/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "question": [448, 560, [10067, 10068, 61736], "3f", ["M0 224a224 224 0 1 0 448 0 224 224 0 1 0 -448 0zm84 0c0-77.3 62.7-140 140-140s140 62.7 140 140c0 72.6-55.3 132.3-126 139.3l0 28.7c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-42c0-7.7 6.3-14 14-14 61.9 0 112-50.1 112-112s-50.1-112-112-112-112 50.1-112 112c0 7.7-6.3 14-14 14s-14-6.3-14-14z", "M252 504c0 15.5-12.5 28-28 28s-28-12.5-28-28 12.5-28 28-28 28 12.5 28 28zm28 0c0-30.9-25.1-56-56-56s-56 25.1-56 56 25.1 56 56 56 56-25.1 56-56zM112 224c0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112c-7.7 0-14 6.3-14 14l0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-28.7c70.7-7 126-66.7 126-139.3 0-77.3-62.7-140-140-140S84 146.7 84 224c0 7.7 6.3 14 14 14s14-6.3 14-14z"]],
    "minus": [560, 560, [8211, 8722, 10134, "subtract"], "f068", ["M0 252l0 56c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56L56 196c-30.9 0-56 25.1-56 56zm56 14c0-7.7 6.3-14 14-14l392 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L70 280c-7.7 0-14-6.3-14-14z", "M70 252c-7.7 0-14 6.3-14 14s6.3 14 14 14l392 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L70 252z"]],
    "microphone-slash": [616, 560, [], "f131", ["M168 159.8l0 92.2c0 77.3 62.7 140 140 140 26.4 0 51.1-7.3 72.2-20L168 159.8zm1.2-38.4L402.8 355c27.8-25.6 45.2-62.3 45.2-103l-83 0c-3.7 0-7.3-1.5-9.9-4.1-8.8-8.8-2.6-23.9 9.9-23.9l83 0 0-56-126 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l126 0C448 62.7 385.3 0 308 0 237 0 178.3 52.9 169.2 121.4z", "M18.1 9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l560 560c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L18.1 9.9zm337 238c-8.8-8.8-2.6-23.9 9.9-23.9l83 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-83 0c-3.7 0-7.3-1.5-9.9-4.1zm-243.4-83c.2 1 .4 2.1 .4 3.1l0 84c0 108.2 87.8 196 196 196 22.9 0 44.9-3.9 65.3-11.1 5.5-1.9 11.6-.7 15.7 3.4 7 7 5 18.9-4.4 22.3-19.7 7.2-40.7 11.7-62.6 13l0 56.4 112 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-252 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l112 0 0-56.4C176.8 468.3 84 371 84 252l0-84c0-7.7 6.3-14 14-14 1.1 0 2.1 .1 3.1 .4 2.2 .5 4 1.9 5.5 3.5l1.4 1.4c1.6 1.6 3 3.4 3.5 5.5zM478.1 370.9c-4.8-4.8-5.5-12.4-2-18.2 17.7-29.4 27.8-63.9 27.8-100.7l0-84c0-7.7 6.3-14 14-14s14 6.3 14 14l0 84c0 42.8-12 82.8-32.9 116.9-4.6 7.4-14.8 8.3-21 2.1zM322 140l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "car": [560, 560, [128664, "automobile"], "f1b9", ["M0 286.8L0 392c0 46.4 37.6 84 84 84l392 0c46.4 0 84-37.6 84-84l0-105.2c0-22.3-8.9-43.6-24.6-59.4L504 196 504 112C504 50.1 453.9 0 392 0L168 0C106.1 0 56 50.1 56 112l0 84-31.4 31.4C8.8 243.1 0 264.5 0 286.8zM168 336a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28-224c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 56c0 30.9-25.1 56-56 56l-224 0c-30.9 0-56-25.1-56-56l0-56zm28 0l0 56c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-56c0-15.5-12.5-28-28-28L168 84c-15.5 0-28 12.5-28 28zM504 336a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M168 84c-15.5 0-28 12.5-28 28l0 56c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-56c0-15.5-12.5-28-28-28L168 84zm-56 28c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 56c0 30.9-25.1 56-56 56l-224 0c-30.9 0-56-25.1-56-56l0-56zm28 224a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM84 546l0-70 28 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14zm364 0l0-70 28 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14zm0-182a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm0-84a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "filter": [560, 560, [], "f0b0", ["M0 106.1c0 12.8 4.9 25.1 13.7 34.4L196 332.9 196 308c0-7.7 6.3-14 14-14s14 6.3 14 14l0 54.4 8.7 9.2C245 384.7 262.1 392 280 392s35-7.4 47.3-20.3l8.7-9.2 0-54.4c0-7.7 6.3-14 14-14s14 6.3 14 14l0 24.9 182.3-192.4c8.8-9.3 13.7-21.6 13.7-34.4 0-27.6-22.4-50.1-50.1-50.1L50.1 56C22.4 56 0 78.4 0 106.1z", "M210 294c7.7 0 14 6.3 14 14l0 187.3c0 4.8 3.9 8.7 8.7 8.7 1.3 0 2.7-.3 3.9-.9l91.7-45.9c4.7-2.4 7.7-7.2 7.7-12.5L336 308c0-7.7 6.3-14 14-14s14 6.3 14 14l0 136.7c0 15.9-9 30.5-23.2 37.6L249 528.1c-5.1 2.5-10.7 3.9-16.4 3.9-20.2 0-36.7-16.4-36.7-36.7L196 308c0-7.7 6.3-14 14-14z"]],
    "envelope": [616, 560, [128386, 9993, 61443], "f0e0", ["M28 184.3L243.2 313.4c39.9 23.9 89.8 23.9 129.7 0L588 184.3 588 392c0 61.9-50.1 112-112 112l-336 0C78.1 504 28 453.9 28 392l0-207.7zm.9-30.3c6.9-55.3 54-98 111.1-98l336 0c57.1 0 104.3 42.8 111.1 98-2.2 .1-4.3 .8-6.3 2L358.4 289.4c-31 18.6-69.8 18.6-100.8 0L35.2 156c-2-1.2-4.2-1.8-6.3-2z", "M35.2 156c-6.6-4-15.2-1.8-19.2 4.8S14.2 176 20.8 180L243.2 313.4c39.9 23.9 89.8 23.9 129.7 0L595.2 180c6.6-4 8.8-12.6 4.8-19.2s-12.6-8.8-19.2-4.8L358.4 289.4c-31 18.6-69.8 18.6-100.8 0L35.2 156z"]],
    "at": [616, 560, [61946], "40", ["M56 280c0 139.2 112.8 252 252 252 99.5 0 185.5-57.7 226.5-141.4-5.4 .9-10.9 1.4-16.5 1.4-36.3 0-68-19.7-84.9-49-23 45.7-70.4 77-125.1 77-77.3 0-140-62.7-140-140s62.7-140 140-140c45.8 0 86.5 22 112 56l0-42c0-7.7 6.3-14 14-14s14 6.3 14 14l0 140c0 38.7 31.3 70 70 70 10.7 0 20.8-2.4 29.9-6.7 7.8-24.4 12.1-50.3 12.1-77.3 0-139.2-112.8-252-252-252S56 140.8 56 280zm140 0a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M308-28C137.9-28 0 109.9 0 280 0 287.7 6.3 294 14 294s14-6.3 14-14C28 125.4 153.4 0 308 0S588 125.4 588 280l0 14c0 38.7-31.3 70-70 70s-70-31.3-70-70l0-140c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42c-25.5-34-66.2-56-112-56-77.3 0-140 62.7-140 140s62.7 140 140 140c54.7 0 102-31.3 125.1-77 16.9 29.3 48.6 49 84.9 49 54.1 0 98-43.9 98-98l0-14C616 109.9 478.1-28 308-28zM196 280a112 112 0 1 1 224 0 112 112 0 1 1 -224 0z"]],
    "truck": [616, 560, [128666, 9951], "f0d1", ["M28 112l0 252c0 42 23.1 78.5 57.2 97.7 6.8-39.6 41.3-69.7 82.8-69.7 46.4 0 84 37.6 84 84l112 0c0-46.4 37.6-84 84-84 41.5 0 76 30.1 82.8 69.7 34.1-19.2 57.2-55.8 57.2-97.7l0-70-126 0c-30.9 0-56-25.1-56-56l0-126c0-7.4 5.8-13.5 13.1-14.1-6.9-55.2-54-97.9-111.1-97.9L140 0C78.1 0 28 50.1 28 112zm84.1 360.5c8.9 2.3 18.3 3.5 27.9 3.5l84 0c0-30.9-25.1-56-56-56-29.8 0-54.1 23.2-55.9 52.5zM392 476l84 0c9.6 0 19-1.2 27.9-3.5-1.8-29.3-26.1-52.5-55.9-52.5-30.9 0-56 25.1-56 56zm42-364l0 126c0 15.5 12.5 28 28 28l126 0 0-28c0-69.6-56.4-126-126-126l-28 0z", "M434 112c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 126c0 30.9 25.1 56 56 56l126 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-126 0c-15.5 0-28-12.5-28-28l0-126zM168 420a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 140a84 84 0 1 0 0-168 84 84 0 1 0 0 168zM448 420a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 140a84 84 0 1 0 0-168 84 84 0 1 0 0 168z"]],
    "frame": [560, 560, [], "e495", ["M56 168l0 224c0 9.7 1.2 19.1 3.5 28l52.5 0 0-280-52.5 0c-2.3 8.9-3.5 18.3-3.5 28zm15-56l41 0 0-41c-17 9.8-31.2 24-41 41zm0 336c9.8 17 24 31.2 41 41l0-41-41 0zM140 59.5l0 52.5 280 0 0-52.5c-8.9-2.3-18.3-3.5-28-3.5L168 56c-9.7 0-19.1 1.2-28 3.5zm0 80.5l0 280 280 0 0-280-280 0zm0 308l0 52.5c8.9 2.3 18.3 3.5 28 3.5l224 0c9.7 0 19.1-1.2 28-3.5l0-52.5-280 0zM448 71l0 41 41 0c-9.8-17-24-31.2-41-41zm0 69l0 280 52.5 0c2.3-8.9 3.5-18.3 3.5-28l0-224c0-9.7-1.2-19.1-3.5-28L448 140zm0 308l0 41c17-9.8 31.2-24 41-41l-41 0z", "M448 0c0-7.7-6.3-14-14-14S420-7.7 420 0l0 112-280 0 0-98c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 98-98 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l98 0 0 280-98 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l98 0 0 98c0 7.7 6.3 14 14 14s14-6.3 14-14l0-98 280 0 0 84c0 7.7 6.3 14 14 14s14-6.3 14-14l0-84 98 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-98 0 0-280 98 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-98 0 0-112zM420 420l-280 0 0-280 280 0 0 280z"]],
    "bell": [560, 560, [128276, 61602], "f0f3", ["M0 406.5C0 429.4 18.6 448 41.5 448l477.1 0c22.9 0 41.5-18.6 41.5-41.5 0-9.4-3.2-18.5-9.1-25.9L460.3 267.3c-7.9-9.9-12.3-22.3-12.3-35l0-64.4C448 75.2 372.8 0 280 0S112 75.2 112 168l0 64.4c0 12.7-4.3 25.1-12.3 35L9.1 380.6C3.2 388 0 397.1 0 406.5zM168 154c0-54.1 43.9-98 98-98 7.7 0 14 6.3 14 14s-6.3 14-14 14c-38.7 0-70 31.3-70 70 0 7.7-6.3 14-14 14s-14-6.3-14-14z", "M196 154c0-38.7 31.3-70 70-70 7.7 0 14-6.3 14-14s-6.3-14-14-14c-54.1 0-98 43.9-98 98 0 7.7 6.3 14 14 14s14-6.3 14-14zM367.6 494.7c2.6-7.3-1.2-15.3-8.5-17.9s-15.3 1.2-17.9 8.5c-9.6 27.2-35.6 46.7-66 46.7s-56.4-19.5-66-46.7c-2.6-7.3-10.6-11.1-17.9-8.5s-11.1 10.6-8.5 17.9c13.4 38 49.7 65.3 92.4 65.3s79-27.3 92.4-65.3z"]],
    "mobile": [448, 560, [128241, "mobile-android", "mobile-phone"], "f3ce", ["M0 112L0 448c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-336C448 50.1 397.9 0 336 0L112 0C50.1 0 0 50.1 0 112zm56 0c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 336c0 30.9-25.1 56-56 56l-224 0c-30.9 0-56-25.1-56-56l0-336zm28 0l0 336c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-336c0-15.5-12.5-28-28-28L112 84c-15.5 0-28 12.5-28 28z", "M364 448c0 15.5-12.5 28-28 28l-224 0c-15.5 0-28-12.5-28-28l0-336c0-15.5 12.5-28 28-28l224 0c15.5 0 28 12.5 28 28l0 336zm28-336c0-30.9-25.1-56-56-56L112 56c-30.9 0-56 25.1-56 56l0 336c0 30.9 25.1 56 56 56l224 0c30.9 0 56-25.1 56-56l0-336z"]],
    "trophy": [560, 560, [127942], "f091", ["M84 112l14 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-9.2 0c11.5-32.6 42.6-56 79.2-56l224 0c36.6 0 67.7 23.4 79.2 56L462 84c-7.7 0-14 6.3-14 14s6.3 14 14 14l14 0 0 140c0 19.5-2.8 38.3-8.1 56L448 308c-7.7 0-14 6.3-14 14s6.3 14 14 14l9.1 0c-29.6 62.2-91 106.4-163.1 111.5l0-13.5c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 13.5c-72.2-5.1-133.6-49.3-163.1-111.5l9.1 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-19.9 0c-5.3-17.7-8.1-36.5-8.1-56l0-140z", "M126 322c0-7.7-6.3-14-14-14l-35 0c-27.1 0-49-21.9-49-49l0-105c0-23.2 18.8-42 42-42l28 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L70 84C31.3 84 0 115.3 0 154L0 259c0 42.5 34.5 77 77 77l35 0c7.7 0 14-6.3 14-14zm154 98c-7.7 0-14 6.3-14 14l0 70-84 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-84 0 0-70c0-7.7-6.3-14-14-14zM448 308c-7.7 0-14 6.3-14 14s6.3 14 14 14l42 0c38.7 0 70-31.3 70-70l0-112c0-38.7-31.3-70-70-70l-28 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l28 0c23.2 0 42 18.8 42 42l0 112c0 23.2-18.8 42-42 42l-42 0z"]],
    "gift": [504, 560, [127873], "f06b", ["M0 252c0-59.6 46.5-108.3 105.2-111.8 12.8 16.9 33 27.8 55.8 27.8l68.3 0-45.9 91.7c-3.5 6.9-.7 15.3 6.3 18.8s15.3 .7 18.8-6.3l43.5-87 43.5 87c3.5 6.9 11.9 9.7 18.8 6.3s9.7-11.9 6.3-18.8L274.7 168 343 168c22.8 0 43.1-10.9 55.8-27.8 58.7 3.5 105.2 52.2 105.2 111.8l0 168c0 61.9-50.1 112-112 112l-280 0C50.1 532 0 481.9 0 420L0 252z", "M199 79.4c-7.1-14.3-21.8-23.4-37.9-23.4-23.2 0-42.1 18.9-42.1 42 0 23.2 18.8 42 42 42l68.3 0-30.3-60.6zm53 106l-43.5 87c-3.5 6.9-11.9 9.7-18.8 6.3s-9.7-11.9-6.3-18.8l45.9-91.7-68.3 0c-38.7 0-70-31.3-70-70 0-38.7 31.5-70 70.1-70 26.6 0 51 15 62.9 38.8l27.9 55.9 27.9-55.9c11.9-23.8 36.3-38.8 62.9-38.8 38.6 0 70.1 31.3 70.1 70 0 38.7-31.3 70-70 70l-68.3 0 45.9 91.7c3.5 6.9 .7 15.3-6.3 18.8s-15.3 .7-18.8-6.3l-43.5-87zM280 140l63 0c23.2 0 42-18.8 42-42 0-23.1-18.9-42-42.1-42-16 0-30.7 9.1-37.9 23.4l-30.3 60.6 5.3 0z"]],
    "gauge": [560, 560, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm105 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm56-140a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm49 266c0-38.7 31.3-70 70-70 1 0 1.9 0 2.9 .1l39.5-171.2c1.7-7.5 9.3-12.2 16.8-10.5s12.2 9.3 10.5 16.8L310 342.8c23.6 11.2 40 35.3 40 63.2 0 38.7-31.3 70-70 70s-70-31.3-70-70zm28 0a42 42 0 1 0 84 0 42 42 0 1 0 -84 0zM301 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm140 56a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm56 140a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M301 84a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zM280 364a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm0 112c38.7 0 70-31.3 70-70 0-27.9-16.3-52-40-63.2l39.6-171.6c1.7-7.5-3-15.1-10.5-16.8s-15.1 3-16.8 10.5L282.9 336.1c-.9 0-1.9-.1-2.9-.1-38.7 0-70 31.3-70 70s31.3 70 70 70zM420 161a21 21 0 1 0 0-42 21 21 0 1 0 0 42zM140 119a21 21 0 1 0 0 42 21 21 0 1 0 0-42zM105 280a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm371-21a21 21 0 1 0 0 42 21 21 0 1 0 0-42z"]],
    "signal": [616, 560, [128246, "signal-5", "signal-perfect"], "f012", ["M0 392L0 504c0 30.9 25.1 56 56 56s56-25.1 56-56l0-112c0-30.9-25.1-56-56-56S0 361.1 0 392zm42 56c0-7.7 6.3-14 14-14s14 6.3 14 14l0 56c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-56zM168 280l0 224c0 30.9 25.1 56 56 56s56-25.1 56-56l0-224c0-30.9-25.1-56-56-56s-56 25.1-56 56zm42 84c0-7.7 6.3-14 14-14s14 6.3 14 14l0 140c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-140zM336 168l0 336c0 30.9 25.1 56 56 56s56-25.1 56-56l0-336c0-30.9-25.1-56-56-56s-56 25.1-56 56zm42 140c0-7.7 6.3-14 14-14s14 6.3 14 14l0 196c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-196zM504 56l0 448c0 30.9 25.1 56 56 56s56-25.1 56-56l0-448c0-30.9-25.1-56-56-56s-56 25.1-56 56zm42 196c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-252z", "M574 252c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 252c0 7.7 6.3 14 14 14s14-6.3 14-14l0-252zM238 364c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 140c0 7.7 6.3 14 14 14s14-6.3 14-14l0-140zm154-70c-7.7 0-14 6.3-14 14l0 196c0 7.7 6.3 14 14 14s14-6.3 14-14l0-196c0-7.7-6.3-14-14-14zM70 448c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 56c0 7.7 6.3 14 14 14s14-6.3 14-14l0-56z"]],
    "share-nodes": [504, 560, ["share-alt"], "f1e0", ["M0 280c0 61.9 50.1 112 112 112 35.7 0 67.6-16.7 88.1-42.8L104.8 292c-4.2-2.5-6.8-7.1-6.8-12s2.6-9.5 6.8-12l95.3-57.2C179.6 184.7 147.7 168 112 168 50.1 168 0 218.1 0 280zm139.2 0l75.3 45.2c6.1-13.8 9.5-29.1 9.5-45.2s-3.4-31.4-9.5-45.2L139.2 280zM280 112c0 16.1 3.4 31.4 9.5 45.2L384.8 100c6.6-4 15.2-1.8 19.2 4.8s1.8 15.2-4.8 19.2l-95.3 57.2c20.5 26.1 52.3 42.8 88.1 42.8 61.9 0 112-50.1 112-112S453.9 0 392 0 280 50.1 280 112zm0 336c0 61.9 50.1 112 112 112s112-50.1 112-112-50.1-112-112-112c-35.7 0-67.6 16.7-88.1 42.8L399.2 436c6.6 4 8.8 12.6 4.8 19.2s-12.6 8.8-19.2 4.8l-95.3-57.2c-6.1 13.8-9.5 29.1-9.5 45.2z", "M404 104.8c4 6.6 1.8 15.2-4.8 19.2l-260 156 260 156c6.6 4 8.8 12.6 4.8 19.2s-12.6 8.8-19.2 4.8l-280-168c-4.2-2.5-6.8-7.1-6.8-12s2.6-9.5 6.8-12l280-168c6.6-4 15.2-1.8 19.2 4.8z"]],
    "percent": [504, 560, [62101, 62785, "percentage"], "25", ["M0 140a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zM280 420a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M413.6 30.2c6.5 4.2 8.3 12.9 4.1 19.4l-308 476c-4.2 6.5-12.9 8.3-19.4 4.1s-8.3-12.9-4.1-19.4l308-476c4.2-6.5 12.9-8.3 19.4-4.1z"]],
    "magnifying-glass": [560, 560, [128269, "search"], "f002", ["M0 252c0 139.2 112.8 252 252 252 64.6 0 123.4-24.3 168-64.2l-39.7-39.7C346 430 301.1 448 252 448 143.8 448 56 360.2 56 252S143.8 56 252 56 448 143.8 448 252c0 49.1-18 94-47.9 128.3L439.8 420C479.7 375.4 504 316.5 504 252 504 112.8 391.2 0 252 0S0 112.8 0 252zm84 0a168 168 0 1 0 336 0 168 168 0 1 0 -336 0z", "M420 252a168 168 0 1 0 -336 0 168 168 0 1 0 336 0zM380.3 400.1C346 430 301.1 448 252 448 143.8 448 56 360.2 56 252S143.8 56 252 56 448 143.8 448 252c0 49.1-18 94-47.9 128.3L555.9 536.1c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L380.3 400.1z"]],
    "palette": [560, 560, [127912], "f53f", ["M0 280c0 155.3 124.7 280 278.9 280 39.8 0 70-25.4 70-67.8 0-16-6.3-30.7-12.6-45.3-4.7-10.9-9.4-21.9-11.5-33.4-10.4-31.3 21.3-63.4 51.4-63.4l106.1 0C522.7 350 560 322.4 560 280 560 125.8 434.2 0 280 0 124.7 0 0 125.8 0 280zm168 56a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm28-168a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM84 336a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28-168a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm252-56a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zM504 224a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M336 112a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zM308 56a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM476 224a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm-28-56a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM140 196a28 28 0 1 1 0-56 28 28 0 1 1 0 56zM84 168a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56 168a28 28 0 1 1 -56 0 28 28 0 1 1 56 0zm-28-56a56 56 0 1 0 0 112 56 56 0 1 0 0-112z"]],
    "key": [504, 560, [128273], "f084", ["M112 196c0 49.1 18 94 47.9 128.3l12.2-12.2c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8l-12.2 12.2C214 374 258.9 392 308 392 416.2 392 504 304.2 504 196S416.2 0 308 0 112 87.8 112 196zm308 0a112 112 0 1 1 -224 0 112 112 0 1 1 224 0zm-196 0a84 84 0 1 0 168 0 84 84 0 1 0 -168 0z", "M224 196a84 84 0 1 1 168 0 84 84 0 1 1 -168 0zm196 0a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM191.9 331.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-168 168c-5.5 5.5-5.5 14.3 0 19.8l56 56c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8L33.8 490 84 439.8 130.1 485.9c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-46.1-46.1 88.1-88.1z"]],
    "skull": [560, 560, [128128], "f54c", ["M0 252c0 72.4 33.9 137.7 88.3 183.7 14.2 12 23.7 29.1 23.7 47.7l0 34.6c0 23.2 18.8 42 42 42l28 0 0-42c0-7.7 6.3-14 14-14s14 6.3 14 14l0 42 56 0 0-42c0-7.7 6.3-14 14-14s14 6.3 14 14l0 42 56 0 0-42c0-7.7 6.3-14 14-14s14 6.3 14 14l0 42 28 0c23.2 0 42-18.8 42-42l0-34.6c0-18.6 9.5-35.7 23.7-47.7 54.4-46 88.3-111.3 88.3-183.7 0-139.2-125.4-252-280-252S0 112.8 0 252zm252 28a84 84 0 1 1 -168 0 84 84 0 1 1 168 0zm-140 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm364 0a84 84 0 1 1 -168 0 84 84 0 1 1 168 0zm-140 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0z", "M168 224a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 140a84 84 0 1 0 0-168 84 84 0 1 0 0 168zM392 224a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm0 140a84 84 0 1 0 0-168 84 84 0 1 0 0 168zM210 518c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42zm70-14c-7.7 0-14 6.3-14 14l0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42c0-7.7-6.3-14-14-14zm70 14l0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42c0-7.7-6.3-14-14-14s-14 6.3-14 14z"]],
    "tree": [504, 560, [127794], "f1bb", ["M0 442.7C0 476.5 27.5 504 61.3 504l177 0 0-189.9-66.2-66.2c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l46.4 46.4 0-148.5c0-7.5 6.1-13.7 13.7-13.7s13.7 6.1 13.7 13.7l0 267 76.2-54.4c6.3-4.5 15-3 19.5 3.3s3 15-3.3 19.5l-92.5 66.1 0 76.6 177 0c33.9 0 61.3-27.5 61.3-61.3 0-14.6-5.2-28.8-14.8-39.9L384 280 386.7 280c33.9 0 61.3-27.5 61.3-61.3 0-14.6-5.2-28.8-14.8-39.9L298.3 21.3C286.7 7.8 269.7 0 251.9 0 234.2 0 217.3 7.7 205.7 21.1L69.5 178.8c-9.6 11.1-14.9 25.3-14.9 40 0 33.8 27.4 61.2 61.2 61.2l4.2 0-105.2 122.8C5.2 413.9 0 428 0 442.7z", "M265.7 126c0-7.5-6.1-13.7-13.7-13.7s-13.7 6.1-13.7 13.7l0 148.5-46.4-46.4c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l66.2 66.2 0 231.9c0 7.5 6.1 13.7 13.7 13.7s13.7-6.1 13.7-13.7l0-118.6 92.5-66.1c6.3-4.5 7.8-13.2 3.3-19.5s-13.2-7.8-19.5-3.3l-76.2 54.4 0-267z"]],
    "flower": [560, 560, [127804, 10047], "f7ff", ["M0 280c0 53.7 37.8 98.6 88.2 109.5-2.7 9.7-4.2 19.9-4.2 30.5 0 61.9 50.1 112 112 112 33.5 0 63.5-14.7 84-37.9 20.5 23.3 50.5 37.9 84 37.9 61.9 0 112-50.1 112-112 0-10.6-1.5-20.8-4.2-30.5 50.4-10.9 88.2-55.8 88.2-109.5s-37.8-98.6-88.2-109.5c2.7-9.7 4.2-19.9 4.2-30.5 0-61.9-50.1-112-112-112-33.5 0-63.5 14.7-84 37.9-20.5-23.3-50.5-37.9-84-37.9-61.9 0-112 50.1-112 112 0 10.6 1.5 20.8 4.2 30.5-50.4 10.9-88.2 55.8-88.2 109.5zm420 0a140 140 0 1 1 -280 0 140 140 0 1 1 280 0zm-252 0a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M280 168a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 252a140 140 0 1 0 0-280 140 140 0 1 0 0 280z"]],
    "camera": [560, 560, [62258, "camera-alt"], "f030", ["M0 163.2L0 392c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-228.8c0-43.7-35.5-79.2-79.2-79.2-21 0-41.1-8.3-56-23.2l-28-28C375.8 11.8 347.3 0 317.6 0L242.4 0c-29.7 0-58.2 11.8-79.2 32.8l-28 28C120.3 75.7 100.2 84 79.2 84 35.5 84 0 119.5 0 163.2zM420 280a140 140 0 1 1 -280 0 140 140 0 1 1 280 0zm-252 0a112 112 0 1 0 224 0 112 112 0 1 0 -224 0z", "M280 168a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 252a140 140 0 1 0 0-280 140 140 0 1 0 0 280z"]],
    "eye": [616, 560, [128065], "f06e", ["M28 280c0-9.4 .7-18.9 2.2-28.2 5.7-.9 10.5-5.3 11.6-11.2 13.3-71 85.2-212.6 266.2-212.6S560.9 169.6 574.2 240.6c1.1 6 5.9 10.4 11.6 11.2 1.4 9.3 2.2 18.7 2.2 28.2 0 18.6-2.8 37-8.4 54.7l-1.6 5.2C542.3 454.2 436.5 532 316.7 532l-17.5 0C179.5 532 73.7 454.2 38 339.9l-1.6-5.2C30.8 317 28 298.6 28 280zm168 0a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm196 0a84 84 0 1 1 -168 0 84 84 0 1 1 168 0z", "M41.8 240.6C55.1 169.6 127 28 308 28S560.9 169.6 574.2 240.6c1.4 7.6 8.7 12.6 16.3 11.2s12.6-8.7 11.2-16.3C587.1 157.1 507.8 0 308 0S28.9 157.1 14.2 235.4c-1.4 7.6 3.6 14.9 11.2 16.3s14.9-3.6 16.3-11.2zM224 280a84 84 0 1 1 168 0 84 84 0 1 1 -168 0zm196 0a112 112 0 1 0 -224 0 112 112 0 1 0 224 0z"]],
    "trash": [448, 560, [], "f1f8", ["M28 112l392 0 0 336c0 61.9-50.1 112-112 112l-168 0C78.1 560 28 509.9 28 448l0-336zm112 98l0 224c0 7.7 6.3 14 14 14s14-6.3 14-14l0-224c0-7.7-6.3-14-14-14s-14 6.3-14 14zm140 0l0 224c0 7.7 6.3 14 14 14s14-6.3 14-14l0-224c0-7.7-6.3-14-14-14s-14 6.3-14 14z", "M168 0c-30.9 0-56 25.1-56 56l0 28-98 0C6.3 84 0 90.3 0 98s6.3 14 14 14l420 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-98 0 0-28c0-30.9-25.1-56-56-56L168 0zM308 84l-168 0 0-28c0-15.5 12.5-28 28-28l112 0c15.5 0 28 12.5 28 28l0 28zM168 210c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 224c0 7.7 6.3 14 14 14s14-6.3 14-14l0-224zm140 0c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 224c0 7.7 6.3 14 14 14s14-6.3 14-14l0-224z"]],
    "equals": [560, 560, [62764], "3d", ["M0 140l0 56c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56L56 84C25.1 84 0 109.1 0 140zM0 364l0 56c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56L56 308c-30.9 0-56 25.1-56 56zM56 154c0-7.7 6.3-14 14-14l336 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L70 168c-7.7 0-14-6.3-14-14zm0 224c0-7.7 6.3-14 14-14l336 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L70 392c-7.7 0-14-6.3-14-14z", "M70 140c-7.7 0-14 6.3-14 14s6.3 14 14 14l336 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L70 140zm0 224c-7.7 0-14 6.3-14 14s6.3 14 14 14l336 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L70 364z"]],
    "expand": [504, 560, [], "f065", ["M84 196l0 168c0 46.4 37.6 84 84 84l168 0c46.4 0 84-37.6 84-84l0-168c0-46.4-37.6-84-84-84l-168 0c-46.4 0-84 37.6-84 84z", "M14 224c7.7 0 14-6.3 14-14l0-154 154 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L28 28C12.5 28 0 40.5 0 56L0 210c0 7.7 6.3 14 14 14zM28 350c0-7.7-6.3-14-14-14S0 342.3 0 350L0 504c0 15.5 12.5 28 28 28l154 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-154 0 0-154zm448 0l0 154-154 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l154 0c15.5 0 28-12.5 28-28l0-154c0-7.7-6.3-14-14-14s-14 6.3-14 14zm0-140c0 7.7 6.3 14 14 14s14-6.3 14-14l0-154c0-15.5-12.5-28-28-28L322 28c-7.7 0-14 6.3-14 14s6.3 14 14 14l154 0 0 154z"]],
    "stop": [448, 560, [9209], "f04d", ["M0 168L0 392c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L112 56C50.1 56 0 106.1 0 168zm56 0c0-30.9 25.1-56 56-56l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0c-15.5 0-28 12.5-28 28l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126z", "M112 140c-15.5 0-28 12.5-28 28l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-30.9 25.1-56 56-56l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0z"]],
    "tv-retro": [560, 560, [128250], "f401", ["M0 196L0 420c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112l-121.8 0-22.9 15.3c-14.1 9.4-32.5 9.4-46.6 0L233.8 84 112 84C50.1 84 0 134.1 0 196zm84 28c0-30.9 25.1-56 56-56l168 0c30.9 0 56 25.1 56 56l0 168c0 30.9-25.1 56-56 56l-168 0c-30.9 0-56-25.1-56-56l0-168zm28 0l0 168c0 15.5 12.5 28 28 28l168 0c15.5 0 28-12.5 28-28l0-168c0-15.5-12.5-28-28-28l-168 0c-15.5 0-28 12.5-28 28zm392 14a42 42 0 1 1 -84 0 42 42 0 1 1 84 0zm0 140a42 42 0 1 1 -84 0 42 42 0 1 1 84 0z", "M272.2 76L161.8 2.4c-6.4-4.3-15.1-2.6-19.4 3.9s-2.6 15.1 3.9 19.4L256.7 99.3c14.1 9.4 32.5 9.4 46.6 0L413.8 25.6c6.4-4.3 8.2-13 3.9-19.4s-13-8.2-19.4-3.9L287.8 76c-4.7 3.1-10.8 3.1-15.5 0zM308 196c15.5 0 28 12.5 28 28l0 168c0 15.5-12.5 28-28 28l-168 0c-15.5 0-28-12.5-28-28l0-168c0-15.5 12.5-28 28-28l168 0zM140 168c-30.9 0-56 25.1-56 56l0 168c0 30.9 25.1 56 56 56l168 0c30.9 0 56-25.1 56-56l0-168c0-30.9-25.1-56-56-56l-168 0zm336 70a14 14 0 1 1 -28 0 14 14 0 1 1 28 0zm-14-42a42 42 0 1 0 0 84 42 42 0 1 0 0-84zm14 182a14 14 0 1 1 -28 0 14 14 0 1 1 28 0zm-14-42a42 42 0 1 0 0 84 42 42 0 1 0 0-84z"]],
    "angle-left": [448, 560, [8249], "f104", ["M0 280c0 17.6 8.3 34.2 22.4 44.8L324.8 551.6c7.3 5.5 16.1 8.4 25.2 8.4 23.2 0 42-18.8 42-42l0-70c-2.9 0-5.8-.9-8.3-2.7l-210-154c-3.6-2.6-5.7-6.8-5.7-11.3s2.1-8.7 5.7-11.3l210-154c2.5-1.8 5.4-2.7 8.3-2.7l0-70c0-23.2-18.8-42-42-42-9.1 0-17.9 2.9-25.2 8.4L22.4 235.2C8.3 245.8 0 262.4 0 280zm205.7 0L392 416.6 392 143.4 205.7 280z", "M403.3 442.3c4.6-6.2 3.2-15-3-19.6L205.7 280 400.3 137.3c6.2-4.6 7.6-13.3 3-19.6s-13.3-7.6-19.6-3l-210 154c-3.6 2.6-5.7 6.8-5.7 11.3s2.1 8.7 5.7 11.3l210 154c6.2 4.6 15 3.2 19.6-3z"]],
    "circle-half-stroke": [560, 560, [9680, "adjust"], "f042", ["M0 280c0 140.4 103.4 256.7 238.1 276.9 22.9 3.4 41.9-15.7 41.9-38.9l0-14.9c-7.2 0-13.1-5.9-13.1-13.1s5.9-13.1 13.1-13.1l0-393.7c-108.7 0-196.9 88.1-196.9 196.9 0 7.2-5.9 13.1-13.1 13.1S56.9 287.2 56.9 280C56.9 156.8 156.8 56.9 280 56.9L280 42C280 18.8 261.1-.3 238.1 3.1 103.4 23.3 0 139.6 0 280z", "M83.1 280C83.1 171.3 171.3 83.1 280 83.1S476.9 171.3 476.9 280 388.7 476.9 280 476.9c-7.2 0-13.1 5.9-13.1 13.1s5.9 13.1 13.1 13.1c123.2 0 223.1-99.9 223.1-223.1S403.2 56.9 280 56.9 56.9 156.8 56.9 280c0 7.2 5.9 13.1 13.1 13.1s13.1-5.9 13.1-13.1z"]],
    "clock": [560, 560, [128339, "clock-four"], "f017", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zM280 98c0-7.7 6.3-14 14-14s14 6.3 14 14l0 154 154 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-168 0c-7.7 0-14-6.3-14-14l0-168z", "M294 84c7.7 0 14 6.3 14 14l0 154 154 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-168 0c-7.7 0-14-6.3-14-14l0-168c0-7.7 6.3-14 14-14z"]],
    "book": [448, 560, [128212], "f02d", ["M0 112L0 448c0 52.2 35.7 96 84 108.5L84 3.5C35.7 16 0 59.8 0 112zM112 0l0 560 224 0c61.9 0 112-50.1 112-112l0-336C448 50.1 397.9 0 336 0L112 0zm56 238c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zm0 112c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14z", "M84 560c0 7.7 6.3 14 14 14s14-6.3 14-14L112 0c0-7.7-6.3-14-14-14S84-7.7 84 0l0 560zm98-336c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0zm0 112c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0z"]],
    "paper-plane": [560, 560, [61913], "f1d8", ["M0 44.9l0 2.2C0 53 1.1 58.8 3.2 64.3L82.1 266.1c.6-.1 1.3-.1 1.9-.1l350 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L84 294c-.7 0-1.3 0-1.9-.1L3.2 495.7C1.1 501.2 0 507 0 512.9l0 2.2c0 24.8 20.1 44.9 44.9 44.9 7.3 0 14.4-1.8 20.9-5.1L546.2 302.8c8.5-4.4 13.8-13.2 13.8-22.8s-5.3-18.3-13.8-22.8L65.8 5.1C59.4 1.8 52.2 0 44.9 0 20.1 0 0 20.1 0 44.9z", "M70 280c0-7.7 6.3-14 14-14l350 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L84 294c-7.7 0-14-6.3-14-14z"]],
    "heart": [560, 560, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", ["M0 206.4l0 6.3c0 43 17.6 84 48.8 113.6l183 173.9c27 25.7 69.4 25.7 96.4 0l183-173.9c31.1-29.6 48.8-70.7 48.8-113.6l0-6.3c0-83.1-67.4-150.4-150.4-150.4-29.7 0-58.7 8.8-83.5 25.3l-42.2 28.1c-2.4 1.6-5.4 1.6-7.8 0L233.9 81.3C209.2 64.8 180.2 56 150.4 56 67.4 56 0 123.4 0 206.4zm56 0c0-52.2 42.3-94.4 94.4-94.4 18.6 0 36.9 5.5 52.4 15.9 6.4 4.3 8.2 13 3.9 19.4s-13 8.2-19.4 3.9c-10.9-7.3-23.7-11.2-36.9-11.2-36.7 0-66.4 29.7-66.4 66.4l0 6.3c0 19.9 8.2 39 22.6 52.7 5.6 5.3 5.8 14.2 .5 19.8s-14.2 5.8-19.8 .5c-20-19-31.3-45.4-31.3-73l0-6.3z", "M150.4 140C113.7 140 84 169.7 84 206.4l0 6.3c0 19.9 8.2 39 22.6 52.7 5.6 5.3 5.8 14.2 .5 19.8s-14.2 5.8-19.8 .5c-20-19-31.3-45.4-31.3-73l0-6.3c0-52.2 42.3-94.4 94.4-94.4 18.6 0 36.9 5.5 52.4 15.9 6.4 4.3 8.2 13 3.9 19.4s-13 8.2-19.4 3.9c-10.9-7.3-23.7-11.2-36.9-11.2z"]],
    "font-awesome": [560, 560, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M84 110.2c14.7-3.8 27.1-13.4 34.5-26.2l347.7 0c20.9 0 37.8 16.9 37.8 37.8 0 11.5-5.2 22.4-14.2 29.5l-71.1 56.9c-28 22.4-28 65 0 87.5l71.1 56.9c9 7.2 14.2 18 14.2 29.5 0 20.9-16.9 37.8-37.8 37.8L84 420 84 110.2z", "M42 56a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm42 54.2c24.2-6.2 42-28.1 42-54.2 0-30.9-25.1-56-56-56S14 25.1 14 56c0 26.1 17.8 48 42 54.2L56 546c0 7.7 6.3 14 14 14s14-6.3 14-14l0-435.8z"]],
    "clone": [560, 560, [], "f24d", ["M0 280L0 448c0 61.9 50.1 112 112 112l168 0c61.9 0 112-50.1 112-112l0-56-112 0c-61.9 0-112-50.1-112-112l0-112-56 0C50.1 168 0 218.1 0 280zM196 168l0 112c0 46.4 37.6 84 84 84l112 0 0-84c0-61.9-50.1-112-112-112l-84 0z", "M280 364c-46.4 0-84-37.6-84-84l0-168c0-46.4 37.6-84 84-84l168 0c46.4 0 84 37.6 84 84l0 168c0 46.4-37.6 84-84 84l-168 0zM560 112C560 50.1 509.9 0 448 0L280 0C218.1 0 168 50.1 168 112l0 168c0 61.9 50.1 112 112 112l168 0c61.9 0 112-50.1 112-112l0-168z"]],
    "forward": [504, 560, [9193], "f04e", ["M196 97.7l0 45.4 117.9 91.7C327.8 245.7 336 262.3 336 280s-8.2 34.3-22.1 45.2l-117.9 91.7 0 45.4c0 23 18.7 41.7 41.7 41.7 9.3 0 18.3-3.1 25.6-8.8l218.6-170C495.8 314.3 504 297.7 504 280s-8.2-34.3-22.1-45.2L263.3 64.8C256 59.1 247 56 237.7 56 214.7 56 196 74.7 196 97.7zm0 80.9l0 202.8 100.7-78.3C303.8 297.5 308 289 308 280s-4.2-17.5-11.3-23.1L196 178.6z", "M56 97.7c0-7.6 6.1-13.7 13.7-13.7 3 0 6 1 8.4 2.9l218.6 170C303.8 262.5 308 271 308 280s-4.2 17.5-11.3 23.1L78.1 473.1c-2.4 1.9-5.4 2.9-8.4 2.9-7.6 0-13.7-6.1-13.7-13.7L56 97.7zm-28 0l0 364.6c0 23 18.7 41.7 41.7 41.7 9.3 0 18.3-3.1 25.6-8.8l218.6-170C327.8 314.3 336 297.7 336 280s-8.2-34.3-22.1-45.2L95.3 64.8C88 59.1 79 56 69.7 56 46.7 56 28 74.7 28 97.7z"]],
    "triangle": [560, 560, [9650], "f2ec", ["M0 449.5C0 479.6 24.4 504 54.5 504l451.1 0c30.1 0 54.5-24.4 54.5-54.5 0-10.2-2.8-20.1-8.2-28.7l-229-369C313.6 37 297.4 28 280 28s-33.6 9-42.8 23.8l-229 369C2.8 429.4 0 439.4 0 449.5zm70.5-22.9L268.1 108.2c4.1-6.6 12.7-8.6 19.3-4.5s8.6 12.7 4.5 19.3L94.3 441.4C90.2 448 81.6 450 75 445.9s-8.6-12.7-4.5-19.3z", "M287.4 103.7c6.6 4.1 8.6 12.7 4.5 19.3L94.3 441.4C90.2 448 81.6 450 75 445.9s-8.6-12.7-4.5-19.3L268.1 108.2c4.1-6.6 12.7-8.6 19.3-4.5z"]],
    "star-half": [616, 560, [61731], "f089", ["M13.7 241L120.9 347.7c2.1 2.1 3.1 5.2 2.7 8.2L100.2 505.2c-5.8 37.1 32.7 65.3 66.3 48.5l137.3-68.6c1.3-.7 2.8-1 4.2-1l0-503c0-4.3-3.5-7.8-7.7-7.1-13.5 2.2-26.1 10.3-33.3 24.3L196.7 133.5c-1.4 2.7-3.9 4.5-6.9 5L39 162.6c-37.3 6-52.1 51.7-25.3 78.4zm57-28.3c1.6-5 5.9-8.7 11.1-9.5l106-17c20.3-3.2 37.8-15.9 47.2-34.1 3.6-6.9 12-9.5 18.9-6s9.5 12 6 18.9c-13.6 26.1-38.6 44.2-67.7 48.8l-78.8 12.6 55.6 55.3c21.1 21 30.8 50.8 26.2 80.1-1.2 7.6-8.4 12.9-16 11.7s-12.9-8.4-11.7-16c3.2-20.5-3.6-41.3-18.3-55.9L74.1 226.9c-3.7-3.7-5.1-9.2-3.4-14.2z", "M253.9 146.2c6.9 3.6 9.5 12 6 18.9-13.6 26.1-38.6 44.2-67.7 48.8l-78.8 12.6 55.6 55.3c21.1 21 30.8 50.8 26.2 80.1-1.2 7.6-8.4 12.9-16 11.7s-12.9-8.4-11.7-16c3.2-20.5-3.6-41.3-18.3-55.9L74.1 226.9c-3.7-3.7-5.1-9.2-3.4-14.2s5.9-8.7 11.1-9.5l106-17c20.3-3.2 37.8-15.9 47.2-34.1 3.6-6.9 12-9.5 18.9-6z"]],
    "arrow-down-to-line": [560, 560, ["arrow-to-bottom"], "f33d", ["M0 448l0 56c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56l-96.4 0-118.2 108.3c-5.4 4.9-13.6 4.9-18.9 0L152.4 392 56 392c-30.9 0-56 25.1-56 56zm193.8-56l72.2 66.2 0-66.2-72.2 0zM294 392l0 66.2 72.2-66.2-72.2 0z", "M101.7 326.5c5.2-5.7 14.1-6.1 19.8-.9L266 458.2 266 42c0-7.7 6.3-14 14-14s14 6.3 14 14l0 416.2 144.5-132.5c5.7-5.2 14.6-4.8 19.8 .9s4.8 14.6-.9 19.8l-168 154c-5.4 4.9-13.6 4.9-18.9 0l-168-154c-5.7-5.2-6.1-14.1-.9-19.8z"]],
    "fire": [504, 560, [128293], "f06d", ["M0 308C0 447.2 112.8 560 252 560S504 447.2 504 308c0-54.5-17.7-107.6-50.4-151.2L410.4 99.2c-16.2-21.6-48.6-21.6-64.8 0-16.8 22.3-50.6 21.4-66.1-1.8L239.1 36.6c-21.2-31.8-67.3-33.5-90.8-3.3L51.6 157.7C18.1 200.7 0 253.6 0 308zm116.3 79.8c-2.8-33.2 7.6-66.1 28.9-91.7l79.9-95.8c14-16.8 39.8-16.8 53.8 0l79.9 95.8c21.3 25.6 31.7 58.5 28.9 91.7-5.5 65.7-60.4 116.2-126.3 116.2l-18.7 0c-65.9 0-120.8-50.5-126.3-116.2zm27.9-2.3c4.3 51.2 47.1 90.6 98.4 90.6l18.7 0c51.4 0 94.1-39.4 98.4-90.6 2.2-25.8-5.9-51.5-22.5-71.4l-79.9-95.8c-2.8-3.4-8-3.4-10.8 0L166.8 314c-16.6 19.9-24.7 45.6-22.5 71.4z", "M246.6 218.2c2.8-3.4 8-3.4 10.8 0L337.2 314c16.6 19.9 24.7 45.6 22.5 71.4-4.3 51.2-47.1 90.6-98.4 90.6l-18.7 0c-51.4 0-94.2-39.4-98.4-90.6-2.2-25.8 5.9-51.5 22.5-71.4l79.9-95.8zm-21.5-17.9l-79.9 95.8c-21.3 25.6-31.7 58.5-28.9 91.7 5.5 65.7 60.4 116.2 126.3 116.2l18.7 0c65.9 0 120.8-50.5 126.3-116.2 2.8-33.2-7.6-66.1-28.9-91.7l-79.9-95.8c-14-16.8-39.8-16.8-53.8 0z"]],
    "rectangle-vertical": [448, 560, ["rectangle-portrait"], "f2fb", ["M0 112L0 448c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-336C448 50.1 397.9 0 336 0L112 0C50.1 0 0 50.1 0 112zm56 14c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L126 84c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126z", "M266 70c0 7.7-6.3 14-14 14L126 84c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14z"]],
    "print": [560, 560, [128424, 128438, 9113], "f02f", ["M0 252l0 84c0 61.9 50.1 112 112 112l0-56c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 56c61.9 0 112-50.1 112-112l0-84c0-61.9-50.1-112-112-112l-28 0c0 7.7-6.3 14-14 14s-14-6.3-14-14l-224 0c0 7.7-6.3 14-14 14s-14-6.3-14-14l-28 0C50.1 140 0 190.1 0 252zm105 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm35 140l0 56 280 0 0-56c0-15.5-12.5-28-28-28l-224 0c-15.5 0-28 12.5-28 28z", "M196 28l168 0c15.5 0 28 12.5 28 28l0 84c0 7.7 6.3 14 14 14s14-6.3 14-14l0-84c0-30.9-25.1-56-56-56L196 0c-30.9 0-56 25.1-56 56l0 84c0 7.7 6.3 14 14 14s14-6.3 14-14l0-84c0-15.5 12.5-28 28-28zM420 504c0 15.5-12.5 28-28 28l-224 0c-15.5 0-28-12.5-28-28l0-112c0-15.5 12.5-28 28-28l224 0c15.5 0 28 12.5 28 28l0 112zm28-112c0-30.9-25.1-56-56-56l-224 0c-30.9 0-56 25.1-56 56l0 112c0 30.9 25.1 56 56 56l224 0c30.9 0 56-25.1 56-56l0-112zM105 252a21 21 0 1 0 -42 0 21 21 0 1 0 42 0z"]],
    "users": [672, 560, [], "f0c0", ["M13.1 444.2C-25.6 498.7 27.3 560 94.1 560L354 560c66.8 0 119.7-61.3 81-115.8-46.4-65.4-123.6-108.2-210.9-108.2S59.5 378.8 13.1 444.2zM84 140a140 140 0 1 0 280 0 140 140 0 1 0 -280 0zm57.5 34.4c-3.5-6.9-.8-15.3 6.1-18.8s15.3-.8 18.8 6.1C176.8 181.8 199.3 196 224 196s47.2-14.2 57.5-34.4c3.5-6.9 12-9.6 18.8-6.1s9.6 12 6.1 18.8C291.3 204.1 259.1 224 224 224s-67.3-19.9-82.5-49.6z", "M428.8 26.6c-11.5 0-22.7 1.7-33.1 4.9-6.7 2-13.7-1.7-15.7-8.4s1.7-13.7 8.4-15.7c12.8-3.9 26.4-6 40.5-6 76.5 0 138.6 62.1 138.6 138.6S505.4 278.6 428.8 278.6c-14.1 0-27.7-2.1-40.5-6-6.7-2-10.4-9.1-8.4-15.7s9.1-10.4 15.7-8.4c10.5 3.2 21.6 4.9 33.1 4.9 62.6 0 113.4-50.8 113.4-113.4S491.4 26.6 428.8 26.6zM414.8 350c0-7.7 6.3-14 14-14 104.5 0 194.8 60.2 238.3 147.8 3.4 6.9 .6 15.3-6.3 18.8s-15.3 .6-18.8-6.3c-39-78.4-119.8-132.2-213.3-132.2-7.7 0-14-6.3-14-14zM306.5 174.4C291.3 204.1 259.1 224 224 224s-67.3-19.9-82.5-49.6c-3.5-6.9-.8-15.3 6.1-18.8s15.3-.8 18.8 6.1C176.8 181.8 199.3 196 224 196s47.2-14.2 57.5-34.4c3.5-6.9 12-9.6 18.8-6.1s9.6 12 6.1 18.8z"]],
    "alarm-clock": [560, 560, [9200], "f34e", ["M28 280c0 64.6 24.3 123.4 64.2 168l9.9-9.9c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8l-9.9 9.9C156.6 507.7 215.4 532 280 532s123.4-24.3 168-64.2l-9.9-9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l9.9 9.9C507.7 403.4 532 344.6 532 280 532 140.8 419.2 28 280 28S28 140.8 28 280zM280 126c0-7.7 6.3-14 14-14s14 6.3 14 14l0 126 126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-140 0c-7.7 0-14-6.3-14-14l0-140z", "M121.9 23.9l-98 98c-5.5 5.5-14.3 5.5-19.8 0s-5.5-14.3 0-19.8l98-98c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8zM294 112c7.7 0 14 6.3 14 14l0 126 126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-140 0c-7.7 0-14-6.3-14-14l0-140c0-7.7 6.3-14 14-14zM121.9 438.1c5.5 5.5 5.5 14.3 0 19.8l-70 70c-5.5 5.5-14.3 5.5-19.8 0s-5.5-14.3 0-19.8l70-70c5.5-5.5 14.3-5.5 19.8 0zm316.2 0c5.5-5.5 14.3-5.5 19.8 0l70 70c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0l-70-70c-5.5-5.5-5.5-14.3 0-19.8zm0-414.2c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l98 98c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0l-98-98z"]],
    "database": [504, 560, [], "f1c0", ["M28 84l0 84c3.7 0 7.4 1.4 10.1 4.3 13.9 14.4 41.1 28.4 79.2 38.6 37.6 10.1 84.1 16.1 134.7 16.1s97-6 134.7-16.1c38.1-10.2 65.4-24.1 79.2-38.6 2.7-2.9 6.4-4.3 10.1-4.3l0-84C476 37.6 375.7 0 252 0S28 37.6 28 84zm0 116.8L28 336c3.7 0 7.4 1.4 10.1 4.3 13.9 14.4 41.1 28.4 79.2 38.6 37.6 10.1 84.1 16.1 134.7 16.1s97-6 134.7-16.1c38.1-10.2 65.4-24.1 79.2-38.6 2.7-2.9 6.4-4.3 10.1-4.3l0-135.2c-19.7 15.6-48.5 28.1-82.1 37.1-40.3 10.8-89.3 17.1-141.9 17.1s-101.6-6.3-141.9-17.1c-33.5-9-62.4-21.5-82.1-37.1zm0 168L28 476c0 46.4 100.3 84 224 84s224-37.6 224-84l0-107.2c-19.7 15.6-48.5 28.1-82.1 37.1-40.3 10.8-89.3 17.1-141.9 17.1s-101.6-6.3-141.9-17.1c-33.5-9-62.4-21.5-82.1-37.1z", "M38.1 172.3c-5.4-5.6-14.2-5.8-19.8-.4s-5.8 14.2-.4 19.8c19.2 20 52.3 35.6 92.2 46.2 40.3 10.8 89.3 17.1 141.9 17.1s101.6-6.3 141.9-17.1c39.8-10.7 73-26.3 92.2-46.2 5.4-5.6 5.2-14.4-.4-19.8s-14.4-5.2-19.8 .4C452 186.8 424.8 200.7 386.7 210.9 349 221 302.5 227 252 227s-97-6-134.7-16.1C79.2 200.7 52 186.8 38.1 172.3zm0 168c-5.4-5.6-14.2-5.8-19.8-.4s-5.8 14.2-.4 19.8c19.2 20 52.3 35.6 92.2 46.2 40.3 10.8 89.3 17.1 141.9 17.1s101.6-6.3 141.9-17.1c39.8-10.7 73-26.3 92.2-46.2 5.4-5.6 5.2-14.4-.4-19.8s-14.4-5.2-19.8 .4C452 354.8 424.8 368.7 386.7 378.9 349 389 302.5 395 252 395s-97-6-134.7-16.1C79.2 368.7 52 354.8 38.1 340.3z"]],
    "newspaper": [560, 560, [128240], "f1ea", ["M26.8 64.2C35.3 59 45.3 56 56 56l42 0c-7.7 0-14 6.3-14 14l0 378c0 15.5-12.5 28-28 28s-28-12.5-28-28L28 70c0-2.1-.4-4-1.2-5.8zM79 499.1c19.4-8.8 33-28.3 33-51.1l0-378c0-7.7-6.3-14-14-14l406 0c30.9 0 56 25.1 56 56l0 280c0 61.9-50.1 112-112 112l-336 0c-11.5 0-22.6-1.7-33-4.9zM168 154c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zm0 84c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zm0 84c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zm0 84c0 7.7 6.3 14 14 14l308 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-308 0c-7.7 0-14 6.3-14 14zM308 196l0 84c0 30.9 25.1 56 56 56l84 0c30.9 0 56-25.1 56-56l0-84c0-30.9-25.1-56-56-56l-84 0c-30.9 0-56 25.1-56 56zm28 0c0-15.5 12.5-28 28-28l84 0c15.5 0 28 12.5 28 28l0 84c0 15.5-12.5 28-28 28l-84 0c-15.5 0-28-12.5-28-28l0-84z", "M98 56c-7.7 0-14 6.3-14 14l0 378c0 15.5-12.5 28-28 28s-28-12.5-28-28L28 70c0-7.7-6.3-14-14-14S0 62.3 0 70L0 448c0 30.9 25.1 56 56 56s56-25.1 56-56l0-378c0-7.7-6.3-14-14-14zm70 98c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zm14 70c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0zm0 168c-7.7 0-14 6.3-14 14s6.3 14 14 14l308 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-308 0zm0-84c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0zM364 168l84 0c15.5 0 28 12.5 28 28l0 84c0 15.5-12.5 28-28 28l-84 0c-15.5 0-28-12.5-28-28l0-84c0-15.5 12.5-28 28-28zm-56 28l0 84c0 30.9 25.1 56 56 56l84 0c30.9 0 56-25.1 56-56l0-84c0-30.9-25.1-56-56-56l-84 0c-30.9 0-56 25.1-56 56z"]],
    "location-arrow": [504, 560, [], "f124", ["M-.9 250.7c0 31.4 25.4 56.8 56.8 56.8l168.9 0 0 168.9c0 31.4 25.4 56.8 56.8 56.8 23.3 0 44.3-14.3 52.8-36L504.6 64c4.1-10.4 1.6-22.2-6.3-30s-19.7-10.3-30-6.3L35.1 197.9c-21.7 8.5-36 29.5-36 52.8zM112.2 238c0-7.7 6.3-14 14-14l168 0c7.7 0 14 6.3 14 14l0 168c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-154-154 0c-7.7 0-14-6.3-14-14z", "M112.2 238c0-7.7 6.3-14 14-14l168 0c7.7 0 14 6.3 14 14l0 168c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-154-154 0c-7.7 0-14-6.3-14-14z"]],
    "arrow-right-to-bracket": [560, 560, ["sign-in"], "f090", ["M336 45.3C336 20.3 356.3 0 381.3 0L504 0c30.9 0 56 25.1 56 56l0 448c0 30.9-25.1 56-56 56l-122.7 0c-25 0-45.3-20.3-45.3-45.3 0-7 1.6-14 4.8-20.3l84.4-168.9 33.1-36.1c4.9-5.4 4.9-13.6 0-18.9l-33.1-36.1-84.4-168.8c-3.1-6.3-4.8-13.2-4.8-20.3z", "M284.5 101.7c-5.7 5.2-6.1 14.1-.9 19.8L416.2 266 14 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l402.2 0-132.5 144.5c-5.2 5.7-4.8 14.6 .9 19.8s14.6 4.8 19.8-.9l154-168c4.9-5.4 4.9-13.6 0-18.9l-154-168c-5.2-5.7-14.1-6.1-19.8-.9z"]],
    "video-slash": [616, 560, [], "f4e2", ["M28 168c0-40.2 21.2-75.5 53-95.2L440.5 432.3C424.3 474.3 383.6 504 336 504l-196 0C78.1 504 28 453.9 28 392l0-224zM108.3 60.5c10-3 20.7-4.5 31.7-4.5l196 0c59.2 0 107.7 46 111.7 104.2L367 219.4c-6.2 4.6-7.6 13.3-3 19.6s13.3 7.6 19.6 3L448 194.7 448 392c0 2.7-.1 5.3-.3 7.9L108.3 60.5z", "M18.1 9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l560 560c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L18.1 9.9zM498.6 122.8c9.6-7.1 21.3-10.8 33.2-10.8 30.8 0 56.2 25 56.2 56l0 224c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-224c0-15.4-12.6-28-28.2-28-6 0-11.8 1.9-16.6 5.4L383.6 241.9c-6.2 4.6-15 3.2-19.6-3s-3.2-15 3-19.6l131.6-96.5z"]],
    "comment": [560, 560, [128489, 61669], "f075", ["M0 252c0 66.7 28.8 127.4 75.9 172.5L56.7 501c-.5 2-.7 4-.7 6l0 2.3c0 12.5 10.1 22.7 22.7 22.7 3.5 0 7-.8 10.1-2.4L175.9 486c32.2 11.6 67.3 18 104.1 18 154.6 0 280-112.8 280-252S434.6 0 280 0 0 112.8 0 252zm161 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm140 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm140 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M119 252a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm140 0a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm161-21a21 21 0 1 1 0 42 21 21 0 1 1 0-42z"]],
    "video": [560, 560, ["video-camera"], "f03d", ["M0 168L0 392c0 61.9 50.1 112 112 112l196 0c60.8 0 110.3-48.5 112-108.9l-100-70c-31.4-22-31.9-68.4-1-91l100.7-73.9C415.7 102 367.2 56 308 56L112 56C50.1 56 0 106.1 0 168zm335.5 88.6c-15.5 11.3-15.2 34.5 .5 45.5l84 58.8 0-166.2-84.5 61.9z", "M487.2 145.4c4.8-3.5 10.6-5.4 16.6-5.4 15.5 0 28.2 12.6 28.2 28l0 217c0 15.5-12.5 28-28 28l-.8 0c-5.7 0-11.4-1.8-16.1-5.1L336 302.1c-15.7-11-16-34.2-.5-45.5L487.2 145.4zM503.8 112c-11.9 0-23.6 3.8-33.2 10.8L319 234c-30.9 22.7-30.4 69 1 91L471.1 430.9c9.4 6.6 20.6 10.1 32.1 10.1l.8 0c30.9 0 56-25.1 56-56l0-217c0-31-25.3-56-56.2-56z"]],
    "clipboard": [448, 560, [128203], "f328", ["M0 140L0 448c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-308c0-61.9-50.1-112-112-112l-14 0c38.7 0 70 31.3 70 70l0 28c0 23.2-18.8 42-42 42L98 168c-23.2 0-42-18.8-42-42l0-28c0-38.7 31.3-70 70-70l-14 0C50.1 28 0 78.1 0 140zM84 98l0 28c0 7.7 6.3 14 14 14l252 0c7.7 0 14-6.3 14-14l0-28c0-23.2-18.8-42-42-42l-42 0c-7.7 0-14-6.3-14-14 0-4.9-.8-9.6-2.4-14l-79.2 0c-1.5 4.4-2.4 9.1-2.4 14 0 7.7-6.3 14-14 14l-42 0c-23.2 0-42 18.8-42 42z", "M224 0c-23.2 0-42 18.8-42 42 0 7.7-6.3 14-14 14l-42 0c-23.2 0-42 18.8-42 42l0 28c0 7.7 6.3 14 14 14l252 0c7.7 0 14-6.3 14-14l0-28c0-23.2-18.8-42-42-42l-42 0c-7.7 0-14-6.3-14-14 0-23.2-18.8-42-42-42zM155.4 28c6.5-32 34.7-56 68.6-56s62.1 24 68.6 56L322 28c38.7 0 70 31.3 70 70l0 28c0 23.2-18.8 42-42 42L98 168c-23.2 0-42-18.8-42-42l0-28c0-38.7 31.3-70 70-70l29.4 0z"]],
    "laptop": [616, 560, [128187], "f109", ["M28 168C28 106.1 78.1 56 140 56l336 0c61.9 0 112 50.1 112 112l0 203c0 58-47 105-105 105l-350 0C75 476 28 429 28 371l0-203zm56 0l0 196c0 30.9 25.1 56 56 56l336 0c30.9 0 56-25.1 56-56l0-196c0-30.9-25.1-56-56-56l-336 0c-30.9 0-56 25.1-56 56zm28 0c0-15.5 12.5-28 28-28l336 0c15.5 0 28 12.5 28 28l0 196c0 15.5-12.5 28-28 28l-336 0c-15.5 0-28-12.5-28-28l0-196z", "M504 168c0-15.5-12.5-28-28-28l-336 0c-15.5 0-28 12.5-28 28l0 196c0 15.5 12.5 28 28 28l336 0c15.5 0 28-12.5 28-28l0-196zm-28-56c30.9 0 56 25.1 56 56l0 196c0 30.9-25.1 56-56 56l-336 0c-30.9 0-56-25.1-56-56l0-196c0-30.9 25.1-56 56-56l336 0zM14 504l588 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L14 532c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "thumbs-down": [616, 560, [128078, 61576], "f165", ["M168 134.9c0-14.7 5.8-28.5 15.6-38.8 7.7 7.6 12.4 18.2 12.4 29.8l0 196c0 12.9-5.8 24.5-15 32.2l-2.6-3.6c-6.8-9.5-10.4-20.9-10.4-32.5l0-183.1zM197.3 377c16.3-12.8 26.7-32.7 26.7-55l0-196c0-17.1-6.2-32.8-16.4-45l37.2-16c13.9-6 29-9.1 44.1-9.1l143.4 0C476 56 515.7 81.4 534 121.1l8.7 18.9-52.8 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c3.2 0 6.1-1 8.4-2.8l23.9 51.9c5.1 11 8.2 22.9 9.3 34.9L518 252c-7.7 0-14 6.3-14 14s6.3 14 14 14l70 0 0 42c0 38.7-31.3 70-70 70l-140 0 0 93.8c0 25.5-20.7 46.2-46.2 46.2-14.9 0-28.9-7.2-37.6-19.4L197.3 377z", "M154 364c23.2 0 42-18.8 42-42l0-196c0-23.2-18.8-42-42-42L98 84c-23.2 0-42 18.8-42 42l0 196c0 23.2 18.8 42 42 42l56 0zM98 392c-38.7 0-70-31.3-70-70l0-196c0-38.7 31.3-70 70-70l56 0c38.7 0 70 31.3 70 70l0 196c0 38.7-31.3 70-70 70l-56 0zM504 266c0-7.7 6.3-14 14-14l70 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-70 0c-7.7 0-14-6.3-14-14zm-14-98c-7.7 0-14-6.3-14-14s6.3-14 14-14l56 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-56 0z"]],
    "utensils": [448, 560, [127860, 61685, "cutlery"], "f2e7", ["M0 56L0 196c0 61.9 50.1 112 112 112l0-14c0-7.7 6.3-14 14-14s14 6.3 14 14l0 14c61.9 0 112-50.1 112-112l0-140c0-30.9-25.1-56-56-56l-14 0 0 182c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-182-56 0 0 182c0 7.7-6.3 14-14 14s-14-6.3-14-14L70 0 56 0C25.1 0 0 25.1 0 56zm308 70l0 210c0 30.9 25.1 56 56 56l56 0 0-378C420 6.4 426.1 .2 433.7 0 364.3 .2 308 56.5 308 126z", "M98 0c0-7.7-6.3-14-14-14S70-7.7 70 0l0 182c0 7.7 6.3 14 14 14s14-6.3 14-14L98 0zm84 0c0-7.7-6.3-14-14-14S154-7.7 154 0l0 182c0 7.7 6.3 14 14 14s14-6.3 14-14L182 0zM448 14c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 532c0 7.7 6.3 14 14 14s14-6.3 14-14l0-532zM126 280c-7.7 0-14 6.3-14 14l0 252c0 7.7 6.3 14 14 14s14-6.3 14-14l0-252c0-7.7-6.3-14-14-14z"]],
    "microphone": [448, 560, [], "f130", ["M84 140l0 112c0 77.3 62.7 140 140 140s140-62.7 140-140l-126 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l126 0 0-56-126 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l126 0C364 62.7 301.3 0 224 0S84 62.7 84 140z", "M238 140c-7.7 0-14 6.3-14 14s6.3 14 14 14l126 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-126 0zm0 84c-7.7 0-14 6.3-14 14s6.3 14 14 14l126 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-126 0zM28 168c0-7.7-6.3-14-14-14S0 160.3 0 168l0 84C0 371 92.8 468.3 210 475.6l0 56.4-112 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l252 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-112 0 0-56.4C355.2 468.3 448 371 448 252l0-84c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 84c0 108.2-87.8 196-196 196S28 360.2 28 252l0-84z"]],
    "crown": [560, 560, [128081], "f521", ["M0 95.6L0 392c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-296.4c0-21.9-17.7-39.6-39.6-39.6-10.5 0-20.6 4.2-28 11.6L392 168 303.2 66.5C297.4 59.8 288.9 56 280 56s-17.4 3.8-23.2 10.5L168 168 67.6 67.6C60.2 60.2 50.1 56 39.6 56 17.7 56 0 73.7 0 95.6zM168 336a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm252 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm252 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M112 308a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm56 28a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm112-28a28 28 0 1 0 0 56 28 28 0 1 0 0-56zm56 28a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm28 56a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"]],
    "arrow-up-wide-short": [616, 560, ["sort-amount-up"], "f161", ["M308 84c0-30.9 25.1-56 56-56l204.6 0c26.2 0 47.4 21.2 47.4 47.4 0 5.7-1 11.3-3 16.6L461.6 495.7c-8.2 21.9-29.1 36.3-52.4 36.3L364 532c-30.9 0-56-25.1-56-56l0-271.5 32.5 29.8c5.7 5.2 14.6 4.8 19.8-.9s4.8-14.6-.9-19.8L308 166.5 308 84z", "M3.7 233.5c5.2 5.7 14.1 6.1 19.8 .9L168 101.8 168 490c0 7.7 6.3 14 14 14s14-6.3 14-14l0-388.2 144.5 132.5c5.7 5.2 14.6 4.8 19.8-.9s4.8-14.6-.9-19.8l-168-154c-5.4-4.9-13.6-4.9-18.9 0l-168 154c-5.7 5.2-6.1 14.1-.9 19.8z"]],
    "sun": [560, 560, [9728], "f185", ["M24.9 236.8c-27.2 22.4-27.2 64.1 0 86.5l27.5 22.7c14.4 11.8 22 30.1 20.2 48.7l-3.4 35.5c-3.4 35.1 26.1 64.6 61.2 61.2l35.5-3.4c18.6-1.8 36.8 5.8 48.7 20.2l22.7 27.5c22.4 27.2 64.1 27.2 86.5 0l22.7-27.5c11.8-14.4 30.1-22 48.7-20.2l35.5 3.4c35.1 3.4 64.6-26.1 61.2-61.2l-3.4-35.5c-1.8-18.6 5.8-36.8 20.2-48.7l27.5-22.7c27.2-22.4 27.2-64.1 0-86.5l-27.5-22.7c-14.4-11.9-22-30.1-20.2-48.7l3.4-35.5c3.4-35.1-26.1-64.6-61.2-61.2l-35.5 3.4c-18.6 1.8-36.8-5.8-48.7-20.2L323.6 24.5c-22.4-27.2-64.1-27.2-86.5 0L214.5 52.1c-11.9 14.4-30.1 22-48.7 20.2l-35.5-3.4c-35.1-3.4-64.6 26.1-61.2 61.2l3.4 35.5c1.8 18.6-5.8 36.8-20.2 48.7L24.9 236.8zM419.6 280a139.6 139.6 0 1 1 -279.3 0 139.6 139.6 0 1 1 279.3 0zm-251.3 0a111.6 111.6 0 1 0 223.3 0 111.6 111.6 0 1 0 -223.3 0z", "M279.6 168a112 112 0 1 1 .7 224 112 112 0 1 1 -.7-224zm.7 252a140 140 0 1 0 -.7-280 140 140 0 1 0 .7 280z"]],
    "image": [616, 560, [], "f03e", ["M28.5 168l0 174.5 118-137.7c26.5-31 73.8-32.8 102.6-3.9L535.5 487.2c31.8-19.8 53-55 53-95.2l0-224c0-61.9-50.1-112-112-112l-336 0c-61.9 0-112 50.1-112 112zm0 210l0 14c0 61.9 50.1 112 112 112l336 0c11 0 21.6-1.6 31.7-4.5L229.4 220.7c-17.3-17.3-45.7-16.2-61.6 2.4L39.1 373.1c-2.8 3.2-6.7 4.9-10.6 4.9zm490-182a70 70 0 1 1 -140 0 70 70 0 1 1 140 0zm-112 0a42 42 0 1 0 84 0 42 42 0 1 0 -84 0z", "M490.5 196a42 42 0 1 1 -84 0 42 42 0 1 1 84 0zm-42-70a70 70 0 1 0 0 140 70 70 0 1 0 0-140zM167.8 223c15.9-18.6 44.3-19.7 61.6-2.4L522.6 513.9c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8L249.2 200.9c-28.8-28.8-76.1-27-102.6 3.9L17.9 354.9c-5 5.9-4.4 14.7 1.5 19.7s14.7 4.4 19.7-1.5L167.8 223z"]],
    "notdef": [504, 560, [], "e1fe", ["M28 112c0-23.9 7.5-46.1 20.3-64.3L234.1 280 48.3 512.3C35.5 494.1 28 471.9 28 448l0-336zM67.3 26.8C86.9 10.1 112.3 0 140 0L364 0c27.7 0 53.1 10.1 72.7 26.8L252 257.6 67.3 26.8zm0 506.5L252 302.4 436.7 533.2C417.1 549.9 391.7 560 364 560l-224 0c-27.7 0-53.1-10.1-72.7-26.8zM269.9 280L455.7 47.7C468.5 65.9 476 88.1 476 112l0 336c0 23.9-7.5 46.1-20.3 64.3L269.9 280z", "M38.9-8.7c-4.8-6-13.6-7-19.7-2.2s-7 13.6-2.2 19.7l217 271.3-217 271.3c-4.8 6-3.9 14.8 2.2 19.7s14.8 3.9 19.7-2.2L252 302.4 465.1 568.7c4.8 6 13.6 7 19.7 2.2s7-13.6 2.2-19.7L269.9 280 486.9 8.7c4.8-6 3.9-14.8-2.2-19.7s-14.8-3.9-19.7 2.2L252 257.6 38.9-8.7z"]],
    "pencil": [560, 560, [9999, 61504, "pencil-alt"], "f303", ["M0 438.4L0 462c0-7.7 6.3-14 14-14s14 6.3 14 14l0 70 70 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l23.6 0c29.7 0 58.2-11.8 79.2-32.8l279.3-279.3-168-168C219 173 125.9 266.1 32.8 359.2 11.8 380.2 0 408.7 0 438.4zM331.9 60.1l168 168c9.1-9.1 18.2-18.2 27.3-27.3 21-21 32.8-49.5 32.8-79.2l0-9.6C560 50.1 509.9 0 448 0l-9.6 0c-29.7 0-58.2 11.8-79.2 32.8-9.1 9.1-18.2 18.2-27.3 27.3z", "M331.9 60.1c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l168 168c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-168-168zM28 462c0-7.7-6.3-14-14-14S0 454.3 0 462l0 84c0 7.7 6.3 14 14 14l84 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-70 0 0-70z"]],
    "lightbulb": [448, 560, [128161], "f0eb", ["M0 224c0 80.6 42.5 151.2 106.4 190.7 3.9 2.4 7.7 5.2 11.1 8.2 2.4-1.8 5.3-2.9 8.5-2.9l196 0c3.2 0 6.2 1.1 8.5 2.9 3.4-3 7.2-5.8 11.1-8.2 63.8-39.5 106.4-110.1 106.4-190.7 0-123.7-100.3-224-224-224S0 100.3 0 224zm113-8.8c-2.1-5.3-.8-11.3 3.2-15.2s10.1-5.1 15.3-2.8l31.8 13.6c38.7 16.6 82.6 16.6 121.3 0l31.8-13.6c5.2-2.2 11.2-1.1 15.3 2.8s5.3 10 3.2 15.2l-56 140c-2.9 7.2-11 10.7-18.2 7.8s-10.7-11-7.8-18.2l43.4-108.6-.8 .3c-45.8 19.6-97.6 19.6-143.4 0l-.8-.3 43.4 108.6c2.9 7.2-.6 15.3-7.8 18.2s-15.3-.6-18.2-7.8l-56-140zM135.7 448c2.8 6.7 4.3 13.9 4.3 21.5l0 6.5 168 0 0-6.5c0-7.5 1.5-14.7 4.3-21.5l-176.6 0zm4.3 56c0 30.9 25.1 56 56 56l56 0c30.9 0 56-25.1 56-56l-168 0z", "M131.5 197.1c-5.2-2.2-11.2-1.1-15.3 2.8s-5.3 10-3.2 15.2l56 140c2.9 7.2 11 10.7 18.2 7.8s10.7-11 7.8-18.2l-43.4-108.6 .8 .3c45.8 19.6 97.6 19.6 143.4 0l.8-.3-43.4 108.6c-2.9 7.2 .6 15.3 7.8 18.2s15.3-.6 18.2-7.8l56-140c2.1-5.3 .8-11.3-3.2-15.2s-10.1-5.1-15.3-2.8l-31.8 13.6c-38.7 16.6-82.6 16.6-121.3 0l-31.8-13.6zM112 434c0 7.7 6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0c-7.7 0-14 6.3-14 14zm14 56c0 7.7 6.3 14 14 14l168 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-168 0c-7.7 0-14 6.3-14 14z"]],
    "code": [616, 560, [], "f121", ["M26.5 230.5c-27.3 27.3-27.3 71.7 0 99L184.6 487.6c17.1 17.1 42.5 20.8 63.2 11.2l18.5-87.7c-.8-.9-1.6-1.8-2.5-2.7l-98.7-98.7c-16.4-16.4-16.4-43 0-59.4l98.7-98.7c21.9-21.9 21.9-57.3 0-79.2s-57.3-21.9-79.2 0L26.5 230.5zm323.6-81.6c.8 .9 1.6 1.8 2.5 2.7l98.7 98.7c16.4 16.4 16.4 43 0 59.4l-98.7 98.7c-21.9 21.9-21.9 57.3 0 79.2s57.3 21.9 79.2 0L589.9 329.5c27.3-27.3 27.3-71.7 0-99L431.8 72.4c-17.1-17.1-42.5-20.8-63.2-11.2l-18.5 87.7z", "M367.1 .3c7.6 1.6 12.4 9 10.8 16.6l-112 532c-1.6 7.6-9 12.4-16.6 10.8s-12.4-9-10.8-16.6l112-532c1.6-7.6 9-12.4 16.6-10.8z"]],
    "address-card": [560, 560, [62140, "contact-card", "vcard"], "f2bb", ["M0 168L0 392c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L112 56C50.1 56 0 106.1 0 168zM57.8 371.1c10.1-17.8 21.8-33.7 37.4-45.1 15.9-11.7 35.1-17.9 58.7-17.9s42.8 6.3 58.7 17.9c15.6 11.4 27.3 27.4 37.4 45.1 3.8 6.7 1.5 15.3-5.2 19.1s-15.3 1.5-19.1-5.2c-9.3-16.3-18.6-28.3-29.6-36.4-10.7-7.8-23.9-12.5-42.2-12.5s-31.5 4.7-42.2 12.5c-11 8.1-20.4 20.1-29.6 36.4-3.8 6.7-12.4 9.1-19.1 5.2s-9.1-12.4-5.2-19.1zM224 210a70 70 0 1 1 -140 0 70 70 0 1 1 140 0zm-112 0a42 42 0 1 0 84 0 42 42 0 1 0 -84 0zm168 0c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zm0 112c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14z", "M154 168a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm0 112a70 70 0 1 0 0-140 70 70 0 1 0 0 140zm-42.2 68.5c10.7-7.8 23.9-12.5 42.2-12.5s31.5 4.7 42.2 12.5c11 8.1 20.4 20.1 29.6 36.4 3.8 6.7 12.4 9.1 19.1 5.2s9.1-12.4 5.2-19.1c-10.1-17.8-21.8-33.7-37.4-45.1-15.9-11.7-35.1-17.9-58.7-17.9s-42.8 6.3-58.7 17.9c-15.6 11.4-27.3 27.4-37.4 45.1-3.8 6.7-1.5 15.3 5.2 19.1s15.3 1.5 19.1-5.2c9.3-16.3 18.6-28.3 29.6-36.4zM294 196c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0zm0 112c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0z"]],
    "angle-right": [448, 560, [8250], "f105", ["M56 42l0 70c2.9 0 5.8 .9 8.3 2.7l210 154c3.6 2.6 5.7 6.8 5.7 11.3s-2.1 8.7-5.7 11.3l-210 154c-2.5 1.8-5.4 2.7-8.3 2.7l0 70c0 23.2 18.8 42 42 42 9.1 0 17.9-2.9 25.2-8.4L425.6 324.8C439.7 314.2 448 297.6 448 280s-8.3-34.2-22.4-44.8L123.2 8.4C115.9 2.9 107.1 0 98 0 74.8 0 56 18.8 56 42zm0 101.4L56 416.6 242.3 280 56 143.4z", "M44.7 117.7c-4.6 6.2-3.2 15 3 19.6L242.3 280 47.7 422.7c-6.2 4.6-7.6 13.3-3 19.6s13.3 7.6 19.6 3l210-154c3.6-2.6 5.7-6.8 5.7-11.3s-2.1-8.7-5.7-11.3l-210-154c-6.2-4.6-15-3.2-19.6 3z"]],
    "face-meh": [560, 560, [128528, "meh"], "f11a", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm168 70c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zm49-154a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm168 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M217 196a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm168 0a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm-7 168c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0z"]],
    "map": [560, 560, [128506, 62072], "f279", ["M0 129.3C0 118.7 6 109 15.5 104.3 61.7 81.2 107.8 58.1 154 35l0 413c0 1.5 .3 3 .7 4.4L36.9 491.7C18.7 497.8 0 484.3 0 465.2L0 129.3zM181.1 452.9c.6-1.5 .9-3.2 .9-4.9l0-413c0-.6 0-1.2-.1-1.8l197 73.9c-.6 1.5-.9 3.2-.9 4.9l0 414.7-196.9-73.8zM404.5 105.7l115-57.5c18.6-9.3 40.5 4.2 40.5 25L560 405c0 9.4-4.7 18.1-12.5 23.3L406 522.7 406 112c0-2.3-.5-4.4-1.5-6.3z", "M182 35c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 413c0 7.7 6.3 14 14 14s14-6.3 14-14l0-413zm224 77c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 420c0 7.7 6.3 14 14 14s14-6.3 14-14l0-420z"]],
    "thumbtack": [448, 560, [128204, 128392, "thumb-tack"], "f08d", ["M0 354.7L0 364c0 30.9 25.1 56 56 56l154 0 0-168c0-7.7 6.3-14 14-14s14 6.3 14 14l0 168 154 0c30.9 0 56-25.1 56-56l0-9.3c0-12.1-3.9-23.9-11.2-33.6l-61.6-82.1c-7.3-9.7-11.2-21.5-11.2-33.6L364 56 84 56 84 205.3c0 12.1-3.9 23.9-11.2 33.6L11.2 321.1C3.9 330.8 0 342.5 0 354.7z", "M392 28c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 56c-7.7 0-14-6.3-14-14s6.3-14 14-14l336 0zM210 252c0-7.7 6.3-14 14-14s14 6.3 14 14l0 266c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-266z"]],
    "money-bill-wave": [560, 560, [], "f53a", ["M0 132.3L0 439.1c0 21.1 11.7 40.9 31.6 47.8 82.8 28.7 165.6 7.6 248.4-13.5 79.2-20.2 158.4-40.4 237.6-17 20.1 5.9 42.4-7.8 42.4-28.7l0-306.8c0-21.1-11.7-40.9-31.6-47.8-82.8-28.7-165.6-7.6-248.4 13.5-79.2 20.2-158.4 40.4-237.6 17-20.1-5.9-42.4 7.8-42.4 28.7zM182 280c0-61.9 43.9-112 98-112s98 50.1 98 112-43.9 112-98 112-98-50.1-98-112zm28 0c0 50 34.7 84 70 84s70-34 70-84-34.7-84-70-84-70 34-70 84z", "M280 364c-35.3 0-70-34-70-84s34.7-84 70-84 70 34 70 84-34.7 84-70 84zm0 28c54.1 0 98-50.1 98-112s-43.9-112-98-112-98 50.1-98 112 43.9 112 98 112z"]],
    "folder": [616, 560, [128193, 128447, 61716, "folder-blank"], "f07b", ["M28 140l0 28 545 0c-19.4-33.5-55.6-56-97-56l-90.7 0c-31.4 0-61.3-13.2-82.6-36.3L292.3 64.3C271.1 41.2 241.1 28 209.7 28L140 28C78.1 28 28 78.1 28 140zm0 56l0 224c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-196c0-9.7-1.2-19.1-3.5-28L28 196z", "M14 182c0-7.7 6.3-14 14-14l560 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L28 196c-7.7 0-14-6.3-14-14z"]],
    "arrow-up-from-bracket": [560, 560, [], "e09a", ["M0 381.3L0 504c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-122.7c0-25-20.3-45.3-45.3-45.3-7 0-14 1.6-20.3 4.8L305 435.5c-3.6 1.8-7.3 3.2-11 4.1l0 36.4c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-36.4c-3.8-1-7.5-2.4-11-4.1L65.6 340.8c-6.3-3.1-13.2-4.8-20.3-4.8-25 0-45.3 20.3-45.3 45.3z", "M101.7 177.5c5.2 5.7 14.1 6.1 19.8 .9L266 45.8 266 476c0 7.7 6.3 14 14 14s14-6.3 14-14l0-430.2 144.5 132.5c5.7 5.2 14.6 4.8 19.8-.9s4.8-14.6-.9-19.8l-168-154c-5.4-4.9-13.6-4.9-18.9 0l-168 154c-5.7 5.2-6.1 14.1-.9 19.8z"]],
    "cloud": [616, 560, [9729], "f0c2", ["M28.7 350.1c7.4-.5 13.3-6.6 13.3-14.1 0-69.6 56.4-126 126-126 28.4 0 54.5 9.4 75.6 25.2 6.2 4.6 15 3.4 19.6-2.8s3.4-15-2.8-19.6c-25.7-19.3-57.8-30.8-92.4-30.8-2.8 0-5.5 .1-8.3 .2 18.2-64.7 77.7-112.2 148.3-112.2 76.3 0 139.7 55.5 151.9 128.3 1.3 7.6 8.5 12.8 16.1 11.5 4.9-.8 8.8-4.1 10.6-8.4 58.6 16.8 101.4 70.7 101.4 134.6 0 77.3-62.7 140-140 140l-280 0C95.5 476 35.8 420.8 28.7 350.1z", "M159.7 182.2c18.2-64.7 77.7-112.2 148.3-112.2 76.3 0 139.7 55.5 151.9 128.3 1.3 7.6 8.5 12.8 16.1 11.5s12.8-8.5 11.5-16.1C473 107.6 398.2 42 308 42 220.2 42 147 104.1 129.8 186.8 63.2 203.8 14 264.1 14 336 14 343.7 20.3 350 28 350s14-6.3 14-14c0-69.6 56.4-126 126-126 28.4 0 54.5 9.4 75.6 25.2 6.2 4.6 15 3.4 19.6-2.8s3.4-15-2.8-19.6c-25.7-19.3-57.8-30.8-92.4-30.8-2.8 0-5.5 .1-8.3 .2z"]],
    "circle": [560, 560, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm56.9 0c0-123.2 99.9-223.1 223.1-223.1 7.2 0 13.1 5.9 13.1 13.1S287.2 83.1 280 83.1c-108.7 0-196.9 88.1-196.9 196.9 0 7.2-5.9 13.1-13.1 13.1S56.9 287.2 56.9 280z", "M280 83.1c-108.7 0-196.9 88.1-196.9 196.9 0 7.2-5.9 13.1-13.1 13.1S56.9 287.2 56.9 280c0-123.2 99.9-223.1 223.1-223.1 7.2 0 13.1 5.9 13.1 13.1S287.2 83.1 280 83.1z"]],
    "backward": [504, 560, [9194], "f04a", ["M168 280c0 17.7 8.2 34.3 22.1 45.2l89.9 69.9 0-230.2-89.9 69.9C176.2 245.7 168 262.3 168 280zM308 143.1l0 273.8 100.7 78.3c7.3 5.7 16.3 8.8 25.6 8.8 23 0 41.7-18.7 41.7-41.7l0-364.6c0-23-18.7-41.7-41.7-41.7-9.3 0-18.3 3.1-25.6 8.8L308 143.1z", "M280 97.7c0-7.6-6.1-13.7-13.7-13.7-3 0-6 1-8.4 2.9L39.3 256.9C32.2 262.5 28 271 28 280s4.2 17.5 11.3 23.1l218.6 170c2.4 1.9 5.4 2.9 8.4 2.9 7.6 0 13.7-6.1 13.7-13.7l0-364.6zm28 0l0 364.6c0 23-18.7 41.7-41.7 41.7-9.3 0-18.3-3.1-25.6-8.8L22.1 325.2C8.2 314.3 0 297.7 0 280s8.2-34.3 22.1-45.2l218.6-170c7.3-5.7 16.3-8.8 25.6-8.8 23 0 41.7 18.7 41.7 41.7z"]],
    "link": [672, 560, [128279, "chain"], "f0c1", ["M0 196c0 92.8 75.2 168 168 168l56 0c0-82.4 59.3-150.9 137.5-165.2 7.6-1.4 14.9 3.6 16.3 11.2s-3.6 14.9-11.2 16.3C301.4 238.3 252 295.4 252 364l28 0c92.8 0 168-75.2 168-168S372.8 28 280 28L168 28C75.2 28 0 103.2 0 196z", "M490 210c0-7.7 6.3-14 14-14 92.8 0 168 75.2 168 168S596.8 532 504 532l-112 0c-92.8 0-168-75.2-168-168 0-82.4 59.3-150.9 137.5-165.2 7.6-1.4 14.9 3.6 16.3 11.2s-3.6 14.9-11.2 16.3c-65.2 12-114.5 69.1-114.5 137.7 0 77.3 62.7 140 140 140l112 0c77.3 0 140-62.7 140-140S581.3 224 504 224c-7.7 0-14-6.3-14-14z"]],
    "backward-step": [392, 560, ["step-backward"], "f048", ["M0 84C0 53.1 25.1 28 56 28l56 0c30.9 0 56 25.1 56 56l0 102.7-61.9 48.1C92.2 245.7 84 262.3 84 280s8.2 34.3 22.1 45.2L168 373.3 168 476c0 30.9-25.1 56-56 56l-56 0c-30.9 0-56-25.1-56-56L0 84zM112 280c0-9 4.2-17.5 11.3-23.1l44.7-34.8 0 115.7-44.7-34.8C116.2 297.5 112 289 112 280z", "M364 97.7c0-7.6-6.1-13.7-13.7-13.7-3 0-6 1-8.4 2.9l-218.6 170C116.2 262.5 112 271 112 280s4.2 17.5 11.3 23.1l218.6 170c2.4 1.9 5.4 2.9 8.4 2.9 7.6 0 13.7-6.1 13.7-13.7l0-364.6zm28 0l0 364.6c0 23-18.7 41.7-41.7 41.7-9.3 0-18.3-3.1-25.6-8.8l-218.6-170C92.2 314.3 84 297.7 84 280s8.2-34.3 22.1-45.2l218.6-170c7.3-5.7 16.3-8.8 25.6-8.8 23 0 41.7 18.7 41.7 41.7z"]],
    "circle-user": [560, 560, [62142, "user-circle"], "f2bd", ["M0 280C0 355.7 30.1 424.4 78.9 474.8 127.1 424 199.5 392 280 392s152.9 32 201.1 82.8C529.9 424.4 560 355.7 560 280 560 125.4 434.6 0 280 0S0 125.4 0 280zM99.4 494c48.8 41.2 111.8 66 180.6 66s131.9-24.8 180.6-66C418 449 353.1 420 280 420S142 449 99.4 494zM392 224a112 112 0 1 1 -224 0 112 112 0 1 1 224 0zm-196 0a84 84 0 1 0 168 0 84 84 0 1 0 -168 0z", "M364 224a84 84 0 1 0 -168 0 84 84 0 1 0 168 0zm-196 0a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM94.5 499.3c-5.1 5.8-14 6.3-19.8 1.2s-6.3-14-1.2-19.8C121.6 426.5 196.4 392 280 392s158.4 34.5 206.5 88.7c5.1 5.8 4.6 14.6-1.2 19.8s-14.6 4.6-19.8-1.2C423 451.3 356 420 280 420S137 451.3 94.5 499.3z"]],
    "hand": [504, 560, [129306, 9995, "hand-paper"], "f256", ["M0 288.4c0 3.7 .6 7.4 1.7 11L34.6 403.5C64 496.6 150.4 560 248.2 560l59.8 0c92.8 0 168-75.2 168-168l0-154c0-64.4-33.5-121-84-153.4L392 294c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-210c0-4.7 2.3-8.9 5.9-11.4-19.1-8.8-40-14.4-61.9-16L308 294c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-238-56 0 0 238c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-234.5C147.7 72 112 115.8 112 168l0 154-44.6-55.8c-7.2-9-18-14.2-29.5-14.2l-1.4 0C16.3 252 0 268.3 0 288.4z", "M210 42c7.7 0 14 6.3 14 14l0 238c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-238c0-7.7 6.3-14 14-14zm84 0c7.7 0 14 6.3 14 14l0 238c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-238c0-7.7 6.3-14 14-14zm98 42l0 210c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-210c0-7.7 6.3-14 14-14s14 6.3 14 14z"]],
    "thumbs-up": [616, 560, [128077, 61575], "f164", ["M168 241.9l0 183.1c0 14.7 5.8 28.5 15.6 38.8 7.7-7.6 12.4-18.2 12.4-29.8l0-196c0-12.9-5.8-24.5-15-32.2l-2.6 3.6c-6.8 9.5-10.4 20.9-10.4 32.5zm29.3-59c16.3 12.8 26.7 32.7 26.7 55l0 196c0 17.1-6.2 32.8-16.4 45l37.2 16c13.9 6 29 9.1 44.1 9.1l143.4 0c43.7 0 83.4-25.4 101.7-65.1l8.7-18.9-52.8 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l56 0c3.2 0 6.1 1 8.4 2.8l23.9-51.9c5.1-11 8.2-22.9 9.3-34.9-23.2 0-46.4 0-69.6 0-7.7 0-14-6.3-14-14s6.3-14 14-14l70 0 0-42c0-38.7-31.3-70-70-70l-140 0 0-93.8c0-25.5-20.7-46.2-46.2-46.2-14.9 0-28.9 7.2-37.6 19.4L197.3 183z", "M154 196c23.2 0 42 18.8 42 42l0 196c0 23.2-18.8 42-42 42l-56 0c-23.2 0-42-18.8-42-42l0-196c0-23.2 18.8-42 42-42l56 0zM98 168c-38.7 0-70 31.3-70 70l0 196c0 38.7 31.3 70 70 70l56 0c38.7 0 70-31.3 70-70l0-196c0-38.7-31.3-70-70-70l-56 0zM504 294c0 7.7 6.3 14 14 14l70 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-70 0c-7.7 0-14 6.3-14 14zm-14 98c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0z"]],
    "building": [448, 560, [127970, 61687], "f1ad", ["M0 112L0 448c0 61.9 50.1 112 112 112l56 0 0-84c0-30.9 25.1-56 56-56s56 25.1 56 56l0 84 56 0c61.9 0 112-50.1 112-112l0-336C448 50.1 397.9 0 336 0L112 0C50.1 0 0 50.1 0 112zm84 14c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm0 168c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm28-168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14zm0 168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14zm84 182l0 84 56 0 0-84c0-15.5-12.5-28-28-28s-28 12.5-28 28zm56-350c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm0 168c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm28-168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14zm0 168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14z", "M84 126l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0c-23.2 0-42 18.8-42 42zm42-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28c0-7.7 6.3-14 14-14zm126 14l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0c-23.2 0-42 18.8-42 42zm42-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28c0-7.7 6.3-14 14-14zM126 252c-23.2 0-42 18.8-42 42l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0zm-14 42c0-7.7 6.3-14 14-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28zm140 0l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0c-23.2 0-42 18.8-42 42zm42-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28c0-7.7 6.3-14 14-14zM196 476c0-15.5 12.5-28 28-28s28 12.5 28 28l0 84c0 7.7 6.3 14 14 14s14-6.3 14-14l0-84c0-30.9-25.1-56-56-56s-56 25.1-56 56l0 84c0 7.7 6.3 14 14 14s14-6.3 14-14l0-84z"]],
    "gear": [560, 560, [9881, "cog"], "f013", ["M14.7 180.3c-8 13.8-5.6 31.2 5.7 42.4l37 36.6c-.6 6.8-.9 13.7-.9 20.7s.3 13.9 .9 20.7l-37 36.6C9.1 348.5 6.7 366 14.7 379.7l46.5 80.5c8 13.8 24.2 20.5 39.5 16.3l50.2-13.7c11.2 8 23.3 15 35.9 20.8l13.2 50.3c4 15.4 17.9 26.1 33.9 26.1l93 0c15.9 0 29.8-10.7 33.9-26.1L374 483.6c12.7-5.8 24.7-12.8 35.9-20.8l50.2 13.7c15.3 4.2 31.6-2.5 39.5-16.3l46.5-80.5c8-13.8 5.6-31.2-5.7-42.4l-37-36.6c.6-6.8 .9-13.7 .9-20.7s-.3-13.9-.9-20.7l37-36.6c11.3-11.2 13.6-28.6 5.7-42.4L499.7 99.7c-8-13.8-24.2-20.5-39.5-16.3L409.9 97.2c-11.3-8-23.3-15-35.9-20.8L360.8 26.1C356.7 10.7 342.8 0 326.9 0l-93 0C218 0 204.1 10.7 200.1 26.1L186.9 76.4c-12.7 5.8-24.7 12.8-35.9 20.8L100.7 83.5C85.4 79.3 69.1 86 61.2 99.7L14.7 180.3zM391.6 280a111.6 111.6 0 1 1 -223.1 0 111.6 111.6 0 1 1 223.1 0zm-195.1 0a83.6 83.6 0 1 0 167.1 0 83.6 83.6 0 1 0 -167.1 0z", "M279.6 196a84 84 0 1 1 .9 168 84 84 0 1 1 -.9-168zm.9 196a112 112 0 1 0 -.9-224 112 112 0 1 0 .9 224z"]],
    "circle-question": [560, 560, [62108, "question-circle"], "f059", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm168-56c0-46.4 37.6-84 84-84l56 0c46.4 0 84 37.6 84 84l0 9.8c0 33.6-20 64-50.9 77.2l-38.6 16.5c-5.1 2.2-8.5 7.3-8.5 12.9l0 9.5c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-9.5c0-16.8 10-32 25.5-38.6l38.6-16.5c20.6-8.8 33.9-29.1 33.9-51.5l0-9.8c0-30.9-25.1-56-56-56l-56 0c-30.9 0-56 25.1-56 56 0 7.7-6.3 14-14 14s-14-6.3-14-14zM301 420a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M280 441a21 21 0 1 1 0-42 21 21 0 1 1 0 42zm14-91c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-9.5c0-16.8 10-32 25.5-38.6l38.6-16.5c20.6-8.8 33.9-29.1 33.9-51.5l0-9.8c0-30.9-25.1-56-56-56l-56 0c-30.9 0-56 25.1-56 56 0 7.7-6.3 14-14 14s-14-6.3-14-14c0-46.4 37.6-84 84-84l56 0c46.4 0 84 37.6 84 84l0 9.8c0 33.6-20 64-50.9 77.2l-38.6 16.5c-5.1 2.2-8.5 7.3-8.5 12.9l0 9.5z"]],
    "file": [504, 560, [128196, 128459, 61462], "f15b", ["M28 112l0 336c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-247.6c0-1.5 0-2.9-.1-4.4L406 196c-69.6 0-126-56.4-126-126l0-70c-1.5 0-2.9 0-4.4 0L140 0C78.1 0 28 50.1 28 112zM140 294c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zm0 112c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zM308 4.8L308 70c0 54.1 43.9 98 98 98l65.2 0c-5.3-17.5-14.8-33.6-28-46.8L354.8 32.8c-13.2-13.2-29.3-22.7-46.8-28z", "M308 0c0-7.7-6.3-14-14-14S280-7.7 280 0l0 70c0 69.6 56.4 126 126 126l70 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-70 0c-54.1 0-98-43.9-98-98l0-70zM154 280c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0zm0 112c-7.7 0-14 6.3-14 14s6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0z"]],
    "volume-slash": [616, 560, [128263], "f2e2", ["M28 224c0-30.9 25.1-56 56-56l4.8 0c14.9 0 29.1-5.9 39.6-16.4L144.1 135.9 308 299.8 308 448c0 30.9-25.1 56-56 56l-4.8 0c-14.9 0-29.1-5.9-39.6-16.4l-79.2-79.2C117.9 397.9 103.7 392 88.8 392L84 392c-30.9 0-56-25.1-56-56l0-112zM163.9 116.1l43.7-43.7C218.1 61.9 232.3 56 247.2 56l4.8 0c30.9 0 56 25.1 56 56l0 148.2-144.1-144.1z", "M18.1 9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l560 560c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L18.1 9.9zM364 56c123.7 0 224 100.3 224 224 0 50.4-16.7 97-44.8 134.4-4.6 6.2-13.4 7.4-19.6 2.8s-7.4-13.4-2.8-19.6c24.6-32.8 39.2-73.5 39.2-117.6 0-108.2-87.8-196-196-196-7.7 0-14-6.3-14-14s6.3-14 14-14zm0 84c77.3 0 140 62.7 140 140 0 23.1-5.6 45-15.6 64.2-3.6 6.9-12 9.6-18.9 6s-9.6-12-6-18.9c7.9-15.4 12.4-32.8 12.4-51.4 0-61.9-50.1-112-112-112-7.7 0-14-6.3-14-14s6.3-14 14-14zm-14 98c0-7.7 6.3-14 14-14 30.9 0 56 25.1 56 56 0 7.7-6.3 14-14 14s-14-6.3-14-14c0-15.5-12.5-28-28-28-7.7 0-14-6.3-14-14z"]],
    "arrow-up": [448, 560, [8593], "f062", ["M0 266.3C0 257 3.1 248 8.8 240.7l170-218.6C189.7 8.2 206.3 0 224 0s34.3 8.2 45.2 22.1l170 218.6c5.7 7.3 8.8 16.3 8.8 25.6 0 23-18.7 41.7-41.7 41.7l-168.3 0 0-182c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 182-168.3 0C18.7 308 0 289.3 0 266.3z", "M224 112c7.7 0 14 6.3 14 14l0 420c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-420c0-7.7 6.3-14 14-14z"]],
    "rectangle": [560, 560, [9644, "rectangle-landscape"], "f2fa", ["M0 168L0 392c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L112 56C50.1 56 0 106.1 0 168zm56 14c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126z", "M266 126c0 7.7-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14z"]],
    "grid": [560, 560, ["grid-3"], "e195", ["M0 364L0 504c0 30.9 25.1 56 56 56l140 0c30.9 0 56-25.1 56-56l0-140c0-30.9-25.1-56-56-56L56 308c-30.9 0-56 25.1-56 56zM28 56l0 140c0 15.5 12.5 28 28 28l140 0c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28L56 28C40.5 28 28 40.5 28 56zm280 0l0 140c0 30.9 25.1 56 56 56l140 0c30.9 0 56-25.1 56-56l0-140c0-30.9-25.1-56-56-56L364 0c-30.9 0-56 25.1-56 56zm28 308l0 140c0 15.5 12.5 28 28 28l140 0c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28l-140 0c-15.5 0-28 12.5-28 28z", "M196 224c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28L56 28C40.5 28 28 40.5 28 56l0 140c0 15.5 12.5 28 28 28l140 0zM196 0c30.9 0 56 25.1 56 56l0 140c0 30.9-25.1 56-56 56L56 252c-30.9 0-56-25.1-56-56L0 56C0 25.1 25.1 0 56 0L196 0zM504 532c15.5 0 28-12.5 28-28l0-140c0-15.5-12.5-28-28-28l-140 0c-15.5 0-28 12.5-28 28l0 140c0 15.5 12.5 28 28 28l140 0zm0-224c30.9 0 56 25.1 56 56l0 140c0 30.9-25.1 56-56 56l-140 0c-30.9 0-56-25.1-56-56l0-140c0-30.9 25.1-56 56-56l140 0z"]],
    "shirt": [560, 560, [128085, "t-shirt", "tshirt"], "f553", ["M26.3 105.3c.9 1.6 1.5 3.5 1.6 5.5l14 161c.1 1.2 .1 2.4-.1 3.6 2.9 .5 5.8 .5 8.9 0L79.7 271c17-2.6 32.3 10.5 32.3 27.7L112 476c0 30.9 25.1 56 56 56l224 0c30.9 0 56-25.1 56-56l0-177.4c0-17.2 15.3-30.3 32.3-27.7l29.1 4.5c3 .5 6 .4 8.9 0-.2-1.2-.3-2.4-.1-3.6l14-161c.2-2 .7-3.8 1.6-5.5-.4-.2-.8-.3-1.2-.4L405.4 60.7c-1.2-.4-2.3-.7-3.5-.8-14.1 54.1-63.3 94.1-121.9 94.1S172.2 114 158.1 59.9c-1.1 .1-2.3 .4-3.5 .8L27.5 104.9c-.4 .1-.8 .3-1.2 .4z", "M168 42.4c7.5-1.9 15.1 2.6 17 10.1 10.9 42.3 49.3 73.5 94.9 73.5s84-31.2 94.9-73.5c1.9-7.5 9.6-12 17-10.1s12 9.6 10.1 17C388 113.8 338.7 154 280 154S172 113.8 158 59.5c-1.9-7.5 2.6-15.1 10.1-17zM12.8 98.1c7.7-.7 14.5 5 15.2 12.7l14 161c.7 7.7-5 14.5-12.7 15.2s-14.5-5-15.2-12.7l-14-161c-.7-7.7 5-14.5 12.7-15.2zm547.2 15.2l-14 161c-.7 7.7-7.5 13.4-15.2 12.7s-13.4-7.5-12.7-15.2l14-161c.7-7.7 7.5-13.4 15.2-12.7s13.4 7.5 12.7 15.2z"]],
    "suitcase": [560, 560, [129523], "f0f2", ["M0 224c0-52.2 35.7-96 84-108.5l0 384.9C35.7 488 0 444.2 0 392L0 224zM112 112l56 0 0 14c0 7.7 6.3 14 14 14s14-6.3 14-14l0-14 168 0 0 14c0 7.7 6.3 14 14 14s14-6.3 14-14l0-14 56 0 0 392-336 0 0-392zm364 3.5c48.3 12.4 84 56.3 84 108.5l0 168c0 52.2-35.7 96-84 108.5l0-384.9z", "M196 56c0-15.5 12.5-28 28-28l112 0c15.5 0 28 12.5 28 28l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-30.9-25.1-56-56-56L224 0c-30.9 0-56 25.1-56 56l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70zm-84 56c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 392c0 7.7 6.3 14 14 14s14-6.3 14-14l0-392zm364 0c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 392c0 7.7 6.3 14 14 14s14-6.3 14-14l0-392z"]],
    "play": [392, 560, [9654], "f04b", ["M28 99.4l0 361.3c0 24 19.4 43.4 43.4 43.4 8.2 0 16.3-2.4 23.3-6.8L368.4 323c14.7-9.4 23.6-25.6 23.6-43s-8.9-33.7-23.6-43L94.7 62.8c-7-4.4-15-6.8-23.3-6.8-24 0-43.4 19.4-43.4 43.4zM84 154c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-252z", "M84 154l0 252c0 7.7 6.3 14 14 14s14-6.3 14-14l0-252c0-7.7-6.3-14-14-14s-14 6.3-14 14z"]],
    "paperclip": [392, 560, [128206], "f0c6", ["M84 182l0 196c0 61.9 50.1 112 112 112 9.1 0 18-1.1 26.6-3.2 9.8-15.2 15.4-33.4 15.4-52.8l0-224c0-23.2-18.8-42-42-42s-42 18.8-42 42l0 112c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-112c0-38.7 31.3-70 70-70s70 31.3 70 70l0 224c0 12.2-1.7 24-5 35.2 28.4-20.3 47-53.6 47-91.2l0-196c0-61.9-50.1-112-112-112S84 120.1 84 182z", "M14 182C14 81.5 95.5 0 196 0S378 81.5 378 182l0 140c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-140c0-85.1-68.9-154-154-154S42 96.9 42 182l0 252c0 54.1 43.9 98 98 98s98-43.9 98-98l0-224c0-23.2-18.8-42-42-42s-42 18.8-42 42l0 112c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-112c0-38.7 31.3-70 70-70s70 31.3 70 70l0 224c0 69.6-56.4 126-126 126S14 503.6 14 434l0-252z"]],
    "wrench": [504, 560, [128295], "f0ad", ["M0 224c0 82 39.2 154.9 99.8 200.9 7.4 5.6 12.2 14.3 12.2 23.6l0 83.5c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-83.5c0-9.3 4.7-18 12.2-23.6 60.7-46 99.8-118.9 99.8-200.9 0-95.7-53.3-178.9-131.9-221.6-6.2-3.3-12.6-3.7-18.3-1.9 5.9 1.7 10.2 7.1 10.2 13.5l0 168c0 4.1-1.8 8-4.9 10.6l-98 84c-5.2 4.5-13 4.5-18.2 0l-98-84c-3.1-2.7-4.9-6.5-4.9-10.6l0-168C140 7.6 144.3 2.2 150.2 .5 144.5-1.3 138-.9 131.9 2.4 53.3 45.1 0 128.3 0 224z", "M168 14c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 168c0 4.1 1.8 8 4.9 10.6l98 84c5.2 4.5 13 4.5 18.2 0l98-84c3.1-2.7 4.9-6.5 4.9-10.6l0-168c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 161.6-84 72-84-72 0-161.6z"]],
    "life-ring": [560, 560, [], "f1cd", ["M0 280C0 207.7 27.4 141.8 72.4 92.2l99.2 99.2c-19.7 24.1-31.6 55-31.6 88.6s11.8 64.5 31.6 88.6L72.4 467.8C27.4 418.2 0 352.3 0 280zM92.2 72.4C141.8 27.4 207.7 0 280 0S418.2 27.4 467.8 72.4l-99.2 99.2c-24.1-19.7-55-31.6-88.6-31.6s-64.5 11.8-88.6 31.6L92.2 72.4zm0 415.3l99.2-99.2c24.1 19.7 55 31.6 88.6 31.6s64.5-11.8 88.6-31.6l99.2 99.2C418.2 532.6 352.3 560 280 560S141.8 532.6 92.2 487.6zM388.4 191.4l99.2-99.2C532.6 141.8 560 207.7 560 280s-27.4 138.2-72.4 187.8l-99.2-99.2c19.7-24.1 31.6-55 31.6-88.6s-11.8-64.5-31.6-88.6z", "M79.9 60.1c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l126 126c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-126-126zm294 294c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l126 126c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-126-126zm126-294c-5.5-5.5-14.3-5.5-19.8 0l-126 126c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l126-126c5.5-5.5 5.5-14.3 0-19.8zm-294 313.8c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-126 126c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l126-126z"]],
    "calendar": [560, 560, [128197, 128198], "f133", ["M28 168l0 28 504 0 0-28c0-61.9-50.1-112-112-112l-7 0 0 28c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-28-217 0 0 28c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-28C78.1 56 28 106.1 28 168zm0 56l0 196c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-196-504 0z", "M154 0c-7.7 0-14 6.3-14 14l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-7.7-6.3-14-14-14zM399 0c-7.7 0-14 6.3-14 14l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-7.7-6.3-14-14-14zM28 196c-7.7 0-14 6.3-14 14s6.3 14 14 14l504 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L28 196z"]],
    "check": [616, 560, [10003, 10004], "f00c", ["M15.9 229.2C-6 251-6 286.3 15.9 308.2L202.8 494c21.9 21.8 57.5 21.8 79.4 0l39.7-39.5c2.4-2.4 4.6-5 6.5-7.8L600 176.5c21.9-21.8 21.9-57.2 0-79L560.3 58c-21.9-21.8-57.5-21.8-79.4 0L241.8 295.9 135 189.7c-21.9-21.8-57.5-21.8-79.4 0L15.9 229.2zm100.4 26.9c5.5-5.5 14.3-5.5 19.8 0L238.2 358.2 452.3 144.1c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8L253.1 383c-8.2 8.2-21.5 8.2-29.7 0l-107.1-107c-5.5-5.5-5.5-14.3 0-19.8z", "M472.1 144.1c5.5 5.5 5.5 14.3 0 19.8L253.1 383c-8.2 8.2-21.5 8.2-29.7 0l-107.1-107c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0L238.2 358.2 452.3 144.1c5.5-5.5 14.3-5.5 19.8 0z"]],
    "fingerprint": [672, 560, [], "f577", ["M56.1 280c0-154.6 125.4-280 280-280s280 125.4 280 280c0 26.3-3.6 51.7-10.4 75.8-15.1-20.8-24.7-45.3-24.7-71.3 0-107.7-91.6-240.1-242.2-240.1-150.7 0-238 124-238 242.2 0 38.9-8.7 69-27.7 89.8-11-30.1-17-62.5-17-96.4zM82.8 399.5c29.5-26.5 41.2-66.2 41.2-112.8 0-108.1 79.3-219 214.8-219 135.5 0 219 119.6 219 216.9 0 37.3 15.9 71.1 39.1 97.4-26.6 68-78.9 123-145.1 153.1 38.4-74.5 60.8-159.2 60.8-248.4 0-79.8-57.3-165.4-165.4-165.4S182 206.8 182 286.6c0 62.6-28.5 119.1-73.1 157-10-13.8-18.7-28.6-26.1-44.2zm40.4 62.4c50-42.2 82-105.2 82-175.3 0-69.6 49.4-142.2 142.2-142.2S489.5 217 489.5 286.6c0 94.7-26.4 184.1-71 261-23 7.1-47.3 11.3-72.5 12.2 56.4-76.4 89.7-170.9 89.7-273.2 0-20.1-5.5-30.5-12-42.9-.2-.3-.3-.6-.5-.9-11.7-22.1-34.4-44.6-76-44.6s-64.3 22.5-76 44.6c-6.8 13-12 28.6-12.5 43.5-2.1 65.4-14.8 111.2-35.8 146.8-15.3 26.1-35.4 47.3-60.2 67-14.5-11.4-27.8-24.2-39.7-38.2zm59.2 52.2c24.1-19.9 44.6-42 60.6-69.3 23.5-39.9 36.7-89.7 39-157.6 .9-11.6 4.4-23.3 9.8-33.6 8.6-16.3 24.3-32.3 55.5-32.3s46.9 15.9 55.5 32.3c5.4 10.2 8.9 21.9 9.8 33.4-.1 103.1-35.8 197.7-95.4 272.3-21.3-1.4-41.9-5.2-61.6-11.1 64.1-68.5 103.4-160.5 103.4-261.6 0-6.4-5.2-11.6-11.6-11.6s-11.6 5.2-11.6 11.6c0 98.6-39.8 188.1-104.2 253.2-17.3-7-33.7-15.6-49.1-25.7z", "M124 286.6c0-108.1 79.3-219 214.8-219 135.5 0 219 119.6 219 216.9 0 56.8 37 105.5 80.1 132.1 5.4 3.4 12.6 1.7 16-3.8s1.7-12.6-3.8-16c-38.4-23.7-69.1-65.7-69.1-112.3 0-107.7-91.6-240.1-242.2-240.1-150.7 0-238 124-238 242.2 0 52-15.6 88.1-50.4 107.6-5.6 3.1-7.6 10.2-4.5 15.8s10.2 7.6 15.8 4.5c45.1-25.1 62.3-71.3 62.3-127.8zm81.2 0c0-69.6 49.4-142.2 142.2-142.2S489.5 217 489.5 286.6c0 108.9-35 211-92.3 294.8-3.6 5.3-2.3 12.5 3 16.1s12.5 2.2 16.1-3c59.7-87.4 96.3-194 96.3-307.9 0-79.8-57.3-165.4-165.4-165.4S182 206.8 182 286.6c0 75.9-41.9 142.8-103.7 178.7-5.5 3.2-7.4 10.3-4.2 15.8s10.3 7.4 15.8 4.2c68.6-39.7 115.3-114.1 115.3-198.7zM347.4 275c-6.4 0-11.6 5.2-11.6 11.6 0 118.7-57.7 224.2-146.6 289.8-5.2 3.8-6.2 11.1-2.4 16.2s11.1 6.2 16.2 2.4c94.5-69.8 156-182 156-308.5 0-6.4-5.2-11.6-11.6-11.6zM243.1 444.8c23.5-39.9 36.7-89.7 39-157.6 .9-11.6 4.4-23.3 9.8-33.6 8.6-16.3 24.3-32.3 55.5-32.3s46.9 15.9 55.5 32.3c5.4 10.2 8.9 21.9 9.8 33.4-.1 112.9-42.9 215.6-113.1 293.1-4.3 4.7-3.9 12.1 .8 16.4s12.1 3.9 16.4-.8c74.1-81.7 119.1-190.1 119.1-309.1 0-20.1-5.5-30.5-12-42.9-.2-.3-.3-.6-.5-.9-11.7-22.1-34.4-44.6-76-44.6s-64.3 22.5-76 44.6c-6.8 13-12 28.6-12.5 43.5-2.1 65.4-14.8 111.2-35.8 146.8-21 35.7-50.9 62.3-89.5 88.4-5.3 3.6-6.7 10.8-3.1 16.1s10.8 6.7 16.1 3.1c40-27 73-55.9 96.5-95.8z"]],
    "house": [616, 560, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", ["M56 247.5L308 45.9 560 247.5 560 420c0 61.9-50.1 112-112 112l-28 0 0-154c0-38.7-31.3-70-70-70l-84 0c-38.7 0-70 31.3-70 70l0 154-28 0c-61.9 0-112-50.1-112-112l0-172.5zM224 378c0-23.2 18.8-42 42-42l84 0c23.2 0 42 18.8 42 42l0 154-168 0 0-154z", "M316.7 17.1c-5.1-4.1-12.4-4.1-17.5 0l-280 224c-6 4.8-7 13.6-2.2 19.7s13.6 7 19.7 2.2l271.3-217 271.3 217c6 4.8 14.8 3.9 19.7-2.2s3.9-14.8-2.2-19.7l-280-224zM224 378c0-23.2 18.8-42 42-42l84 0c23.2 0 42 18.8 42 42l0 154c0 7.7 6.3 14 14 14s14-6.3 14-14l0-154c0-38.7-31.3-70-70-70l-84 0c-38.7 0-70 31.3-70 70l0 154c0 7.7 6.3 14 14 14s14-6.3 14-14l0-154z"]],
    "play-pause": [504, 560, [], "e22f", ["M0 97.7L0 462.3c0 23 18.7 41.7 41.7 41.7 9.3 0 18.3-3.1 25.6-8.8L252 351.6 252 208.4 67.3 64.8C60 59.1 51 56 41.7 56 18.7 56 0 74.7 0 97.7zM280 230.2l0 99.6 5.9-4.6C299.8 314.3 308 297.7 308 280s-8.2-34.3-22.1-45.2l-5.9-4.6z", "M322 112l-28 0c-7.7 0-14 6.3-14 14l0 308c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-308c0-7.7-6.3-14-14-14zM294 84l28 0c23.2 0 42 18.8 42 42l0 308c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-308c0-23.2 18.8-42 42-42zm168 28l-28 0c-7.7 0-14 6.3-14 14l0 308c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-308c0-7.7-6.3-14-14-14zM434 84l28 0c23.2 0 42 18.8 42 42l0 308c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-308c0-23.2 18.8-42 42-42z"]],
    "sliders": [560, 560, ["sliders-h"], "f1de", ["M56.9 420l222.3 0c-6.9-55.2-54-98-111.1-98S63.8 364.8 56.9 420zm0 28c6.9 55.2 54 98 111.1 98s104.2-42.8 111.1-98L56.9 448zm224-308l222.3 0c-6.9-55.2-54-98-111.1-98S287.8 84.8 280.9 140zm0 28c6.9 55.2 54 98 111.1 98s104.2-42.8 111.1-98l-222.3 0z", "M0 154c0-7.7 6.3-14 14-14l532 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L14 168c-7.7 0-14-6.3-14-14zM0 434c0-7.7 6.3-14 14-14l532 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L14 448c-7.7 0-14-6.3-14-14z"]],
    "face-frown": [560, 560, [9785, "frown"], "f119", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zM126 434c0-85.1 68.9-154 154-154s154 68.9 154 154c0 7.7-6.3 14-14 14s-14-6.3-14-14c0-69.6-56.4-126-126-126S154 364.4 154 434c0 7.7-6.3 14-14 14s-14-6.3-14-14zm91-238a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm168 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M175 196a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm168 0a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm91 238c0 7.7-6.3 14-14 14s-14-6.3-14-14c0-69.6-56.4-126-126-126S154 364.4 154 434c0 7.7-6.3 14-14 14s-14-6.3-14-14c0-85.1 68.9-154 154-154s154 68.9 154 154z"]],
    "forward-step": [392, 560, ["step-forward"], "f051", ["M224 84l0 102.7 61.9 48.1C299.8 245.7 308 262.3 308 280s-8.2 34.3-22.1 45.2L224 373.3 224 476c0 30.9 25.1 56 56 56l56 0c30.9 0 56-25.1 56-56l0-392c0-30.9-25.1-56-56-56l-56 0c-30.9 0-56 25.1-56 56zm0 138.1l0 115.7 44.7-34.8C275.8 297.5 280 289 280 280s-4.2-17.5-11.3-23.1L224 222.1z", "M28 97.7c0-7.6 6.1-13.7 13.7-13.7 3 0 6 1 8.4 2.9l218.6 170C275.8 262.5 280 271 280 280s-4.2 17.5-11.3 23.1L50.1 473.1c-2.4 1.9-5.4 2.9-8.4 2.9-7.6 0-13.7-6.1-13.7-13.7L28 97.7zm-28 0L0 462.3c0 23 18.7 41.7 41.7 41.7 9.3 0 18.3-3.1 25.6-8.8l218.6-170C299.8 314.3 308 297.7 308 280s-8.2-34.3-22.1-45.2L67.3 64.8C60 59.1 51 56 41.7 56 18.7 56 0 74.7 0 97.7z"]],
    "sort": [392, 560, ["unsorted"], "f0dc", ["M0 211.1c0-9.8 3.5-19.2 9.8-26.6L149.8 21.3C161.3 7.8 178.2 0 196 0s34.7 7.8 46.2 21.3L382.2 184.5c6.4 7.4 9.8 16.8 9.8 26.6 0 22.6-18.3 40.9-40.9 40.9L40.9 252C18.3 252 0 233.7 0 211.1z", "M40.9 336c-7.1 0-12.9 5.8-12.9 12.9 0 3.1 1.1 6 3.1 8.4L171 520.5c6.2 7.3 15.4 11.5 25 11.5s18.7-4.2 25-11.5L360.9 357.3c2-2.3 3.1-5.3 3.1-8.4 0-7.1-5.8-12.9-12.9-12.9L40.9 336zm0-28l310.2 0c22.6 0 40.9 18.3 40.9 40.9 0 9.8-3.5 19.2-9.8 26.6L242.2 538.7C230.7 552.2 213.8 560 196 560s-34.7-7.8-46.2-21.3L9.8 375.5C3.5 368.1 0 358.6 0 348.9 0 326.3 18.3 308 40.9 308z"]],
    "user": [448, 560, [128100, 62144, 62470, "user-alt", "user-large"], "f007", ["M13.2 444.2C-25.5 498.7 27.4 560 94.2 560l259.9 0c66.8 0 119.7-61.3 81-115.8-46.4-65.4-123.6-108.2-210.9-108.2S59.6 378.8 13.2 444.2zM84.1 140a140 140 0 1 0 280 0 140 140 0 1 0 -280 0zm55.7 34.4c-3.5-6.9-.8-15.3 6.1-18.8s15.3-.8 18.8 6.1c10.3 20.2 32.8 34.4 57.5 34.4s47.2-14.2 57.5-34.4c3.5-6.9 12-9.6 18.8-6.1s9.6 12 6.1 18.8c-15.2 29.7-47.4 49.6-82.5 49.6s-67.3-19.9-82.5-49.6z", "M298.7 155.5c6.9 3.5 9.6 12 6.1 18.8-15.2 29.7-47.4 49.6-82.5 49.6s-67.3-19.9-82.5-49.6c-3.5-6.9-.8-15.3 6.1-18.8s15.3-.8 18.8 6.1c10.3 20.2 32.8 34.4 57.5 34.4s47.2-14.2 57.5-34.4c3.5-6.9 12-9.6 18.8-6.1z"]],
    "snowflake": [560, 560, [10052, 10054], "f2dc", ["M22.5 246.9L109 212.8 162.2 266 84 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l78.2 0-53.2 53.2-86.5-34.1c-30-11.8-30-54.3 0-66.2zm52-125.6C61.7 91.7 91.7 61.7 121.3 74.5l64.4 28c-5.1 5.5-4.9 14.1 .4 19.4l79.9 79.9 0 64.2-64.2 0-79.9-79.9c-5.3-5.3-13.9-5.5-19.4-.4l-28-64.4zm0 317.4l28-64.4c5.5 5.1 14.1 4.9 19.4-.4l79.9-79.9 64.2 0 0 64.2-79.9 79.9c-5.3 5.3-5.5 13.9-.4 19.4l-64.4 28c-29.6 12.9-59.6-17.2-46.8-46.8zM212.8 109l34.1-86.5c11.8-30 54.3-30 66.2 0L347.2 109 294 162.2 294 84c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 78.2-53.2-53.2zm0 342l53.2-53.2 0 78.2c0 7.7 6.3 14 14 14s14-6.3 14-14l0-78.2 53.2 53.2-34.1 86.5c-11.8 30-54.3 30-66.2 0L212.8 451zM294 201.8l79.9-79.9c5.3-5.3 5.5-13.9 .4-19.4l64.4-28c29.6-12.9 59.6 17.2 46.8 46.8l-28 64.4c-5.5-5.1-14.1-4.9-19.4 .4l-79.9 79.9-64.2 0 0-64.2zm0 92.2l64.2 0 79.9 79.9c5.3 5.3 13.9 5.5 19.4 .4l28 64.4c12.9 29.6-17.2 59.6-46.8 46.8l-64.4-28c5.1-5.5 4.9-14.1-.4-19.4L294 358.2 294 294zm103.8-28l53.2-53.2 86.5 34.1c30 11.8 30 54.3 0 66.2L451 347.2 397.8 294 476 294c7.7 0 14-6.3 14-14s-6.3-14-14-14l-78.2 0z", "M294 84c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 78.2-60.1-60.1c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l79.9 79.9 0 64.2-64.2 0-79.9-79.9c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8L162.2 266 84 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l78.2 0-60.1 60.1c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l79.9-79.9 64.2 0 0 64.2-79.9 79.9c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l60.1-60.1 0 78.2c0 7.7 6.3 14 14 14s14-6.3 14-14l0-78.2 60.1 60.1c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-79.9-79.9 0-64.2 64.2 0 79.9 79.9c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8L397.8 294 476 294c7.7 0 14-6.3 14-14s-6.3-14-14-14l-78.2 0 60.1-60.1c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-79.9 79.9-64.2 0 0-64.2 79.9-79.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0L294 162.2 294 84z"]],
    "ticket": [616, 560, [127903], "f145", ["M0 140l0 63c0 11.6 9.7 20.6 20.5 24.9 20.8 8.2 35.5 28.4 35.5 52.1s-14.7 43.9-35.5 52.1C9.7 336.4 0 345.4 0 357l0 63c0 46.4 37.6 84 84 84l448 0c46.4 0 84-37.6 84-84l0-63c0-11.6-9.7-20.6-20.5-24.9-20.8-8.2-35.5-28.4-35.5-52.1s14.7-43.9 35.5-52.1c10.8-4.3 20.5-13.3 20.5-24.9l0-63c0-46.4-37.6-84-84-84L84 56C37.6 56 0 93.6 0 140zm112 56c0-30.9 25.1-56 56-56l280 0c30.9 0 56 25.1 56 56l0 168c0 30.9-25.1 56-56 56l-280 0c-30.9 0-56-25.1-56-56l0-168zm28 0l0 168c0 15.5 12.5 28 28 28l280 0c15.5 0 28-12.5 28-28l0-168c0-15.5-12.5-28-28-28l-280 0c-15.5 0-28 12.5-28 28z", "M448 168c15.5 0 28 12.5 28 28l0 168c0 15.5-12.5 28-28 28l-280 0c-15.5 0-28-12.5-28-28l0-168c0-15.5 12.5-28 28-28l280 0zM168 140c-30.9 0-56 25.1-56 56l0 168c0 30.9 25.1 56 56 56l280 0c30.9 0 56-25.1 56-56l0-168c0-30.9-25.1-56-56-56l-280 0z"]],
    "wheelchair": [504, 560, [], "f193", ["M0 392c0 92.8 75.2 168 168 168s168-75.2 168-168c0-9.5-.8-18.9-2.3-28l-80.9 0c-36 0-58.6-38.9-40.8-70.2l30.1-52.6C219.7 230.2 194.6 224 168 224 75.2 224 0 299.2 0 392zm236.3-84.3c-7.2 12.6 1.9 28.3 16.4 28.3l73.7 0c-11.5-32.6-32.8-60.6-60.4-80.4l-29.8 52.1z", "M308 56a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm84 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM190 140c-17.3 0-34.1 5.6-47.9 16l-38.4 28.8c-6.2 4.6-7.4 13.4-2.8 19.6s13.4 7.4 19.6 2.8l38.4-28.8c9-6.7 19.9-10.4 31.1-10.4l75.5 0c8.2 0 13.4 8.9 9.3 16L212 293.8c-17.9 31.3 4.7 70.2 40.8 70.2l111.6 0c18.5 0 34.9 12.2 40.2 29.9l30 100.1c2.2 7.4 10 11.6 17.4 9.4s11.6-10 9.4-17.4l-30-100.1c-8.9-29.6-36.1-49.9-67-49.9l-111.6 0c-14.5 0-23.7-15.7-16.4-28.3L299 197.9c14.7-25.8-3.9-57.9-33.6-57.9L190 140z"]],
    "bookmark": [448, 560, [128278, 61591], "f02e", ["M0 112C0 59.8 35.7 16 84 3.5L84 322c0 38.7 31.3 70 70 70l140 0c38.7 0 70-31.3 70-70L364 3.5C412.3 16 448 59.8 448 112l0 402.7c0 25-20.3 45.3-45.3 45.3-7 0-14-1.6-20.3-4.8L249 488.5c-15.8-7.9-34.3-7.9-50.1 0L65.6 555.2c-6.3 3.1-13.2 4.8-20.3 4.8-25 0-45.3-20.3-45.3-45.3L0 112zM112 0l224 0 0 322c0 23.2-18.8 42-42 42l-140 0c-23.2 0-42-18.8-42-42L112 0z", "M98-14c7.7 0 14 6.3 14 14l0 322c0 23.2 18.8 42 42 42l140 0c23.2 0 42-18.8 42-42L336 0c0-7.7 6.3-14 14-14s14 6.3 14 14l0 322c0 38.7-31.3 70-70 70l-140 0c-38.7 0-70-31.3-70-70L84 0c0-7.7 6.3-14 14-14z"]],
    "bomb": [560, 560, [128163], "f1e2", ["M0 336C0 459.7 100.3 560 224 560S448 459.7 448 336c0-26.9-4.7-52.6-13.4-76.5-3.4-9.4-1.6-20 5.5-27 16.4-16.4 16.4-43 0-59.4l-16.7-16.7-7.5 7.5c-5.5 5.5-14.3 5.5-19.8 0s-5.5-14.3 0-19.8l7.5-7.5-22.9-22.9c-16.4-16.4-43-16.4-59.4 0-8.6 8.6-21.5 11.1-33.2 7.6-20.3-6.1-41.8-9.3-64.1-9.3-123.7 0-224 100.3-224 224zm70 0c0-85.1 68.9-154 154-154 7.7 0 14 6.3 14 14s-6.3 14-14 14c-69.6 0-126 56.4-126 126 0 7.7-6.3 14-14 14s-14-6.3-14-14z", "M410.1 18.1c-5.5 5.5-5.5 14.3 0 19.8l28 28c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-28-28c-5.5-5.5-14.3-5.5-19.8 0zm84 47.8c5.5 5.5 14.3 5.5 19.8 0l28-28c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-28 28c-5.5 5.5-5.5 14.3 0 19.8zm-98 98c5.5 5.5 14.3 5.5 19.8 0l42-42c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-42 42c-5.5 5.5-5.5 14.3 0 19.8zm98-42l28 28c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-28-28c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8zM70 336c0 7.7 6.3 14 14 14s14-6.3 14-14c0-69.6 56.4-126 126-126 7.7 0 14-6.3 14-14s-6.3-14-14-14c-85.1 0-154 68.9-154 154z"]],
    "arrow-right": [560, 560, [8594], "f061", ["M252 97.7l0 168.3 182 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-182 0 0 168.3c0 23 18.7 41.7 41.7 41.7 9.3 0 18.3-3.1 25.6-8.8l218.6-170C551.8 314.3 560 297.7 560 280s-8.2-34.3-22.1-45.2L319.3 64.8C312 59.1 303 56 293.7 56 270.7 56 252 74.7 252 97.7z", "M448 280c0-7.7-6.3-14-14-14L14 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l420 0c7.7 0 14-6.3 14-14z"]],
    "battery-bolt": [560, 560, [], "f376", ["M0 196L0 364c0 61.9 50.1 112 112 112l49 0c0-3.4 1.2-6.8 3.7-9.5l160.2-172.5-161 0c-18.7 0-28.1-22.6-14.8-35.8L323.2 84 112 84C50.1 84 0 134.1 0 196zm180.8 70l160.1 0c18.3 0 27.9 21.9 15.4 35.3L194.1 476 392 476c61.9 0 112-50.1 112-112l-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l14 0 0-112-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l14 0c0-61.9-50.1-112-112-112l-35 0c0 3.6-1.4 7.2-4.1 9.9L180.8 266z", "M352.9 93.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-184 184.1c-13.2 13.2-3.9 35.8 14.8 35.8l161 0-160.2 172.5c-5.3 5.7-4.9 14.5 .7 19.8s14.5 4.9 19.8-.7L356.3 301.3c12.5-13.4 2.9-35.3-15.4-35.3L180.8 266 352.9 93.9zM518 224c7.7 0 14 6.3 14 14l0 84c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l28 0c23.2 0 42-18.8 42-42l0-84c0-23.2-18.8-42-42-42l-28 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l28 0z"]],
    "buildings": [616, 560, [], "e0cc", ["M28 112l0 336c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-196c-3.1 0-6.2-1-8.7-3.1l-131.3-105-131.3 105c-6 4.8-14.8 3.9-19.7-2.2s-3.9-14.8 2.2-19.7l64.7-51.8 0-63.3C364 50.1 313.9 0 252 0L140 0C78.1 0 28 50.1 28 112zm112 42c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm0 168c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm28-168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14zm0 168l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14zm224 0c0-23.2 18.8-42 42-42l28 0c23.2 0 42 18.8 42 42l0 28c0 23.2-18.8 42-42 42l-28 0c-23.2 0-42-18.8-42-42l0-28zm28 0l0 28c0 7.7 6.3 14 14 14l28 0c7.7 0 14-6.3 14-14l0-28c0-7.7-6.3-14-14-14l-28 0c-7.7 0-14 6.3-14 14z", "M182 112c-23.2 0-42 18.8-42 42l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0zm-14 42c0-7.7 6.3-14 14-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28zm14 126c-23.2 0-42 18.8-42 42l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0zm-14 42c0-7.7 6.3-14 14-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28zm224 0l0 28c0 23.2 18.8 42 42 42l28 0c23.2 0 42-18.8 42-42l0-28c0-23.2-18.8-42-42-42l-28 0c-23.2 0-42 18.8-42 42zm42-14l28 0c7.7 0 14 6.3 14 14l0 28c0 7.7-6.3 14-14 14l-28 0c-7.7 0-14-6.3-14-14l0-28c0-7.7 6.3-14 14-14zm22.7-192.9c-5.1-4.1-12.4-4.1-17.5 0l-140 112c-6 4.8-7 13.6-2.2 19.7s13.6 7 19.7 2.2l131.3-105 131.3 105c6 4.8 14.8 3.9 19.7-2.2s3.9-14.8-2.2-19.7l-140-112z"]],
    "xmark": [504, 560, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", ["M34.4 101.8c-21.9 21.9-21.9 57.3 0 79.2l99 99-99 99c-21.9 21.9-21.9 57.3 0 79.2L74 497.8c21.9 21.9 57.3 21.9 79.2 0l99-99 99 99c21.9 21.9 57.3 21.9 79.2 0L470 458.2c21.9-21.9 21.9-57.3 0-79.2l-99-99 99-99c21.9-21.9 21.9-57.3 0-79.2L430.4 62.2c-21.9-21.9-57.3-21.9-79.2 0l-99 99-99-99c-21.9-21.9-57.3-21.9-79.2 0L34.4 101.8zm81.9 14.3c5.5-5.5 14.3-5.5 19.8 0L252.2 232.2 368.3 116.1c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8L267 257c-8.2 8.2-21.5 8.2-29.7 0L116.3 135.9c-5.5-5.5-5.5-14.3 0-19.8z", "M388.1 116.1c5.5 5.5 5.5 14.3 0 19.8L267 257c-8.2 8.2-21.5 8.2-29.7 0L116.3 135.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0L252.2 232.2 368.3 116.1c5.5-5.5 14.3-5.5 19.8 0z"]],
    "lock-open": [504, 560, [], "f3c1", ["M0 280L0 448c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-168c0-61.9-50.1-112-112-112l-224 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-70-28 0C50.1 168 0 218.1 0 280z", "M252 28c-46.4 0-84 37.6-84 84l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126C140 50.1 190.1 0 252 0S364 50.1 364 112c0 7.7-6.3 14-14 14s-14-6.3-14-14c0-46.4-37.6-84-84-84z"]],
    "droplet": [448, 560, [128167, "tint"], "f043", ["M0 352.7C0 467.2 92.8 560 207.3 560l33.4 0c114.5 0 207.3-92.8 207.3-207.3 0-47.1-16-92.7-45.4-129.5L251.3 34.2c-14-17.5-40.7-17.5-54.7 0L45.4 223.2C16 260 0 305.6 0 352.7zM56 350c0-7.7 6.3-14 14-14s14 6.3 14 14l0 14c0 61.9 50.1 112 112 112l14 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-14 0c-77.3 0-140-62.7-140-140l0-14z", "M70 336c7.7 0 14 6.3 14 14l0 14c0 61.9 50.1 112 112 112l14 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-14 0c-77.3 0-140-62.7-140-140l0-14c0-7.7 6.3-14 14-14z"]],
    "shop": [560, 560, ["store-alt"], "f54f", ["M28 236.8c13.9 19.8 37 32.7 63 32.7s49.1-12.9 63-32.7c13.9 19.8 37 32.7 63 32.7s49.1-12.9 63-32.7c13.9 19.8 37 32.7 63 32.7s49.1-12.9 63-32.7c13.9 19.8 37 32.7 63 32.7s49.1-12.9 63-32.7L532 420c0 61.9-50.1 112-112 112l-28 0 0-126c0-38.7-31.3-70-70-70l-84 0c-38.7 0-70 31.3-70 70l0 126-28 0C78.1 532 28 481.9 28 420l0-183.2zm7.6-56L81 89.9C100 52 138.8 28 181.2 28l197.6 0C421.2 28 460 52 479 89.9l45.4 90.8c-3.8 2.5-6.4 6.8-6.4 11.7 0 27.1-21.9 49-49 49s-49-21.9-49-49c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 27.1-21.9 49-49 49s-49-21.9-49-49c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 27.1-21.9 49-49 49s-49-21.9-49-49c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 27.1-21.9 49-49 49s-49-21.9-49-49c0-4.9-2.5-9.2-6.4-11.7zM196 406c0-23.2 18.8-42 42-42l84 0c23.2 0 42 18.8 42 42l0 126-168 0 0-126z", "M28 178.5c7.7 0 14 6.3 14 14 0 27.1 21.9 49 49 49s49-21.9 49-49c0-7.7 6.3-14 14-14s14 6.3 14 14c0 27.1 21.9 49 49 49s49-21.9 49-49c0-7.7 6.3-14 14-14s14 6.3 14 14c0 27.1 21.9 49 49 49s49-21.9 49-49c0-7.7 6.3-14 14-14s14 6.3 14 14c0 27.1 21.9 49 49 49s49-21.9 49-49c0-7.7 6.3-14 14-14s14 6.3 14 14c0 42.5-34.5 77-77 77-26 0-49.1-12.9-63-32.7-13.9 19.8-37 32.7-63 32.7s-49.1-12.9-63-32.7c-13.9 19.8-37 32.7-63 32.7s-49.1-12.9-63-32.7c-13.9 19.8-37 32.7-63 32.7-42.5 0-77-34.5-77-77 0-7.7 6.3-14 14-14zM196 406l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-38.7 31.3-70 70-70l84 0c38.7 0 70 31.3 70 70l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-23.2-18.8-42-42-42l-84 0c-23.2 0-42 18.8-42 42z"]],
    "film": [560, 560, [127902, 62368, "film-alt", "film-simple"], "f008", ["M0 168L0 392c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L112 56C50.1 56 0 106.1 0 168zm91-14a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm49-259c0-19.3 15.7-35 35-35l210 0c19.3 0 35 15.7 35 35l0 70c0 19.3-15.7 35-35 35l-210 0c-19.3 0-35-15.7-35-35l0-70zm0 196c0-19.3 15.7-35 35-35l210 0c19.3 0 35 15.7 35 35l0 70c0 19.3-15.7 35-35 35l-210 0c-19.3 0-35-15.7-35-35l0-70zm28-196l0 70c0 3.9 3.1 7 7 7l210 0c3.9 0 7-3.1 7-7l0-70c0-3.9-3.1-7-7-7l-210 0c-3.9 0-7 3.1-7 7zm0 196l0 70c0 3.9 3.1 7 7 7l210 0c3.9 0 7-3.1 7-7l0-70c0-3.9-3.1-7-7-7l-210 0c-3.9 0-7 3.1-7 7zM511 154a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm0 84a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M140 147c0-19.3 15.7-35 35-35l210 0c19.3 0 35 15.7 35 35l0 70c0 19.3-15.7 35-35 35l-210 0c-19.3 0-35-15.7-35-35l0-70zm35-7c-3.9 0-7 3.1-7 7l0 70c0 3.9 3.1 7 7 7l210 0c3.9 0 7-3.1 7-7l0-70c0-3.9-3.1-7-7-7l-210 0zM70 133a21 21 0 1 1 0 42 21 21 0 1 1 0-42zm0 84a21 21 0 1 1 0 42 21 21 0 1 1 0-42zM49 322a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm21 63a21 21 0 1 1 0 42 21 21 0 1 1 0-42zM469 238a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm21-105a21 21 0 1 1 0 42 21 21 0 1 1 0-42zM469 322a21 21 0 1 1 42 0 21 21 0 1 1 -42 0zm21 63a21 21 0 1 1 0 42 21 21 0 1 1 0-42zM175 308l210 0c19.3 0 35 15.7 35 35l0 70c0 19.3-15.7 35-35 35l-210 0c-19.3 0-35-15.7-35-35l0-70c0-19.3 15.7-35 35-35zm-7 35l0 70c0 3.9 3.1 7 7 7l210 0c3.9 0 7-3.1 7-7l0-70c0-3.9-3.1-7-7-7l-210 0c-3.9 0-7 3.1-7 7z"]],
    "comments": [560, 560, [128490, 61670], "f086", ["M0 201.6c0 47 17.8 90.2 47.8 124.4L28.5 399.3c-.4 1.4-.5 2.8-.5 4.2l0 .5c0 8.8 7.2 16 16 16 2.4 0 4.7-.5 6.9-1.6l74.8-35.6c29.7 13.1 63 20.4 98.3 20.4 123.7 0 224-90.3 224-201.6S347.7 0 224 0 0 90.3 0 201.6zm133-4.2a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm112 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm112 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M133 197.4a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm91 21a21 21 0 1 0 0-42 21 21 0 1 0 0 42zm277.8-32.1c-5.4-5.6-14.2-5.8-19.8-.4s-5.8 14.2-.4 19.8c31.6 33 50.4 75.6 50.4 121.9 0 50-21.9 95.7-58.1 129.5-3.2 3-4.8 7.3-4.4 11.6l6.2 61.3-57.6-30.1c-3.6-1.9-7.8-2.1-11.6-.6-25.8 10.2-54.4 15.8-84.5 15.8-69.5 0-130.8-30.2-168.9-76.1-4.9-6-13.8-6.8-19.7-1.8s-6.8 13.8-1.8 19.7c43.6 52.6 112.9 86.3 190.5 86.3 31.3 0 61.3-5.5 88.7-15.5l56.4 29.4c3.6 1.9 7.6 2.9 11.7 2.9 13.9 0 25.2-11.3 25.2-25.2l0-2.8c0-.5 0-.9-.1-1.4l-5.9-57.9c38.3-38.1 61.9-89 61.9-145.1 0-54.2-22.1-103.6-58.2-141.3zM336 218.4a21 21 0 1 0 0-42 21 21 0 1 0 0 42z"]],
    "moon": [560, 560, [127769, 9214], "f186", ["M0 280c0 154.6 125.4 280 280 280 113.8 0 211.8-67.9 255.6-165.5 9.5-21.1-13.1-40.6-35.8-35.9-16.7 3.5-34.1 5.3-51.8 5.3-139.2 0-252-112.8-252-252 0-17.8 1.8-35.1 5.3-51.8 4.7-22.7-14.7-45.3-35.9-35.8-97.5 43.8-165.5 141.7-165.5 255.6zm56 0c0-7.7 6.3-14 14-14s14 6.3 14 14c0 108.2 87.8 196 196 196 7.7 0 14 6.3 14 14s-6.3 14-14 14C156.3 504 56 403.7 56 280z", "M294 490c0 7.7-6.3 14-14 14-123.7 0-224-100.3-224-224 0-7.7 6.3-14 14-14s14 6.3 14 14c0 108.2 87.8 196 196 196 7.7 0 14 6.3 14 14zM434 28c7.7 0 14 6.3 14 14l0 70 70 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-70 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-70-70 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l70 0 0-70c0-7.7 6.3-14 14-14z"]],
    "pen": [560, 560, [128394], "f304", ["M28 410.4c0-29.7 11.8-58.2 32.8-79.2L309.8 82.3c5.1 2.1 9.8 5.1 13.9 9.2L480.1 247.9c-83.8 83.8-167.5 167.5-251.3 251.3-21 21-49.5 32.8-79.2 32.8L56 532c-2.5 0-4.9-.3-7.3-.9l31.2-31.2c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0L28.9 511.3c-.6-2.3-.9-4.7-.9-7.3l0-93.6zM330.5 61.5l26.7-26.7c22.3-22.3 52.5-34.8 84-34.8 65.6 0 118.8 53.2 118.8 118.8 0 31.5-12.5 61.7-34.8 84-8.4 8.4-16.9 16.9-25.3 25.3L343.5 71.7c-4-4-8.4-7.4-13-10.2z", "M343.5 71.7c-27.3-27.3-71.7-27.3-99 0l-72.4 72.4c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l72.4-72.4c16.4-16.4 43-16.4 59.4 0L480.1 247.9c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8L343.5 71.7zM79.9 499.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-56 56c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l56-56z"]],
    "plane": [672, 560, [], "f072", ["M0 156.3c0 4.7 .7 9.3 2.2 13.8L60.3 347.7c14.1 43.2 54.4 72.3 99.8 72.3l37.8 0 28-48.9c3.8-6.7 12.4-9 19.1-5.2s9 12.4 5.2 19.1l-20 35.1 142.1 0 51.9-51.9c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8L411.8 420 546 420c69.6 0 126-56.4 126-126 0-15.3-2.7-29.9-7.7-43.5-1.9 1-4 1.5-6.3 1.5l-84 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l76.8 0c-22.6-33.8-61.1-56-104.8-56l-378 0-102.4-51.2c-6.3-3.1-13.2-4.8-20.3-4.8l-1 0C19.8 112 0 131.8 0 156.3zM252 266a42 42 0 1 1 -84 0 42 42 0 1 1 84 0zm112 0a42 42 0 1 1 -84 0 42 42 0 1 1 84 0zm112 0a42 42 0 1 1 -84 0 42 42 0 1 1 84 0z", "M368.1 135.9L240.4 8.2C235.2 3 228 0 220.6 0L174.2 0c-10.7 0-17.5 11.6-12.2 20.9l56.1 98.1c3.8 6.7 1.5 15.3-5.2 19.1s-15.3 1.5-19.1-5.2L137.8 34.8C121.8 6.8 142-28 174.2-28l46.4 0c14.9 0 29.1 5.9 39.6 16.4L387.9 116.1c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0zm75.8 232.2c5.5 5.5 5.5 14.3 0 19.8L260.2 571.6c-10.5 10.5-24.7 16.4-39.6 16.4l-46.4 0c-32.2 0-52.5-34.8-36.5-62.8l88.1-154.1c3.8-6.7 12.4-9 19.1-5.2s9 12.4 5.2 19.1L162.1 539.1c-5.3 9.3 1.4 20.9 12.2 20.9l46.4 0c7.4 0 14.5-3 19.8-8.2L424.1 368.1c5.5-5.5 14.3-5.5 19.8 0zM210 280a14 14 0 1 0 0-28 14 14 0 1 0 0 28zm0-56a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm126 42a14 14 0 1 0 -28 0 14 14 0 1 0 28 0zm-56 0a42 42 0 1 1 84 0 42 42 0 1 1 -84 0zm154 14a14 14 0 1 0 0-28 14 14 0 1 0 0 28zm0-56a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm140 0l84 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-84 0c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "images": [672, 560, [], "f302", ["M140 140l0 174.5 115.9-135.2c27.5-32.1 76.9-32.7 105.2-1.3L570.4 410.6c5.2 5.7 4.7 14.6-1 19.8s-14.6 4.7-19.8-1L340.2 196.8c-17-18.8-46.6-18.5-63.1 .8L150.6 345.1c-2.8 3.2-6.7 4.9-10.6 4.9l0 14c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L252 28c-61.9 0-112 50.1-112 112zm448 14a70 70 0 1 1 -140 0 70 70 0 1 1 140 0zm-112 0a42 42 0 1 0 84 0 42 42 0 1 0 -84 0z", "M476 154a42 42 0 1 0 84 0 42 42 0 1 0 -84 0zm42 70a70 70 0 1 1 0-140 70 70 0 1 1 0 140zM476 546c0 7.7-6.3 14-14 14l-336 0C56.4 560 0 503.6 0 434L0 210c0-54.1 43.9-98 98-98 7.7 0 14 6.3 14 14s-6.3 14-14 14c-38.7 0-70 31.3-70 70l0 224c0 54.1 43.9 98 98 98l336 0c7.7 0 14 6.3 14 14zM340.2 196.8c-17-18.8-46.6-18.5-63.1 .8L150.6 345.1c-5 5.9-13.9 6.5-19.7 1.5s-6.6-13.9-1.5-19.7L255.9 179.3c27.5-32.1 76.9-32.7 105.2-1.3L570.4 410.6c5.2 5.7 4.7 14.6-1 19.8s-14.6 4.7-19.8-1L340.2 196.8z"]],
    "bag-shopping": [448, 560, ["shopping-bag"], "f290", ["M0 196L0 448c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-252c0-30.9-25.1-56-56-56l-56 0 0 14c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-14-168 0 0 14c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-14-56 0c-30.9 0-56 25.1-56 56zm147 42a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm196 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M168 28c-15.5 0-28 12.5-28 28l0 98c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-98c0-30.9 25.1-56 56-56L280 0c30.9 0 56 25.1 56 56l0 98c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-98c0-15.5-12.5-28-28-28L168 28zM126 259a21 21 0 1 1 0-42 21 21 0 1 1 0 42zm175-21a21 21 0 1 1 42 0 21 21 0 1 1 -42 0z"]],
    "phone": [336, 560, [128222, 128379], "f095", ["M0 273.9l0 12.1c0 51.7 7.2 103.1 21.4 152.9 20.5 71.7 86 121.1 160.5 121.1l42.1 0 0-182c-15.7-2.6-31.3-5.2-47-7.8-12-59.2-12-121.1 0-180.3l47-7.8 0-182-42.1 0C107.4 0 41.9 49.4 21.4 121.1 7.2 170.8 0 222.2 0 273.9zM252 0l0 177.3 9.2-1.5c27-4.5 46.8-27.9 46.8-55.2L308 56c0-30.9-25.1-56-56-56zm0 382.7L252 560c30.9 0 56-25.1 56-56l0-64.6c0-27.4-19.8-50.7-46.8-55.2l-9.2-1.5z", "M224 0c0-7.7 6.3-14 14-14s14 6.3 14 14l0 182c0 7.7-6.3 14-14 14s-14-6.3-14-14L224 0zm0 378c0-7.7 6.3-14 14-14s14 6.3 14 14l0 182c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-182z"]],
    "leaf": [504, 560, [], "f06c", ["M28.4 273.4c0 58.6 21.9 112.2 57.9 152.8l110.1-110.1 0-134.2c0-7.7 6.3-14 14-14s14 6.3 14 14l0 106.2 102.1-102.1c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8L106.1 446.1c40.7 36 94.2 57.9 152.8 57.9 122.1 0 223-95.2 230.2-217L500.7 90.9c2-33.5-25.7-61.2-59.2-59.2L245.4 43.2c-121.9 7.2-217 108.1-217 230.2z", "M224.4 182c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 134.2-177.9 177.9c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l308-308c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-102.1 102.1 0-106.2z"]],
    "universal-access": [560, 560, [], "f29a", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm154-14c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-56 0 1.8 181.9c.1 7.7-6.1 14.1-13.9 14.1s-14.1-6.1-14.1-13.9l-.7-70.1-58.2 0-.7 70.1c-.1 7.7-6.4 13.9-14.1 13.9s-13.9-6.4-13.9-14.1l1.7-181.9-56 0c-7.7 0-14-6.3-14-14zm182-98a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM251.2 364l57.6 0c-.3-28-.5-55.9-.8-84l-56 0c-.3 28.1-.5 56-.8 84zm.8-196a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M252 168a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm84 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM168 252c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0-1.7 181.9c-.1 7.7 6.1 14.1 13.9 14.1s14.1-6.1 14.1-13.9l.7-70.1 58.2 0 .7 70.1c.1 7.7 6.4 13.9 14.1 13.9s13.9-6.4 13.9-14.1L336 280 392 280c7.7 0 14-6.3 14-14s-6.3-14-14-14l-224 0zm140 28l0 .1 .8 83.9-57.6 0 .8-83.9 0-.1 56 0z"]],
    "hourglass": [504, 560, [9203, 62032, "hourglass-empty"], "f254", ["M56 28l392 0 0 54.3c0 19.3-5.7 38.3-16.5 54.4l-80 120c-9.4 14.1-9.4 32.5 0 46.6l80 120c10.7 16.1 16.5 35 16.5 54.4l0 61.3-392 0 0-61.3c0-19.3 5.7-38.3 16.5-54.4l80-120c9.4-14.1 9.4-32.5 0-46.6l-80-120C61.7 120.6 56 101.7 56 82.3L56 28z", "M28 0C20.3 0 14 6.3 14 14s6.3 14 14 14l448 0c7.7 0 14-6.3 14-14S483.7 0 476 0L28 0zm0 539c-7.7 0-14 6.3-14 14s6.3 14 14 14l448 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L28 539z"]],
    "fish": [616, 560, [128031], "f578", ["M0 390.7c0 6.8 2.7 13.3 7.5 18.1L179.2 580.5c4.8 4.8 11.3 7.5 18.1 7.5 12 0 22.4-8.3 25-20L244 471.4c2.9-12.8 14.2-21.9 27.3-21.9l64.7 0c123.7 0 224-100.3 224-224L560 112c0-46.4-37.6-84-84-84L362.4 28c-123.7 0-224 100.3-224 224l0 64.7c0 13.1-9.1 24.4-21.9 27.3L20 365.7c-11.7 2.6-20 13-20 25zM462 182a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M406 154a28 28 0 1 1 0 56 28 28 0 1 1 0-56zm0 84a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]],
    "chart-simple": [560, 560, [], "e473", ["M0 252L0 364c0 46.4 37.6 84 84 84s84-37.6 84-84l0-112c0-46.4-37.6-84-84-84S0 205.6 0 252zM196 112l0 252c0 46.4 37.6 84 84 84s84-37.6 84-84l0-252c0-46.4-37.6-84-84-84s-84 37.6-84 84zm196 56l0 196c0 46.4 37.6 84 84 84s84-37.6 84-84l0-196c0-46.4-37.6-84-84-84s-84 37.6-84 84z", "M0 518c0-7.7 6.3-14 14-14l532 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L14 532c-7.7 0-14-6.3-14-14z"]],
    "list": [504, 560, ["list-squares"], "f03a", ["M0 112c0 46.4 37.6 84 84 84 41.6 0 76.2-30.3 82.8-70L84 126c-7.7 0-14-6.3-14-14s6.3-14 14-14l82.8 0C160.2 58.3 125.6 28 84 28 37.6 28 0 65.6 0 112zM0 280c0 46.4 37.6 84 84 84 41.6 0 76.2-30.3 82.8-70L84 294c-7.7 0-14-6.3-14-14s6.3-14 14-14l82.8 0c-6.7-39.7-41.2-70-82.8-70-46.4 0-84 37.6-84 84zM0 448c0 46.4 37.6 84 84 84 41.6 0 76.2-30.3 82.8-70L84 462c-7.7 0-14-6.3-14-14s6.3-14 14-14l82.8 0c-6.7-39.7-41.2-70-82.8-70-46.4 0-84 37.6-84 84z", "M70 112c0-7.7 6.3-14 14-14l364 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L84 126c-7.7 0-14-6.3-14-14zm0 168c0-7.7 6.3-14 14-14l364 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L84 294c-7.7 0-14-6.3-14-14zm0 168c0-7.7 6.3-14 14-14l364 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L84 462c-7.7 0-14-6.3-14-14z"]],
    "headphones": [504, 560, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", ["M0 378l0 84c0 38.7 31.3 70 70 70s70-31.3 70-70l0-140c0-38.7-31.3-70-70-70-15.8 0-30.3 5.2-42 14l0 112c0 7.7-6.3 14-14 14S0 385.7 0 378zm364-56l0 140c0 38.7 31.3 70 70 70s70-31.3 70-70l0-84c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-112c-11.7-8.8-26.2-14-42-14-38.7 0-70 31.3-70 70z", "M490 392c-7.7 0-14-6.3-14-14l0-126C476 128.3 375.7 28 252 28S28 128.3 28 252l0 126c0 7.7-6.3 14-14 14S0 385.7 0 378L0 252C0 112.8 112.8 0 252 0S504 112.8 504 252l0 126c0 7.7-6.3 14-14 14z"]],
    "bus": [448, 560, [128653], "f207", ["M0 112L0 420c0 30.9 25.1 56 56 56l336 0c30.9 0 56-25.1 56-56l0-308C448 50.1 397.9 0 336 0L112 0C50.1 0 0 50.1 0 112zm56 0c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 84c0 30.9-25.1 56-56 56l-224 0c-30.9 0-56-25.1-56-56l0-84zM168 364a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zM84 112l0 84c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-84c0-15.5-12.5-28-28-28L112 84c-15.5 0-28 12.5-28 28zm0 252a28 28 0 1 0 56 0 28 28 0 1 0 -56 0zm308 0a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M112 84c-15.5 0-28 12.5-28 28l0 84c0 15.5 12.5 28 28 28l224 0c15.5 0 28-12.5 28-28l0-84c0-15.5-12.5-28-28-28L112 84zM56 112c0-30.9 25.1-56 56-56l224 0c30.9 0 56 25.1 56 56l0 84c0 30.9-25.1 56-56 56l-224 0c-30.9 0-56-25.1-56-56l0-84zm84 252a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM70 546l0-70 28 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14zm294 0l0-70 28 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14zM336 392a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm0-84a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]],
    "quote-left": [560, 560, [8220, "quote-left-alt"], "f10d", ["M6.2 501.6c2.2 1.5 4.9 2.4 7.8 2.4 7.7 0 14-6.3 14-14l0-202.5c8.2-4.8 17.8-7.5 28-7.5l140 0c30.9 0 56 25.1 56 56l0 140c0 30.9-25.1 56-56 56L56 532c-21.7 0-40.5-12.3-49.8-30.4zm308 0c2.2 1.5 4.9 2.4 7.8 2.4 7.7 0 14-6.3 14-14l0-202.5c8.2-4.8 17.8-7.5 28-7.5l140 0c30.9 0 56 25.1 56 56l0 140c0 30.9-25.1 56-56 56l-140 0c-21.7 0-40.5-12.3-49.8-30.4z", "M98 56C43.9 56 0 99.9 0 154L0 490c0 7.7 6.3 14 14 14s14-6.3 14-14l0-336c0-38.7 31.3-70 70-70l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L98 56zm308 0c-54.1 0-98 43.9-98 98l0 336c0 7.7 6.3 14 14 14s14-6.3 14-14l0-336c0-38.7 31.3-70 70-70l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0z"]],
    "martini-glass": [560, 560, [127864, "glass-martini-alt"], "f57b", ["M0 78.1c0 12.8 4.9 25.1 13.7 34.4l219 231.2c9 9.5 20.6 16 33.3 18.8l0-12.5c0-7.7 6.3-14 14-14s14 6.3 14 14l0 12.5c12.6-2.8 24.2-9.3 33.3-18.8l219-231.2c8.8-9.3 13.7-21.6 13.7-34.4 0-27.6-22.4-50.1-50.1-50.1L50.1 28C22.4 28 0 50.4 0 78.1zM280 196a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M196 196a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm84 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm14 154c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 168-70 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l168 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-70 0 0-168z"]],
    "rectangle-wide": [616, 560, [], "f2fc", ["M0 196L0 364c0 61.9 50.1 112 112 112l392 0c61.9 0 112-50.1 112-112l0-168c0-61.9-50.1-112-112-112L112 84C50.1 84 0 134.1 0 196zm56 14c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126z", "M266 154c0 7.7-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14z"]],
    "angle-down": [560, 560, [8964], "f107", ["M0 154c0 9.1 2.9 17.9 8.4 25.2L235.2 481.6C245.8 495.7 262.4 504 280 504s34.2-8.3 44.8-22.4L551.6 179.2c5.5-7.3 8.4-16.1 8.4-25.2 0-23.2-18.8-42-42-42l-70 0c0 2.9-.9 5.8-2.7 8.3l-154 210c-2.6 3.6-6.8 5.7-11.3 5.7s-8.7-2.1-11.3-5.7l-154-210c-1.8-2.5-2.7-5.4-2.7-8.3l-70 0c-23.2 0-42 18.8-42 42zm143.4-42L280 298.3 416.6 112 143.4 112z", "M117.7 100.7c6.2-4.6 15-3.2 19.6 3L280 298.3 422.7 103.7c4.6-6.2 13.3-7.6 19.6-3s7.6 13.3 3 19.6l-154 210c-2.6 3.6-6.8 5.7-11.3 5.7s-8.7-2.1-11.3-5.7l-154-210c-4.6-6.2-3.2-15 3-19.6z"]],
    "chart-pie": [616, 560, ["pie-chart"], "f200", ["M28 280C28 134.8 138.5 15.4 280 1.4L280 238c0 38.7 31.3 70 70 70l236.6 0C572.6 449.5 453.2 560 308 560 153.4 560 28 434.6 28 280zM308 14c146.9 0 266 119.1 266 266l-224 0c-23.2 0-42-18.8-42-42l0-224z", "M293.3-13.6c4.9-.2 9.8-.4 14.7-.4 162.4 0 294 131.6 294 294 0 4.9-.1 9.8-.4 14.7-.4 7.5-6.5 13.3-14 13.3L350 308c-38.7 0-70-31.3-70-70L280 .3c0-7.5 5.9-13.6 13.3-14zM308 14l0 224c0 23.2 18.8 42 42 42l224 0C574 133.1 454.9 14 308 14z"]],
    "inbox": [560, 560, [], "f01c", ["M28 364l0 56c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-56-168 0c0 46.4-37.6 84-84 84s-84-37.6-84-84L28 364zm.5-28L210 336c7.7 0 14 6.3 14 14l0 14c0 30.9 25.1 56 56 56s56-25.1 56-56l0-14c0-7.7 6.3-14 14-14l181.5 0c-.3-3.3-.8-6.6-1.3-9.9L492.7 120C483 66.7 436.7 28 382.5 28L177.5 28C123.3 28 77 66.7 67.3 120L29.8 326.1c-.6 3.3-1 6.6-1.4 9.9z", "M14 350c0-7.7 6.3-14 14-14l182 0c7.7 0 14 6.3 14 14l0 14c0 30.9 25.1 56 56 56s56-25.1 56-56l0-14c0-7.7 6.3-14 14-14l182 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-168 0c0 46.4-37.6 84-84 84s-84-37.6-84-84L28 364c-7.7 0-14-6.3-14-14z"]],
    "credit-card": [616, 560, [128179, 62083, "credit-card-alt"], "f09d", ["M28 196l560 0c0-61.9-50.1-112-112-112L140 84C78.1 84 28 134.1 28 196zm0 28l0 168c0 61.9 50.1 112 112 112l336 0c61.9 0 112-50.1 112-112l0-168-560 0zM392 364c0-30.9 25.1-56 56-56l28 0c30.9 0 56 25.1 56 56l0 28c0 30.9-25.1 56-56 56l-28 0c-30.9 0-56-25.1-56-56l0-28zm28 0l0 28c0 15.5 12.5 28 28 28l28 0c15.5 0 28-12.5 28-28l0-28c0-15.5-12.5-28-28-28l-28 0c-15.5 0-28 12.5-28 28z", "M28 196l560 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L28 224c-7.7 0-14-6.3-14-14s6.3-14 14-14zM448 336c-15.5 0-28 12.5-28 28l0 28c0 15.5 12.5 28 28 28l28 0c15.5 0 28-12.5 28-28l0-28c0-15.5-12.5-28-28-28l-28 0zm-56 28c0-30.9 25.1-56 56-56l28 0c30.9 0 56 25.1 56 56l0 28c0 30.9-25.1 56-56 56l-28 0c-30.9 0-56-25.1-56-56l0-28z"]],
    "wand-magic-sparkles": [560, 560, ["magic-wand-sparkles"], "e2ca", ["M25.6 394.4c86.2-86.2 172.3-172.3 258.5-258.5l140 140c-86.2 86.2-172.3 172.3-258.5 258.5-21.9 21.9-57.3 21.9-79.2 0L25.6 473.6c-21.9-21.9-21.9-57.3 0-79.2zM303.9 116.1c30.2-30.2 60.3-60.3 90.5-90.5 21.9-21.9 57.3-21.9 79.2 0l60.8 60.8c21.9 21.9 21.9 57.3 0 79.2-30.2 30.2-60.3 60.3-90.5 90.5l-140-140z", "M490 308c-7.7 0-14 6.3-14 14l0 42-42 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l42 0 0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42 42 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-42 0 0-42c0-7.7-6.3-14-14-14zM210 0c-7.7 0-14 6.3-14 14l0 42-42 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l42 0 0 42c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42 42 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-42 0 0-42c0-7.7-6.3-14-14-14zm93.9 116.1c-5.5-5.5-14.3-5.5-19.8 0s-5.5 14.3 0 19.8l140 140c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-140-140z"]],
    "folders": [672, 560, [], "f660", ["M140 140l0 28 489 0c-19.4-33.5-55.6-56-97-56l-34.7 0c-31.4 0-61.3-13.2-82.6-36.3L404.3 64.3C383.1 41.2 353.1 28 321.7 28L252 28c-61.9 0-112 50.1-112 112zm0 56c0 56 0 112 0 168 0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-140c0-9.7-1.2-19.1-3.5-28L140 196z", "M462 560c7.7 0 14-6.3 14-14s-6.3-14-14-14l-336 0c-54.1 0-98-43.9-98-98l0-224c0-38.7 31.3-70 70-70 7.7 0 14-6.3 14-14s-6.3-14-14-14c-54.1 0-98 43.9-98 98L0 434c0 69.6 56.4 126 126 126l336 0zM140 168c-7.7 0-14 6.3-14 14s6.3 14 14 14l504 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-504 0z"]],
    "star": [616, 560, [11088, 61446], "f005", ["M13.7 241L120.9 347.7c2.1 2.1 3.1 5.2 2.7 8.2L100.2 505.2c-5.8 37.1 32.7 65.3 66.3 48.5l137.3-68.6c2.7-1.3 5.8-1.3 8.5 0l137.3 68.6c33.6 16.8 72.1-11.4 66.3-48.5L492.4 355.9c-.5-3 .5-6 2.7-8.2L602.3 241c26.8-26.6 12-72.4-25.3-78.4L426.2 138.5c-3-.5-5.5-2.3-6.9-5L349-1.7c-17.3-33.2-64.7-33.2-82 0L196.7 133.5c-1.4 2.7-3.9 4.5-6.9 5L39 162.6c-37.3 6-52.1 51.7-25.3 78.4zm57-28.3c1.6-5 5.9-8.7 11.1-9.5l106-17c20.3-3.2 37.8-15.9 47.2-34.1l49.8-95.8c3.6-6.9 12-9.5 18.9-6s9.5 12 6 18.9l-49.8 95.8c-13.6 26.1-38.6 44.2-67.7 48.8l-78.8 12.6 55.6 55.3c21.1 21 30.8 50.8 26.2 80.1-1.2 7.6-8.4 12.9-16 11.7s-12.9-8.4-11.7-16c3.2-20.5-3.6-41.3-18.3-55.9L74.1 226.9c-3.7-3.7-5.1-9.2-3.4-14.2z", "M303.7 50.3c6.9 3.6 9.5 12 6 18.9l-49.8 95.8c-13.6 26.1-38.6 44.2-67.7 48.8l-78.8 12.6 55.6 55.3c21.1 21 30.8 50.8 26.2 80.1-1.2 7.6-8.4 12.9-16 11.7s-12.9-8.4-11.7-16c3.2-20.5-3.6-41.3-18.3-55.9L74.1 226.9c-3.7-3.7-5.1-9.2-3.4-14.2s5.9-8.7 11.1-9.5l106-17c20.3-3.2 37.8-15.9 47.2-34.1l49.8-95.8c3.6-6.9 12-9.5 18.9-6z"]],
    "flag": [448, 560, [127988, 61725], "f024", ["M28 56l0 336 382.2 0c20.9 0 37.8-16.9 37.8-37.8 0-11.5-5.2-22.4-14.2-29.5l-71.1-56.9c-28-22.4-28-65 0-87.5l71.1-56.9c9-7.2 14.2-18 14.2-29.5 0-20.9-16.9-37.8-37.8-37.8L28 56z", "M14 0c7.7 0 14 6.3 14 14l0 532c0 7.7-6.3 14-14 14S0 553.7 0 546L0 14C0 6.3 6.3 0 14 0z"]],
    "triangle-exclamation": [560, 560, [9888, "exclamation-triangle", "warning"], "f071", ["M0 465.5C0 502.2 29.8 532 66.5 532l427.1 0c36.7 0 66.5-29.8 66.5-66.5 0-11.5-3-22.8-8.6-32.8L342.7 64.5C329.9 42 306 28 280 28s-49.9 14-62.7 36.5L8.6 432.8C3 442.7 0 454 0 465.5zM301 420a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zM266 182c0-7.7 6.3-14 14-14s14 6.3 14 14l0 168c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-168z", "M280 441a21 21 0 1 1 0-42 21 21 0 1 1 0 42zm14-91c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-168c0-7.7 6.3-14 14-14s14 6.3 14 14l0 168z"]],
    "lock": [504, 560, [128274], "f023", ["M0 280L0 448c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-168c0-61.9-50.1-112-112-112l-28 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-70-168 0 0 70c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-70-28 0C50.1 168 0 218.1 0 280z", "M252 28c-46.4 0-84 37.6-84 84l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126C140 50.1 190.1 0 252 0S364 50.1 364 112l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-126c0-46.4-37.6-84-84-84z"]],
    "anchor": [616, 560, [9875], "f13d", ["M28.3 267.8L146.7 327c19.1 65.6 77.1 114.6 147.3 120.4l0 42.6c0 7.7 6.3 14 14 14s14-6.3 14-14l0-42.6c70.3-5.8 128.3-54.8 147.3-120.4l118.4-59.2c.2 4.1 .3 8.1 .3 12.2 0 154.6-125.4 280-280 280S28 434.6 28 280c0-4.1 .1-8.2 .3-12.2z", "M252 84a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm70 82.8c39.7-6.7 70-41.2 70-82.8 0-46.4-37.6-84-84-84s-84 37.6-84 84c0 41.6 30.3 76.2 70 82.8L294 490c0 7.7 6.3 14 14 14s14-6.3 14-14l0-323.2zM15.5 245.7c-3.5 6.9-.7 15.3 6.3 18.8l140 70c6.9 3.5 15.3 .7 18.8-6.3s.7-15.3-6.3-18.8l-140-70c-6.9-3.5-15.3-.7-18.8 6.3zm578.8 18.8c6.9-3.5 9.7-11.9 6.3-18.8s-11.9-9.7-18.8-6.3l-140 70c-6.9 3.5-9.7 11.9-6.3 18.8s11.9 9.7 18.8 6.3l140-70z"]],
    "scissors": [560, 560, [9984, 9986, 9988, "cut"], "f0c4", ["M0 126c0 69.6 56.4 126 126 126 36.7 0 69.7-15.7 92.7-40.7l-101-74.1c-6.2-4.6-7.6-13.3-3-19.6s13.3-7.6 19.6-3l101 74.1C245.9 170.3 252 148.9 252 126 252 56.4 195.6 0 126 0S0 56.4 0 126zM0 434c0 69.6 56.4 126 126 126s126-56.4 126-126c0-22.9-6.1-44.3-16.7-62.8l-101 74.1c-6.2 4.6-15 3.2-19.6-3s-3.2-15 3-19.6l101-74.1c-23-25-56-40.7-92.7-40.7-69.6 0-126 56.4-126 126z", "M114.7 117.7c4.6-6.2 13.3-7.6 19.6-3L336 262.6 537.7 114.7c6.2-4.6 15-3.2 19.6 3s3.2 15-3 19.6L359.7 280 554.3 422.7c6.2 4.6 7.6 13.3 3 19.6s-13.3 7.6-19.6 3L336 297.4 134.3 445.3c-6.2 4.6-15 3.2-19.6-3s-3.2-15 3-19.6L312.3 280 117.7 137.3c-6.2-4.6-7.6-13.3-3-19.6z"]],
    "bug": [504, 560, [], "f188", ["M51.7 322L70 322c7.7 0 14-6.3 14-14s-6.3-14-14-14l-15.6 0 9.3-84 6.2 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-2.7 0c10.4-57.3 46.5-104.9 95.4-131.4l5.7 22.8c1.9 7.5 9.5 12.1 17 10.2s12.1-9.5 10.2-17L188.7 39c19.8-7.1 41.2-11 63.3-11s43.5 3.9 63.3 11l-6.9 27.6c-1.9 7.5 2.7 15.1 10.2 17s15.1-2.7 17-10.2l5.7-22.8c48.9 26.5 85 74.1 95.4 131.4l-2.7 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l6.2 0 9.3 84-15.6 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l18.3 0c1.4 29.6-3.7 58.1-14.1 84l-4.2 0c-7.7 0-14 6.3-14 14 0 4.7 2.3 8.9 5.9 11.4-32.3 56-90.9 95.4-159.9 100.1L266 224c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 307.5c-68.9-4.7-127.6-44.1-159.9-100.1 3.6-2.5 5.9-6.7 5.9-11.4 0-7.7-6.3-14-14-14l-4.2 0c-10.4-25.9-15.5-54.4-14.1-84z", "M181.6 10.6c-1.9-7.5-9.5-12.1-17-10.2s-12.1 9.5-10.2 17l14 56c1.9 7.5 9.5 12.1 17 10.2s12.1-9.5 10.2-17l-14-56zM14 182c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0zM0 420c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zm504 0c0-7.7-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14zm0-224c0-7.7-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14zM14 294c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0zm406 14c0 7.7 6.3 14 14 14l56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0c-7.7 0-14 6.3-14 14zM339.4 .4c-7.5-1.9-15.1 2.7-17 10.2l-14 56c-1.9 7.5 2.7 15.1 10.2 17s15.1-2.7 17-10.2l14-56c1.9-7.5-2.7-15.1-10.2-17zM266 224c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 308c0 7.7 6.3 14 14 14s14-6.3 14-14l0-308z"]],
    "arrow-right-from-bracket": [560, 560, ["sign-out"], "f08b", ["M0 56L0 504c0 30.9 25.1 56 56 56l122.7 0c25 0 45.3-20.3 45.3-45.3 0-7-1.6-14-4.8-20.3L124.5 305c-1.8-3.6-3.2-7.3-4.1-11L84 294c-7.7 0-14-6.3-14-14s6.3-14 14-14l36.4 0c1-3.8 2.4-7.5 4.1-11L219.2 65.6c3.1-6.3 4.8-13.2 4.8-20.3 0-25-20.3-45.3-45.3-45.3L56 0C25.1 0 0 25.1 0 56z", "M382.5 101.7c-5.7 5.2-6.1 14.1-.9 19.8L514.2 266 84 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l430.2 0-132.5 144.5c-5.2 5.7-4.8 14.6 .9 19.8s14.6 4.8 19.8-.9l154-168c4.9-5.4 4.9-13.6 0-18.9l-154-168c-5.2-5.7-14.1-6.1-19.8-.9z"]],
    "arrow-right-arrow-left": [560, 560, [8644, "exchange"], "f0ec", ["M0 392c0 13.2 6.4 25.5 17.1 33.2l180 128.4c5.9 4.2 12.9 6.4 20.2 6.4 19.2 0 34.7-15.5 34.7-34.7l0-119.3-126 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l126 0 0-119.3c0-19.2-15.5-34.7-34.7-34.7-7.2 0-14.3 2.3-20.2 6.4L17.1 358.8C6.4 366.5 0 378.8 0 392zM308 34.7l0 119.3 126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0 0 119.3c0 19.2 15.5 34.7 34.7 34.7 7.2 0 14.3-2.3 20.2-6.4l180-128.4c10.7-7.6 17.1-20 17.1-33.2s-6.4-25.5-17.1-33.2L362.9 6.4C357 2.3 349.9 0 342.7 0 323.5 0 308 15.5 308 34.7z", "M434 154c7.7 0 14 6.3 14 14s-6.3 14-14 14L14 182c-7.7 0-14-6.3-14-14s6.3-14 14-14l420 0zM126 378l420 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-420 0c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "arrow-up-from-line": [560, 560, [8613, "arrow-from-bottom"], "f342", ["M0 448l0 56c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56l-210 0 0 84c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-84-210 0c-30.9 0-56 25.1-56 56z", "M101.7 177.5c5.2 5.7 14.1 6.1 19.8 .9L266 45.8 266 476c0 7.7 6.3 14 14 14s14-6.3 14-14l0-430.2 144.5 132.5c5.7 5.2 14.6 4.8 19.8-.9s4.8-14.6-.9-19.8l-168-154c-5.4-4.9-13.6-4.9-18.9 0l-168 154c-5.7 5.2-6.1 14.1-.9 19.8z"]],
    "battery-full": [560, 560, [128267, "battery", "battery-5"], "f240", ["M0 196L0 364c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l14 0 0-112-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l14 0c0-61.9-50.1-112-112-112L112 84C50.1 84 0 134.1 0 196zm56 0c0-30.9 25.1-56 56-56l280 0c30.9 0 56 25.1 56 56l0 168c0 30.9-25.1 56-56 56l-280 0c-30.9 0-56-25.1-56-56l0-168zm28 0l0 168c0 15.5 12.5 28 28 28l280 0c15.5 0 28-12.5 28-28l0-168c0-15.5-12.5-28-28-28l-280 0c-15.5 0-28 12.5-28 28z", "M112 168c-15.5 0-28 12.5-28 28l0 168c0 15.5 12.5 28 28 28l280 0c15.5 0 28-12.5 28-28l0-168c0-15.5-12.5-28-28-28l-280 0zM56 196c0-30.9 25.1-56 56-56l280 0c30.9 0 56 25.1 56 56l0 168c0 30.9-25.1 56-56 56l-280 0c-30.9 0-56-25.1-56-56l0-168zm462 28l-28 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l28 0c23.2 0 42 18.8 42 42l0 84c0 23.2-18.8 42-42 42l-28 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l28 0c7.7 0 14-6.3 14-14l0-84c0-7.7-6.3-14-14-14z"]],
    "font": [560, 560, [], "f031", ["M84 210l0 154 196 0 0-154c0-54.1-43.9-98-98-98s-98 43.9-98 98zM336 392c0 61.9 50.1 112 112 112 33.5 0 63.5-14.7 84-37.9l0-148.2c-20.5-23.3-50.5-37.9-84-37.9-61.9 0-112 50.1-112 112z", "M84 210c0-54.1 43.9-98 98-98s98 43.9 98 98l0 266-28 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l84 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-28 0 0-266c0-69.6-56.4-126-126-126S56 140.4 56 210l0 266-21 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l84 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-35 0 0-266zm294-42c-7.7 0-14 6.3-14 14s6.3 14 14 14l112 0c23.2 0 42 18.8 42 42l0 252c0 7.7 6.3 14 14 14s14-6.3 14-14l0-252c0-38.7-31.3-70-70-70l-112 0z"]],
    "language": [560, 560, [], "f1ab", ["M140 515.3c0 24.7 20 44.7 44.7 44.7l330.6 0c24.7 0 44.7-20 44.7-44.7 0-7.4-1.9-14.7-5.4-21.3L391.3 192.6C383.1 177.5 367.3 168 350 168s-33.1 9.5-41.3 24.6L239.2 320.8c10.2 3.8 20.7 7 31.5 9.4l26.5 6.1c7.5 1.7 12.2 9.3 10.5 16.8s-9.3 12.2-16.8 10.5l-26.5-6.1c-13.3-3.1-26.2-7-38.6-11.9L145.4 494c-3.5 6.5-5.4 13.8-5.4 21.3z", "M167 14c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42-125 0C6.3 56 0 62.3 0 70S6.3 84 14 84l220.8 0-4.7 22.2c-12.4 59.1-42.5 112.1-85.2 152.6-28.7-29.9-50.1-67-61.4-108.5-2-7.5-9.7-11.9-17.2-9.8s-11.9 9.7-9.8 17.2c12.4 45.6 35.8 86.4 67.2 119.4-19.9 15.6-42.1 28.8-65.9 39l-49.3 21c-7.1 3-10.4 11.3-7.4 18.4s11.3 10.4 18.4 7.4l49.3-21c27.4-11.7 52.7-27 75.4-45.2 33.9 29.2 75 50.5 120.2 60.9l26.5 6.1c7.5 1.7 15.1-3 16.8-10.5s-3-15.1-10.5-16.8l-26.5-6.1c-39.4-9.1-75.3-27.3-105.3-52.3 46-44.2 78.6-101.8 92.1-166l5.9-27.9 31.4 0c7.7 0 14-6.3 14-14s-6.3-14-14-14L167 56 167 14z"]],
    "person-biking": [560, 560, [128692, "biking"], "f84a", ["M0 420a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm133 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm203 0a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zm133 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M364 56a28 28 0 1 1 0 56 28 28 0 1 1 0-56zm0 84a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM112 399a21 21 0 1 0 0 42 21 21 0 1 0 0-42zm336 42a21 21 0 1 0 0-42 21 21 0 1 0 0 42zM274.3 179.5c4.6-4.6 11.7-5.4 17.2-2.1l59.5 36.3c11 6.7 23.6 10.2 36.5 10.2l46.5 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-46.5 0c-7.7 0-15.3-2.1-21.9-6.1l-59.5-36.3c-16.6-10.1-37.9-7.6-51.6 6.2l-55.6 55.6c-20 20-14.9 53.6 10.1 66.8l48.6 25.6c13.8 7.3 22.4 21.6 22.4 37.1l0 90.7c0 7.7 6.3 14 14 14s14-6.3 14-14l0-90.7c0-26-14.4-49.8-37.3-61.9l-48.6-25.6c-8.3-4.4-10-15.6-3.4-22.3l55.6-55.6z"]],
    "globe": [560, 560, [127760], "f0ac", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm14 0c0-7.7 6.3-14 14-14l112.2 0c2.1-87.8 24-166.4 58.2-217.8 4.3-6.4 13-8.2 19.4-3.9s8.2 13 3.9 19.4c-30.4 45.6-51.3 118.4-53.5 202.2l223.6 0c-2.1-83.9-23.1-156.6-53.5-202.2-4.3-6.4-2.5-15.1 3.9-19.4s15.1-2.5 19.4 3.9c34.2 51.3 56.1 129.9 58.2 217.8L532 266c7.7 0 14 6.3 14 14s-6.3 14-14 14l-112.2 0c-2.1 87.8-24 166.4-58.2 217.8-4.3 6.4-13 8.2-19.4 3.9s-8.2-13-3.9-19.4c30.4-45.6 51.4-118.4 53.5-202.2l-223.6 0c2.1 83.9 23.1 156.6 53.5 202.2 4.3 6.4 2.5 15.1-3.9 19.4s-15.1 2.5-19.4-3.9c-34.2-51.3-56.1-129.9-58.2-217.8L28 294c-7.7 0-14-6.3-14-14z", "M221.6 63.8c4.3-6.4 2.5-15.1-3.9-19.4s-15.1-2.5-19.4 3.9C164.2 99.6 142.3 178.2 140.2 266L28 266c-7.7 0-14 6.3-14 14s6.3 14 14 14l112.2 0c2.1 87.8 24 166.4 58.2 217.8 4.3 6.4 13 8.2 19.4 3.9s8.2-13 3.9-19.4c-30.4-45.6-51.3-118.4-53.5-202.2l223.6 0c-2.1 83.9-23.1 156.6-53.5 202.2-4.3 6.4-2.5 15.1 3.9 19.4s15.1 2.5 19.4-3.9c34.2-51.3 56.1-129.9 58.2-217.8L532 294c7.7 0 14-6.3 14-14s-6.3-14-14-14l-112.2 0c-2.1-87.8-24-166.4-58.2-217.8-4.3-6.4-13-8.2-19.4-3.9s-8.2 13-3.9 19.4c30.4 45.6 51.4 118.4 53.5 202.2l-223.6 0c2.1-83.9 23.1-156.6 53.5-202.2z"]],
    "arrow-left": [560, 560, [8592], "f060", ["M0 280c0 17.7 8.2 34.3 22.1 45.2l218.6 170c7.3 5.7 16.3 8.8 25.6 8.8 23 0 41.7-18.7 41.7-41.7l0-168.3-182 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l182 0 0-168.3c0-23-18.7-41.7-41.7-41.7-9.3 0-18.3 3.1-25.6 8.8L22.1 234.8C8.2 245.7 0 262.3 0 280z", "M112 280c0-7.7 6.3-14 14-14l420 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-420 0c-7.7 0-14-6.3-14-14z"]],
    "paw": [504, 560, [], "f1b0", ["M28 427c0 58 47 105 105 105l3.5 0c20.6 0 40.7-6.1 57.8-17.5 35-23.3 80.6-23.3 115.5 0 17.1 11.4 37.2 17.5 57.8 17.5l3.5 0c58 0 105-47 105-105 0-22.7-7.4-44.8-21-63L341.6 212.8C320.4 184.6 287.3 168 252 168s-68.4 16.6-89.6 44.8L49 364c-13.6 18.2-21 40.3-21 63z", "M196 84a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM84 196a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM0 196a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm336-84a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm0-84a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM476 196a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]],
    "bed": [560, 560, [128716], "f236", ["M0 112L0 406c0-41.4 25.6-76.8 61.9-91.1-12.3-12.6-19.9-29.9-19.9-48.9 0-38.7 31.3-70 70-70l112 0c22.9 0 43.2 11 56 28 12.8-17 33.1-28 56-28l112 0c38.7 0 70 31.3 70 70 0 19-7.6 36.3-19.9 48.9 36.2 14.4 61.9 49.8 61.9 91.1l0-294c0-46.4-37.6-84-84-84L84 28C37.6 28 0 65.6 0 112zM28 406l0 70 504 0 0-70c0-38.7-31.3-70-70-70L98 336c-38.7 0-70 31.3-70 70zM70 266c0 23.2 18.8 42 42 42l112 0c23.2 0 42-18.8 42-42s-18.8-42-42-42l-112 0c-23.2 0-42 18.8-42 42zm224 0c0 23.2 18.8 42 42 42l112 0c23.2 0 42-18.8 42-42s-18.8-42-42-42l-112 0c-23.2 0-42 18.8-42 42z", "M42 266c0-38.7 31.3-70 70-70l112 0c22.9 0 43.2 11 56 28 12.8-17 33.1-28 56-28l112 0c38.7 0 70 31.3 70 70 0 19-7.6 36.3-19.9 48.9 36.2 14.4 61.9 49.8 61.9 91.1l0 112c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-112c0-38.7-31.3-70-70-70L98 336c-38.7 0-70 31.3-70 70l0 112c0 7.7-6.3 14-14 14S0 525.7 0 518L0 406C0 364.6 25.6 329.2 61.9 314.9 49.6 302.3 42 285 42 266zm70 42l112 0c23.2 0 42-18.8 42-42s-18.8-42-42-42l-112 0c-23.2 0-42 18.8-42 42s18.8 42 42 42zm224 0l112 0c23.2 0 42-18.8 42-42s-18.8-42-42-42l-112 0c-23.2 0-42 18.8-42 42s18.8 42 42 42z"]],
    "landmark": [560, 560, [127963], "f66f", ["M28 190.1L280 44.2 532 190.1 532 224c0 30.9-25.1 56-56 56l-14 0 0-42c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42-84 0 0-42c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42-84 0 0-42c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42-84 0 0-42c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 42-14 0c-30.9 0-56-25.1-56-56l0-33.9z", "M273 15.9L7 169.9C.3 173.8-2 182.3 1.9 189s12.4 9 19.1 5.1L280 44.2 539 194.1c6.7 3.9 15.3 1.6 19.1-5.1s1.6-15.3-5.1-19.1L287 15.9c-4.3-2.5-9.7-2.5-14 0zM126 238c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 266-56 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l476 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0 0-266c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 266-84 0 0-266c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 266-84 0 0-266c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 266-84 0 0-266z"]],
    "music": [560, 560, [127925], "f001", ["M0 420c0 61.9 50.1 112 112 112 61.7 0 111.8-49.9 112-111.6-.2 7.6-6.4 13.6-14 13.6-7.7 0-14-6.3-14-14l0-74.1C175.5 322.7 145.5 308 112 308 50.1 308 0 358.1 0 420zm280-56c0 61.9 50.1 112 112 112 61.7 0 111.8-49.9 112-111.6-.2 7.6-6.4 13.6-14 13.6-7.7 0-14-6.3-14-14l0-74.1c-20.5-23.3-50.5-37.9-84-37.9-61.9 0-112 50.1-112 112z", "M453.8 35c26-5.2 50.2 14.7 50.2 41.2L504 364c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-287.8c0-8.8-8.1-15.5-16.7-13.7l-224 44.8c-6.5 1.3-11.3 7.1-11.3 13.7l0 299c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-299c0-20 14.1-37.3 33.8-41.2L453.8 35z"]],
    "files": [560, 560, [], "e178", ["M140 112l0 280c0 61.9 50.1 112 112 112l168 0c61.9 0 112-50.1 112-112l0-219.6c0-1.5 0-2.9-.1-4.4L462 168c-54.1 0-98-43.9-98-98l0-70c-1.5 0-2.9 0-4.4 0L252 0C190.1 0 140 50.1 140 112zm84 154c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zm0 112c0-7.7 6.3-14 14-14l196 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-196 0c-7.7 0-14-6.3-14-14zM392 4.8L392 70c0 38.7 31.3 70 70 70l65.2 0c-5.3-17.5-14.8-33.6-28-46.8L438.8 32.8c-13.2-13.2-29.3-22.7-46.8-28z", "M378-14c-7.7 0-14 6.3-14 14l0 70c0 54.1 43.9 98 98 98l70 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-70 0c-38.7 0-70-31.3-70-70l0-70c0-7.7-6.3-14-14-14zM224 266c0 7.7 6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0c-7.7 0-14 6.3-14 14zm0 112c0 7.7 6.3 14 14 14l196 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-196 0c-7.7 0-14 6.3-14 14zM350 588c7.7 0 14-6.3 14-14s-6.3-14-14-14l-224 0c-54.1 0-98-43.9-98-98l0-280c0-38.7 31.3-70 70-70 7.7 0 14-6.3 14-14s-6.3-14-14-14C43.9 84 0 127.9 0 182L0 462c0 69.6 56.4 126 126 126l224 0z"]],
    "plus": [560, 560, [10133, 61543, "add"], "2b", ["M0 252l0 56c0 30.9 25.1 56 56 56l140 0 0 140c0 30.9 25.1 56 56 56l56 0c30.9 0 56-25.1 56-56l0-140 140 0c30.9 0 56-25.1 56-56l0-56c0-30.9-25.1-56-56-56l-140 0 0-140c0-30.9-25.1-56-56-56L252 0c-30.9 0-56 25.1-56 56l0 140-140 0c-30.9 0-56 25.1-56 56zm56 14c0-7.7 6.3-14 14-14l182 0 0-182c0-7.7 6.3-14 14-14s14 6.3 14 14l0 189c0 11.6-9.4 21-21 21L70 280c-7.7 0-14-6.3-14-14z", "M280 70c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 182-182 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l189 0c11.6 0 21-9.4 21-21l0-189z"]],
    "box": [560, 560, [128230], "f466", ["M28 196l0 224c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-224-504 0zm2.1-28l235.9 0 0-140-106.2 0c-45.8 0-87 27.9-104 70.4L36 148c-2.6 6.5-4.6 13.2-5.9 20zM294 28l0 140 235.9 0c-1.3-6.8-3.3-13.5-5.9-20L504.2 98.4C487.2 55.9 446 28 400.2 28L294 28z", "M266 28l0 140-238 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l504 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-238 0 0-140c0-7.7-6.3-14-14-14s-14 6.3-14 14z"]],
    "arrow-rotate-right": [504, 560, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", ["M84.1 280c0 92.8 75.2 168 168 168s168-75.2 168-168c0-29.8-7.7-57.7-21.3-82l-64.7 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l45 0c-30.8-35.5-76.3-58-127-58-92.8 0-168 75.2-168 168z", "M430.4 170c-37-60-103.3-100-178.9-100-116 0-210 94-210 210s94 210 210 210c83.8 0 156.1-49 189.8-120 3.3-7 11.7-10 18.7-6.6s10 11.7 6.6 18.7c-38.2 80.4-120.1 136-215.1 136-131.4 0-238-106.6-238-238S120.1 42 251.5 42c81.7 0 153.8 41.2 196.6 103.8l0-89.8c0-7.7 6.3-14 14-14s14 6.3 14 14l0 128c0 7.7-6.3 14-14 14l-128 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l96.3 0z"]],
    "arrow-down-wide-short": [616, 560, ["sort-amount-asc", "sort-amount-down"], "f160", ["M308 84c0-30.9 25.1-56 56-56l204.6 0c26.2 0 47.4 21.2 47.4 47.4 0 5.7-1 11.3-3 16.6L461.6 495.7c-8.2 21.9-29.1 36.3-52.4 36.3L364 532c-30.9 0-56-25.1-56-56l0-82.5 51.5-47.2c5.7-5.2 6.1-14.1 .9-19.8s-14.1-6.1-19.8-.9L308 355.5 308 84z", "M3.7 326.5c5.2-5.7 14.1-6.1 19.8-.9L168 458.2 168 70c0-7.7 6.3-14 14-14s14 6.3 14 14l0 388.2 144.5-132.5c5.7-5.2 14.6-4.8 19.8 .9s4.8 14.6-.9 19.8l-168 154c-5.4 4.9-13.6 4.9-18.9 0l-168-154c-5.7-5.2-6.1-14.1-.9-19.8z"]],
    "compress": [560, 560, [], "f066", ["M84 168c0-46.4 37.6-84 84-84l0 84-84 0zm0 28l84 0c15.5 0 28-12.5 28-28l0-84 168 0 0 84c0 15.5 12.5 28 28 28l84 0 0 175-84 0c-15.5 0-28 12.5-28 28l0 77-168 0 0-84c0-15.5-12.5-28-28-28l-84 0 0-168zm0 196l84 0 0 84c-46.4 0-84-37.6-84-84zM392 84c46.4 0 84 37.6 84 84l-84 0 0-84zm0 315l83.7 0c-3.6 43.1-39.7 77-83.7 77l0-77z", "M378 0c7.7 0 14 6.3 14 14l0 154 154 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-154 0c-15.5 0-28-12.5-28-28l0-154c0-7.7 6.3-14 14-14zM168 546l0-154-154 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l154 0c15.5 0 28 12.5 28 28l0 154c0 7.7-6.3 14-14 14s-14-6.3-14-14zm224 7c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-154c0-15.5 12.5-28 28-28l154 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-154 0 0 154zM168 14c0-7.7 6.3-14 14-14s14 6.3 14 14l0 154c0 15.5-12.5 28-28 28L14 196c-7.7 0-14-6.3-14-14s6.3-14 14-14l154 0 0-154z"]],
    "eye-slash": [616, 560, [], "f070", ["M28 280c0-9.4 .7-18.9 2.2-28.2 5.7-.9 10.5-5.3 11.6-11.2 4.6-24.8 16.8-59.1 38.7-93 2.5-3.8 2.9-8.4 1.4-12.4 8.9-11.6 18.6-22.4 29.2-32.4L483.5 475.3C436.8 511.2 378.6 532 316.7 532l-17.5 0C179.5 532 73.7 454.2 38 339.9l-1.6-5.2C30.8 317 28 298.6 28 280zM132.5 84.7c11.3-8.7 23.4-16.5 35.9-23.4 2.1-.1 4.2-.6 6.2-1.7 35.5-19.1 79.4-31.6 133.4-31.6 181 0 252.9 141.6 266.2 212.6 1.1 6 5.9 10.4 11.6 11.2 1.4 9.3 2.2 18.7 2.2 28.2 0 18.6-2.8 37-8.4 54.7l-1.6 5.2c-14.3 45.8-39.9 85.8-73.1 117.2L132.5 84.7zM196 280c0 61.9 50.1 112 112 112 7.7 0 14-6.3 14-14s-6.3-14-14-14c-46.4 0-84-37.6-84-84 0-7.7-6.3-14-14-14s-14 6.3-14 14zm98-98c0 7.7 6.3 14 14 14 46.4 0 84 37.6 84 84 0 7.7 6.3 14 14 14s14-6.3 14-14c0-61.9-50.1-112-112-112-7.7 0-14 6.3-14 14z", "M18.1 9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l560 560c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L18.1 9.9zM308 28c-54 0-97.9 12.5-133.4 31.6-6.8 3.7-15.3 1.1-19-5.7s-1.1-15.3 5.7-19c39.7-21.4 88.2-35 146.7-35 199.8 0 279.1 157.1 293.8 235.4 1.4 7.6-3.6 14.9-11.2 16.3s-14.9-3.6-16.3-11.2C560.9 169.6 489 28 308 28zM76.4 128.3c6.5 4.2 8.3 12.9 4.1 19.4-22 33.8-34.1 68.2-38.7 93-1.4 7.6-8.7 12.6-16.3 11.2S12.8 243 14.2 235.4c5.3-28.4 18.8-66.1 42.8-103 4.2-6.5 12.9-8.3 19.4-4.1zM294 182c0-7.7 6.3-14 14-14 61.9 0 112 50.1 112 112 0 7.7-6.3 14-14 14s-14-6.3-14-14c0-46.4-37.6-84-84-84-7.7 0-14-6.3-14-14zm-84 84c7.7 0 14 6.3 14 14 0 46.4 37.6 84 84 84 7.7 0 14 6.3 14 14s-6.3 14-14 14c-61.9 0-112-50.1-112-112 0-7.7 6.3-14 14-14z"]],
    "mug-hot": [560, 560, [9749], "f7b6", ["M56 280l0 84c0 108.2 87.8 196 196 196 78.5 0 146.2-46.1 177.5-112.8-5.5-1.9-9.5-7.1-9.5-13.2 0-7.7 6.3-14 14-14l5.9 0c5.3-17.7 8.1-36.5 8.1-56l0-112-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l-322 0c-30.9 0-56 25.1-56 56z", "M126 0c7.7 0 14 6.3 14 14l0 7.2c0 18.6 7.4 36.4 20.5 49.5l6.8 6.8c18.4 18.4 28.7 43.3 28.7 69.3l0 7.2c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-7.2c0-18.6-7.4-36.4-20.5-49.5l-6.8-6.8C122.3 72.1 112 47.2 112 21.2l0-7.2c0-7.7 6.3-14 14-14zM420 238c0-7.7 6.3-14 14-14l14 0c61.9 0 112 50.1 112 112S509.9 448 448 448l-14 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l14 0c46.4 0 84-37.6 84-84s-37.6-84-84-84l-14 0c-7.7 0-14-6.3-14-14zM280 14l0 7.2c0 18.6 7.4 36.4 20.5 49.5l6.8 6.8c18.4 18.4 28.7 43.3 28.7 69.3l0 7.2c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-7.2c0-18.6-7.4-36.4-20.5-49.5l-6.8-6.8C262.3 72.1 252 47.2 252 21.2l0-7.2c0-7.7 6.3-14 14-14s14 6.3 14 14z"]],
    "bolt": [504, 560, [9889, "zap"], "f0e7", ["M4.7 309.9L282.3 32.3c12.7-12.7 34.4-4.6 35.8 13.2l2.6 34.3-178.3 178.3c-13.2 13.2-3.9 35.8 14.8 35.8l161 0-137.2 147.8-5.1-66c-.8-10.3-9-18.5-19.3-19.3L17.9 345.7C0 344.3-8 322.6 4.7 309.9zM174.2 266l149.4-149.4 5.2 67.7c.8 10.3 9 18.5 19.3 19.3l138.8 10.7c17.9 1.4 25.9 23.1 13.2 35.8L222.5 527.7c-12.7 12.7-34.4 4.7-35.8-13.2L184 479.8 349.7 301.3c12.5-13.4 2.9-35.3-15.4-35.3l-160.1 0z", "M346.3 93.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-184 184.1c-13.2 13.2-3.9 35.8 14.8 35.8l161 0-160.2 172.5c-5.3 5.7-4.9 14.5 .7 19.8s14.5 4.9 19.8-.7L349.7 301.3c12.5-13.4 2.9-35.3-15.4-35.3L174.2 266 346.3 93.9z"]],
    "arrow-rotate-left": [504, 560, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", ["M84.1 280c0-29.8 7.7-57.7 21.3-82l64.7 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-45 0c30.8-35.5 76.3-58 127-58 92.8 0 168 75.2 168 168s-75.2 168-168 168-168-75.2-168-168z", "M73.8 170c37-60 103.3-100 178.9-100 116 0 210 94 210 210s-94 210-210 210c-83.8 0-156.1-49-189.8-120-3.3-7-11.7-10-18.7-6.6S34.3 375 37.6 382c38.2 80.4 120.1 136 215.1 136 131.4 0 238-106.6 238-238S384.1 42 252.7 42C171 42 99 83.2 56.1 145.8l0-89.8c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 128c0 7.7 6.3 14 14 14l128 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-96.3 0z"]],
    "wifi": [616, 560, ["wifi-3", "wifi-strong"], "f1eb", ["M0 188.4c0 13.9 5.2 27.2 14.5 37.5l43.4 47.5c.4-.6 .8-1.2 1.3-1.8 59-71.8 148.6-117.6 248.8-117.6s189.8 45.8 248.8 117.6c.5 .6 .9 1.2 1.3 1.8l43.4-47.5c9.4-10.2 14.5-23.6 14.5-37.5 0-6.8-2.5-13.4-7-18.5-73.4-83.6-181-136.3-301-136.3S80.4 86.3 7 169.9c-4.5 5.1-7 11.7-7 18.5zM75.9 293.2L165.3 391c33.3-42 84.9-69 142.7-69s109.4 27 142.7 69l89.4-97.9c-1.8-.9-3.5-2.1-4.9-3.8-53.9-65.6-135.7-107.4-227.2-107.4S134.8 223.8 80.8 289.4c-1.4 1.7-3 2.9-4.9 3.8zM184.3 411.9L284.6 521.7c6 6.6 14.5 10.3 23.4 10.3s17.4-3.8 23.4-10.3L431.7 411.9c-.6-.5-1.1-1.1-1.6-1.8-28.2-36.6-72.4-60.1-122-60.1s-93.9 23.5-122 60.1c-.5 .7-1.1 1.3-1.6 1.8z", "M80.8 289.4C134.8 223.8 216.5 182 308 182s173.2 41.8 227.2 107.4c4.9 6 13.7 6.8 19.7 1.9s6.8-13.7 1.9-19.7C497.8 199.8 408.2 154 308 154S118.2 199.8 59.2 271.6c-4.9 6-4.1 14.8 1.9 19.7s14.8 4.1 19.7-1.9zM186 410.1c28.2-36.6 72.4-60.1 122-60.1s93.9 23.5 122 60.1c4.7 6.1 13.5 7.3 19.6 2.5s7.3-13.5 2.5-19.6C419 349.8 366.7 322 308 322s-111 27.8-144.2 71c-4.7 6.1-3.6 14.9 2.5 19.6s14.9 3.6 19.6-2.5z"]],
    "volume": [560, 560, [128265, "volume-medium"], "f6a8", ["M0 224c0-30.9 25.1-56 56-56l4.8 0c14.9 0 29.1-5.9 39.6-16.4l79.2-79.2C190.1 61.9 204.3 56 219.2 56l4.8 0c30.9 0 56 25.1 56 56l0 336c0 30.9-25.1 56-56 56l-4.8 0c-14.9 0-29.1-5.9-39.6-16.4l-79.2-79.2C89.9 397.9 75.7 392 60.8 392L56 392c-30.9 0-56-25.1-56-56L0 224z", "M322 70c0-7.7 6.3-14 14-14 123.7 0 224 100.3 224 224S459.7 504 336 504c-7.7 0-14-6.3-14-14s6.3-14 14-14c108.2 0 196-87.8 196-196S444.2 84 336 84c-7.7 0-14-6.3-14-14zm0 84c0-7.7 6.3-14 14-14 77.3 0 140 62.7 140 140S413.3 420 336 420c-7.7 0-14-6.3-14-14s6.3-14 14-14c61.9 0 112-50.1 112-112S397.9 168 336 168c-7.7 0-14-6.3-14-14zm14 70c30.9 0 56 25.1 56 56s-25.1 56-56 56c-7.7 0-14-6.3-14-14s6.3-14 14-14c15.5 0 28-12.5 28-28s-12.5-28-28-28c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "tag": [560, 560, [127991], "f02b", ["M0 70L0 261.6c0 29.7 11.8 58.2 32.8 79.2L212.4 520.4C237.8 545.8 272.1 560 308 560s70.2-14.2 95.6-39.6L520.4 403.6C545.8 378.2 560 343.9 560 308s-14.2-70.2-39.6-95.6L340.8 32.8C319.8 11.8 291.3 0 261.6 0L70 0C31.3 0 0 31.3 0 70zm224 84a70 70 0 1 1 -140 0 70 70 0 1 1 140 0zm-112 0a42 42 0 1 0 84 0 42 42 0 1 0 -84 0z", "M154 112a42 42 0 1 1 0 84 42 42 0 1 1 0-84zm0 112a70 70 0 1 0 0-140 70 70 0 1 0 0 140z"]],
    "compact-disc": [560, 560, [128191, 128192, 128440], "f51f", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm392 0a112 112 0 1 1 -224 0 112 112 0 1 1 224 0zm-196 0a84 84 0 1 0 168 0 84 84 0 1 0 -168 0zm105 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zM266 70c0-7.7 6.3-14 14-14 123.7 0 224 100.3 224 224 0 7.7-6.3 14-14 14s-14-6.3-14-14c0-108.2-87.8-196-196-196-7.7 0-14-6.3-14-14z", "M280 56c-7.7 0-14 6.3-14 14s6.3 14 14 14c108.2 0 196 87.8 196 196 0 7.7 6.3 14 14 14s14-6.3 14-14C504 156.3 403.7 56 280 56zm0 140a84 84 0 1 1 0 168 84 84 0 1 1 0-168zm0 196a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm21-112a21 21 0 1 0 -42 0 21 21 0 1 0 42 0z"]],
    "phone-slash": [616, 560, [], "f3dd", ["M140 273.9c0-42.9 5-85.6 14.8-127.4L308.5 300.3c1 23.5 3.9 46.9 8.6 69.9l73.6 12.3 57.4 57.4 0 64.2c0 30.9-25.1 56-56 56l0-112c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 112-42.1 0c-74.5 0-140-49.4-160.5-121.1-14.2-49.7-21.4-101.2-21.4-152.9l0-12.1zm23.2-158.6C185.4 46.8 249.4 0 321.9 0l42.1 0 0 182-47 7.8c-4.7 23.3-7.6 47-8.6 70.8L163.2 115.4zM392 0c30.9 0 56 25.1 56 56l0 64.6c0 27.4-19.8 50.7-46.8 55.2L392 177.3 392 0z", "M18.1 9.9c-5.5-5.5-5.5-14.3 0-19.8s14.3-5.5 19.8 0l560 560c5.5 5.5 5.5 14.3 0 19.8s-14.3 5.5-19.8 0L18.1 9.9zM378-14c7.7 0 14 6.3 14 14l0 182c0 7.7-6.3 14-14 14s-14-6.3-14-14L364 0c0-7.7 6.3-14 14-14zm0 448c7.7 0 14 6.3 14 14l0 112c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-112c0-7.7 6.3-14 14-14z"]],
    "arrow-up-right-from-square": [560, 560, ["external-link"], "f08e", ["M0 224L0 448c0 61.9 50.1 112 112 112l224 0c61.9 0 112-50.1 112-112l0-224c0-25.9-8.8-49.7-23.5-68.7L233.9 345.9c-5.5 5.5-14.3 5.5-19.8 0s-5.5-14.3 0-19.8L404.7 135.5c-19-14.7-42.8-23.5-68.7-23.5l-224 0C50.1 112 0 162.1 0 224z", "M322 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l190.2 0-298.1 298.1c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0L532 47.8 532 238c0 7.7 6.3 14 14 14s14-6.3 14-14l0-210c0-15.5-12.5-28-28-28L322 0z"]],
    "rectangle-tall": [392, 560, [], "e791", ["M0 84L0 476c0 61.9 50.1 112 112 112l168 0c61.9 0 112-50.1 112-112l0-392c0-61.9-50.1-112-112-112L112-28C50.1-28 0 22.1 0 84zM56 98c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L126 56c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14L56 98z", "M266 42c0 7.7-6.3 14-14 14L126 56c-23.2 0-42 18.8-42 42l0 126c0 7.7-6.3 14-14 14s-14-6.3-14-14L56 98c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14z"]],
    "compass": [560, 560, [129517], "f14e", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zM140.9 382.3l57-132.9c9.9-23.1 28.3-41.6 51.5-51.5l132.9-57c23.2-10 46.7 13.5 36.8 36.8l-57 132.9c-9.9 23.1-28.3 41.6-51.5 51.5l-132.9 57c-23.2 10-46.7-13.5-36.8-36.8zm25.7 11l132.9-57c16.5-7.1 29.7-20.2 36.8-36.8l57-132.9-132.9 57c-16.5 7.1-29.7 20.2-36.8 36.8l-57 132.9zM301 280a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M419.1 177.7c10-23.2-13.5-46.7-36.8-36.8l-132.9 57c-23.1 9.9-41.6 28.3-51.5 51.5l-57 132.9c-10 23.2 13.5 46.7 36.8 36.8l132.9-57c23.1-9.9 41.6-28.3 51.5-51.5l57-132.9zM260.4 223.6l132.9-57-57 132.9c-7.1 16.5-20.2 29.7-36.8 36.8l-132.9 57 57-132.9c7.1-16.5 20.2-29.7 36.8-36.8zM301 280a21 21 0 1 0 -42 0 21 21 0 1 0 42 0z"]],
    "square": [504, 560, [9632, 9723, 9724, 61590], "f0c8", ["M0 140L0 420c0 61.9 50.1 112 112 112l280 0c61.9 0 112-50.1 112-112l0-280c0-61.9-50.1-112-112-112L112 28C50.1 28 0 78.1 0 140zm56 14c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 154c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-154z", "M266 98c0 7.7-6.3 14-14 14l-126 0c-23.2 0-42 18.8-42 42l0 154c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-154c0-38.7 31.3-70 70-70l126 0c7.7 0 14 6.3 14 14z"]],
    "face-grin": [560, 560, [128512, "grin"], "f580", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm126 14c0-7.7 6.3-14 14-14l280 0c7.7 0 14 6.3 14 14 0 85.1-68.9 154-154 154S126 379.1 126 294zm28.8 14c7 63 60.4 112 125.2 112s118.3-49 125.2-112l-250.5 0zM217 196a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm168 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M217 196a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm168 0a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm49 98c0-7.7-6.3-14-14-14l-280 0c-7.7 0-14 6.3-14 14 0 85.1 68.9 154 154 154s154-68.9 154-154zM280 420c-64.9 0-118.3-49-125.2-112l250.5 0c-7 63-60.4 112-125.2 112z"]],
    "angle-up": [560, 560, [8963], "f106", ["M0 406c0 23.2 18.8 42 42 42l70 0c0-2.9 .9-5.8 2.7-8.3l154-210c2.6-3.6 6.8-5.7 11.3-5.7s8.7 2.1 11.3 5.7l154 210c1.8 2.5 2.7 5.4 2.7 8.3l70 0c23.2 0 42-18.8 42-42 0-9.1-2.9-17.9-8.4-25.2L324.8 78.4C314.2 64.3 297.6 56 280 56s-34.2 8.3-44.8 22.4L8.4 380.8C2.9 388.1 0 396.9 0 406zm143.4 42L416.6 448 280 261.7 143.4 448z", "M117.7 459.3c6.2 4.6 15 3.2 19.6-3L280 261.7 422.7 456.3c4.6 6.2 13.3 7.6 19.6 3s7.6-13.3 3-19.6l-154-210c-2.6-3.6-6.8-5.7-11.3-5.7s-8.7 2.1-11.3 5.7l-154 210c-4.6 6.2-3.2 15 3 19.6z"]],
    "face-smile": [560, 560, [128578, "smile"], "f118", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zm126 14c0-7.7 6.3-14 14-14s14 6.3 14 14c0 69.6 56.4 126 126 126s126-56.4 126-126c0-7.7 6.3-14 14-14s14 6.3 14 14c0 85.1-68.9 154-154 154S126 379.1 126 294zm91-98a21 21 0 1 1 -42 0 21 21 0 1 1 42 0zm168 0a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M217 196a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm168 0a21 21 0 1 0 -42 0 21 21 0 1 0 42 0zm49 98c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 69.6-56.4 126-126 126S154 363.6 154 294c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 85.1 68.9 154 154 154s154-68.9 154-154z"]],
    "umbrella": [560, 560, [], "f0e9", ["M5.9 224.4C-.2 254.7 25.5 280 56.4 280l210 0 0-56c0-7.7 6.3-14 14-14s14 6.3 14 14l0 56 210 0C535.3 280 561 254.7 554.8 224.4 529 96.4 416 0 280.4 0S31.7 96.4 5.9 224.4z", "M280.4 210c-7.7 0-14 6.3-14 14l0 203c0 42.5 34.5 77 77 77s77-34.5 77-77l0-21c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 21c0 27.1-21.9 49-49 49s-49-21.9-49-49l0-203c0-7.7-6.3-14-14-14z"]],
    "pause": [392, 560, [9208], "f04c", ["M0 140L0 420c0 30.9 25.1 56 56 56l56 0c30.9 0 56-25.1 56-56l0-280c0-30.9-25.1-56-56-56L56 84C25.1 84 0 109.1 0 140zm56 14c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-252zm168-14l0 280c0 30.9 25.1 56 56 56l56 0c30.9 0 56-25.1 56-56l0-280c0-30.9-25.1-56-56-56l-56 0c-30.9 0-56 25.1-56 56zm56 14c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-252z", "M56 406l0-252c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14zm224 0l0-252c0-7.7 6.3-14 14-14s14 6.3 14 14l0 252c0 7.7-6.3 14-14 14s-14-6.3-14-14z"]],
    "desktop": [560, 560, [128421, 61704, "desktop-alt"], "f390", ["M0 140L0 364c0 61.9 50.1 112 112 112l154 0c0-7.7 6.3-14 14-14s14 6.3 14 14l154 0c61.9 0 112-50.1 112-112l0-224c0-61.9-50.1-112-112-112L112 28C50.1 28 0 78.1 0 140zm56 0c0-30.9 25.1-56 56-56l336 0c30.9 0 56 25.1 56 56l0 224c0 30.9-25.1 56-56 56l-336 0c-30.9 0-56-25.1-56-56l0-224zm28 0l0 224c0 15.5 12.5 28 28 28l336 0c15.5 0 28-12.5 28-28l0-224c0-15.5-12.5-28-28-28l-336 0c-15.5 0-28 12.5-28 28z", "M476 140c0-15.5-12.5-28-28-28l-336 0c-15.5 0-28 12.5-28 28l0 224c0 15.5 12.5 28 28 28l336 0c15.5 0 28-12.5 28-28l0-224zM448 84c30.9 0 56 25.1 56 56l0 224c0 30.9-25.1 56-56 56l-336 0c-30.9 0-56-25.1-56-56l0-224c0-30.9 25.1-56 56-56l336 0zM294 476l0 56 140 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-308 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l140 0 0-56c0-7.7 6.3-14 14-14s14 6.3 14 14z"]],
    "arrow-down": [448, 560, [8595], "f063", ["M0 293.7c0-23 18.7-41.7 41.7-41.7l168.3 0 0 182c0 7.7 6.3 14 14 14s14-6.3 14-14l0-182 168.3 0c23 0 41.7 18.7 41.7 41.7 0 9.3-3.1 18.3-8.8 25.6l-170 218.6C258.3 551.8 241.7 560 224 560s-34.3-8.2-45.2-22.1L8.8 319.3C3.1 312 0 303 0 293.7z", "M224 448c7.7 0 14-6.3 14-14l0-420c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 420c0 7.7 6.3 14 14 14z"]],
    "location-dot": [448, 560, ["map-marker-alt"], "f3c5", ["M0 226.1C0 278.5 18.4 330 51.9 370.3L201.6 549.9c5.3 6.4 13.2 10.1 21.5 10.1l1.8 0c8.3 0 16.2-3.7 21.5-10.1L396.1 370.3C429.6 330 448 278.5 448 226.1 448 102.4 347.7 0 224 0S0 102.4 0 226.1zM322 210a98 98 0 1 1 -196 0 98 98 0 1 1 196 0zm-168 0a70 70 0 1 0 140 0 70 70 0 1 0 -140 0z", "M224 140a70 70 0 1 1 0 140 70 70 0 1 1 0-140zm0 168a98 98 0 1 0 0-196 98 98 0 1 0 0 196z"]],
    "bars": [560, 560, ["navicon"], "f0c9", ["M0 112c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56s-25.1-56-56-56L56 56C25.1 56 0 81.1 0 112zM0 280c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56s-25.1-56-56-56L56 224c-30.9 0-56 25.1-56 56zM0 448c0 30.9 25.1 56 56 56l448 0c30.9 0 56-25.1 56-56s-25.1-56-56-56L56 392c-30.9 0-56 25.1-56 56zM42 126c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 140c-7.7 0-14-6.3-14-14zm0 168c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 308c-7.7 0-14-6.3-14-14zm0 168c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 476c-7.7 0-14-6.3-14-14z", "M42 126c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 140c-7.7 0-14-6.3-14-14zm0 336c0-7.7 6.3-14 14-14l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 476c-7.7 0-14-6.3-14-14zM56 280l224 0c7.7 0 14 6.3 14 14s-6.3 14-14 14L56 308c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "stopwatch": [504, 560, [9201], "f2f2", ["M28 322c0-126.7 99.1-230.4 224-237.6 .2 7.5 6.4 13.6 14 13.6s13.8-6 14-13.6c55.2 3.2 105.3 25.2 144.1 59.7l-14 14c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l14-14c37.4 42 60.1 97.4 60.1 158.1 0 131.4-106.6 238-238 238S28 453.4 28 322zM252 196l0 140c0 7.7 6.3 14 14 14s14-6.3 14-14l0-140c0-7.7-6.3-14-14-14s-14 6.3-14 14z", "M196 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0 0 56c0 7.7 6.3 14 14 14s14-6.3 14-14l0-56 56 0c7.7 0 14-6.3 14-14S343.7 0 336 0L196 0zM485.9 121.9c5.5-5.5 5.5-14.3 0-19.8s-14.3-5.5-19.8 0l-56 56c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l56-56zM280 196c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 140c0 7.7 6.3 14 14 14s14-6.3 14-14l0-140z"]],
    "train": [504, 560, [128646], "f238", ["M56 112l0 168c0 61.9 50.1 112 112 112l168 0c61.9 0 112-50.1 112-112l0-168C448 50.1 397.9 0 336 0L168 0C106.1 0 56 50.1 56 112zm56 0c0-30.9 25.1-56 56-56l168 0c30.9 0 56 25.1 56 56l0 28c0 30.9-25.1 56-56 56l-168 0c-30.9 0-56-25.1-56-56l0-28zm28 0l0 28c0 15.5 12.5 28 28 28l168 0c15.5 0 28-12.5 28-28l0-28c0-15.5-12.5-28-28-28L168 84c-15.5 0-28 12.5-28 28zM308 280a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm-84 0a28 28 0 1 0 56 0 28 28 0 1 0 -56 0z", "M168 84l168 0c15.5 0 28 12.5 28 28l0 28c0 15.5-12.5 28-28 28l-168 0c-15.5 0-28-12.5-28-28l0-28c0-15.5 12.5-28 28-28zm-56 28l0 28c0 30.9 25.1 56 56 56l168 0c30.9 0 56-25.1 56-56l0-28c0-30.9-25.1-56-56-56L168 56c-30.9 0-56 25.1-56 56zM224 280a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm84 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM140 434c0-3.6-1.4-7.2-4.1-9.9-5.5-5.5-14.3-5.5-19.8 0l-112 112c-5.5 5.5-5.5 14.3 0 19.8s14.3 5.5 19.8 0l23.9-23.9 408.4 0 23.9 23.9c5.5 5.5 14.3 5.5 19.8 0s5.5-14.3 0-19.8l-112-112c-5.5-5.5-14.3-5.5-19.8 0-2.7 2.7-4.1 6.3-4.1 9.9l-224 0zm246.2 28l42 42-352.4 0 42-42 268.4 0z"]],
    "gamepad": [560, 560, [], "f11b", ["M0 280L0 445.5c0 47.8 38.7 86.5 86.5 86.5 32.8 0 62.7-18.5 77.4-47.8L168 476c17.2-34.3 52.2-56 90.6-56l42.8 0c38.4 0 73.4 21.7 90.6 56l4.1 8.2c14.7 29.3 44.6 47.8 77.4 47.8 47.8 0 86.5-38.7 86.5-86.5L560 280C560 156.3 459.7 56 336 56L224 56C100.3 56 0 156.3 0 280zm70-14c0-7.7 6.3-14 14-14l56 0 0-56c0-7.7 6.3-14 14-14s14 6.3 14 14l0 56 56 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-56 0 0 56c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-56-56 0c-7.7 0-14-6.3-14-14zm322-56a42 42 0 1 1 -84 0 42 42 0 1 1 84 0zm84 112a42 42 0 1 1 -84 0 42 42 0 1 1 84 0z", "M350 196a14 14 0 1 1 0 28 14 14 0 1 1 0-28zm0 56a42 42 0 1 0 0-84 42 42 0 1 0 0 84zM168 196c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 56-56 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l56 0 0 56c0 7.7 6.3 14 14 14s14-6.3 14-14l0-56 56 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-56 0 0-56zM420 322a14 14 0 1 1 28 0 14 14 0 1 1 -28 0zm56 0a42 42 0 1 0 -84 0 42 42 0 1 0 84 0z"]],
    "ship": [560, 560, [128674], "f21a", ["M28 303.9c0-2 .2-3.9 .6-6 2.3 7.5 10 11.6 17.4 9.5l220-64.7 0 233.3c0 7.7 6.3 14 14 14s14-6.3 14-14l0-233.3 220 64.7c7.4 2.2 15.1-2 17.3-9.3 .4 1.9 .6 3.8 .6 5.8l0 37.7c0 55.8-33.1 107.2-86.4 134.3L402 498c-6.3-10.5-10-22.9-10-36 0-7.7-6.3-14-14-14s-14 6.3-14 14c0 36.7-35.5 70-84 70s-84-33.3-84-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 13.2-3.6 25.5-10 36l-43.6-22.2C61.1 448.8 28 397.4 28 341.6l0-37.7zM56 112C56 50.1 106.1 0 168 0L392 0c61.9 0 112 50.1 112 112l0 140c0 7.7-.8 15.3-2.3 22.7-72.6-21.4-145.2-42.8-217.8-64.1-2.6-.8-5.3-.8-7.9 0l-217.8 64C56.8 267.3 56 259.7 56 252l0-140zm56 14l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-23.2 18.8-42 42-42l196 0c23.2 0 42 18.8 42 42l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-38.7-31.3-70-70-70L182 56c-38.7 0-70 31.3-70 70z", "M182 56c-38.7 0-70 31.3-70 70l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-23.2 18.8-42 42-42l196 0c23.2 0 42 18.8 42 42l0 70c0 7.7 6.3 14 14 14s14-6.3 14-14l0-70c0-38.7-31.3-70-70-70L182 56zM284 210.6c-2.6-.8-5.3-.8-7.9 0l-238 70c-7.4 2.2-11.7 10-9.5 17.4s10 11.7 17.4 9.5l220-64.7 0 233.3c0 7.7 6.3 14 14 14s14-6.3 14-14l0-233.3 220 64.7c7.4 2.2 15.2-2.1 17.4-9.5s-2.1-15.2-9.5-17.4l-238-70zM28 462c0-7.7-6.3-14-14-14S0 454.3 0 462c0 54.1 43.9 98 98 98 36.3 0 67.9-19.7 84.9-49 19.7 29.8 56.7 49 97.1 49s77.4-19.2 97.1-49c16.9 29.3 48.6 49 84.9 49 54.1 0 98-43.9 98-98 0-7.7-6.3-14-14-14s-14 6.3-14 14c0 38.7-31.3 70-70 70s-70-31.3-70-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 36.7-35.5 70-84 70s-84-33.3-84-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 38.7-31.3 70-70 70s-70-31.3-70-70z"]],
    "arrows-rotate": [504, 560, [128472, "refresh", "sync"], "f021", ["M84.1 280c0 29.8 7.7 57.7 21.3 82l64.7 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-45 0c30.8 35.5 76.3 58 127 58 92.8 0 168-75.2 168-168 0-29.8-7.7-57.7-21.3-82l-64.7 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l45 0c-30.8-35.5-76.3-58-127-58-92.8 0-168 75.2-168 168z", "M73.8 390c37 60 103.3 100 178.9 100 116 0 210-94 210-210 0-7.7 6.3-14 14-14s14 6.3 14 14c0 131.4-106.6 238-238 238-81.7 0-153.7-41.2-196.6-103.8l0 89.8c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-128c0-7.7 6.3-14 14-14l128 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-96.3 0zM448.1 145.8l0-89.8c0-7.7 6.3-14 14-14s14 6.3 14 14l0 128c0 7.7-6.3 14-14 14l-128 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l96.3 0c-37-60-103.3-100-178.9-100-116 0-210 94-210 210 0 7.7-6.3 14-14 14s-14-6.3-14-14c0-131.4 106.6-238 238-238 81.7 0 153.8 41.2 196.6 103.8z"]],
    "book-open": [560, 560, [128214, 128366], "f518", ["M0 136.6L0 412.2C0 465.6 37.7 511.5 90 522l168 33.6c2.6 .5 5.3 1 8 1.3L266 56c0-1 .1-2.1 .3-3.1-2.8-.3-5.5-.8-8.3-1.3L134 26.8C64.7 12.9 0 65.9 0 136.6zM293.7 52.9c.2 1 .3 2 .3 3.1l0 500.9c2.7-.3 5.3-.8 8-1.3L470 522c52.4-10.5 90-56.4 90-109.8l0-275.6c0-70.7-64.7-123.7-134-109.8L302 51.6c-2.8 .6-5.5 1-8.3 1.3z", "M266 560c0 7.7 6.3 14 14 14s14-6.3 14-14l0-504c0-7.7-6.3-14-14-14s-14 6.3-14 14l0 504z"]],
    "box-archive": [504, 560, ["archive"], "f187", ["M28.2 216.6c8.2 4.7 17.7 7.4 27.8 7.4l392 0c10.1 0 19.6-2.7 27.8-7.4 .2 2.4 .2 4.9 .2 7.4l0 196c0 61.9-50.1 112-112 112l-224 0C78.1 532 28 481.9 28 420l0-196c0-2.5 .1-4.9 .2-7.4zM34.6 186c15.5-43.2 56.9-74 105.4-74l224 0c48.5 0 89.9 30.9 105.4 74-5.1 6.1-12.8 10-21.4 10L56 196c-8.6 0-16.3-3.9-21.4-10zM112 294c0 7.7 6.3 14 14 14l252 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-252 0c-7.7 0-14 6.3-14 14z", "M56 56C40.5 56 28 68.5 28 84l0 84c0 15.5 12.5 28 28 28l392 0c15.5 0 28-12.5 28-28l0-84c0-15.5-12.5-28-28-28L56 56zM0 84C0 53.1 25.1 28 56 28l392 0c30.9 0 56 25.1 56 56l0 84c0 30.9-25.1 56-56 56L56 224c-30.9 0-56-25.1-56-56L0 84zM126 280l252 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-252 0c-7.7 0-14-6.3-14-14s6.3-14 14-14z"]],
    "cake-candles": [560, 560, [127874, "birthday-cake", "cake"], "f1fd", ["M28 252c0-57.1 42.8-104.2 98-111.1l0 13.1c0 7.7 6.3 14 14 14s14-6.3 14-14l0-14 112 0 0 14c0 7.7 6.3 14 14 14s14-6.3 14-14l0-14 112 0 0 14c0 7.7 6.3 14 14 14s14-6.3 14-14l0-13.1c55.2 6.9 98 54 98 111.1 0 38.7-31.3 70-70 70s-70-31.3-70-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 36.7-35.5 70-84 70s-84-33.3-84-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 38.7-31.3 70-70 70s-70-31.3-70-70zm0 68.6c17.8 18.2 42.6 29.4 70 29.4 36.3 0 67.9-19.7 84.9-49 19.7 29.8 56.7 49 97.1 49s77.4-19.2 97.1-49c16.9 29.3 48.6 49 84.9 49 27.4 0 52.2-11.3 70-29.4L532 448c0 61.9-50.1 112-112 112l-280 0C78.1 560 28 509.9 28 448l0-127.4z", "M140 0c-5 0-9.7 2.7-12.2 7.1L103.5 49.7c-3.6 6.3-5.5 13.4-5.5 20.7 0 18.2 11.7 33.7 28 39.4l0 44.3c0 7.7 6.3 14 14 14s14-6.3 14-14l0-44.3c16.3-5.7 28-21.1 28-39.4 0-7.2-1.9-14.4-5.5-20.7L152.2 7.1C149.7 2.7 145 0 140 0zm0 42.2l12.2 21.4c1.2 2.1 1.8 4.4 1.8 6.8 0 7.5-6.1 13.7-13.7 13.7l-.7 0c-7.5 0-13.7-6.1-13.7-13.7 0-2.4 .6-4.7 1.8-6.8L140 42.2zM322 70.3c0-7.2-1.9-14.4-5.5-20.7L292.2 7.1C289.7 2.7 285 0 280 0s-9.7 2.7-12.2 7.1L243.5 49.7c-3.6 6.3-5.5 13.4-5.5 20.7 0 18.2 11.7 33.7 28 39.4l0 44.3c0 7.7 6.3 14 14 14s14-6.3 14-14l0-44.3c16.3-5.7 28-21.1 28-39.4zM280 42.2l12.2 21.4c1.2 2.1 1.8 4.4 1.8 6.8 0 7.5-6.1 13.7-13.7 13.7l-.7 0c-7.5 0-13.7-6.1-13.7-13.7 0-2.4 .6-4.7 1.8-6.8L280 42.2zM462 70.3c0-7.2-1.9-14.4-5.5-20.7L432.2 7.1C429.7 2.7 425 0 420 0s-9.7 2.7-12.2 7.1L383.5 49.7c-3.6 6.3-5.5 13.4-5.5 20.7 0 18.2 11.7 33.7 28 39.4l0 44.3c0 7.7 6.3 14 14 14s14-6.3 14-14l0-44.3c16.3-5.7 28-21.1 28-39.4zM420 42.2l12.2 21.4c1.2 2.1 1.8 4.4 1.8 6.8 0 7.5-6.1 13.7-13.7 13.7l-.7 0c-7.5 0-13.7-6.1-13.7-13.7 0-2.4 .6-4.7 1.8-6.8L420 42.2zM28 252c0-7.7-6.3-14-14-14S0 244.3 0 252c0 54.1 43.9 98 98 98 36.3 0 67.9-19.7 84.9-49 19.7 29.8 56.7 49 97.1 49s77.4-19.2 97.1-49c16.9 29.3 48.6 49 84.9 49 54.1 0 98-43.9 98-98 0-7.7-6.3-14-14-14s-14 6.3-14 14c0 38.7-31.3 70-70 70s-70-31.3-70-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 36.7-35.5 70-84 70s-84-33.3-84-70c0-7.7-6.3-14-14-14s-14 6.3-14 14c0 38.7-31.3 70-70 70s-70-31.3-70-70z"]],
    "circle-info": [560, 560, ["info-circle"], "f05a", ["M0 280a280 280 0 1 0 560 0 280 280 0 1 0 -560 0zM210 406c0-7.7 6.3-14 14-14l42 0 0-140-28 0c-7.7 0-14-6.3-14-14s6.3-14 14-14l42 0c7.7 0 14 6.3 14 14l0 154 42 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-112 0c-7.7 0-14-6.3-14-14zm91-238a21 21 0 1 1 -42 0 21 21 0 1 1 42 0z", "M280 189a21 21 0 1 0 0-42 21 21 0 1 0 0 42zm-42 35c-7.7 0-14 6.3-14 14s6.3 14 14 14l28 0 0 140-42 0c-7.7 0-14 6.3-14 14s6.3 14 14 14l112 0c7.7 0 14-6.3 14-14s-6.3-14-14-14l-42 0 0-154c0-7.7-6.3-14-14-14l-42 0z"]],
    "layer-group": [560, 560, [], "f5fd", ["M0 168c0 8.6 4.9 16.4 12.6 20L249.2 301.3c9.2 4.4 19.2 6.7 29.4 6.7 10.1 0 20.1-2.2 29.2-6.6L547.4 188c7.7-3.7 12.7-11.4 12.7-20s-4.9-16.3-12.7-20L307.9 34.6c-9.1-4.3-19.1-6.6-29.2-6.6-10.2 0-20.2 2.3-29.4 6.7L12.6 148C4.9 151.6 0 159.4 0 168z", "M20.5 267.6c-6.8-3.6-15.3-1-18.9 5.9s-1 15.3 5.9 18.9L247.4 418.7c20.4 10.7 44.8 10.7 65.2 0L552.5 292.4c6.8-3.6 9.5-12.1 5.9-18.9s-12.1-9.5-18.9-5.9L299.6 393.9c-12.2 6.4-26.9 6.4-39.1 0L20.5 267.6zm0 112c-6.8-3.6-15.3-1-18.9 5.9s-1 15.3 5.9 18.9L247.4 530.7c20.4 10.7 44.8 10.7 65.2 0L552.5 404.4c6.8-3.6 9.5-12.1 5.9-18.9s-12.1-9.5-18.9-5.9L299.6 505.9c-12.2 6.4-26.9 6.4-39.1 0L20.5 379.6z"]],
    "shield": [560, 560, [128737, "shield-blank"], "f132", ["M14 160c0 104.3 45.4 293.1 236.1 379.7 5.2 2.3 10.5 3.9 15.9 5l0-528.2c-.5 .2-1 .4-1.5 .6L56.2 100.6C31.8 111 12.9 132.9 14 160zM294 16.9l0 527.6c5-1 10-2.6 14.8-4.8 190.6-86.6 236.1-275.4 237.2-379.7 0-27.1-18.8-49-43.2-59.5L294.4 17.1c-.1-.1-.3-.1-.4-.2z", "M280 0c7.7 0 14 6.3 14 14l0 532c0 7.7-6.3 14-14 14s-14-6.3-14-14l0-532c0-7.7 6.3-14 14-14z"]],
    "cart-shopping": [560, 560, [128722, "shopping-cart"], "f07a", ["M104.7 84.2l41.9 272.2c.4 2.6 1 5.2 1.9 7.6l295.4 0c35.3 0 66.1-24 74.7-58.3L558.5 146c1-4 1.5-8 1.5-12.1 0-27.5-22.3-49.9-49.9-49.9l-404 0c-.5 0-1 .1-1.5 .2z", "M0 42c0-7.7 6.3-14 14-14l40 0c24.2 0 44.8 17.6 48.4 41.5l44.1 286.8c3.2 20.5 20.8 35.6 41.5 35.6l302 0c7.7 0 14 6.3 14 14s-6.3 14-14 14l-302 0c-34.6 0-63.9-25.2-69.2-59.4L74.7 73.8C73.2 63.6 64.3 56 54 56L14 56C6.3 56 0 49.7 0 42zM196 532a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm0-84a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm280 56a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zm-84 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]]
  };

  bunker(function () {
    defineIcons('fatl', icons);
  });

}());
