/*!
 * Font Awesome Pro 7.1.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2025 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};
  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {} // eslint-disable-line no-empty

  var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithoutHoles(r) {
    if (Array.isArray(r)) return _arrayLikeToArray(r);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _iterableToArray(r) {
    if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r);
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _toConsumableArray(r) {
    return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }

  var _dt;
  var q = {
      classic: {
        fa: "solid",
        fas: "solid",
        "fa-solid": "solid",
        far: "regular",
        "fa-regular": "regular",
        fal: "light",
        "fa-light": "light",
        fat: "thin",
        "fa-thin": "thin",
        fab: "brands",
        "fa-brands": "brands"
      },
      duotone: {
        fa: "solid",
        fad: "solid",
        "fa-solid": "solid",
        "fa-duotone": "solid",
        fadr: "regular",
        "fa-regular": "regular",
        fadl: "light",
        "fa-light": "light",
        fadt: "thin",
        "fa-thin": "thin"
      },
      sharp: {
        fa: "solid",
        fass: "solid",
        "fa-solid": "solid",
        fasr: "regular",
        "fa-regular": "regular",
        fasl: "light",
        "fa-light": "light",
        fast: "thin",
        "fa-thin": "thin"
      },
      "sharp-duotone": {
        fa: "solid",
        fasds: "solid",
        "fa-solid": "solid",
        fasdr: "regular",
        "fa-regular": "regular",
        fasdl: "light",
        "fa-light": "light",
        fasdt: "thin",
        "fa-thin": "thin"
      },
      slab: {
        "fa-regular": "regular",
        faslr: "regular"
      },
      "slab-press": {
        "fa-regular": "regular",
        faslpr: "regular"
      },
      thumbprint: {
        "fa-light": "light",
        fatl: "light"
      },
      whiteboard: {
        "fa-semibold": "semibold",
        fawsb: "semibold"
      },
      notdog: {
        "fa-solid": "solid",
        fans: "solid"
      },
      "notdog-duo": {
        "fa-solid": "solid",
        fands: "solid"
      },
      etch: {
        "fa-solid": "solid",
        faes: "solid"
      },
      jelly: {
        "fa-regular": "regular",
        fajr: "regular"
      },
      "jelly-fill": {
        "fa-regular": "regular",
        fajfr: "regular"
      },
      "jelly-duo": {
        "fa-regular": "regular",
        fajdr: "regular"
      },
      chisel: {
        "fa-regular": "regular",
        facr: "regular"
      },
      utility: {
        "fa-semibold": "semibold",
        fausb: "semibold"
      },
      "utility-duo": {
        "fa-semibold": "semibold",
        faudsb: "semibold"
      },
      "utility-fill": {
        "fa-semibold": "semibold",
        faufsb: "semibold"
      }
    };
  var i = "classic",
    t = "duotone",
    d = "sharp",
    l = "sharp-duotone",
    f = "chisel",
    n = "etch",
    h = "jelly",
    o = "jelly-duo",
    u = "jelly-fill",
    g = "notdog",
    s = "notdog-duo",
    y = "slab",
    m = "slab-press",
    e = "thumbprint",
    p = "utility",
    a = "utility-duo",
    w = "utility-fill",
    x = "whiteboard",
    b = "Classic",
    c = "Duotone",
    I = "Sharp",
    F = "Sharp Duotone",
    v = "Chisel",
    S = "Etch",
    A = "Jelly",
    P = "Jelly Duo",
    j = "Jelly Fill",
    B = "Notdog",
    N = "Notdog Duo",
    k = "Slab",
    D = "Slab Press",
    T = "Thumbprint",
    C = "Utility",
    W = "Utility Duo",
    K = "Utility Fill",
    R = "Whiteboard",
    dt = (_dt = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, i, b), t, c), d, I), l, F), f, v), n, S), h, A), o, P), u, j), g, B), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_dt, s, N), y, k), m, D), e, T), p, C), a, W), w, K), x, R));
  var gt = {
      classic: {
        900: "fas",
        400: "far",
        normal: "far",
        300: "fal",
        100: "fat"
      },
      duotone: {
        900: "fad",
        400: "fadr",
        300: "fadl",
        100: "fadt"
      },
      sharp: {
        900: "fass",
        400: "fasr",
        300: "fasl",
        100: "fast"
      },
      "sharp-duotone": {
        900: "fasds",
        400: "fasdr",
        300: "fasdl",
        100: "fasdt"
      },
      slab: {
        400: "faslr"
      },
      "slab-press": {
        400: "faslpr"
      },
      whiteboard: {
        600: "fawsb"
      },
      thumbprint: {
        300: "fatl"
      },
      notdog: {
        900: "fans"
      },
      "notdog-duo": {
        900: "fands"
      },
      etch: {
        900: "faes"
      },
      chisel: {
        400: "facr"
      },
      jelly: {
        400: "fajr"
      },
      "jelly-fill": {
        400: "fajfr"
      },
      "jelly-duo": {
        400: "fajdr"
      },
      utility: {
        600: "fausb"
      },
      "utility-duo": {
        600: "faudsb"
      },
      "utility-fill": {
        600: "faufsb"
      }
    };
  var _t = {
      chisel: {
        regular: "facr"
      },
      classic: {
        brands: "fab",
        light: "fal",
        regular: "far",
        solid: "fas",
        thin: "fat"
      },
      duotone: {
        light: "fadl",
        regular: "fadr",
        solid: "fad",
        thin: "fadt"
      },
      etch: {
        solid: "faes"
      },
      jelly: {
        regular: "fajr"
      },
      "jelly-duo": {
        regular: "fajdr"
      },
      "jelly-fill": {
        regular: "fajfr"
      },
      notdog: {
        solid: "fans"
      },
      "notdog-duo": {
        solid: "fands"
      },
      sharp: {
        light: "fasl",
        regular: "fasr",
        solid: "fass",
        thin: "fast"
      },
      "sharp-duotone": {
        light: "fasdl",
        regular: "fasdr",
        solid: "fasds",
        thin: "fasdt"
      },
      slab: {
        regular: "faslr"
      },
      "slab-press": {
        regular: "faslpr"
      },
      thumbprint: {
        light: "fatl"
      },
      utility: {
        semibold: "fausb"
      },
      "utility-duo": {
        semibold: "faudsb"
      },
      "utility-fill": {
        semibold: "faufsb"
      },
      whiteboard: {
        semibold: "fawsb"
      }
    };
  var qt = {
      kit: {
        fak: "kit",
        "fa-kit": "kit"
      },
      "kit-duotone": {
        fakd: "kit-duotone",
        "fa-kit-duotone": "kit-duotone"
      }
    },
    Ht = ["kit"];
  var L = "kit",
    r = "kit-duotone",
    U = "Kit",
    J = "Kit Duotone",
    $t = _defineProperty(_defineProperty({}, L, U), r, J);
  var ol = {
    kit: {
      "fa-kit": "fak"
    },
    "kit-duotone": {
      "fa-kit-duotone": "fakd"
    }
  };
  var fl = {
      kit: {
        fak: "fa-kit"
      },
      "kit-duotone": {
        fakd: "fa-kit-duotone"
      }
    };
  var ul = {
      kit: {
        kit: "fak"
      },
      "kit-duotone": {
        "kit-duotone": "fakd"
      }
    };

  var _ml;
  var l$1 = {
      GROUP: "duotone-group",
      SWAP_OPACITY: "swap-opacity",
      PRIMARY: "primary",
      SECONDARY: "secondary"
    };
  var n$1 = "classic",
    o$1 = "duotone",
    u$1 = "sharp",
    s$1 = "sharp-duotone",
    h$1 = "chisel",
    g$1 = "etch",
    y$1 = "jelly",
    e$1 = "jelly-duo",
    m$1 = "jelly-fill",
    p$1 = "notdog",
    a$1 = "notdog-duo",
    w$1 = "slab",
    b$1 = "slab-press",
    r$1 = "thumbprint",
    c$1 = "utility",
    i$1 = "utility-duo",
    x$1 = "utility-fill",
    I$1 = "whiteboard",
    F$1 = "Classic",
    v$1 = "Duotone",
    S$1 = "Sharp",
    A$1 = "Sharp Duotone",
    P$1 = "Chisel",
    j$1 = "Etch",
    B$1 = "Jelly",
    N$1 = "Jelly Duo",
    k$1 = "Jelly Fill",
    D$1 = "Notdog",
    C$1 = "Notdog Duo",
    T$1 = "Slab",
    L$1 = "Slab Press",
    W$1 = "Thumbprint",
    R$1 = "Utility",
    K$1 = "Utility Duo",
    U$1 = "Utility Fill",
    J$1 = "Whiteboard",
    ml$1 = (_ml = {}, _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, n$1, F$1), o$1, v$1), u$1, S$1), s$1, A$1), h$1, P$1), g$1, j$1), y$1, B$1), e$1, N$1), m$1, k$1), p$1, D$1), _defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_defineProperty(_ml, a$1, C$1), w$1, T$1), b$1, L$1), r$1, W$1), c$1, R$1), i$1, K$1), x$1, U$1), I$1, J$1));
  var E$1 = "kit",
    d$1 = "kit-duotone",
    _$1 = "Kit",
    M$1 = "Kit Duotone",
    rt$1 = _defineProperty(_defineProperty({}, E$1, _$1), d$1, M$1);
  var $t$1 = {
      classic: {
        "fa-brands": "fab",
        "fa-duotone": "fad",
        "fa-light": "fal",
        "fa-regular": "far",
        "fa-solid": "fas",
        "fa-thin": "fat"
      },
      duotone: {
        "fa-regular": "fadr",
        "fa-light": "fadl",
        "fa-thin": "fadt"
      },
      sharp: {
        "fa-solid": "fass",
        "fa-regular": "fasr",
        "fa-light": "fasl",
        "fa-thin": "fast"
      },
      "sharp-duotone": {
        "fa-solid": "fasds",
        "fa-regular": "fasdr",
        "fa-light": "fasdl",
        "fa-thin": "fasdt"
      },
      slab: {
        "fa-regular": "faslr"
      },
      "slab-press": {
        "fa-regular": "faslpr"
      },
      whiteboard: {
        "fa-semibold": "fawsb"
      },
      thumbprint: {
        "fa-light": "fatl"
      },
      notdog: {
        "fa-solid": "fans"
      },
      "notdog-duo": {
        "fa-solid": "fands"
      },
      etch: {
        "fa-solid": "faes"
      },
      jelly: {
        "fa-regular": "fajr"
      },
      "jelly-fill": {
        "fa-regular": "fajfr"
      },
      "jelly-duo": {
        "fa-regular": "fajdr"
      },
      chisel: {
        "fa-regular": "facr"
      },
      utility: {
        "fa-semibold": "fausb"
      },
      "utility-duo": {
        "fa-semibold": "faudsb"
      },
      "utility-fill": {
        "fa-semibold": "faufsb"
      }
    },
    z = {
      classic: ["fas", "far", "fal", "fat", "fad"],
      duotone: ["fadr", "fadl", "fadt"],
      sharp: ["fass", "fasr", "fasl", "fast"],
      "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"],
      slab: ["faslr"],
      "slab-press": ["faslpr"],
      whiteboard: ["fawsb"],
      thumbprint: ["fatl"],
      notdog: ["fans"],
      "notdog-duo": ["fands"],
      etch: ["faes"],
      jelly: ["fajr"],
      "jelly-fill": ["fajfr"],
      "jelly-duo": ["fajdr"],
      chisel: ["facr"],
      utility: ["fausb"],
      "utility-duo": ["faudsb"],
      "utility-fill": ["faufsb"]
    },
    Ht$1 = {
      classic: {
        fab: "fa-brands",
        fad: "fa-duotone",
        fal: "fa-light",
        far: "fa-regular",
        fas: "fa-solid",
        fat: "fa-thin"
      },
      duotone: {
        fadr: "fa-regular",
        fadl: "fa-light",
        fadt: "fa-thin"
      },
      sharp: {
        fass: "fa-solid",
        fasr: "fa-regular",
        fasl: "fa-light",
        fast: "fa-thin"
      },
      "sharp-duotone": {
        fasds: "fa-solid",
        fasdr: "fa-regular",
        fasdl: "fa-light",
        fasdt: "fa-thin"
      },
      slab: {
        faslr: "fa-regular"
      },
      "slab-press": {
        faslpr: "fa-regular"
      },
      whiteboard: {
        fawsb: "fa-semibold"
      },
      thumbprint: {
        fatl: "fa-light"
      },
      notdog: {
        fans: "fa-solid"
      },
      "notdog-duo": {
        fands: "fa-solid"
      },
      etch: {
        faes: "fa-solid"
      },
      jelly: {
        fajr: "fa-regular"
      },
      "jelly-fill": {
        fajfr: "fa-regular"
      },
      "jelly-duo": {
        fajdr: "fa-regular"
      },
      chisel: {
        facr: "fa-regular"
      },
      utility: {
        fausb: "fa-semibold"
      },
      "utility-duo": {
        faudsb: "fa-semibold"
      },
      "utility-fill": {
        faufsb: "fa-semibold"
      }
    },
    G$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"],
    O$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
    V$1 = O$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]),
    $$1 = ["aw", "fw", "pull-left", "pull-right"],
    to = [].concat(_toConsumableArray(Object.keys(z)), G$1, $$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(O$1.map(function (t) {
      return "".concat(t, "x");
    })).concat(V$1.map(function (t) {
      return "w-".concat(t);
    }));

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e$$1) {
      return false;
    }
  }();
  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[i];
      }
    });
  }
  var _PREFIX_TO_STYLE = _objectSpread2({}, q);

  // We changed FACSSClassesToStyleId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _PREFIX_TO_STYLE below, so we are manually adding
  // {'fa-duotone': 'duotone'}
  _PREFIX_TO_STYLE[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    'fa-duotone': 'duotone'
  }), q[i]), qt['kit']), qt['kit-duotone']);
  var PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE);
  var _STYLE_TO_PREFIX = _objectSpread2({}, _t);

  // We changed FAStyleIdToShortPrefixId in the icons repo to be canonical and as such, "classic" family does not have any
  // duotone styles.  But we do still need duotone in _STYLE_TO_PREFIX below, so we are manually adding {duotone: 'fad'}
  _STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, {
    duotone: 'fad'
  }), _STYLE_TO_PREFIX[i]), ul['kit']), ul['kit-duotone']);
  var STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX);
  var _PREFIX_TO_LONG_STYLE = _objectSpread2({}, Ht$1);
  _PREFIX_TO_LONG_STYLE[i] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[i]), fl['kit']);
  var PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE);
  var _LONG_STYLE_TO_PREFIX = _objectSpread2({}, $t$1);
  _LONG_STYLE_TO_PREFIX[i] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[i]), ol['kit']);
  var LONG_STYLE_TO_PREFIX = familyProxy(_LONG_STYLE_TO_PREFIX);
  var _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, gt);
  var FONT_WEIGHT_TO_PREFIX = familyProxy(_FONT_WEIGHT_TO_PREFIX);
  var RESERVED_CLASSES = [].concat(_toConsumableArray(Ht), _toConsumableArray(to));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w$2 = WINDOW || {};
  if (!w$2[NAMESPACE_IDENTIFIER]) w$2[NAMESPACE_IDENTIFIER] = {};
  if (!w$2[NAMESPACE_IDENTIFIER].styles) w$2[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$2[NAMESPACE_IDENTIFIER].hooks) w$2[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$2[NAMESPACE_IDENTIFIER].shims) w$2[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w$2[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;
      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }

    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */
    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "dollar-sign": [384, 512, [128178, 61781, "dollar", "usd"], "24", "M224 11.9c-10.2-48.4-76.4-27.8-62.3 18.8-61.5 5.1-146 36.7-141.7 110.5-1.8 83.1 50 117.4 120.5 129.2 7.4 1.7 13.8 3.3 20.9 4.7-1.6 47.8-.5 97.3-.2 147.5-8.2-.6-16.6-1.3-25.4-2.1-33.4 1.8-108.8-25.8-111.6 29.3 6.2 48 72.4 25.1 105.6 34.4 10.1 .9 20.4 1.8 30.8 2.5-7.9 53.9 69.3 54.8 64 .7 84.3-2.7 169.7-52.7 158.3-150.1-19-88.5-94.1-100.4-156.2-115.8 1-38.1-1.2-74.8 .2-112.6 .1-5.8 .3-11.7 .4-17.7 35.4-3.6 111.2 28 116.8-27-1.7-41.5-48.8-30.1-78-34.5-13.5-1-26.5-2.2-40.5-2.6-.4-5-1-10-1.6-15zM163.2 95.1c-.1 3.6-.2 7.2-.2 10.8-1.3 33.2 .5 70.3 0 103.9-3.3-.8-6.7-1.6-10.1-2.3-14.8-2.7-54.3-13.7-59.1-23.6-5.7-10.8-10-26.8-9.7-41.3 .3-14.7 4.9-22 9.8-25.2 18-12.1 42.4-18.4 69.4-22.3zm62 191.1c42.4 9.1 93.2 27.9 94.7 61.6 4.8 12.9-14.2 53.3-26.8 56.9-23 10.9-45.1 16.2-67.8 18.3-.1-17.3-.2-34.9-.4-50.6-.4-33.8-.5-54.4 .4-86.2z"],
    "calendar-check": [512, 512, [], "f274", "M190 4.1c.1-4.3 .2-8 .3-11 .9-6.4 1-11.5-.8-18.2-7.4-29.7-52.2-30.6-61.1-1.6-7.4 21.9-3.3 49.9-1.9 72.2-54.4 9.1-98.7 20.6-94.7 85.8-.4 96.3-18.7 203.1 9.8 297.2 9.2 31.5 37.1 41.7 63.4 46.2 30.3 4.6 100.1 9.2 167.9 9.2 61.8-2.3 121.4 2.2 175.5-24 33.2-13.9 38.3-45 37.4-79.3 2.6-40.3 1.7-76.4 3.9-118.4 2-56.1 6.9-120.5-13.2-173.6-20.4-31.9-55.7-34.2-90.8-41.7-4.5-31.3 12.1-87.9-33.5-90.3-43.5 2.1-30.3 52.9-30.8 83.3-42.8-2.9-88.9-3.3-131.3-.9-.5-8.1-.5-22-.3-35zM416.7 119.9c1.5 .5 2.7 1.1 3.6 1.5 16.1 76.6 1.8 173.6 1.9 253.9-.4 8.7-.9 17.6-1.3 26.8-1.9 1.1-3.9 2.2-5.9 3.3-82.7 24.5-246.2 15.5-312.7 2.8-16-46.4-12.7-119.9-10.1-175.4 2-32.6 1.3-62.6 3.3-94 .4-6.2 .8-12.8 1.2-20.2 93.8-25.6 227-22.5 320 1.5zM360.8 228.2c11.4-13.5 9.7-33.7-3.8-45.1-13.5-11.4-33.7-9.7-45.1 3.8-20.1 23.9-44.4 46.9-68.1 69.3-6.1 5.8-12.2 11.6-18.4 17.5-18.4-19.4-48.3-51.3-73.4-22.8-11.5 13.4-9.9 33.7 3.6 45.1 66 61.6 59.7 82.5 131.4 7.5 25.4-24 50.5-47.6 73.8-75.2l0 0z"],
    "question": [320, 512, [10067, 10068, 61736], "3f", "M59.5 137.5c17.5-100.5 148.8-94.2 192.5-14.9 17.8 61.6-11.6 112.5-83 133.7-43.9 9.3-66.2 96.3-11 101.1 22.2 .4 34.3-21 32.4-40.7 200.8-60.3 161.5-321.9-55.9-318.5-71.3 3.5-135.4 68.4-138.9 139.4 .3 41.9 63.8 41.9 64 0zm98 261.2c-59.8 1.7-53.5 95 3.7 93.8 29.9-2.8 38.1-24.4 40.7-47.9 1.9-23-21.5-46.8-44.4-45.9z"],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", "M2.1 255.5c.5-17.7 15.2-31.6 32.8-31.2 128.7 3.4 257.3 5 386.3 6.5 17.7 .2 31.8 14.7 31.6 32.4s-14.7 31.8-32.4 31.6c-129-1.5-258-3.1-387.3-6.5-17.7-.5-31.6-15.2-31.2-32.8z"],
    "microphone-slash": [576, 512, [], "f131", "M46.5-21.6c-34.5-23.6-70.8 28.7-36.4 52.6 59.7 44.8 112 97.4 161 153.3 111.9 124.2 235 240.2 353.3 359.6 28.3 30.6 75.4-12.3 47.1-43.3-117.6-119-239.4-233.2-352.3-358.3-29.6-32.8-60.5-69-94.4-97.4-26.1-22.9-49.4-47.1-78.4-66.4zM270 75.1c32.5-18 52.4-3.8 53.8 31.1l3.6 60.4c1.1 17.6 16.2 31.1 33.9 30 17.6-1.1 31.1-16.2 30-33.9l-3.5-59.5c1.4-80-83.8-127.5-151.5-82.5-35.5 22.3-1.9 76.3 33.8 54.4zM515.5 217.4c6.4-41.3-56.4-51.4-63.2-10l-11.9 74.7c-6.4 41.3 56.4 51.4 63.2 10l11.9-74.7zM109 205.7c-56.8 5.2-22.7 85.9-14.7 115.2 22.7 72.5 94.4 123.3 165.1 132-1.5 22.2-14.1 83 30.2 82.3 17.7-.4 31.7-14.9 31.3-32.6-.4-17.9 .6-26.9 1.4-35.1 2.1-23.1 6.1-65.9-27.2-73.4-97.9-8.7-147-63.1-154.2-156.4 0-17.7-14.3-32-32-32z"],
    "cloud-slash": [640, 512, [], "e137", "M25.5-27c13.1-11.9 33.3-10.9 45.2 2.2 74.4 84.2 117 106.7 183 171 33.3 31.1 62.9 64.8 97.7 95.4 50 44.4 89.5 99.2 143.8 142.8 36.3 32.2 73.2 64 107.3 100.9 12 13 11.2 33.2-1.8 45.2-13 12-33.2 11.2-45.2-1.8-27.8-30.1-58.4-57.2-90.4-85.5-56.4-44.8-101.6-102.3-155.5-153-34.5-30-66.2-65.9-100.2-97.7-64.9-62.8-112.4-90.5-186.2-174.3-11.9-13.1-10.9-33.3 2.2-45.2zM133.1 206c8 15.8 1.7 35-14 43-41.5 19.8-47.3 113-11.6 143 22.2 17.9 62.1 13.5 88 18.8 46 2.8 92 7.4 140.2 5.1 17.7 0 32 14.3 32 32-.1 29.5-29.8 34.4-53.7 32.2-34.4 1.7-72.2-1.8-108.2-4.8-50.3-5.3-104.8-1-144.8-39.2-63.7-67.8-56.2-197.4 30.7-245 15.4-6.8 33.6-.4 41.4 14.8zM275 92.7c-16.6 6-35-2.7-41-19.3-6-16.6 2.7-35 19.3-41 96.6-37.7 179.4 26.4 203.5 118.6 88.6 12 162.4 107 136.6 196.7-5.5 16.8-23.6 25.9-40.4 20.4s-25.9-23.6-20.4-40.4c6.5-19.8 .1-47.7-19.6-73.2-20.1-25.5-46.5-41.1-69.3-39.8-17.3 5.3-40.7-4.2-43.9-24.2-1.6-7.8-3.7-18.1-5.5-25.8-23.4-61.8-52.7-93.2-119.3-72z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M192.4 96.9l0 0c-47 7.8-60.7 58.4-69.5 101 82.4-10.5 189.5-9.1 267.8 1.1-4.9-27.9-10.5-54.2-20-78.2-1.1-2.8-6.1-8.8-23.8-14.5-48.4-13-105.3-17.5-154.5-9.4zM54.6 217.4c17.5-153.4 91.6-207.4 247.9-184.7 128 11.1 137.1 64.5 155.4 179.3 .3 1.9 .6 3.7 .9 5.6 35.2 21.9 51.2 63.4 51.2 102.1l0 159.7c-.2 41.8-63.8 41.9-64 0l0-31.6c-13.7 .3-27.7 .6-41.7 1-110.7 4.2-226.9-5.4-340.6-2.6l-.6 30.1c-1 41.8-64.6 40.6-64-1.2L.2 419.6c.4-62.3-14.9-161.9 54.4-202.2zm357.1 49.5c-79.9-14.8-217.8-17.2-305.8-1.9-48.9 6.6-43.5 76.2-41.9 117.2 127.8-2.3 255.9 7.4 382.1 1.6-1.6-35.1 11.3-110.6-34.4-116.9zM162.4 319.6c.8 38.5-47.2 46.8-61 18.3-22.4-49.5 56.1-73.6 61-18.3zm230.4-34.6c-37.8-9.1-60.7 45.3-24.1 62.4 42 18.4 70.3-48.4 24.1-62.4zm.8 62.8l.7-.3c-.3 .1-.6 .2-.7 .3z"],
    "filter": [512, 512, [], "f0b0", "M464.8 32.3c29.8-5.5 42.4 22.6 40.1 45.9 3.4 31.2 1.9 64.8-15 88.6-40 52.4-94.6 85.1-139.6 133.5 .6 54 5.5 95.5 9.3 146.9 4 41.2-34.9 75.6-77 58.9-43.4-19.6-87.2-42.6-116.2-76.8-13.4-40.2-4.5-85.8-8.2-128 0 0-.1-.2-.2-.3-70.6-45.4-162.7-114.1-161-206.6-1.1-37.4 30.8-62.3 62.8-61.9 135.5 2 270.3 7.9 405-.2zM442.1 97.4c-127.8 6.8-254.1 .7-380.9-.9 3.4 66.5 73.8 110.3 124.8 146.3 55.5 28.6 31.6 103.7 38.3 154.9 22.5 17.2 46.3 32.9 70.6 44.1-3.5-47.8-8.2-90.4-8.7-141.2-.3-15.4 5.1-30.9 16.3-42.9 17.8-19.1 36.3-33.9 55-51.6 24.6-24.9 56.4-45 78.2-73.4 9.3-14.5 5-22.2 6.3-35.2z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M448.7 32c-68.7 0-137.1 4.3-205.8 3.9-11.1-.1-22.4-.1-33.7-.2-45.2-.3-91.8-.7-139.4 .5-35.2 .9-60.9 29.4-63 61.5-7.5 109.9-7.4 215.5 2.9 324.3 3.1 32.9 30.7 57.9 63.7 57.9l370.3 0c35.3 0 64-28.7 64-64l0-124c0-66.8 7.2-133.5 4.2-200.3-1.5-34.6-30.5-59.6-63.1-59.6zM242.5 99.9c55.9 .3 111.8 0 168-3.9l37.4 0c.6 14.3 .7 28.6 .5 43.1-20 12.8-39.8 26.4-60.6 37.9-45 24.8-84.2 58.4-128.7 83.9-45-32.6-93-61.3-139.4-91.7-16.9-11.1-33.7-24.6-51.9-33.6 .6-7.2-1.5-30.2 3.5-35.2 .1-.1 .2-.1 .2-.1 46.5-1.1 91.7-.8 136.8-.5 11.4 .1 22.9 .2 34.3 .2zM64.5 209.5c6.1 4 12.9 8.4 20.1 13.1 26.9 17.6 58.9 38.8 80 53.1 24 16.3 50.6 38.7 78.1 50.1 2.5 1 6.4 2.4 11.2 3 4.7 .6 12.5 .6 20.6-3.6 51-26.1 94.1-64.7 144.2-92.2 5.6-3.1 16.2-9.6 27-16.4-1.1 24.7-2.1 50-2.1 75.3l0 124-370.3 0-8.8-92.5 0-114z"],
    "cloud-arrow-up": [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M342 85.3c22.2-.4 30.7 .8 41.2 8.3 37.2 26.5 45.5 52.5 63.2 107.6 3.7 12.3 14.3 20.9 26.2 22.5 57.8 14.1 121.6 120.9 51.5 167.1-22 14.2-50.4 19.7-84.5 25.6-42.6 8.4-29.4 71.8 13.1 62.7 89.8-7.8 189.8-70.1 163.3-177.5-17.3-54.4-49.5-111.7-113.6-135.6-14.8-66.3-79.8-156.5-161.4-144.9-86.8-2-164.4 52.2-178.3 142.3-84.4 14.1-128.5 95.6-132.1 175.3-6.5 102 90.1 155.7 179 138.1 41.2-7.6 30-70.1-11.3-63-112.4 18.6-127.1-84.3-75.6-156.4 15.6-19.9 37.2-32.2 66.3-32.2 17.1 0 31-13.4 31.9-30.2 4-18.8 13-54.4 25.4-72.6 25.2-26.1 55.3-36.7 95.6-37.4zM295.2 200.6c-32.4 30.2-62.8 62.1-93.9 93-12.5 12.5-12.6 32.7-.1 45.3 28.4 27.3 55.4-10.2 74.5-29.3 4.5-4.5 8.9-9 13.3-13.4-1.1 66.9-1.9 109.2 1.2 166.4 7.6 51.5 75.4 33.1 63.4-16.6-2.6-50.9-1.3-88.1-.5-149.5l47.4 40.1c32.1 26.9 73.2-21.7 41.3-48.8l-104-88c-12.4-10.5-30.6-10-42.5 1z"],
    "at": [512, 512, [61946], "40", "M121.4 49.7c104.3-88.7 259-37.4 335.1 65.7 42.4 53.6 73.9 144.3 31.5 210-25.6 42.4-104.1 75.9-138.9 28.2-61.8 45.4-155.6 50.1-203.6-14.9-28.7-58.2-20.2-121.1 17.8-162.6 42-53.7 133.8-69.2 176-12.3 36.1 43.9 28 107.8 60.2 149.8 34.5-11.7 43.6-28.1 44.5-61.5-5.1-85.8-81.8-161.9-164-181.2-86.1-21.3-166.8 57.6-201.9 129.1-18.6 40.3-16.3 86-4.4 135.2 10.1 45.5 61 93.2 116.5 107.6 31.2 6.6 95.2-8.8 92 41.1-2.9 23.1-26.1 30.9-46.5 26.5-16.9-1.3-36.7-1.9-54.4-4.2-16.2-2.3-34.4-6.8-51.8-17.8-48.8-30.8-100.4-65.3-118-138.1-35.8-111.5 14.2-232 109.8-300.4zm196.8 240c-8.9-28.8-13-77.1-39.2-95.2-7.4-2.7-31.3-3.4-37.3 .3-14.3 5.4-45.9 35.9-46.3 50.7-1.7 38.5-9.2 56.9 22 71.6 29 13.7 89.4 3.6 100.8-27.4z"],
    "truck": [640, 512, [128666, 9951], "f0d1", "M189.7 34.7c68.2-.5 133.3-5.6 201.6-.2 51.8 4.7 61 54.9 57.7 97.6l34.6 0c96.5-.9 162.6 82.6 156 177 1 24.4-.3 47.8-1.7 71.2-1.7 56.8-.2 75-64.4 68.3-15.5 125.7-210.1 124.8-219.1 0l-65.7 0c-6.6 50.2-54.1 100.7-106.4 94.9-65 2-103.8-36.6-110.6-94.1-91.4 2.7-69.3-106.2-69.6-166.3 1.3-60.6 6.1-114.6 5.3-182.8 .1-34.8 28.1-63.1 62.8-63.4 39.2-.4 79.2-1.4 119.5-2.3zm177 350.6c5.2-10.4 11.3-19.7 19.1-28.6 6.2-98.3 .7-168.5-.3-259.2-107.6-5.9-207.6 2.9-314.7 2.7l-.2 .2C72.1 203.3 59.7 284.4 65.3 386l14.6 .3c44.8-82.8 164.1-81.9 201.7-1l85.1 0zm83.7-60.7c48.7-3.8 98.6 14.4 113.4 60.3 .3-.1 10 .4 10.6 .4 1.4-24.6 3.1-50 2.1-73.7 .3-42.9-5.4-76.4-42.6-102.3-19.5-15.3-59.2-14.4-83.2-14 1.1 40.2 1.8 82.2-.4 129.2zM200 390.4c-22.6-8.4-62.8 2.7-66.4 36.5-3 14.5 10.1 50 19.5 49.3 13.9 3 38.7 6.8 49.1 1.1 30.2-19.7 36.8-76.2-2.2-86.9zm307.7 63.9c9.7-13.3-3.1-62.1-16.4-62.6-23.6-4.2-49.5-11-63 12.8-42.4 61.1 40.1 107.1 79.3 49.8z"],
    "user-check": [640, 512, [], "f4fc", "M204-1c164.7-22.2 204.3 184.5 57.8 246-90 29.8-188.1-55.5-163-150 15.3-46.6 55.2-87.1 105.2-96l0 0zm84.6 111.7c-.1-38.2-42.2-52.8-75.4-48.3-18.9 1.3-49 32.1-53 50.8-14.3 37.7 45 87.4 79.7 71.7 29.2-10.7 48.7-40 48.7-74.2zm34.8 280.8c-63-17.1-151.9-21.3-212 3.6-17.2 6-49.6 65.6-46.8 83.6 0 17.7-14.3 32-32 32-56-6.7-25.2-78.5-7.7-110.8 22-47.6 74.2-77.2 122.5-80.7 116.9-18 312.1 0 301.3 159.6-.3 41.8-63.7 41.9-64 0 1.4-46-15.2-73.7-61.2-87.2zM615.2 152.1c25.1 26.6-5 49.9-22.8 70.9-20.1 23.8-45.8 54.1-92.2 89-12.4 9.9-31.6 8.6-42.5-3L410 261.3c-29.5-29.7 15.5-74.7 45.2-45.2l27.9 27.9c26.2-21.9 40.3-38.7 54.8-56 16.7-19.6 47.1-65.2 77.3-35.8z"],
    "frame": [576, 512, [], "e495", "M191.6 25.9c0-17.7-14.3-32-32-32-34.4 1-32.1 34.5-33.6 60.1-1.1 12.5-2 27.3-2.6 40.4l-74.8 .7c-17.7 .2-31.8 14.7-31.7 32.3 .2 17.7 14.7 31.9 32.3 31.7l72.8-.7c-.1 7.3-.1 14.5-.1 21.7-.2 56.3-1.1 112.2-.9 168.6-30 1.8-88.9-9.2-86.4 37.4 6.7 42.8 56.8 23.5 87.2 26.6 5.1 32.9-13.4 98.1 36.4 99.6 48.3-6.4 23.9-67.2 27.7-100 54.3 .6 108.1 2.8 162.5 6.4 11.1 .7 22.3 1.5 33.7 2.1 5.1 34.6-19.7 102.5 31.6 107.5 50.7-4.8 26.8-71 32.4-105.5 9.7 .2 19.6 .9 30.8 1.8l.6 .1c25.7 3 69.9 7.8 70.2-30-.9-36.5-39.1-31.8-66.3-33.9-10.8-.8-22.7-1.8-34.9-2 0-25.8 .2-50.1 1-77 1.3-40.7 1.4-82.5-.8-123.1 34.6-3.8 97.6 25.7 106.8-24-.5-52.1-71.3-33.2-105.9-40.1 .5-11.1 1.1-22.3 1.7-33.6 2.5-25.4 6.4-64.2-28.9-66.1-34.2-1.2-34.9 35.4-34.9 60.9-.6 12.1-1.3 24.4-1.8 36.8-16.8-.3-33.6-.4-50.2-.4l-.3 0-145.9 1.4c.5-10.6 1.1-20.1 2-31 1-11.4 2-24.4 2-36.8l0 0zM382.7 356.7c-9.1-.5-18.1-1.1-27.4-1.7-56.2-3.8-113.4-6.1-170.1-6.8-.1-32.8 .2-65.7 .4-98.9 .2-22.9 .4-46.2 .4-69.2 0-7.5 0-14.9 .1-22.3 36.1-.2 162.7-2.1 196.7-1.1 1.8 40.1 2.4 79.3 .9 119.4-.8 25.7-1.1 53.8-1.1 80.6z"],
    "bell": [448, 512, [128276, 61602], "f0f3", "M393.6 262.8c-3.5-5.8-6.6-10.9-9.2-15.5 6.1-119.8-23.6-273.9-183.5-247.5-96.9 13.3-143.2 112.4-136.4 192.3 1.6 19.6 .1 36.2-.1 56.1-17.5 42-37.4 82.7-60.2 120.2-23.6 69.5 81.2 42.3 115.8 43.8 54.8-4.2 110.6-4.4 166.9 .3 27.4 1.9 56.1 3.8 84.9 3.8 .3 0 44.6-.6 45-.6 22.3 .3 38.4-24.9 28.8-45-11.9-26.3-35.8-84.4-52.1-107.8zM209.6 63.3c118.8-18.7 108.9 103.3 110.8 192.3 .4 15.4 11.2 26.7 18.5 40.5 12.2 18.8 20.5 37.5 28.5 56.1-25.2-.2-50.6-1.9-77.2-3.6-55-4.8-119.8-4.5-173.4-.3l-.2 0c-9.5 .6-18.9 1.2-28.3 1.7 10.6-20.3 20.1-41.7 27.2-60.1 0 .1 0 .1 .1-.2 2.6-5.9 6.6-14 9.4-19.8l.1-.2 0 0 0-.1c6.9-26.2 3.5-54.7 3.1-82.8-5.1-59.5 30.1-116.4 81.3-123.4zm63 447.4c41.8-.6 41.2-64.2-.6-64l-87.9 .9c-17.7 .2-31.8 14.6-31.7 32.3 .2 17.7 14.6 31.8 32.3 31.7l87.9-.9z"],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", "M385.2 203.8c0 71.2-7.5 152.8-9.9 224.5-1.2 37.5-28 71.1-67.1 77.3-83.3 11.7-147.8 6.4-236.5 1.4-65.1-6.5-74.4-67-69.4-120.6 2.8-115.9-3.7-202.1 .6-312.7 2.1-42.3 37.3-73.3 77.9-73.5 63.3-.3 181.5-.4 236 1.7 32.4 1.2 58.3 24.6 61.9 57.5 5.4 56.8 5.9 92.6 6.4 144.4zM316.1 332c6-92.4 7.9-172.1-1-266.1-53.2-2.2-169.8-1.9-234-1.7-8.3 0-13.9 6.1-14.2 12.7-3.9 119.8 2.2 228.9-.9 353.2 0 7.9 5.3 12.7 11 13.2 53.6 4.4 92.2 4.6 134.7 4.6 31.4 .6 54.3 .1 86.6-5.5 6.7-1.1 12.8-7.2 13.1-16.1 1-32.2 2.9-63.5 4.7-94.3l0 0zM154.3 344l82 2.9c17.6 .6 31.5 15.5 30.8 33.2s-15.5 31.5-33.1 30.8L152 408c-41.8-1.6-39.5-65.3 2.3-63.9z"],
    "trophy": [576, 512, [127942], "f091", "M413.6 .3c14.8 .2 28.2 12.8 30.7 28.4 4.4 13.2 .6 34.1 5.8 36.8 5.5 1.8 29.2 0 50.2 .3 27.8 .5 53.5-6.9 65.1 22.1 20.5 105.1-12.2 223.3-149 232.2 0 0-19.4 18.3-40.7 32.5-16 12.8-37.1 18.1-54.5 29.1-5 4.7-1.9 23-2.5 23.5 1.6 11.7-2 29.5 4 39.1 10.1 6.1 33.8 1.2 46.7 2.9 27.7 1 39.8 27 28.2 48.6-11.4 19.9-40.1 14.5-58.2 15.4-59.9 .3-139.1 2.8-138.8 2.9-8.4-1.4-17.6-4.3-24.1-10-18.1-17.7-4.7-51.6 18.5-53.4 15.9-3.5 52.1 3.5 60.3-6.3 .6-17-.3-33-.9-47.6 1.4-15.5-13.9-17.9-26.4-23.9-28-9.9-64.6-48-64.6-48-50.5 4.8-109.7-5.5-140.7-46.6-41.6-42.4-28.1-130.1-25.2-183.9 11.3-47.4 85.6-24.6 129-28.9 0 0-4.4-14.3 0-36.6 3.5-29.6 34-30.5 56.4-27.7 77.2 3.3 154-2.2 230.9-.7l0-.1zm29.6 253.5c65.6-4.8 66-70.8 63.5-124.1l-58.3 .6c.8 45.2 4.4 85-5.2 123.5zm-321-64c-2.4-17.2-2.4-39.9-1.6-62.2-17.5-.3-43.1-.6-60.7-.5-6.2 70.3-11.5 137.6 78.5 134.1-8.3-24.5-13.1-49.3-16.2-71.3zm70.4 29.4c10.5 63.1 68.8 131.6 134 88.7 82.9-44.9 54.3-148 56.4-225.1-.6-8.4 1.7-13.4-1.9-15.8-61-1-130.1 1.8-191.4-1.7 0 0-3.2 128.6 2.9 153.9z"],
    "text": [448, 512, [], "f893", "M169.2 89c-36.5-.9-70.5 .6-104.6 8.2-1.5 8.4-.3 18.7-.4 27.8-.1 41.8-63.9 41.9-64 0 0-7.2-.6-14.4-.3-22.3-2.1-113.2 197.6-69 270-74.5 63.5-1.7 185.9-15.9 179.2 80.4-.3 7.5-1.2 10.6-1.2 16.5-.3 41.9-63.7 41.9-64 0 0-9.3 1.7-18.6 1.4-27.2 0-.1-.1-.1-.1-.2-40.3-13.1-89.2-3.9-132.1-5.7 6.9 110.8 .6 209 2 320.2 26-.4 65.6-2.2 65 33.7-.5 17.7-15.2 31.6-32.9 31.1-42.6-1.2-84.1-1.8-125.8 0-17.6 .8-32.6-13-33.3-30.6-1.1-35 37.3-35 62.9-34.3-1.3-112.5 5-210.4-2.2-322.4-6.8-.3-13.4-.5-19.8-.6z"],
    "pen-slash": [576, 512, [], "e213", "M8.9-22.1c12.2-12.8 32.5-13.2 45.2-1 33.6 31.8 131 126.5 163.8 156.2l.1 .1c45.5 40.6 89 87.2 130.3 131.6 49.1 52.8 98.1 104.7 148.9 154.9l67.7 70.4c12.3 12.7 11.9 33-.9 45.2s-33 11.9-45.2-.9l-67.5-70.1C400 413.6 350.7 361.3 301.8 308.8 246.9 247.4 189 193.4 128.8 137L9.9 23.1C-2.9 10.9-3.3-9.4 8.9-22.1zM157.5 252.6c27.1 28.8-10.3 54.7-29.4 74.8-12.4 12.6-25.9 24.1-38.8 36.2l6.8 84.3c34-3.7 67.9-8 101.4-13.2 15.6-18.8 31.2-37.5 47.1-56 27.4-31.6 75.7 9.8 48.5 41.7-7.5 8.6-31 35.9-37.8 44.5-33.1 49.4-101.7 35.6-152.7 46.7-35.9 3.9-67.4-22.8-70.3-58.3-.4-46.3-21.6-106.8 13.2-136.4 17.2-16.1 28.2-24.6 43.6-41.1 17.2-19.1 43.2-47.9 68.3-23zM340 121c-32.9 25.9-72.5-23.7-39.9-50 6.4-4.7 78.9-64.3 84.3-65.4 86.1-39.5 170.3 43.9 155.3 129.7-1.3 22.7-70.2 90.7-83.2 109.4-27.2 31.8-75.7-9.3-48.8-41.4l69.4-82c6-31.9-31.2-74.9-64.2-58.5L340 121z"],
    "camera-slash": [640, 512, [], "e0d9", "M42-22.5c25.5-24.7 50.6 4.1 68.6 23.1 31.5 28.8 58.9 62.6 90.1 93.2 25 24 48.9 50.4 74.3 74.5 18.4 17.9 38.1 37.4 55.4 56.3 64.7 68.5 138.4 127.6 201.8 197.4 22 24.8 49.4 47.2 68.6 72.3 47 44.5-19.6 93.3-51.5 38.2-20.2-25.6-44.5-44.2-64.8-67.8-62.9-69-137.3-128.7-201.2-196.8-17.2-18.7-33.8-35.1-51.9-52.8-56.4-53.8-107.8-111.4-163.6-166.8-19-17.7-51.8-44.3-25.9-70.8l0 0zm52.5 193c17.7-.1 32.1 14.1 32.3 31.7 .2 29.8 1.7 59.6 3.3 90.2 1.7 33.4 3.4 67.4 3.4 101.8 .1 14.3 13.1 29.6 37.4 30.1 45 .3 86.6 1.9 130.1-2.5 14-1.4 27.9-3 44-2.4 41.7 1.8 39.3 65.4-2.6 63.9-56.4 3.8-114.1 7.1-172.9 4.9-49.2-.8-101-36.5-100.1-95.6 0-62.8-6.2-126.2-6.7-190-.1-17.7 14.1-32.1 31.7-32.2zM290.1 97.6c-17.7 0-32-14.3-32-32 2.1-43 52.1-30 82-33.5 25.2-.2 64.2-7.3 84 9.7 20.2 14.3 35.9 35.5 52.3 53.5 5.1 5 19.9 1.8 28.4 2.3 50-1 86.4 40.4 85.4 87.4-.5 25.2-.6 51.4 .6 66.2 .1 .6 .1 1.2 .1 1.8l1.6 71.9c.8 42-62.9 43.2-64 1.4l-1.6-71c-1.4-18.5-1.2-47.2-.7-71.6 .3-13.7-9.5-22.3-20.2-22.1-34.4 4.7-69.1-6.8-90.2-38.2-7.9-9.1-19-22.2-27.9-28.7-32.3 .2-64.7 2.9-97.9 2.9zm96-4.1s.1 0 .3 .2c-.2-.1-.3-.2-.3-.2z"],
    "gift": [512, 512, [127873], "f06b", "M215 129.7c-12.9-23-81.4-87.9-99.4-49.8-.9 14.4 9.3 35.2 16.2 47.6l0 0c.6 1 1.1 2 1.6 3 27.1 .1 54.3-.2 81.5-.6 0-.1 .1-.2 .1-.3l0 .1zm-152.8 .7c-26.6-51.5-1-120.6 60.4-125.9 52.2-3.1 96.7 31.2 129.3 67.9 72.8-99.8 220.2-90.3 190.6 53.8 27-.3 70.5-6.4 71.2 32 .1 21.2-19.6 34.5-39.6 31.9 1 18 2.2 37.9 2.9 54.2-2.2 64.7-5.6 123.6-4.6 188.7-.3 57.4-45.2 79.5-102.1 76.6-64.3 2.2-127.9 2.3-193.2-2.1-62.6-2.1-150.8 4.3-152-85.2-4-88.9 9.6-141.5 6.8-228-42.2 .3-42.5-63.8-.4-64l30.5 .1 0 0zM353.4 72.1c-13 4.9-30 16.1-48.8 36.8 .2-.3 .1-.1-.5 .8-3.6 5-9.1 12.7-13.4 19 28.3-.6 56.8-1.2 85.2-1.6 9.1-29.4 16.2-69.6-22.4-54.9zM223 193.9c-40.5 .7-86.2 .8-126.9 .6 6.6 85.4-19.4 155.8-2.1 241.2 27.2 10.8 62.7 3.8 91.4 8.1 12.7 .7 25.3 1.3 37.9 1.9 0-1.3 0-7 0-6 .5-79.7-1.1-148.6-.5-230.7 .1-3 .3-11.9 .3-15.1zm64.2 253.6c38.3-1.4 81.1 .2 118.5-4.9 7.3-60.3 1.1-121.3 7-181.1 1.4-22.7-1.7-47-2.6-71.1-34.6 .4-69.3 1.1-104.1 1.8l-18.9 .4c-1.5 87.1 .8 162.2 .1 247.5-.1 2.3-.1 5.1 0 7.3z"],
    "block-quote": [576, 512, [], "e0b5", "M91.4 54.5c-1-41.8-64.6-40.7-64 1.2l2 104.5c-1.2 74.3 3.2 138.8 .3 215.6 2.9 35.9-20.2 100.1 30 104 45.9-4.1 28.7-54.5 33.6-89.9 3.8-79.6-1-152 .2-230.7l-2-104.8zm128.8 70.3c50.9-3.3 104.1-.9 156.5 1.6 34.8 1.6 70.5 3.3 106 3.3 17.7 0 32-14.3 32-32s-14.3-32-32-32c-88.8-.1-176.8-10.4-266.5-4.7-17.7 1.1-31 16.3-29.9 34s16.3 31 34 29.9zm-3.6 167.3c26 0 50.6-.7 74.6-1.5 75.1-2.5 152.5-.1 227.4 1.8 41.8 2.3 45.7-61.2 3.8-63.9-23.1-1.4-45.4-1.5-67.6-1.5-56.9-.6-112.7-2.9-169.8-.2-34.7 6-96-15.8-100.5 33.3 0 17.7 14.3 32 32 32zM445.8 447.6l0 0c30.1-5 79.5 9.4 83.7-32.6 1-17.8-12.8-32.8-30.2-33.7-95.8 5.8-188.3 4.6-284.1 3.8-44.6-4.5-51.3 60.7-6.7 64.1 78.4-1.4 158.7 4.2 237.2-1.5z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M492 163.9c-52.9-130.1-217.5-211-347-134.9-86.4 36.1-134.5 123.3-146.5 215.9-4.9 72.4 27.1 151.2 82 199.6 106.3 82.4 270.5 98.8 360.5-9.6 69.8-65 86.9-181.6 51-271zm-306.2-84c151-72 309.7 106.6 247.8 254.9-26.9 60.9-98.6 123.5-172.2 111.6-53.7-6.6-104-19.4-138.6-50-63.1-57.7-78.7-149.1-35.5-225.6 18.9-49.3 52.9-68.7 98.5-91zm-25.7 68.3c-56.2 4.4-43.8 86.2 10.5 71.6 40.2-14.5 29.9-72.8-10.5-71.6zm187.2 0c-56.2 4.4-43.8 86.2 10.5 71.6 40.2-14.5 29.9-72.8-10.5-71.6zM222 294.8c-64.6 31.5-21.2 139.1 46.8 118 50.7-16.5 70.1-93.2 17.2-119.6l0-149.8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 151.3zM108 259.3c46-30.5 83.3 42.8 30.6 64.5-39.2 14-67.1-42.9-30.6-64.5zm276.1-7.1c-56.2 4.4-43.9 86.2 10.5 71.6 40.2-14.5 29.9-72.8-10.5-71.6z"],
    "signal": [576, 512, [128246, "signal-5", "signal-perfect"], "f012", "M516.4 74.6c-39 28-65.2 45.3-97.9 73.6-1.5 119.9 .3 206.3 1.6 302.3 32.8-.6 67-1.3 90.4-1.7 5.4-124.9 4-248.6 5.9-374.1zM356.1 451.7c-.6-91.5-3.3-129.5-1.9-245.7-30.6 27.3-62 54.2-92.2 82 0 10-.2 19.3-.4 28.2-1 43.7 2.4 90.2 1.9 136.7 36.6 .3 51.4-.4 92.6-1.2zM183.6 364.3c-27 28.3-54.3 56.5-80.5 84.8 32.3 .7 64.3 1.9 96.5 2.7 0-32.4-.9-74.2-2-101.9-4.7 4.8-9.3 9.6-14 14.4zM505 4.3c31.8-22.5 75.8 .3 75.6 39.3-1.4 113.3-.9 229.5-3.7 342.1-5.2 43.3 14.1 122.7-50.2 126.8-46.8 .9-190.2 3.6-200.6 3.9-98.7 2.7-195.8-4.1-293.8-4.2-26.5 .9-42.3-33.4-24.3-52.9 35.5-41.2 71.5-78.8 107.9-116.9 66.6-72.4 141.2-135.3 213.1-200.1 54.3-52 111.6-93.3 175.9-138.1z"],
    "share-nodes": [512, 512, ["share-alt"], "f1e0", "M463.3 11c37.4 20.8 55.4 64.9 44.8 113.2-17.5 78-117.3 96.4-166.6 46-19.8 11.1-43.8 22.1-65.9 32.4-26.2 12.1-49.9 23.2-67.5 33.4-2 1.2-7.6 4.5-13.8 7.9 .8 8.5 .5 16.8-.7 24.6 29.6 14.6 56.4 28.1 85 44.6 22 12.4 46.2 26 67.6 34.8 18.7-15.9 44.8-38.7 85.9-29.7 31.6 11 66.6 32.6 69.4 71.3 31.1 152.3-199.4 163.3-187.2 14.3-24-10.6-46.7-23.5-69-36-20.1-11.5-37.1-20.5-57-30.4-8.2-4.2-17.1-8.7-25.1-12.6-42.9 37.7-119.4 41.3-151.5-19.8-26.5-59.8 6.1-158.5 87-148.1 27.1-2 52.8 13.4 67.2 29.5 4.4-2.5 8.3-4.7 9.9-5.7 20.2-11.9 46.7-24.1 71.4-35.6 23.8-11 48.4-22.4 65.4-32.2-16-75.8 90.5-141.3 150.8-102l0 0zM432.2 66.9c-29.3-17.5-87.4 34-36.7 64.1 49.3 20.3 67.7-46.1 36.7-64.1zM88.5 220.8c-11.2 .6-12.8 .4-19.5 21.5-3.8 26.4-5.4 44.2 21.3 45.3 44.3 2.3 54.6-50.6 15.4-66.5-5.9 0-11.9-.4-17.3-.3l0 0zM392.4 392.5c-30.8 23.1-9.7 59.6 24.7 53.3 28.9-8.2 22.8-28.8 20.4-51.6-4.4-4.9-14.9-11.7-20.8-13.9-.1 0-.2 0-.1 0-8.7-1.1-15.1 5.2-24.3 12.2z"],
    "hard-drive": [512, 512, [128436, "hdd"], "f0a0", "M362.3 446.6c20.7-1.3 58.1-.6 84.6 .1l0-158.6c-22.2-.3-51.4 .2-78.1 .6-94.4 1.4-201 .4-302.6 .1 1 40.7 .6 77.2 .3 115.6-.1 12.1-.3 24.4-.3 37 108.4 7 196.9 8.3 296.1 5.2zM69.7 224.9c98.8 .3 202 1.2 293.3-.1 26.3-.5 57.1-1 81.3-.7-7.1-48.4-27.9-103.8-47.8-155.8-1.8-3.9-3.1-5.7-6.8-6-56.4-1.7-185 0-251.5 1.1-27 3.8-26.4 45.2-37.8 67-10.8 30.4-23.3 65.1-30.7 94.6zM510.9 454.7c0 31.8-26.4 57.1-58 56.1-64.1-3.1-115.5 2.3-175.5 1-65.9 .4-150.9-1.3-227.2-7.5-30.5-3.8-50.6-31.2-48.2-61.2 5.4-77.6-9.1-156.7 6.1-236.1 12.6-48.5 34.1-101.5 49-147.9 11.1-33.4 45.8-61.2 83.2-59.8 68.5-1 194.7-3 254.1-.9 33 2 56.5 26.9 64.8 54.7 22.7 58.1 52.4 141.6 51.6 203 0 4.1 0 198.7 0 198.7zM241.1 336c34 .7 53.2 41 27 62.3-22.3 17.7-58.5-3.1-59-30.3 0-17.7 14.3-32 32-32zm-67.3 13.1c-24.5-31.7-78.9 .2-55 37.6 29.7 43.3 88.1 4.8 55-37.6z"],
    "ellipsis": [512, 512, ["ellipsis-h"], "f141", "M56 314.9c-2-.5-4.9-1.5-8.2-3.4-36.9-5.7-45.4-34.7-47.5-60.9 2-42.8 41.3-69.4 81.3-59.4 46.3 10.6 65.8 72 28.7 104.6-14.3 14.8-32.9 24.3-54.4 18.9zM239.8 193.8c22.8-11.7 46.7-1.2 62.6 15.6 37.1 32.6 17.6 94.1-28.7 104.6-40.1 10.1-79.4-16.6-81.3-59.4 2.1-26.2 10.7-55.2 47.5-60.9zm226.9 0c36.8 5.7 45.4 34.7 47.5 60.9-2 42.7-41.3 69.4-81.3 59.4-46.3-10.5-65.7-72-28.7-104.6 15.9-16.7 39.8-27.3 62.6-15.6z"],
    "percent": [448, 512, [62101, 62785, "percentage"], "25", "M159 43c-94.8-56.1-211.6 65.4-131.4 154.7 37.6 39.1 105.4 32.4 138.6-7.7 33.4-37.2 42.7-119-7.2-147zM102.4 93.8c14.5-.6 26.6-.5 27.6 13.4-1.8 33.3-9.7 50.8-40.7 52.9-40.3-5.8-23.9-65.7 13.2-66.3zm284.9 202c-41.3-15.7-101-.4-115.2 39.7-22.8 45.3-21 112 29.8 134.3 117.8 56.4 215.3-123.2 85.4-174zM365.4 356c6 2.2 13 6.9 20.3 17.2 1.4 14-14.8 35.8-26.8 42.5-13.3 1.1-27.5 .4-34.9-8-5.7-13.8 1.2-40.4 10.3-51.2 10.9-2 24.5-3.9 31.2-.5zm20.2 17.1l.1 .1c0-.1-.1-.1-.1-.1zM335 356c0 0-.2 0-.4 .2 .3-.1 .4-.2 .4-.2zm86.4-250.9c12.4-12.6 12.3-32.8-.3-45.2s-32.8-12.3-45.2 .3c-37.7 38.1-76.6 76-115.8 114.1-79.8 77.6-160.7 156.3-234.2 240.8-11.6 13.3-10.2 33.6 3.1 45.2 13.3 11.6 33.5 10.2 45.1-3.1 71.9-82.6 149.4-158 228-234.4 39.7-38.6 79.6-77.4 119.3-117.6z"],
    "display": [512, 512, [], "e163", "M336.7-3.9c-71.7-4.7-139.8-7.4-209.9-3.9-45.5 2.7-125.8-4-128.5 67-2.2 56.2-2 180.1-1.7 245.2 5.4 113.9 156.3 72.6 229.3 78.3 .9 20.3 .3 43.6 0 65.1-27.4 3.8-95-15.5-96.7 32.5 .2 17.7 14.6 31.9 32.3 31.7 37.2-.3 65-.3 91.6-.3 34.7 .2 61.1 .2 100.1 .3 17.7 0 32-14.3 32-32-2.1-47.6-67.5-28.3-95.3-32.1 .3-22 .8-44.5 .1-65.6 30.8 .1 62.7 .3 93.4 .6 53.7 5 114.3-4.4 120.7-69.6 4.4-54 5-96 4.9-139.7 2.3-156.7-16-176.4-172.4-177.4zm-7.8 63.7c30.8 1.9 62.1 3.8 94.4 4.8 8.9 .3 15.1 6.5 16.2 13.2 5.7 33.7 6.3 57.8 5.7 90.5-.1 43.8-.1 84.4-4.7 139.7-5.1 20.6-38.8 7.6-55.7 10.8-114.2-2.9-203.3 3.9-312.4-.7-7.9-.5-12.8-10.3-11.6-17.5-.2-66.9-.5-185.9 1.8-239.9 94-9.2 174-7.2 266.5-1.1z"],
    "magnifying-glass": [576, 512, [128269, "search"], "f002", "M471.7 240.9c16.6-224.6-289.7-348.9-402.8-135.5-115 214.5 103 445.2 318.9 296.9 39.9 34 75 76 111.7 111.9 29.6 29.5 74.8-15.4 45.3-45.2l-36.8-36.9c-19.8-24.5-44.3-47-66.3-67.2-2.6-2.4-5.2-4.7-7.7-7 25.9-36.5 34.1-80.9 37.7-117.1zM204.1 65c97.9-36.9 216 69.1 203.9 169.6 .5 106.3-104.4 163.6-196 147.2-145-38.7-143.7-266.9-7.8-316.8z"],
    "cloud-moon": [640, 512, [], "f6c3", "M460.3-16.1c13.7-22.5-7.9-52.9-33.7-47.2-35.6 6.6-76.9 18-113.2 38.2-34.3 15.5-129 104.1-64.9 136.6 16.8 5.5 34.9-3.6 40.4-20.3 11.6-38.7 56.7-65.3 96.6-78.1-13.9 98.8 58.2 198.8 153.6 229.4-41.5 27.7 4.5 84.3 40.6 49.5 32.7-17.5 73.1-97 11.7-104.6-91.1-4.3-177.3-113.6-131.2-203.5zm-269.3 256c18.3-13.9 77.1-24.8 94.8-8.6 29.3 25.9 45.1 69 90.3 84.3 54.1 16.1 80.8 58.2 70.1 106-3.4 13-10.6 22.8-24.4 28.5-34.5 14.4-74 20.5-116.2 25.6-65.5 12-286.6-1.5-231.7-112.8 8.9-18 43-26.1 53.1-31.5 6.5-3.4 11.7-8.9 14.7-15.6 13.9-28.9 21.5-59.8 49.3-76l0-.1zm-103.3 40c-68.4 30.3-106.4 83.3-78.3 155.9 46.8 111.2 213 112.7 304 103.5 66.4-8.5 178.1-20.4 194.8-101.4 22.9-82.9-36.9-163.9-112.6-183.3-5.2-.2-23.6-19.3-33-32.8-43.6-75.4-140.1-76.9-205.9-35.9-35.8 22.4-52.2 56.9-69 94z"],
    "floppy-disk": [512, 512, [128190, 128426, "save"], "f0c7", "M329.1 4.8c-69.2-4.4-132.6-6.6-197.9-2.5-45.4 3.2-125.7-.3-127.5 69.8-2.7 74.3-2.3 273.9-2 360.1 2 102.3 132.4 77.4 198.3 78.9 52.4-2.2 122.8-1.4 187.7-.6 54.4 5.9 114.6-6.7 120-71.7 5.2-72.4 5.1-143.3 6.3-200.5 2-27.4 2.3-67.3-20.7-88.5L381.6 29.9C368 15.3 349.4 6.1 329.1 4.8zM205.3 64c21.8 0 52.5 1 82.1 2.5l.7 32c.4 17.8-12.7 29.7-26.4 29.4-24.3-.6-50-.5-75.8-.4-28.1 .2-24.3-26.4-24.3-43.6-.3-6.9 0-12.4 .7-19 14.4-.5 28.7-.9 43-.9zM352.1 97l-.1-5 94.4 101.3c2.7 2.9 3.9 6.1 4 8.9-1.1 75-.9 143.6-6.6 232.2-5 22.3-37.2 8.9-54.6 12-67-.8-141.3-1.6-196.6 .9-34.4 1.2-78.3 1.1-116.3-1.9-7.1-.4-11.8-10.1-10.6-16.3 0-89.3-1.2-283.6 2.3-356.5 9.3-1.4 19.7-2.6 29.8-3.6-.4 7.6-.3 15.6-.2 21.7-3.7 106 80.3 103.1 158 101.1 55.6 3.9 97.9-42.9 96.5-94.8l0 0zM247.2 224c-114.4 7.8-114.1 189.4 4.9 192 136.4 1.7 138.2-193.1-4.9-192zm-12.8 71c14.9-14.1 55.7-3.6 55.1 19-1.7 18.1 .4 27.7-15 34.5-38.3 15.7-64.2-19.4-40.1-53.4z"],
    "palette": [512, 512, [127912], "f53f", "M499 148.4c-65.4-158-302.3-199.2-420-79.9-146.9 149.7-71.3 427.5 147 441.4 30.3 3.2 58.1-16.1 65.9-45.3 8.2-20.4 5.6-51.6 16.5-65.9 26.7-29.5 75.3-17.5 113.4-16.7 39.2 8.9 82.5-10.5 86.7-52.9 7.5-55.1 16.4-131.2-9.5-180.7zM217.6 66.5c75.2-15.7 194.1 26.3 221.4 104.2 23.7 52.2 10.9 93.8 6.1 149-114-10.4-200.6-12.5-214.5 126.4-21.6-2.3-35.9-5.2-51.1-11-169.1-64.1-139.7-340.8 38.1-368.6zM126.5 220.2c-5.1 8.3-2.3 33 11.8 41.1 29 31.4 81.6-9.1 59.6-45-3.6-16.4-30.4-28.5-45.3-19.2-12.8 3.3-22.1 13-26.1 23.1zm170.8-91.9c-12.3-16.5-34.4-16.3-47.5-7.2-9.9 2.3-23.9 18.3-22.3 31.8-7.4 51.2 63.8 54.7 74.5 9 3.6-11.8 4.2-19.7-4.6-33.7zm94 67.6c-34.9-35.4-89.8 15.8-64.8 55.3 29 39 99.5-5.6 70.7-47.5-1.5-2.8-3.5-5.5-5.9-7.8z"],
    "unlock": [512, 512, [128275], "f09c", "M324.1 101.6c-1.7 28.6-2.1 65.4-2.8 94.1 32.2 10.3 56 34.6 61.3 71.6 2.9 20.2 8.2 107.8 1.6 162.4-18 97.7-122.2 72.5-195.4 75.5-42.1-.6-83.9 .1-124.3-.5-34.3 2.4-65.4-19.9-62.1-56.1 2.3-45.1 .6-89.7-1.9-133.5-1.7-40.5 .4-86.9 36-110.2 17-11.7 37.4-16 57-15.6 73.7 1.8 99.8 3.9 163.9 .1 1.1-30.9 .4-68.4 3.7-99.3 23.2-91.3 150.9-122.5 215.7-58.3 39.1 50.5 31.5 130.6 35.2 188.5 0 6.2-1.5 10-5.3 17.9-24.1 14.5-62 1.1-58.7-17.6-1.1-41.9-.6-103.1-16.6-143.7-28.9-29.7-94.4-12.1-107.3 24.8zm124 118.3l0 0zM222.6 254.8c-50.4 2.3-65.6-.8-130.4-1.6-9.7-.2-16 2.1-19.5 4.4-2.8 1.9-5 4.6-5.9 10.4-6.7 58.2 4.2 115.5 .2 172.6 71.4-.4 157.5 2.3 227.4-.4 14.1-1.5 24-5.2 26.3-18.4 5.8-47.7 .9-129.4-1.4-145.5-7.9-36.7-66.4-19.8-96.7-21.6z"],
    "key": [512, 512, [128273], "f084", "M336.4-3c102.6 9.4 147.3 92.9 142.6 179.9 0 23.6-8.8 44.8-19.3 61.7-43.8 79.3-158.5 104.4-227.8 51-28 26.4-51.1 47.9-78.1 73.8 20.4 20 55.6 42.6 30.5 72-27.5 27.4-53.3-5.1-74.6-25.6-9.5 11.2-19.5 22.1-31.8 34.8 10 8.3 20.9 19.5 29.2 28.8 28.4 30.7-18.1 74.1-46.8 43.6-13.7-16-38.1-35.4-51.6-50.6-30-36.8 31.3-66.6 48.1-93.1 40.7-47.7 84.8-85.8 130-129-76.3-103 28.6-262.8 149.7-247.3zm-2.7 64c-64.4-7.2-109.6 53.3-109.1 107.2 2.2 36 39 74.9 72.7 84 54.5 8.2 109.4-20 117.6-75.3-2.7-65.9-7.2-99.9-81.3-115.9z"],
    "skull": [512, 512, [128128], "f54c", "M315 71.7c48 7.6 80.2 25.7 92.3 54.8 24.9 59.9 37.4 119 40.4 183.3-13.1 18.1-28.3 34.8-47.8 46.2-27.7 18.8-13.8 65.3-17 98.5-14.1 3.7-28 5.6-42.3 6.4 .3-4.4 .5-8.9 .8-13.6 2.3-26.1 7.8-70.6-30.4-71.1-37 .9-31.8 40.4-33.5 67.6l0 .4c-.4 6-.8 12.3-1.1 18.8-12.1 .5-24.2 .3-36.8-.2-5.5-28.7 12.2-84.4-33.3-86.2-23.5-.2-34.8 22.1-32.1 43.3-.1 12-.3 25.7 .7 39.4-15.7-.5-31.2-2.5-46.8-4.5-.2-6.3-.4-12.4-.6-18.3-8.6-49.6 3.1-63.4-31.1-97.8-10.7-10.8-21.5-21.5-32.3-32.3 12.6-171 52.5-262 250.8-234.7zM64.1 481.3c-.9 16.6 11.2 31.3 28 33.4l.2 0c39 4.8 76.4 7.7 115.4 10.3 31.5 2.6 64 2.4 97.1 1.1 38.7 .5 81.4-3 118.4-15.3 15.5-3.6 26.1-17.9 24.8-33.7-1.6-20.4-1.6-50.9-.7-75.7 26.6-22.6 58.3-48.1 64.8-82.8-2.3-75.7-16.2-145.7-45.6-216.7-49.1-123.2-298.7-124.2-376.9-47.4-74.1 66.8-85.5 175-89.5 265 2.8 28.4 34.5 42.9 50.8 64L63 395.9c-1.2 29.2 2.2 57.6 1 85.4zm302-252.4c-6.5-14.9-23-22.3-38.1-17.9l-.4 .1c-48.1 10-26.7 84.6 21.1 60.4 16.8-6.7 24.8-26.1 17.4-42.6zm-37.5-18c.7-.1 .8-.2 .2 0l-.2 0zM193.8 271c36-15.7 15.6-71-21.7-60l-.4 .1c-48.2 10-26.7 84.6 21 60.4 .4-.1 .7-.3 1.1-.4zm-20.9-60.2c.7-.2 .5-.1-.2 0l.2 0z"],
    "gamepad-modern": [576, 512, [127918, 63676, "gamepad-alt"], "e5a2", "M382.6 94.4c-27.4-.7-53 1.3-80.4 2.8-41.8 2.4-84.6 4.6-127.3 4.6-50.3 1.1-91.4 44.8-103 94.2-4.6 20.4-5.2 67.8-5.1 88.3 0 26.3-.8 73.3-.8 77.3 8.1 27.2 41.2 52.1 66.9 58.9 8.6 1.7 22.4 3.8 32.3 4.9l21.3-41.8c8.1-15.9 24.1-28.2 44.3-29.5 27.9-1.8 81.7-1.9 111.2-2 32.7-3.2 65.2 45.5 86.4 64 61.6-11 87.3-5.7 82.6-78.7 5.8-103.4 9.9-248.3-128.5-243.1zm2.9-64c122.9-4.9 192.2 99.3 190.7 209.2 2.9 32.9-1.2 64.6-1.1 98.8 5.6 108-49.8 131.6-146.8 142.2-20.6 2.2-35.5-9.5-42.6-16.7l-46.9-47.7c-28.2 0-71.8 .3-97.7 1.5-5.9 10-24.2 51.4-32.4 59.7-12.4 16.8-44 13.2-63.7 10-67.9-8.1-134.5-54.2-142.9-125.9 2.2-39.8-3.1-133.8 8.3-182.8 18.3-71.1 78.9-141 167.9-141 68.8 .5 138.3-8 207.3-7.3zM162.3 260.8c-23.9 2.8-56.1-1-56.1-31.7-.1-28.6 28.9-34.6 52-32.2-3.3-29.5-1.1-56.1 31-58.3 31.7 2.3 32.9 26.8 33 56.5 24.7-2.5 59.8-1.1 59.9 31.6 0 30.7-31.8 34.1-55.8 32.3 .2 8.5 2.4 14.2 2.8 21.9 .9 31-40.9 41.7-56.2 21-10.8-13.3-8.5-25.5-10.7-41.2zm243.9-72.7c-9.2 26.6-35.3 33.9-59.1 22.3-24.2-14.6-27.8-47.7-6.5-67.4 31-22.6 73.9 9.8 65.7 45.1zm64.9 87.3c1.2 23.6-25.1 40.9-45.4 36.6-41.6 .1-48.4-63.7-11.7-73.5 25.9-7 54.9 4 57.2 36.9z"],
    "tree": [512, 512, [127794], "f1bb", "M231.5 9.5c12.1-12.4 33.2-12.4 45.3 0 6.4 7.2 9.4 13.8 15.7 22.4 32 39.1 53.9 77.3 82.3 113.8 18.3 19.4 25.9 45.2 40.7 61.2 27 29 47.7 53.8 8.9 83.8 5.6 7.1 11.6 14.5 17.9 22.2 22 27.1 46.9 57.3 63.4 86.8 5.5 9.2 5.8 21.3 1 30.6-4.7 9.5-14.6 16.4-25.2 17.4-50.1 6-131.8 1.2-189.3 .5-.7 28.5 10 77.5-31.7 78.9-41.2-1.3-30.9-49.2-32.3-77.5-20.3 .7-39.5 .4-58.9 0-36.4-1-66.7 .6-104.5-1-25.9-2.2-51.4 6-63.7-19.5-11.7-25.2 14.1-44.3 28.7-62.3 22.2-23.1 34.7-49.3 53.6-76.5-3.9-4.3-13.8-12.8-16.5-17.7-7.9-12.3-5.1-28.2 3.8-39.3 17.6-28.5 34.7-51.4 54.8-77 16.7-21.5 30-39.3 45.9-61.3 15.6-23 33-42.1 47.1-65.9 3.8-6.1 7.7-14.2 13.1-19.8zM419.4 387c-21.3-29-49.9-57.5-67.3-87.6-7.6-18.6 5.4-33.4 18.7-45.4l.5-.5c-12.6-12.4-21.7-28.1-27.6-39-6.4-11.7-10.8-19.6-16.4-25.7-29.1-32.7-44.4-69.3-72.3-99.3-10.6 13.8-20.4 27.3-30.4 41.2-25.3 35.8-53 70-79.2 105.3-3.4 5-6.8 10.3-10.4 15.8 4.9 5.4 17.1 15.5 19.9 22.3 13.3 32.2-22.1 48-35.2 78.2-6.7 10.7-14.1 22.6-22.1 33.5 44.1-.8 86.4 1.3 129.4 .2-1.2-42.7-2.8-85.5-4.8-128.4-.8-17.7 12.9-32.6 30.5-33.4 17.7-.8 32.6 12.9 33.4 30.5 1.9 43.2 3.6 86.4 4.8 129.8 40.9 .5 88.5 2.6 128.5 2.5z"],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M234.5 84c16.8 28.5 3.2 74.2-17.6 95.8-6.6 7.4-14.8 29-18.6 39.4-3.6 47.1 70.6 102.7 110.2 90 14.6-4.2 35.2-20.1 50-28.4 11.7-7.4 20-14.8 40.2-15.6 38.6 2.4 52.5 28.9 69 51.4 21.2 28.1 42.9 67 19.8 105.2-87.5 129.1-280.5 100.6-376.8 6.8-78.9-69.8-111.4-159.7-110.5-259.4 4-59.8 38.9-142.8 102-166.6 57.9-12.3 109.3 33 132.3 81.4zM119.7 64.3c-144.8 126.5 14.1 382.6 182.3 380.4 57.4-.4 112.1-18.7 131.5-58.4-3-16.2-23-40.6-34.9-55.3-25.2 14.8-45.2 32.6-76.1 40.6-83.6 15.2-145.2-38.8-179.6-104.6-20.1-36.4-3.7-86.8 20.2-122 7.5-9.7 13.5-18.1 15.5-24.9-1.8-22.9-34.9-56-58.7-55.9zM320.2 32.2c0-17.7 14.3-32 32-32l128 0c17.4-.4 32.7 15.2 32 32.6l-2.5 131.9c-1 41.8-64.6 40.7-64-1.2l.9-48.6c-13.1 13.7-27.5 30.2-41.4 41.9-10.2 8.5-15.6 14.8-23.3 24-20.5 21.3-51 74.2-84.8 42.3-12.2-12.8-11.8-33 1-45.2 21.5-19.9 41.7-50 64.6-68.9 10.2-8.6 16.2-15.6 24.5-24.3 6.5-6.9 12.8-13.6 19.1-20.4l-54.1 0c-17.7 0-32-14.3-32-32z"],
    "pen-line": [640, 512, [], "e212", "M388.2 74.9c53.4-40.6 118.3-6.4 91.8 60.3-75.6 84.7-218.6 217.4-294.1 303.3-.1 .1-.3 .2-.3 .3-.1 0-.2 .1-.3 .1-30.2 1.8-60.3 4.1-90.2 6.8-.2 0-.1 0-.3-.1 .3-32.8 .6-54.1 1.1-84.9 40.8-55.6 97-103 147.1-151.7 48.5-45.2 94.7-92.3 145.3-134zm150.2 86.4c26.1-60.3 7.5-117.4-36.2-147.3-78.7-55.3-162.5 8.5-221.2 71-27.8 26.6-55.4 51.3-82.4 77.7-53.7 52-109.2 98.7-154.3 159.9-19.3 26.1-11.1 59.3-13.3 89.3 0 6.5-.2 19.3-.4 32.4-.7 38.3 32.1 68.5 70.1 65.1 43.8-8.8 99.6 6.8 133.2-28.6 37.6-42.7 95.3-100.4 150.8-155.6 58-61.1 115.9-108.8 153.8-163.8zM493.9 512.4c16.9 0 33.6-.4 49.9-.9l.2 0c29.2-2.6 78.6 9.5 80.4-32.9-1.6-43-53.2-30.5-81.9-31.1l-.2 0c-46.8 1.9-91.9-.3-138.8 1.4l-64.9 2.5c-17.7 .7-31.4 15.6-30.8 33.2 .7 17.6 15.6 31.4 33.2 30.7l64.9-2.5c29-1.1 58.4-.4 87.9-.4z"],
    "paintbrush": [640, 512, [128396, "paint-brush"], "f1fc", "M500.1 77.3c2.8-.6 7.1-.8 15.6 1.3 49.3 21.6 7.2 64.3-17.4 91.9-38.8 43.3-82.4 85.2-128 124.4-13.4-23.6-30.4-41.9-52.7-56.9 58.2-54.8 108.5-124.8 182.5-160.7zM385.6 365.7c77.3-72.4 336.5-258.4 152.2-347.1-105-34.4-216.1 137-290.2 198.7-122.1-3.6-154.3 143.6-149.6 237.2l-47.2 0c-41.9 .2-41.8 63.8 0 64 1.8-.2 47.9 .2 49.7 0 107.8-6.3 285.4 1 285-152.7zM162.1 451.2c.8-64.9 6.4-175.5 92.6-170.1 23.8-3.4 70.6 45.9 67.2 69.2 9.9 97.7-88.8 92.4-159.8 100.8z"],
    "flower": [576, 512, [127804, 10047], "f7ff", "M332.1 85.6c38.4-39.5 119.5-26.5 141.8 23.9 23.6 58.9-12.2 96.6-77.3 91.5-6-36.5-44.3-68.6-82.9-74 2-18.4 9.2-31.8 18.4-41.4zm-46-44.4c-3.8 3.9-7.4 8.1-10.7 12.5-21.7-35.1-80-47.2-114.6-44.3-118.3 6.2-163 175.2-74.2 249.2-54.8 36.6-76.4 110.2-55.2 167.5 38.2 108.8 178.4 97.6 239.6 22.6 1.2-1.4 2.5-2.9 3.9-4.5 58.4 113.7 234.2 69 263-44.9 12.2-62.6-22.9-118.8-70.6-143.7 70.3-21.5 95.5-112.1 64.3-173.4-47-95-175.5-110.6-245.7-40.9zm-43.8 325c-.7 6-2.3 15.5-4.3 20.7-23.5 49.2-120.6 86.5-145.9 18.8-18.5-51.7 18-92 58.5-113.1 5.4-2.6 11.5-5.1 17.5-7.6 9.6 32.7 37.2 71.8 74.2 81.2zM164 211.2c-9.9 1.4-25 1.9-34.2-.5-35.4-26-34.5-95 2.1-122.8 14.9-12.1 11.7-13.2 29-14.4 48.7 .3 69.5 3.9 74.5 61.7-30.5 12.3-57.8 39.9-66.8 75.3-1.2 .3-2.8 .5-4.6 .8zm220.4 91.1c56.4-4 96.9 35.1 91.7 80.6-9.4 44.1-81.2 81.2-120.8 56.4-24.3-13.1-38.6-52.9-39-80.6 29.3-10.2 54.3-31 68.1-56.4zM269.3 191c39.1-7.4 73.3 2.4 66.5 54.6-3.2 35.1-27 52.7-62 58-7.4 1-12.9 1.2-18 0-40.5-27.1-40.2-99.3 13.5-112.6z"],
    "battery-slash": [640, 512, [], "f377", "M86.9-22.1C57.7-51.9 12-7.8 41 22.5L98.5 81.6c120.8 104.8 211 240.1 334.7 342.5 11.3 10.5 22.6 20.9 33.7 31.3 .2 .2 87 79.7 87.2 79.9 30.9 28.1 74-18.7 43.2-47.1-107.6-100.1-224.6-199.3-317.8-312.7-37.4-44.3-79-92-123.6-128.5-9.2-6.4-60.2-60.4-69-69.2l0 0zM245.2 448.2c26.8-1.7 91.4 12.9 90.6-34-3.1-43.8-60.4-26.3-86.4-29.9-57.1-.9-105.2-.4-165.9-5.1-11.3-.9-17.9-7.6-18.2-19.7-1.6-57-1.4-154.6-1.2-212.3-.1-41.9-63.6-42-64-.3-.3 57.6-.4 156.1 1.2 214.3 1.2 44 32.5 78.1 77.2 81.6 62.6 4.9 107.4 4.4 166.7 5.3zM511.1 335.9c35.9 0 33.8-38.5 32.5-64.3 .7-101.9 9.2-213.6-131.8-206.4-30.8 3.5-89.4-14-92 32.6 .1 17.7 14.5 31.9 32.1 31.8 27.5-.1 55.6-.4 82.7-.6 23.3-.2 40.5 16.1 41.9 36.7 3.3 45.9 2.7 70.8 2.9 107.4-.9 25.6-2.8 61.7 31.5 62.8zM576 192l0 127.9c.2 41.8 63.8 41.8 64 0L640 192c-.2-41.8-63.8-41.8-64 0z"],
    "font-case": [640, 512, [], "f866", "M310.7 157.9c-.7-114.9-170.7-173.4-232.7-78.4-54.8 92.7-38.9 200.3-39.7 300.5 .6 12.4 1.2 24.3 1.5 36.1-47.8-5.8-55.5 62.2-7.2 64.3l83.6-2.5c49-5.8 36.1-72.8-12.4-63.7-.4-12.8-1-25.4-1.6-37.7-.9-19.1-1.9-38.6-1.8-56.8 39.5-.1 128.7-.4 152.3-.4 .6 27.6 .1 67.6-.9 99.6l0 .1c-49.2-11.3-65 54.9-15.8 63.1 6.6 .4 17.1 1.2 23.8 1.1 17.2 .9 43.6-1.7 62.1-2.9 42.6-3.3 36.7-68.1-5.8-63.8 .4-43.2 2.2-87.2-.9-126.5-3.3-45-.7-86.8-4.5-132.1zm-61.2 97.4c-27 0-107.7 .3-147.3 .4 3.2-51.2 .4-129.6 49.1-157.5 109.1-13.6 97.9 79.2 98.1 157.1zm166.4-97.8c-1.6 17.6 11.4 33.2 29 34.8 1.7 .1 86.9 7.7 88.7 7.9 35.5 3.5 40.2 22.2 42 51.6-25.3-.3-45.1 .3-65.7-.6-90.3-14.5-146.6 83.9-112.4 161.5 24.1 65.1 120.1 76.5 178 51 15.8 30.5 64.7 15.4 59.9-19.2-4.4-34.5-1.8-72.6 .9-109.4 9.2-84.2 11.2-191.7-98.8-198.8l-86.8-7.7c-17.6-1.6-33.2 11.4-34.7 29zM573.4 315.7c-.3 4.3-.6 8.7-.9 13.1-1.6 22.4-3.2 44.6-3.5 67.6-30.5 16.5-91.3 29.5-112.2-7.9-14.8-34.6 2.1-83.1 50.5-73.3 20.5 1 40.5 .4 66.1 .6z"],
    "camera": [576, 512, [62258, "camera-alt"], "f030", "M336.7 99.6l0 0c28.3-3.5 33.4 8.8 51.7 29.3 3.1 3.7 18.9 21.8 23.2 27 17.7 19.4 53.7 11.4 76.3 10.3 2.8-.3 5.5-.5 8.1-.8-6.8 83.9-7.3 160-12.4 240-.1 4.3-.3 7.4-.5 11.1-25 .7-51.7 2.1-77.9 3.5-103.4 7.2-200.1 2-307.1-2.4 .2-16-.3-31.8-.8-46.7-1.7-68.8-.4-141-.9-210.8 21.4-2.1 67.8 7.1 80.3-11.2 7.3-8.5 29.6-34.2 35.6-43.1 41.1-1.5 82.9-7.2 124.6-6.3zM64.2 96.2c-17.7 0-32 14.3-32 32 0 66.4 .2 144.4 .2 210.8-.2 37.2 3.9 69.3 .1 105.5-2.4 18.4 12.4 35.3 30.8 35.7 115 4.9 232.4 11.8 344.7 3.8 37.4-2 73.7-3.8 104.4-3.8 19.4 .2 34.8-17.8 31.6-36.9 10.7-94.2 8.1-193.1 16.9-288.1 1.7-47.3-42.1-60.8-81.8-52.4-9.1 .9-19.4 1.8-27.2 1.7-2.8-3.3-11.6-13.5-14.3-16.7-16.7-22.4-49.9-53.5-79.4-51.9-52.4-2.8-103.4 5.1-155.9 5.9-28.6-.9-47.2 36.5-64.7 54.4l-73.2 0 0 0zM377.1 224.6c-59.6-108.1-235.4-23.3-192.4 92.6 64.6 128.6 259.9 41.5 192.4-92.6zM248.4 264.4c10.6-24.2 58.4-38.1 72.2-9.7 10.4 19.6 6 37.9-4.4 49.1-20.2 27.4-96.5 5.8-67.8-39.4z"],
    "eye": [640, 512, [128065], "f06e", "M309.2 92.4c94-8.6 191.2 89.6 245.3 167.4-43.8 99.4-146.5 159.1-253.5 158-24 1.2-39.7-3-66.1-14-71.7-22.3-112.5-80-138-147.9 43.8-79.1 127.6-145.1 212.4-163.4zm167.3-5c-44.5-30.4-105.3-70.8-178.2-58-114.9 26.1-208.1 103.3-261 202.8-7 16.3-5.9 33.7 .4 48 30.1 82.6 88.2 155.6 172.3 182.5 146.1 63 345.7-32.5 404.3-179.8 8.1-19.2 5.5-40.5-5.5-57.2-33.4-50.6-81.7-103.9-132.3-138.4l0 0zM409.3 290.2c21.8-66.7-29.1-147.3-106.8-127.8-81.4 21.3-108 130.3-33.9 181.7 54.4 37.2 121.8 2.7 140.7-53.9zm-90.6-65.9c-44.4 8.7-34.5 83.6 9.5 68.6 31.8-10.7 28.8-75.4-9.5-68.6z"],
    "trash": [448, 512, [], "f1f8", "M249.1 60.8c15.9 .4 29.1 1.2 41.2 3-.1 9.3-.9 20.5-1.7 30.1-43.7-1-86.8-.3-130.1 .1 .3-8.3-2.1-21.3 .7-28.3 24.1-6.3 58.4-4.6 89.9-5zM352.7 96.7C364.3 2.9 335.8 .5 250.7-3.2 172.3-4.4 82-9.3 94.5 94.2 61.2 98.7 .1 73.9-6.4 122.5-7.9 146.7 15.2 158.9 36.8 156.8l0 257.8c-.2 52 43.9 93.3 95.8 90.7l170.3 0c101.5 4.8 116.4-92.4 110.8-174.1-.6-31.1 1.7-121.6 2.8-171.4 42.2-.1 42-64.3-.3-64l-63.6 .9zm-.2 64c-2.4 77.2-3 153.3-2.7 215.6-3.2 35.8-2.9 67.2-45.7 64.9l-173.1 0c-15.9 1.6-30.4-10.3-30.3-26.7l0-256.4c83.7 .2 169.8-3 251.7 2.5z"],
    "clipboard-check": [448, 512, [], "f46c", "M235.8 39c12.5 11.2 10.8 38.1 12.9 57l-60.1 0c-.9-29.2 13.3-76.8 47.2-57zM221.5-29.5c-36 .5-71 23-86 61.9L82.3 33.8c-46.5 1.2-84.1 38.3-85.8 84.8-3.8 102.7-6.4 175.2-.5 267.9 1.5 12 1.7 28.4 1 47.3-.2 62.4 51 79.6 106.2 76.2 87.2 6 179.4 9 266.1-.3 38.5-2.9 65.3-35.5 66.9-71.6 10.3-44.4 7.1-100.6 8.8-152.9 2.9-35-.4-73.2-.6-109.7-.4-21.2-.8-43-1.9-64.8-2.3-46.2-41-79.2-84.6-79.7-1 .1-52.8-.7-53.9-.6-13-39.1-46.5-60.4-82.4-59.9zM313.6 128c0-9.9-.3-21.5-.9-33.5l44.4 .5c35.9 2.7 18.3 56.9 23.2 82 .1 35.7 3.5 68.7 .7 105.4-3 41.8 3.1 92.5-6.1 132.7-3.1 9 .9 28.5-10.8 30.7-91.2 9.7-175.4 5.4-262.7 0-13.5-1.6-27.5 1.6-38.4-3.2-5.1-17.8 .7-43.2-3.1-61.1-5.5-88.6-3.2-158.1 .7-260.5 1.5-31.8 43.5-21.9 64.1-24.2-2.1 26.3-2.6 62.7 31.7 63.3l125.3 0c17.2 .3 32.4-14.8 32-32zm7.9 136.6c32-26.9-8.7-75.8-41-49.2l-48 40c-.7 .6-1.5 1.3-2.1 2l-43.3 43.3-25.6-21.3c-32.2-26.7-73 22.2-41 49.2l48 40c12.7 10.6 31.4 9.8 43.1-2l63-63 46.9-39.1z"],
    "equals": [448, 512, [62764], "3d", "M34.1 132.9c-41.7 .1-42 63.8-.1 64 129.2 .2 258.3-1.3 387.3-3.1 41.7-.7 41.1-64.4-.9-64-129 1.7-257.6 3.3-386.3 3.1zM420.7 382.6c41.7 .1 42.4-63.5 .4-64-129.3-.8-258.3 .2-387.3 1.3-41.7 .5-41.3 64.2 .6 64 129-1.2 257.6-2.1 386.3-1.3z"],
    "expand": [576, 512, [], "f065", "M72.9 165.5l-.1-.1c17.4-2.7 29.4-19.1 26.7-36.5-3.6-23.2-5.9-45.6-6.7-69.2l75.7 3C210.5 64.3 213 .7 171.2-1.2l-92.6-3.7-1 0c-43-.6-53.7 40.3-48.2 76.4 .9 22.9 4.5 44.5 7 67.3 2.7 17.5 19.1 29.4 36.5 26.7zm91.2 353.8c41.9 1.1 43.8-62.5 2-64l-66-2c-5 0-2.7-72.1-2.5-82 .5-41.8-63.1-42.9-64-1-.4 26.8 .2 75.1 .5 99.6 .3 35.3 34 51.3 64.4 47.4l65.7 2zm242.4 .5c46.8-6.8 137.2 20.9 145-47.6l4.6-89.5c2-41.8-61.6-45.1-63.9-3.3l-3.9 74.7c-9.2 .2-18.4 .4-27.4 .7-31.2 3.7-83.8-11.6-86.4 33.1 0 17.7 14.3 32 32 32zm80.2-386.1c-3.1 41.7 60.4 46.7 63.8 4.9 .7-9.4 2.8-45.4 4.3-72.7 2.1-37.2-28-68.3-65.2-67.5L418.3 0C400.7 .4 386.6 15 387 32.7S402 64.4 419.7 64l71.2-1.5c-1.5 27.8-3.5 62.8-4.2 71.3z"],
    "signal-weak": [576, 512, ["signal-1"], "f68c", "M516.4 74.6c-152.5 109.6-285.8 238.7-413.3 374.5 149.1 5.7 237.2 3.2 407.5-.4 5.4-124.9 4-248.6 5.9-374.1zM505 4.3c31.8-22.5 75.8 .3 75.6 39.3-2.1 141.9 .3 282.9-7.1 424.2-1.7 24.8-22 44.2-46.8 44.6-188.9 5.6-321.1 4.1-494.3-.3-26.5 .8-42.3-33.3-24.3-52.9 35.5-41.2 71.5-78.8 107.9-116.9 122.6-124.2 244.7-238.3 389-338.1z"],
    "water": [640, 512, [], "f773", "M626.1 47c-38.7 99.7-129.3 104.8-202.4 38-57.2 68.1-149.4 59-202.4 .8-42 64.1-169.7 65-198-15.3-12.2-20.9-25.3-47 .6-63.3 28.6-17 48.1 12.4 56.8 34.9 7.6 13.7 6.7 20.5 22.4 23.3 31.6 5.2 44.4 1.1 52.2-3.9 10.3-6.6 19.2-18.7 36.7-45.6 11.6-19.1 41.9-19.2 53.6-.1 41.9 59.5 99.6 80.6 150.5 1.5 5.2-7.5 13.4-12.4 22.5-13.5 20.8-3.3 35 18.1 46.2 31 17.8 20.1 48.4 35.3 71.6 29.1 15.2-6.6 24.5-30.8 33.1-46.5 19.6-37 75.9-7.6 56.7 29.6zM25.7 195.8l0-.1c56.7-25.3 45.4 80.8 101.2 59.6 17.6-6.5 32.3-11.4 46.6-28.5 11.1-12.9 25.4-34.3 46.2-31 9.1 1.1 17.3 6 22.5 13.5 50.9 79.1 108.5 58 150.5-1.5l0 0c11.7-19.1 42-19 53.6 .1 17.5 26.9 26.4 39 36.6 45.6 3.1 5.2 40.4 10.6 62.2 .6 5.9-4.7 7.9-11.1 12.7-20.5 8.5-22.4 28.2-51.3 56.5-34.4 26 16.3 12.7 42.5 .6 63.3-28.3 80.3-156.1 79.5-198 15.3-52.9 58.3-145.2 67.3-202.4-.8-45.1 47.3-141.6 68.1-180.8 .8-15.4-25.2-42.7-61.9-8-82zM612.5 378c34.7 20 7.4 56.8-8 82-39.3 67.3-135.7 46.5-180.8-.8-56.4 66.9-146.9 59.8-200.2 2.9-21.3 42.5-67.1 59.2-114.8 48.6-50.6-8.4-73.6-48.3-95.5-85.4-22.5-44.4 43.1-69.7 60.4-23.7 12.3 19.7 23.4 42.1 45.4 46 34.9 6.8 41.2-1.7 56.1-29.5 4.6-8 10.3-17.9 16.8-27.9 11.6-19.1 41.9-19.2 53.6-.1l0 0c41.9 59.6 99.6 80.6 150.5 1.5 21.4-28.3 51-7.9 66.1 14.4 14 18.4 30.8 25.2 49.2 31.6 55.8 21.2 44.6-84.9 101.2-59.5z"],
    "signal-good": [576, 512, ["signal-3"], "f68e", "M513.4 63.2c-37.7 27.8-63.3 45.3-95 72.5-1.5 120.4 0 215 1.5 309.9 31.9-.6 65-1.3 87.8-1.7 2.1-126.1 3.8-254.4 5.7-380.7zM355.9 446.8c-.9-91.5-3.2-132.3-1.9-251.5-31.2 30.6-59.8 60.3-92.3 91.5 .1 10.3-.2 20.2-.3 29.4-1 42.3 2.3 86.7 1.9 131.9 36.7 .3 51-.5 92.6-1.3zm-173-88.5c-6.8 7.3-13.5 14.5-20.2 21.6-20.2 21.7-40 42.8-59.4 64.3 32.1 .8 63.9 1.9 95.9 2.7 .1-33.7-1.1-72.3-2.1-100.9-4.7 4.1-9.5 8.2-14.3 12.3zM501.6-7.4c31.7-23 76.3-.4 76.1 39-.3 61.5-1.4 121.5-2.5 181.3-1.3 69.8-2.6 139.2-2.6 210.1 0 8.1-1.2 27.3-2 39.7-1.6 24.8-21.9 44.3-46.8 44.7-145.5 2.4-244.9 7.1-369.5 2.1-41.9-1.4-82.3-2.2-124.2-2.6-31.1-3.5-37-43.3-13.1-61.7 32.6-38.2 65.7-73.7 99.1-109.5 132.2-122.1 236-242.7 385.3-343.3l.1 0z"],
    "stop": [384, 512, [9209], "f04d", "M125.1 64l.6 0 123.8 1.2 .4 0 48.5 1.1c46.5 1.1 84.1 38.1 86 84.5 3 73.6-.6 146.8 .5 220.3 .5 36.2-26.6 69.3-65.7 71.1-27.5 1.3-49.6 1.1-74 3.2-54.3 4.8-113.3 1.9-167-2-36.1-2.6-63.1-31.1-67.8-64.6-7.2-50.4-9.6-101.6-6.9-152.4 1.1-20.7 2.5-51.6 3.7-78.2 2.2-46.6 40.3-83.5 87-84l30.8-.3zm.4 64l-30.4 .3c-12.8 .1-23.2 10.2-23.8 22.9-1.2 26.6-2.7 57.7-3.8 78.5-2.3 46 .2 94.7 6.4 140.3 .8 6 5.4 9.3 9 9.5 53.4 3.9 108 6.4 156.8 2.1 17.2-1.5 35.3-2 52.3-2.6 8.5-.3 16.8-.5 24.4-.8 2.5-.1 4.7-2.2 4.6-6.3-1.1-73 2.5-145.6-.4-218.7-.5-12.7-10.8-22.8-23.5-23.1l-48.4-1.1-123.3-1.2z"],
    "signal-slash": [576, 512, [], "f695", "M57.2-21.7c-12.1-12.9-32.3-13.6-45.2-1.5-30.1 30.3 13.5 59.3 32.6 80.6 25.2 25.4 49.8 52.4 75.5 76.4 26.7 25.2 49.8 50.1 74.3 76.8 106.4 110.5 213.4 227.8 331.3 326.4 32.4 26.2 72.8-22.9 40.4-49.6-116.6-98.1-217.7-209.2-323.8-319.3-24.6-26.9-51.1-55.3-77.3-79.9-37.4-36.1-72-73-107.7-109.9zM546.1 384.2c17.7-.3 31.7-14.9 31.4-32.5-.5-31.4-.3-63.7 0-96.5-3.7-73.1 10.5-166.6-14.9-234.8-15.3-20.1-44.2-23.4-63.7-7.4L349.5 135.4c-32.3 26.7 8.2 75.9 40.6 49.5L510.9 85.8c3.6 54.4 3.1 108.6 2.6 164.1-.3 33.7-.6 67.9 0 102.9 .3 17.7 14.9 31.7 32.5 31.5zM210.2 297.3c-11.7-13.2-32-14.4-45.2-2.6-51.7 46-102.9 93.4-151.9 143.2-27.1 26-7.4 75.5 30.2 75.5 103.7 3.4 207.4 5.1 312.4-1.3 17.6-1.1 31.1-16.2 30-33.9-1.1-17.6-16.2-31.1-33.9-30-86.9 5.3-173.5 5-261.1 2.6 37.8-37 77-72.9 116.8-108.3 13.2-11.7 14.4-32 2.6-45.2z"],
    "command": [512, 512, [], "e142", "M495.5 61.5c32.3 90.5-37.8 164.3-142.1 161.5 .3 18.5 .1 37.4 .8 56.1 43.1-3.2 94.4 2.1 129.5 32.3 66.5 54.8 34.2 153.9-32.9 187.4-100 39.7-171.7-59.1-159.5-150.8-23 1.3-45.5-.1-68.9-.7-2.6 50.5-6.7 115.6-60.1 148.2-43.6 26-98.3 12.7-130.2-20.6-48.3-49.5-32.1-133.5 25.1-166.4 30.7-17.7 66.9-23.5 100.7-25.3-.3-20.7-.1-41.4-.1-62.1-30.1-1.2-71.2 3.4-98.8-14-44.9-25.1-75.9-81.8-56.6-130.4 18.9-63.5 88.8-98.2 151.8-72.4 53.4 27.4 68.5 104.9 67.7 153 22.2-.4 44.4-.6 66.7-.7-.7-63.4 12.9-129.3 83.6-159 53.8-19.2 106.4 14.6 123.1 63.9zM352.7 159c24.9 .4 54.1-7.5 66-15.2 28.1-15.9 25.7-67.1-.9-83.7-21.8-11.5-41.4 4-55.4 30.2-8.6 14.6-10 48.4-9.7 68.7zm-63.4 61.6c-22.5 .1-45 .3-67.6 .7l0 29.3c0 11.2-.1 21 .2 32.6 24 .7 45.3 2.2 68.3 .7-.8-20.6-.5-42.5-.9-63.4zM157.9 157.2c.4-33.5-6.6-73.8-30.2-94.7-3.8-3-39.5-3.5-45 5.7-14.5 11-27.5 38.6-19.2 54.7 4.8 9.9 20.7 25.7 27 28.5 16.8 9.2 50.5 3.9 67.4 5.8zm.5 190.2c-28.4 1.8-51.8 6.7-69.2 16.7-24.9 14.4-28.5 52-8.6 68.8 61.8 45.2 78.4-37.9 77.8-85.5zm197-4.3c-1.3 37.2-2.1 74 30.9 94.9 31 16.5 58.7-4.3 67.8-37.3 11.7-55.2-53.2-60.4-98.7-57.5z"],
    "tv-retro": [576, 512, [128250], "f401", "M419.2-6.4c12.9 12 13.7 32.3 1.6 45.2-14.9 15.6-34.8 38.1-50.6 54.1 59.6 5.4 181.3-30.3 188 57.7-.7 67.6-1.1 187.2-1 262.9 .5 29-24.8 54.3-53.8 53.9-137.7 2-276.5 8.8-414.7 12.3-30.8 .6-56.2-23.8-57-54.5-1.4-63.3-2.5-90.6-1.9-137.8 0-45.7 .4-74.2 1.9-133 3.4-67.1 78.5-54 125.9-60 16-1.4 32.8-2.8 49.2-3.9L153 41.7c-30.9-28.2 11.8-75.4 43-47.5 25.1 22 70 64.6 94.6 87 15.9-15.1 43-41.4 54.4-54.8 19.1-19.3 43.6-59.6 74.2-32.8zM95.7 163.1c-1.4 59-1.6 79.4-1.7 124.6-.4 46.8 0 64.5 1.6 127.9 46.3-.9 89-2 133-4.5 88-4.5 176.1-4.5 264.7-7.6-.2-72.6 .4-177.6 .9-246-67-6.8-129.9 4.3-198.1-3.3-41.7-3.7-87.4 .1-131.1 3.9-22.7 2-46.2 4-69.3 5zM423 275.1c-20.4 6.3-32.1-2.6-40.4-11.4-32.8-34.7 1.4-92.3 45.1-65.3 22.2 18.4 29.4 61.5-4.7 76.7zm3 31.6c35.1 25 8.1 80.9-34.8 70.8-23.5-4.4-35.5-35.6-23.4-55.9 7.1-16.9 40.9-30 58.2-14.9z"],
    "angle-left": [320, 512, [8249], "f104", "M251 92.4c13.5-11.4 15.3-31.6 3.9-45.1-11.4-13.5-31.6-15.3-45.1-3.9-46.8 39.3-92.3 81.9-134.6 126-18.3 19.1-45.3 47.1-65.5 67.9-13.6 13.2-11.9 36.7 3.1 47.9 8 6.3 18 14.4 25.9 20.9 6.3 5.7 12.7 11.5 19.2 17.5 33.1 31.1 68.1 57.4 99.1 92.4 11.3 12.1 25.3 26.9 37.7 37.4 6.6 5.8 12.9 11.5 17.7 16.7 28.4 30.7 75.3-12.3 47.2-43.3-18.7-19.3-36.6-32.8-53.7-52.4-30.4-34.7-68.9-64.9-103.3-96.7-7.4-6.8-14.9-13.8-22.9-20.8 55.9-58.8 109.4-113.2 171.3-164.5z"],
    "arrow-right-to-line": [512, 512, [8677, "arrow-to-right"], "f340", "M508.5 63.6L513 457.2c.3 41.9-63.4 42.4-64 .7L444.5 64.3c-.3-41.9 63.4-42.4 64-.7zM170.7 413.4c-13.5-11.4-15.3-31.6-4-45.1 18.8-22.2 52.2-54 74-76.6-70.9 2.2-138.7-5.4-208.5 .8-17.4 .7-32.5-12.9-33.2-30.8-.9-19.4 15.7-34 34.8-33.6 63.5-5.2 124.9 .9 187.7-.3 6-.1 12.5-.1 19.3-.2l-72.2-72.3c-29.4-29.6 15.5-74.7 45.2-45.2l128 128c15.2 14.4 11 41.9-7.9 51-7.6 3.6-25.3 23.1-32.7 31.4-10.8 12.2-24.5 25.8-39.7 41-30.8 23.8-52.5 79.1-90.9 51.7z"],
    "radio": [512, 512, [128251], "f8d7", "M446 20.7c6.4 16.5-1.9 35-18.4 41.3-34.9 13.4-152.4 53.7-219.3 74.8 35.3 .1 70.1-1.7 105.9-3.5 43.9-2.5 94.2-3.8 139-4.7 30.9-.6 56.3 23.9 57 54.6 2.9 110.2 2.3 154.8 0 263.4-.7 30.5-25.7 54.6-55.9 54.7-94.8 .4-166.2 3.3-261.1 7-31 2-87.7 1.7-118.4 .8-39.5 .7-77.2-20.8-74.5-61.3 .2-66.7 1.8-177.2 .5-249-4.8-37.1 21.6-71.7 56.4-81.4 93.9-32.1 254.5-78.6 349.1-115.7 16-5.2 33.5 3.1 39.6 19zM79.1 445.3c125.7 2.4 242-8.6 367.2-7.9 2.1-104.5 2.7-138.6 .1-244.6-107.2 2.6-208.4 8.4-315.1 9.9-21.7 .8-43.8 1.6-66.1 1.9 .2 70.7-.3 172.2-.9 239.1 6.1 .9 11.4 1.6 14.8 1.7zM396.4 266.1c0 1.9-.1 3.5-.2 4.3-.9 45.2-68.2 41.1-63.9-3.8-.3-42.1 63.8-42.6 64-.4zm-60.7 79.4c-27.6 48.4 54.7 82.5 61.2 22.8 1.2-31.9-42.5-50.7-61.2-22.8zm-49.8-32.2c-2 69-54.2 105.8-119.6 90.8-62.4-10.6-79.6-77.1-65.5-127 30-87.6 183.5-62.3 185.2 36.2zm-123.5-19c-4 16.6-4.6 43 14.4 46.7 23.5 3.9 32 .8 34.9-1.2 1.9-1.2 7.5-6.2 10.1-27.9 2.2-18.3-45.2-32.5-59.4-17.7z"],
    "pencil-line": [640, 512, [], "e74f", "M388.2 74.9c53.4-40.6 118.3-6.4 91.8 60.3-13.2 14.8-28.5 31.1-45.3 48.5-25-24.1-40.8-38-68.1-67.9-4.1-4.4-8.1-8.7-11.7-12.4 10.8-9.9 21.6-19.4 33.3-28.5zm-79.8 72.4c27.3 29.8 53.8 56.1 81.5 82-65.1 65.6-151.8 149.9-204 209.1-.1 .1-.3 .3-.3 .3-.1 .1-.2 .1-.3 .1-30.2 1.8-60.3 4.1-90.2 6.8-.2 0-.1 0-.3-.1 .3-32.8 .6-54.1 1.1-84.9 40.8-55.6 97-103 147.1-151.7 21.7-21.2 43.5-41.4 65.4-61.6zm230.1 14c26.1-60.3 7.5-117.4-36.2-147.3-78.7-55.3-162.5 8.5-221.2 71-27.8 26.6-55.4 51.3-82.4 77.7-53.7 52-109.2 98.7-154.3 159.9-19.3 26.1-11.1 59.3-13.3 89.3 0 6.5-.2 19.3-.4 32.4-.7 38.3 32.1 68.5 70.1 65.1 43.8-8.8 99.6 6.8 133.2-28.6 37.6-42.7 95.3-100.4 150.8-155.6 58-61.1 115.9-108.8 153.8-163.8zm37.8 341.1c49.9 8 61.3-59.1 11.6-64-66.3-1.2-133.2 3.6-200.4 4.6-27.6 2.5-76.4-6.8-76.2 35.3 3.3 41.5 50.1 28.6 77.8 28.7 62.2-.7 124-5.5 187.2-4.6z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M405.9 36.4c-65.2 45.8-117.2 114.2-178.6 164.1-9.7 12.4-32.9 26.5-35.2 42.4l0 44.6c13.9-.2 27.7-.5 42.3-.3 13 1.6 36.1-23.9 47.3-37.2 53.2-61.5 116.6-112.7 166.4-178.1 .4-9.7 .9-28.7-8-32.8-6.9-4.8-23.5-11.2-34.1-2.7zM390.7-27.2c54.1-19.2 125 21.8 121.2 86.4 4.5 31-13 53.2-32.7 77.4-47.5 52.9-101.6 101.7-149.7 155.9-25.2 27.9-49.3 58-96.3 58.8-11-.2-22 0-33.6 .2-26.5 .6-71 6.4-71.6-31.9 2.7-37.5-10.5-104.1 22.5-132.1 54.1-56.4 108.2-99.5 159.6-154.7 23.1-23.8 47.9-45.6 80.5-60zM176.1 63.1c.4 17.7-13.5 32.4-31.1 32.8L66.5 98c-5 105.5-2.4 210.9-4.6 316.1 105.5 11.7 212.7 1.4 318.8 .9 2.9-5.7 2.7-79.8 3.4-87.8 1.1-41.8 64.8-40.4 64 1.5-5.4 44.3 13.9 118.3-38 143.5-13.6 6.5-27.5 7.8-39.7 7.8-74.1 .7-151.3 3.4-225.9 2.7-46.2-1.1-131.5 9.5-146-48.6-.2-100.4-.3-200 2.7-300.1 3-38.5-8-90.1 45.1-99.4L143.3 32c17.7-.4 32.4 13.5 32.8 31.2z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M124.6 43.8c171.5-99.6 373.5-19.1 386.8 187 23.6 199.8-197.8 357.3-377 244.3-94.2-53.5-157.3-168.6-124-280.1 16-61.2 48.5-120.4 114.2-151.3zM226.6 72c-217.4 45.4-211.7 322.9 4.5 372.5-2.3-120.3-7.9-242.8-4.5-372.5zm64.1-7.5c-.1 15.6-.2 32.4-.4 49.8-3.3 122.4 3.9 222.2 4.9 332.6 204.1-39.5 206.3-363.6-4.5-382.4z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M218.5-.4c-240.1 16.6-302 387.7-83.6 486.7 105.8 49.4 270.8 29.9 341.8-87 27.4-48.8 35.7-115.2 35.7-164.9-5.9-77.7-71.6-168.4-134.1-206-50.1-28.7-108.5-28.1-159.8-28.8zM118.6 111.9c24.1-24.5 64.5-42.4 101.2-48.3 53.1 .6 105 0 145.8 32.6 27 23.7 84 102.2 82.8 138.2 0 45.5-8 98.9-27.5 133.5-44.4 76-173.8 100.8-258.5 60.5-120-53.6-124.7-226-43.8-316.5zm171.1 32c.4-41.8-63.3-42.7-64-.8l-1.3 108.7c2.5 46.9 58.3 27.8 90.3 33.8 26.2 2.5 68.2 8 69.7-29.3-2.4-47.5-63.2-30.3-95.6-36.2l1-76.2 0 0z"],
    "book": [448, 512, [128212], "f02d", "M261.6-.5c-214.8 .7-276.4-36.4-264.1 213.9-.2 65.1-.2 137.2-.2 202.6 0 3.7 .6 7.3 1.8 10.7 7.2 110.1 159.8 80.8 236.6 84.1 44.8-1.5 125.9-.7 160.6-.2 26.5 .3 48.2-20.8 48.6-47.3 .8-42.9 .3-80.8 2.1-121.2l0-.3c1.7-34.1 1.4-70.6 .8-105-.6-34.7-.5-105.4-.5-140.8 0-17.7-14.3-32-32-32s-32 14.3-32 32c.1 35.9-.3 106.6 .5 141.5 .5 34.6 .9 67.3-.8 102.1l0 .3c-1.7 36.9-1.2 65.2-1.9 106.5-91.8-2.8-197.3 5.1-288.8-2.1-23.9-2-28.5-13-29.1-16.2-4.2-20.9 46.3-39.2 70.2-40.1 49.1-6.3 102.1-.6 153.1-4 8.6-.5 16.2-4.3 21.7-10.2 5.6-6 8.7-14 8.5-22.4-.9-64.8-1.5-140.5-1.5-205.3 0-9.5 .7-59.2 1.1-89.8 .4-30.8-24-56.2-54.8-56.8zm-9.2 321.6c-63.6 1.1-130.3-6.8-191.1 20.9 0-42.6 .1-85.8 .2-128.5 5.3-43.4-13.1-109.9 13.5-144.6 2-2.8 22.8-5.1 30.3-5.1 4.8-.3 10.5-.6 15.7-1.2 0 0 .2 0 .5 0 39.4-1.4 92.6 .2 130.9 .7-1.7 99.4-.9 163 .1 257.7z"],
    "magnifying-glass-minus": [576, 512, ["search-minus"], "f010", "M361.6 20.9c118.5 61.1 141.7 223 65.1 330.6 14 13.2 24 23.8 36.3 36.6 26.7 27.8 52.9 55.1 80.4 80 13.1 11.9 14.1 32.1 2.2 45.2-11.9 13.1-32.1 14.1-45.2 2.2-29.3-26.6-57.4-55.8-84.2-83.8-6.2-6.4-12.3-12.8-18.3-19.1-4.9-4.8-10.5-10.3-15.7-15.2-92.9 87.3-259.1 46-325.3-58.4-111-187.4 114.8-414.7 304.8-318.1zM332 77.6c-101.4-52-239 36.6-240.2 155.1-3.9 87.5 85.2 148.6 167.1 149.8 147.1-10.9 208.1-232.8 73-304.9zM182.8 192.2l125.6 3.1c41.9 1.2 40.2 64.8-1.6 64l-125.6-3.1c-41.9-1.2-40.2-64.8 1.6-64z"],
    "paper-plane": [576, 512, [61913], "f1d8", "M61.9-15c-29.6-8.9-58.4 18.1-49.9 48.9 6.6 26.6 19.3 60 32.5 85.3 14.1 33.1 34.2 64.3 50.3 98.3 6.8 15.5 13.6 28.6 24.4 45-7.8 22.4-16.4 38-26.5 58.6-25 50.4-43.6 97.3-60.4 152.4-2 7.8-4.2 13.7-2.4 23.2 1.7 11.8 14.5 26 30.6 25.9 16.9-.3 22-8.4 32.6-14.7 29.9-19.8 63.5-31.3 94.3-50 83.3-47.2 174.6-74.7 258-122.4 15.6-6.8 27.8-14.4 44.4-22.5 11.3-5.1 22.4-9.7 33.3-17.7 41.6-30.7 17.5-66.5-17.1-86.7-44.8-29.7-110.6-63.5-160.7-90-53.7-28.3-90.6-49.4-141.8-72.3-47.2-21.6-91.6-47-140.8-61.1l-.9-.3zm47.7 86.9c22.3 11.6 45.1 22.2 67 32.4 78.8 36.6 155 79.7 233.7 121.6-9.4 0-18.8-.1-28.4-.2-48.2-.6-98 2.9-145.4 .9-22.6 .3-41.6-1.4-65.5-2.1-23.1-42.7-45.4-85-67.1-129.5-4.8-10.4-10.3-21.4-15.6-32.7 7.3 2.9 14.3 6 21.2 9.6zM393 289.9c-7.7 4.1-15 8-22 11.8-24.4 13.4-45.2 24.6-72.4 33.4-18.4 5.9-39.6 15.6-58.3 24.6-28.9 13.1-59.5 28.4-87 43.8-12.1 6.6-23.8 12.9-35.5 18.9 17.1-47 42.3-87.3 60-133.6 8.4 .4 17.6 .7 25.6 1.1 64.4 3.2 126.1-.8 189.7-.1z"],
    "heart": [576, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M18.1 208c-3.8-129.6 175.1-245.3 273.1-124.4 104.3-77.9 289.2-60.1 273.2 112-5.7 69.9-62.7 126-105.9 172.5-37.5 41.4-78.1 75.6-119.4 113.1-64.1 47.7-104-20.6-152.9-60.2-61.6-61.7-156.1-121.6-168.2-213.1zM315 148.4c-45.8 45.1-77.5-55.4-120.8-52.2-61.8 0-112 56.4-112 111.9 5.1 30.1 45.8 70.2 74.8 99.2 44.1 39.9 96.3 91.9 140.2 125.7 41.9-38 79.9-69.9 117.1-111.1 31.1-32.2 84.7-89.5 86.4-130.3 2.6-41.1-7.8-70-32.7-81.3-73.3-15-113.2 .5-152.9 38z"],
    "battery-half": [640, 512, ["battery-3"], "f242", "M360.3 442.7c-98.4 5.9-182.5 7.9-281.9 .4-44.7-3.5-75.9-37.7-77.2-81.6-1.3-50.2-1.4-130.3-1.3-188.1 7.2-122.9 120.4-110.4 209.7-107.9 56.5 1.6 132.5 1 202.1 .4 139.8-6.7 132.5 101.8 131.6 203.5 10.1 143.8-50.7 175.1-183.2 173.2zm-6.1-63.6c93.8-5.3 133.6 9.6 125.4-103.9-.3-36.6 .4-62.7-2.9-108.8-1.4-20.5-18.6-36.8-41.9-36.6-74.5 .5-162.8 1.5-226.7-.3-41.3 5.7-140.3-25.4-144 44.2-.2 58-.1 137.2 1.2 186.2 .4 12.1 7 18.8 18.2 19.7 95.6 7 175.9 5.3 270.7-.4zM239.4 350c-53.5 3.4-141.9 15.1-143.2-60.5-.2-15.6-.3-35.3-.3-52.6 0-40 30.8-76.3 74.6-76.3 79.9 0 155-9.4 149.3 99.7 6.9 55.5-27.2 92.2-80.3 89.6zm-6.2-63.6c6.9-1.1 15.5 .5 22.2-2.5 .5-6.5 .4-12 .3-18.8-1.6-10.4 3.6-26.4-3.5-36.8-22.8-7.7-58.1-.9-81.9-3.7-6.7 .2-10.4 5.6-10.6 12.4 0 16.9 .1 35.6 .3 50.6 25.2 1.5 47.3 .7 73.1-1.1zM576 320.3l0-127.7c.2-41.7 63.8-41.8 64 0l0 127.7c-.2 41.7-63.8 41.8-64 0z"],
    "font-awesome": [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M77.7-4.6c-25.6-10.5-54.8 8-64.6 32-5.4 13.3-4.9 38.7 2.2 51.5 5.2 9.4 13 14.1 19.1 16.6 .2 2.3 .6 4.7 1.3 7 1 3.5 1.2 6.7 1.4 13 .1 2.8 .2 6.3 .5 10.6 .8 14.3 1.2 27.9 .5 41-.4 7.1-.8 14.4-1.2 21.9-1.1 19.4-2.3 39.7-2.5 59.7-.1 10.6-.8 21.2-1.5 31.7-.6 9.7-1.3 19.5-1.4 29.3-.2 9.6-.8 19.1-1.4 28.7-.7 10.2-1.4 20.4-1.5 30.6-.1 10.6-.3 21.3-.4 32.2-.2 14.9 .2 29.7 .7 44.6 .4 12.1 .7 24.2 .7 36.3 0 17.7 14.3 32 32 32s32-14.3 32-32c0-11.9-.4-23.8-.7-35.7-.3-11.2-.7-22.4-.7-33.6 5.9 .1 11.8 .3 17.7 .5 76.6 2.3 154.7 .4 234.2 2.9 23.8 .7 47.5 .5 71.2-2.4 4.4-.5 11.8-1.5 18.5-3.2 8.6-2.2 20.3-6.7 30-16.9 7.1-7.5 9.4-16.2 10.2-21.2 .9-5.4 .7-10.3 .4-13.8-.6-7.1-2.4-13.5-3.5-17-2-6.6-5.1-12.7-8.2-18.7-1.9-3.7-3.7-7.3-5.4-11.1-9.1-21-20.1-46.9-24.5-70.3 1.8-14.5 5.2-28.7 10.7-42.2 4.1-7.9 8.5-15.2 12.9-22.6 10.6-17.7 21-34.9 25.2-57.2 2-10.7 1.5-23-5.6-35.5-5.8-10.1-14.8-14.5-21-16.3-4.8-1.4-9.2-1.5-11.2-1.5-13.3-3.1-27.8-3.1-42.1-3-8.7 0-17.3 .1-25.6-.6-10.8-.9-22.9-1.9-35.1-2-55.1-.6-110.8-.1-166.1 .3-22 .2-43.9 .4-65.7 .5 6.9-25.5-6.2-55.5-31.5-65.9zm98.9 129.4c54.6-.5 108.8-.9 163.6-.3 23.1 .3 47.9 1.7 70.9 4-3.4 6.8-7.7 13.7-12.2 20.7-5.8 9.2-11.8 18.6-15.9 28.4-4.8 11.6-13.3 32.1-13.4 52.4-1.4 12.3-.4 23.6 3.4 35.5 1.1 3.5 2.3 7 3.4 10.6 8.1 25.3 16.3 50.8 28.6 74.3-18.5 2.4-37.8 2.3-59.1 1.7-79.7-2.4-157.9-.6-234.6-2.9-5.9-.2-11.9-.3-18-.5 .2-3.2 .4-6.3 .6-9.5 .6-9.5 1.3-19 1.4-28.5 .2-9.9 .8-19.7 1.4-29.5 .7-10.7 1.4-21.3 1.5-32 .1-18.3 1.2-36.1 2.3-54.8 .5-7.8 .9-15.8 1.3-24.1 .7-13.4 1.3-29.3 .8-45.1 24.8-.1 49.4-.3 73.9-.5z"],
    "forward": [576, 512, [9193], "f04e", "M359.9 62.9c-32.1-16.8-68.9 7.8-68.1 42.5 .9 40.6 1.1 81.1 1 121.6-43-38.1-76.1-58.3-115.2-98.7-21.1-20.2-45.5-42.7-73.7-57.4-32.1-16.8-68.9 7.8-68.1 42.5 1.4 59.6 1.1 119.2 .8 178.9-.2 37-.6 74 .3 111.2 .5 38.8 46.4 64.6 79.6 38.5 30.5-22.4 61.8-42.9 92.5-65.7 29.5-21.6 57.7-39.1 83.5-65.2 0 23.8-.4 46.8 .2 70.9-6.8 43.8 40.2 82 79.8 52 30.5-22.4 61.8-42.9 92.5-65.7 184.3-123.2 99-125.3-22.5-239.6-24.6-23.6-50.2-48.9-82.6-65.9zm-3.3 222.8c.2-49.2 .5-98.9-.2-148.5 48.4 44.3 88.4 80.8 143.3 124.1-22.9 21.3-48.3 38.1-73.8 56.4-23.1 16.7-45.9 33.1-69.5 49.1-.2-26.9 .1-53.8 .2-81.1zm-256 8c.2-49.2 .5-98.9-.2-148.5 48.4 44.3 88.4 80.8 143.3 124.1-22.9 21.3-48.3 38.1-73.8 56.4-23.1 16.7-45.9 33.1-69.5 49.1-.2-26.9 .1-53.8 .2-81.1z"],
    "triangle": [576, 512, [9650], "f2ec", "M289.4 39.4c16.4-1 26.7 12.1 35.3 24.2 58.9 75.5 120.9 154.9 165.5 244.9 16 32.3 37.7 60.5 61.4 91.5 6.5 8.4 13.1 17 19.8 26 15.9 19.9 0 52-25.6 51.2-103.6 1.8-209.2 2-314.1 5.6-62.4 1.9-126.9 3.8-196.1 3.8-8.8 0-17.2-3.6-23.2-10-24.7-29.9 8.5-66.5 28.1-87.5 79.8-101.5 138-229 223.5-336zm1.7 85.1c-72.2 95.6-121.8 201.8-193.9 297.5 129.8-4 254.3-4.9 383.8-9.2-64.2-95.7-112.1-198.5-190-288.3z"],
    "lightbulb-slash": [576, 512, [], "f673", "M48-28.3C34.5-39.7 14.3-38 2.9-24.6-18.4 2.3 8 21.8 27.6 41.1 46.7 62 68.5 81.7 89.9 99l0 0c48.4 38.9 85.9 87.8 131.2 127.7 104.2 102.6 199 210.8 302.8 312.9 12.4 12.6 32.6 12.8 45.3 .4 12.6-12.4 12.8-32.6 .4-45.2-37.3-37.9-75.1-77.7-112.7-115.3-108.3-111.2-212.2-227.9-326.8-330.3-30.7-23.4-53.6-51.6-82.1-77.5zM243.7 69.4c115.7-27.7 198.1 53.6 174.3 171.1-9.2 40.7 52.9 55.1 62.4 14.2 33.4-154.2-81.1-285.1-244.3-248.9-41.5 5.2-34 68.3 7.6 63.6zm44.2 314.2c0-17.7-14.3-32-32-32l-19 0c-.9-17.8-2.9-41.8-23.5-47.6-35.4-12.1-66.4-46-79.3-89.5-5-17-22.8-26.6-39.8-21.6-68.3 27.8 38.4 150.6 78.8 163.5l3 30.4c1.6 16.4 15.4 28.8 31.8 28.8l48 0c17.7 0 32-14.3 32-32zm58.4 132.8c41.8-.9 40.8-64.5-1-64-32.3 .5-64.7 1.5-97.2 3.1-41.8 2.3-38.6 65.9 3.3 63.9 31.6-1.6 63.2-2.6 94.9-3.1z"],
    "landmark-dome": [576, 512, ["landmark-alt"], "f752", "M239.5 33.1c33.8-3.9 74.5-4.8 110.9 13.1 62 33 115.1 79.7 121.7 147.4-133.8-3.5-266.8 3.7-400.4 4.6l-.9 0C94.6 114.7 160.5 47.6 239.5 33.1zM340.8-25.9C182.3-69.2 16 60.9 3.7 218.3l0 .2c-.2 2.2-.8 9.9 2.6 18 6.8 14.2 11.8 15.2 20.1 20.8 11.6 8 23.8 3.5 37.2 4.6 .4 0 .8 0 1.2 0 .4 17.1 1.3 59.7 1.3 70l1 37.6c1.3 41.8 64.9 40.2 64-1.6-.9-31.6-1.4-70.5-2.3-106 19.1-.2 38.7-1 57.9-1.8 1.5 21 3.6 54.1 4.1 73.2l0 .4 1.2 33.5c1.6 41.8 65.2 39.6 64-2.2-.9-33.2-2.6-73.4-5.2-107.1 24.1-.6 48.2-1.1 72.2-1.3l2.8 110c.4 17.7 15.1 31.6 32.8 31.2s31.6-15.1 31.2-32.8L386.8 257c22.2 .2 44.4 .4 66.8 .5l-1.4 104.2c-.2 17.7 13.9 32.2 31.6 32.4s32.2-13.9 32.4-31.6l1.4-106.1c31.2-7.8 24-47.3 18.4-69.7-10.8-103.4-103.2-183.5-195.3-212.6zM54.5 453.7c-41.8-.7-43.2 62.9-1.3 64 133.6 3.3 266.9-5.5 399.3-1.2l.3 0 56.6 1.6c41.8 1.1 43.7-62.6 1.8-64-152.4-7.2-304.7 2.6-456.6-.5z"],
    "moon-star": [512, 512, [], "e7c9", "M485.6 342.4c-6.6-9.4-17.8-14.5-29.2-13.4-18.9 1.6-53.2 5.1-67.6 5.2-118.4 1.3-204.7-157.3-157-260.9 8.4-23 15.2-16.1 24-37 7.6-20.6-13.3-43.6-31.7-41.2-16.2 1.3-36.1 4.5-51.4 7.6-46 17.7-96.9 58.8-127.4 96.1-67.5 104.2-73 255.1 25 346.3 106.8 90.4 250.4 92.4 361.7 11.3 29.9-22.9 42.9-52.6 54.3-77.2 6.4-11.4 7.2-25.6-.7-36.5l0 0zm-83.9 55.3c-106 94.7-303 59.8-338.1-88.8-14.2-49.6 5.6-129.7 33.6-172.8 15-18.4 40.2-39.9 64.7-56-36.7 148.1 75.7 325.7 239.8 317.5zM510 122.5c-2.8-35.4-41.3-30-66.9-27.9-1.9-27.1 3.9-70.5-34.7-70.4-38.2 1.8-31.3 44.9-29.4 71.7-26 0-66.6-5.6-68.8 30.4-1.1 19 14.8 34.6 33.6 33.7 13.1 0 26.2 0 39.5-.1 .9 26.2-2.1 66.2 34.4 65.8 36-1.4 32.1-41.3 29.6-67.2 25.9 0 64.8-.6 62.7-36z"],
    "strikethrough": [448, 512, [], "f0cc", "M156 37.2c96.2-18.1 190.1-2.9 250.4 64.9 29.7 29.4-14.8 74.9-44.8 45.7-27.5-26.9-55.7-46.4-86.3-50-54.6-10.2-219.4-.7-170.2 89.2 98.1 52.5 208.8 24.6 314.6 43.4 17.5 2.2 30 18.2 27.8 35.7-2.2 17.5-18.2 30-35.7 27.8-35.1-4.4-70.7-6.5-107.2-8.4-77.1-4-154.1-2.6-231.6-1.2-27.2 .4-71.4 8.2-72.9-30.8-.5-27.6 27.1-35.3 50-32.8-55.4-85.8 21.8-173.4 106-183.5zM375.9 334.3c17.7 0 32 14.4 31.9 32-.1 48.1-34.2 81-68.6 96.5-62.6 25.7-120.4 19.5-180.9 14.1-58.8-5.5-102.8-55-122.6-95.8-18-37.7 39-65.6 57.6-28 15.2 31.3 44.1 57.6 71 60.1 56.2 3.6 165.8 19.9 179.6-46.9 0-17.7 14.4-32 32.1-31.9z"],
    "shield-check": [448, 512, [], "f2f7", "M157.5 90.2c8.4-3.8 48.4-19.6 68.4-27.4 50.3 14.3 108.1 35.4 154.8 56.7-2.4 66 16.1 146.9-16.5 206.7-42.3 57.4-77.5 95.5-143 116.1-177.1-75.8-149.5-146.1-154.9-320.6 29.3-8.6 62-18.3 91.3-31.5zM243.7 1.3C210.5-10 156.5 24.2 131.2 31.8 99.4 46.3 61.3 56 25.9 66.9-9.9 80.5 4.6 119.8 3.3 148l0-.2c-8.1 181.9 16.2 286 205.4 358.7 8.9 3.7 19.1 3.2 27.6-1.5 79.4-23.5 134.7-77.4 179.6-141.2 39.9-59.2 30.4-134.8 29.9-199.4-5.2-27.8 10.1-68.2-15-89.1-36.3-25.3-70.4-32.2-107.9-47.8-21.3-9.6-55.9-19.7-79.3-26.2l0 0zm92.9 176c-12.5-12.4-32.8-12.4-45.2 .2-25.8 28.1-53.7 49.5-80.4 75.9-4 3.9-8.5 8.4-12.5 12.1-9.6-9.3-18.8-17.9-27.5-26.2-30.5-28.6-74.2 17.6-44 46.5l0 0c16.6 15.8 47.9 59.8 75.9 54.4 11.7-2.5 16.4-8.1 23.9-14.3 11-9.1 20.2-18.1 29.5-27.3 27-26.3 54.3-47.5 80.6-76.1 12.4-12.5 12.4-32.8-.2-45.2l-.1 0z"],
    "arrow-down-to-bracket": [448, 512, [], "e094", "M256.4 165.5c-.1 27.4-.2 54.7-.2 82 13.3-13.1 26.8-26.1 39.2-38l0 0c25.4-22 47.2-60.8 79.3-33.2 29 33.9-15.5 57.6-38.3 82.6-105.6 90.8-88.3 154-202.7 29.4-20.8-22.7-39.9-45.9-60.4-66.9-12.4-12.6-12.2-32.9 .4-45.2 12.6-12.4 32.9-12.2 45.2 .4 24.1 24.5 49.1 55.3 73.2 80.5 .1-54.9 .5-128.6 .6-221 0-17.7 14.3-32 32-32s32 14.3 32 32c0 43.2-.2 86.4-.3 129.5zM.1 339.9c.2-41.9 63.8-41.8 64 0l0 47.5c1.3 43.9 9.3 53.3 14 56.7 52.8 18.5 129.5 5.9 187.7 8.8 32.5-1.9 79.3-.3 106.6-15.2 7-4.4 11.6-9.8 11.7-21.9l-2.9-64.5c-.8-17.7 12.8-32.6 30.5-33.4 17.7-.8 32.6 12.9 33.4 30.5l3 65.3C442.8 553.3 241.5 509 148.5 517.3 18.6 524.1-7 461.3 .1 339.9z"],
    "star-half": [576, 512, [61731], "f089", "M294.5 20.9c-16.4-6.6-35 1.4-41.6 17.8-14.8 36.7-26 56.6-42.1 84.9-6.9 12.2-14.4 25.3-22.5 40.7-55.4 12.6-95.2 20.4-143.3 28.3-25.9 3-36.6 38.5-16.5 55.4 26.8 23.9 70.9 48.2 91.9 75.4 4.7 5.2 10 11.2 15.3 16.7-6.3 46.7-15.5 89.9-21.6 136-.4 0 1.3 .2 4.5 .6l-4.5-.6c-4.1 29.6 31.2 45.7 53.8 29.2l0 0c40.4-26.4 87.1-53 123.8-78.6 34.6-23.5-.8-76.3-35.7-53.1-20.7 14.5-44 29-67.4 43.1 .2-1.2 .4-2.4 .5-3.6 3.4-37.1 25-87.8-6.6-116.7-17.7-18.6-32.4-38-54.9-53.7 27.1-5.3 55.4-11.5 89.4-19.4 9.2-2.1 17-8.3 21.3-16.7 10-19.8 18.8-35.1 27.4-50.3 17.5-30.8 30-53.1 46.5-93.8 6.6-16.4-1.4-35-17.8-41.6z"],
    "arrow-down-to-line": [448, 512, ["arrow-to-bottom"], "f33d", "M221.7 3.8c17.6-1.6 33.2 11.3 34.8 28.9 3.8 40.5 2.6 82.5 1.6 122.1-.8 25.9-1.2 45.8-.8 71.4 .1 6 .1 12.5 .2 19.3l72.3-72.3c29.6-29.4 74.8 15.5 45.2 45.2l-128 128c-14.4 15.3-41.9 11-51-7.9-3.6-7.6-23.1-25.3-31.4-32.7-12.2-10.9-25.8-24.5-41-39.7-23.7-30.8-79.2-52.5-51.7-90.9 36.1-36 68.5 22.5 97.1 45.7 8.9 9 17.3 17.3 24.6 24.4 0-5.1-.1-10.1-.1-15-.4-28.7 .1-55.4 .9-82.3 1-37.4 2-72.7-1.4-109.5-1.6-17.6 11.3-33.2 28.9-34.8zM421.3 513.2L27.7 517.7c-42 .3-42.4-63.3-.7-64l393.6-4.5c41.9-.3 42.4 63.4 .7 64z"],
    "fire": [448, 512, [128293], "f06d", "M181.5 26.3c-36.4-33.4-68.2 24.7-91.3 47-126.4 112.8-132.4 392.5 61.6 433.9 73.4 21.9 162.6 3 224.2-48.5 97.2-91.5 72.5-230 12.2-326.7-15.7-22-17.9-52.3-41.9-65.8-16.3-6.8-35.1 .9-41.9 17.2-1.2 5.1-20.8 26.4-31.9 36.7-27.5-30.7-63.1-66.3-91.1-93.8zM327.3 156.1l.8-.8c25.5 47.6 54.9 98.7 49 152.3-4.3 42.2-16.6 82.6-42.1 102 1.6-51.8-17.5-102-54.4-135-6.1-5.9-25.8-29.1-34-38.8-27.8-30.8-57 6.1-73.8 28.4-33.8 47.6-69.4 96-59.6 156.8-49.6-42.1-55.3-124.8-45.6-183.6 11.9-50.6 44.5-95.6 82.4-134.9 2.7-3.1 5.3-6.1 8.1-9.2 19.6 19.6 45.5 45.9 63.8 66.3 22.7 21.8 19.2 35.8 45.4 40.5 27.4 .8 39.1-27.9 59.9-44zM239.8 451.6c-12.1 .7-26.8 2.5-39.6-1.7-24.6-5.4-30-62.9-18.4-79.5 11.1-21.1 27-48.5 40.1-65.2 17.5 19.7 35.6 33.5 42.4 57.4 10.2 33.6 14.7 77.8-24.5 89z"],
    "magnifying-glass-plus": [512, 512, ["search-plus"], "f00e", "M413.2 126.8c-53.7-87-169.2-145.9-272-108.1-85.8 32.5-147.8 120.1-134.4 217.6 7.6 55.9 20 128.5 78.7 162.6 73.5 52.3 188 56.9 263.6 7.1 13 12 25.8 23.5 38.4 34.9 25.5 22.9 50.2 45.2 74.2 69.5 12.4 12.5 32.7 12.7 45.2 .3 12.6-12.4 12.7-32.7 .3-45.3-25.1-25.4-52.4-50-78.9-73.9-11-10-21.9-19.7-32.4-29.4 50.2-66.7 61.3-161.3 17.4-235.3zM163.9 78.6c68.1-27 159.6 21.3 194.6 81.3 40.5 64.8 9.9 171.8-61.7 202-55.3 22.8-115.3 20.8-165.7-10.4-45.5-18.2-54.9-77.9-60.8-123.9-8.9-64.2 32.1-125.7 93.7-149zM331.2 224.4c-.1-17.7-14.5-31.9-32.2-31.8l-39.7 .2c-2.6-31.5 5.6-87.7-39.9-84.8-42.5 7.1-22.4 55.7-24.1 85.2l-50.8 .3c-17.7 .1-31.9 14.5-31.8 32.2 1.7 42.4 51.4 30.2 79.2 31.6 0 10.7 .5 20.6 1.2 30.7-.4 24.5 1.8 54.7 32.9 55.1 45.4-2.1 28.8-56.6 30-86.1l43.4-.3c17.7-.1 31.9-14.5 31.8-32.2z"],
    "rectangle-vertical": [448, 512, ["rectangle-portrait"], "f2fb", "M437.7 504.1c-6 6.3-14.4 9.9-23.1 9.9-27.8 0-67.5-.5-107.1-.9l-.8 0c-40-.5-79.9-.9-108-.9-29.9 0-93-7-127.4-11.1-30.9-3.7-54.5-28.9-56.1-59.9-3.9-74.6-14.7-288.3-14.7-347.2 0-.6 0-1.2 0-1.9 0-6.6-.1-18.9 2.5-30.4 2.9-13.1 11.4-33.8 35.1-41.9 47.2-16.2 101.2-19.7 152.1-19.6 25.7 .1 51.4 1 75.7 2l.9 0c24.2 .9 46.8 1.8 67.7 1.8 1.4 0 3.2 0 5.4 0 9.1-.1 23.9-.2 38.1 .7 8.8 .6 18.7 1.7 27.8 3.8 8.2 1.9 20.3 5.6 29.9 14.1 6.9 6.1 10.8 14.8 10.8 24 0 40-.5 86-1.1 134.1-1.2 103-2.5 215.8 1.1 299.8 .4 8.7-2.8 17.2-8.9 23.5zM382.5 69.3c-2.7-.3-5.7-.6-8.9-.8-11.3-.8-22.6-.7-31.8-.6-2.6 0-5 0-7.3 0-22.2 0-45.9-.9-69.5-1.8l-1.6-.1c-24.4-1-49-1.9-73.4-1.9-46.5-.1-89.4 3.1-125.1 14.1-.2 1.3-.3 2.9-.4 4.8-.1 2.8-.1 5.4-.1 8.5 0 .7 0 1.5 0 2.3 0 56.6 10.6 267.5 14.6 343.6 36 4.3 94.4 10.6 119.6 10.6 28.6 0 68.9 .5 108.8 .9l.4 0c25.8 .3 51.3 .6 73.6 .8-2.2-81.1-1-181.5 0-272.4 .4-38.4 .9-75.1 1-108z"],
    "burger": [576, 512, ["hamburger"], "f805", "M210.6 69.7c-50.6 7.4-83.8 45.2-104 83.3L94.8 194.2c-11.5 40.2-72.9 22.8-61.6-17.5 15.7-83.5 83.7-157.9 165.2-169.8 140.8-28.5 329.2 14.3 345.5 182.9 1.3 17.6-12 32.9-29.6 34.2s-33-12-34.2-29.6C465.3 66.5 312.6 51 210.6 69.7zM24 292.4c-.3-17.7 13.8-32.2 31.5-32.5 60.6-1 121.2 .1 181.2 1.2 81.8 2.5 163.9 .4 245.8 1 26.4-.2 63.7-3.5 64.9 31.9 .3 36.1-40.3 33.9-65.9 32.1-82.5-.5-164.4 1.5-246.9-1-61-1.2-120.7-1.8-181.7-1.3-16.1-1.5-28.7-14.9-29-31.4zm68.9 77.9c42.3 85.7 153.7 81.1 239 74.5 64.1-6.6 125.5-10.6 152.8-68.8 22.1-35.6 76.3-2.2 54.5 33.5-34.6 77.4-132.2 94.7-200.9 98.9-107.1 10-246.9 6.7-303.2-110.7-17.9-37.9 39.7-65.2 57.8-27.5z"],
    "print": [512, 512, [128424, 128438, 9113], "f02f", "M417.2 35.4L415.6 127c49.4 2.3 88.6 42.1 90.7 91.4l6.9 161.7c.8 17.7-13 32.6-30.6 33.3-17.6 .7-32.6-13-33.3-30.6l-6.9-161.7c-.7-16.7-14.1-29.8-30.4-30.2-77.6-1.9-215.2-3.9-318.1 1.5-15.1 .8-27.5 13.7-27.3 30.6L69.1 381c.3 17.7-13.8 32.2-31.5 32.5-17.7 .3-32.3-13.8-32.5-31.5L2.6 224.1c-1.2-52.1 41-96.5 94.6-95.9l0-96.2c0-8.5 3.4-16.6 9.4-22.7S120.8 0 129.2 0L290.8 .4c1.2-.1 94.1 2.5 95.2 2.4 17.6 .4 31.5 15 31.2 32.5zm-65.6 90.4L352.6 66c-40.3-1.8-149.6-1.9-191.5-1.9l0 61.9c64.8-1.5 133.9-1.1 190.4-.3zM227.3 288c43.4 0 88.3 4 131.2 5 53.2 .8 61.3 60.2 58.5 102-.9 40.5 17.4 113.4-52.1 116.6-75.8-1.5-141.6 1.5-213.9-1.2-30-1-53.7-25.6-53.8-55.5-.2-31.8-.3-90.3 1-117.7 5.4-63.6 86.6-45.1 129.1-49.2zm125.3 78.1l-1.6-9.3c-16.6-.5-33.5-1.4-50-2.2-48.7-2.8-90.6-3.7-139.2-.5-.6 26-.6 65.2-.5 92.7 67.9 2.2 122.6-.5 193.1 .8-.4-30.4-1.9-37.8-1.2-58.3 .1-8.4 .2-15.3-.5-23.1z"],
    "users": [640, 512, [], "f0c0", "M98.8 161.3c-30.3-137.7 134.1-233 222.8-117.9 56 65.2 12.5 162.1-62.6 193.3-67.6 27.2-151.9-5.7-160.3-75.4zm136 16.2c78.5-28.6 43.2-145.4-33.7-116-37.9 15.5-44.5 50.8-39.5 87.4 5.2 39.1 51.2 35.7 73.2 28.6zm196.4 8.4c90 18.2 66.5-138.7-5.8-127.5-41.5 5.1-49.6-57.9-8.1-63.5 84.5-13.6 139.5 72.9 136.4 147.4 0 77-70.6 120.2-136 106.1-17.2-3.7-28.3-20.7-24.5-38 3.7-17.3 20.7-28.3 38-24.5zm12.7 293.6c1.4-96.9-60.6-150.4-154.9-156.1-137.2-12.1-275-3.5-278.7 166.5-2.2 41.8 61.3 45.5 63.9 3.7 2.8-47.6 14.3-71.9 29.9-85.6 14-16.2 64.6-25.2 108.2-23l2.7 0c46.3-.2 100.7-.4 138.8 22.8 17.1 9.6 27.1 51.7 26.2 71.6 .2 41.9 63.7 41.8 64 0zm52.5-162.8c-17.7 0-32 14.3-32 32s14.3 32 32 32c29.2 0 42.3 15.5 57.4 38.9 11.7 18.2 14.4 36.6 14.4 64.4 0 17.7 14.3 32 32 32s32-14.3 32-32c0-31.8-2.9-65.3-24.7-99-12.2-18.9-25.4-37.1-43.7-49.7-19.5-13.5-41.6-18.6-67.5-18.6z"],
    "alarm-clock": [640, 512, [9200], "f34e", "M158 12.8c30.5-28.6-12.7-75.3-43.5-46.9-28 25.9-54.7 53.2-83.5 78.3-31.4 27.6 10.4 75.6 42 48.3 17.8-15.5 34.9-32 51.5-48 10.6-10.2 22.7-21.8 33.5-31.6zM482.6-28.5c-26.8 31.3 16.5 56.1 35.1 76.7 13.3 14 33.4 31.5 46.3 46 27.5 31.6 75.7-10 48.5-41.8-16.3-18.4-30.3-29.7-47.2-47.2-22.3-20.2-51.6-64.8-82.6-33.7zm-77.3 44C288.8-32 130.6 32.9 80.8 146.1 55.6 218 58 293.1 85.6 357.9 217.5 666 689.9 464.2 551.5 165 526.1 108.5 479.1 30.7 405.3 15.5zM140 170.4c34.3-85.2 179.7-134.4 260.8-88.7 50.2 18 66.6 62 93.4 111.9 56.2 112.3-28.8 254-179.2 254-142.9 7.6-220.7-160.2-175-277.2zm211.9-18.8c-.2-41.8-63.8-41.9-64 0l0 104c0 17.7 14.3 32 32 32 31.3 .1 71.5 .2 102.8 1 41.8 .9 43.6-62.7 1.7-64-22-.6-49.7-.8-72.5-1l0-72.1z"],
    "database": [448, 512, [], "f1c0", "M84.2 98.3c76.5-51.7 212.2-43 281.7 .4 16.2 8.4 21.8 34.7 20.4 55-110.1 40.4-202.7 31.1-321 9.5-1.1-21.3-.9-54.8 18.8-65zm-18.8 130c109.3 19.5 207.3 29.2 320-6.6-.7 25.3-.5 51.1-.1 76.5-63.2 23.5-122 23.2-185.2 22.2-37.7 1.3-92.7-9.2-134.7-18.2l0-73.9zM386.1 365.9c-58.3 17.7-127.9 20.5-188.2 18.5-40.4 1-90.7-8.1-132.6-16.8-12.7 117.6 338.8 107.6 320.8-1.7zM201.8 0C113.8 .9 1 39.1 1.4 137.6l0 238c8.4 169.1 296.2 167.2 402.4 90.6 54.2-34.4 47.1-99.7 45.7-153.8-2.2-56 2.3-120.5 .5-174.2-4.5-120-149.8-139.9-248.2-138.2z"],
    "newspaper": [576, 512, [128240], "f1ea", "M188.6 92.7c102.7 5.7 198.1-1 304.5 1.8 6.3 .3 12.6 .5 18.6 .7l0 231.9c-5.1 63.6 10.5 97.4-72.8 91.2-51.6-.9-105.8 1.8-159.4 2.3-37.3 .1-53 1.9-97.9-.4 16.7-51.9 11.6-96.4 11.1-147.4-.4-63.7-3.8-115.6-4.1-180.1zM98 416.2c-.6 0-2.3-.1-2.9-.2l-.1 0c-33.1-5.3-29.2-20.2-32-61.4l-2-219C60.8 118 46.4 103.8 28.7 104S-3.2 118.6-3 136.3l2 219.3 0 .7c-4.2 56 24.4 124.3 96.3 123.9 82.5 5.4 160.2 6.2 237.8 3.5 90.8-7.5 238.3 31.2 240-106.7 .7-13.1 3.3-51.7 2.7-64l0-247.4c-1.8-43.1-44.4-32-78.9-34.9-84.2-5.9-155.1 5.6-238.3 0-38.8 1.6-142.8-22.8-133.9 45.9-.3 33.4-.1 55.7 1.2 83.2 2.1 39.2 1.6 80.9 2.9 119-.9 43.5 8.6 95.4-15.6 135.1-3.1 1.7-7.4 2.6-15.3 2.3zM413 224c41.9-.2 41.8-63.8 0-64l-128 0c-41.9 .2-41.8 63.8 0 64l128 0zm-61.7 59.2l-.6 0-70.6 1.3c-17.7 .3-31.7 14.9-31.4 32.6 .3 17.7 14.9 31.7 32.6 31.4l70.3-1.3c11 0 22.1 .3 33.6 .5l.2 0c25.9 1.6 66.9 5.2 67.3-31.4-.6-36.2-39.7-32.6-66.1-32.6-11.4-.3-23.4-.6-35.3-.6z"],
    "location-arrow": [512, 512, [], "f124", "M501.4 10.6c18.2 19.4 1.7 47.2-5.5 67.9-47.6 136-98.8 282.1-174.8 408.7-9.3 15.6-26.1 24.8-43.9 24.8-28.3 0-51.4-23-51.3-51.5 .3-57.1 1.5-114.2 1.9-171.4-14.8 0-29.5-.1-44.2-.2-40.7-.2-81.1-.3-121.7-.1-34 .2-61.9-27.2-61.9-61.4 0-24.7 14.9-47.1 37.8-56.6 28.9-12 57.7-23.6 86.4-35.3 47.3-19.2 94.3-38.3 141.1-58.2 63.1-26.9 136.2-56.4 204-75.7 11.5-3.3 23.9 .1 32.1 8.9zm-74.8 72c-45.8 16.1-92.7 35.2-136.2 53.7-47.2 20.1-95.2 39.6-142.9 59-24.3 9.9-48.5 19.7-72.5 29.6 56.4-.2 113.1 .2 169 .3 26.4 0 48 21.5 47.9 48.1-.2 46.2-1 92.3-1.6 138.5 55.3-102.5 96.6-216.4 136.3-329.2z"],
    "rectangle-code": [640, 512, [], "e322", "M118.8 40.2c-13.2-11.8-33.4-10.7-45.2 2.5-15.5 17.2-43.9 44.7-62.1 62.1-13 11.9-13.2 34-.4 46 20.1 20 43.9 45.6 64.3 64.3 30.3 28.9 74.4-17 44.4-46.1-9.5-8.8-32-30.9-40.6-40.4 21.8-24.9 72.5-54.6 39.8-88.4zm84 1.2c-12.5 12.5-12.5 32.7 0 45.2l41 41c-10.2 9.8-33.5 32.2-42.2 42.9-27.9 31.2 19.5 73.8 47.6 42.8 7.8-10.2 52.4-52.5 62.5-62.4 6.2-6 9.7-14.1 9.7-22.7s-3.3-16.8-9.4-22.9l-64-64c-12.5-12.5-32.8-12.5-45.2 0zM405.6 32c-17.7 0-32 14.3-32 32s14.3 32 32 32c47.4 .4 87.2 1.4 137.8 7.3 2.5 65 2.1 243.1 1.8 309.8-112.2 6.8-206.4-2-324 1.5-18.9 .2-37.2 .4-54.1 .4-3.6-31.8-6-65.8-5.7-94.7 .2-17.7-14-32.2-31.6-32.4-17.7-.2-32.2 14-32.4 31.6-.4 39.7 3.7 86 8.7 124.8 2.6 20 19.6 34.8 39.7 34.8 81.9-.2 190.7-2.7 265.2 0 47.1 1.7 112.8 1 162.5-4.4 19.6-2.1 35.4-18.4 35.5-39.3 .2-46.9 1.7-310.5-3.2-358-1.9-17.5-14.6-29.6-29.1-33.2-61.3-11.5-114.1-11.3-171.2-12.4z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M240.4 217.5c4.1 3.8 8.1 7.5 12 11.2-74.4 .2-148.4 .5-222.8 .6-17.4 .9-31.2 15.9-30.2 33.7 .9 19.6 19.1 32.5 38.1 30.2 68.5 0 136.9-.4 205.4-.5-13.1 13.3-26.1 26.9-38.1 39.2-22 25.3-60.8 47.2-33.2 79.4 33.9 29 57.6-15.6 82.6-38.3 30.2-31.4 64.7-67.2 88.9-88.1 42.7-41.6-61.4-111.1-87.7-139.7-25.1-18.4-51.6-64.6-84-34.9-30.2 35.4 21.3 61.7 43.9 84.9 8.7 7.7 17.2 15.2 25.1 22.4zM335.3 36.7c-41.9 .2-41.9 63.8 0 64l47.6 0c43.8 1.3 53.3 9.3 56.7 14 18.5 52.9 5.9 129.5 8.8 187.7-1.8 32.4-.4 79.3-15.1 106.6-4.4 7-9.8 11.6-21.9 11.7l-64.5-3c-17.6-.8-32.6 12.9-33.4 30.5-.8 17.6 12.8 32.6 30.5 33.4l65.4 3c139.5-5.3 95.1-206.6 103.5-299.5 6.7-130-56-155.5-177.4-148.4z"],
    "folder-check": [576, 512, [], "e64e", "M195.1 88.5l35.8-1.1c31 23.5 50.7 78.8 99.3 79.7 54.4 1.9 93.5-.9 146.6-2.6-.4 50-2.5 174.8 .4 221l0 31.4s0 .1-.1 .1c-31.9 .4-60.7 .6-91.8-.2-40.4-1-84.4-.6-125 .5l-.2 0c-58.6 1.8-104.1 1-170.2 .2-1.2-51.5-.5-103 .2-154.9 .4-31.4 .8-62.9 .8-94.7 0-.4-.8-79.3-.8-79.7 38.5 0 64.2 .3 105.1 .3zm79.7-47.7c-20.2-22.1-54.8-17.2-81.2-16.3-61.7 4.3-163.5-24.7-167.6 64.3 .9 52.2 1 118.6 0 170.8-7.2 261.4-7.3 220.7 235.4 221.6l.2 0c41-1.2 79-1.5 120.2-.5 88.2-1.2 170 23 159.3-100.1-2.7-37.4-.7-171.4-.3-216-1.7-60.5-55-69.2-104.8-62.8-24.5 1-48.3 1.9-69.2 1.9l-.9 0c-11.2-.2-22.6-.5-34.2-.7-.1 0-.4-.1-.9-.4-17.9-22-42.3-49.7-55.9-61.9zM379.4 262.6c29.5-29.7-15.6-74.8-45.2-45.2-20.2 20.3-61.1 61.1-81.4 81.4l-25.4-25.4c-29.7-29.5-74.8 15.6-45.2 45.2l48 48c12.5 12.5 32.8 12.5 45.2 0 24.4-24.6 80-79.9 104-104z"],
    "video-slash": [640, 512, [], "f4e2", "M88-22.4c-12.5-12.5-32.8-12.5-45.3-.1-26 26.5 6.8 53.1 25.9 70.8 32 29.2 58.5 63 89.1 92.1 25.5 24.8 49.1 50.6 74.6 74.8 80.9 86.2 171.5 164.1 253.2 249.5 20.2 23.7 44.6 42.2 64.8 67.8 32 55.1 98.5 6.3 51.5-38.2-19.2-25.2-46.6-47.5-68.6-72.3l0 0c-63.5-69.9-137.1-128.9-201.8-197.4-17.3-18.8-37-38.4-55.4-56.3-25.4-24.1-49.4-50.5-74.3-74.5-31.2-30.6-58.7-64.4-90.1-93.2-8-7.8-15.8-15.5-23.3-23l0 0zM413.1 37.5c-41.2-5.4-62.9-5.6-141.2-5-17.7 .3-31.7 14.9-31.5 32.5 .3 17.7 14.9 31.7 32.5 31.5 55.3-1 88.2 .3 107.3 1.7 4.5 59-24.4 162.6 73.6 113.9 32-11.7 61.7-22.9 93.8-36.8l0 206.8c.2 41.8 63.8 41.9 64 0l0-220.3c4.3-38.1-31.1-70.4-67.2-54.7-36.9 15.9-64.2 27.4-100 40.3-.2-24.2-.2-48.5-.2-72.9 2-19-11.7-36.7-31.2-37zM65.8 144.2c-17.7-.5-32.4 13.3-33 31-1.5 47.3-.3 224.1 0 270.8-.1 8.7 3.4 17.1 9.7 23.2 26.7 19.6 79 2.5 111.8 8.4l166.1 0c41.9-.2 41.7-63.9 0-64-42.8 .5-183.4-.8-223.9-.2-.4-68.8-1-197.9 .2-236.2 .5-17.7-13.3-32.4-31-33z"],
    "comment": [512, 512, [128489, 61669], "f075", "M302.4 65.5c-119.1-19.8-273.3 80.9-230.2 209.5 7 30.2 40.5 59 37.5 92.2-2.2 16.4-5.6 45.4-9.7 63.7 32.2-12 65.3-32.6 101.8-32.6 72.1 9.3 131.6 1.3 189.6-48 24.6-18.7 47.4-46.8 54.1-71.5 11.8-80.7-45.5-207.5-143-213.3zM145.1 26.7c92.1-39.2 203.3-43.2 278.3 26.5 32 32.2 56.5 67.7 70.8 113.5 10.8 34 25.8 81.5 12.9 129-43.2 124.8-185.1 187.5-310.2 166.7-35.4 9.7-69.8 28-105.2 41-30.8 11.5-66.9-12.4-61.6-49.2 5.6-30.9 12-58.9 15.2-89.8-91.1-133.7-34.1-269.5 99.6-337.6l0 0z"],
    "file-check": [384, 512, [], "f316", "M242.1 5.4c-10.3-.5-140.1-7.4-194-6.6-36.4 .4-56.2 34.6-49.8 67-3.7 125.5-1.5 253.6 5.2 393.6 1.2 28.9 24.1 52 52.7 53.7 19.2 1.1 29.1 1.7 44 2.9 44.2 5.9 90-1.9 134.4 1.3 111 3.7 157.4 17.8 146.9-116.3-1.5-60.6 .7-122.2-2-182.4-4.6-29.8 7.8-59.7-9.2-86.8-10.4-16.4-24.8-35.5-38.2-52.4-24.9-29.6-45.4-69-90-74.1zM62.3 65.2c0-.8 0-1.6-.1-2.4 55.6 .3 160.3 5.7 175.4 6.5 15.4 10.8 30.7 32.3 42.8 48.1 12.9 16.8 22.2 27.9 34.9 47.6-1.6 21.2-.7 38.7 .2 58 2.5 60.7 .4 123.3 1.9 183.7 .4 16.8 .8 32.1-.1 48.3-26.9-.5-52.2 .4-79.6-1.5-18.8-1.6-42.2-1.3-60.9 0-24.6 1.8-45.2 1.2-69.8-1.1-13.8-1.2-23.2-1.8-40-2.7-5-117.4-8.6-229.5-5.8-326.5 .3-16.3 .6-34.9 1-58zM275.5 278.6c29.5-29.7-15.5-74.7-45.2-45.2l-73.6 73.6-12.3-12c-30-29.2-74.6 16.2-44.8 45.7 20.8 18.1 49.2 63.3 79.9 34l96-96z"],
    "video": [576, 512, ["video-camera"], "f03d", "M379 37.2c40.2 1.3 32.1 43.1 34.8 72.2 .7 11.5 1.5 23.8 1.8 36.4 12.2-4.7 17.6-6.8 27.8-10.6 24.3-8.8 42-16.8 68.8-28.2 28.9-12.3 63.2 6.1 66.2 39.2 1.6 8.9 .7 89.4 .9 100.3l0 135.5c.6 22.1-24.3 38.7-44.4 29.5-39.2-17.3-81.7-31.1-120.3-45.3 6.7 57.9-33 113-92.9 113.2-66.9 1.2-130.6 1.4-201.1-1.8-59.6 6-120.7-30.3-120.4-96.3 0-81 4.6-162.6 2.6-243.8-1-56.1 45-101.6 100.4-101.7 95.6-1 221.3-8 275.7 1.5zm36.3 260.6c3.1 1.2 6.2 2.4 9.3 3.6 31.1 12.8 58.3 20.1 90.8 33.1l0-159.2c-18.9 8.2-33.2 14-51.4 20.6-15.9 5.9-25.8 9.9-47.8 18.3 .4 27.9-.2 55.8-.8 83.6zM349.9 112.6c-.3-4.7-.6-9.5-.9-14.4-29.7-4.7-172.3 .5-245.6 1.4-20.4 0-36.9 17-36.5 36.6 2 82.5-2.6 163.1-2.6 244.9 0 17 14.2 31.7 33.4 31.8 76.1 2.6 148.9 4.3 223 2.4 39.2-2.2 28.6-45.7 30.2-73 .2-49.1 2.1-96.9 1.1-145.9-.4-28 .3-55.1-2.1-84z"],
    "calendar-plus": [512, 512, [], "f271", "M321.8 4.1c-.2-9.6-2.2-19.8 .4-29.2 7.5-29.6 52.1-30.7 61.1-1.6 1.3 3.7 1.6 7.4 1.9 11.3 .7 16.6 1.2 42.2 .1 60.1 55.8 8.8 104.8 18.8 100.4 86.7 .4 96.3 18.7 203.1-9.8 297.3-9.2 31.5-37.1 41.7-63.4 46.2-30.3 4.6-100.1 9.2-167.9 9.2-61.2-2.1-119.9 1.9-173.8-23-19.7-10.5-37.8-26.7-37.8-50.8-3.1-50.1-3.2-96.3-5.3-147.8-1.9-56.1-6.9-120.5 13.2-173.6 19.4-30.5 51.2-33.2 84.9-40.7 .7-17 1.6-43.6 1.6-59.3 .2-41.8 63.8-41.9 64 0 0 14.8-.7 35.5-1.2 51.7 42.8-3.2 88.7-3.7 131.4-1.6 .4-8.2 .5-21.9 .3-34.7l0 0zM97.3 121.4l0 0c-16.1 76.5-1.8 173.7-1.9 253.9 .4 8.7 .9 17.6 1.3 26.8 1.9 1.1 3.9 2.2 5.9 3.3 82.8 24.5 246.2 15.5 312.7 2.8 16-46.4 12.7-119.9 10-175.4-2-32.6-1.2-62.6-3.3-94-.2-2.5 .2-19.6-1.4-20.3-95.1-25.2-229.8-23.4-323.4 3.1zm164 17.6c34.6 2.5 30.8 40 27.8 65.3-.4 6.6-.9 13.2-1.3 19.7 36 4.1 75.2-16 85.9 24.7 4.9 49-56.2 38.4-89.5 39.3-2.6 28.6 8.7 77.3-33.1 78.8-42.5-1.7-30.8-51.8-30.9-81L164.7 283c-17.7-.9-31.3-15.9-30.4-33.6 .9-17.7 15.9-31.2 33.6-30.4l55.9 2.8c.5-7.6 1-15.3 1.5-22.8 .3-25.4 2-62 36-60.1l0 .1z"],
    "wheelchair-move": [448, 512, ["wheelchair-alt"], "e2ce", "M335.4 94.2c72.3 6.4 74.4-97.2 .8-94.2-57.8 4.4-54.9 90.3-.8 94.2zM153.9 159.3c11.8-7 58.4-.7 89.9 7.3-1.5 10-6.6 20.8-11.3 31.4-3.5 7.6-6.8 15.4-9.5 22.8-60.1 142.8 15.1 139.8 132.3 130.5 1.5 23.9 1.1 41.8 4.8 73.2l2.8 39.8c3.1 41.7 66.6 37.3 63.9-4.5-1.5-26.6-6.4-71.2-6.7-93.8 4.7-107.5-86.8-72.5-153.4-75 10-52 83.9-147.7 4.4-183.6-8.9-2-28.1-7.7-37.3-8.3-34.8-4.2-79.5-14-114 5.9-27.6 20.3-74.7 57.2-39.7 88.7 33 24.6 51.8-21.5 73.8-34.5zm-11.6 136c41.2-7.2 30.5-70-10.8-63.1-115.2 19.9-169.4 172.6-107.8 253.3 38.9 71 128.5 70.5 191.3 53.3 45.9-12.8 77.9-55.4 97.9-92.2 19.1-37.2-37.2-66.6-56.8-29.6-9.4 19.6-36.8 55.2-57.2 59.8-41.2 11.5-104.8 15.4-123.7-29.7-10.4-15.9-13.5-20.5-13.5-34.5 0-56.6 32.1-109.1 80.6-117.3z"],
    "bold": [384, 512, [], "f032", "M132.3 93.2c62.7-.7 165.1 8 152.2 87.1-28.5 44.3-105.4 40.6-154.2 40.4 .5-43.8 1.3-94 2-127.5zM315.6 241.9c33.3-25.4 41.8-70.3 28.5-109.1-50.6-134.3-202.1-97.5-311.8-102.7-17.7-.1-32.1 14.1-32.3 31.7 .4 37.2 41.4 33.2 68.3 31.9-2.4 121-2.3 214.7-4.4 318.8-25.9-1.4-64.8-1.8-63.9 33.6 .7 17.7 15.5 31.4 33.2 30.8 90.9-2.3 187 13.5 275.5-20.4 91.7-34.8 101.1-173.5 6.9-214.7zM160.6 285c56.9-2.5 178.7-5.4 154.6 82-8.4 16.8-18.8 25.2-32 30.9-41.8 15.9-105.4 18.5-155.3 16.5 .3-43.3 2-85.7 1.8-129.7 10.1 .1 20.3 .3 30.9 .2l0 0z"],
    "clipboard": [448, 512, [128203], "f328", "M193.8 57.5c4.5-33.1 42.1-29 51 2 3.1 11.3 4.6 23.4 5.2 36.5l-60.1 0c.8-13.8 2.1-27.5 3.9-38.5zM303.1 32.4c-28.6-78.7-141.6-84.6-168.4-2-1-.1-52.9 .6-53.9 .6-83.2 4.6-88.7 75.4-86.5 143l0 1.5c-.8 85.3-5.3 182.8 8.1 262.5 1.6 36.1 28.4 68.6 66.9 71.6 86.7 9.3 178.9 6.3 266.1 .3 55 3.5 106.6-13.8 106.2-76.2-.7-18.9-.6-35.3 1-47.3 5.8-92.7 3.3-165.2-.5-267.9-1.7-46.5-39.3-83.6-85.8-84.8l-53.2-1.3zm10.9 64.3c20.6 2.3 62.6-7.6 64.1 24.2 3.8 102.5 6.2 171.9 .7 260.5-3.9 17.9 2 43.3-3.2 61.1-10.9 4.9-24.9 1.6-38.4 3.2-87.3 5.5-171.5 9.8-262.7 0-3.3-.3-7.2-3.2-7.7-8.6-13.6-84.2-9.3-175.1-8.5-260.2 5-25.2-12.6-79.3 23.2-82l44.4-.5c-2.6 27.2-4.4 64.6 31.1 65.5l125.3 0c34.4-.6 33.8-37 31.7-63.3z"],
    "laptop": [576, 512, [128187], "f109", "M451.8 319.3c-1.5 17.6 11.5 33.1 29.1 34.7 49.8 .6 33.4-64.8 36.2-96.9 .2-43.9-.5-83.5-4.2-141.6-3.2-49.4-44.6-84.4-92-84-64.3 .5-134.2 1.6-194-.3-79.3-5.4-161-1.9-165.1 95.5l3.4 193.9c1 41.8 64.4 40.8 64-1.1l-3.4-193.9c-.3-17.2 12.4-29.9 26.7-30.4 86.3-1.1 179.1 2.6 268.9 .3 15.6-.1 26.7 10.8 27.6 24.2 4 60.1 3.9 97.6 4.1 142.5 .2 19.8 .4 37.9-1.2 57.2zM310.4 481.1l0 0c77.5-.4 207.2-1.2 233 .2 17.6 1 32.7-12.5 33.7-30.2 1-17.6-12.5-32.7-30.2-33.7-28-1.6-164.7-.7-241.6-.3-99.6 .5-172.5 .2-273.7-.4-17.4 .8-31.3 15.6-30.5 33.5 .9 19.4 18.1 32.5 37.9 30.6 100.5 .6 171.4 .8 271.3 .3z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M245.5-1c-164.7-22.2-204.3 184.5-57.8 246 90 29.8 188.1-55.5 163-150-15.3-46.6-55.2-87.1-105.2-96l0 0zM160.9 110.7c.1-38.2 42.2-52.8 75.4-48.3 18.9 1.3 49 32.1 53 50.8 14.3 37.7-45 87.4-79.7 71.7-29.2-10.7-48.7-40-48.7-74.2zM126.1 391.5c63-17.1 151.9-21.3 212 3.6 17.2 6 49.6 65.6 46.8 83.6 0 17.7 14.3 32 32 32 56-6.7 25.2-78.5 7.7-110.8-22-47.6-74.2-77.2-122.5-80.7-116.9-18-312.1 0-301.3 159.6 .3 41.8 63.7 41.9 64 0-1.4-46 15.2-73.7 61.2-87.2zM618.7 155.7c-23-30.5-56.9-.2-74.4 19.6-20.9-18.3-41.8-47.6-69-24.3-27.4 27 4.4 54 26.7 72.3-18 18.9-51.7 35.9-31.2 65.9 24.6 32.9 60.7-3 78.8-23.1 18.1 20.1 26.5 46.7 57.5 33.1 36.9-20.7 7.1-60.6-15.1-81.3 18.3-16.7 46.1-35 26.6-62.2z"],
    "joystick": [512, 512, [128377], "f8c5", "M210.1 1.5c-94.2-13.9-173.2 122.3-98.3 193.9 12.4 13.9 30.3 28.4 53.8 28.5-.9 30.6-.6 39.5-1.4 66.1-53.1 4.8-155-27.6-162.3 51.7-1.3 27.2-1.6 36.5-1.2 57.8 .1 20.4 .1 29.9 1.3 55 1.3 30 26 53.4 55.8 53.5 95.4 .2 167.2 1.6 262.2 3.6 29.5 1 85.2 .8 115 .4 37.5 3 78.1-15.4 77.1-57.9-.4-22.5-.8-56.9-.8-77.8-1.2-24.9 8.4-67.5-26.6-73.3-23.8-16.9-58-5.2-86-9.1l.9-14.8c2.2-41.8-61.3-45.4-63.9-3.7l-1 17.4c-35.5-.3-71-.2-106.5-1.2 .3-9.7 .5-27.9 .6-36.3 .2-9.5 .6-25.2 .8-34.7 46.5-6.9 86.2-46.8 80.8-96.2 6.6-63.9-34.1-117.8-100.4-122.9zM174.2 72.7c14.8-18 60.7-1 64.1 7.5 11.7 8.6 12.4 49.2 6.4 62.8-10.2 15.5-39.8 17.1-57.6 17-8.3 .3-14.3 .5-20.2-.3-35.2-24.7-20.8-61 7.3-87zm54 216.8l0 0zM348.9 448c-100.3-2-183.3-3.9-283.3-4.1-1.2-30.5-1.6-61-.1-91.5 44.6 .4 86.5 1.1 129 2.2 84.3 2.2 168.4 2.2 252.9 3.7-.1 27.4 .2 58.9 .6 88.8-23.5 1.6-75.6 .9-99.1 .8z"],
    "battery-three-quarters": [640, 512, ["battery-4"], "f241", "M360.3 69.3c-98.4-5.9-182.6-7.9-281.9-.4-44.7 3.5-75.9 37.7-77.1 81.6-1.3 50.2-1.4 130.3-1.3 188.1 7.3 123 120.3 110.4 209.7 107.9 62.4-1.7 150.2-.8 224.5-.3 120.1-5 109.4-117.8 109.3-203.7 10.1-143.8-50.7-175.1-183.2-173.2zm-6.1 63.6c93.8 5.3 133.6-9.6 125.4 103.9-.3 36.6 .4 62.8-2.9 108.8-1.4 20.5-18.6 36.8-41.9 36.6-74.5-.5-162.8-1.5-226.7 .3-41.3-5.8-140.4 25.4-144-44.2-.2-58-.1-137.2 1.2-186.2 .4-12.1 7-18.8 18.2-19.7 95.6-7 175.9-5.3 270.7 .4zM576 191.6l0 127.7c.2 41.7 63.8 41.8 64 0l0-127.7c-.2-41.7-63.8-41.8-64 0zM266 159.7c-22.1 0-45.8 1.1-68.6 2.2-61.3-3.3-108.7 19.3-101.3 90.7-6.1 52.9 23 99.9 78.3 98.3 76.9-7 203.4 32.8 209.5-77.1 6.6-101.9-21.1-117.5-117.8-114zM165.1 227.2c52.9-2.1 101.7-5.5 154.4-2.2-3 14.4 10.2 60.5-12 62.4-13.3 .2-26.5 .1-37.5-.2-27.9-.7-65.5-.4-98.4-.2-3.8 0-6.6-1.3-8.3-2.8-6.7-11-1.7-28-3.3-38.2-.1-6.4-.2-11.1 .4-17.1 1-.9 2.5-1.6 4.6-1.7z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M257.8 448.8c-12.7-1.8-16.9-22.9-20.8-32.7-14.1-35.4-32.1-69.6-47.1-104.7 7.1-67.1-1.5-142.7 1.3-210.5 15.4-.3 31.4-1.2 46.6-2.1 89.9-8.4 172.6 .8 194 98.8 8.4 21.1 10.3 93-2.1 106.1-22.9 19.6-102.7 4.8-138.7 4.7-19.1-1.9-36.4 15.6-34.3 34.6l0 .2c2.4 30.4 15.8 104.9 1.1 105.6zM138.4 355.5c10.5 27.6 26.4 52.5 37.3 79.8 12.1 27.5 20.3 58.8 57.3 73.2 22 6.4 48.5 8.2 71.9-8.6 27.1-27.9 16.1-87.7 17.7-125.4 54.8 2.1 118.1 13.5 155.6-29.3 34.4-48.2 27.8-109.4 14.3-167.6-29.8-128.2-147-156.2-263.1-142.6-69 0-102.3 0-162.9 1.1-34.3 0-62.5 27.1-63.9 61.4L.6 149c.1 30.5-.6 103.7 1.1 133.1-2.8 81.8 77.1 76.2 136.8 73.5zM66.1 290.9c0-.1-.1-.3-.1-.4-1.5-46.5-1.2-93-1.4-139.6l2-50.7 60.5 0c0 34.9-.2 93.8 .7 127.8 .4 21.6 .9 43.1 .7 64.2-21.1-.1-42-.3-62.5-1.3z"],
    "utensils": [512, 512, [127860, 61685, "cutlery"], "f2e7", "M473.7 .7l0 0-2.2-7.5c24.7-7.6 44.9 15.9 41 39.6-5.1 136.8-5.4 310.1-2.7 444.7 .3 42-63.4 42.4-64 .7l-1.5-126.4-69.3 0c-11.3 0-27.6-4.3-37.6-19.8-55.8-123.6-.2-299.6 134-338.9 0 0 .7 2.5 2.2 7.4zm-26.4 75c-62.9 53.1-76.7 132.9-59.7 212.3l56.1 0-.1-5.4 0-.4c0-53 2.1-144.5 3.7-206.5zM32.5 0c17.7 0 32 14.3 32 32l0 48.7c0 27.9 9.1 60.2 24.8 80.9 21.6 36.7 78.5 17.9 97.3-8 10.4-25.2 6.8-67.3 6.6-96.3-3.1-25.5 0-56.8 31.4-57.3 17.7 0 32 14.3 32 32 3.1 90.4 13.4 179.4-92.6 208.8l-3.4 239.6c-.3 17.7-14.8 31.8-32.4 31.6s-31.8-14.8-31.6-32.4l3.3-236.1C30.9 224.7 .5 142.8 .5 80.7L.5 32c0-17.7 14.3-32 32-32zm97.2 4.3c17.7 .4 31.7 15 31.3 32.7l-1.6 77.9c-.4 17.7-15 31.7-32.6 31.3-17.7-.4-31.7-15-31.3-32.7l1.6-77.9c.4-17.7 15-31.7 32.7-31.3z"],
    "envelope-open": [576, 512, [62135], "f2b6", "M316.9-18c-16.3-16.5-37.8-7.7-53.3 4.8-53.6 35.7-106 70.8-163.9 100.6-17.1 9.6-33.4 22-49.7 30.4-24.1 13.8-24.8 54.1-28.2 73.8-5.9 52-1.5 103.6 2.7 152 2.7 35.5 6.1 69.6 9.4 105.3 .2 11.8 0 21.5 5.2 33.8 8.6 16.3 18.1 18.9 30.5 22.7 42.2 8.1 95.5 3.1 138.9 2.1 92.4-3.1 173.3 5.5 263.2 3.9 3.6 0 4.7-.1 9.2 .2 14.1 .3 26.1 2.4 44.1-10.9 13.1-11 16.9-26.9 18.4-34.5 10.4-94.6 14.3-194.3-2.4-292-5-27.6-11-60.3-43.6-77.5-64.6-32.2-133.7-68.6-180.6-114.8zM225.8 88.6c21.6-14.6 43.4-29 65.4-43.4 53.3 46 121.9 80.5 178 109.3-.2 .1-.4 .3-.5 .4-59.4 46.4-116.2 87.4-177.9 126.9-36.7-28-99-76.1-130-95.2-14.6-9.5-32.7-21.2-50-30.8 16-10.7 29.7-18 46.6-27.2 22.4-12.2 46.6-25.3 68.4-40.2zM84.1 214.2l0 0c13 7.4 27.1 16.5 40.6 25.2 30 18.6 88.2 63.3 127.5 93.4 50.8 39.3 104.2-20.4 146.4-46.7 30.2-21.6 54.1-37.2 85.2-61.8 8.1 72.5 4.2 149.1-2.1 223.2-123.2 1.7-259 6.1-383.6-2.7-6-75.4-18.1-156.3-14-230.7z"],
    "voicemail": [640, 512, [], "f897", "M515.2 153.2c-47.1-7.3-70 24.2-90.5 62.4-12.7 28.5 7.5 64.1 27.8 87.6 3.7 3.7 10.5 10.3 15.5 15.2 55.8-10.7 94.7-23.2 107.9-88.3 6.4-37.8-17.3-72.4-60.6-76.9zM389.5 326.7c-103.3-131.5 65.3-310.1 203.3-209.3 83.1 61.2 47 203.4-35 239.5-87.3 41-194.3 34.2-287.9 36-67.2 .1-133.5 .8-199.7-35-64.7-35.2-90.9-123.6-51.9-189.3 58.5-110.7 245.8-105.8 267.7 28.6 3.9 42.3-4.9 92.7-35.6 131.6 46.7 0 93.7 .5 139.1-2.2zm-235.7-5.5c35.6-11.8 32.3-12.9 53.1-43 13.7-21.5 16.8-45.5 14.9-77.2-.5-9.3-8.2-22.3-25.5-33.9-33.6-23.2-65.5-13.2-91.6 .9-76.9 54-36.6 141.6 49.2 153.2z"],
    "microphone": [448, 512, [], "f130", "M207.7 70.9c-20.8 10.9-12.8 44.6-16 64-1.2 37.2-10.5 91 17.7 117.7 7.2 6.3 23.8 3.2 34.1-1 16.8-4.6 20.7-46.4 18-67.5-3.8-38.2 10.5-139.5-53.8-113.2l0 0zM129.7 95.7c.5-75.5 77.6-111.5 138.3-83.5 61.7 31.5 55.1 109.7 57.4 166.4 8.1 67-20.4 144.6-106.8 141.3-93.8-5-99.4-122.1-90.6-191.7 .7-11.3 1.3-22.2 1.7-32.6zm293.5 86.7c17.6 1.7 30.5 17.4 28.7 35-6.1 112.6-79 213.2-193.5 229.2 .8 26.9 5.8 72.4-34.1 71.1-36.7-3.1-29.2-42.1-29.9-69.3-109.6-20.5-199.7-114.4-193.2-224.7 0-17.7 14.3-32 32-32s32 14.3 32 32c-1.9 66.6 32.3 113.5 85.5 140.9 54 32.4 112 26.3 163.6-6 27.9-25.8 43.6-44.4 53.8-64.4 10.2-20 16.2-44 20-83.1 1.7-17.6 17.4-30.5 35-28.7z"],
    "crown": [512, 512, [128081], "f521", "M282.9 32.4c-8.3-9.5-33.8-11.6-41.9-.7-3.6 3.9 .3-1.9-3.7 2.3-28.8 25.5-60.7 58.6-88.6 83.8-33-15.4-62.3-46.7-90.8-69.5-16-26.3-60.1-18.2-61 14.8 18.8 125.3 56.2 249.8 73 374.9 .5 3.6 .2 1.3 .3 2-3.8 .5 6.7-.9 5.1-.7-.1-.7-5.8 1.3-3.5 6.5 4.2 13.1 17.2 21.6 30.7 21.6 46.1-12.7 100.7-20 154.3-21 52.6-1.9 105.6 6 155.6 17.7 13.9 .5 27.2-9 31.3-22.3 23-109.9 43.5-223.8 61.5-335.9 .8-10.4 7.2-20.4 6.1-30.2-1.3-21.6-29.1-37.8-47.1-25.7-25.4 11.6-62.7 51.3-89.6 68.6-4.8 .7-10.8-9.8-9.1-6.8-25-27.2-53.2-54.8-80.5-77.3l-2.1-2 0 0zM387.3 392.9l0 0c-84.4-17.3-169.9-12.3-258.6 1.6-4.1-29.8-10.8-59.4-17.2-87.5-11.3-49.4-20.7-108.2-33.1-157.6 23.1 12.5 48.6 43.3 74.7 42.4 28.6 3.2 41.1-31 60-46.3 18-18.8 29.1-27.9 48.8-46.3 28.2 24.7 54.1 54.9 81.7 82.6 14.5 14.6 37.6 15.8 53.5 2.9 7.1-5.8 20.5-16.7 34.1-28.3-1.6 9.6-3.1 19.2-4.6 28.8-8.7 53.5-16.3 101.4-27.8 153.3-3.7 16.8-7.9 36.5-11.4 54.4z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M250.7 186.6c12.5-12.5 12.5-32.8 0-45.2l-96-96c-11.6-11.6-30.1-12.5-42.8-2.2-27.8 22.7-62.2 63-88.1 87.5-19.2 13.4-33.2 34.9-15.6 56 36.7 34 67-21 93.9-44.5-.1 12-.3 31.7-.5 55.6-.8 88-2.1 232.5-.9 255.9 .9 17.7 15.9 31.2 33.6 30.3 17.7-.9 31.2-15.9 30.3-33.6-1.1-21.2 .2-156.2 1-244.4 .2-24.2 .4-44.8 .5-58.7 22.4 18.6 51.4 70.1 84.6 39.3zm292.5-53c17.6 1.1 32.8-12.3 34-29.9s-12.3-32.8-29.9-34c-54.2-3.4-90.3-1.2-134.9 1.3-28.2 1.7-56.6 3.3-91.6 3.3-17.7 0-32 14.3-32 32s14.3 32 32 32c85.3 .2 136.8-10.3 222.5-4.8zm-151.3 94c-30.9 3.6-101-20.2-104.8 30.5 3.9 48.6 65.3 27.7 98.5 33.4 36 1.1 72.9 2.2 110.6 .6 17.7-.8 31.4-15.7 30.6-33.3-.7-17.6-15.6-31.4-33.3-30.6-36.5 1.6-68.2 .5-101.7-.5zm35.1 220.3c41.9 .5 42.8-63.1 1-64-62.7-1-45.4 1.8-107.2 .8-17.7-.3-32.2 13.8-32.5 31.5-.3 17.7 13.8 32.2 31.5 32.5 62.7 1 45.5-1.8 107.2-.8z"],
    "sun": [576, 512, [9728], "f185", "M317.1-10.2c-18.8-23.8-55.2-20.6-73.4 10-13.5 15.7-30.9 38.1-48.1 48.4-63.1 3.7-144.6-20.9-120.5 78.6 3.3 18.6 2.2 31.3-.1 47.6-1.7 1.9-3.3 3.8-4.9 5.6-40.6 48.3-116.2 75.5-31.6 134.5 12.6 9.2 21.3 15.6 29.8 25.5 5.1 155 9.6 123.9 148.6 128.6 66.3 80.8 85.3 77.7 151.8-.8 27.9-10.2 52.9-15 75.7-10.1 23.3 5 48.5-11.5 49.6-38.1 .4-10.7 1.4-23.5 2.4-36.7 1.6-18.2 2.3-37.5 3-53 42-42.1 107.6-79.4 28.4-126.9 .2 .1 .2 .1-.1-.1-10.5-9.2-24.9-28.1-33.3-39 4.6-117.9 1.4-112.6-113.8-113.2-16.8-14.3-51.9-45.9-63.5-60.9l0 0zM262 75.6c8-8.2 16-17.3 23.2-25.8 27.1 23 56.3 63.4 86.5 64.9 18.5 0 39.6-.1 59.2 .7l-.6 55.9c1.1 23.5 13.7 30.3 30.3 53.1 8.7 10.4 16.3 19.5 27 28.4-27.4 29.5-54.9 38.8-52.2 75.5-.7 17.1-2.1 42.7-3.9 63.5-33.6-1.2-65.3 8.2-92.1 18.6-20.9 9.6-29.2 32.4-47.4 45.9-11.9-11-29.4-34.4-37.5-40.5-7.5-7.2-17.2-11-27.2-11.1l-91.1-1c-.5-8.2-1.2-17.3-1.8-26.2-1.6-18.1-1.7-29.9-2.8-46.8-1.6-28.2-35.8-53.5-54.9-67.6 17.1-14.5 30.9-28.3 43.6-43.2 27.4-27.1 21.7-66.9 17.5-107.1 20.6-.6 41.6-.6 60-.6 29.7-1.6 45.6-18.8 64.3-36.6l0 0zM365.1 316.3c64.3-90.5-53.6-214.4-141.1-146-41.9 37.1-57.2 103.3-24 150.1 41.9 56.9 125.1 46.6 165.1-4.1zM263.3 220.8c32.2-26 70.6 35.1 50.1 57.7-7.8 15-51.5 23-60.4 6-15-18.9-3.8-48.1 10.3-63.7z"],
    "image": [512, 512, [], "f03e", "M393.4 33.8c33.1 3.1 83.7-13.2 109.4 11.2 12.4 15.5 13.6 34.1 14.1 41.4 5.1 40.3 3.5 78.8 1.4 115.5-1.1 20.1-1.4 40.2-1.7 61-.9 54.5-2 108.7 .2 162.1 3.4 55.4-23.5 51.6-69.7 51.5-137.6-2.4-272.5-4.2-410.2-4.2-16.1-.6-29.4-15.5-29.7-30.1-.1-1-.8-13.3-1.2-21.2-.2-5.2-.4-5.4-.4-7.9 .9-90.1-2.1-177.5-.6-267.5L7.3 61.8c.2-17.3 16-32 33.2-31 118.8 5.3 235.4 4.9 352.9 3zm4.9 63.9c-109.4 1.8-218.1 2.5-328-1.7-1.8 47-2.5 98.4-1.5 145.6-.3 55.8 1.1 111.9 .7 167l5.2 .1c34.1-30.8 64.9-63.3 96.6-96.7 31-35.4 72.3-69.8 101.6-106.5 5.2-7.6 13.5-12.6 22.8-13.7 9.2-1.1 18.4 2 25.2 8.2 42.7 38.4 85.2 75.7 130.8 110.3 .2-15.4 .5-32.5 .8-47.9-.4-54.2 7.7-113.8 1-165.8-18.1 0-36.4 .5-55.3 1.1zM170.1 408.8c61.5 0 124.5-.5 186.1 2.2 33.6 1.5 61.4 2.2 96.1 1.3-.2-6-.4-12-.5-18-7.6-6.5-20.3-17.6-26.6-23.3-25.3-20.3-52.7-40.4-77.2-62.4-15.5-13.4-30.4-25.6-45.5-39.1-6.4 6.7-12.8 12.9-18.7 18.6-21.8 21-41.6 42.3-63.3 65-17.5 18.5-35.4 37.3-53.6 55.7l3.1 0zM153.3 171c5.7 2.7 10.2 6.9 13.3 11.9 38.9 30.7-10.7 81.9-47.2 50.2-29.9-27.3-6.3-79.2 33.9-62.1zm-5.7 70.1l.1 0c-.7 0-1.4 0-2.2-.1 1 .1 1.8 .1 2.1 .1z"],
    "notdef": [448, 512, [], "e1fe", "M382.7 116.4c-9.2 14.4-18.6 29.3-28.1 44.5-1.3 2.1-2.7 4.3-4 6.4-17.8 28.5-36.3 58.2-55.8 87.1-6.3 9.4-12.7 18.7-19.3 28 14.5 20 27.8 37.8 37.3 49 19.6 23.3 34.5 35.9 50.4 49.4 .8 .7 1.6 1.4 2.5 2.1 5.7 4.8 11.5 9.8 17.5 15.3 .4-79.8 0-155.8-.3-226.4-.1-18.9-.2-37.4-.2-55.4zm-38.5 333c-6.7-6.4-13.2-12-19.9-17.7-.9-.7-1.8-1.5-2.6-2.2-16.4-13.9-34.6-29.3-57.8-56.8-8-9.5-18-22.6-28.6-37-26.3 32.2-55.1 61.9-87.1 86.6-5.2 4-14.2 11.2-23.9 18.9 38.6 3.5 81.4 6.9 100.1 6.9 28.6 0 62.5 .5 96 1l.4 0c7.9 .1 15.7 .2 23.5 .3zM236 227.2c1.9-2.8 3.9-5.7 5.8-8.5 18.8-28 36.8-56.8 54.7-85.5 1.3-2.1 2.6-4.2 3.9-6.2 13.2-21.1 26.4-42.1 39.7-62.4-8.4-.4-15.5-.5-19.7-.5-19.1 0-38.7-.5-58.2-1-3.4-.1-6.9-.2-10.3-.3-23-.6-45.8-1-68.3-.6-26.2 .5-51.4 2.2-75.2 6 9.4 11.9 20.3 25.6 28.1 35.4 10.3 13 21.1 25.5 32.3 38.6 1 1.1 1.9 2.3 2.9 3.4 12.1 14.1 24.7 28.9 36.8 44.5 7.4 9.6 17 22.7 27.4 37.2zM64.8 116.1c1.5 64.3 8 198.9 12.2 280.8 12.3-9.8 25.1-20 32.1-25.4 31.5-24.3 60.1-55 87.3-89.7-15.1-21.1-28.8-40.2-38.5-52.7-10.9-14.2-22.5-27.8-34.7-42-1-1.2-2-2.3-3-3.5-11.1-12.9-22.6-26.3-33.7-40.3-6-7.6-14-17.6-21.6-27.3zM447 170.8c.4 95 .9 200.5-.4 311.5-.2 17.5-14.5 31.6-32 31.6-27.8 0-61.2-.5-94.4-1l-.7 0c-33.6-.5-67-1-95.1-1-30.7 0-110.8-7.5-151.8-11.5-31.4-3.1-55.9-28.6-57.5-60.2-3.9-75.2-14.6-287.8-14.6-346.5 0-.6 0-1.2 0-1.9 0-6.6-.1-18.9 2.5-30.4 2.9-13.1 11.4-33.8 35.1-41.9 46.6-16 96.5-20.6 144.4-21.5 24-.5 48 0 71 .6 3.5 .1 7 .2 10.5 .3 19.5 .5 38.2 1 56.4 1 9.6 0 30.7 .5 51.7 2.8 10.5 1.1 21.7 2.7 31.7 5.2 8.4 2 21.9 5.9 31.9 14.7 6.9 6.1 10.8 14.8 10.8 24 0 38.9 .2 80.4 .4 124.2z"],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", "M310.4 82.5l0 0c20.9-18.1 69.1-61.1 94.1-48.9 15.9 8.3 29.3 15.2 32.8 22.5l.1 .1 .1 .1 .1 .2c6 9.7 16.8 29.6 18 41.1-6.1 30.5-35.6 55.5-58 78.8-35.9-31.8-57.5-53.3-91.9-89.8 1.6-1.4 3.1-2.7 4.7-4.1zM420.1 243.3c.2-.2 .4-.3 .5-.5 40.5-41.1 94.8-80.7 99.1-145.1-8.5-97.2-108.1-163.8-187.8-111.2-96.7 64.3-160.6 144.4-243.9 222.3-33.9 32.8-79.4 61.3-89.7 111.4-1.6 16.7 .2 45.7 1 62.6 0 25.4-.7 69.8-1 88.4 3.3 72.6 119.6 26.8 163.4 24.9 23.5-4.7 42-27.1 54.5-40.5 .2-.2 .3-.3 .3-.3 69.9-68.5 136.4-140.6 203.7-211.9zm-67.9-21.6c-66.8 72.5-134.1 143.1-205 212-29.1 5.2-56.7 9.6-84.6 12.3 1.6-38.6-.9-83.7-.8-118.6 13-23.7 46.3-50.6 68.4-70.6 45.7-41.4 82.5-86.6 129-126.1 33.3 35.3 57.4 59.5 92.9 91z"],
    "plane-up": [576, 512, [], "e22d", "M64 339.2c40.2-13.9 73.3-35.6 112.2-52 4.5-1.8 17.3-7 26.6-10.7 25.7-10.2 54.3 7.9 54.6 35.7 .3 31.3-.3 78.3-.5 91.6 1.9 26.6-38 45-51 59.1-5.5 4.1-14.8 26.8-12.9 33.4 31.5-8.7 62.4-22.7 96-23.3 31.8 .7 62.2 15.2 90.2 28 .4-6.9 .5-10.7 .7-14.4l0-1.6c-19.4-26.9-56.2-48.3-59.7-81.5 .3-27 .4-71.7 .4-91.9 0-26.3 25.8-44.7 51-37.4l32.6 9.5c36.4 12.5 73.4 30.4 107.8 49.5-.2-14.1-.4-28-.5-42.3-59.9-40.1-113.4-92.8-172-132.3-21.9-11-19.3-41.2-18.9-61.7-.4-17.1 .6-35-.4-51.3-4.5-34.1-5.2-53.6-37.2-45.1-32.3 14.2-25.4 66.9-26.3 99.8-.2 18.2 2.8 40.3-12 53.8-58.8 56.2-118.8 79.4-178.9 131.9-.8 18.7-1.5 36.1-1.8 53.2zm-5.1 70.5c-27.2 13.6-59.7-6.5-58.9-36.6 .1-30.3 1.5-71.9 2.8-100.3 .5-11.1 5.7-21.5 14.6-28.6 54-48.4 121.5-80.7 175.8-128 .1-4.2 .2-9 .2-12.7-3.1-56.6 2.2-145.1 72.8-163.1 32.6-9.8 69.8-3.4 91 22.3 35 42.7 25.8 99.9 27.2 150.1 49.1 35.4 92.1 73.8 138.7 109.6 17.7 12.6 48.4 28.4 51.2 53.5 1.7 32.8 2.7 68.1 .3 100.9-2.8 28.3-35.4 45.9-61.5 29.9-40.6-24.8-86-48.7-128.8-63.5-.1 16.9-.1 36.1-.3 51.8 20.2 28.7 58.1 48.6 59.7 85.5 .3 10-1.9 37.1-2.8 59.6-4.1 40.1-45.5 44.6-75.2 24.1-19.3-9.5-61-29.1-76.6-28.5-4.9-.6-37.3 6.9-42.1 9.3-44.7 14.5-109.5 42.9-117-18.1-5.8-61.1 12.4-100.1 63.6-134.9 .1-11.3 .3-27.6 .4-44.1-42.7 22.3-90.7 43.8-135 62z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M152.4 19.3c179.3-66.1 369.1 43.1 356.4 242.8 0 72.7-20.7 156-88 197-88.6 88.3-238.8 76.2-328.1-2-152.1-106.5-112.9-371.2 59.6-437.8zM315.7 70.1c-186-47.9-327.4 149.8-215.5 307.7 68.4 78.9 200.3 114.2 279.9 32 52.8-31 63.7-89.6 64.7-148.7 15-77-54.1-176.7-129.1-190.9zM381 259.4c-.9 17.7-15.9 31.2-33.6 30.3-27.8-1.4-81.3-.2-116 0L270.7 329c29.5 29.7-15.5 74.8-45.2 45.3l-88-88c-33.1-39.2 33.7-74.3 58-104.2 27.3-22.7 46.7-63.4 80.9-36.7 29.3 31.7-10.6 56.4-33.8 80.3 34-.4 81.7-1.2 108.2 .2 17.7 .9 31.2 15.9 30.3 33.6z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M340.9 68.1C242.8-67.6 8.3 14.3 .3 175.7-9.6 266.2 39.1 318.9 96.7 355.1l.8 31.6c.4 17.7 15.1 31.6 32.7 31.2 41-1 81.7-.6 122.8 .5 11.8 .4 22.8-5.9 28.7-16.2 8.5-17.4 5.4-30.3 5.9-47.7 108.8-48.8 121.3-198.7 53.3-286.4zM110.3 95.4c50.7-39.2 138.2-47.9 178.4 9.7 46.1 60.8 43.8 161.2-33.1 194-11.6 6.5-26.7 13.1-30.1 27.6-2.7 10.8-1.8 16.8-1.9 27-21-.4-41.9-.5-62.9-.3 .6-17.4-.4-40-19.7-47.2l-.1 0 .1 0C56.6 270.9 31.1 159.4 110.3 95.4zm85.3 416.2c8.1-.2 15-.1 22.7 .1 62.6 11.9 69-70.5 4.4-63.9-15-.5-39.7-.3-51.7 1.4-5.5 .6-8.6 1-19.4 1-41.9 .2-41.9 63.8 0 64 22.5 .1 23.2-1.9 44.1-2.5z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M359.7 19.3c-179.3-66.1-369.1 43.1-356.4 242.8 0 72.7 20.7 156 88 197 88.6 88.3 238.8 76.2 328.1-2 152.1-106.5 112.9-371.2-59.6-437.8zM196.4 70.1c186-47.9 327.4 149.8 215.5 307.7-68.4 78.9-200.3 114.2-279.9 32-52.8-31-63.7-89.6-64.7-148.7-15-77 54.1-176.7 129.1-190.9zM131.1 259.4c.9 17.7 15.9 31.2 33.6 30.3 27.8-1.4 81.3-.2 116 0L241.4 329c-29.5 29.7 15.5 74.8 45.2 45.3l88-88c33.1-39.2-33.7-74.3-58-104.2-27.3-22.7-46.7-63.4-80.9-36.7-29.3 31.7 10.6 56.4 33.8 80.3-35-.3-82.2-1.3-110 .3-16.8 1.8-29.4 16.4-28.6 33.4l0 0z"],
    "bed-empty": [640, 512, [128719], "f8f9", "M67.6 62.7c-.2-41.7-63.8-42-64 0 0 127.7-3.1 256-3.1 383.9 0 17.7 14.3 32 32 32 34.8-.4 33.2-38 32.1-63.6 137.6 7.7 276.9 5.8 414.6 8 28.1 .8 53.8 .5 82.2 .5-4.1 24.1 1.1 55.1 31.1 55.2 47.7-4 27.6-61.7 37.8-98.8 7.4-71.6 10.1-155.9-21.9-203.9-62.4-57.8-176-42.9-218.1-43.2-104.7-.9-217-.3-322.9 .2 .2-23.4 .3-46.9 .3-70.3zM197 355.9c-44.3-1-88.4-2.5-132-4.9 .5-51.3 1.2-102.7 1.8-154 38.2-.2 88.9-.5 127.3-.6-.2 56 3.4 111.3 2.9 159.5zm64 1.1l0 0 0-3.3c.4-46.3-3.1-100.6-3-157.2 35.5 .1 93.7-.2 128.8 .4 35.9 .5 72.2 1 111-2 90.5-6.9 79.5 99.7 70.3 164.8-28.9 0-57.8 .4-85.9-.4-73.3-1.4-147.9-1-221.4-2.1z"],
    "code": [576, 512, [], "f121", "M353.2 34.2c2.7-41.7-60.7-46.3-63.9-4.5-6.7 114.9-31.3 224.1-48 336.6-6.2 30.9-12.2 77.8-15.9 109.7-4.9 41.5 58.2 49.4 63.6 7.8 16.7-148.7 55.3-300.9 64.2-449.7zM173.3 114.7l0 0c-13-12-33.2-11.1-45.2 1.9-.8 .9-15.9 17.2-16.3 17.7-29.5 35.6-75.3 60.9-106.7 100-10.3 12.7-9.4 31.2 2.2 42.8 37.3 38 83.4 86.3 122.4 120.9 30.8 28.4 74.1-18.1 43.7-46.8-29.9-26.6-70.7-67.4-98.9-97.2 28.1-25.7 59.8-46.6 86.2-78.4l14.4-15.6c12-13 11.1-33.2-1.9-45.2zm237.4 6.7c-12.5 12.5-12.5 32.7 0 45.2l89 89c-18.6 18-74.8 71.6-90.2 90.9-27.9 31.3 19.5 73.8 47.6 42.8 14.1-18.3 92.5-92.7 110.5-110.4 6.2-6 9.7-14.1 9.7-22.7s-3.3-16.8-9.4-22.9l-112-112c-12.5-12.5-32.8-12.5-45.2 0z"],
    "sparkles": [576, 512, [10024], "f890", "M99.3 169.2c37.2-.6 32.9-42.3 31.3-68.7 27.6-.4 67.9 6.7 69.6-32.2-2-39.9-44-31.3-72.1-31.8-.7-26.7 4.8-68.2-32.7-68.9-37.7 .6-32.7 43.2-31.3 69.8-11.4 0-22.7 1.5-34.1 2.3-17.6 1.2-30.9 16.5-29.7 34.2s16.6 30.9 34.2 29.7l31-2.2 1.1 0c.5 26.5-4.4 67.3 32.7 67.9zM319.7 25.4c-5.5-33-55.8-34-62.5-1.2-14.5 61.5-28 101.4-62.7 148.6l-64.4 38c-7.9 3.2-16.1 6.5-24.4 9.9-18 7.4-36.4 14.9-52.5 20.9-27.9 9.3-27.2 52 1 60.4 37 12.2 99.2 27.6 139.7 37.2l49.2 105.6 9.8 32.2c7.4 27.9 49.3 30.4 59.9 3.5 21.4-49.1 46.8-97.2 69.2-146.5 7.1-2.7 13.8-5.3 20.3-7.8 30.9-12.8 65.5-22.9 98.9-31.3 27.7-6.4 32.1-47.2 6.4-59.4-8.7-4.4-17.4-9-26.3-13.6l0 0c-32.6-17-66.5-34.7-101.3-49.9L337.3 98.7c-5.6-16.7-13.6-53-17.6-73.2l0-.1 0 0zM286.2 385.9l-40.9-87.8c-4.2-8.9-12.2-15.5-21.8-17.7l-.3 0-.9-.2c-18.7-4.3-36.5-8.7-59.4-14.4l69.6-41.1c26-23.3 41.7-57.9 54.9-84.4L330 213.2c18.9 22.6 52.9 26.5 77.5 42.5-10.9 3.9-21.5 8-31.8 12l0 0c-16.5 7.8-38.6 9.3-46.6 27.8-13.3 30-28.2 60.2-42.8 90.3zm261.2 102c41.9-.2 41.8-63.8 0-64l-33.1 0c-.5-29.1 4.6-59.5-29.6-63.9-36-1.9-37 36.5-34.4 63.9l-30.9 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l31.3 0c-1.8 28.4-3.6 62.6 31.5 64 35.3-1.5 32.7-35.4 32.5-64l32.6 0z"],
    "angle-right": [320, 512, [8250], "f105", "M69.8 92.4c-13.5-11.4-15.3-31.6-3.9-45.1 11.4-13.5 31.5-15.3 45.1-3.9 46.8 39.3 92.3 81.9 134.6 126 18.3 19.1 45.3 47.1 65.5 67.9 26.4 29.6-6.8 51.8-29 68.8-6.3 5.7-12.7 11.5-19.2 17.5-33.1 31.1-68.1 57.4-99.1 92.4-11.3 12.1-25.3 26.9-37.7 37.4-6.7 5.8-12.9 11.5-17.7 16.7-28.4 30.7-75.3-12.3-47.2-43.3 18.7-19.3 36.6-32.8 53.7-52.4 30.5-34.7 68.9-64.9 103.3-96.7 7.4-6.8 14.9-13.8 22.8-20.8-55.9-58.8-109.4-113.2-171.3-164.5l0 0z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M101.8 457.2c110.2 87 292.7 60.5 360.6-71.7 30.8-65.3 53.9-125.7 38.9-204.2-39.6-184-282-238.5-417.3-125.6-128.4 108.8-115.3 296.9 17.8 401.5zM295 437.7c-185.4 48.8-324.9-206.3-168.8-333.9 95-81.8 287.3-41.5 312.4 89.4 10.9 57.5-4.3 102-34 164.9-19.8 42-58.5 66.2-109.5 79.5zM207.8 183.4c-10.4-31.2-56.5-27-72.8-2.5-9.5 12.7-7.8 35.4 2.8 47 33.1 38.3 90.8 .7 70.3-43.7-.1-.2-.1-.3-.3-.8zm131.9-17.2c-60.6-6.2-66 80-8.2 83.3 56-1.5 67.1-77.3 8.2-83.3zm-6.9 63.6l0 0zM248.5 378.3c22.7-.3 41.8-.6 61.2-.7 17.7 0 32-14.3 32-32-7.1-19.6-18.2-31.6-29.9-31.9-.7-.1-1.2-.1-1.3-.1-19.7 0-37.7 .4-60.7 .7-29.3 .4-59.2 .8-65.4 .8-14.2-1.2-32.4 12.7-32.4 30.2 4.4 48.9 46.6 30.2 96.7 33z"],
    "map": [576, 512, [128506, 62072], "f279", "M129.3 119.5c6.6-3.7 17.8-9.9 28.7-15.8 .4 95 6.9 185.9 1.3 274.9-29.5 13.9-68.3 29.9-98 41.8 0-30.3 .2-190.4-.2-217.3-.1-13.2-.2-26.3-.2-39.5 .1-3.9 .2-10 .3-14 19.3-7.5 49.1-19.6 67.9-30.2zM239.8 386c-4.4-1.6-10.4-4.1-16.4-6.7 3.5-57.8 2-115.4 .4-178.4-.8-31.2-1.6-63.7-1.9-98.3 40.4 9.1 94.2 21.9 132.4 33.5 1.4 18.7 1.2 37.5 1 57.7 .1 62.7-3.4 163.6-4.9 237.3-24.6-9.5-46.2-15.6-70.6-27.9-12.3-5.7-26-12-40.1-17.2zm159 120.6c32.5-15.1 62.9-44.4 99-60 27.2-16.4 76.8-31.5 76.1-71.2l0-291.1c0-31.2-29.9-55.2-61.2-45.8-34.8 11.2-82.1 32.8-116.3 43.5-61.4-20.3-183-47.3-211-52.9-30.6-6-60 22.6-87.6 34.7-17.5 9.9-51 23.1-68.9 29.9-18.2 6.9-30.7 24.1-31.2 43.9-1.3 39.5-.1 67.8-.3 105.3l0 201.3c0 33.7 33.9 57 65.4 44.5 30.4-12 87.6-35 127.7-54.1 21.6 9.7 40.8 16 62.5 26.6 31 15.6 79.2 29.5 109 44.2 11 6.2 25.8 8.6 36.9 1.1l.1 0zm15.9-86.1c.5-22.2 1.2-47 1.8-71.9 2-85.8 4.1-133.2 2.3-206.7 21.5-7.6 65.6-23.5 91-34.7l0 259.4c-12.7 8.1-26.2 15.2-41.3 23-18 9.5-35.5 18.5-53.9 30.8z"],
    "user-plus": [640, 512, [], "f234", "M203.5 1.7c164.7-22.2 204.3 184.5 57.8 246-90 29.8-188.1-55.5-163-150 15.3-46.6 55.2-87.1 105.2-96l0 0zm84.6 111.7c-.1-38.2-42.2-52.8-75.4-48.3-18.9 1.3-49 32.1-53 50.8-14.3 37.7 45 87.4 79.7 71.7 29.2-10.7 48.7-40 48.7-74.2zm34.8 280.8c-63-17.1-151.9-21.3-212 3.6-17.2 6-49.6 65.6-46.8 83.6 0 17.7-14.3 32-32 32-56-6.7-25.2-78.5-7.7-110.8 22-47.6 74.2-77.2 122.5-80.7 116.9-18 312.1 0 301.3 159.6-.3 41.8-63.7 41.9-64 0 1.4-46-15.2-73.7-61.2-87.2zM512 192.9c-1.5-24.7-2.7-64.2 32.9-63.6 35.7 1.6 31.4 38.9 31.1 63.8 24.6-.7 63.9-3.4 64.1 32.3-.7 35.3-37.9 33-62.6 31.8 .5 24.9 .7 66.4-35.8 64.1-35.2-3.3-29.5-39.7-28.2-64.4-25 .8-64 5.5-65.4-30.9-.4-35.8 39.3-33.8 63.9-33.1z"],
    "thumbtack": [448, 512, [128204, 128392, "thumb-tack"], "f08d", "M171-2.9c64.5-.1 130.4-.2 196.1 5 17.6 1.4 30.8 16.8 29.4 34.4-1.5 21.6-22.7 33-42.7 28.8-.3 23.4 .2 52.8 2.7 72.5 2.2 3.3 5.4 7.1 8.3 10.5 5.2 6.2 8.4 10.5 15 17.1 6.7 7.1 13.3 13.7 20.1 23.8 39.7 54.6 82.2 189.9-17.8 195.9-8.3-.1-125.6 0-130.6 0 0 4.8-.1 9.6-.1 14.4l2.8 85c.6 17.7-13.3 32.4-30.9 33-17.7 .6-32.4-13.3-33-30.9l-2.8-85.5c0-5.3 0-10.7 .1-16-58.6-4.8-171 24.9-174.1-64.9 .1-.1 .2-25.1 .2-25.2 1.8-60.7 33-102.4 70.7-139.2 5.7-5.5 10.5-10.1 14.9-15 .2-24.8 .8-54.8 1.2-79.9-21.5 2.8-45.3-8.2-44.7-32.6 5.1-52.1 79.3-24.9 115.2-31.2zm81.3 324l127.6 0c-3.8-38.8-16.5-83.9-45.6-110.6-5.6-5.6-12.1-13.1-18.1-20.5-33.5-31.4-24.9-85.5-26.4-127.8-41.5-1.2-83.3-1.1-125.3-1-4 52.3 13.1 105.6-36.2 141.2-37.1 33.2-55.2 72.9-50.9 118.4 37.4 .4 75.6 .4 110.8 .4-.8-12.8 3.3-60.3 4-73.7 3.1-41.8 66.6-37.3 63.8 4.4l-3.8 54.8 0 14.4z"],
    "money-bill-wave": [576, 512, [], "f53a", "M510.6 65.8c-3.7 41-4.4 82.6-5.3 124.2-2.9 63.3-.3 112.6 4.9 188.4-117.4-22-225 53.5-337.1 56.7-42.3 0-76.6-2.9-114.1-12.7-1.6-27.9-3.7-54.5-1.7-83.4 1.5-25.9 1-55.1 .4-80.5-1.2-39.7-.2-60.4 .3-104.5 .1-15 .3-31.9 .5-46.8 154.1 60.7 292.3-61 452.2-41.4zM43.2 33.9c-66-11.8-45.2 81.3-49.4 121.5-2.3 65.2 1.7 116.6-.5 179.6-1.7 37.8-1 76.6 4.9 115.3 3.1 12.4 12.1 24.4 24.6 28.3 52.6 16.4 97.5 20.5 150.3 20.5 104.8 2 190.3-61.3 292.3-59.5 19-.2 53.1 3.5 72.1 7.7 20.4 4.8 40.7-12.3 39-33.3-4.4-72.2-11.2-148.7-7.3-220.9-.1-51.5 4.5-102.5 6.9-154.8 1.7-17.6-11.4-33.3-29-34.9-87.7-4.5-176.9-2.8-260.9 30.2-50.8 17.5-123.9 35.8-179.9 22.3-8.5-2.6-53.6-18.6-63.2-22.1l0 0zM201.5 217.8c-44.7 99.5 72.3 176.5 151 109.3 43.2-38.7 41.1-108 1.2-146.2-49.8-40-128.2-23.3-152.2 36.9zm108.3 61.6c-13.8 12.7-45.2 12.1-52.3-7.7-5-8.4 3.7-46.5 22.6-46.8 6.9-1.6 25-1.3 29.3 2.2 14.7 14 14 40 .4 52.3z"],
    "phone-hangup": [576, 512, [], "e225", "M260.2 65.5c158.1-14.2 301 65.2 316 246.9-1.4 26-6 67.5-46.3 69.8-38.5 0-77.2 2-116.2 2-36.4 .1-40.8-54.2-39.9-76.1-1.4-16.9 6-34.9-5.1-47.6-38.1-26.5-109.3-20-151.6 6-.2 51.3 5.3 124.7-71.7 111.4-35.3-2.5-68.5 1.1-104.2 1-11.4 .8-26.8-7.9-32-17.3-15.5-27.2-7.4-54.5-3.6-80.6 16.1-122 130.3-214.9 254.7-215.3zM487.6 230.7c-50-114.8-223.6-125.1-331.1-73.1-47.8 28.3-88.1 94.5-91.5 156.8 28.4-1 59.2-2.5 87.6-.3 1.2-14.7-1.2-33.4 .3-49.6-2.7-37.3 46.4-68.4 77-73.7 66-16.3 181.8-26.5 206.8 67.4 3.5 22.5 .3 41.6 1.2 61.8 24.5-.4 49-1.4 73.8-1.7 2.3-27.1-10.2-56.8-24.2-87.6zM150.8 322.8s0-.1 .1-.1c0 .1-.1 .1-.1 .1z"],
    "circle-plus": [576, 512, ["plus-circle"], "f055", "M236.9 6C435.9-27.7 623.4 167.9 530.7 363.6 453 532.8 191.4 569.9 80.4 411.9-24.6 266.1 50.6 34.8 236.9 6zm34 60.4c-227.3 10.8-234.5 367.2-2 381.1 67.1 5.2 106.5-9.1 158.1-53.1 144.5-128.1 26.1-334.9-156.1-328zM289.3 136c45.4 5.7 24.8 60.4 25.7 91 19.7-.6 39.8-1.4 59.9-2.2 44.9-.4 43.2 66.1-1.6 64.1-20 .8-40.1 1.6-60.4 2.2-.9 28.7 11.3 79.3-31.4 80.8-42-1.6-30.7-51-32.6-80-29.8-2.1-86.4 7.8-84.6-37.3 6-43.4 56.4-24.3 86.5-26.7 5.7-31.7-8.9-92.1 38.5-92z"],
    "folder": [576, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M232.4 87.3L195 88.5c-40.9 0-66.6-.3-105.1-.3 0 .3 .8 79.4 .8 79.7 0 83.4-2.9 166.6-1 249.6 62.2 .8 106.1 1.4 162.2-.3l.2 0c74.3-2.7 150.7 1 224.8-.3 0 0 .1 0 .1-.1l0-31.4c-3-47.4-.8-177.7-.4-229-53.2 1.7-92.1 4.5-146.6 2.6-46.7-1-66-51.6-97.7-71.7zm-1.6-64c44.3 .1 66.1 38.8 100.7 71.7 11.6 .3 23 .5 34.2 .7l.9 0c58.5 4 171.1-31.4 174 60.9-.4 45.3-2.4 186.1 .3 224 .4 .8 0 34.5 .2 36.2 0 35.6-29 64.1-64.2 64.1-73.6 1.2-149.5-2.4-223.4 .3l-.2 0c-241.7 2.2-233 29.2-227.4-221.6 .4-31 .8-61.8 .8-91.6l-.8-79.2c4.3-89 105.8-60.1 167.6-64.3l37.3-1.2z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M207 9.1c13.4-8.7 31.2-6.2 41.7 6 29.8 34.6 89.3 89.3 126.4 126.3 29.5 29.7-15.6 74.8-45.2 45.2-18-18-47.4-45.7-73.3-71.2 .2 70.5 .5 140.9 .5 211.5 0 17.7-14.3 32-32 32s-32-14.3-32-32c-.1-92.4-.5-166.1-.5-221-24.1 25.2-49.2 56-73.2 80.5-12.4 12.6-32.6 12.8-45.2 .4-29.6-32.5 16.5-58.9 34.9-84 29.2-33 60.4-69 98.1-93.7l-.1 0zM448.4 339.9c6.8 121.9-18 183.8-148.4 177.4-94-9.2-292.3 37.2-299.5-103.5l3-65.3c.8-17.7 15.8-31.3 33.4-30.5 17.7 .8 31.3 15.8 30.5 33.4l-2.9 64.5c.2 12.1 4.7 17.5 11.7 21.9 27.3 14.8 74.1 13.3 106.6 15.2 58.2-3 134.8 9.7 187.7-8.8 4.7-3.4 12.7-12.8 14-56.7l0-47.5c.2-41.8 63.8-41.9 64 0z"],
    "cloud": [576, 512, [9729], "f0c2", "M382.4 199.1c-11.6-61.7-52.5-108.7-106.5-107.7-44.8 1.1-89.6 32.1-99.5 75.9 33.8 9.7 98.7 18.9 82.1 65.5-7.5 16-26.5 22.9-42.6 15.5-32.6-15.3-58.7-23.4-86-18-55.1 6.4-94.4 112.3-50.5 148.1 72.8 57.4 190.6 33.3 280.4 34 50.7-1.6 102.5-2.5 129.1-34.6 43.7-43.3 15.7-121.4-38.7-141.3-25.9-14-60.5-4.5-67.8-37.4zM110.8 169.1c9.2-80.7 87.4-141.2 163.8-141.6 89.7-1.7 145.2 68 165.5 138.3 114 21.1 181.2 164.9 95.9 255.3-46.1 50.5-107.5 52.8-155.6 54.6-115.5-1.2-240.2 30.9-342.7-48.7-84.9-78.1-30.2-230.8 73-258z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M185.4 4.8C263.9-10.1 324.2 13 389.6 43.7 521.9 111.6 548.3 294.2 461.3 404.4 356.6 537.4 168.6 550.6 59.8 422.2-53.1 286.9 1.3 44.4 185.4 4.8zm176.9 96.8c-134.3-78-284.4-28.9-295.7 134.3-18.5 153.2 148.6 267.1 278 185.7 77.6-45.2 121.3-125.4 97.3-210.5-13.3-51.1-37.5-89.7-79.5-109.5z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M292.6 5.5c185 25.6 280.1 256.5 174.6 407.8-60.3 94.2-189.1 110.3-287.6 85.7-71.4-12.9-118.2-61.6-149.4-116.6-107.9-172.3 70.5-416.6 262.5-377zm-11.4 63c-91.6-18.8-171.3 51.6-204.4 123.5-44 94.9 15.7 223.6 114.1 244.1 149.9 40.6 282.2-45.7 250.9-206.3-15-86.1-74.7-147.4-160.6-161.3zm8.4 274.3c14.4 34-33.7 62.1-55.7 31.2-25.9-29.8 15.4-72.9 46.4-45.3 5 5 7.2 8.7 9.3 14.1zm.4 11.3c0-.5 0-.9 0-1.1 0 .4 0 .7 0 1.1zm.5-193.8c-4.4 36.2 24.4 120.6-34.2 121-17.6-1.9-30.2-17.7-28.4-35.3 2.6-24.2-1.5-59.7-1.4-85.7 .2-41.9 63.8-41.8 64 0z"],
    "backward": [576, 512, [9194], "f04a", "M238.4 62.9c32.1-16.8 68.9 7.8 68.1 42.5-.9 40.6-1.1 81.1-1 121.6 40.3-36.3 69.4-52.8 106.4-90.2 24.6-23.6 50.2-48.9 82.6-65.9 32.1-16.8 68.9 7.8 68.1 42.5-1.4 59.6-1.1 119.2-.8 178.9 .1 32.7 .6 64.8-.1 97.7 6.8 43.8-40.2 82-79.8 52-30.5-22.4-61.8-42.9-92.5-65.7-29.5-21.6-57.7-39.1-83.5-65.2 .2 28 .3 56.2-.4 84.4-.5 38.8-46.4 64.6-79.6 38.5-30.5-22.4-61.8-42.9-92.5-65.7-39.8-33.5-147.5-82.8-90.3-143.7 16.3-14.2 47-40.8 60.7-50.3 45.1-32 82.2-84.1 134.6-111.4zm3.3 222.8c-.2-49.2-.5-98.9 .2-148.5-48.4 44.3-88.4 80.8-143.3 124.1 22.9 21.3 48.3 38.1 73.8 56.4 23.1 16.7 45.9 33.1 69.5 49.1 .2-26.9-.1-53.8-.2-81.1zm256 8c-.2-49.2-.5-98.9 .2-148.5-48.4 44.3-88.4 80.8-143.3 124.1 22.9 21.3 48.3 38.1 73.8 56.4 23.1 16.7 45.9 33.1 69.5 49.1 .2-26.9-.1-53.8-.2-81.1z"],
    "link": [640, 512, [128279, "chain"], "f0c1", "M337.4 102.7c64.3-18.8 164.3-24 208.1 25 23.2 31.1 29.6 88.4 11.2 118.3-7.1 12.7-18.7 24.9-38 39.8-33.1 25.6 5.7 76.1 39 50.8 129.2-87.2 79.6-291.7-72.4-306.3-100.2-17.7-225.1 7.1-272.3 100.4-48.8 70.4-10.4 179.5 64.8 206.5 37.9 17.9 65.2-39.4 27.6-57.7-92.9-38.7-39.4-156.2 32-176.7zM130 233.3c38.5-16.4 13.6-75.1-25-58.9-69.7 28.5-109.9 110-92.4 188.2 11.7 47.1 52.5 71.4 87.8 91.8 199.3 119.3 492.7-74.4 258.6-265.5-30.2-37.7-84 6.1-50 41.2 190.4 142.7-46.1 248.6-176.4 169-21.6-12.7-52-29-57.8-51.5-9.8-39.4 10-96.7 55.1-114.3z"],
    "backward-step": [448, 512, ["step-backward"], "f048", "M362.5 48.4c31.9-18.2 70 6.1 69.2 41.4-1.5 65.7-1.2 131.4-.9 197.2 .1 35.6 .6 70.4-.1 106.3 8 45.7-40.6 86.5-81.2 53.4-30.3-24.3-61.6-46.6-92.2-71.4-184.1-135.1-97.9-129 22.6-255.1 24.4-25.5 50.1-53.2 82.5-71.9zm4.3 239.7c-.3-54.4-.5-109.3 .2-164.2-12.6 11-27.2 26.1-40.2 40-34.2 38.5-64.3 58.1-105.2 97.5 43.4 44.5 95.6 80.7 145.4 117.6 .3-30.2-.1-60.4-.2-90.9l0 0zM32.4 88.8c-.9-41.7 62.7-43.6 64-1.7 2.8 107.7 3.1 219.6 3.6 328 0 41.8-63.6 42.2-64 .3l-.2-37.3 0 0c-.4-96.2-.9-194.8-3.4-289.4z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M328.1 2c-118-26.1-250.1 18.7-302.3 131.6-51.5 107.6-32.7 248.1 67.1 318.3 89.3 78.2 239.5 90.3 328.1 2 67.2-41 88-124.3 88-197 12.5-113.4-69-229-180.9-254.8zm-156.2 73c71.4-22.1 135.9-26.2 200.8 16.4 43.8 27.3 84.3 113.1 72.2 164.3-2.8 44-5 98.3-38.5 126.9-90.4-45.3-199.2-36.1-286.7 8.1-100.3-85.6-64.3-263.6 52.1-315.7zM182 433.3c52-17 115.6-24.5 166.3-5.2 .4 .2 .7 .3 1.1 .5-49.8 32.5-114.6 28.5-167.4 4.7zM317.1 140.9c-15.1-12-41.8-27.5-73.8-19.2-56.4 9.6-102.3 60.7-83.2 122.5 7.3 55.9 60.8 81.6 110.7 76.9 91.4-4.3 122.6-127 46.3-180.1zm-39.9 50.1c8.5 6.8 14.8 15.2 16.3 17.3 9.7 11.8-5.3 50.2-21.2 48.8-12.6 0-31.9 .4-39.6-5.5-10.1-10.9-5.8-6.9-10.5-22.9-6.8-32.4 6.3-35.6 36.4-44.9 3.6-1 8.4-.7 18.5 7.2z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M308.4 62.4c-3.7 1-9.4 4.4-12.6 6.7-6 18.1-5.3 41.9-7.4 60.9 2 23.3 1.1 43.6 3.3 67.5 1.4 21.6 2.8 43.3 2 66.7-1.6 41.8-65.2 39.6-64-2.2 1.2-37.1-4.3-75.1-4.3-113.6-.2-12-4.1-46.9-19.9-39.1-11.3 15.5-10.4 42.9-10.9 64.3l1.3 120.2c.3 41.8-63.4 42.6-64 .7 0-.4-1.3-120.4-1.3-120.7-4.6-59.7 21.3-151.9 104.4-125.4 24.4-67.5 136.9-67.9 154.8 5.5 11.5-1 24.7-.1 39.6 4.3 37.3 11.6 49.3 47.6 56.6 76.3 8.5 34.8 14.5 78.4 16 121.5 18.3 167.5-102.2 294.1-266.8 269.9-159.1-24.6-192-136.7-201.2-275.1-3.9-41.7 59.5-47.8 63.7-6.2 16.8 126.6 10.4 189 148.9 218.4 72.6 14.5 161.5-33.2 182-101.4 16.1-66.7 14.3-179.6-17.5-242-6.1-1.8-10.9-2.1-14.4-2-.4 22.7-3.8 49.5-4.2 70.3l2.6 79.9c.6 17.7-13.3 32.4-30.9 33-17.7 .5-32.4-13.3-33-31l-2.6-80.4c-.1-11.3 1-24.9 2.1-38.3 1.5-26.1 6.6-67.6-6-86.2l-.1-.1c-.7-.8-3.5-4-16.2-2.4l.1 0z"],
    "thumbs-up": [512, 512, [128077, 61575], "f164", "M257.8 66.2c-12.7 1.5-17 23-20.8 32.6-14.1 35.5-32.1 69.7-47.1 104.7 7.1 67.1-1.5 142.7 1.3 210.5 15.4 .3 31.4 1.2 46.6 2.1 89.9 8.3 172.6-.9 194-98.8 8.4-21 10.3-93-2.1-106.1-31.2-27.1-101.6-4.7-138.7-4.7-19.1 1.9-36.4-15.6-34.3-34.6 0-35.4 4.7-70.3 1.1-105.8zM138.4 159.4c6.9-18.1 13.3-31.2 21.4-46.6 4.9-9.3 9.7-18.6 13.3-27.1 14.4-31.7 24.2-65.4 59.8-79.4 22-6.4 48.5-8.1 71.9 8.6 27.1 28 16.1 87.7 17.7 125.4 54.8-2.1 118.1-13.6 155.6 29.4 34.4 48.2 27.8 109.4 14.3 167.6-29.7 128.2-147 156.3-263.1 142.6-69 .2-101-1.1-162.9-1.1-34.3 0-62.5-27.1-63.9-61.4L.6 366c.1-30.5-.6-103.7 1.1-133.1-2.7-81.8 77.1-76.2 136.8-73.5zM66.1 224c0 .1-.1 .3-.1 .4-.1 3.9-.3 7.8-.4 11.6-1.6 27.6-.8 99.5-1 128l2 50.7 60.5 0c0-34.8-.2-93.8 .7-127.8 .4-21.6 .9-43.1 .7-64.2-21.1 .1-42 .3-62.5 1.3z"],
    "building": [448, 512, [127970, 61687], "f1ad", "M215.2 57.9c47.5 .3 95.5-.1 143.7-4.7l27.1 0c1.7 46.9 .2 94.8-1.4 142.5-3 64.5-2 191.9-2.1 258.2l-310.1 0-8-118c.4-50.8-1.8-182.9 3-231.6 .9-14.5 1.9-29.5 2.6-45.3 0-.4 .2-.7 .3-.9 49.1-1.6 96.4-.5 144.9-.2zM386.5-10.9C280.8-5 175.4-7.2 67.9-6-19.7 1.9 8.7 113.4 .4 174.3 .5 177.9 .3 335.6 .5 339.1l8.1 119c2.3 33.6 30.2 59.7 63.8 59.7l310.1 0c35.3 0 64-28.6 64-64-.4-65.9-.5-191.3 2.1-255.7-6.1-64.9 36.4-203.6-62.1-209zM145.4 223.7c26 17.9 61.7-9.7 49.6-40.1-4.7-31.6-51.8-35.9-62-5.1-9.7 15.6-3.8 36.4 12.4 45.2zm168.1-64.3c-26.5-9.7-54.4 19.9-40.5 46.3 1.1 2.2 1.9 3.6 3 5.2 3.8 8.3 11.2 14.8 20.7 17.4 17.7 5.9 40-9.3 40.5-28.4 5.4-17.6-5.8-36.1-23.7-40.5zM339 318.1c2.3-31.5-39.1-48.6-59.5-22.8-8 6.7-12.6 17.5-11.1 28.5 1.1 17 20.7 31.8 37.7 27.7 18.4 .6 33.4-14.9 33-33.4zm-140 4.7c5.7-30-30.8-53.5-54.9-31.8-1.9 1.6-2.9 2.8-4.3 4.3-25 19.9-5.2 62.8 26.6 56.3 16.6 .4 30.9-12 32.7-28.7z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M15.6 363.6c-66.1-179.3 43.1-369.1 242.8-356.4 72.7-.1 156 20.8 197 88 88.3 88.7 76.3 238.8-2 328.1-106.5 152.1-371.2 112.9-437.8-59.6zM66.4 200.3c-47.9 186 149.8 327.4 307.7 215.5 78.9-68.4 114.2-200.3 32-279.9-30.9-52.8-89.7-63.7-148.7-64.7-77-15-176.7 54.1-190.9 129.1zM255.7 135c17.7 .9 31.2 15.9 30.3 33.6-1.4 27.8-.2 81.3 0 116l39.3-39.3c29.7-29.4 74.8 15.5 45.3 45.2l-88 88c-39.2 33.1-74.3-33.7-104.2-58-22.7-27.3-63.4-46.7-36.8-80.9 31.8-29.3 56.3 10.6 80.3 33.8-.4-34-1.2-81.7 .2-108.2 .9-17.7 15.9-31.2 33.6-30.3z"],
    "gear": [512, 512, [9881, "cog"], "f013", "M217.9 63.9l0 0c14.8-5.7 43-5.3 62.4-4.7 7.8 .4 15.1 4.3 16.1 11.5 2 16.3-.4 35.8 15.6 45.8 5.3 3.6 11 7.5 16.4 11.3 22.3 16.9 47.3 5.1 73 0 10.8 18.2 22.8 39.3 36.5 56-49.5 41.8-53.4 87.4-8.2 133.2-2.3 17.5-24.5 47.8-33 58.8-44.3-13.3-89.8 8.5-108 52.6-3.8 7-8.2 12.1-11.6 20-12.9 2.6-41.1 .2-53.5-4.1-9.1-30.1-22.5-59.7-50.7-71.6-23.9-12.9-49.2-7-71.9-7.1-4.6-12.8-32.4-37.1-21.8-50.3 8.4-8.3 17.7-17.6 22.3-22.8 11.2-10.4 8.3-39.7 10.3-53.4 .7-25-17.3-29.6-37.5-44l38-66.4c14.2 1.4 46.8 13.6 60.2 4.8 6-3.3 17.3-7.8 21.8-13.2 16.7-17.3 15.9-38.1 23.4-56.4zm142.9 7.5c-5.2-87.1-108.3-87.4-170-65.5-33.8 17.6-35.1 42.4-41.4 64.8l-36-7c-20.2-3.9-40.6 5.5-50.8 23.3l-51 89.2c-18.9 32.7 5.9 62.3 35.3 77.3l-.3 4c-31.7 25-46 70.2-22.5 105.6 7.6 11.9 16 25.3 22.9 36.4 16.8 26.8 47.7 34.1 72.1 29.6 12.8-2.4 21.4-1.1 26.4 1.2 9 1.8 15.2 29.5 18.6 38.2 12 50.4 112.4 53.3 149.6 34.2 18.2-9.7 19.2-25.7 32-45.2 8.7-17 13.7-19.7 15.1-20.4 1.8-.8 6.9-2.2 24.2 1.5 46.8 14.9 81.3-47.2 98.5-81.2 11.7-20.6 16.6-51.3-1.2-77-6.5-9.1-17-20-20.6-27.1 1.9-7.4 24-25.2 32-35.6 20.6-24.3 6.6-63.2-12.4-82.7-37.3-57.8-40.9-88.8-120.5-63.7zM101.2 365.6l0 0zM218.1 63.7c.1-.1 .2-.2 .2-.2 0 0-.1 0-.2 .2zM180.4 194.8c-63.3 83.7 31.9 188.8 115.5 143.8 61.7-34.8 82.3-136.8 8.8-170.5-41.6-19.7-93.2-14.3-124.3 26.7zm96.8 31.1c24.5 13 3.5 46.8-14.5 58-59.2 8.8-45.6-85.6 14.5-58z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M279.3 67.5c-160.6-31.3-246.9 101-206.3 250.9 8.3 45.7 39.4 79.1 85.2 105.2 75.9 45.2 164.7 23.7 228.4-39.6 112.1-103.8 45.3-294.8-107.4-316.5zM95.8 42.1C247.1-63.4 478 31.7 503.6 216.7 543.2 408.7 299 587.1 126.6 479.2-27.2 407.5-48.6 138.5 95.8 42.1zM271 181.2c-8.3-6-28.2-4-37.4 4.1-4.5 39-63.9 35.6-63.7-3.9 3.2-46 42.6-62.2 77-67.4 133.3-7 134.7 180.6 8.3 192.1-41.9-.2-41.9-63.8 0-64 4.8 0 15.2-4.6 23.7-17.9 8.6-13.5 7.6-23.6 5.9-27-4.5-8.8-9.4-13.5-13.7-16zm25.7 184c-.7 18.6-11.4 26.1-24.2 34.2-34.5 18.4-66.1-30-34-54.1 19.9-22.3 57.7-11.6 58.1 19.9z"],
    "arrow-rotate-right-10": [512, 512, [], "e837", "M205.4 6.8c88.5-24.3 187.3 13.3 246 78.7l0-53.5c.2-41.8 63.8-41.9 64 0l0 128c.8 24.9-29.9 41.1-50 26.5-29.8-22.9-59.2-58.6-88.1-82.7-199.9-144.6-413.2 128.8-257 301.1 81 66.5 237.3 47.4 293.6-49.1 9.7-14.8 29.5-18.9 44.3-9.2s18.9 29.5 9.2 44.3C424.9 455.6 363 496.8 282.4 503.9-52 556.5-95.1 80.8 205.4 6.8l0 0zM170.7 164.7c47.3 2.8 28.6 63 30 93.7l0 .2c-5.2 31.9 12 87.4-34 90.4-17.7 0-32-14.3-32-32 0-40.6 3.9-80.7 3.9-120.3 0-17.7 14.3-32 32-32zm119.8 123c5.9 .2 13.4-.5 25.7-1.4 .3-15.5-.1-33.8-.7-49l-24.5-.7c-.4 16.4-.7 35.7-.5 51.1zM276.8 172.1l55.6 1.7c24.7 .8 45.2 20.3 46.3 45.5-1.1 37.4 18.4 125.5-42.4 129.6-42 2.8-103.1 13.6-109.5-42 2.7-44.6-18.7-134.3 49.9-134.8z"],
    "file": [384, 512, [128196, 128459, 61462], "f15b", "M47.2-1.5c42-1.6 129.8-.1 172.8 3.2 30 1.3 60.5 16.9 79.1 43.2 25.3 22.8 43.4 49.6 65 74.2 10.5 11.9 16.1 27.6 14.9 43.7-1.4 49.3 2.9 102 1.7 152l0 .1c-.9 51.6 2.9 102-.3 154.4-9.7 71.5-96.3 45.9-146 48.2-48.6-2.8-98.6 4.5-146.9-2.3-6.2-.4-20.1-1.3-32.4-2-27.9-1.6-50.6-23.6-52.6-51.8-10.6-130.3-5.8-263.1-4.5-395.5-6.4-32.4 13.2-66.2 49-67.4l0 0zM62.1 62.1c-.7 132.6-6.2 256.6 3.9 387.6 40.1 2 71.7 7.1 110.8 3.8 46.6-2.9 94.1 2.7 140.4 1.5 1.4-98.1-2.4-196.1-2.2-294.7-24.3-30.6-51.6-61-77.3-88.1-44.1-15.7-123-8-175.6-10z"],
    "volume-slash": [640, 512, [128263], "f2e2", "M87.9-22.4c-29.7-29.5-67.9 22.4-45.3 45.2 39.6 40 55.2 51 78.8 79.5 11 13.6 24.1 27 36.1 38.2 25.5 24.8 49.1 50.6 74.6 74.7 84.6 82.3 173.7 162.5 253.2 249.5 24.5 27.1 53.6 51.9 76.4 81.7 27.5 31.6 75.7-9.9 48.5-41.8-23.7-30.7-50.8-54-77.3-82.6l0 0C429.2 307.8 312.6 200.9 201.3 93.8 161.9 56.5 128.5 13.9 87.9-22.4zM320.4 16.2c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-17.7-14.3-32-32-32zM69.3 137.2c-45.4 2.4-29.4 58.3-31.1 88.6 1.4 31.2-.3 64.1 2.9 95 2.7 51.9 5.8 74.9 65.5 65.2 12.4-1.8 43.5-3.1 47.2-.1 40.8 22.8 82.9 54.7 122.6 83.3 6 5.3 13.4 10.4 19.4 15.4 18 23.5 56.6 7.8 56.6-20.5l0-61.3c2.3-42.4-60.1-47-63.9-4.9-56.8-34.2-109.1-93.3-182.9-76.1-3.9-31.5-1.9-61-3.3-91.8-4.5-31.9 13.8-89.7-33-92.8zm382 12.3c-34.5-23.6-70.8 28.6-36.4 52.6 28.3 19.6 39.9 35.7 37.5 57.6-1.9 17.6 10.8 33.3 28.4 35.3 17.6 1.9 33.3-10.8 35.3-28.4 6.4-59.2-32.5-94.7-64.7-117.1zM402.2 50.1c-7.4 16.1-.3 35 15.7 42.4 78.4 38.8 159.2 121.3 127.2 218.3-5.1 16.9 4.4 34.8 21.3 39.9 52 10.5 50.1-67.5 49-100.4-6.6-94.8-86.7-175.3-170.8-216-16.1-7.4-35-.3-42.4 15.7z"],
    "arrow-up": [448, 512, [8593], "f062", "M394.4 283.4c30.6 28.3 74.2-18.3 43.5-46.9-56.5-52-146-136.1-191.8-185-15.8-16.2-41.6-16.1-57.3 0-10.3 10.5-28.4 28.8-34.8 34.2-54.1 45.6-91.7 106.1-142.6 149.9-13.4 11.5-15 31.7-3.6 45.1 40.6 41.7 92.2-50.2 118.4-73.2 22.6-26.5 43.9-51.3 68.1-72 0 93.7-2.5 187.6-1.7 282.1-1.2 25.6-5.1 65.7 31.6 66.3 34.1-.5 33.2-36.2 32.4-62-.3-88.6 1.1-177.3 1.9-266.9 48.5 48.6 88.5 83.5 136 128.4z"],
    "rectangle": [512, 512, [9644, "rectangle-landscape"], "f2fa", "M512.3 65.9l0 313.9c0 22.3-.8 50.3-25.4 74.8-10.7 10.7-26.2 15.6-37.2 18.3-50.6 12.6-105.4 11.1-157 11.1-71.3 0-161.5 9.5-232.8-6.5-13.1-2.9-33.8-11.4-41.9-35.1-16.2-47.2-19.7-101.2-19.6-152.1 .1-62.1 .3-125.8 4.5-187.7 1.7-25.5 8.5-68.6 42-68.6 39.5 0 85.6 1.4 133.4 2.9 27.5 .9 55.6 1.7 83.3 2.4 77.3 1.8 153.3 1.7 215-5.1 18.7-2.1 35.5 13 35.5 31.8zM67.7 98.1c-7.8 63.3-5.1 128.7-5.2 192.3-.1 46.5 3.1 89.4 14.1 125.1 69.3 8.6 146.7 4.5 216.2 4.5 39.8 0 77.5-1 106.8-3.8 31-3 48.8-2.7 48.8-36.4l0-278.9c-58.3 4.1-123.9 3.8-188 2.3-29.1-.7-57.8-1.6-85.5-2.4-38-1.2-74.2-2.3-107.1-2.7z"],
    "grid": [576, 512, ["grid-3"], "e195", "M319.6 156.4c-1.9 37.9 29.5 67.9 66.4 66.1l109.6-5.4c65.4-5.6 62.1-66.2 61.4-118.6 4.9-72.1-.6-122.9-86.6-117.9-110.9-2.4-149.9-7.9-147.9 119.7-1.1 19-2.1 38.1-3 56zm66.8-51.8l0 0c1.2-21.2 2.4-42.7 3.2-59.2 0-.2 0-.3 .1-.4 0-.2 .3-.4 .4-.4 34.1-.1 69.3 0 103.6 .1 .1 0 .3 .3 .4 .4l0 .2c-.6 33.1-1.2 75.3-1.9 108l-108.6 5.3c.7-15.3 1.8-34.5 2.9-53.9zm-117-56.1C271.3 10.7 240-19.4 203-17.6L93.4-12.2c-84.6 7-56.2 112.4-62.3 170.6-.7 35.9 28.1 65.9 64.4 65.9 31.9 0 70.8 0 103.5 0 67.6-2 66.2-68 67.5-119.7 1.1-19 2.1-38.1 3-56zm-66.8 51.8c-1.2 21.3-2.4 42.7-3.2 59.2 0 .2 0 .3-.1 .4 0 .1-.2 .3-.2 .3l-.1 .1c-32.7-.1-71.7 0-103.7 0 0 0-.1 0-.2-.1-.1-.1-.2-.2-.2-.2l0-.2c.6-31.7 1.2-73.9 1.9-108l108.6-5.3c-.7 15.3-1.8 34.5-2.9 53.9zM31.6 340c.9 17.9 1.9 37 3 56 1.6 52.2-.7 117.1 67.5 119.7l103.5 0c36.3 0 65.1-30 64.4-65.8-.3-15.1-.6-33.5-.9-52 .7-52.4 3.9-113-61.4-118.6L98 274c-37-1.8-68.3 28.2-66.4 66.1zm66.8 51.8c-1.1-19.4-2.1-38.7-2.9-54l108.6 5.3c.7 34.1 1.2 76.3 1.9 107.9 0 .1 0 .1 0 .2 0 .1-.1 .2-.2 .3-.1 .1-.2 .1-.2 .1-31.8 0-71.2-.1-103.6 0-.1 0-.3-.3-.3-.4-.1-.1-.1-.2-.1-.4-.8-16.5-2-37.9-3.2-59.2l0 0zM491 514.1c37 1.8 68.3-28.3 66.4-66.1-.9-17.9-1.9-37-3-56-.5-74.6-6.2-127.8-96.4-119.7-32.1 .1-51 0-74.6 0-36.3 0-65.1 30-64.4 65.8 .3 15.1 .6 33.5 .9 52-.7 52.4-3.9 113 61.4 118.6L491 514.1zm2.5-64l-108.6-5.3c-.7-34.1-1.2-76.3-1.9-107.9l0-.2c0-.1 .3-.4 .3-.4 28.3 0 69.4 0 103.6 0 0 0 .1 0 .2 .1 .1 .1 .2 .2 .2 .3 .1 .1 .1 .2 .1 .4 1.7 34.3 4.6 83.8 6 113.2z"],
    "shirt": [640, 512, [128085, "t-shirt", "tshirt"], "f553", "M69.6 161.5c-1.1-13.5-2.3-28.7-3.3-41.3 53.7-14.5 103.7-32.4 156.1-44.1 16.7 124.1 194.7 126.2 190.7-8 35 3.8 111.1 29.9 146.3 42.8-.5 18-1.2 43.1-1.1 58.6-.7 15.9-1.9 33.6-2.9 50.6-36.1 .5-100-29.9-110 22-3.4 38.4-.8 160.9 .9 208-81.2-8.3-168.1 10.4-251.4-2.7-1.3-47.3-2.1-132.7-2.4-179.8-.2-34.2-30.8-60.3-64.7-54.9-17.8 2.7-35 5.8-52.4 7.6-2.2-23.1-4.4-36.2-6-58.8zM349.2 64.2c-.5 22.1 .2 41-27 41.1-24.1 .8-30.8-19.5-36.4-39.2 20-2 42.5-2.3 63.3-1.9zM329.5 0c-85.4 0-154.7 21-222.7 41.7-130.4 30.8-105.8 52.3-97.4 162.2 1.6 85.6 48 88.1 119.3 73.5 .4 51.3 1.3 136.7 2.6 179.9 1.8 94.8 214.6 47.3 276.6 54.5 11.1 1.6 24.2 1.7 37.9 2.4 34.9 7.6 68.5-19.5 65.2-54.5-2-39-3.5-132-2.9-180.4 12.6 1 30.7 3.1 47.1 5.3 32 4.3 61.6-19.3 63.6-52.1 4.1-55 3.4-77.7 4.8-125.6-2.1-60.8-61.6-59.5-114-80.7-62.8-21.6-117.9-27.1-180.1-26.3z"],
    "suitcase": [512, 512, [129523], "f0f2", "M377.6 94.5c-1-52.6-44.1-94.4-96.5-94.1L219.8 .7c-51.4 .3-93.2 41-95.4 91.9-145.8-15.5-119.6 94.9-123.8 196.3-.3 47.1 .6 93.5 5.1 151.6 3.2 41.4 38.1 70.8 77.8 70.5 124.7-3.5 237.8 3.5 355.9-1.1 42.1-2.3 72.7-37.4 72.9-77.7 .3-69.4 .5-207.2-1.8-267-2.2-72-86.7-64.9-132.8-67.7 0-1.1 0-2-.1-3.1zm-64 1.6c-40.3 0-82-.9-125.2-1.9 1.3-16.4 15-29.3 31.7-29.4l61.3-.4c17.8-.1 32.1 14.1 32.2 31.6zM188.4 158.2c43.7 1.1 86.1 1.9 126.5 1.9 1.8 98.5 4.2 227.5 5.2 287.4-38.8-1.3-84.1-1.4-131.6-1.1l0-288.1zm-64-1.5l0 290.1c-17.2-3.2-49.3 10-54.8-11.1-3.1-39.9-5.1-90.4-4.8-115.2-1.1-53 .9-94.3 3.4-148.7 3.9-26.5 37.6-12.3 56.2-15zM384 447.8c-1-59.4-3.3-187.7-5.1-286.2 14.7 .6 44.2 2.2 67.6 5.1 2.5 58.8 2 194.7 1.9 265.3 0 8.3-6 13.7-12.4 14-16.8 .9-34.5 1.5-51.9 1.8z"],
    "comment-slash": [640, 512, [], "f4b3", "M79-21.8c-28.8-30.2-75.2 13.4-46.5 44 118.4 113.3 230.9 230.4 349.8 343.2 29.3 24.4 51.5 51.7 78.5 77.5 32.8 33.2 65.2 65.2 103.2 92.4 14.3 10.4 34.3 7.3 44.7-6.9 10.4-14.3 7.3-34.3-6.9-44.7-182.8-158.9-346.8-339.3-522.8-505.5zM424.4 120.4c40.3 21.5 79.7 82.4 79.6 142.2-1 24.9 5 56.8 36.8 54 17.6-1.8 30.4-17.5 28.5-35.1 2.9-163.5-126.2-266.9-284-249.2-17.6 1.2-31 16.4-29.8 34 1.2 17.6 16.4 31 34 29.8 55.9-3.7 100.8 4.4 134.8 24.4zM99.2 182c-49.5-8.1-47.4 63-43.5 95.3 5.4 38.8 36 67 55.4 102.9-4.4 24.5-13.7 59.7-19.4 80.1-8.5 30.5 20.4 59.1 51.2 48.8 29.9-10.1 62.3-22.1 91.7-30.1 36.7 5.7 144.8 26.8 140.5-32.8-2.7-17.5-18.9-29.5-36.4-26.8-40.6 10-76.3-5.4-115.8-3.6-7.5 2.2-37.2 10.8-58 17.9 4.6-27.7 18.4-53.2 6.1-77.7-8.4-20.9-49.9-68-52.3-90-2.1-11.6-1.2-25.2 3.8-45.2 4.3-17.2-6.2-34.5-23.3-38.8z"],
    "play": [384, 512, [9654], "f04b", "M4 89.6c23.4-137.4 203.9 54.8 260.9 77.8 18.5 10 60.7 38.4 83.8 54.1 27.1 18.4 28.2 58.1 1.8 77.8-85.8 65-178.9 102.8-269.4 158.3-49.4 26.6-82-20.1-75.8-64.8-1.4-101.2 2.2-202.2-1.2-303.2zm64.6 23c2.3 92.9-.6 184.8 .6 277.2 77.5-44.2 149.5-77.2 224.5-128.2-22.3-15-47.9-31.8-59.3-37.9-58.5-31.3-108.8-82.4-165.8-111.1z"],
    "paperclip": [448, 512, [128206], "f0c6", "M68.7 36.9c43.9-47 136.2-51.2 183.9-6.4 74 66.1 73 180.7 58.6 267.5-5.9 42.4-56.2 77.8-98.9 70.1-30.9-2.6-61.4-28.3-65.7-66.2-3.5-33.8-42.2-129.2 17.3-133.7 17.7 .2 31.9 14.6 31.7 32.3-.2 26 6.6 56.8 13.5 88 1.2 4.2 1.4 11.1 4.3 13.7 7.6 5.4 22.8 1.5 28.7-4.8 2.9-2.8 5-6.7 6.6-13.7 8.5-50.9 10-112.2-8.4-160.4-18-56.1-82.2-83.6-129.6-38.4-20.7 18.2-31.6 51.7-33.2 87.6-3.2 61.5-2.5 118.3 6.7 177.7 18.7 120 186.7 120.1 241.7 42.9 22.7-28.3 37.3-67.4 50.7-118.7 8.6-33.5 3.8-73.3 4-109.1 0-17.7 14.3-32 32-32 33.2 .4 33.4 35.1 32.6 60.4 6.1 81.7-21 175.8-69.4 239.5-69.9 93.3-237.8 108.1-316.9 12.1-41-45.4-41.3-107.4-45.6-161.8-.4-87-15.2-178.1 55.1-246.6z"],
    "wrench": [512, 512, [128295], "f0ad", "M304.7 22.9c36.6-28.4 80.7 7.4 111.4 35.2 112.4 109.7 93.5 318.4-48.4 395.8-.8 12.8-1.7 29.7-1.7 42.3-.2 41.8-63.8 41.9-64 0 0-14.8 1-33.7 1.8-46.6 .7-32.5 28.6-50.2 53.1-64.8l-.1 .1c94.2-69.4 90.7-239.6-12.5-301.9-5.4 50 17.9 132.9-28.2 168.3l-27.5 19.6c-29.6 22.5-63.9 8.5-92.4-6.2-23.9-10.6-39.2-34.6-38.3-61 1.7-44.8 1.9-70.6 .9-112.1 0-.5 0-1 0-1.4-43.8 25.6-79.3 71.8-86.2 117.9-7.7 61.6 22 153.1 79.7 182.7 16.9 9.1 33.1 26 36.8 49.9l6.9 45c6.1 41.3-56.7 51.1-63.3 9.7l-6.9-44.9c0-.1-.1-.3-.4-.6-86.8-47.4-125.8-156.6-116.5-248.7 11.3-75.1 61.6-134.6 122.7-169 43.9-22.9 90.3 11.9 91.1 55.6l0 2.9c1.1 41.1 .8 71.3-.9 115.1l0 .1 .1 .1c0 .1 .1 .1 .2 .2 8.5 3.7 18.6 8.3 27.7 12.5 .4 .2 .9 .3 1.2 .2 .2 0 .3 0 .3-.1l0 0 27.4-19.6c2-43.5 2.1-85.9 1.2-127-.4-20.6 10-38.7 24.6-49.2l.1 0z"],
    "life-ring": [512, 512, [], "f1cd", "M358.7 25.7c-48.7-33.4-110.2-30.4-161.9-14.5-33.6 10.3-66.3 26.8-93.7 46.5-12.1-12.5-32-13-44.8-1.1-12.7 11.8-13.6 31.6-2.2 44.6-62.5 80.5-77.1 211.9-16.4 297.9 4.1 5.7 8.3 11.3 12.6 16.6-2.7 3-5 6.5-6.5 10.5l0 .1c-.5 1.4-3.8 9.8-.7 20.2 2 6.9 6.6 13.6 13.9 18.2 6.6 4.1 12.9 4.7 16.6 4.8 6.5 0 11.3-1.9 12.4-2.4l.1 0c3.8-1.6 7.2-3.9 10.3-6.7 63.9 48.8 145.8 64.7 229 39 26.8-8.3 62.1-17.6 92.5-37.8 13.8 5.8 30.2 1.2 38.9-11.6 5.9-8.7 6.9-19.3 3.6-28.5 22.3-29 37.1-64.4 44.4-99.8 10.9-52.5 6.6-111.1-20.3-156.5-1.9-3.3-3.9-6.7-6-10.1l0 0c-8.7-14.8-18.3-31.3-30.3-47.2 1.9-2 3.8-4.1 5.7-6.1 11.9-13.1 11-33.3-2.1-45.2s-33.3-11-45.2 2.1c-1.2 1.3-2.3 2.5-3.5 3.8-14.3-12.4-29.4-24.9-46.3-36.5zM101.9 146.8c13.9 14.2 27.6 28.5 41.8 42.4 6.1 6 11.9 11.7 16.5 16.3-15.1 25.9-19.8 56.1-13.1 83.9 1.9 8 4.7 15.6 8.5 22.9-18.9 19.7-38.4 38.6-57.4 58.2-2.1-2.8-4.2-5.6-6.3-8.5-44-62.3-29.9-155.3 10-215.3zm102.7 12.7c-15.7-15.5-32.1-30.6-47-46.8-2.8-3.1-5.7-6.1-8.5-9 19.6-12.8 42.5-24 66.3-31.3 43.1-13.2 81.4-11.5 107 6.1 12.7 8.7 24.3 18.1 36.3 28.4-17.1 15.8-33.7 32.3-49.2 49.6-26.3-22.6-79.7-12.9-104.9 2.9zM444 308.6c-4.8 23.4-13.5 45.1-25 63.1-7.7-8.5-15.6-17.1-23.3-25.5-12.9-13.9-25.5-27.3-36.6-42.7l-.3-.5c2.9-6.7 5.1-13.9 6.5-21.6 4.5-24.3 5.5-52-11.2-78.4 15.8-17.5 32.4-34.2 49.6-50.2 7 10.1 13.7 21.4 21.1 34.1 2.1 3.5 4.2 7.2 6.5 11 16.5 27.8 21.3 69 12.7 110.8zM315.2 351.4c10.9 13.9 22.9 26.7 34.9 39.7 7.5 8.1 14.8 16 22.2 24.2-70 36-161 45.8-227.8-.5 18.9-19.5 38.4-38.4 57.2-58 3.4 1.6 6.9 3.1 10.6 4.4 29.6 10.5 63.5 8.7 91.9-4.1 3.8-1.7 7.5-3.6 11.1-5.7zm-17.8-118c6.7 8.1 8.6 16.5 5 36.3-2.4 13-11 23-24.4 29-14 6.3-30.9 6.9-44.2 2.2-14.1-5-21.6-14.9-24.4-26.4-2.9-12.2-.6-27.4 8.7-40.7 4.8-7 11.4-13.8 18.5-18.7 23.8-16.4 44.6-1.2 60.8 18.3z"],
    "calendar": [512, 512, [128197, 128198], "f133", "M324.5 4.1c-.1-4.3-.2-8-.3-11-1.2-5.6-.9-12.6 .7-18.2 7.5-29.6 52.2-30.7 61.1-1.6 6.4 18.3 2.8 41.1 2.5 59.9 57.6 7.5 98.4 37.2 94.1 98.2 .4 96.3 18.7 203.1-9.8 297.2-9.2 31.5-37.1 41.7-63.4 46.3-30.3 4.6-100.1 9.2-167.9 9.2-61.8-2.3-121.4 2.2-175.5-24-33.2-13.9-38.3-45-37.4-79.3-3.4-52.3-2-120.1-2.3-172.8 .4-98.7-17.3-155.2 102.8-172.8 .5-14.9 1.1-34 1.1-46.3 .2-41.9 63.8-41.9 64 0 0 11-.4 26.2-.8 39.3 41.4-3 88.6-4 131.3-1.7 .1-6.8 0-14.7-.1-22.2l0 0zM114.1 103.4l-.1 0c-11.4 4-17 5.1-22.6 10.2-1.5 16.8-1.3 37-1.5 55.8 8.3 0 17.1-.7 27.2-1.5 16.7-1.3 34.5-2.3 51.5-3.5 83.4-6.5 168.1-9.2 251.3-7.5-.2-6-.6-12-1-18.4-1.5-8.2 .9-23-3.5-30.5-80.8-31.7-219.8-20-301.2-4.6zM90.2 233.3c-.4 52.2-.1 116.9 3.4 168.7 .6 .4 2 1.2 2.7 1.5 1 .6 2.1 1.2 3.2 1.8 82.7 24.5 246.2 15.5 312.7 2.8 16-46.4 12.7-119.9 10-175.4-.1-1.4-.4-10.1-.5-11.7-10.9 0-21.7-.1-32.4-.2-73-1.6-143.7 2.4-216.1 7.6-28.4 1.4-53.4 4.5-82.9 5zM413.9 407.1l0 0z"],
    "italic": [512, 512, [], "f033", "M485.7 57.9c-.2 55.6-83 32.6-117.8 36.8-3.6 8-8.9 16.5-12.8 22.9-53.9 94.5-88.9 190.8-131.3 289.8 22.7 1.7 46.5 4.5 67.8 4.5 17.7 0 32 14.3 32 32-1.6 44.2-56.5 30.4-84.7 29-44-5-83.5-2.3-127.6 .9-31.3-.9-90.8 20.1-95.4-27.4-.5-17.7 13.3-32.4 31-33 33.9-1.1 68.9-4.5 103.3-6.3 17.7-28.6 34.3-63.7 45.4-98 25.6-77.1 64.8-145 99.6-216-25.1 .3-55.7 3.2-80.9 2.8-41.8 .4-42.7-63.3-.8-64 45.5-.7 95.6-4.5 138.9-1.7 34.5 1.1 66.6 2.1 98.3-1 17.6-1.7 33.2 11.1 35 28.7z"],
    "check": [448, 512, [10003, 10004], "f00c", "M432.6 100.3c32.4 27.5-13.6 63.3-26.9 80.5-64.7 79.7-147.9 156.3-224.2 224.2-13.2 11.5-33.1 10.4-44.8-2.6-21.7-24-46-46.7-70.6-69.6-21.8-28.4-98-65.2-62.1-106.8 12.8-12.2 33.1-11.6 45.2 1.2 35.6 37.6 76.1 71.6 113.1 109.2 59.8-55.6 120.7-108.2 173.2-172.4 20.3-23.6 28.6-32.5 52-60 11.4-13.5 31.6-15.1 45.1-3.6z"],
    "wifi-slash": [640, 512, [], "f6ac", "M33.4-31c12.5-12.5 32.8-12.5 45.2 0 72.5 72.5 133.6 138.1 198.1 207.7 91.4 97.1 191.5 186.1 286.4 280.7 13.9 13.2 28.2 26.5 41.9 42 27.6 31.4-20 73.7-47.9 42.4-54.4-55-110.5-110.9-168.8-163.4-125.5-117.6-230.6-240-354.9-364.2-12.5-12.5-12.5-32.8 0-45.2zM288 87.6c3.3-69.8 158.9-6.8 191.3 3.2 41 15.7 83.1 37.4 114.5 66.2 34.6 23.4-.7 76.3-35.6 53.2-64.5-54.9-155.1-86.3-238.2-90.6-17.7 0-32-14.3-32-32zM75.2 162.2c17.3-1.7 35.5 18.3 33.3 33.9 1.1 30.9-42.4 43.6-58.5 18-16.5-19.7-1-52.7 25.2-51.8zm73.2 138.1c-.9 40.4 63 44.8 64.5 .3-1.4-44.2-64.8-40.4-64.5-.3zm144.2 73c21.5 26.7 81.7 58.9 52.3 95.3-24.6 27.2-54.3-3.7-70.5-23.1-8.2-8.9-16-17.1-23.8-23.9-31.4-27.6 10.3-75.6 42-48.3z"],
    "rocket-launch": [576, 512, [128640], "e027", "M272.3 115.9c-42.7 41.3-72.2 92.1-99 144.7 29 34.4 58.6 68.2 90.3 100.6 61-30.5 126.7-72.6 173.3-121.8 52.3-51.6 41.5-114 39.1-178.7-83.5-3.9-148.2-.5-203.7 55.1zM128.7 208.2c18.2-34.8 38.6-68.7 63.3-98.7-47.8 4.4-65.8 30.8-90.1 65.4 8.8 11.2 17.7 22.3 26.8 33.3zm125.2-161c79.6-60.1 170.8-53.5 255.5-48.7 43.6 4.9 27.1 57.3 31.6 88.2 7.1 64.9-3 137.3-47 184.5-4.2 50.1-4.4 126.4-37.8 167-37.6 57.3-135.7 103.6-181.6 29.3-23.4-28.3-48.9-52.3-74-79.7-26.2-26.6-50.3-55.8-75-84.4-30.1-35-61.2-71-89.2-108.8-14.9-19.6-.7-38.8 12.3-55.3 47.5-73.5 101.2-105 205.2-92zm170 289.7c-17.4 13.1-34.5 24.5-51.2 35.3-19.6 12.6-40.5 26.2-62.8 38 9.5 9.7 18.2 23.3 27.7 32.2 54.1-5.7 83.9-52.8 86.2-105.5zM373.4 124.6c-65.4-3.5-74.1 95.2-5.6 95.4 63.1-2.6 66.2-95 5.6-95.4zM91.6 366.2L62.1 390.8c-32.4 26.6-73-22.3-40.9-49.2L50.7 317c32.3-26.6 73 22.4 40.9 49.2zm62.9 16.4c12.6 12.4 12.7 32.7 .3 45.2l-53.8 54.5c-12.4 12.6-32.7 12.7-45.2 .3-12.6-12.4-12.7-32.7-.3-45.2l53.7-54.4c12.4-12.6 32.7-12.7 45.2-.3zm77.6 113.7c-20.8 18.1-49.4 63-79.9 33.3-12.4-12.7-12.1-32.9 .5-45.3l34.7-33.8c30.1-29.1 74.5 16.4 44.7 45.8z"],
    "shield-slash": [640, 512, [], "e24b", "M47.6-31.5c26.9-23.8 51.8 7.9 67.7 27.8 124 131.8 258.8 251.8 379.8 387.4 25.3 27.4 52.8 52.4 81.1 78.8 20.9 19.7 57.3 43.6 31.4 73.3-12.1 12.9-32.3 13.5-45.2 1.4-154.9-144.1-292.8-304.4-448.9-448.7-24.2-23.3-46.2-50.4-68.2-74.8-11.9-13.1-10.9-33.3 2.2-45.2zM311 2.3c38.5-5.7 70.3 18.3 105.3 25.6 45.8 17.3 128.2 28.1 130.4 90.5 .7 37.8 3.2 88.5 .7 126.9-.8 26.7 3.1 65.3-33.1 66-17.7 0-32-14.3-32-32 2.3-51.8 2.7-106.8 .5-158.2-47.3-24-107.9-38.1-158.2-55.8l-30 10.3C254.8 89.2 234.2 29 273.6 15.2L311 2.3zM128.3 189c17.7 0 32 14.3 32 32 0 35.7 2.7 64 12.9 94.8 21.4 68.4 95.9 91.9 150.1 126.8 34.1-38 86.1 9.8 47.8 43.7-10.5 8.3-19.3 16.3-34 21-38.6 8.9-79.7-32.3-112.6-48.6-51.3-28.7-93.9-62.8-112.2-122.8-9.4-36.9-40.8-145.3 15.9-146.9z"],
    "house": [512, 512, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M283.4-8.8c-40.8-23.5-84 15.9-113.5 40.1-10.9 9.2-21.5 17.3-32.8 25.4-19 14-38.5 28.5-58.7 42.5-30.2 23.6-79.3 44.2-78.2 89.1l0 262.7c0 30.4 21.6 57.5 52.9 62.5 91.9 10.1 184.9 4.9 276.9 5.1 29.6 0 88.8-4.3 123.5-7 33.3-2.6 58.7-30.3 58.8-63.4 .2-46.5 .5-132.1 .8-146.9 .8-29.9-.2-88.6-.7-114.8-.3-17.6-7.9-34.4-21.3-46.2-18.6-16.7-43.6-37.4-65-50.1-50.1-32.1-89.4-72.9-142.8-98.8l0 0zM250.5 50.6c.6-.4 2-1.1 4.3-2.2 50 24.5 92.1 68.2 139.4 97.1 19.2 11.8 34.2 24.4 54.3 42.3 2 88-.3 154-.2 259.9-21.2 1.6-49.6 3.7-74.8 5.1-9.3-77.4-20.9-216.7-132.7-196.4-91.7 30.2-82.6 126.1-85.3 197.9-33.4-1.4-56 2-91.3-4l0-261.8c61.7-44.2 125.9-92 186.2-137.9l0 0zM219.5 455.8c.9-42-3.9-126 37.7-137.4 7-1.9 11.7-.4 17.4 5.4 26.3 34.1 28.5 88.4 34.8 130.8-11.9 .1-23.5 .3-35 .5-18.5 .4-36.7 .7-54.9 .6z"],
    "play-pause": [512, 512, [], "e22f", "M71.9 62.9c-32.1-16.8-68.9 7.8-68.1 42.5 1.4 59.6 1.1 119.2 .8 178.9-.2 37-.6 74 .3 111.2 .5 38.8 46.4 64.6 79.6 38.5 30.5-22.4 61.8-42.9 92.5-65.7 184.3-123.2 99-125.3-22.5-239.6-24.6-23.6-50.2-48.9-82.6-65.9l0 0zM68.6 285.6c.2-49.2 .5-98.9-.2-148.5 48.4 44.3 88.4 80.9 143.3 124.1-7.1 6.6-14.6 13.8-21.6 19.2-18 12.5-35.2 25-52.2 37.2-23.1 16.7-45.9 33.1-69.5 49.1-.2-26.9 .1-53.8 .2-81.1zM355.5 63.3c-17.7-.2-32.1 14-32.3 31.7-.4 41.6 .7 82.2 1.7 122.1 1.7 66.3 3.3 131.1-1.4 196.5-1.3 17.6 12 33 29.6 34.2 17.6 1.3 33-12 34.2-29.6 4.9-67.9 3.2-139 1.5-208-.9-39.3-1.9-77.9-1.6-114.8 .2-17.7-14-32.1-31.7-32.3zm127.6 4.4c-27.7 0-35.1 24-33.5 47.5-3.1 101.3-6.2 204-1.2 306.8 .8 17.6 15.8 31.3 33.5 30.4 17.6-.8 31.3-15.8 30.4-33.5-4.8-100.2-1.8-200.6 1.3-302.5 3.1-23.2-3.3-47.1-30.5-48.7z"],
    "sliders": [576, 512, ["sliders-h"], "f1de", "M163.2-2.8c17.6 1.8 30.4 17.4 28.7 35-5.6 61.2-6.6 124.4 .1 186.9 2.3 41.7-61.2 45.6-63.9 3.8-1.4-22.6-4.8-44.5-4.7-68.1-22.6-1.6-36.7-.6-59.5 1.3-41.7 3.8-47.8-59.5-6.1-63.7 26-2.3 42.2-3.2 66.5-1.8 4.4-31.5-9.3-94.9 39.1-93.5zM331.3 92.5c60.3-.1 120.5 .5 180.7 .4 17.7 0 32 14.3 32 32s-14.3 32-32 32c-59.7 0-119.4-.5-179-.5l-55.3 2c-17.7 .6-32.5-13.2-33.1-30.8s13.2-32.5 30.8-33.1l55.9-2zM317.5 242.4c40.7 1 31.5 49.3 31.2 76.5-2.8 52 2.8 101.9 6.6 152.8 3.8 41.6-59.5 47.8-63.7 6.2-2.1-21.2-2.9-42.2-4.7-62.9-77.1 .2-153.2 2.2-230.5 2.9-17.7 .2-32.1-14-32.3-31.7-.2-17.7 14-32.1 31.7-32.3 75.6-.7 152.5-2.7 228.3-2.9 6.2-35.1-17.2-104.2 33.4-108.6l-.1 0zm90.6 138c2.5-41.3 49-29.7 76.6-30.3 26-2 68-6 68.4 31-.8 37.4-41.9 32.1-68.8 33l-45-1c-17.7-.4-31.7-15-31.3-32.7z"],
    "paintbrush-slash": [640, 512, [], "e74e", "M86.3-21.7C56.1-50.4 11.8-4.6 42.1 24.5 126.2 109.1 220.5 182.9 299.7 273.4L551 534.4c12.3 12.7 32.5 13.1 45.2 .9 12.7-12.3 13.1-32.5 .9-45.2L345.7 228.8c-9.8-9.9-19-20.2-28.8-31.3-63.7-70.6-140.8-129-208.2-197.8-7.5-7.2-14.9-14.3-22.5-21.5l0 0zM553.5 82.1l0-.1c13.7 33.2-27.9 70.6-50.3 93.9-5.2 5-10.6 10.3-16.3 16.2l-28.4 26.6c-12.9 12.1-13.6 32.3-1.5 45.2 12.1 12.9 32.3 13.6 45.2 1.5L531 238.4c4.4-4.3 8.7-8.7 13.7-13.5 45.9-43.7 107.4-115.6 58.2-183.4-41.2-50.2-110.9-51.6-156.3-6.6-31.4 31.7-67.5 59.6-97 91.7-12.5 12.5-12.4 32.8 .1 45.2 18.8 19.3 44.1 5.5 57.4-12.4 27-28.2 58-51.4 84.6-79 19.9-19.7 45.7-17.9 61.8 1.8zM216.9 270.9c-9.6-14.8-29.4-19.1-44.2-9.5-66.8 43.7-77.3 116.6-79 186.3l-42.1-.8c-41.9-.6-43 63-1.2 64l74.5 1.3c9.5 0 20.4 .3 32.6 .7 61 .6 129.9 7.3 181.9-34.1 2.3-1.7 9.6-10.4 11.8-12.4 30.2-39.4-27.2-76.8-54.5-35.3-27.3 22.3-98.8 19.2-138.9 17.8 1.2-49.4 6.4-106.2 49.7-133.7 14.8-9.6 19.1-29.4 9.5-44.2z"],
    "face-frown": [512, 512, [9785, "frown"], "f119", "M101.8 48.8c110.2-87 292.7-60.5 360.6 71.7 30.8 65.3 53.9 125.7 38.9 204.2-39.6 184-282 238.5-417.3 125.6-128.4-108.8-115.3-296.9 17.8-401.5zM295 68.3c-185.4-48.8-324.9 206.3-168.8 333.9 95 81.8 287.3 41.5 312.4-89.4 10.9-57.5-4.3-102-34-164.9-19.8-42-58.5-66.2-109.5-79.5zm84.5 261.6c31 28.1-11.5 75.5-42.8 47.6-38.1-40.5-90.6-33.7-138.4-14.9-7.3 3-13.5 7.3-23.6 14.7-14.3 10.4-34.3 7.3-44.7-7-21.2-32.8 15.5-54 44-66.9 66.3-28.8 153.2-29.4 205.5 26.6zm-28.2-86.2c-18.2 10.7-42.4 1-54.4-18.1-14.7-23 7.4-52.4 27.8-55.1 53.1-14.1 69 48.7 26.6 73.3zm-168.8-75c65.2 9.8 47.2 88.8-14.2 78.9-47.2-9.9-28.2-78.5 14.2-78.9z"],
    "phone-plus": [512, 512, [], "f4d2", "M234.8 84c16.8 28.5 3.2 74.2-17.6 95.8-6.6 7.4-14.8 29-18.6 39.4-3.6 47.1 70.6 102.7 110.2 90 14.6-4.2 35.2-20.1 50-28.4 11.7-7.4 20-14.8 40.2-15.6 38.6 2.4 52.5 28.9 69 51.4 21.2 28.1 42.9 67 19.8 105.2-87.5 129.1-280.5 100.6-376.8 6.8-78.9-69.8-111.4-159.7-110.5-259.4 4-59.8 38.9-142.8 102-166.6 57.9-12.3 109.3 33 132.3 81.4zM120 64.3c-144.8 126.5 14.1 382.6 182.3 380.4 57.4-.4 112.1-18.7 131.5-58.4-3-16.2-23-40.6-34.9-55.3-25.2 14.8-45.2 32.6-76.1 40.6-83.6 15.2-145.2-38.8-179.6-104.6-20.1-36.4-3.7-86.8 20.2-122 7.5-9.7 13.5-18.1 15.5-24.9-1.8-22.9-34.9-56-58.7-55.9zm243.4 77.4c-27.6-.2-73.4 8.8-74.9-31.1 .8-41 48.3-31.8 76.6-33 .8-28.2-11.1-66.4 26.2-72.4 40.6-4.6 38.6 46 37.8 72.4 26.7-.1 69-4.3 68.7 33.4-1.6 37.6-43.5 31.1-70.1 30.6 .4 3.3 1 8.3 1.6 12.7 5.8 25.2 3 58.3-29.5 59-17.7 0-32-14.3-32-32 0-2.4-1.1-12.1-2.4-21.7-.7-5.3-1.6-11.9-2.1-17.9z"],
    "forward-step": [448, 512, ["step-forward"], "f051", "M105.1 48.4c-31.9-18.2-69.9 6.1-69.2 41.4 1.4 65.7 1.2 131.4 .9 197.2-.2 40.8-.6 81.6 .3 122.6 .4 40 48.3 65.1 80.9 37.2 30.3-24.3 61.6-46.6 92.2-71.4 184-135.1 97.9-129-22.7-255.1-24.4-25.6-50.1-53.2-82.5-71.9zm-4.3 239.7c.2-54.4 .5-109.3-.3-164.2 12.6 11 27.2 26.1 40.3 40 34.2 38.5 64.3 58.1 105.2 97.5-23.9 24.5-49.9 43.5-77 64.9-22.8 17.9-45.2 35.5-68.4 52.8-.2-30.2 .1-60.4 .2-90.9zM419.3 96.8c.9-41.7-62.7-43.6-64-1.7-2.9 108.6 12.9 212.9 12.4 320 0 41.8 63.6 42.2 64 .3 .7-107.8-15.1-212.4-12.4-318.7z"],
    "wand-magic": [576, 512, ["magic"], "f0d0", "M492 19.7c-69-63-128.2-2-175 53.1-65.1 66.9-120.4 128-190.8 193.2l0 0c-76.7 72.5-159.5 128.3-49 218.5 34.5 36.3 87.3 31 119-.3 54.8-55.3 85.3-76 128.5-123.4 10.8-11.7 22.4-22.5 34.9-34 37.2-34.6 72.4-72.4 110.5-107.4l2.5-2.3c74.3-62 106.4-120.4 19.6-197.4zM415.1 63.4c22.5-19.6 44 15.7 58.8 30.4 25.2 27.8-38.4 70-62 92.5-5.5-5.1-10.7-10.3-16.3-16.1-5.6-5.6-12.1-12.2-17.5-17.4-7.8-7.6-19.4-16-23.7-26.2 3.3-3.5 6.6-7 9.8-10.6 16.7-18 33.8-36.4 50.9-52.5zm-106 110c12.6 14.5 26.8 27.4 40.3 41.1 5.2 5.2 10.8 11 16.6 16.4-28 29.7-58.3 55.3-87.2 85.3-44.1 48-74.9 69-127.4 122.3-10.2 9.7-21.1 10-29.9-.1-17.9-17.8-27.2-25.3-34.8-38.7 18.3-30.6 59-63.4 89.1-92.3 48.1-42.9 90.9-92.1 133.4-134z"],
    "sort": [384, 512, ["unsorted"], "f0dc", "M210.6-27.9c77.6 51 125.5 126.2 173 205.6 10.3 19.3-4 44.9-25.9 46.2-72.2 6.3-147.4 4.1-220 2.1-35.1-1-69.6-2-102.8-2-81.3-15.2 18.2-113.9 43.1-144.1 33.2-35.1 57-74.7 97.6-105.4 10.1-7.7 23.9-8.6 35-2.4zM197 40.4c-37 36-73.4 79.5-103.9 120.3 17.3 .4 34.5 .9 51.5 1.4 52.6 1.5 104.2 3 155.6 1.2-22.2-29.1-41.2-60.4-67.4-88.5-10.6-11.9-21.2-22.7-35.8-34.3zm14.6 314.7c-31.2 0-81.4-1-120.5-1.8 31.4 47.8 69 83.6 108.7 122.4 41-32.9 74.1-76.6 102.1-124.8-29.8 1.2-60.4 4.1-90.3 4.1zM35.8 288c75.9 0 152.1 6 227.9 1 37.2 1.1 140.8-22.8 119.9 45.3-39 78.1-91.7 158.9-170.7 211.1-33.1 20.6-51.5-21.8-73.6-39.4-22.5-21.8-207.1-203.9-103.5-218l0 0z"],
    "server": [512, 512, [], "f233", "M513.2 203.8c0 44.6-3.8 90.2-7.5 134.8-2.5 30-4.9 59.2-6.2 88-8.2 106.5-147.6 80.3-221.9 85.2-62.5 .3-129.3-.7-205.8-5.9-42.7-4.1-72.4-42.7-69.4-84.1 4.6-127-5.1-231.3 1.7-353.4 3.8-41.3 42.5-69.9 79.8-68.2 89.2-.2 284.7-.8 359.9 2.1 30.3 2.1 56.8 24 60.7 57.4 7.4 56.9 8.1 91.9 8.8 144zM441.9 332.8c1.2-15 2.5-30 3.6-44.8l-378 0c0 46.6-.8 94.3-1.2 140.2-.1 8 5.7 13.7 12.4 14.1 52.2 3.5 123.5 5.8 157.7 5.4 64.6 0 118.8 2.1 184.4-7.1 7.3-.9 14.1-7.5 14.6-17 1.4-30.1 3.9-60.8 6.4-90.9zM66.9 224l382 0c.5-55.3-.6-98.9-8.3-157.5-73.7-3.5-271.4-2.3-359.3-2.3-8.2 0-13.2 5.7-13.7 11.6-3.6 49.5-1.7 98.8-.7 148.2zm262.2-80c1.2-37.6 48.1-40.4 64.6-14.6 10.8 14 8.4 34-5.6 44.9-22.3 17.7-58.5-3.1-59-30.3zm14 24.5s0 0 .1 .1l-.1-.1zm56 197.6c6.1 41.3-43.3 51.4-64.1 19.6-27.1-51.1 52.5-72.2 64.1-19.6z"],
    "user": [448, 512, [128100, 62144, 62470, "user-alt", "user-large"], "f007", "M245-1c-164.7-22.1-204.3 184.5-57.9 246 90 29.8 188.1-55.5 163-150-15.3-46.6-55.1-87.1-105.2-96zM160.4 110.7c.1-38.2 42.2-52.8 75.4-48.3 18.8 1.3 49 32.2 53 50.8 14.2 37.7-45 87.4-79.7 71.7-29.2-10.7-48.7-40-48.7-74.2zM125.6 391.5c63-17.1 151.9-21.3 212 3.6 17.2 6 49.6 65.6 46.8 83.6 0 17.7 14.3 32 32 32 56-6.7 25.2-78.5 7.7-110.8-22-47.6-74.2-77.2-122.5-80.7-116.9-18-312.1 .1-301.3 159.6 .3 41.8 63.8 41.9 64 0-1.4-46 15.3-73.7 61.2-87.2z"],
    "snowflake": [576, 512, [10052, 10054], "f2dc", "M320.9 28.4c2.1-17.5-10.5-33.5-28-35.5-48.7-2.6-36.1 61.9-36.8 92.2-18.8-18.3-35.6-34.7-42.4-42.3-28-31.1-75.5 11.3-47.7 42.6 17.9 19.8 73 71.4 92 91.6 .4 15.9 1 31.6 1.5 47.3-21.4-.1-42.4 .3-63.5 .4-28.3-29.6-54.7-60.3-84.6-89.3-12.7-12.3-32.9-12-45.2 .7-29.8 34.5 21.4 60.9 40.2 86.2l-.7 0c-30.9 .1-90.2-16.7-90.6 31.3 4.1 42.1 54.4 27.6 84 32.4 3.5 .2 7.1 .4 10.7 .7-13.7 14.1-27.6 27.9-41.4 41.9-29.2 29.9 16.1 74.6 45.6 44.9 27-26.9 52.4-53.2 79.7-83.6l0 0c.3-.4 .6-.7 1-1.1 22.3-.1 44.6-.4 66.6-.4 .2 14.4 .3 27.5 .5 42.5-14.7 15.3-26.9 31.5-41.9 44.2-24.1 28.7-85.3 56.9-52.4 96 37.5 31.1 64.7-26.8 95.7-48.8 .6 33.1 1.1 61 1.1 72.9 .2 41.9 63.8 41.9 64 0 0-9.3-.3-29.3-.7-54 21.9 18 47.3 57.2 76.9 29.7 32.5-37.6-28.6-67.8-50.2-91.5-9.7-8.5-19.1-16.8-28.1-25.1-.4-24.8-.5-44.6-.8-66.9 14.4-.4 28.8-.8 43.1-1.3 .8 1.2 1.7 2.4 2.7 3.6 26.9 31.2 55 62.1 84.1 89.5 30.1 29 74.5-16.6 44.5-45.9-17.2-16.6-33.1-32.4-48.6-49.6 31.2-4.2 88.8 13.7 91.7-32.8-1.6-42.4-51.7-30.7-80.5-31.5 20.3-22.6 71.7-54.8 38.3-87.5-32.5-26.3-55.5 17.8-77.9 36.6-16.8 16-35.4 35.3-49.3 53.5-16.7 .5-33.4 1.1-50 1.5l-.2-6c-.5-15.9-1.1-32-1.5-47.8 29.2-27.6 58.2-58.2 88.9-85.8 31.9-27-9-75.8-41.2-49-18 15.2-33.6 32-49.6 47.4-.8-18.2-1.2-36.5 .9-53.7z"],
    "skull-crossbones": [512, 512, [128369, 9760], "f714", "M223.5 37.4c-62.8 18.7-95.5 76.4-95.2 140.4 39.2 40.7 54.9 55.1 60.9 111.7 43.7 4.4 74.4 1.9 116.1-1 4.4-32.8 8.4-68.8 37.1-88.4 14.4-10.1 28.1-17.3 41.9-25.9 .1-32.9-2.1-58.4-14.3-84.6-25-44.8-96.3-68.6-146.6-52.3zM128.3 322.3l0-.3c-2.3-24.3-7.1-44.1-11.5-67.9-6.5-6.8-14.3-13.7-21.9-20.4-11.7-11.4-31-22.7-30.7-41.8-10.3-111.8 78.1-227.7 196.4-224.3 132.3 7.4 198.9 96.8 187.5 224.4 .4 23.7-27.7 34.1-43.4 44.5l-.1 0c-10.4 6.9-20.6 10.4-27.6 18.6-1.7 3.9-4.6 15.2-6.8 30-4.7 32.5 4.5 62.3-33.3 66.4l-.5 0c-13.7 .4-33.1 .9-46.5 1.6l-.3 0c-.2 0-.2 0-.2 0-37 5.1-76.2 2.2-110.2-.2-22 .2-49-3.9-51-30.7zM235 122.9c11.2 16.1 4.2 39.4-13.6 47.1-44.1 26.3-72.5-42.2-26.7-58.2 14.1-6.7 31.4-2.2 40.3 11.1zM335.6 144c-1.7 13.1-8.7 20.5-16.6 25.6-32.1 22.6-69.2-23.6-39.7-50 20.9-17.6 61.2-9.5 56.4 24.4zM482.2 372.4c6.2 16.6-2.2 35-18.8 41.2-33.5 12.6-67.3 24.1-101.2 35.4 32.6 13 65.5 25.5 98.2 38.3 16.5 6.2 25 24.6 18.8 41.2-13 33.8-49.9 16.7-73.4 6-22.1-9.2-44-17-65.9-25.5-24.2-9.3-47.6-18.4-70.3-25-34.6 13.7-69.2 22-102.5 30.1l-.1 0c-34.4 7.6-64.3 18.4-98.8 32.7-16.4 6.6-35-1.2-41.7-17.6-6.7-16.4 1.2-35 17.6-41.7 32.6-13.6 69.5-27.3 106.6-35.3-35.6-14-76.1-26.8-111.8-41.8-38.3-16.8-13-75.2 25.5-58.7 66.5 25.3 128.5 50.9 200.1 64.9 28.4-12.4 59-22.4 87.6-31.7 30.7-9.9 58.8-20 88.9-31.3 16.5-6.2 34.9 2.2 41.2 18.8z"],
    "ticket": [512, 512, [127903], "f145", "M64.2 155.8l0-58.8c128-2.7 255.4-.8 383.7-.8 0 17.8 .1 35.7 .2 53.4-42.6 20.4-60.4 72.1-62.1 106.7-2.3 46.7 30.8 81 62.9 99.6 .2 12.7-.2 24.7-.5 37.4-.2 7.1-.4 14.4-.5 22.1-87.1-1.9-173.4 4.1-259.9 1.2-41.3-.8-81.2-.9-123.8-.7l0-61.4c77.7-45.3 76-155.9 0-198.8zM261 31.8c-69.4-.3-138.8-.7-209 1.6-29.6 1.3-52.7 29.1-51.8 55.8-.1 1.8 0 58.7 .1 71.7 1 24.4 17.8 42.5 32.8 50.9 34.3 19.8 34.1 70-6.4 90.9-39 25.8-23.6 76.6-26.4 123.7 1.1 36.9 36.3 58.4 71 53.6 127.6 2 254.9-.3 382.9-.4 45.7 .5 62.3-42.9 58.2-81.7 2.1-33.6 4.4-80.7-29.9-96.4-26.5-14.9-41.2-35.1-26.7-68.4 4.7-12.7 10.7-20.1 16.3-23 13.9-7.2 40.1-25.4 39.9-57.8-.1-21-.3-42.6-.2-63.3 .2-31.1-25-56.9-56.5-56.7-14.5 .1-30.7 .1-38.3-.2-50.7-.7-104.9 .4-156.1-.2l0 0zm-6.9 284.7c-35.2-.3-44 49.8-11.4 62 2.4 .9 3.6 1.3 6.2 2 49.7 10.6 55.8-63.6 5.2-64zm3 63.9c-1 .1-2 .1-3 .1 .2 0 2.1 0 3.5-.2l-.5 .1zM246.6 222.5c-41.7 11-25.1 72.9 16.4 61.9l0 0c2.5-.6 3.8-1.1 6.2-2 38.6-15.4 17.5-73.8-22.6-59.9zm7.7 61.8c1.3 .2 3.3 .2 3.5 .2-1.2 0-2.3 0-3.5-.2zm-.2-94.7c55.6-1.2 39.8-82.3-11.4-62-1.4 .5-5 2.2-7.5 4.1-24.6 16.8-11.5 58.7 18.9 57.9l-.1 0zm3-63.9l.5 .1c-1.3-.2-3.3-.2-3.5-.2 1 0 2 0 3 .1z"],
    "wheelchair": [448, 512, [], "f193", "M218.1-32.8c4.3 .7 10.5 2.6 16.3 7.1 18.5 7.2 23.4 30.4 22 42.5-2.6 30-24.9 43.3-52.3 45.9-36.3-3.1-42.5-30.2-43.7-51-.9-26.8 29.3-48.4 57.8-44.5zM209.7 93.5c47 2.1 58.4 61.7 91.5 78 13.6 5.2 26.6 5.2 37 .6 16.2-7.1 35.1 .3 42.2 16.4 17.1 55.9-70 57.9-102.1 42.7-28.9-12.4-38.9-27.2-54.2-45.9 3.1 28.4-2.5 59.7 2 87.3 21.4 10.3 58 9.8 84.1 11.2 127.2-8.3 120.4 96.3 97.8 184.7-3.3 17.4-20 28.8-37.3 25.6-27.8-5.1-29.2-34.6-21.6-56.7 5.2-20.3 14.4-73.6 2.1-85.1-.2-.2-.5-.5-1.2-.8-8.9-3.4-26-2.8-41.6-3.7l0 0c-51.7-1.9-137.4-1.2-146.3-68.4-4.4-34.3 1.6-62-2.3-94.7-7.4-36.1 1.4-90.7 50.1-91.2zM125.1 256.7c7.7 15.9 1.1 35-14.8 42.8-14.7 7.1-22.2 13.9-27.8 21.4-6.2 8.4-11.3 19.6-18.2 39-12.1 27.1 8.6 89.1 34.4 103.5 53.7 37.3 133.7-4.2 155.2-60.4 16.4-38.5 75.1-13.7 59 24.9-30.1 67.1-92 112.8-166.2 114.4-159.4 .1-205.6-231.8-64.4-300.2 15.9-7.7 35-1.1 42.8 14.8z"],
    "volume-off": [448, 512, [], "f026", "M293.6 108.1c-49 27.6-90.1 69-142.7 78.8-12.4 2.4-45.4 .8-58.1 .8-4.5-.1-8.2 3.6-8.1 8.1 0 42.4 3.1 73.8 3.1 117.6 .1 4.9 3.7 7.6 6.6 7.7 15.3 .7 26.3-.4 39.4-1.3 66 .2 101.5 57.8 159 87.4-5.4-100.3 2.3-198.3 .8-299.1zm-15-67c31.1-22.9 79.1 .6 78.6 40 .4 21 .9 56.2 .9 77.5-2.6 91.4-5.4 178.6-.4 270 5 38.8-40.1 75.4-74.6 49.4-40.9-28-87.1-57.3-122.7-86.2-7.4-5.8-16-8.5-23.8-8.2-139.3 18.2-109.6-85.8-115.9-181-3.5-42.4 29.9-79.8 72.9-79 2.4-.2 44.7 1 45.7 .2 13.5-2.5 21.9-5.8 34-14.2 26.2-18.1 79.6-50.7 105.3-68.6z"],
    "bookmark": [384, 512, [128278, 61591], "f02e", "M303.1 67.1c-59.4-4.8-148.2-9.7-210.7-8.5-17 .3-31.6 14.2-31.6 36.7 .1 101.2 .1 221.5 0 318.5 36.5-28.8 70.4-60 109.3-87.9 10.1-7.3 23.6-8 34.5-1.9 37.1 21.2 83.4 48.3 118.8 74.7-4-105.9-8.1-211.3-7-316.6 0-8.4-6.1-14.5-13.3-15.1l0 0zM91.2-5.4c65.7-1.3 156.9 3.8 217.1 8.7 41.6 3.4 72.2 38.4 72.1 79-2 130.2 6.5 259.1 8.8 388.8 .9 26.2-32.7 42.1-52.4 24.7-43.4-43.6-90.9-74.3-145.8-105.6-41.4 32.8-81.7 67.7-124.4 100.4-6.1 5-15.2 12.6-19.6 15.6-20.1 15-51.1-1.2-50.3-26.3 .1-160.7 .3-265.5 .1-384.5 0-51.7 37.1-99.7 94.4-100.8z"],
    "list-ol": [576, 512, ["list-1-2", "list-numeric"], "f0cb", "M22.1 63.3c.1-17.7 14.4-31.9 32.1-31.9l24.8 .1c65.3 4.7 45.4 78.8 52.7 129.3 42.2-7.4 52.6 57.3 10 63.3-34.8 4.5-56.4 1.3-87 1.2-51-5.1-36.5-73.8 13-63.9-1.1-20.4-2.7-46.1-3.9-66-20.6 2.8-42-9.6-41.7-32.2zM65.9 355c-55.8 8-56.8-70.8-.7-64l.1 0c87.1-6.7 106.9 56.4 63 118.9l20.6-1.3c41.7-2.4 45.7 61.2 3.9 63.9-17.6 1.5-40.2 2-57.7 1.3-21.3-.5-46.3 3.6-56-19.7-5.6-12.4-1.6-26.4 7-36.2 13.5-20 28.8-39.8 38.9-62.7-5.6-.5-12.9-.3-19.2-.3zM248.6 125.6c-41.9 1.1-43.6-62.5-1.9-64 86.8-2.6 173.5-4.4 260.6-4.1 41.9 .3 41.6 64-.2 64-86.1-.3-172.1 1.5-258.5 4.1zM531 285.4c-93.4-2.5-190.8-2.5-282 8.2-41.5 4.6-49-58.6-7.4-63.6 95.8-11.2 196.9-11 291-8.6 17.7 .5 31.6 15.2 31.2 32.8-.5 17.7-15.2 31.6-32.8 31.2zM326.5 450.5c-33.8-3.2-100.7 22.7-106.6-28.2 3-48.7 63.8-29.2 97.7-35.6 66.4-3.4 138-6.9 205.3 3.1 17.5 2.6 29.5 18.9 26.9 36.4-2.6 17.5-18.9 29.5-36.4 26.9-60.4-9-122.5-5.9-186.9-2.7z"],
    "bomb": [640, 512, [128163], "f1e2", "M542.6-64c17.7-.5 32.4 13.5 33 31.2l1 33.2 31.4 0c17.7 0 32 14.4 32 32.2s-14.3 32.2-32 32.2l-29.5 0 .8 27.3c.5 17.8-13.4 32.7-31 33.2-17.7 .5-32.5-13.4-33-31.2l-.9-29.3-34.5 0c-17.7 0-32-14.4-32-32.2S462.3 .4 479.9 .4l32.6 0-.9-31.2c-.5-17.8 13.4-32.6 31-33.2zM349.5 69.8c44.1-41.8 156.3 87.4 170.8 128.9 8.5 18.7-3.9 34.5-17.1 47.3l-4.1 5C552.8 497.7 234.7 611 99.8 404.9-9.9 246.8 150.2 19.9 338.2 74.2l5.2 1.8 6.1-6.2zm28.2 62.8c-16.8 21.3-39.9 10.1-60.4 2.4-126.1-34.2-243.6 124.7-162.5 236.8 67.6 101.4 222.6 106 277.2-14.7 10.4-18 12.8-80.3 2.1-98.3-11-19.4 6.1-38.4 18.2-52-16.5-26.8-47.8-57-74.5-74.3zm-78.4 72.2c1.4 17.7-11.7 33.3-29.3 34.7-11.8 0-32.5 25.2-30.4 39.2-.1 17.8-14.5 32.1-32.2 32-53.9-4.8-27.6-79.4-4.1-102.1 20.8-27.5 87.4-55.9 96-3.8z"],
    "trash-slash": [576, 512, [], "e2b3", "M13.8-26.5c13-12 33.2-11.2 45.2 1.8 28.4 30.6 57.5 60.6 86.9 91 46.3 45.2 85.8 95.4 136.5 137.1 99.3 91.4 201.1 182.4 290.9 283.1 27.5 31.2-19.7 73.9-47.8 42.6-132.7-149.9-291.2-270.4-425.7-418.4-29.3-30.2-58.8-60.7-87.7-91.9-12-13-11.2-33.2 1.8-45.2zm230.8 87c-48.8 8.9-61.9-59.4-11.7-64 77.6 .2 191.5-12.8 190.8 97.3 30.1 2.5 83.7-12.3 86 32.2 0 17-13.3 30.9-30.1 31.9-.6 29.1-1.6 56.9 .3 86 1.2 17.6-12.1 32.9-29.8 34.1-55.3-1.2-30-84.7-34.6-120.2-30.7-.3-75.6 0-106.8 .5-41.8 .4-42.6-63.3-.8-64l51.7-.6c.4-7.5-1.8-18.8-8.4-25.3-32-11.7-71.5-6.3-106.7-7.9zM135.7 228.4c17.7 0 32 14.3 32 32 .1 59.3-4.8 124.5 7.9 178.2 61 6.6 122.9 2 185.5 2 17.7 0 32 14.3 32 32s-14.3 32-32 32c-67.8 .1-135.6 5.1-205-3.9-14.3-3.5-26.3-9.2-36.5-26.1-19.6-56.6-16.7-121.9-16.3-179.2-.1-27-4.2-66.2 32.4-67z"],
    "airplay": [512, 512, [], "e089", "M421.3 415.9c-47.2 0-43.5-67.5 3.5-64.3 12.3-.8 21.5-10.5 21.8-21.9 1.4-46.4 1.4-92.1 1.4-138.4 0-26.9 0-54.1 .3-81.7 0-4.9-3.4-7.3-6.1-7.5-14.8-.6-30.9-1-47.5-1.3-104.2-3.6-211.6-9.8-320.1-4.2-3.6 .2-6.8 3.1-6.9 7.1-4.3 66.3-1.1 129.2 1.8 193 2.4 24.2-7.8 59 29.8 54.5 41.9 .2 41.8 63.9 0 64-70 3.5-99.2-51.5-93.8-116.6-3.2-65.7-6-132.4-1.8-197.8 1.7-36.8 31.1-66.6 68.3-68.1 82.2-3.3 177.6-3.2 255.4 1.8 65.8 8.1 182.1-21.9 184.8 75.8-.7 73.4 .5 147.7-1.7 221.3-1.3 48.4-42.2 84.7-89.3 84.3zM285 332.8l96 128c16 19.9-.1 52-25.6 51.2l-192 0c-67.6-11.1-8.4-84.6 15.5-114.3l56.1-66.4c12.5-15.5 38.5-14.8 50 1.5zm-27.1 70.5c-12.5 14.8-25.7 29.3-37.5 44.7l71 0-33.5-44.7z"],
    "volume-xmark": [576, 512, ["volume-mute", "volume-times"], "f6a9", "M239.7 129.5c11.2-7.1 22.8-14.6 33.4-21.4 2.8 84.4-6.2 164.6-2 248.6 .6 17.3 1.2 34 1.2 50.5-57.5-29.6-93-87.2-159-87.4-13.1 1-24.1 2-39.4 1.3-2.9-.1-6.6-2.8-6.6-7.7-.1-43.8-3.1-75.2-3.1-117.6 0-4.5 3.6-8.2 8.1-8.1l41 .5c51.4-.5 80.4-31.2 126.4-58.7zm47.1-97.4c-33.3 2.8-51.2 27.8-84.4 45.3-34.5 18.9-52.7 43-88.3 46.8l-41-.5c-43-.8-76.4 36.6-72.9 79 6.2 90.5-23.1 198.3 111.1 181.3 9.5-1.3 19.9 .9 28.6 7.9 35.5 28.9 81.8 58.1 122.7 86.2 16.1 13.2 44.8 10.1 58-4.6 18.7-16 17.4-44.9 15.7-65.9-1-59.5-4.2-115.9-.6-175.3 2.4-48.3 2-102.6 1-151.2-.4-27.3-22.7-49-49.9-49zm261 155.5c-32.5-31.7-63.2 18-84.5 38.6-7.8-8.1-15.8-15.9-23.4-23.3-.6-.5-12.6-12.1-13.7-13-30.5-28.6-74.3 17.5-44 46.4 12.6 11.8 26.5 25.5 38.1 37.6-18.3 23.9-67.2 47.1-40 81.4 31.3 32.6 63.8-15.6 85.1-35.9 22.8 18.6 51.2 68.7 83.8 38.2 30.4-33.9-19.5-61.1-40.9-85.8 18.1-24.8 68.1-50 39.5-84.2z"],
    "gauge-high": [512, 512, [62461, "tachometer-alt", "tachometer-alt-fast"], "f625", "M354.1 22.2c157.9 63.3 211.7 294.8 86.9 412.7-90.1 108.5-254.2 92-360.5 9.6-54.9-48.4-86.8-127.2-82-199.6 11-69.3 31.5-121.3 78.4-171.6 77.4-68.2 186.4-97 277.2-51.1zM327.5 80.4c-51.6-24.2-107.9-22.5-154.7 6.3-42.2 20.6-67.3 39.7-85.5 84.2-43.2 76.5-27.7 167.9 35.5 225.6 68 55.1 208.3 79.1 270.5-4.3 97.4-93.2 53.7-261.5-65.8-311.8zm27 60c38.8 26-4.6 65.7-16.6 96.4-11.7 22.2-23.9 45.2-36.9 67.5 35 33.9 10.5 94.5-32.3 108.6-75.8 22.8-112.9-104.2-33.9-122.8 16.2-25.9 29.8-51.7 44.1-78.8 17.8-25.5 31.4-92.3 75.6-70.9zM256.1 92.3c40.4-1.2 50.7 57.1 10.5 71.6-54.3 14.6-66.7-67.2-10.5-71.6zm-96 56c40.4-1.2 50.7 57.1 10.5 71.6-54.3 14.6-66.7-67.2-10.5-71.6zM108 259.3c-36.5 21.6-8.6 78.5 30.6 64.5 52.7-21.7 15.4-95-30.6-64.5zm276.1-7.1c40.4-1.2 50.7 57.1 10.5 71.6-54.4 14.6-66.7-67.2-10.5-71.6z"],
    "cloud-sun": [640, 512, [9925], "f6c4", "M440.8-51.6c15.1 18.6 28.4 37.1 44.4 52.3 12.9 .3 29.2 .1 41.5-.1 26.8-.5 48.4 20.9 49.3 47 .4 11.5 1.2 26.5 2.7 39.3 75.2 37.3 63.9 79.2 2.8 124.1l0 42.7c-.2 41.9-63.8 41.8-64 0l0-49.1c.5-29.4 19.8-39.1 38.8-56.5-17.9-10.2-36.3-19.5-39.7-43.1-2-12.8-3.2-27.6-3.9-40.2-23.9-.6-50.1 4.3-67.6-13.8-11.3-11-20.3-20-30.4-32.8-18.1 19.4-16.4 27.4-38.4 38.2-16 5.8-30.8 4.2-45.8 3.4-3.9-.2-10.1-.8-14.1-.3 .3 5.2 .6 10.4 1 15.2 4 41.7-59.3 48-63.7 6.4-.4-13-5-45 0-61.7 10.5-33.9 67.5-21.8 95.9-22.8 20.6-22 55.6-87.6 91.2-48.1zM382.2 116.8c25.5-31.3 55.8 3.2 77.9 19 14 10.7 16.8 30.8 6.1 44.8-25.4 31.3-55.8-3.2-77.9-19-14-10.7-16.8-30.8-6.1-44.8zM273.4 218.5c-49.3-22.2-107.3 29.2-107.6 80.6 0 14.2-9.3 26.7-22.9 30.7-11.1 3.2-35.6 11.6-42.6 15.6-32.8 18.8-53 79-17.1 107.9 64.5 43.3 187.7 30.4 262.6 16.7 34.6-5.3 94.6-30.8 91.1-71.2-3.5-41.1-13.8-63.6-40.1-73.3-5.8-2-13.9-3.6-20.9-6-17.4-2-39.9-27.9-48.9-45.8-12.6-20.7-32.2-48.3-53.6-55.3l0 0zM104.2 274.9c33.8-149.7 210.6-169.6 279.3-31.8 3.4 5.3 6.6 10.3 9.5 14.5 3.2 1.3 6.1 2 10.5 3.1 69.5 14 95.4 82.7 97.1 132.4 5.3 92.2-89.4 132.9-161.4 142.9-90.2 12.5-220.1 27.4-301.2-37.6-75.6-70.6-30.3-199 66.3-223.6z"],
    "arrow-right": [448, 512, [8594], "f061", "M200.5 89.7c-28.3-30.7 18.2-74.1 46.9-43.6 51.9 56.6 136.1 146 185 191.9 16.2 15.7 16 41.6 0 57.3-10.5 10.3-28.8 28.4-34.2 34.8-45.6 54.1-106.1 91.7-149.9 142.6-11.5 13.4-31.7 15-45.1 3.6-41.6-40.8 50.1-92 73.2-118.4 26.5-22.6 51.3-43.9 72-68.1-12.4-.3-24.8-.1-37.7 .2-80.9 .2-162.6 2.1-244.4 1.5-26.1 1.3-67.5 5.1-66.3-33.7 1.9-31.9 36.6-31.1 61.9-30.2 81.5 .5 162.8-1.2 245.2-1.5 6.9-.2 14.1-.3 21.7-.4-48.6-48.5-83.5-88.5-128.4-136z"],
    "file-minus": [384, 512, [], "f318", "M242 5.4c-10.3-.5-140.1-7.4-194-6.6-36.4 .4-56.1 34.6-49.8 67.1-.7 54.6 .6 80.2 2.7 117.7 5 74.2 3.4 182.3 3.4 273.6-.1 29.9 23.3 54.3 52.8 56.1 18.8 1.1 28.4 1.7 43 2.9 44.2 5.9 90-1.9 134.4 1.3 111.1 3.7 157.4 17.8 146.8-116.3-1.5-60.6 .7-122.3-1.9-182.4-4.6-29.8 7.8-59.7-9.2-86.8-10.3-16.3-24.8-35.6-38.2-52.4-25-29.6-45.4-69-90-74.1zM62.2 65.2c0-.8 0-1.6-.1-2.4 55.6 .3 160.3 5.7 175.4 6.5 15.4 10.8 30.7 32.3 42.8 48.1 12.9 16.8 22.2 27.9 34.9 47.6-1.6 21.2-.7 38.7 .2 58 2.5 60.7 .4 123.3 1.9 183.7 .4 16.8 .8 32.1-.1 48.3-26.9-.5-52.2 .4-79.5-1.5-18.8-1.6-42.2-1.3-60.9 0-24.6 1.8-45.2 1.2-69.8-1.1-13.5-1.1-22.4-1.7-38.8-2.7 3.1-150.1-4.7-244-6-384.6zM253.5 315.4c41.8-1.3 40.1-64.9-1.8-64-42.7 1.2-85.6 2.5-128.7 4.7-41.8 2.4-38.4 65.9 3.4 63.9 42.2-2.2 84.4-3.5 127.1-4.7l0 0z"],
    "shredder": [512, 512, [], "f68a", "M415.6 127l1.6-91.7C417.5 17.8 403.6 3.3 386 2.8 328 .3 188.7-.1 129.2 0 112.1-.4 96.8 14.8 97.2 32l0 96.2C43.5 127.6 1.4 172 2.6 224.1L5.1 382c.3 17.7 14.8 31.8 32.5 31.5 17.7-.3 31.7-14.8 31.5-32.5L66.5 223c-.3-16.9 12.2-29.8 27.3-30.6 102.9-5.4 240.5-3.4 318.1-1.5 16.3 .4 29.7 13.4 30.4 30.2l6.9 161.7c.7 17.7 15.7 31.4 33.3 30.6 17.7-.8 31.4-15.7 30.6-33.3l-6.9-161.7c-2.1-49.3-41.2-89.1-90.7-91.4zM161.2 126l0-61.9c41.3 0 151.6 .1 191.5 1.9l-1.1 59.7c-56.5-.9-125.6-1.2-190.4 .3zm96.6 386c17.7-.1 31.9-14.5 31.8-32.2l-.5-87.9 0-71.9c-.2-41.8-63.8-41.9-64 0l0 72.2 .5 88c.1 17.7 14.5 31.9 32.2 31.8zM129.2 320l0 160c.2 41.8 63.8 41.9 64 0l0-160c-.2-41.8-63.8-41.9-64 0zm257.7 .8c.2-41.8-63.4-42.5-64-.6l-1.4 160.4c-.2 17.7 14 32.1 31.7 32.3 17.7 .1 32.1-14 32.3-31.7l1.4-160.3z"],
    "battery-bolt": [640, 512, [], "f376", "M335.8 37c-1.9-30-45-39.7-59.4-13.2l-58.6 99.8c-31.1 49.4-64 99.7-99 144.8-6.6 8.5-8.4 19.7-5 29.9s11.8 17.9 22.1 20.7l74.6 19.7c2.8 26.1 10.9 108.2 13.6 135.6 1.5 15.1 13.4 27.1 28.5 28.7 15.1 1.6 29.2-7.7 33.8-22.2 6.3-21.3 38.2-85.3 51.6-102.8 32.5-43.8 62.8-96.1 88.6-143.9 11.2-18.9-2.2-45.3-24.1-47.3l-64.1-7.8c.8-45.1 1.3-101.2-2.6-141.9zM272.7 156.5l2.1-3.6c-1.2 78.8-10.9 84.4 72.8 91.7-21.2 39.1-46.7 74.3-71.1 110.6L271.8 310c-2.7-33-49.5-31.8-73.9-40.9 26.4-37.1 51.4-75.5 74.7-112.6zM200.1 95.3c-2.5-41.1-48.2-29.9-75.6-30.4-60.4 1.2-115.4 45.2-122.2 108.7-3.8 58.3-2.2 101.8 .4 163.3 3.8 65 58.3 110.5 120.5 110l19.2-.2c17.7-.1 31.9-14.6 31.8-32.2s-14.5-31.9-32.2-31.8l-19.3 .2c-78.1-1.1-53.9-99.3-58.3-145.6-2.8-47-.7-106.2 61.5-108.4l42.9-.9c17.6-.4 31.7-15 31.3-32.7zm173.3 1.1c2.2 42.6 43.1 31.6 78.2 35.7 16.6 1.2 26.8 11.6 27.1 29.2 1.1 45.3 1.2 110.7 1.1 163.4-.1 34.2-25.6 59.7-54.2 59.3-7.3-.1-15.7-.3-25.8-.6-17.7-.5-32.4 13.4-32.8 31.1-.5 33.2 33.9 34.6 57.8 33.4 69.6 1 118.9-59 119-123.2-9-91.3 38.1-242.8-87.7-256.5-36.1-.7-77-14.5-82.7 28.2zM576.1 192l0 128c.2 41.8 63.8 41.9 63.9 0l0-128c-.2-41.8-63.8-41.9-63.9 0z"],
    "arrow-rotate-left-10": [512, 512, [], "e836", "M313.1 6.8c-88.5-24.3-187.3 13.3-246 78.7l0-53.5C66.9-9.8 3.3-9.9 3.1 32l0 128c-.8 24.9 29.9 41.1 50 26.5 29.8-22.9 59.2-58.6 88.1-82.7l0 0c199.9-144.6 413.2 128.8 257 301.1-81 66.5-237.3 47.4-293.6-49.1-9.7-14.8-29.5-18.9-44.3-9.2S41.3 376.1 51 390.8c42.5 64.7 104.4 106 185 113.1 334.4 52.6 377.5-423.1 77-497.2zM170.3 164.7c-17.7 0-32 14.3-32 32 0 39.6-3.9 79.7-3.9 120.3 0 17.7 14.3 32 32 32 46-3 28.7-58.6 34-90.4l0-.2c-1.4-30.7 17.3-90.8-30-93.7zm119.8 123c-.1-15.4 .2-34.8 .5-51.1l24.5 .7c.5 15.2 1 33.5 .7 49-12.3 .9-19.8 1.6-25.7 1.4zM276.5 172.1c-68.6 .5-47.2 90.2-49.9 134.8 6.3 55.6 67.5 44.8 109.5 42 60.8-4.1 41.4-92.2 42.4-129.6-1.2-25.3-21.7-44.8-46.3-45.5l-55.6-1.7z"],
    "buildings": [576, 512, [], "e0cc", "M240.7-.6c40.5-6 79.2 25.7 79.3 67.7 63-1.7 126 3.3 186.4-4.4 85.8 3.6 69.9 95.1 68.7 152.2-2 43.9-1.7 166.2-1.6 215.8 0 44.2-35.8 80-80 80l-408.7 0c-42.7 0-77.9-33.6-79.9-76.3L.4 336.6C.6 284-.8 156 2.5 105.3-4-44.6 147.7 18 240.7-.6zm78.2 202.9c-3.3 68.4 1.4 175.9-3 244.4l177.6 0c8.8 0 16-7.2 16-16 .1-50.3-.6-173.6 1.6-217.9 .9-26.7 1.6-49 .9-81 0-2.5-2.2-5.1-5.7-5.1-63.6 8.6-123.8 2.1-186.2 4.4-.3 23.7-.8 47.5-1.3 71.1zM250.4 62.7c-56.2 7.6-114.5 3.2-170.1 4.1-17.8 2.3-12.1 29.5-13.9 42.6-3.2 47.5-1.7 175.8-2 225.1l4.5 97c.4 8.5 7.4 15.3 16 15.3l152.7 0c8.8 0 16-7.2 16-16-.2-62.3-.4-172.4 1.4-232.7 1-43.4 1.9-85.9 1-130.3 0-2.4-2.1-5-5.6-5zM137.5 193.3c-16.2-8.9-22.2-29.6-12.4-45.2 9.6-32.3 56.7-25.2 62 5.2 10.1 28.7-22.4 59.1-49.5 40.1zM425.6 185c18 4.3 29.1 22.9 23.7 40.4-.4 17.5-19.8 32.5-36.5 29.3-11-1.5-20.3-8.7-24.7-18.2-19.6-26.4 7.6-62 37.5-51.6zm25.5 158.7c.5 18.5-14.6 34-32.9 33.4-17 4.1-36.6-10.7-37.7-27.7-2-15.9 10.7-33.3 25.7-39 21.6-10 47.8 11.7 45 33.3zm-260-51.4c-1.7 16.8-16.1 29.2-32.7 28.7-44.4 9.2-46.1-53.9-12.1-66.7 24.4-10.5 49.6 14.3 44.7 37.9z"],
    "xmark": [320, 512, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M312.5 148.1c12.5-12.5 12.5-32.7 0-45.2-32-28.7-57.1 15.1-82 33.5-24.9 21-49.4 46.1-73.1 69.3-33.6-32.9-67.6-65.4-102.5-97.2-13.1-11.9-33.3-11-45.2 2-11.9 13.1-11 33.3 2.1 45.2 33.8 30.9 67 62.6 99.8 94.7-19.4 19-38.4 39.2-56.4 58.6-19.3 27.7-77.5 56.2-45.9 93.3 37.6 32.2 67.4-28.4 92.4-49.3 18.6-19.9 36.4-38.9 55.5-57.6 35 35 71.8 68.3 106.4 102.8 12.5 12.5 32.8 12.5 45.3 0 12.5-12.5 12.5-32.8 0-45.2-34.8-34.8-71.4-67.9-105.9-102.3 34.7-36.1 72.7-67.6 109.6-102.6z"],
    "lock-open": [384, 512, [], "f3c1", "M286.7 23.7C218.3-25.2 112.4 3 83.2 82.1 72.4 109.4 68.6 148.5 68.9 173.9l0 17.8c-46.7 5.6-71.6 51-68.6 95.6 0 48 0 143.9 5.3 181.2 5.1 31.8 46.9 43 62.5 42.4 77.9-2.5 153.4 3.9 231.8 4.3 43.5 5.6 94-30.6 90-81.8-4.4-37.8-4.6-77.5-5.2-114.8 15.3-174.8-138.5-121-251.8-128.8l0-16.9c-.4-20 3.6-51.6 9.6-66.7 7.8-19 22.4-33.1 41.7-39.8 6.9-5.1 56.5-1 61.2 6 11.2 9.4 16.2 18.1 17.3 26.9 2.2 17.5 18.2 30 35.7 27.8 55.3-12.1 15.1-85.7-11.7-103.6zM264.5 252.8c47.6-3.3 59.7 5.6 56.4 52-.5 16.4 0 34.3 .5 52.1 .3 27.5 1.1 53.7 4.4 78.5-.4 7.7 .3 6.3-5.1 12.8-72.4 10-151.9-6.3-226.7-1.4-9.2 .5-18.3 1-26.5-.1-1.5-49-8.2-132.3 .1-185.4 9.1-11.9 34.7-6.4 49.7-7.5 48.6 .4 98.6 .9 147.1-1z"],
    "droplet": [384, 512, [128167, "tint"], "f043", "M209.2 21.7c51.9 66 106.2 119.4 148.8 196.7 71.2 121.7-18.8 262.6-155.9 271.6-183.2 13.2-249.3-164.7-154.2-305.7 29.7-50.2 61.2-99.3 98.3-142.4 5.3-6.5 7.7-10.3 8.5-12.2 8.4-22 40.2-26.7 54.5-7.9zm-23.1 72c-35.9 43.9-63.6 90.8-92.3 137.8-25.5 36.9-31.8 104-14.6 142.5 49.2 80.4 190.4 63.6 229.3-18 43.1-98.8-70.3-187.6-122.5-262.2z"],
    "shop": [576, 512, ["store-alt"], "f54f", "M401.8-1c26 3 54.8-6.7 73.5 15.2 27 28.4 79.6 109.4 95.7 163.7 12.3 39.4-26.7 59.4-58.6 50.9 .1 80.9 1.4 170 1.4 251.2 0 17.7-14.3 32-32 32s-32-14.3-32-32c0-81.9-1.3-172.2-1.4-254.1-29.2-.8-61.9-1-95.8-1 .4 21.4 1.1 43.1 1.9 65.3 8.5 249.8 15.4 222.8-230.5 222-80.3-1.4-63.5-105-64.5-155.7 .7-8.7 1.7-95.9 2.2-125.7-72.6 8.2-65.7-50.3-41.7-98.4 6.9-16.5 15.1-32.3 23.5-48.5 17-27 32.3-81.9 72.6-84 95.3 2.7 189.6-3.1 285.6-1zm-276 229.9c-.4 27.2-1 64.9-1.4 92.9 60.8 .3 116.3 2.4 167.2-1-.3-9.1-.6-18.2-.9-27.4-.8-22.7-1.6-45.6-2-68.1-58.8 .7-116.9 2.1-162.8 3.5zm269.9-166c-89.8-2-179.4 3.8-267.5 1.1-9.4 13.5-16.9 28.2-25.4 45-7.3 14.4-16.1 30.2-22.4 45.6-1.6 3.6-3.3 7.5-5.2 11.8 90.9-3.1 303.3-9.1 421.1-2.8-15.4-37.3-42.2-74.7-62.9-99.8-13.1-.2-25.5-.6-37.6-1zM123 385.8c.2 19.2 1.2 42.2 2.6 62.5 54 .3 125.9 .1 165.5-.1 1.3-20.7 1.8-41.9 1.8-63.3-51.5 3.4-108.7 1.2-169.9 .9z"],
    "film": [512, 512, [127902, 62368, "film-alt", "film-simple"], "f008", "M431.3 30c-38-1.4-102.2-1.9-210.5 1.1-31.9 .9-66.4 1.5-100.7 1.5-65.4 0-118.2 54.4-117.3 119.5 1.5 71.4-3.1 142.9-3.7 214.1-.3 63.2 52 111.6 113.1 111.6 101.3 2.6 198.4 4.4 295.8 2.4 73.8 .1 117-69.2 107.9-138.6 1.2-63.6 2.3-127.6 1-190.9 5.1-55.5-19.5-119.3-85.5-120.6zm-44.5 63c69.8-2.4 66.1 5.5 66.1 68.6-20.7 .4-47 .6-65 .3-.4-20.6-.8-50.2-1.2-68.9zm-64 .1c-1.6 113 11.1 220.1 2.4 323.9-42.1 .2-84-.1-127.3-1.1-.6-95.6 3.7-193.3-1.8-288.5-.8-11-1.6-21.5-2-31.6 42.8-1.1 94.6-2.5 128.7-2.7zm67 323.3c2.5-21.1 3.1-42.8 2.8-63.9 23.2 .1 42.9 .3 59 .4 5.3 41.4-18.4 68.6-61.9 63.5zm62.8-127.5c-8.8 0-17.6-.1-26.5-.2-11.8-.1-23.7-.2-35.6-.2-.7-19.3-1-36.5-1.5-62.6 19.3 .3 44.4 .1 64.5-.3 .2 21-.3 42.1-1 63.3zM133.8 414c-44.6 5.3-77.2-18.4-70.6-64.4 15.5-3.1 35.3-2.3 53.4-1.4 5.7 .3 11.7 .6 17.6 .8-.2 21.6-.4 42.8-.4 65zM65 284.8c.7-20.4 1.2-41 1.5-61.6 20.2 .5 48.1 1.5 67.8 2.3 0 19.9 0 39.8 0 59.6-23-.9-45.1-3-69.4-.3zm1.7-125.6c-4.6-36.9 26.9-67.1 63.2-62.5 .8 22.1 3.2 43.5 4.1 64.7-19.3-.7-47.3-1.8-67.3-2.2z"],
    "comments": [640, 512, [128490, 61670], "f086", "M431.8 96.1c-35.7-93-152-126-238-120.3-175.2 19.1-230.4 149.7-146.1 295.6-.5 18.8-3.6 38.7-8.2 58-1.4 5.9-3.3 13-4.6 18.8-3.8 14.5 5 30.4 21.6 37.4 6.3 1.3 17.7 .5 22.4-1.2 32.8-12.6 70.3-27.2 102.9-39.9 148.8 20.4 312.4-84.8 250-248.4l0 0zM199 39.6c234-13.8 248.1 249 9.9 242-32.4-7.4-70.3 9.9-99.8 22.8 1.8-19.2 6.7-44.4-3.8-60.9-62.3-109.8-37-187.7 93.6-204zM545.6 190.4c-33.8-24.6-71.6 26.5-38 51.5 47.5 36.9 59.7 57.1 61.3 117.6 3.4 34.4-21.2 57.3-32.2 79.6-8.9 18.4-2.3 28.6 1.8 50.2-22.4-4.4-42.7-22.1-66.3-18.5-43.5 11.5-90.4 7.4-127.2-14.1-23.5-10-54.4-23.1-66.6-46.3-21.4-35.9-76.3-3.5-55 32.6 21 36.1 55 55.5 91.4 70.2 50.4 27.7 109.9 34.6 162.5 21.8 17.2 7.5 34.4 12.9 52.5 18.7 10 3.2 21 6.8 31.2 9.6 29.6 8.1 55.2-18.4 49.2-46.6-4-18.6-9.2-42-12.4-55.8 67.3-88.2 36.1-212.4-52.1-270.5z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M411.6 42.1C260.3-63.4 29.4 31.7 3.8 216.7-35.9 408.7 208.4 587.1 380.7 479.2 534.6 407.5 556 138.5 411.6 42.1zM228.1 67.5c160.6-31.3 246.9 101 206.3 250.9-8.2 45.7-39.4 79.1-85.2 105.2-75.9 45.2-164.7 23.7-228.5-39.6-112.1-103.9-45.3-294.8 107.4-316.5zm136.5 166c31.5-27.5-10.1-75.6-41.9-48.4-26.7 22.8-69.1 58.8-90.5 85.2-2.5 2.7-5.6 5.4-8.6 8.3-9.5-8.3-17.2-16.6-23.8-26.5-23.2-34.8-76.3 .4-53.3 35.4 25.8 35.5 67.4 83.2 109.5 48.3 38.7-36.9 65.2-67.5 108.7-102.2z"],
    "moon": [512, 512, [127769, 9214], "f186", "M261.9 49.6c20.4-19.1 3.9-56.8-24.3-54.4-30.8 1.3-64.5 .9-100.4 22.8-115.9 72.6-168.4 207.8-122.9 341.3 49.8 122.3 190 174.8 312.3 149.7 43.7-13.8 102.3-45.9 134.1-80.1 9.2-13.8 18.9-29.8 26.5-44.4 13.2-27.3-19.2-56.6-44.8-41.2-23.9 10-75.3 1.4-92.4-9.2-52.1-30.2-97.2-56.8-113.3-131.1-17.7-70.8-.9-100.4 25.2-153.5zM182.9 66.5c-39.1 85.8-8.9 219.7 67.2 278.1 42 30.3 80 60 133.8 65.3-47.8 30.4-79.1 47.6-137.1 39.2-223.2-9.1-243.2-291.4-64-382.7z"],
    "file-plus": [384, 512, [], "f319", "M220 260.1l0-36.1c0-17.7-13.2-32-29.5-32s-29.5 14.3-29.5 32l0 35.9c-24.8-.9-63.6-12-67.9 26.1-2.6 40.8 42.1 36.5 67.9 38l0 28.1c0 17.7 13.2 32 29.5 32S220 369.7 220 352l0-27.9c25.3-.8 64.7 5.1 64.9-33.8-2.2-38.6-39.8-30.7-64.9-30.2zM381.4 401.1c-.7-29.2-.4-57.4-.6-86.2l0-.1c-.3-32.1 .4-65.2-1.3-97.2-3.1-43.5 9.2-80.5-27.1-112.6-4.9-6.2-11.4-13.8-17.3-21-9.8-12-22.9-27.9-35.9-39.1 0 0-.1-.1-.4-.3-19-26.7-48.5-41.2-78.8-42.9-43-3.3-130.8-4.8-172.8-3.2-35.8 1.2-55.4 35-49 67.4-1.3 132.4-6.1 265.2 4.5 395.5 2 28.2 24.7 50.1 52.6 51.8 19.4 1.1 29.8 1.7 44.8 3 44.2 5.9 90.1-1.9 134.4 1.3 110.8 3.7 157.5 18 146.8-116.3l0 0zM317.3 455c-26.9-.5-52.3 .4-79.6-1.4-18.8-1.6-42.2-1.3-60.9 0-24.6 1.8-45.2 1.2-69.8-1.1-14.1-1.2-23.7-1.8-41-2.8-10.2-130.9-4.6-254.9-3.9-387.6 52.7 2.1 131.5-5.7 175.7 10 14.4 17.7 29.9 29.3 45.3 49.4 10.2 12.2 21.5 26.2 32 38.6-1.3 21.3-.4 41.1 .5 61.2 2.4 61.8 .4 123.9 1.9 185.2 .4 16.8 .8 32.1-.1 48.3z"],
    "closed-captioning": [576, 512, [], "f20a", "M374.3 97.8c-100.7-.4-175.2 1.9-305.3 .8-7.7 115 3.9 293.8 3.1 318.9 19.2 .4 29.9 1.1 46.2 2.3 130.5 5.4 255.4 2.2 392.5-1.7l4-92.3 0-.2c7.1-77.6-4.5-151.6-5.4-226.5-23-1.7-62.2-1.5-79.5-1.2-19.3 .2-37-.1-55.6-.2zm1.9-64c48 1.2 100.7-2.3 152.6 2.9 21.1 3.2 42.2 7.7 44.8 37.6-1.3 85.2 13.1 171.1 5.2 254.4l0 .1-4.6 106.8c-1.1 24.7-20.8 44.7-45.7 45.9-146.2 4.6-279 8-417 2-19.5-1.6-31.6-1.9-56.3-2.4-26.1-.6-47.1-22-47-48.2l.1-28.8c-.7-14.8-11.5-228.2-1.6-327 2.5-25.3 24-42.6 47.5-42.5 122.6 1.2 223.4-1.2 322.1-.8zM224.3 150.6c29.7-1.7 49.9 23.1 50.6 50.2 5.4 37.9-50.4 50.6-62 14.5-10.6 .5-14.8 .5-27.5 .2-.7 17.2-.8 32-.4 49.6 .1 10.3 .3 20.7 .1 31.6 9.2 .1 18.6-.1 28.4-.3 6.1-42 70.2-32.2 63.3 9.7-1.2 27.8-19.7 54.2-49.2 54-42.7 1.1-107.8 9.5-106.8-50.8 1.2-36.4-.8-73.8 1.3-111.1 4.7-58.3 60.8-44.7 102.4-47.7l0 .1zm237 168.6c-3.3 26.8-29.4 45.2-56.9 40.6-6.9-.4-12.9-.8-19.1-.8-52.1 5-78.6-11.3-76.4-66.1 3.2-90-28.2-154.2 95-142.5 35.3-3.2 58.5 19.3 60.4 54.2 6.9 41.9-57.2 51.8-63.3 9.7-9.8-.2-19.2-.4-28.4-.3 .4 27.6-1 54.1 .4 81.2 12.6-.3 16.9-.3 27.5 .2 16.7-41.3 73.6-18.7 60.8 23.7z"],
    "pen": [576, 512, [128394], "f304", "M354.3 100.4c-87.7 79.9-177.4 163.2-258.9 248.5-1.6 32.8-.4 64.4 2.8 97.1 28.1-2 55.6-5.7 84.5-6.8 .5 0 .8-.1 1.1-.2 .2-.1 .2-.1 .3-.2 72.4-77.3 147.9-150.8 223.1-225 28.5-29.7 78.6-61.5 85.8-102.3 2.8-26.4-34.7-56.6-61.8-54.9-25.8-.2-55.7 25.6-76.9 43.9zm.7-81.8c103.5-81.8 263.9 46.8 177.5 159.1-92.1 100.9-195.3 189.7-288.2 289.7-12.2 16.3-36.2 37.2-59.2 35.7-158.4 21.7-155.8-10.7-153.6-158 .7-14.1 6.1-27.5 15.5-38.1 35-39.9 74.8-76.6 112.5-111.5 65.1-59 122.7-125.4 195.5-177z"],
    "plane": [640, 512, [], "f072", "M236.8 32c13.9 40.2 35.6 73.3 52 112.2 1.8 4.5 7 17.3 10.7 26.6 10.2 25.7-7.9 54.3-35.7 54.6-31.3 .3-78.3-.3-91.6-.5-26.6 1.9-45.1-38-59.1-51-4.1-5.5-26.8-14.8-33.4-12.9 8.7 31.5 22.7 62.4 23.3 96-.7 31.8-15.2 62.2-28 90.2 6.9 .4 10.7 .5 14.4 .7l1.6 0c26.9-19.4 48.3-56.2 81.5-59.7 27 .3 71.7 .4 91.9 .4 26.3 0 44.7 25.8 37.4 51l-9.5 32.6c-12.5 36.4-30.4 73.4-49.5 107.8 14.1-.2 28-.4 42.3-.5 40.1-59.9 92.9-113.4 132.3-172 11-21.9 41.2-19.3 61.7-18.9 17.1-.4 35 .6 51.3-.4 34.1-4.5 53.6-5.2 45.1-37.2-14.2-32.3-66.9-25.4-99.8-26.3-18.2-.2-40.3 2.8-53.8-12-56.2-58.8-79.4-118.8-131.9-178.9-18.7-.8-36.1-1.5-53.2-1.8zm-70.5-5.1c-13.6-27.2 6.5-59.7 36.6-58.9 30.3 .1 71.9 1.5 100.3 2.8 11.1 .5 21.5 5.7 28.6 14.6 48.4 54 80.7 121.5 128 175.8 4.2 .1 9 .2 12.7 .2 56.6-3.1 145.1 2.2 163.1 72.8 9.8 32.6 3.4 69.8-22.3 91-42.7 35-99.9 25.8-150.1 27.2-35.4 49.1-73.8 92.1-109.6 138.7-12.6 17.7-28.4 48.4-53.5 51.2-32.8 1.7-68.1 2.7-100.9 .3-28.3-2.8-45.9-35.4-29.9-61.5 24.8-40.6 48.7-86 63.5-128.8-16.9-.1-36.1-.1-51.8-.3-28.7 20.2-48.6 58.1-85.5 59.7-10 .3-37.1-1.9-59.6-2.8-40.1-4.1-44.6-45.5-24.1-75.2 9.5-19.3 29.1-61 28.5-76.6 .6-4.9-6.9-37.3-9.3-42.1-14.5-44.7-42.9-109.5 18.1-117 61.1-5.8 100.1 12.4 134.9 63.6 11.3 .1 27.6 .3 44.1 .4-22.3-42.7-43.8-90.7-62-135z"],
    "images": [576, 512, [], "f302", "M246.2 385.2c26.8-1.4 51.1-2 78.1-1.9 69.6-1.1 141.2-3 212.6-.3 20.1 3.6 42.1-9.4 42-31.3 .9-46.3 1.7-108.1-.2-153.5-.5-47.1-2.4-93.4-2.7-141.1 .3-2.7-1.6-24.9-1.8-28.1-1.2-16.7-15.2-29.6-31.9-29.6-37.4 0-74.8 .6-111.9 1.2-89.6 3-179.5-1.9-269.1 1.3-27.2 2.1-32.4 26.4-30.2 49.5 2.4 40.3 2.4 80.4 2.3 122l0 14.5c.8 52.5-5.6 99.5 2.6 153.9 1.2 11.6 4 22.5 13.2 33.6 24.9 23.2 66.5 7.3 97.3 9.8l0 0zm-37.1-62.5c-3.7 .1-7.5 .2-11.2 .3-5.3-41.7 .3-91.3-.7-135.1l0-14.5c.1-35.5 .1-71.8-1.5-108.3 28.4-1.2 49.4-.7 76.8 0 52.4 1.6 106.3 .3 158.6-.5 27.1-.4 54-.9 80.8-1.1 .8 45.4 2.2 90.8 2.8 136.7 .7 24.4 1.4 48.2 1.3 72-40.5-35.7-82-70.4-117.4-103.5-13.6-13.4-38.1-10.7-48.4 5.5-21.7 27.5-53 54.5-75.7 81.1-21.6 23.3-42.4 45.7-65.2 67.3zm261.5-5c-57.9-1.2-111.3 2.1-168.4 1.7 7.3-7.8 14.6-15.6 21.8-23.4 19.1-20.6 36.1-38.8 55.5-57.9 23.5 20.6 62.2 54.2 91.1 79.5zM293.3 119.4c-28.8-38.4-78.9 1.9-54.6 41.2 29.4 46.7 98.8-3.2 54.6-41.2zm-21.2 58.1c.7 .1 1.4 .1 2.2 .1-.4 0-1.1 0-2.2-.1zM64.4 160c-.3-41.7-64.1-41.6-64 .4 .8 85.4 7.2 170.1 7.1 254.8 1.8 58.3 51.7 94.8 102.8 95.8 121.2 1.8 214.5 3.5 304.5-5.6 41.7 1.9 45.1-61.6 3.1-63.9-94.6 7.7-181.3 8-306.4 5.5-31.9-1.2-42.9-23.4-40.3-47.5 0-80.4-6.4-160-6.9-239.6z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M352 81.9C345.2 34.5 304.3 0 256.9 .3L193.4 .7c-69.1-.1-105.6 66.5-96.6 127.8-70.8-8-105 36.7-95.6 104.7 1.1 164.5 8.2 286.2 207.1 275.5 111.5 8.8 227-21.7 239.6-144.5 8.2-50.6 3.6-102.9 3.2-150.7 4.7-55.7-37.4-95.4-93.4-89.2-1.6-13.2-3.6-27.8-5.7-42.5zM293.4 126l0 0c-44.6 1.9-88.4 3.5-132.6 2.9-8.4-82.4 38.9-61.6 96.4-64.6 33.5-.5 33.1 38.3 36.2 61.6zm-15.6 64.7c35.9 .9 71.3-7.8 105.5 1.1 8.4 19.2 1.8 42.2 4.6 62.9 5.1 112-2 196.7-137 189.8-52.1-2.4-128.2 13.2-162.5-32.8-29.3-64.4-20.3-143-24-211.8-.1-3.9 3.1-7.5 7.8-7.5 68.3 .4 137.7 1.7 205.5-1.7l0 0z"],
    "phone-volume": [576, 512, ["volume-control-phone"], "f2a0", "M326-39c96.2 2.4 195.4 50.4 236 145.4 17.6 31.6 41.8 112.5-18.4 109.9-17.4-3.1-28.9-19.8-25.8-37.2 .4-2.3 .4-7.5-2-16.2-6.4-25-30.1-62.7-43.3-78.6-25-32.9-105.3-60.7-146.5-59.4-41.9-.2-41.8-63.8 0-64zM155.1 78.9c-49.8 50-84.1 131.2-56.2 191 28.8 52.3 56.4 89.9 98.1 131.7 34.6 39 161.4 67.2 207.3 38.7 24-12.9 42.3-30.5 63-54-8-7-18-14.4-27.8-21.9-10.7-8-22.7-17-34-27.2-44.1 56.3-105.7 51.1-155.4 13.1-45.4-38.1-118.8-100-85.7-172.5 11.4-20.7 24.3-36.1 37.9-53.5-15.7-21.1-28.7-31.5-47.3-45.5zM127.9 19.2c24.2-17.5 51-6.1 70 11.9 21.6 15.2 43.3 37.8 57.2 56.8 19.9 21.1 16 51.8 2.5 69-11.7 16.9-28.1 34.4-37.4 52.4-5 21.9 38.2 64.7 54.1 78.1 15.8 14 42.2 33.9 59.9 26.9 10.8-5.8 14.8-9.1 23.2-19.2 15.1-29.1 53.5-41.1 79.3-16.4 13.8 13.8 24.8 22.4 42.1 35.3 42.2 29.9 82.6 62.1 37.5 113.7-53.1 70.4-140.9 105-231.4 82.1-120.7-19.6-186.8-111.7-242-208.9-44.5-91.9 .3-193.8 58.2-257.9 7.8-10 17.6-17 26.8-23.7zM400 148.4c-19.5-13.9-33.7-18.8-50.8-16.7-41.5 4.8-49.1-58.5-7.6-63.6 72.5-6.9 143.3 46.7 141.3 118.8-.2 41.8-63.8 41.9-64 0 0-18.1-5.4-28.9-19-38.5z"],
    "phone": [512, 512, [128222, 128379], "f095", "M234.8 84c6.7 15.6 11.2 35.6 4.8 55.6-10.4 32.5-27.2 37.8-36.7 68.1-6.7 14.2 8.6 54.2 20.3 64.6 36.8 43.2 93.4 35.7 136.5 7.8 44.6-35.5 86.3-1.4 108.3 36.3 21.2 28.1 42.9 67 19.8 105.2-87.5 129.1-280.5 100.6-376.8 6.8-78.9-69.8-111.4-159.7-110.5-259.4 4-59.8 38.9-142.8 102-166.6 57.9-12.3 109.3 33 132.3 81.4zM120 64.3c-144.8 126.5 14.1 382.6 182.3 380.4 57.4-.4 112.1-18.7 131.5-58.4-3-16.2-23-40.6-34.9-55.3-67 48.6-167.9 50.6-222.7-15.3-28.9-33.6-48.5-83.5-33.4-129.9 3.7-19.6 28-47.7 35.9-65.7-1.8-22.7-34.9-56-58.7-55.8z"],
    "id-card": [576, 512, [62147, "drivers-license"], "f2c2", "M228.8 .2c86 0 175.4 10.9 260.9 14 38.4 1.4 72.3 29.5 77.7 69.4 16.1 124.6 9.2 224.4 2.3 356.4-3.1 41.5-38.1 71.5-78.2 71.2-17.3-.1-35.5-.3-54.1-.5-135.8-4.2-237.3 6.1-367.6-1.6-41.5-3.7-70.8-42.3-69.1-80.2-.3-89.4-.9-283.5 2.4-358.9 2.3-31.2 25.5-57.1 58.7-60.5 65.6-7.8 107.1-8.5 167-9.2l0 0zM487.5 78.1c-36.4-1.3-73.7-4-110.3-6.7-108.2-8.4-200.7-11.5-309.9 1.9-1.7 77.2-6.9 276.1-.1 366.3 34.3-58.1 114-86.1 172.2-80.7 32.6 0 78.3 7.3 108.6 40.4 10.6 12.1 26.7 29.7 34.2 46.8 38.4 .3 76.1 .8 109.8 1 8 .1 13.5-5.6 14-12.1 4-52.2 6.7-123.8 6.3-158.1 0-65 2.5-119-8.2-184.8-1-7.2-7.4-13.7-16.5-14zM303.8 445.9c-32.4-36.6-126.7-27.3-158.6 2.2 58.1 .9 99.9-2.4 158.6-2.2zM136.3 154.6c83.4-103.7 249.3 20.1 165.9 134.2-31.6 43.9-100.8 49.3-145.4 20.2-49.9-35.8-58.6-107.3-20.4-154.4zM210.9 180c-43.1 3.5-48 82.2 3.6 82.6 27.5 1.7 37.7-6.2 44.6-31.7 8.9-29.4-22-50.7-48.2-50.8zm238.1 47.9l-52.3 2c-41.9 1.4-44.2-62.2-2.4-64l52.3-2c41.9-1.4 44.2 62.2 2.4 64zm-60.8 95.9c-50 7.8-54.2-65.8-3.7-63.9 27.5-1.5 92-9.3 86.1 37.8-9.3 40.7-50.2 20.6-82.4 26.1z"],
    "leaf": [512, 512, [], "f06c", "M446 32.2c-8.8 0-20.1 2.3-25 3.2-64.4 13.4-141-.8-205.3 21.7-57.9 10.8-114.9 33.9-149.8 86.6-47 75.7-34 181.4 14.8 246.1-1.1 1.1-2.2 2.1-3.3 3.2-20.3 25.5-77 52-46.9 89 35.9 33.1 67.3-24.9 93-44.6 1.2-1.2 2.3-2.3 3.5-3.4 213.7 138.8 350.1-74.7 341-278.8-5.9-39.3 35.9-118.2-22-123zM174.8 388.6c32.6-32.4 60.5-65 93.2-98l19.7-18.8c12.8-12.2 13.2-32.5 1.1-45.2-12.2-12.8-32.5-13.2-45.2-1.1l-20.7 19.8c-31.6 31.8-62.8 68-95.2 99.9-27.3-41.2-38.9-109.3-9.6-164.3 27.4-42 69.8-52.5 116.5-62.7 59.3-19.1 112.3-7 173.2-16-2.7 25.4-3.6 50-4.5 74.8 2.9 83.5-27.3 178-99.4 227.4-30 20.5-97 3.9-129-15.9z"],
    "heart-half": [576, 512, [], "e1ab", "M146.1 104.6c40.4-9.2 89.3 4.7 118.6 42.9 25.5 33.2 76.1-5.6 50.8-38.8-90.2-123.8-310.1-77.4-296.9 86.9 7.3 78.4 73.5 136.2 121.5 189 34.1 37.1 74 74.7 116.2 104.8 14.4 10.3 34.4 6.9 44.6-7.5 10.3-14.4 6.9-34.4-7.5-44.6-37.6-26.8-74.2-61.1-106.3-96-35.8-39.1-100.5-98.9-104.7-149.7-2.2-48.6 20.6-75.9 63.6-87z"],
    "universal-access": [512, 512, [], "f29a", "M476.4 150.1c-65-187.8-338-209.2-423.1-33.6-123.2 229.1 40.4 436.5 292.4 378.4 70.6-14.3 112.6-82.9 141.8-136.4 34.1-71.9 14.4-144.6-11-208.4zM220.1 61.8c129.5-20.4 209.9 81.6 220.4 199.1 5.2 59.2-21.2 92.4-53.3 134.6-17.3 20.2-35.2 32.9-54.1 36.6-95 17.8-168 11.3-232.3-67.2-62.9-93.8-1.6-283.5 119.3-303.1zm29.1 24.9c-40.4 1.8-57.4 63.2-19.3 79.4 34.7 12.3 79.5-24.7 55.3-59.8-7.2-12.2-19.7-19.9-35.9-19.5zm-91 165.8c10.2 1 20.4 1.5 30.6 1.7-1.2 42 4 78.1 2.5 118.3 .1 31.4 47.9 31.4 48 0-.2-13.2 .4-40-.5-52.9 9.2-.3 21.4-1.2 31.2-1.9 .1 8.9 .2 16.7 .2 22.3l0 .4 .5 35.3c.6 31.3 48.3 30.7 48-.7-.5-36.7-.9-86-1.3-124.4 19.5 .6 49.1 5.8 51.2-21.3 .9-13.2-9.1-24.7-22.3-25.6-62.3-4.4-123.1 6.5-183.7 1-31.2-2.8-35.7 44.8-4.4 47.8l0 0z"],
    "volume-low": [512, 512, [128264, "volume-down"], "f027", "M256 389.2c11.2 7.2 22.8 14.6 33.4 21.5 2.8-84.4-6.2-164.6-2-248.6 .6-17.3 1.2-34 1.2-50.5-57.4 29.6-93 87.2-159 87.4-13.1-1-24.1-2.1-39.4-1.3-2.9 .1-6.6 2.8-6.6 7.7-.1 43.8-3.1 75.2-3.1 117.6 0 4.5 3.6 8.2 8.1 8.1l41-.5c51.4 .4 80.4 31.2 126.4 58.7zm47.1 97.5c-33.2-2.8-51.2-27.8-84.4-45.3-34.5-18.9-52.7-43-88.3-46.8l-41 .5c-43 .8-76.4-36.6-72.9-79 6.2-90.5-23.1-198.4 111.1-181.3 9.5 1.3 19.9-1 28.6-7.9 35.5-28.9 81.9-58.1 122.7-86.2 16.1-13.1 44.8-10.1 58 4.6 18.7 16 17.4 44.9 15.7 65.9-1 59.5-4.2 115.9-.6 175.3 2.4 48.3 2 102.6 1 151.2-.4 27.3-22.7 49-49.9 49zM443.4 359.4c-34.5 23.6-70.8-28.6-36.4-52.6 28.3-19.6 39.9-35.7 37.5-57.6-2-18.9-13.1-35.5-30.2-46.5-14.9-9.5-19.2-29.3-9.7-44.2 41.7-49.2 101.5 40.4 103.6 83.8 6.4 59.2-32.5 94.8-64.7 117.1z"],
    "hourglass": [512, 512, [9203, 62032, "hourglass-empty"], "f254", "M463.9 63.6c41.7 0 42.2-63.7 .3-64L47.3-2C5.5-2 5.1 61.7 47 62l14.1 .1c7.6 83.5 70.3 135.4 137.3 180.9-50.7 40.8-95.7 98.3-118.5 161.8-4.2 11.3-11.2 29.9-12.9 48.2-22.3-2.7-48.6 4.7-49.1 31.2-.4 37.4 42.5 34 68.5 32.2 120.1 .6 241-2.5 360.8-3.6 64.3 12.1 68.1-71.2 2.6-64-4-86.4-51.6-137.8-133.7-204.6 71.1-37.1 122.7-97.1 140.2-180.6l7.6 0zm-74-.3c-2.1 7.6-4.6 15.9-6.4 22.2-19.4 54.5-74.9 92.6-126.5 118.8-52.6-34.7-121-74.5-131.2-141.9l264.1 1zM370.7 394c11 20.2 14.8 37.8 15.2 55.2-84.3 2.5-170.1 3.6-254 2.8 1.7-7.5 5.2-16.8 9.4-28.4l.2-.5c21.2-55.5 64.4-109.2 115.6-143.5 65.2 48 97.7 85.1 113.7 114.4z"],
    "fish": [576, 512, [128031], "f578", "M505.6 18.5c-122.3-53.2-334.1 11-359 159.3-3 23.6-5.8 51.4-7 77.7l-15.6 3.9c-35 8.6-80.9 29.2-110.4 50.2-9.5 6.8-14.6 18.1-13.3 29.7 1.3 11.6 8.8 21.5 19.6 26 13.4 4.9 31 23.6 43.8 39 24.3 28.8 51.6 50.5 75.2 84.1 36.5 45.6 81.3 87.6 120.6 17 8-15.2 21.4-48.3 33.9-75 119-15.7 224-96.8 243.9-215.6 12.7-60.7 7.8-126.6-15.9-180.3-3.1-7.1-8.7-12.8-15.6-16l0 0zM210.1 185.8c8.2-89.3 182.2-145 257.2-113.8 46.9 140.8-33.7 278.1-183.2 295-47.5 1.7-60.4 68.4-77.9 101.5-35.8-44.5-75.9-86.5-115.3-129.3 25.5-12.3 50.2-18.4 75.6-24.4 55.1-16.1 31.8-86.7 43.5-128.9zM194.5 485.7l-.1 0 .1-.1-.1 .1zM382 116.8c68.2 8.8 33.2 114.1-25.5 69-29.2-22.9-19.4-74.7 25.8-69l-.3 0z"],
    "chart-simple": [576, 512, [], "e473", "M257.6 60.5c-.2 .2-.2 .4-.2 .6 0 128.6-7.1 256.7-6.1 385.4 22.6 0 45.1 .4 67.4 1-.1-15.3-.5-32-1-49.1l0-.2c-1.2-38.7-.7-72.7-2-111.3-3.4-74.6 4-149.2 2.6-224.8-.1-.4-.3-.7-.4-.9-24.4-3.3-30.2-1.6-60.3-.7l0 0zM187.3 446.7c.1-41.2 .7-82.4 1.2-123.5 .3-21.9 .6-43.6 .9-65.3-35.3-.5-69.3 .7-103.8 3.9 4.2 65.6 1.9 119.3 5.6 187.6 14.1 .5 28.4 1.2 41.6 .7 18.1-2 36.4-3 54.5-3.4zm3.2-252.8c1-44.7 5.6-83.1 2.9-130.3-1.3-34.8 25.5-65.5 61.5-67 84-7.6 136.9 6.6 127.1 99.3 62-2 155-14.7 158.2 65.8-1.8 42 6 83.5 4.9 122.2 .1 41.6-2.1 118-3.6 167-1.1 35.4-30.7 63.1-66.1 61.8-43.3-.7-73.5-5.5-111.2-2.5-92.2 .9-184.5 1.3-276.1 3.1-33.1-1.3-59.3-27.8-60.9-60.5-3.8-58.7-1.1-104.1-4.3-159.9-20.2-118.5 89-95.5 167.5-99zm191.1-34c-3.7 40.4-3.3 79.4-2 120.4 1.3 38.4 .8 76.2 2.1 116.6l0 .3c.4 16.1 .8 32.5 .9 47.9 29.1-.1 57.6 2.8 94.9 3.7 5.2-99.9 2.5-193.4-1.4-287.1-35.3-7.5-54.2-1.6-94.6-1.8z"],
    "headphones": [512, 512, [127911, 62863, "headphones-alt", "headphones-simple"], "f025", "M511.8 401.3c-1.4-117-.5-281.6-114-359.5-118.2-82.2-313-30.2-367.1 116.1-23.7 58-26.5 119.6-27.3 179.5l0 0c-3.4 36.5 .5 76.2 12.1 112 1.9 9 5.3 18.4 12.9 23.9 10.6 8.4 21.9 6.9 35.5 7.5 31.9-.1 73.4 1.7 104.3-13.3 20.2-8.2 27.9-36.8 29.8-60.9 3.5-30.4 4.7-67.5-4.5-98.1-10.4-52.6-77.4-53.9-121.8-52.8 22.7-243.6 347.5-258.8 367.6-7.7-37.8 .7-83.5 2-101.4 46.1-24.8 70.7-20.9 191.6 78.8 186.5 29 2.6 56.9-.3 81.8-17.9 20.5-14.1 12.1-39.4 13.4-61.3zM68.1 319.6c19.8-.1 44-.4 62.9 4 8.7 23.9 5.7 63.5 1.2 89.1-14.8 3.6-42 4.4-59.1 4.2-1.9-7-4-16.3-5.3-21.1-2.2-15.8-1.5-35.5-.6-53.5 .3-7.3 .6-15 .8-22.6zm355.4-7.6c7.7-.4 15.5-.3 22.1 0 1.6 29.4 1.9 59 2.2 87.5 .1 5.6 .1 11.1 .2 16.6-8.5 2.3-20.4 .3-29 .4-5.1 0-16.5-.6-18.5-1.8-20.3-24.5-9.4-71.4-2.7-97.7 6.8-3 14.3-4.2 25.8-5zm-27.1 5.7c0 0 .1 0 .2-.1-.1 .1-.2 .1-.2 .1zm-266.4 4c0 0 .1 .1 .2 .3-.2-.2-.2-.3-.2-.3z"],
    "bus": [640, 512, [128653], "f207", "M227.4 0c57.8 0 126.8 0 185.7 .2 71.6 .3 131 57 131.7 129.7 .4 40.1 .1 80.7-.2 121-.5 51.9-.1 102.3-1.4 154.3-6.4 35.7 17.8 101-33.1 106.2-36.8-.7-32.8-41.2-31.7-67.7-107.4-4.5-213-1-320.7 3.4l.4 32c.3 41.8-63.4 42.6-64 .7L92.1 301c-2.6-56.7-2-112.8-.7-168.4 1.8-73.9 62.4-132.5 136-132.6zM157.1 383.1c106.7-4.4 215.5-7.9 322.6-3.4 .8-41 .4-81.3 .9-121.6-23.4-.1-47.1 .5-71.4 1.1-81.2 2-163.7 .3-254.4 3.3 1.2 25.5 2 94.2 2.2 120.6zM480.9 130.5c-.4-36.7-30.3-66.2-68-66.4-58.7-.2-127.6-.2-185.4-.2-77.4 3.4-74.5 76.1-73.2 134.5 90.7-2.9 171.8-1.3 253.9-3.3 24-.6 48.4-1.2 72.8-1.1 .1-21.1 .1-42.3-.1-63.6zM250.6 304.4l-.1-.3c.1 .4 .2 .5 .1 .3zm-3.3-6.8c27.2 39.2-32.2 73.2-54.1 34.7-21.6-36.1 31.5-69.2 54.1-34.7zm164.4-13.9c-42.4 .1-41.8 65.7 .3 65.9 42.3-.1 41.8-65.7-.3-65.9zM32.8 135.3c41 1.5 30.8 48.3 32.8 76.9 0 28 10.4 77.1-31.2 78.4-41-1.5-30.9-48.3-32.8-76.9 0-28.1-10.4-77.2 31.2-78.5zm602.2 45c-.6 26-1.4 50.5-.3 76.5l0 .1c1 41.8-62.5 43.8-64 1.9-1.1-26.8-.4-53.4 .4-80.2 1.3-41.8 64.9-40.1 64 1.7z"],
    "screencast": [576, 512, [], "e23e", "M99.4 144l0-49.9c106.1 .9 216.4 4.7 323.3 3.6 19.3 .3 38.9 .5 58.8 .7 .1 0 .2 .1 .3 .2 .1 .1 .2 .2 .2 .3-.2 39.7 .4 78.1 1.2 116 2.2 64.4 .2 129.2-.2 194.7l-97.2 4.8c-41.8 2.2-38.7 65.8 3.1 63.9l97.2-4.7c34.4-1.7 61.3-30.3 60.9-64.8l-.3-22.3c2.6-58.4 1.5-118.1 .4-176.6-.7-37.5-1.3-74.4-1-110 .3-35.9-28.7-65.3-64.6-65.4-57.4-.2-115.6-2.2-173.5-.5-68.1 2-142.6-6.2-212.4-3.6-34.8 1.3-60.1 30.3-60.1 63.1l0 50.7c.3 41.8 63.7 41.9 64 0l0-.1zM74 425.4C44.3 395.9-.8 440.9 28.7 470.6l16 16c12.5 12.5 32.8 12.5 45.2 0 12.5-12.5 12.5-32.8 0-45.2l-16-16zM15.9 328.5c-5.7 18.6 6.7 37.3 25.4 41.1 57.5 15.5 92.3 44.8 99.8 104.2 6.2 41.5 69.1 32.2 63.4-9.2-3.7-25.4-11.9-59.1-32-84.9-24.1-35.6-136-110.5-156.5-51.2zm37.9-48.8c41.1-5.7 135.9 61.8 155 96.3 16.5 25.7 22.2 57.5 24.8 94.6 1.2 17.6 16.5 30.9 34.1 29.7 58.1-4.2 17.2-124.2-5.1-158.9-41.3-59.2-134.3-128.5-213.4-125.5-41.6 3.2-37.2 66.6 4.6 63.8z"],
    "martini-glass": [512, 512, [127864, "glass-martini-alt"], "f57b", "M2.8 50.9c5.2-11.5 16.6-18.9 29.2-18.9 89.5 .3 176.4 1.6 265.9 1.7 55.6 1.1 110.4-1 166.1-1.7 10.6 0 20.4 5.2 26.4 13.9 6 8.7 7.3 19.8 3.5 29.6-22.5 58-61.7 99.6-100.8 142-39.8 37.2-62.6 85.4-105.1 120.6l0 110.3c11.4-.2 53.9-.4 66-.6 41.8-.2 42.4 63.4 .6 64-38.5 .4-86.9 1.2-124-1.4-35.3-7.7-102.9 17.2-103.5-37 6.1-44.2 66.3-25.6 97-27.5l0-110.5c-34.4-28.1-65.8-68.3-97-107.6l0 0C97.6 190.9 61.3 145.2 8.1 85.2-.3 75.8-2.4 62.4 2.8 50.9zm99.6 45.5c30.7 36.3 54.6 66.4 74.8 91.9 26.1 33 56.2 70.8 80.4 91.8 30.4-35.3 57.7-76 91.3-109.2 22.3-24.1 44.2-47.9 61.6-73.9-102.2 2.1-206.2 0-308.1-.6z"],
    "link-simple": [576, 512, [], "e1cd", "M331.2 99.5c.5-34.6 37.2-33.6 62.4-31.3 106.6-6.3 151.1 39.4 160.5 142.9 37.7 142.2-59.7 240.1-195.5 239.6-41.8 .4-42.8-63.1-1-64 104.9-2 161-61.5 133-167.2-5.8-46.7-11.6-90.9-68.7-86.6-31.6-3.9-87.9 12.2-90.8-33.4l0 0zM73.7 106.7c29-23.8 185-71.3 185.1-2.6-1 17.7-16 31.2-33.7 30.2-88.6-3.7-163.9 27.6-160.5 125.7-1 30.8 3.3 52.9 14.4 77.1 25.1 27.1 115.9 41.2 152.4 40 17.7 0 32 14.3 32 32s-14.3 32-32 32C173.1 440 81 428.4 33.5 382 5 348.5 0 297 .6 259.3-1.6 192.4 26.7 137.5 73.7 106.7zm328.7 183l-224.2 .7c-41.9-.1-42-63.7-.2-64l224.2-.7c41.9 .1 42 63.7 .2 64z"],
    "rectangle-wide": [576, 512, [], "f2fc", "M566.5 74.8c6.3 6 9.9 14.4 9.9 23.1l0 4.3c0 97.9 0 197.8-13.4 297.6-3.7 27.7-27.2 48.1-55.1 48.1L92.3 448c-.6 0-1.2 0-1.9 0-6.6 0-18.9 .1-30.4-2.5-13.1-2.9-33.8-11.4-41.9-35.1-23.3-67.7-20.6-119-17.7-174 1-18.8 2-38 2-58.5 0-1.4 0-3.2 0-5.4-.1-9.1-.2-23.9 .7-38.1 .6-8.8 1.7-18.7 3.8-27.8 1.9-8.2 5.6-20.3 14.1-29.9 6.1-6.9 14.8-10.8 24-10.8 38.1 0 87.7 .5 141.7 1 123.6 1.2 270.5 2.7 356.2-1 8.7-.4 17.2 2.8 23.5 8.9zM67.7 130c-.3 2.7-.6 5.7-.8 8.9-.8 11.4-.7 22.6-.6 31.8 0 2.6 0 5 0 7.3 0 27.3-1.2 50-2.2 70.3-2.5 48.6-4.3 83.6 12.4 135.3 1.3 .2 3 .3 4.9 .4 2.8 .1 5.4 .1 8.5 .1 .7 0 1.5 0 2.3 0l408.2 0c10.6-83.2 11.7-167.1 11.8-253-89.2 2.3-219.3 1-329-.1-42.8-.4-82.6-.8-115.6-1z"],
    "cloud-arrow-down": [576, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M275.6 96.1c-22.2-.4-30.7 .8-41.2 8.3-37.2 26.5-45.5 52.4-63.2 107.6-3.7 12.4-14.3 20.9-26.4 22.5-96.5 22.6-114.3 147.3-21.4 184.5 7.3 3.2 15.5 5.6 30.6 8.2 17.4 3 29.1 19.6 26 37-15.8 55-90.9 10.3-121.3-8.9-104.5-77.2-65.1-243.2 56.6-278.8 14.8-66.2 79.9-156.2 161.3-144.6 86.8-2 164.3 52.2 178.3 142.3 177.9 29.4 149 326.6-33.3 322-41.8-.2-41.9-63.8 0-64 85.1 2.1 112.6-111 69.3-167.8-12.9-16.6-32.7-28.3-62.5-28.3-17.1 0-31-13.4-32-30.2-4-18.8-13-54.4-25.4-72.6-25.2-26.1-55.3-36.7-95.6-37.4zM243.7 375.7c4.4 4.5 8.9 9 13.3 13.4-1.1-66.9-1.9-109.1 1.2-166.4 7.6-51.5 75.4-33.1 63.4 16.6-2.6 50.8-1.3 88.2-.5 149.6l47.4-40.1c32-26.9 73.2 21.7 41.3 48.8l-104 88c-12.4 10.5-30.6 10-42.5-1-32.4-30.2-62.8-62.1-93.9-93-12.5-12.5-12.6-32.7-.1-45.3 28.5-27.3 55.3 10.2 74.5 29.3l0 0z"],
    "angle-down": [448, 512, [8964], "f107", "M56.5 169.3c-11.4-13.5-31.6-15.3-45.1-3.9-13.5 11.4-15.3 31.5-3.9 45.1 39.3 46.8 81.9 92.3 126 134.6 19.1 18.3 47.1 45.3 67.9 65.5 29.6 26.4 51.8-6.8 68.8-29 5.7-6.3 11.5-12.7 17.5-19.2 31.1-33.1 57.4-68.1 92.4-99.1 12.1-11.3 26.9-25.3 37.4-37.7 5.8-6.7 11.5-12.9 16.7-17.7 30.7-28.4-12.3-75.3-43.3-47.2-19.3 18.7-32.8 36.6-52.4 53.7-34.7 30.5-64.9 68.9-96.7 103.3-6.8 7.4-13.8 14.9-20.8 22.8-58.8-55.9-113.2-109.4-164.5-171.3l0 0z"],
    "ghost": [512, 512, [128123], "f6e2", "M158.4 104.2c117.8-85 225.5-34.2 247.3 109.3 15.4 56.7 7 109.9 11.2 166.7 .5 14.8 1 29.6 1.1 44.1-19.3-10.9-41.5-29.5-66-32.6-38.8 3.2-68 29.1-97.9 49.1-4.1-3.1-8.5-6.7-13.2-10.4-47.9-44.2-96-50.3-152.9-10.7 1.3-101.9-5.1-239.1 70.3-315.5zm84.1 404.4c11 5.2 24 3.6 33.5-4l.1-.1c20.3-15.6 48.2-36.6 72.2-47.1 12.3 6.2 26.1 15 39.4 23.6 112.4 83.6 94.1-25.2 93.1-105.3-3.8-59.8 3.7-122.6-13.8-180.7-29.1-184.8-197.6-255.4-350-139.5-83 79.6-86.9 190.5-92.9 296.2l0 128c-.1 30.2 37.5 42 57.8 21 18.1-12.5 54.1-38.2 77.1-44.3 .3-.1 .4-.1 .2-.1 8.5-1.3 29.8 13.7 41.8 24.1 13 10.4 25.1 20.4 41.6 28.2l.1 0zM191.3 186.9c-13.2 0-24.6 8-29.4 19.5-31.7 56.4 64.5 80 61 17.8 3.3-19.2-12-37.5-31.6-37.2zm137.3 6.3c-18.1-3.9-33.9 8.8-39.7 25.2-12 38.3 41.2 59.9 60 23.8 11.6-16.8 1.7-45.4-20.3-49z"],
    "chart-pie": [512, 512, ["pie-chart"], "f200", "M253.1 2.2c-50.8 4.9-26.7 71.6-32 106-.1 49.4-.1 99 0 148.4-.4 18.5 17.2 34.3 35.6 31.7 39.3-4.5 79.2-3.8 120.3-3.9l98.8 3.5c18.6 1.1 34.9-16.1 33-34.6-10-139.5-102.6-253.2-255.8-251.1zm32 106.2l0-40.2C374.8 80.9 421.7 139.5 440 222.7l-61.2-2.1c-31.1 0-61.6-.4-93.7 1.3 0-37.8 0-75.6 0-113.4zm-142-5.1c36.5-20.4 5.7-76.1-31-56-21.9 12.1-37.5 29-50 42.6-86.1 90.2-84.4 244.7-4.4 329.9 104.7 122.2 319.1 101 412.8-16.9 24.4-33.9-26.8-71.4-51.7-37.7-76.4 89.8-242.8 101.2-317.2 8-69.5-82.9-43.4-216.7 41.6-269.9z"],
    "phone-arrow-right": [576, 512, [], "e5be", "M482.2-15.4l0 0c3.5 3.5 6.4 6.5 9.1 9.3 52 53.4 136.9 93.5 51.7 167.9-9.3 10.3-42.3 43.6-52.3 53.8-29.5 29.7-74.8-15.1-45.6-45l39.1-39.6 1.1-1.2c-53 1.4-105.4 1.5-158.6 2.1-19 2.3-37.2-10.6-38.1-30.2 2.5-52.5 70.6-28.7 105.3-34.5 26.7-.5 54-.5 81-.9-10.7-8.8-21.5-19.4-31.2-29.7-39.1-28.5 2.1-84.2 38.7-52zm-343 94.3c-49.8 50-84.1 131.2-56.2 191 28.8 52.3 56.4 89.9 98.1 131.7 34.6 39 161.4 67.2 207.3 38.7 24-12.9 42.3-30.5 63-54-8-7-18-14.4-27.8-21.9-10.7-8-22.7-17-34-27.2-44.1 56.3-105.7 51.1-155.4 13.1-45.4-38.2-118.8-100-85.7-172.5 11.4-20.7 24.3-36.1 37.9-53.5-15.7-21.1-28.7-31.5-47.3-45.5zM112 19.2c24.2-17.5 51-6.1 70 11.9 37.2 28.5 95.7 80 59.7 125.8-11.7 16.9-28.1 34.4-37.4 52.4-5 21.9 38.2 64.7 54.1 78.1 15.8 14 42.2 33.9 59.9 26.9 10.8-5.8 14.8-9.1 23.2-19.2 15.1-29.1 53.5-41.1 79.3-16.4 13.8 13.8 24.8 22.4 42.1 35.3 42.1 29.8 82.7 62.1 37.5 113.7-53.1 70.4-140.9 105-231.4 82.1-120.7-19.6-186.8-111.7-242-208.9-48-103.2 8-219.8 85.1-281.6l0 0z"],
    "list-music": [640, 512, [], "f8c9", "M163.3-.8c-20.9-.1-37.7 19.7-39.2 39.5 0 0 7.9 0 7.1 0l-7.1 0c-.5 83.5-.4 192.8 2.9 273.1-81.4-32.3-149.9 61.4-116.2 134 22.7 58.9 114.4 95.3 158.9 42.4 40.1-47.2 20.2-112.8 21.5-169.9-1.4-42.2-2.7-77.9-3-126.9 5.6 .3 11.2 .5 16.8 .8 29.3 1.5 55.8 2.8 88.2-.4 19.2-1.1 38.9-4.6 47.5-28.7 5.8-21.1 8.2-53.2 6.9-74.3l0-.3c0-.7-.1-2.5-.1-3.2-1.4-21.4-.1-44.9-9.6-65.8-1.2-2.5-10.1-19.7-31.1-19.7-16.4 0-32.9 .1-49.3 .2-31.3 .2-62.3 .4-94.1-.8l0 0zM123.5 381.6c2 1.8 4.3 3.2 6.6 4.4 1.5 12.6 .9 27.6-1.3 41.3-1.3 41.3-50.2 18-59.6-7.4-7.3-16.4-.1-39.7 14.1-47.9 7.5-5.7 34.1 2.7 40.2 9.7zm64.4-254.2c0-25.3 0-46.1 .1-63.5 32.3 .7 62.4 0 94.3 0 .6 8.9 1 17 1.2 25.1 .9 9.1 .3 25.5-1.4 39.6-24.5 2.1-47.9 1-72.5-.2-7-.4-14.3-.7-21.8-1zM280 46.7l0 0zm170 9.5c-41.8-2-45.2 61.5-3.4 63.9l152 8c41.8 2 45.2-61.5 3.4-63.9l-152-8zM607.8 224.3c-55.3-4.3-105.9-.2-159.4-.1-17.7 0-32 14.3-32 32 1.9 45.5 60.4 29.4 88.9 31 32.9-.9 63.1-1.8 97.5 .9 17.6 1.4 33-11.8 34.4-29.4s-11.8-33-29.4-34.4zm26.4 186.5c-3-42-54.4-27.5-80.8-29.4-68.2-.2-137.1 1.3-205 2.9-26.8 1-69.6-5.7-71.5 31.8-.1 40.4 45.6 32.9 73.2 32.2 67.8-1.6 135.3-3 202.7-2.8 25.9-1.1 82.6 8.8 81.3-34.6z"],
    "inbox": [576, 512, [], "f01c", "M95 248.1c.7-61.5 3.5-124.1 6.6-181.7 129.5-1.8 257.9-4 385.5 4.4 13.6 54.9 7.9 122.7 4.3 183.9-31.7-.6-79.5 .6-98.8 1.2-35.7 .6-46.7 36.4-61 63.6-30.1-.6-59.9 0-89.5 .5-14.7-26.8-20.1-61.2-55.5-64.7-17.2-1.9-58.3-6.2-91.5-7.1zm.2 64c24.6 .8 55.3 3.7 75 5.8 5.3 12.2 13.2 29.2 21.1 42.2 13.7 25.9 41.3 24.9 65.4 23.6 28.2-.4 55.6-.9 83 0 39.2 1.7 48-36.4 63.8-64.1 21.3-.6 56.5-1.3 82.1-1-3 28.6-5.9 52.3-7.6 66.3-1.8 12.5-1 29.2-.4 43.7 .3 6.1 .5 12.1 .6 17.9-105.9 9.9-213.5 6.3-320.5 1.2-16.7 .2-40.9 1.3-52.5-5.6-9.1-38.8-7.8-84.4-9.9-130zm409 199.3l.1 0c57.8-1.1 31.3-84.7 37.2-118.9 1.9-49 58-364.5-31.8-384.3-132.3-9.8-264.6-7.9-395.5-6.1-29.7 .6-76.4-6.5-75.1 35.6-6.8 125.4-14.9 284.9 .9 410.1 8.3 59.3 74.5 67 122.5 63.6 113.9 9 226.8 3.4 341.7-.1z"],
    "bolt-slash": [576, 512, [], "e0b8", "M56-18.7c-10.4-14.3-30.4-17.4-44.7-7-49.5 39.6 64.9 115.7 90.1 144 26.4 22.6 52 48.2 76.9 71.3 26.6 24.3 51.1 48.9 74.7 76.5 61.4 68.2 129.2 131 190.6 200 22.8 24.6 45.9 49.4 69.4 74.2 12.2 12.8 32.4 13.3 45.2 1.1 12.8-12.2 13.3-32.4 1.2-45.2-22.5-23.6-44.9-47.8-67.5-72.1l0 0c-61.2-68.7-128.4-131.4-190.5-199.8-25-29.4-53.3-57.5-82-83.8-52.9-53.9-118.3-99.9-163.4-159.1zM319.5 101.8c3.3 34.9 13.7 82.3 55.6 87.7 10 3.1 18.7 7.5 27.4 10.8 15.1 6.2 36.4 15.2 52.2 20.9l-10.1 11c-28.2 30.9 18.7 74 47.1 43.3l42-45.6c15.3-15.7 8.6-44.2-12.1-51.5-20.8-7.7-77.3-29.9-97-38.2-10.9-4.4-22.5-9.6-32.6-12.4-1-.3-1.7-.5-2.5-.8-5.8-15.5-8.2-48.7-9.4-69.4-2.8-20.3 2.4-41.4-18-54.5-17-8.8-30-4.9-41.3 7.1-21.3 24.8-57.3 47.7-64.4 74.8-5 30.7 29.2 45.7 47.2 34 9.4-5.5 11.8-10.8 16-17.1zM137.1 224.6c-40.2-27.1-60.9 30.7-87.8 55.3-24.4 28.4-8.3 73.3 29.6 78.7 28.8 4 69.9 9.5 101.7 11.6 4.5 16.4 7.2 34.9 9.6 53.2 5 31.2 8.9 116.5 63.1 86.1l64.9-47.3c33.7-24.8-3.7-76.2-37.7-51.7l-25 18.2c-.7-4.5-1.3-9.2-2-14-7.7-29.8-4.8-108-52.4-108-12.8 1.1-62.1-4.6-84.2-7.5 19.4-22.5 48.5-49 20-74.5z"],
    "cloud-snow": [576, 512, [127784], "f742", "M220.3 60.1c83.3-56 159.7-25.8 169.4 75.6 4.5 25 26.1 38.8 46 40.3 94.2 14.1 74.6 129.9 12.7 179-29.9 29.2 14.4 75 44.6 46 97.8-80.2 104.8-258.8-42.2-287.6-31.2-206.4-271.8-173.7-341.9-13-87.4 30.9-136.4 135.6-97.2 222.3 18.1 34.6 68.5 118 108.4 79.1 11.8-13.2 10.7-33.4-2.4-45.2-49.6-40.4-76-101.9-36.4-158.2 23.1-35 82.8-59.9 118.1-30.8 13.8 11 34 8.8 45-5.1 26.9-37-27.8-64.2-57-69.2 9.3-13.2 19.6-24.1 32.8-33.1l0 0zM186.9 294.8c43.6-3 47.1 62.1 3.5 63.9-43.6 3-47.1-62.1-3.5-63.9zm202-7.3c-30.6-4-58.4 38.2-24.6 61.4 22.1 12.6 57-2 56.6-29.4 0-17.7-14.3-32-32-32zM253.4 388.1c-.1-42.6 68.7-42.6 68.6 0 .1 42.6-68.7 42.6-68.6 0zm-61.4 31.6c-34.4-2.5-53.2 49.6-13.2 64.2 48 12.1 65-60 13.2-64.2zm94.9 60.4c-37.6-5.1-54.2 50.6-15.2 63.6 47.7 12.6 66-57.2 15.2-63.6zm96.9-67.9c-41.9 1.1-42.1 61.6-.8 64.4 46.2 3 46.8-64.9 .8-64.4z"],
    "credit-card": [512, 512, [128179, 62083, "credit-card-alt"], "f09d", "M308.4 32c-70.9 0-172.3-.1-235.7 7.5-35.3 4.2-59.6 32.5-64 64.4-14.6 106.8-8.6 190.8-3 303.9 5.9 65 66.1 76.3 120.3 70.8 116.4-3.3 202.7 4.6 313.9-.8 42-2.6 72.1-37.8 72.3-77.7 .1-49.7 .5-137.3-.2-207.5-.3-36.2-.8-68.6-1.6-90.5-1.2-31.6-23.4-58.1-56.3-62.4-57.3-6.6-93.2-7.2-145.4-7.8zM447.5 164.3c-134-7.3-242.6-10.6-381.7 .1 1.1-13.3 3.7-33.9 6.2-51.6 .9-6.5 5.1-9.3 8.3-9.7 108.1-8.9 248.5-11.5 365.8 .3 1 16.1 1 36.4 1.5 60.9zM64.3 228.6c138.7-10.8 248.5-7.7 383.7-.3 .3 62.1 .2 129.2 0 171.6 0 8.4-6 13.7-12.1 14-39.9 2.4-85 2.5-119.7 1.3-66.1-2.3-158.2-.8-232.9-.2-8 .1-13.3-5.5-13.8-11.8-4.8-65.1-5.2-116.4-5.1-168.4-.1-2-.1-4.1-.1-6.1z"],
    "wand-magic-sparkles": [576, 512, ["magic-wand-sparkles"], "e2ca", "M128.6 31.6c1.8-28.4 3.6-62.6-31.5-64-33.3 1.4-32.9 31.9-32.6 59.4 0 1.6 0 3.1 .1 4.6L32 31.6c-17.7 0-32 14.3-32 32s14.3 32 32 32l33.1 0c.1 3.7 .1 7.5 0 11.2-.1 25.2-.3 48.8 29.6 52.7 35.9 1.9 37-36.6 34.4-63.9l30.9 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-31.4 0zm124.7 407c-46.8 55-106 116-175 53.1-86.8-77-54.8-135.4 19.6-197.4 20.5-19.4 40.7-38.9 60.7-58.8 17.3-17.3 34.6-34.4 52.2-50.9 12.6-11.6 24.1-22.4 34.9-34.1 23.6-25.9 43.4-43.8 65.5-63.7 18.3-16.6 38.2-34.5 63-59.6 31-30.3 81.6-36.8 116.8-2.4 4.9 5 9.7 9.8 14.4 14.3 21.6 21 40.1 38.9 42.3 72-4.5 44.3-37.3 73.5-70.1 102.8-11.5 10.3-23.1 20.6-33.4 31.5-35.3 31.6-64.8 62.5-94.5 93.5-18.2 19.1-36.5 38.2-56.2 57.6-13.7 13.6-26.4 27.2-40.2 42.2l0 0zM415.5 184.7c4.2-4.1 8.8-8.3 13.4-12.7 21-19.7 44.6-41.8 54.8-60.4-7.6-13.3-16.8-20.9-34.8-38.7-3.9-4.4-9.6-8.1-14.8-7.4-15.2 4.3-32.9 22.9-48.7 39.6-9.5 10-18.3 19.2-25.5 24.4 .2 .2 .5 .4 .7 .6 .2 .2 .5 .4 .7 .6 18.5 17.3 37 35.5 54.2 54zm-228.1 112c-22.7 21.9-44.9 44.9-68.6 65.7-28.5 25.1-46.1 40.5 4.6 83.9 9.7 9.7 23.5 9.3 31.7 1.6 17.1-16.1 34.2-34.5 50.9-52.5 55.3-58.1 104.9-109.2 162.5-167.2-10.3-11.1-22.9-22.7-34-34l0 0-22.2-20.9c-40.5 42.1-82.9 83-124.9 123.5zM483.9 112.2l0-.1 0 .1 0 .1zm-.1-1.1l0-.1s0 0 0 .1zM481.2 352c35.1 1.4 33.3 35.6 31.5 64l31.4 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-30.9 0c2.6 27.3 1.5 65.8-34.4 63.9-29.9-3.9-29.8-27.4-29.6-52.7 0-3.7 0-7.5 0-11.2l-33.1 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32.6 0c0-1.5 0-3.1-.1-4.6-.4-27.5-.7-58 32.6-59.4z"],
    "bell-slash": [576, 512, [128277, 61943], "f1f6", "M2.2-23.7c11.4-13.5 31.6-15.3 45.1-3.9 59.3 50.2 115.9 107.4 164.2 167.5 77.1 78.8 152.4 158.4 234 234.1 42 35.5 83.8 76.8 126.6 114.1 12.7 12.3 13 32.6 .6 45.2-33.8 30.8-61.7-19.8-88.3-37.7-127.3-114.3-253.7-237-366.9-367-35.8-38.3-71.1-74-111.3-107.2-13.5-11.4-15.3-31.6-3.9-45.1zM353.3 90.8c-25.2-26.1-59.3-30.5-101.8-19.4-40.4 10.5-56.7-51.2-16.2-61.9 152.1-41.9 225.2 82.8 212.2 221.6-2 41.8-65.5 39.2-63.9-2.6 1.6-45 .1-104.8-30.2-137.7zm-194.5 156c44.7 18.6 6 72.8-5.8 100.9l15.7-.6c31.5 2.6 100.2-25.3 103.9 26.9-1.6 35.6-35.5 31.6-64.1 34.4l-.9 .1c-11.6 1.2-25.2 2.6-37.2 2.6L92.5 414c-26.7 1.9-43.6-32.2-25.9-52.3 24.5-29.8 38.6-57.1 51.6-95.1 5.7-16.7 23.9-25.6 40.6-19.9zM287.7 444.6c27.3-1.5 77.2-11.6 78.3 30 0 17.7-14.3 32-32 32-36-5.7-114.9 28.2-120.9-28 1.5-40.2 45.9-30.7 74.6-34z"],
    "folders": [640, 512, [], "f660", "M218.5 148.7c-1.2-29-2.3-57.3-2-85.4 28.4-.8 75.7-2 99.8-2.5l63.6 63.6c7.3 7.3 17.3 11.6 27.9 11.7 16.3 .1 90.9 .7 133 1l-.1 183c-57.4-1.7-111.5-3.9-166-.3-43.5 3-81.8 1.7-124.5 1.4 .3 0 0 0-.8-.1l0 0c-6.7-.6-16.5-1.7-24.7-2.7-2.8-51.6-2.8-102.8-5.4-153.5-.3-5.4-.5-10.8-.7-16.2zM418.2 72.1L356 9.9C350.2 1.8 340.7-3.5 330-3.5 305.6-3.3 223.5-.9 188.3 0l-.4 0c-13.6 .4-25 9.2-29.3 21.4-14.8 46.2-2.2 99.3-3.4 146.6 2.3 51.7 3.1 103.5 5.2 154.3-.8 10.2-2.1 27.6 5.7 39.6 4.7 8.9 13.5 15.4 24.3 16.7l.2 0c30.5 4.3 62.2 7.5 93.1 6.8 30.8 .8 62.7 .1 93.6-1.7 62.8-4.2 129.8-.5 194 1.4l.3 0c17.6 1.1 33.5-14.3 33.2-31.9l.2-241.1c0-10.1-4.7-19.1-12-25-5.8-8.4-15.4-13.9-26.4-13.9-18.9 0-113.2-.8-148.3-1.1zM87.7 159.2c0-17.7-14.3-32-32-32-52.6 4.3-25.8 80.3-31.4 115.6 .3 44.3 1.7 86.4-1.1 131l0 .4c-12.4 94.6 18.5 143 117.5 136 51.6-.2 102.9-1.2 153.6-2.8l.3 0c61.4-1.7 117.8-3.5 179.8-2.2l.4 0c41.8 .4 42.7-63.3 .9-64l-.4 0c-62.5-1.3-121.3 .5-182.3 2.2l-.2 0c-58.2 1.8-115.8 2.9-173.8 2.9-12.6-.7-24.2-.8-30.6-6.9-6.6-14.8-1.1-44-1.3-62.6 2.8-43.8 1.5-90.3 1.2-134.4-.3-27.9-.6-55.5-.6-83.1z"],
    "tv": [512, 512, [63717, "television", "tv-alt"], "f26c", "M305.3-9.5c-43.9 0-89.4 2.8-133.7 5.4-43.3 2.7-85 5.1-125.7 5.4-19 .5-35.6 17-37.4 34.5-19.2 101.9-13.2 210-2.8 314.9 14.8 53.1 79.5 26.4 123 32 124.7-3.5 226.3 6.6 346.2-3.5 20.8-1.9 35.8-24.5 34.2-40.7 .2-23.3 .5-90.7 .2-156.1-.4-65-.7-127-3.7-150.6-2.9-18-17.9-29.1-32-31.3-61.3-9.3-111.9-9.2-168.3-10zM62.1 111.2c1-11.5 3.9-30.4 6.5-46.2 35.2-.8 71.1-3 106.3-5.1 94.2-6.3 174.4-8.2 268.8 .9 2.2 56.8 1.9 198.5 1.6 256.7-127 5.5-247.2-1.8-378.7 1.7-5.2-55.7-5.7-105.2-5.7-150.9-.2-19.8-.4-37.9 1.2-57.2l0 .1zM362.5 514.6c32-5.6 90.2 16.7 96-30.1 1-17.6-12.5-32.7-30.2-33.7-35-2-72.7 .5-107.2 .6-75.2 0-143.6 0-223.5-.7-17.7-.1-32.1 14.1-32.3 31.7-.2 17.7 14 32.1 31.7 32.3 93.9 .3 175.9 1.7 265.3-.1z"],
    "star": [576, 512, [11088, 61446], "f005", "M282.8 18.7c13 .6 24.4 9.1 28.7 21.4 7.9 23 24.6 53 39.1 78.6 7.9 14.1 16.5 29.3 25.1 45.6 58.8 14.7 101.4 19.1 152.7 31.2 19.8 9.3 23.8 38.3 7.1 52.4-26.8 23.9-70.9 48.2-91.9 75.4-4.7 5.2-10 11.2-15.3 16.7 6.3 46.7 15.6 89.9 21.6 136 4.1 29.6-31.2 45.7-53.8 29.2l0 0c-35.6-23.5-74.7-45.5-107.5-67.5-12.2 6.8-24.9 13.5-37.3 20.1-32 17-67.7 36-94 55.8-14.1 10.6-34.2 7.7-44.8-6.4-20.7-22.5-3.1-56.9 5.1-79.3 11.6-25.9 19.3-53.8 25.6-79.4 1-3.9 2-7.9 3.1-11.9-39.8-28.8-77.6-58.7-116.1-89.1-28.5-22-2.1-68 31-55.1 44.4-.5 87.1-7.4 131.3-20.5 6.7-13.5 17.8-35.7 24.1-48.7l.1-.2c11.7-28.5 22.6-57.5 35.8-86 5.5-11.8 17.5-19.2 30.6-18.6l0 0zM246.6 206.5c-22.4 35.6-71.9 33.9-109.4 43.7 19.8 15.1 38.4 29.1 59.2 43.8l0 0 0 0c36.8 28 .5 85.8-6.4 124 10.8-5.9 22-11.8 32.5-17.4 28.7-10.4 56.8-46.1 86.8-26 9.3 6.2 21.8 14.9 31.1 21 .8 .5 1 .7 .8 .5 8.3 4.7 20.9 12.4 34 20.5l-.5-3.6c-3.2-20.3-7.4-46.6-10.4-66.8-4.4-29.6 13.4-46.5 31-65.2 12.5-14.4 24-26.3 40.8-38.4-27.1-5.3-55.4-11.5-89.4-19.4-9.2-2.1-17-8.3-21.3-16.7-10.1-20-20.3-38-30.2-55.6-4.1-7.3-8.2-14.6-12.2-21.9-8.3 22.5-24.2 52.4-36.5 77.4z"],
    "flag": [448, 512, [127988, 61725], "f024", "M61.6 27.9c-4.1-38.8-63.4-36.5-63.8 3.2-2.6 145.9-5.1 304.1-1.7 448.4 0 17.7 14.3 32 32 32s32-14.3 32-32c0-43.3-.9-84-1.6-126 49.8-7.3 91.6 2.6 141.1 27.3 30.4 13.8 66.5 30.1 106.6 33.8 29.1 2.7 75.6-1.8 97.2-4.1 24.4-2.7 42.4-23.2 42.5-47.3 .3-81 3.5-141.1 .1-220.4-3.7-62.8-77.9-44.9-121.2-55-66.3-12-105.1-68.1-185.1-66.5-22.8 .1-55.1 3.7-78.1 6.6l0 0zm-.5 64.6c58.9-9.3 112.5-13.8 163.2 22.6 39.6 28.2 103.7 41.7 158 43.2 3.1 73.8-.1 114.2-.4 190-61.4 8-101.6 1.7-158.5-27-45.6-23.6-108.2-40.8-165.7-32.1-.6-60 3.5-135.6 3.3-196.8z"],
    "arrow-right-from-line": [512, 512, [8614, "arrow-from-left"], "f343", "M3.5 457.9c.6 41.7 64.3 41.2 64-.7L63 63.6c-.6-41.7-64.3-41.2-64 .7L3.5 457.9zm329-349.6c-36 36.1 22.5 68.5 45.7 97.1 9 8.9 17.3 17.3 24.4 24.6-33-.5-65.9-.3-97.3 .8-38.1 1.1-73.7 2-111.2-1.5-17.4-.7-32.5 12.9-33.2 30.8-.9 19.4 15.8 34.1 34.8 33.6 38.7 3.2 78.6 2.1 116.4 1.1 31.9-1 58.8-1.1 90.7-.6l-72.2 72.2c-29.4 29.7 15.5 74.8 45.2 45.2l128-128c15.3-14.4 11-41.9-7.9-51-7.6-3.6-25.3-23.1-32.7-31.4-10.9-12.2-24.5-25.9-39.7-41-30.8-23.8-52.5-79.1-90.9-51.7z"],
    "store": [576, 512, [], "f54e", "M448.2 .4c-106.5-1.6-197.2-.1-296.1 .2-23.6 .3-46.3-5.5-61.8 16.7-41.3 46.2-59.2 98.9-82.4 149.5-22.2 48.8-9.3 115.1 27 149.1-2.5 74.1-24.3 195.4 84 190.2 56.7 2.7 105.2 7.2 159.5 5 43-.5 85.7-.6 128.2-2.3 158.3 7.3 135.6-69.7 135.3-192.1 20.3-17.2 34.2-43.4 34.2-76.8l0-47.4c-.4-15.6-10.9-27.9-16.6-42.3-22.2-46.8-47.3-99.2-88.8-140.6-6-6-14-9.3-22.5-9.3zm46.9 163.9c-137.6 1-276.9-6.3-414.2-4.3 16-36.2 31.6-70.4 53.1-95.6 4.9 0 10.1 .1 15.5 .1 95.7 0 181.4-2 284.8-.3 25.5 28.5 42.6 62.1 60.8 99.9zM61.2 224c22.3 0 44.5 0 66.8 .1l-3.1 38.7c-18.5 46.8-64.6 1.4-63.7-38.8zm130.9 .3c21.3 .1 42.7 .3 64 .5-3.2 81.1-62.9 79.5-64-.5zm128 1.5c21.3 .4 42.7 .9 64 1.5 7.2 65.5-59.6 71.5-64-1.5zm128 3.4c21.5 .3 42.6-.3 64-1.9l0 12.7c1.2 40.3-54.9 51.6-64 12.4l0-23.3zM97.5 431.6c-1.3-28.9-1.4-56.1-.2-85.3 22.8 2.4 48.5-7 64.7-24.3 33.7 38.5 99.7 34.7 129.4-7.2 32.6 34.4 90.1 39.5 124.7 3.6 17.1 15 40.4 22.6 62 22.2 .2 28.4 .3 58.1 .1 86.8-.1 8.2-6.3 14.5-14 15-21 1.3-40.1 1.9-60.3 2.5-96.7 3.3-189.2 3.9-285.4-2.8-8.9-.3-20.7 1.5-21.1-10.6z"],
    "mug-saucer": [576, 512, ["coffee"], "f0f4", "M417.9 32.4c-106.3-1.2-212.7-2.9-320.4 1.9-22.1 .7-31.5 20.6-32.3 40.6-4.1 21.2-5.1 46.8-4.6 69.9-2.2 160.5-6 243.8 185.4 236 89.2 2.4 185.3-8.6 198.3-118.2 181.6-22.8 164.1-249.2-26.4-230.2l0 0zm48.5 159.4c-5.3 2.6-10.4 4-17.1 5.2 .2-33.1 .8-66.2 .5-99.6 66.9-1.1 80.1 67.5 16.6 94.5zM273.5 96c37.5-1.6 74.2-1.1 112.3-.3-5.2 183.5 34.1 233.9-184.9 219.8-24-2.9-53.6 .3-66-22.9-17.7-59.4-9.6-132.3-8.2-195.6 47.3-4.4 98 1 146.8-1zM64.1 422.6c0-17.7-14.3-32-32-32-46 1.9-34.8 64.6-10.7 85.2 29.3 30.8 86.3 34.6 118.9 36 74.1 4.3 144.3 .4 218.9-1.2 48.7-3.9 114.9 9.9 145.4-32.8 20.7-26.6 23.7-74.9-16.9-77.1-17.7 0-32 14.3-32 32 .1 1.5-1.3 5.6-2.5 7.1-22.2 10.2-64.3 4.2-94.3 6.8-93.2-.3-184.9 12.5-277-7.5-11.5-5.4-16.7-5.2-17.9-16.6z"],
    "lock": [384, 512, [128274], "f023", "M256.2 108.8c2.5 28.1-1.2 50.5-.4 79.1-42.3 0-84.7-1.1-127.1-.4 .2-5.2 .5-10.2 .7-14.8l0 0c.8-39.4-15.8-99.6 45.8-106.4 36.6-9 77.7 10.2 80.9 42.5zm63.6 84.3c-1-33 3.6-58.2-.1-92.3-10.8-80.5-92.2-109.6-153-97.9-56.9 7.7-104 50.3-102.5 113.8 .5 26.6 2.2 48.2 .5 72-43-4.1-60.2 36.4-63.6 64.9 .4 58.1-4.2 133.5 .2 195.9 10.7 84.5 113.6 55.2 171.4 59 96.1-4.6 232.3 34.5 213.2-114.8-7-64.9 31.7-191.6-66-200.7zm-39.7 59c13 1.2 24.9 2.9 38 6 11.8 30 2.6 71.4 3 105.1-.3 24.6 2.8 49.9 1.1 73.4-13.9 14.2-44.3 8.9-64.6 8.4-63.7-4.3-129.7 4.8-192.5-1.3-2.4-61.8-2.5-133.5 1.6-190.8 71.7-1.1 141.9-2.1 213.4-.8z"],
    "folder-plus": [512, 512, [], "f65e", "M199.1 87.3c-54.4 1.6-63.1 1.2-140.9 .9 0 .2 .9 127.5 .9 127.7 .1 77.3-2.9 124.4-1 201.6 66.1 .8 111.6 1.6 170.3-.2l.2 0c72.7-2.7 143.9 .9 216.8-.3 0 0 .1 0 .1-.1l0-63.4c-2.8-38.2-1-143.6-.5-188.9-54.5 3-82.4 3.8-146.1 2.3-48.9-.5-68.7-56.2-99.7-79.6zm-1.2-64c47.5 .3 67.5 44.9 101.9 79.6 34.7 .6 75.6 1.6 109.5-.7 40.7-2.9 97.9-11.2 99.9 46.3-2.2 73.5-.1 198.9 .3 268.3-3.4 84.6-101.7 62-159.5 63.9-41.2-1-79.1-.6-120.2 .5l-.2 0c-58.3 1.8-106.9 1-172.7 .2-34-.4-62-27.5-62.9-61.9-1.2-44.8-.5-80.7 .1-119.8 1.3-48.6 .5-159 0-211.2-.3-35.5 28.5-64.5 64.1-64.4 42.8 .1 83.1 .3 87.8 .3L198 23.3zM147.6 286c4.6-38.1 46.7-26.9 73.5-26.1l0-35.9c0-17.7 14.3-32 32-32s32 14.3 32 32l0 36.1c27.2-.4 67.9-8.3 70.3 30.2-.2 38.9-42.8 33-70.3 33.8l0 27.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-28.1c-27.9-1.4-76.4 2.8-73.5-38z"],
    "anchor": [576, 512, [9875], "f13d", "M377.8 59.9c15.8 45-11.1 113-60.3 126.6 0 41 .6 99.4 1.1 147.7 .4 41.2 .8 82.6 1 114.9 82.6 4.1 136.8-52.7 157-133.6-16.1-.1-34-.1-46.4-.1-41.9-.2-41.8-63.8 0-64 43.9 1.4 119.7-13.7 113.6 55.2-17.3 119.1-110 221.4-248.2 206.7-136.1 8.1-269.1-59.3-277-206.2-1.6-26.3 18.3-47.2 42.5-49.7 32.1 1.2 108.8-26.7 112.1 26.3-3.7 45.3-53.8 28.6-88.9 35.7 13.9 86.1 85.7 125.6 171.4 128.9-.2-31.8-.6-72.5-1-113.2-.4-47.9-1.1-106.3-1.1-147-68.3-17.6-85-118-31.6-163.7 49.3-43.7 134.5-28.7 155.9 35.6zm-71.5 7.6c-36.6-19.2-70.7 26.6-41.3 56.7 14.4 5.8 41 6 48.4-14 7.4-23.7 8.3-32-7-42.8z"],
    "user-minus": [640, 512, [], "f503", "M148.8 21.4C279.9-61.3 430.9 114.7 311.2 219.9 178.9 340.5 7.8 119.3 148.8 21.4zm33.8 54.3c59.4-41.4 150 39.1 86 96.3-18.9 16.8-42.1 22.1-59.1 15.9-40.9-12-71.6-85-27-112.2zm109 309.5c18.9 3.2 34.4 6.5 46.5 12.8 17.2 6 49.5 65.6 46.8 83.6 .3 41.9 63.7 41.9 64 0-2.7-52.4-34.7-113-81.2-140.4-118.1-46.3-362.6-43.6-366.8 126.7-9.4 50.1 58.3 65.2 64 13.7-8.8-113.3 150-104.1 226.7-96.4zM481.5 257.8c34.8-.7 56.9-.5 83.9-.3 24.7-.2 74.5 6.7 74.6-33.5 0-39.6-48.2-29.9-73.2-30.5-27.7-.2-52.4-.5-88.3 .4-40.4 3-37.9 64.6 3 63.9z"],
    "scissors": [576, 512, [9984, 9986, 9988, "cut"], "f0c4", "M66.2 30.2c87.4-67.4 207.5 22.7 176.3 125.8 23.4 20.2 44 34.8 67.9 57.8 46.3-37.6 92.5-79.5 141.1-113 19.9-16 48.4-37.8 68.8-10.7 21 28.9-12.5 50.5-33.9 64.4-47.7 33-87.6 70.2-132.2 106-8.9 7.6-18.2 15.8-28.4 23.1-8.5 6.2-17.7 14-26.5 21.6-19.2 17.1-39 31.2-62.9 48.4 51.1 128.3-86 212.3-181.8 122.6-91.3-86.5 41.9-239.5 140.5-171.6 3.6-2.6 7.6-5.5 11.6-8.4 22.4-16 35.1-25.4 53.4-41.6-14.8-13.4-18-16.9-28.5-24.5-7.9-5.8-16.4-12.4-24.2-20.2-53.1 53.8-151.4 16.3-176.8-51.9-14.7-45-4.3-99.3 35.6-127.7zm76.2 40.9c-77.3-2.9-68.8 99.4 5.2 100.9 50.1-16.4 45.5-87.6-5.2-100.9zM373.5 311.4c12.9-20.5 39.1-16.6 55-2.3 32.9 19.2 68.9 47.4 101.2 64.3 38.3 16.8 12.9 75.3-25.5 58.7-18.3-8-35.4-19.9-48.6-29.2-25.9-25-108.4-45.5-82.1-91.4zm-226.2 42c-29.5-9-53.6 26.3-58.4 47.4-7.4 29.4 35.2 49.2 57.9 49.3 7.5 2 35.6-17 34.7-25.5 1.9-34.6 1.3-60.9-34.2-71.1z"],
    "bug": [512, 512, [], "f188", "M385.3-3.8c24.1 13.5 16.2 40.9 3.4 59.6-4.7 9.2-8.8 17.3-15.3 27.4 9.2 14.4 15.4 29 21.2 45.2 31.6-1 98.4-14.3 94.4 36.7-7.5 38.8-49.5 22-77.5 26.4 4.7 24.9 6.1 41.2 5.9 63.7 26.8-.8 67.5-3.3 67 33.5-1.5 36.8-42.5 30.9-68.3 30.5-1.1 20.6-4.2 42.8-10 64.4 30.2-.3 75.7-7 75.2 34.1-4.9 40.6-46.7 27.6-78.7 29.9-8.3 .1-16.6 .3-24 .3-52 89.5-194.5 80.8-245.5-.3-20.1 1.5-44.5-3-62.5-.2-41.3 6.6-51.6-56.2-10.4-63.2 17.4-2.8 31.9-1.7 47-.9-4.6-20.4-6.9-41.9-8.1-62.9L58 321.2c-17.7 .3-32.3-13.8-32.6-31.4s13.8-32.3 31.4-32.5l41.1-.7c-.2-20.8 .8-41.8 4.2-62.2l-38.6-2.4c-41.8-2.8-37.9-66.2 3.9-63.9l53.5 3.3c8.1-17.3 18.6-33.5 32-48-1.7-1.9-3.4-3.8-5.2-5.7-18.4-19.4-53.9-53.9-21.6-78.5 31.1-21.5 49.6 15.3 68.8 35.3 3 3.3 6.2 6.8 9.4 10.4 36.8-20.3 81.4-18 119.1-2.6 13.1-24 26.3-64.3 61.9-46.1l0 0zM242.1 97.8c-31.4 13.6-52.3 35.6-64.9 64.2 64 1.3 102.4 2.6 161.2 .6-5.3-17.5-15-42.8-25.1-52.5-11.7-12.7-56-20.7-71.3-12.2zM162.7 225.7c.8 70.8-10.9 154.7 38.3 203.3 115.6 69.4 157.6-53.8 152-153.9 .4-16.7 1-31.9-.9-48.9-65.9 2.8-119.3 1.1-189.4-.4z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M507.7 243.3c8.7 13.4 6.1 31.2-6 41.7-34.6 29.8-89.4 89.3-126.3 126.4-29.7 29.4-74.8-15.6-45.2-45.2 8.8-8.8 20.3-20.8 33.2-34.1 11.9-12.4 25-25.9 38.1-39.2-71.2 .1-141.9 .6-213.3 .5-17.5-.9-31.2-15.9-30.2-33.7 .9-19.6 19.1-32.5 38.1-30.2 87.3 0 158.9-.5 214.9-.5-25.2-24.2-56-49.1-80.5-73.2-12.6-12.4-12.8-32.6-.4-45.2 32.5-29.6 58.9 16.5 84 34.9 33 29.2 69 60.3 93.7 98zM176.8 484.7C55 491.4-7 466.8-.5 336.3 8.5 242.3-37.7 43.9 103 36.7l65.3 3c17.7 .8 31.3 15.8 30.5 33.4-.8 17.7-15.8 31.3-33.4 30.5l-64.5-2.9c-12.1 .2-17.6 4.6-21.9 11.7-14.8 27.2-13.3 74.1-15.2 106.6 2.9 58.2-9.7 134.8 8.8 187.7 3.4 4.7 12.8 12.7 56.6 14l47.6 0c41.8 .2 41.9 63.8 0 64z"],
    "arrow-right-arrow-left": [448, 512, [8644, "exchange"], "f0ec", "M344.4 15.2c-27.2-31.8-75.7 9.5-48.8 41.4 12.3 14.5 25.1 28.2 38.1 41.3-80.2 .6-272.8 2.8-300.1 1.4-41.8-2-45.1 61.6-3.3 63.9 23.3 1.2 167.9-.1 255.9-.9 23.8-.2 43.6-.4 55.6-.5-18.2 17.2-33.1 31.5-47.6 48.8-27.4 31.6 20.6 73.5 48.2 42.1 13.5-16.2 25.5-27.4 43.6-44.7l0 0c18.3-17.5 40.4-38.4 54.7-55.9 10.7-13.2 9.3-32.3-3.1-43.8-33.9-31.2-65.1-60-93.3-93.2zm-182.6 338c-23.9 .2-43.6 .4-55.6 .5 23.5-27 78.4-57.2 44.5-93.9-21.1-17.6-42.6-3.6-56 15.6-24.5 25.9-64.8 60.3-87.5 88.1-10.4 12.7-9.4 31.2 2.2 42.8l96 96c29.8 29.5 74.7-15.6 45.2-45.3l-39.3-39.3c79.5-.6 275.6-2.8 303.1-1.5 41.9 2 45-61.6 3.3-63.9-23.3-1.2-167.9 .1-255.9 .9z"],
    "arrow-up-from-line": [448, 512, [8613, "arrow-from-bottom"], "f342", "M71.8 184.3c36.1 36 68.5-22.5 97.1-45.7 8.9-9 17.3-17.3 24.6-24.4 0 5.1-.1 10.2-.1 15-.4 28.7 .1 55.4 .9 82.3 1 37.4 2 72.7-1.4 109.5-1.6 17.6 11.3 33.2 28.9 34.8 17.6 1.6 33.2-11.3 34.8-28.9 3.8-40.5 2.6-82.5 1.6-122.1-.8-25.9-1.2-45.8-.8-71.4 .1-6 .1-12.5 .2-19.3l72.3 72.2c29.6 29.4 74.8-15.5 45.2-45.2l-128-128c-14.4-15.3-41.9-11-51 7.9-3.6 7.6-23.1 25.3-31.4 32.7-12.2 10.9-25.8 24.5-41 39.7-23.8 30.8-79.2 52.6-51.7 90.9zM27 513.2l393.6 4.5c42 .3 42.4-63.4 .7-64L27.7 449.2c-41.9-.3-42.4 63.4-.7 64z"],
    "battery-full": [640, 512, [128267, "battery", "battery-5"], "f240", "M360.2 442.7c-96.3 5.9-179.9 7.7-277.1 .8-47.5-3.6-80.7-39.8-81.9-86.7-1.2-48.3-1.3-121.2-1.2-176.8 .2-61.3 47.2-114 110.7-115.6 34.6-.9 70-.7 99 .1 56.5 1.6 132.5 1 202.3 .4 63.3-6.2 124.9 35.4 128.9 103.1 2.8 41.9 2.5 66.2 2.6 100.9 11 140.2-55.7 175.7-183.4 173.6zm-5.9-63.8c91-3.9 133.9 4 125.3-104.2-6.1-42.1 22.1-144.4-51.6-145.7-114.1 2.2-207.8-1.6-315.7-.5-26.6 .7-48.3 22.8-48.3 51.7-.1 55.6 0 127.7 1.2 175.1-.8 36.5 58 23.1 74.5 27.2 72.3 3.3 141.1 .9 214.7-3.6zM576 192c.2-41.9 63.8-41.8 64 0l0 128c-.2 41.9-63.8 41.8-64 0l0-128zm-337.7 160c-38.7-3.9-88.9 9.5-122.5-17.5-26.7-24.1-18.1-59.3-19.8-92.3-1.8-42.4 30.2-79.6 73.3-81.8 65.8-1.1 117 1.1 186.6 .1 65.3-5.5 97.6 36 91.8 100.5 11.1 121.2-134.1 82.2-209.3 91.1zm138.6-67.9c2.9-.2 4.9-1 6.3-2.4 1.2-9.3 .2-22.1 .4-32.3-.7-3.3 1.7-17.1-3-22.6-3.4-4.1-19.5-1.9-24.4-2.4-67.3 .9-119.5-.9-183-.2-23.3 1.7-10 47.1-12.8 61.9 74.4 4.1 142.3 .1 216.5-2z"],
    "font": [512, 512, [], "f031", "M222.9 96c-59.1 11.2-93.7 85-95 148-.3 2.7-.5 5.4-.8 8.2 11.7-.1 23.6-.3 35.6-.4 72.8-2.5 147.9 2.5 220.8 3.9-8.1-50.4-12-102.6-54.8-137.9-26.2-25.1-63.2-30.9-105.9-21.7zM126.1 316.3c1.1 29.2 3.1 69.4 4.6 95.9l4.8 .3c24.3-.2 56 .5 56.6 32.9 0 17.7-14.3 32-32 32-25 .1-42.4-3.1-66.8-1.1l-60.6 1.1c-17.7 .3-32.3-13.7-32.6-31.4-.3-17.7 13.8-32.2 31.4-32.5l35.1-.6c-1.8-53-9.2-119.9-2.7-171.3 4.3-86.5 45.7-184.8 145.6-207.8 48.2-10.8 111.8-8.2 156.9 32.4 92.3 76 86.1 220.8 86.2 329.9-.2 5.9-.4 11.4-.5 16.7l30.6 2.1c41.7 3.1 37.4 66.5-4.4 63.8-44-4.9-88.9-.6-134.1-1.3-41.8-.1-42-63.7-.2-64 12.7 0 34.1-.1 44.1-.1 .7-28.8 2.9-68.9 1-93.2-74.8-1-148.1-6.6-222.8-4-13.2 .2-26.6 .4-40.2 .5z"],
    "language": [640, 512, [], "f1ab", "M236.8 17.4c-3.5-41.7-66.9-36.6-63.8 5.1l3.5 43.7c-40.2 .7-80.8 1.6-120.5 1.6-17.7 0-32 14.3-32 32s14.3 32 32 32c74.3 .1 148.5-3.1 222.5-2.5-5.8 10-11.9 19.4-18.9 29.8-15.8 24.1-30.5 49.1-50.5 71.2-2.9-2-5.7-4-8.4-5.9-32.1-14.8-53.8-68-90.8-40.3-36.8 38.1 30.7 74.1 54.8 93.3-25.9 20.8-60.4 39.4-93.2 52.5-16 7.6-22.8 26.6-15.3 42.6 11.4 24.5 38.7 19.9 58.2 8.4 37.9-16 71.4-36.5 104.7-66 37.5 24 80.4 46.6 122.5 61.3-14.2 32.5-27.6 67.8-40.2 101-6.2 16.5 2.1 35 18.6 41.2 43.1 13.8 47.7-43.4 61.2-70.6 47.1-1.4 90.7-1.4 138.8-6.4 8.8 25.5 16.4 69.4 53.4 57.6 22.3-7.3 26-32.5 16.3-51.5-31.7-91.3-63.8-179.5-106.3-268.3-15.5-29.8-53-19.2-63.3 9.4-23.7 39.7-43.1 80.5-56.9 127.3-33.3-11.6-68.6-29.6-101-49.6 34.1-41.7 60.3-87.1 89.1-134.6 24 3 56.5-.7 56.5-31.6 0-17.7-14.3-32-32-32-44.3-.3-90.3-4.1-135.4-3l-3.8-47.9zM497.3 379.4c-8.7 .8-17.7 1.5-24.9 2.1-17.5 .3-33.2 .8-48.7 1.3-5.2 .2-10.4 .4-15.6 .5 16.1-39.8 22.6-78.1 43.9-118.6 16.1 37.5 30.6 75.4 45.2 114.7z"],
    "shield-halved": [448, 512, ["shield-alt"], "f3ed", "M258.9 77c3.6 119.4-2 232.6-4.4 353 150.6-72.5 122.1-148.9 128.1-308.3-44.4-12.1-77.9-25.6-123.7-44.7zM190.5 427.2c1.8-120.8 9.3-235.8 3.4-356-40.1 13.6-88.4 30.8-125.9 48.3 0 55.6-6.6 108.4 1.4 164.3 14.1 65.8 71.8 113.8 121 143.5zM205.1 1.3c33.3-11.4 87.3 22.9 112.5 30.5 31.9 14.4 69.9 24.2 105.4 35.1 35.7 13.6 21.2 52.9 22.6 81.1l0-.2c8.1 181.9-16.2 286-205.4 358.7-8.9 3.7-19.1 3.2-27.6-1.5-79.4-23.6-134.7-77.4-179.6-141.2-39.9-59.2-30.4-134.8-29.9-199.4 5.2-27.8-10.1-68.2 15-89.1 36.3-25.3 70.4-32.2 107.8-47.8 21.3-9.5 55.9-19.7 79.3-26.2l0 0z"],
    "person-biking": [576, 512, [128692, "biking"], "f84a", "M378.3-.8c-28.5-3.9-58.6 17.7-57.8 44.5 1.2 20.8 7.4 47.9 43.7 51 27.4-2.5 49.7-15.8 52.3-45.9 1.4-12.2-3.5-35.3-22-42.5-5.8-4.5-11.9-6.3-16.3-7.1zM245.6 129.5c-13.6 12.7-15.4 14.3-26.1 24.2-5.4 4.3-23.3 22.9-24 22.8-46.8 31-40.3 68.5 7.6 91.7 11.6 7.5 22.8 14.1 32.4 23.3 36.5 29.5-12.1 131.6 58.4 121.6 28.5-8.4 22.8-46.7 23.2-69.5-1.7-47.2-18.8-92.3-61.1-118.9-14-10.2 2-18 11.4-27.7 9.3-8.5 16.1-14.7 22.4-20.8 3.7-3.5 5.6-6.9 9.6-7.8 6.5-.2 9.3 7.4 14 11.4 26.6 38.7 168.9 77.3 147.7-3.4-16.1-29.3-50.1-11.4-75.6-23.2-31-12.8-45.6-53.2-80.6-57.7-24.6-1.3-43.6 16.4-59.2 34zM125.8 284.9C295.2 304 222.1 564.6 58.5 498.5-51.8 446.7 5.2 264 125.8 284.9zM88.2 348.3c25.6-6 72.8 4.4 72.8 38.9-1 23.9-19 49.9-37.2 54.5-28.9 8.3-49.3 1.7-57.3-28.7-4.9-29.9-6.7-49.7 21.8-64.7zm457.4-27.9c-33.7-36-93.8-44.7-138.6-24.4-74.3 37.8-84 155.6-8.6 203.1 108.9 55.9 231.1-75 149.5-176l-2.4-2.8zm-108.4 32c7.6-5.3 48.3-2.7 59 8.7 12.6 16.3 17.2 38.3 12 52.7-2.8 7.8-15.6 21.2-36.3 29.4-20.9 8.3-35.1 5.7-40.4 1.6-28.9-19-29.4-74.2 5.7-92.4z"],
    "phone-xmark": [512, 512, [], "e227", "M123.3 78.9c-49.8 50-84.1 131.2-56.2 191 28.8 52.3 56.4 89.9 98.1 131.7 34.6 39 161.4 67.2 207.3 38.7 24-12.9 42.3-30.5 63-54-8-7-18-14.5-27.8-21.9-10.7-8-22.7-17-34-27.2-44.1 56.3-105.7 51.1-155.4 13.1-45.4-38.1-118.8-100-85.7-172.5 11.4-20.7 24.3-36.1 37.9-53.5-14.8-19.6-26.4-29.8-43.6-42.6l-3.7-2.9zM96.1 19.2c24.2-17.5 51-6.1 70 11.9 21.6 15.2 43.3 37.8 57.2 56.8 39.9 47.1-14.9 83.5-34.9 121.4-.5 .9-2.8 8.1 8 26.5 16.2 26.4 36.4 42.7 56.3 60.6 17.2 10.2 33.5 24.4 49.7 17.9 10.8-5.8 14.8-9.1 23.2-19.2 15.1-29.1 53.5-41.1 79.3-16.4 13.8 13.8 24.8 22.4 42.1 35.3 42.2 29.9 82.6 62.1 37.5 113.7-53.1 70.4-140.9 105-231.4 82.1-120.7-19.6-186.8-111.7-242-208.9-44.5-91.9 .3-193.8 58.2-257.9 7.8-10 17.6-17 26.8-23.7zM484.8 32.2c25.3 31-15.4 53.9-34.5 74 19.6 21.8 64 56.5 30.2 85.4-33.1 24.2-53.4-19.7-74.2-38.8-1.7 1.9-3.5 4-5.3 6.1-17.9 20.7-49.3 62.5-78.1 31.6-24.1-28.4 9.9-50.2 27.4-70.9 2.8-3.3 5.9-6.7 9.2-10.4-4.3-3.8-8.2-7.4-11.8-10.7-19.7-19.5-57.7-35.4-37.8-67.7 29.6-39.4 70.2 12.7 93.6 31.8 21.1-19.5 52.3-61.8 81.4-30.5z"],
    "globe": [512, 512, [127760], "f0ac", "M389.2 42.3c-171.7-101.2-373.8-17.6-386.8 187-5.2 64.2 10.7 138.5 57.1 191.4 49.7 55.3 132.3 101.7 211 89.6 125.1-14 264.1-134.8 239.1-275.5-7.1-77.4-42.1-154.6-120.3-192.5zm-155.6 20c10.6-.2 20.7 .6 30.8 2.3 34.8 46.6 50.8 101.4 55.6 156.7-19.9 .4-40.1 .2-60.6 .1-28.5-.2-47.5-.2-80.3 .3 5.6-56.4 25.2-107.4 54.5-159.5l0 0zM114.7 222.7c-17.2 .3-33.7 .5-47.4 .6 6.4-59.6 34.2-109.1 83.1-137.9-18.8 42.9-31.7 88-35.7 137.3zM68 287.3c13.6-.1 29.7-.4 46.5-.6 3 43.1 12.3 81.8 24.1 120.4-40.1-29.1-63.2-69.5-70.6-119.7zm110.6-1.6c32.9-.5 50.4-.5 78.8-.3 19.9 .1 40.2 .3 60.7-.1-1.2 21.6-3.4 42.6-10.5 61.3-10.8 36.3-21.4 65.4-38.9 99-16.3 3.4-31.7 3.8-50-.2-20.1-58.5-35.8-105.8-40.1-159.7zm204-3.3c12.4-.6 25.5-.6 39.1-.5 8.5 .1 17.4 .2 26.5 0-5.1 54.9-51.3 101.2-95.6 132.4 6-16.3 11.3-33.3 16.3-49.5 8.2-22.7 11.4-46.8 12.5-69 .3-4.7 .6-9 1.1-13.4zM443.2 218c-19.6 .2-38.8-.5-59.3 .3-4.4-43.7-12.4-82.8-26.9-120.4 47 19.7 74.6 65 86.2 120.1z"],
    "folder-minus": [512, 512, [], "f65d", "M147.7 88.5l51.5-1.2c12.3 11.8 32.2 32.1 45.2 50.1 30.9 45.9 100.3 25.3 147.7 28 17.4 2.3 50.4-11 52.8 14.9-.3 46.1-2 131.8 .7 173.2l0 63.4s-.1 .1-.1 .1c-72.8 1.2-144.1-2.4-216.8 .3l-.2 0c-58.6 1.8-104.2 1-170.3 .2-1.9-77.2 1.2-124.3 1-201.6 0-.2-.9-127.5-.9-127.7 45 0 82.3 .4 89.4 .3zm95.4-47.8c-22.2-25-68-15.7-97-16.2-3.8-.1-49.1-.3-90.3-.3-34.9 .2-63 33.3-61.6 64.4 .6 57 1.4 160.8 0 211.1-.6 39-1.2 75-.1 119.8 .9 34.4 28.9 61.5 62.9 61.9 65.8 .8 114.3 1.6 172.7-.2l.2 0c41-1.2 79-1.5 120.2-.5 57.7-1.9 156.1 20.7 159.5-63.9 0-68.7-2.6-161.1-.7-235.7-.8-67.7-60.9-87.9-119.4-79.7-30.2 .8-59.8 1.5-89.9 1.4-18.3-21.4-42.7-50.1-56.5-62.1l0 0zM182.7 257.3c-17.6-1.8-33.3 11.1-35 28.6-1.8 17.6 11.1 33.3 28.6 35 50.7 5.1 99.7 3.3 148 2.1 41.8-1.3 40.2-64.9-1.7-64-48 1.3-94.4 2.8-139.9-1.8z"],
    "poop": [512, 512, [], "f619", "M276.6 69c-5.2 51-46.3 97.6-100.8 102.2-32.4 4.1-63 16.4-57.3 51.1 29.1-5.6 71.6-10.9 73.3 28.1-1.3 36.4-36.1 30.5-63.5 35.2-36.5 8.4-68.4 32.5-66 68.8 4 46 17.2 64.1 32.2 73.7 20.5 16.8 90 18.1 133.2 21.2 57.2 2.1 149.8 17.4 194.1-26 42.4-54.2 30.8-112-36.8-137.9-10-4.4-17-13.7-18.6-24.5-1.6-10.8 2.4-21.7 10.6-28.8 16.3-16.2 18.3-23.6 10.2-41.9-8.8-16.1-29.7-32.1-55.3-37.7-16.3-3.6-27.1-19-24.9-35.5 1.3-11.2 3.3-21.1 2.2-28.8 0-.4-.3-3.3-10.4-11.2-6.1-3.6-14.5-6-22.2-8.1zM57.8 247.3c-22.6-77.7 41.2-136.3 112.9-139.9 18.2-1.5 36.5-17.8 41-37.9 7-22.3-9.1-37.8 4.9-56.3 11.6-15.7 29.1-13.9 47.6-11.9 49.7 4.1 116.3 37.1 109.2 97.5 57.1 22.9 102.8 86.5 73 146.9 77.3 46.7 82.4 148.4 26.1 216.6-36 44.8-93.8 52.2-147.3 54.6-49.2 1.5-96.3-3.9-139.7-6.4-45.9-2-91.1-6.4-125.7-28.7-72.4-44.1-88.6-188.3-2-234.7z"],
    "speaker": [512, 512, [], "f8df", "M309.2-3.8c45.8 2.8 93.7 1.8 140.4 4 45.5 5.5 32.4 60.8 35.1 93.8-.7 90.4 11.5 184.1 3.6 275.3-4.4 37 2.2 76.3-7.7 111.3-.3 17.6-14.7 31.7-32.3 31.6-98.9-.5-216.8-2.4-299.6-1-37.7-3-101.2 17.5-107.6-37.1-1.9-38.6-9.7-78.1-8.5-118.5 .4-98.5 0-216.2 0-323.4-.5-22 21.3-35.1 41.5-32 80.2 3.3 158.9-9.2 235.2-4l0 0zM103.9 447.6c98.3-1.7 203.4-.6 317.2 .3 .6-25.2 1.8-50.4 2.9-75.2 2.3-54.9 5.9-105.3 .3-160.4-4.2-37.8-2.7-78.4-3.6-117.7-.2-10.3-.4-20.8-.5-31.4-111.6-6-211.8-1.7-323.6 .9 3.6 134.4-8 256.8 7.4 383.5zm87.7-235.9c42.9-28.3 105.9-14.8 141 12 68.3 45.8 37.5 145.5-20 184.9-113.6 75.9-233.9-128.3-121-196.9zm33.3 54.7c-34.1 26.6-3.3 85.3 32.6 94.2 27.5 4.2 52.8-42.3 49.9-66.3-.8-8.2-3.9-13.2-9.2-16.6-26-17.7-49.5-24.3-73.3-11.3zM270.2 93.1c19.6 9.8 22.7 25.5 22.6 42.1-6.9 33-34.2 35.7-55 28.2-47.6-19.8-16.9-88.4 32.5-70.3z"],
    "battery-quarter": [640, 512, ["battery-2"], "f243", "M360.2 69.3c-96.3-5.9-179.9-7.8-277.1-.8-47.5 3.6-80.7 39.8-81.9 86.7-1.2 48.3-1.3 121.2-1.2 176.7 .2 61.3 47.2 114 110.7 115.5 34.6 .9 70 .7 99-.1 56.5-1.6 132.6-1 202.3-.4 63.3 6.2 124.9-35.4 128.9-103.1 2.8-41.9 2.5-66.2 2.6-100.9 11-140.2-55.7-175.7-183.4-173.6zm-5.9 63.8c91 3.9 133.9-4 125.3 104.2-6.1 42.1 22.1 144.4-51.6 145.7-114.1-2.2-207.8 1.6-315.7 .5-26.6-.7-48.3-22.8-48.3-51.7-.1-55.6 0-127.7 1.2-175-.8-36.5 58-23.1 74.5-27.2 72.3-3.3 141.1-.9 214.7 3.6zM195.5 349.8c43.6-4.1 66-45.4 60.3-88.9 7.3-60.5-30.4-104.8-90.8-100.6-79.7-.1-69.8 82.6-68.9 135.1 .9 54.5 53.7 62.4 99.3 54.5zM164.7 288c-1.5 0-3.1-.1-4.6-.1 1.2-18.5-2.9-44.9 1.5-63.7 10.3 .3 30.6-1.3 30.2 12.6 .2 10.6 0 17.9 .1 26.9 .1 7.3 .1 13.9-.2 20.9-8.5 4-20 2.6-26.9 3.4zM576 320c.2 41.9 63.8 41.8 64 0l0-128c-.2-41.9-63.8-41.8-64 0l0 128z"],
    "diamond": [576, 512, [9830], "f219", "M260.8 4.8c32-27.1 68.8-6.6 89.8 19.6 52.4 41.9 103.4 91.2 149.4 141.4 18.6 24.1 62.4 54.4 61.4 86.4-48.4 84.1-145.5 175.4-213.3 249-19.2 17.5-35.9 39.9-65.7 17.4-58.3-52.3-128.3-92.6-175.2-154.2-19.4-23.6-45.4-48.7-65.5-70.6-46.1-51.3 22-98.5 54-133.9 56.8-52.4 107.8-103.9 165.2-155.1zm34.4 54.8c-67.6 64.4-138.8 127.4-202 195.5 65.8 73.4 132.1 144.1 212.5 198 63.6-65.7 127.9-134.2 182.9-205.3-59.3-68.4-124.3-128.5-193.4-188.2l0 0z"],
    "computer-classic": [512, 512, [], "f8b1", "M406.3 512.1c-75.3 .3-289.9 .9-310.8-.1-26.4-3.3-36.7-17.2-52.4-32.4-21.3-26.5-38.7-38.9-42.5-70.6-3.2-49.2-.9-244.9 .3-329.8 3-102 132.8-76.4 198.7-78.2 52.4 2 122.9 1.3 187.8 .6 54.3-5.6 114.5 6.2 120.1 71.3 3.5 49.3 5.8 115.3 5.4 148.6-.5 46.4 0 131.9 .2 164.9 .1 14.7-3.9 29.1-11.4 41.7l-27.2 45.2c-14.3 23.9-40.1 38.7-68.2 38.8zM102.9 448.2c35.1 .8 229.8 .2 303.1-.1 5.5 0 10.6-2.9 13.5-7.7l27.2-45.2c6.1-37.7-.4-122.1 2.1-174.3 .3-31.1-1.9-95.3-5.2-143.5-.4-6.6-6-12.3-14-12.2-124.1 4.1-233.2-4.1-352.9 1.2-6 .4-11.7 5.5-11.9 13.7-1.2 86.5-3.4 277.4-.5 324.2 8.2 11.3 25.6 34.1 38.5 43.9zm2 1.3s-.1-.1-.3-.2c.2 .1 .3 .2 .3 .2zM213.5 98c38.4-1.8 77.3-2.6 115.6-1.3 26.1 2.6 82-6.6 86.3 36.5 2.2 20.9 1.7 92.4 1.5 113.8-.2 20.8-16.4 38.3-37.6 39.5-68.4 3.4-125.2-.3-196.4 1.1-97.4 9.2-82.6-34.7-85.9-110 .7-95.3 43.6-74.7 116.4-79.6zM162 163.9c-1 5.9-.9 13.2-.8 20.4 .2 13.8-.3 22.6 1.3 39.4 67.7-1.1 125.9 1 190.6-.1 .1-19.4 0-43.8-.4-61.9-64.7-3.8-125.9 .3-190.8 2.2zM385.4 384l-80 .7c-41.9 .2-42.4-63.5-.6-64l80-.7c41.9-.2 42.4 63.4 .6 64z"],
    "grid-round": [512, 512, [], "e5da", "M223 121.4C232.8 50.5 160.7-27.2 86.2-8.8 24.1 8.7-18 79.9-1.3 141.9 27 254.9 205.3 236.1 223 121.4zM104.3 52.6c21.2-7.9 61.3 38 55.9 56.9-5.9 31.1-37.7 51.3-70.4 43.4-54.2-13.9-28.7-89 14.5-100.3zM471.1 21.2c-96.6-81.6-222.8 46.6-187.4 148.2 22.5 64.6 111.9 70.8 166.3 39.7 74.4-33.5 87.1-136.2 21-187.9zM345.1 113c10.8-33.8 50.3-72.2 84.3-43.2 29.3 25.1 30.7 62.3-9.1 82.7-40.3 21-94.4 14.6-75.2-39.5zm48.7 174c164.1 2.8 135.5 230.9-18.3 229.2-138.1-9.8-100.4-233.2 18.3-229.2zm1.7 64c81.2 4.2 42.4 106.5-19.5 101.2-43-3.6-27.7-102.4 19.5-101.2zm-202-27.2C140.4 258 46 294.1 15.1 357-8 411.5-2.9 491.1 62.6 519.9 171.8 561.7 265.4 407.4 193.4 323.7zM73.5 383.1c5.5-18 54.6-43.8 68.8-20.8 10.6 14.1 15.5 35.2 12 47.6-30.3 83.7-112.8 62.3-80.8-26.8z"],
    "arrow-left": [448, 512, [8592], "f060", "M247.9 89.7c28.3-30.7-18.3-74.2-46.9-43.6-52 56.5-136.1 146-185 191.9-16.2 15.7-16.1 41.6 0 57.3 10.5 10.3 28.8 28.4 34.2 34.8 45.6 54.1 106.1 91.7 149.9 142.6 11.5 13.4 31.7 15 45.1 3.6 41.7-40.6-50.2-92.2-73.2-118.4-26.5-22.6-51.3-43.9-72-68.1 93.7-.1 187.6 2.5 282.1 1.7 25.6 1.2 65.7 5.1 66.3-31.6-.5-34.1-36.2-33.2-62-32.4-88.6 .3-177.3-1.1-266.9-1.9 48.6-48.5 83.5-88.5 128.4-136z"],
    "paw": [512, 512, [], "f1b0", "M365.3 7.5c57.5 38.5-10.5 109.5-60.9 80.5-23.7-13.7-21-48.2-11.1-69 13.4-30.1 52.9-31.6 72-11.5zM216.8 17.5c27.4 27.3-6.7 93.2-50.3 79.1-78.3-28.2-9.5-151 50.3-79.1zM73.8 143.2c41.1 32.7-9.2 106.5-53.7 69.7-27.1-22.5-25.2-79.5 21.2-87.6 13.9-1.6 26.7 6 32.5 17.9zM195.7 158c56.9-33.4 114.1 .8 159.5 36.7 64 55 102.4 82.6 121.2 162.4 16.4 116.5-124.9 195.9-212 108.3-81.1 78.5-240.4 55.9-233-75.8 3.6-68.5 53-110.4 90.6-158.8 17.3-22.1 42.5-54.2 73.8-72.8zm53.8 239.6c23-16.4 46.3 6.9 60.9 23.3 22.1 21.6 48.9 21.9 70.3 9.7 101.7-62.3-58.8-199.2-130.4-222.4-46.7 3.5-68.6 57.7-101.5 90.7-74.1 70.5-80.4 181.5 46.8 137.8 18.1-8.6 33.8-28.9 54-39.1l0 0zm211.3-268c11.1-.4 21.2 4.9 27.2 13.3 41.6 25.6 9.9 91.4-36.4 83-52.4-10.4-49.1-91.5 9.2-96.4z"],
    "bed": [640, 512, [128716], "f236", "M31.9 22.7c17.7 0 32 14.3 32 32 0 41.9 .4 84.1 .9 126.6 .5 46.1 .9 92.5 1 138.7 29.2-.4 61.1-3 90-2.5l0 0c33.1 .3 65.5-2.8 97.6 .2 14.8 1 26.2 1.2 40.4 1.4 7 .1 14.1 .3 21.3 .5-6.1-65.3-1.9-122.6 2.6-187.5l0-.1c.2-2.1 .5-4.1 1.1-6.1 4.9-31.6 32.9-30.9 58-32.1 47.5-1.6 112.2-1.4 160.2 2.6 30.1 4.4 55.2 8.6 78.7 38.6 9.2 13 11.8 27.2 12.6 37.6 6 78.7 6 211.8 6 280.8 .4 18-14 32.8-32 32.8-48.7-5.2-27.6-60-32.1-97.9-91.8 2.5-183.9-.9-276.4-5.2-15.7-.2-35.5-.8-50.1-1.9-59-2.1-117 1.2-175.6 2.7-.3 .1-.6 .3-1 .4-3.6 33.5 19.8 99.3-30.6 103.7-50.3-4.9-26.8-69.6-33.5-104.4l0-.1C.8 316.8 1.8 249.3 .7 182l0-.2c-.4-42.3-.9-84.8-.9-127.1 0-17.7 14.3-32 32-32l.1 0zM379.5 161.4c-2.4 59.9-6.4 99.7 .2 161.5 62.6 3.5 126.4 1.7 190 1.3-1.1-55.3-1.5-109.4-6-151.5-.1-.5-.3-.7-.3-.8-6.4-7.2-9.4-6.1-22.2-10.5-47.8-5.9-113.7-4.9-161.4-3.8l-.3 3.7zM282 166.3c5.2 29.9-1.8 58.4-16.6 81.6-30.8 42.5-85 39.7-124.6 22.2-61.3-36.5-41.7-110-8.5-146.5 46.4-45.3 135.1-27.2 149.7 42.6zm-102.2 .3c-12.9 14.3-17.8 31.6-11.8 45.2 7.6 6.1 33 9.2 43.4 1.7l.1-.1c6.9-10.7 9.8-23.1 7.5-36 .3-11.9-29.9-18.3-39.1-10.8z"],
    "heart-slash": [576, 512, [], "e78e", "M8.9-25.6c13-12 33.3-11.1 45.2 2 164.1 179.1 355 332.4 512.8 519.4 26.8 31.9-21.7 73.3-48.9 41.3-86.1-101.9-183.9-195.3-281.6-288.5-77.7-74.1-156.2-149-229.5-229-11.9-13-11-33.2 2-45.2zM423.1 112.2c-30.6-1.7-66.7 9-95.8 24.8-15.6 8.4-35 2.7-43.4-12.9-27.2-56.5 102.1-78 142.8-75.8 135.8 5.5 167.4 175.7 78.8 261.3-28.3 30.8-75.4-11.7-47.5-42.9 54-50.1 43.7-151.7-34.9-154.5zM80.6 187.8c7.7 109.6 121.6 179.9 193.2 255.4 41.9-47.8 91.8 15.3 39.6 50.9-58 54.2-112.8-40.1-153.1-70.2-63-58.6-143.5-137.9-143.7-236.1 .1-41.9 63.9-41.7 64 0z"],
    "fill": [576, 512, [], "f575", "M192.6-13.1c-26.5-32.4-75.9 7.6-49.7 40.3 15.9 19.4 31.9 33.8 48.3 52.1-1 1-2 2-3 3-14 12.9-23.3 28.8-39.1 42.8-20.8 20.4-40.3 43.6-64.4 63.5-58.2 49.1-117.8 106-64.2 189.2 41.3 63.3 113.9 125 191 130.6 31.1-.4 54.9-25.2 74-43.4 15.8-15.3 31.4-31 46.7-46.5 15.8-16 31.7-32 47.2-48 111.8-102.2 88.2-125.4-15.6-216.1-12.4-11.4-25.6-23.5-38.3-34.9-21.7-19.6-42.8-38.5-62.9-58.4-2-2.8-4.5-5.3-7.2-7.3-20.1-21.5-43.4-44.6-62.6-66.8l0 0zm40 141.5c1.2-1.2 2.4-2.5 3.7-3.8 15.5 14.6 31.2 28.7 46.6 42.6 12.3 11 23.9 21.6 36.3 33 12.5 11.6 25.4 23.4 38.4 34.8-87.6 9.1-164.9 7.5-249 18 5.8-5.3 11.7-10.6 18-16.2 37.9-33.1 71.4-69.8 106-108.5zM334.9 324.2l-1.4 1.5c-40.6 39.1-77.2 84.2-122.1 117.9-.5 .3-1 .4-1.3 .6-55.3-9-125.8-67.7-144.9-121.9l.5 0c7-.8 14-1.6 21.1-2.4 94.1-12.8 177.4-11.4 272.7-20.8-8.3 8.4-16.5 16.8-24.5 25.1zM486.1 347l-.1 .1c-26.2 31.3-51.6 52.1-65.5 90.9-24.8 61.9 31.5 118.7 91.3 105.7 62.3-9.6 84.7-85.1 57.4-132.1-8.7-19.7-22-39.3-29.9-56.5-8.6-20.8-38.8-25.5-53.2-8.1zm16.5 78.3l1.2-1.4c12.8 20.9 21.8 51.5-3.4 56.8-35.4 5-18.7-30.5-5.2-46.8l.2-.2 .5-.6c2.1-2.5 4-4.7 6.6-7.7z"],
    "landmark": [576, 512, [127963], "f66f", "M300.1-31.9c-20.6-7.6-32.6 5.9-52.8 14.7-29.1 14.6-70.5 35.4-107.4 57.6-46.1 31-102.2 58.8-107.7 118.3-.3 16.5 13.8 31.4 30.3 32l1.2 171.7c.2 17.7 14.6 31.9 32.3 31.8 17.7-.1 31.9-14.6 31.7-32.2L126.5 189c22-.4 43.8-.5 66.7-.4l-2.7 177.1c-.3 17.7 13.9 32.2 31.5 32.5s32.2-13.9 32.5-31.5l2.7-177.8c24.4 .1 48 .2 72.1 1-1.7 59.6-3.3 130-5 175.6-1.2 41.8 62.4 44 64 2.2l1.2-33.5 0-.4c.4-20.5 2.8-104.9 3.8-142.2 6.9-.1 13.8-.2 20.5-.3 12.4-.2 24-.4 34.8-.3 .4 32.9 1.4 129.2 1.5 140.1l-1 37.2c-.5 17.7 13.5 32.4 31.1 32.8 17.7 .4 32.4-13.5 32.8-31.2l1-37.6c0-10.3-1.1-107.9-1.5-141.3 38.1-1.7 37.6-48.5 21.1-74.4-22.1-29.3-52.7-38.6-81.2-60.6-48.1-32-98.8-66-152.3-87.6l0 0zM420.8 111.5c7.6 5.1 15.2 10.1 22.8 15.1-65.6 2-131.9-2.4-196.7-2-39.7-.1-80.4-.4-118.5 .3 40.4-31 103.3-62.8 144.6-83.5 5.8-2.9 11.3-5.7 16.4-8.3 43.3 19.4 89.8 50.7 131.3 78.3zm88.7 342.2c-151.9 3-304.2-6.7-456.6 .5-41.9 1.4-39.9 65 1.9 64l56.6-1.6 .3 0c132.4-4.3 265.7 4.5 399.3 1.2 41.9-1.1 40.4-64.7-1.3-64z"],
    "music": [512, 512, [127925], "f001", "M416.9 75.4c.5 20.7 1.2 44.5 2.1 58.9-75 32.5-150.6 49.9-226.8 80.7l-2.4-61.4c15.5-5.6 28.3-10.7 45.2-15.3 60-20.6 122.3-38.6 181.8-62.9zm3.8 127.3l0 10.5c-.2 29.4 .5 58.7 1.3 85.9-110.8-36.9-172.5 80.9-95.2 160.2 41.1 37.2 103.5 34.3 137.2-6 38.4-44.9 20.6-94.2 22.4-142.5-1-31.3-2-63.5-1.8-97.7 .8-51.8-3.3-95.1-4.1-151.3-.8-35.2-34.8-63.6-71.5-52-83.4 33.5-169 58-254.7 88-16.1 4.4-31.6 21.3-29.3 35.6 .2 4.1 7.5 192.5 7.5 192.5-144.7-48.8-183.3 160.2-45.5 184 25.2 2.3 58.2 2.4 79.7-23.1 12.9-13.8 33.3-35.6 33.3-70.8 .1-1.3-5.2-132.4-5.2-133.8 10.6-3.8 21.6-8.2 32.1-12.3 67.4-26.4 127.9-40.4 193.8-67.5zm-7.2 160.7c6.4 3.5 8.8 8.2 11.2 13.7 3.9 34.8-24.6 58.8-54.5 35.1-11.3-11.7-19-35.3-9.3-48.7 11.9-11.6 32-6.5 52.6-.1zM136 418c-.5 7.4-4.1 12.3-18.2 27.6-15.5 3.6-39.8 2.4-48.2-16.3-7.2-12.3-3.8-44.4 11.9-45.1 39.9 .8 50 3.7 54.5 33.8z"],
    "files": [512, 512, [], "e178", "M348.6-26.4c-9.1-.5-108.9-6-155.4-5.6-33.3 .1-55.7 30.3-50.4 61.8-.3 18.3-.6 33.3-.8 46.5-2.7 81.5 .8 183.9 5.3 281.3 1.2 29 24.3 52 52.9 53.5 10.2 .5 20.9 1.2 26 1.5 26.1 2.3 56 4 82.5 2l.4 0c17.7-1.1 30.6-1.3 48.3 0 20 1.5 42.3 .9 62.8 1.2 71.6 6.9 76.7-47.7 72.4-104.7-1.3-50.9 .6-102.8-1.8-153.1-3.2-29.2 7.1-59-16.5-82.6-10.7-11-22-22.5-29.6-31.1-24-24.5-54.4-67-96.1-70.7l0 0zm0 0l0 0zM205.9 78c.3-13 .5-27.8 .9-45.9 47 .5 126.8 4.8 137.8 5.4 17.3 9.7 40 35.7 51.9 48.9 8.2 9.3 19.3 20.7 29.9 31.5-.9 16.2-.2 29.5 .6 44 2.2 51.2 .3 104.1 1.7 154.9 .3 12.3 .6 23.4 .1 35l-7.7-.1c-37.7 .9-77-3.7-115-1.2l-.4 0c-33.3 2.6-60.8-1.3-94.8-3-4.5-99.7-7.5-188.2-5-269.6zM77 135.2c-1.2-41.7-64.9-40.3-64 1.6 2.8 110.3 4.1 220.5 4.3 330.9 .1 42.5 33.9 78.5 78.1 78 18.2-.2 36.9-.6 53.8-1 45.7-1.7 79.7 .1 123.9 .7l94.2 6c17.7 1.1 32.9-12.3 34-29.9 1.1-17.6-12.3-32.8-29.9-34l-95.2-6.1c-13.3-.2-26.5-.4-40.3-.8-31.8-1.1-53.3-.8-89.1 .1-17.3 .4-36 .8-52.3 1-6.9 .1-13.3-5.4-13.3-14.1-.3-110.8-1.5-221.5-4.3-332.4z"],
    "underline": [512, 512, [], "f0cd", "M450.4 60.8c-.1-17.7-14.5-31.9-32.2-31.8-17.7 .1-31.9 14.5-31.8 32.2-1.5 51.8 .6 104.3 1 156.5 0 52.6-33.4 95.4-87.6 119.1-112.1 45.4-187.8-69-174.7-171.1l.2-100.9c0-17.7-14.3-32-31.9-32.1-17.7 0-32 14.3-32 31.9l-.2 101c-17.4 150.3 112.7 294.6 264.3 229.8 71.1-31.1 126-93.3 126-177.7-.4-52.5-2.4-103.9-1-156.9l0 0zM107.2 540.5c117.2 2.4 233.1 .4 351.5 4.1 41.7 3.4 47.1-60 5.5-63.8-117.1-4.2-233-1.7-351-4.2-32.9 2.4-98.8-14.4-96.6 36.7 7.6 43.1 60.3 22.6 90.6 27.2z"],
    "plus": [448, 512, [10133, 61543, "add"], "2b", "M258.4 52.8c0-17.7-14.3-32-32-32s-32 14.3-32 32c-1.9 54.8-6.5 113.3-5.6 169.4-53 .5-106 1.7-159.1 4.1-17.7 .8-31.3 15.7-30.5 33.4S15 291 32.6 290.2c51.7-2.4 103.5-3.6 155.5-4.1-.3 31 .5 62.7 1.6 93.1 6.9 34.8-16.9 100.6 33.7 105.5 51.4-4.9 26.5-73.2 30.3-107.2-1.1-31.2-2-61.1-1.6-91.7 55.7 .1 111.6-2.8 166.7-2.8 17.7 0 32-14.3 32-32-4.9-53-79-25.6-114.3-30.6-28.3 .8-56 1.4-83.7 1.4 .5-37.5-.2-72.5 3-110.8 1.2-18.8 2.6-38.7 2.6-58.3l.1 0z"],
    "bell-ring": [576, 512, [], "e62c", "M476.9-8.8c67.5-60.4 142.2 208.3 63 201.2-17.7-.7-31.4-15.5-30.8-33.2 1.9-37.4-8.3-95.7-34-122.8-12-13-11.3-33.2 1.7-45.2l0 0zM108-4.2c11.7 13.2 10.6 33.4-2.6 45.2-28.3 24.5-43.9 81.5-45.7 118.9-1 17.6-16.2 31.1-33.8 30.1-79.4-.4 20.6-260.7 82.1-194.2zm99.6 113c-19.9 41.3-9.8 107.1-19.3 161.6-14.3 27.6-30.7 53.3-43.4 81.7 93.5-3 185.7-7.4 279.1-2.3-22-42.1-36.8-80.3-36.8-80.3l0 0 0-.1c-6.9-26.2-3.5-54.7-3.1-82.8 5.1-59.5-30.1-116.4-81.3-123.4-54.2-5-75.2 2.5-95.1 45.6zm-2-93.2c128.2-65.1 255.9 44.9 242.2 176.5-1.6 19.6-.1 36.2 .1 56.1 15.1 32.9 30.3 73 49.9 101.4 8.6 14.6 20.8 33.8 9.6 50.4-5.8 9.7-16.2 15.6-27.5 15.6-31.5 0-60.1-1.8-87.6-3.5-83.2-8.4-167.6 2.3-252.3 4.1-22.2-.3-56.9 6.7-71-15.4-5.8-9.1-6.7-20.4-2.3-30.2l32-72c7.7-16.4 20.2-35.5 29.2-51.2 .7-77.3-1.2-185.1 77.6-231.7zm10.4 462.8c.2-17.7 14.6-31.9 32.3-31.7l87.9 .9c17.7 .2 31.9 14.6 31.7 32.3-.2 17.7-14.7 31.8-32.3 31.7l-87.9-.9c-17.7-.2-31.8-14.6-31.7-32.3z"],
    "copy": [576, 512, [], "f0c5", "M514.4-1C414-10 302.7-15.4 199.7 .3l0 0c-22.7 3.5-39.2 22.4-40.4 44.6-5.3 94.8-10.4 200.4-2.3 294.6 1.7 25.3 22.8 44.8 48.1 44.6 78.1-.6 215.6-1.5 304.6 0 26.5 .2 48.2-21.1 48.2-47.8l0-289.7C558 21.6 538.8 1.2 514.4-1zM221.7 76.8c.3-5 .5-10 .8-15.1 86.8-11.6 181.2-7.9 271.5-.2L494 320c-69.8-1.2-153.7-.7-227.4-.2-16.1 .1-31.8 .2-46.7 .3-6.2-83.4-2.3-161 1.8-243.2zM97.1 161c.4-17.7-13.5-32.4-31.2-32.8s-32.4 13.5-32.8 31.2c-2.8 108.4-3.5 216.7-.4 325.4 3.9 56.4 71 51.2 124 47 15.9-1.2 30.5-2.4 41.8-1.7l.4 0c29.5-2.1 58.4-2.5 87.3-2.9 17.5-.2 34.9-.5 52.5-1.1l.2 0c9.2-1.5 20.4-1.1 32-.6 30.7 1.3 63.7 2.6 66.6-32.7-2.9-36.9-39.3-34-71.1-31.5-10.8 .8-21 1.6-29.2 .8l-.3 0c-17.5 .6-35.1 .9-52.8 1.1-30 .4-59.9 .9-89.1 3-34.2 2-65.4 3.6-99 2-2.5-102.3-1.8-204.6 .8-307.3z"],
    "box": [512, 512, [128230], "f466", "M101.5 15.2C116.4-3.9 141.9 1.8 163 1.3l218.6 0c11.7 0 22.5 5.1 29.9 13.5 22.5 25.6 43.5 55.1 63.3 82.9 12.9 22.1 33.5 36.8 37.8 61.5 7.9 83.5-.4 219.8-1.2 313.1-.1 21.5-17.4 39.5-39.5 39.8-65 1-128.6 .6-190.6 3.2-67.3 3.1-135.9 3.6-202.9-3.5-22.9-1.7-66-.3-71.5-27.5-6.6-38.5-.5-108.8-2.1-148.5 4.4-63.2-12.3-120.6 1-182.2 13.6-27.3 29.8-43.6 45.5-69 15.9-23.5 31.7-47.1 50.4-69.4l0 0zm41.9 49.9c-13.1 16.6-26.2 36-38.7 54.6-3.3 4.8-6.6 9.7-9.9 14.6 41.6 .9 78.7 .7 116.2-2.4 6.2-.4 12.6-.9 19-1.2-1.1-19.4-2.7-46.1-3.9-65.4-28-.1-54.3 .2-82.6-.2zm146.8 .2c1.2 19.5 2.7 43.3 3.7 63.1 42 1.4 82.7 4.1 125.8 2.5l-.3-.4c-16.1-22.7-31.4-44.3-49-65.2l-80.3 0zM67 253.2l0 .3c3.4 60.8 .7 130.3 1.2 193.7 68.8 6.3 137.9 8.2 209 4.3 62.3-2.6 100.9-2 170.3-3 1.5-79.9 6.7-180.1 3.2-253.9-11.6 .4-23.2 .2-35.5 .4-66.2 2-129.7-6.3-197.2 .7-47.4 4.1-104.2 3.4-152.8 2 .1 18.2 .9 36.4 1.7 55.5z"],
    "arrow-rotate-right": [512, 512, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M284.4-.4c-358.7-10.2-377.7 555.6 2.5 504.4 80.6-7.1 142.5-48.4 185.1-113.1 9.7-14.8 5.6-34.6-9.2-44.3s-34.6-5.6-44.3 9.2C362.2 452.2 205.8 471.3 124.8 404.8 22.6 302.6 77.1 101.5 220 70 294.3 48.2 356.7 81.8 416.6 128l-61.2 0c-41.8 .2-41.9 63.8 0 64 32.7 .2 94.6-.5 127.5 0 17.4 .6 32.9-14.6 32.5-32l0-128c-.2-41.8-63.8-41.9-64 0l0 42.2c-2.5-1.8-5.2-3.6-7.8-5.5-47.1-33.1-94.5-65.4-159.1-69.1z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M101.7 322.2c-.8-88-2.1-232.5-.9-255.9 .9-17.7 15.9-31.2 33.6-30.3 17.7 .9 31.2 15.9 30.3 33.6-1.1 21.2 .2 156.2 1 244.4 .2 24.2 .4 44.8 .5 58.7l39.3-39.3c29.7-29.4 74.8 15.5 45.3 45.2l-96 96c-11.6 11.6-30.1 12.5-42.8 2.2-27.9-22.7-62.2-63-88.1-87.5-19.2-13.4-33.2-34.9-15.6-56 36.7-34 67 21 93.9 44.5-.1-12-.3-31.8-.5-55.6zM322.7 133.5c-17.1 1.1-31.8-11.4-33.8-28.2-2.1-17.7 10.7-33.5 28-35.6 54.5-3.6 91.8-1.4 136.6 1.2 28.2 1.7 56.6 3.3 91.6 3.3 17.7 0 32 14.3 32 32s-14.3 32-32 32c-37.1 0-67.6-1.8-95.9-3.5-42.4-2.5-76.7-4.4-126.6-1.3zm69.2 157.8c-30.9-3.6-101 20.2-104.8-30.5 3.9-48.6 65.3-27.7 98.5-33.3 36-1.1 72.9-2.2 110.6-.6 17.7 .7 31.4 15.6 30.6 33.3-.7 17.7-15.6 31.4-33.3 30.6-36.5-1.5-68.2-.5-101.7 .6zM320.8 447.8c-41.8 .5-42.9-63.1-1-64 62.8-1 45.4 1.8 107.2 .8 17.7-.3 32.2 13.8 32.5 31.5 .3 17.7-13.8 32.2-31.5 32.5-62.7 1-45.5-1.8-107.2-.8z"],
    "compress": [576, 512, [], "f066", "M152.4-11.3C135-8.1 123.5 8.6 126.7 26l6.5 35.3c.6 11.6 1.3 22.5 2.1 33.7 0 0-73.2-.9-75.7-.9-39.1-1.1-45.1 60-2.6 63.9 4.6 .2 88.1 1 94.8 1.2l.7 0c58.3-2.7 47.6-61.5 44.5-102.9 .4-1-7-39.6-7.4-41.9-3.2-17.4-19.9-28.9-37.3-25.7zM64.4 364c-41.9-.1-42.3 63.5-.4 64l65.9 .5 2.4 0c1 25.7 2.1 61 2.3 82 .5 41.8 64.1 41.4 64-.5-.2-26.8-2-75.1-2.9-99.6-1.2-35.3-35.2-50.5-65.5-45.9L64.4 364zm417.7 2.1c-37.2-.8-83.6-.8-86.9 46.5l-4.6 89.5c-2 41.8 61.6 45.1 63.9 3.3l3.9-74.7c9.2-.2 18.4-.5 27.4-.7 31.2-3.6 83.8 11.6 86.4-33-3.2-46.1-57.4-29.1-90-30.9zM456.5 25.9c-.2-41.8-63.8-41.9-64 0 .6 21 5.9 67.4 8.2 90.3 6.4 46.6 50.5 45.7 84.5 41.9 15.1 0 37.1-2.3 51.4-1.3 17.6 1.3 32.9-12 34.2-29.6 2.2-37.1-40.2-36.7-65.3-33.9-5.5 .3-10.1 .5-16.8 .6-7.9 .2-17 .4-25.8 1-1.8-16.8-6.1-58.8-6.3-69z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M485.7 360.5c121.8-280.8-184.1-469.2-400.8-293.9-147.6 125.1-94 422 110.4 442.4 122 16.2 239.8-24.2 290.4-148.5zm-358-246.2c92.7-83.4 270.4-63.6 312.5 61.8 32 87.8-26.4 256-143.2 267.7-49.1 8.2-132.9 7.4-170-29-82.8-79.3-84.1-224.4 .7-300.4zm162.6 3.3c-6-37.3-62.4-33.7-63.6 4.1-40.9 2.2-87.5 29.9-82.2 74.7 6.9 59.2 75.5 74.9 123 82.6 11.3 1.9 25.2 3 31.9 10.4 .6 2.5 .6 8.2-.2 11.1-22.7 15.8-56.5 13.1-85.5 11.7-56.4-11.7-62.9 67.7-5.2 63.8 4.7 .3 9.8 .5 15 .7-4 54 71.5 50.1 64-3.5 110.7-20.2 98.3-150.7-10.8-157.7-24-4.4-50.7-8-67.7-23.6 22.8-10.6 69.7-10.4 93.3-9.9 53.2-2.5 41.7-72.8-12-64.4z"],
    "cloud-bolt": [576, 512, [127785, "thunderstorm"], "f76c", "M178 108.7c35.3-115.8 182.2-90.7 202.7 13.4 1.9 10.1 1.9 17.1 10.7 29.3 14.5 22.7 49.2 2.6 62.8 13.9 22.9 15.6 43.6 48.9 54.3 80.7 11.3 21.4-24.6 89.4-49.3 91-40.8 9.3-26.8 71.6 14.1 62.4 70-20.4 114.6-104.4 95.9-173.9-17-50.9-63.8-129.3-128.7-128.4-45.7-168.8-288.8-175.3-328.1 8.9-116.3 14.6-154.6 193.5-66.4 260.2 25.5 18 60.6 42.8 80.7 8.5 16.1-33.8-21.2-45.3-42.3-59.7-30.8-25.6-25.5-75.4-11.7-106.9 24.3-54.1 89.1-45 135.1-20.6 15.8 7.9 35 1.6 42.9-14.2 18.3-43.4-42.2-55.7-72.6-64.6l0-.1zM320.4 263.4c-41.2-35.7-73.1 45.5-94.7 68.5-76.6 99.9-2.9 91.7 80.1 83.6-9.6 14-19.4 26.8-30.1 40.8-14.8 22.3-53.4 53.4-22.3 78 31.7 20.5 48.4-23.1 65.4-42.1 21.4-31.7 115.3-131.7 25.2-134-22.8-1.6-47.1 2.5-70.8 3.6 14.7-19.5 28.7-44.3 45.2-58.9 11.5-10.4 12.4-28.1 2-39.6z"],
    "eye-slash": [640, 512, [], "f070", "M72.6-22.6c-30-29.2-74.6 16.3-44.8 45.7 57.5 58.9 122.4 110 180.9 168.5 113.5 114.4 228.2 232.1 342.5 346.2 12.7 12.3 33 12 45.2-.7 12.3-12.7 12-33-.7-45.2-43.8-43.7-85.7-88.9-130.7-131.4-34.8-33.7-68.9-66.8-101.3-102.6-89.3-100-194.7-186.6-291.1-280.6zM276.3 74.2c0 17.7 14.3 32 32 32 122-5.6 193.5 39.6 245.8 149.9l-.2 .3c-10.8 20.7-16.7 31-30.8 48.7-25.5 33.2 24.8 72.2 50.6 39.2 16.2-19.6 30.4-44.9 42.5-68.9 5.9-9.5 8.1-21.2 3.3-31.8-.3-.7-.6-1.4-1-2.1-61.6-136.1-156.4-207.1-310.2-199.3-17.7 0-32 14.3-32 32zm-154 140.9c22.1-35.4-31.9-69.4-54.2-34-16.9 27.2-38.6 50-40.3 87 0 24.1 9.7 46 22 64.1 52.2 70.2 135.2 115.9 212 137 36.4 4.9 103.6 31.3 111.4-19.6-.1-48.9-66.2-29.6-94.9-42.3-53.6-14.6-92.5-35.6-141.2-74.5-20.8-18-44.4-41.7-45.2-65.1 .1-.3 .1-.7 .2-1.2 3.6-12.7 13.2-25.7 21-37.5 3.1-4.6 6.5-9.5 9.2-13.9z"],
    "mug-hot": [576, 512, [9749], "f7b6", "M118-30.3c16.7-5.6 34.9 3.4 40.5 20.1 3.5 10.3 6.7 15.1 10 18.6 4 4.3 9.7 8.4 21.6 15.9 24.2 13.6 36.7 40 34 66 4.8 45.5-62.1 51.5-64.1 5.7-.1-5.1 .3-10 .1-14.5-33.2-17.2-98.1-83.7-42.1-111.8zM402.1 193.1c7.7 .2 15.1 .4 22.9 .5 188.5-13.4 195.1 209.2 19.5 230-3.2 .4-5.7 .9-8.5 1.2-33.2 104-167.7 84.9-252 82.5-152.4-2.1-125.9-168.6-118.2-273.8 .5-18.8 11-37.7 31.9-38.3 39.2-2.1 76.1-4.3 114-2.5 64.8 1.6 127.2-2.6 190.4 .3zM126.8 258c-4.1 47.8-2.8 93.6 1.1 140.6 1 13.2 7.4 26.8 15.4 33.5 26.7 16.3 69 12.2 101.5 13.7 43.3-2.5 95.1 5.8 123.8-26.1 22.6-47.5 18.7-106.1 17.8-162.9-86.3-.1-174.4-1.5-259.6 1.2l0 0zm323.7 .5c1 31.5 1.7 65.7-1.6 99.7 73.1-13.4 83-98.4 1.6-99.7zM287.4-7.2c2.1 9.3 8.4 14.7 25.8 29.8 15.2 13.1 39.8 35 39 74.1-.4 17.7-14.9 31.7-32.6 31.4s-31.7-15-31.4-32.6c1.7-6.5-7.6-17.4-20.4-27.4-13.2-11.1-35.6-29.9-42.8-60.7-9.3-40.8 52.7-55.2 62.3-14.5z"],
    "bolt": [576, 512, [9889, "zap"], "f0e7", "M322.1 7.1c22.1-21.6 60.8 2 52.6 31.2-.1 42.1 5.3 90.9 1.4 134.4 49.6 5.2 94.8 8 144.5 7.7 29.2-.9 43.5 39.1 20.1 56.9-52.4 42.4-99.9 94-143.7 147.6-36.1 41.5-74.1 79.7-112.4 118.4-23.5 22.8-63 9.2-67.3-23.4-5.5-46.2-6.9-91.6-12.7-138.4-47.8 2-110.2 6.8-157 10.8-22.2 1.8-40-22.7-31.6-43.2 26.5-37.5 74.8-69.3 107.7-100.4 67.7-63.4 132.6-136.6 198.2-201.5 0 0 0 0 .4 .3l-.3-.4zm-184.5 274c34.5-2.3 71.6-4.4 95.7-4.4 16.3 0 30 12.3 31.8 28.5 3.9 35.5 8.3 76.2 11.2 115.2 9.7-10.7 19.8-21 29.4-30.8 47.4-47.6 84.3-100.3 133.5-147.1-29.4-2.1-68.6-6-99.2-8.8-33.7-3.1-30.7-39.4-27.9-65.2 1.9-23.6 1.7-37.8 .6-58.8-50.5 50.1-94.9 98.3-146.8 147.3-9.1 7.7-18.7 15.9-28.4 24.3z"],
    "aperture": [512, 512, [], "e2df", "M169.6 10.9C263-15.2 374.4 8 445.9 83.5 573.3 223.7 509.4 466.1 307.8 500.7l0 0C138.5 557.5-5.8 401.3 .2 238.1 14.5 137.2 73.1 52.5 169.6 10.9zM192 70.8c-25.5 11-58.9 33.2-78.9 59.3 12.3 22.5 28.6 51.2 37.4 70.4 17.4-37.7 36.1-64.7 49.9-103.6 3.8-9.7 8.1-20.5 13.2-31.3-7.8 1.1-15.1 2.8-21.5 5.2zm8 224.3c3.6 6.8 6.9 13.1 9.3 17.6 26.5-1.9 65.8-5.5 92.4-8.1 9.4-18.3 20.6-41.2 30.2-58.5-10-17.6-18.5-35.5-29.7-52.8-2.1-3.4-4.3-6.9-6.6-10.7-19.9-.6-40.4-1.6-62.6-2.1-15.1 25.6-31.1 60.1-44.2 93.5 3.7 7 7.7 14.4 11.2 21.2zm-61.2 21.3c-23.6-43-39.6-76.1-62.5-119.9-20.9 39.7-11.7 82.3 .4 122.6 18.5-.5 40.6-1.6 62-2.7l0 0zm-29.3 65.5c27.7 39 72.6 64.3 121.4 66 2.3-4.6 4.8-9.3 7.1-13.6 5.7-10.8 11.1-20.7 15.7-30.8 3.9-10.6 8.4-21.1 13.1-31.5-43.2 4.1-68.2 5.4-107.1 7.3-15.9 .9-33.4 1.8-50.2 2.5zM283.2 118.1c35.8 1.5 73.5-.5 109.7 2.1-27-28.2-65.9-43.2-109.2-51-10.1 18.8-14.8 28-22.5 48.1 8.1 .3 15.8 .5 22 .8zm85.3 196.3l-.5 1c-21.3 41.6-42.2 77.5-58.1 119.4 36.9-8.1 70.8-31.2 93.6-56.7-10.4-18.4-24.2-43.8-35-63.7zM373.1 188c5.1 9.8 10.5 19.5 16.1 29.6 19.6 35.1 25.9 49.6 51 95 12.4-40.3 10.6-84.7-5.8-126.3-13.3-.2-25.9-1-38.6-1.7-8.7-.5-17.1-1-25.3-1.3 .9 1.6 1.7 3.2 2.5 4.8z"],
    "signal-fair": [576, 512, ["signal-2"], "f68d", "M459 103.1c13-9.7 34.3-25.3 54.4-40-2 126.3-3.6 254.6-5.7 380.7-105.4 1.7-175.7 4.3-244.4 4.3-.3-29.1-.4-70.3-2.2-95.2-1.3-22.6-2.9-51.3-3.3-72.4 63.8-63.9 131.8-125.5 201.2-177.3zM196.5 343.8c.3 4.6 .5 9 .8 13.1 1.6 22.4 1.8 62.1 2 90.1-32-.8-63.8-2-95.9-2.7 19.4-21.5 39.1-42.6 59.4-64.3 11.1-11.9 22.5-24.2 33.8-36.2zM577.6 31.6c.2-39.4-44.4-62-76.1-39-143.2 98.7-270 216.3-385.3 343.3-36.1 38.7-71.8 76.9-107 118.7-17.7 19.6-1.9 53.5 24.5 52.6 40.1 0 80 1.2 120.6 2.4 124.4 5 224.2 .2 369.5-2.1 24.9-.5 45.2-20 46.8-44.7 .8-12.4 2-31.6 2-39.7 0-70.9 1.3-140.4 2.6-210.1 1.1-59.8 2.2-119.8 2.5-181.3z"],
    "arrow-rotate-left": [512, 512, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M238.7-.4c358.7-10.2 377.7 555.6-2.5 504.4-80.6-7.1-142.5-48.4-185-113.1-9.7-14.8-5.6-34.6 9.2-44.3s34.6-5.6 44.3 9.2c56.2 96.5 212.7 115.6 293.6 49.1 102.2-102.2 47.8-303.4-95.2-334.8-74.3-21.8-136.7 11.8-196.6 58l61.2 0c41.8 .2 41.9 63.8 0 64-32.7 .2-94.6-.5-127.5 0-18 1.6-34-18.1-32.5-32.1 .1-5.7-.1-127.2 0-129.7 3.3-42 64.3-37.8 64 1.8l0 42.1c51-35.5 102.8-70.9 167-74.6z"],
    "wifi": [576, 512, ["wifi-3", "wifi-strong"], "f1eb", "M105.5 103.3c147.3-68.2 347.9-60.2 460.5 63.5 30.2 28.8-13.2 75.2-43.9 46.6-114.5-125-342.3-114.7-461.6 1.3-32.2 26.6-73.1-22.4-40.9-49.2 26.3-20.8 53.9-48.4 85.9-62.1zm22.5 167.1c65.2-63.5 176.2-88.8 266.6-46.2 28.2 14.4 106.6 50.7 68.7 93.2-34.9 28.8-58.5-24.8-95.1-34.9-67.4-29-140.4-17.7-199.3 37.2-32.2 26.6-73-22.4-40.9-49.2zm236.4 90.5c21.7 9.3 27.2 41.5 6.5 55.5-7.3 5.3-17.7 14.6-29.4 25.5-36.8 36.9-56.5 57.2-95.2 9-15.9-21-50.9-35.9-45.4-66.2 2.5-10.9 10.5-19.8 21.1-23.4 59.3-17.8 96.9-16.7 142.4-.4z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M496.9 156.2c66.1 179.3-43.1 369.1-242.8 356.4-72.7 0-156-20.7-197-88-88.3-88.6-76.3-238.8 2-328.1 106.5-152.1 371.2-112.9 437.8 59.6zM446.1 319.6c47.2-187-148.9-327-307.7-215.5-78.9 68.4-114.2 200.3-32 279.9 31 52.8 89.7 63.7 148.7 64.7 77 15 176.7-54.1 190.9-129.1zM256.8 384.9c-17.7-.9-31.2-15.9-30.3-33.6 1.4-27.8 .2-81.3 0-116l-39.3 39.3c-29.7 29.4-74.8-15.5-45.3-45.2l88-88c39.2-33.1 74.3 33.7 104.2 58 22.7 27.3 63.4 46.7 36.8 80.9-31.8 29.3-56.3-10.6-80.3-33.8 .4 34 1.2 81.7-.2 108.2-.9 17.7-15.9 31.2-33.6 30.3z"],
    "volume": [576, 512, [128265, "volume-medium"], "f6a8", "M320.1 48.2c.9-26.7-33.7-42.3-53.2-24-7.4 6.7-36.4 27.6-54.9 40.8-37.1 24.6-57 46-89.6 68.9-2.5 1.9-6.7 4.9-8.3 5.8-98.9-6.3-115.6-19.9-108.2 91.8 1 42.4 .5 86.8 6.6 127.5 3.1 32.1 37.2 31 61.7 27.1 45.3-8.4 63.6 6.4 97 31.9 25.9 20.1 57.8 36.7 83.1 59.6 3.1 2.3 6.5 5 9 7.1 16.5 21.4 54 10.8 56.4-16.6 18.6-141.1-2.5-279.3 .2-419.8zM262.9 402.5l0 0c-58.6-34.8-114.1-98.3-189.6-80.7-4.3-41.4-2.1-80.8-4-121.7 3.4 .4 7 .8 10.8 1.2 21.3 1.9 39.9 6.4 62.6-4.4 20.4-12.4 38.5-26.1 55.5-41.1 16.9-15.1 34.4-26.8 58.5-44.2 1.9 93.8 7 187.4 7 280.6l0 .1c-.1 2.7-.5 6.4-.9 10.1zM374.5 157.6c-10 14.5-6.4 34.5 8.1 44.5 49.9 30 48.2 75.6 7.3 104-14.9 9.5-19.2 29.3-9.7 44.2 41.6 49.2 101.5-40.3 103.6-83.8 6.4-59.2-32.5-94.7-64.7-117.1-14.5-10.1-34.5-6.5-44.5 8.1zM412.4 34.4c-38.1-17.2-64.7 40.4-26.7 58.2 44.4 20.4 84.4 56.7 112.4 98.4 55.4 69.6-4.9 226.6-94.3 234.2-41.8 .1-41.9 63.9 0 64 113.1-4.5 186.6-139.6 179.4-238.8-6.6-94.8-86.7-175.3-170.8-216z"],
    "tag": [512, 512, [127991], "f02b", "M441 64.3c4-.1 7.5 3.1 7.6 7.6l1.8 185.7c0 2-.6 3.6-1.7 4.9-50.5 59.2-120.3 130.4-186.4 181.3-1.9 1.4-5.2 1.8-7.9-.8-11.3-10.4-23.6-21.9-31-29.3-47.5-38.3-109-109.1-147.9-156.5-2.5-2.9-2.1-6-1-7.8 40.2-59.8 89.2-92.9 136-144.5 11.5-8.4 31-37 42.2-39.2 59 .3 129.1-.2 188.4-1.5zm71.6 7c-1.6-60.4-57-77.3-108.7-70.4-45.5 .7-106.3 1.2-151.2 .9-51.8 1.4-74 50.6-109.7 80.2-46 57.9-178.8 131.6-116.1 216.9 40.4 48.3 103.2 122.2 151.2 160.1 31.4 34.5 76 71.6 123.3 35.5 70.7-54.5 143.7-129.2 196-190.5 11.3-13.2 17.2-30 17-47L512.5 71.3zM368.6 129.2c46 15.8 23.3 80.2-21.4 66.3-43.3-14.2-24.8-82.7 21.4-66.3zm2.1 .8c.7 .3 .5 .2-.2-.1l.2 .1z"],
    "compact-disc": [512, 512, [128191, 128192, 128440], "f51f", "M307.7 12.7c-35.5-8.5-78.9-15.3-121.9-.2-38.9 13.7-71.8 41.2-96.9 65.2-51.1 45.2-91.4 122.5-83.2 192.4-4.8 159.4 194.8 297.9 342.6 226.3 158.3-61.8 238.6-294.1 97.2-410.7-31.8-37.5-90.3-63.9-137.8-73.1zM207 72.9c60.8-15.1 146.4 9 191.6 56.7 149.6 119.4-27.2 374.1-193 313.7-65.3-23.9-139.2-93.7-136.1-171.1-10-88.4 63.6-166 137.4-199.3zm29.8 94.1c-59.8 1.2-86.7 62.3-72.8 111.6 14.9 50 57.2 67.5 95.1 72.4 50.9 3.9 78.4-39.5 87.1-79.2 17.2-67.1-53.2-108.9-109.4-104.7zm-11.5 93.2c-2.5-7.7-.3-22.6 6.9-28 18-4.8 44.2 4 51.2 13.9 3.8 6.6-5.1 36.9-16.7 41.2-25.8-3.5-37-12.2-41.5-27.2z"],
    "phone-slash": [576, 512, [], "f3dd", "M568.4-21.4c11.2 13.7 9.2 33.8-4.5 45-136.5 131.9-282.7 265.2-410.4 403-34 37.7-69 76.5-107.1 112.5-12.9 12.1-33.1 11.5-45.2-1.3-12.1-12.9-11.5-33.1 1.3-45.2 76.4-72.2 140.6-157 219.3-229.5 87.1-80.4 170.7-161.2 253.2-246 26.4-21.8 60-72.7 93.4-38.5zM132.7 12.2c31.4-21.8 57.9 13.4 91.4 31.2 25.4 19.6 78.7 46.5 53.2 84.1l-60.8 77.2c-26 32.7-76-6.6-50.3-39.6l42.5-54c-15.2-11.7-35.8-25.1-51.8-34.8-57.2 55.4-78.8 126.8-44.1 200 7.6 16 .8 35.1-15.2 42.7-16 7.6-35 .8-42.6-15.2-54.1-113.8-7-221.7 77.6-291.5zM421.7 337.1c-31.3 27.7-73.7-19.6-42.7-47.7 .5 .2 21.6-20.3 21.6-19.2 19.5-14.1 38.2-6.3 54.9 3.4 26.8 16.8 56.1 41.4 76 65.4 5.4 8 9 10.9 10 25.7 0 14.6-7.1 27.2-10.8 33.2-12.4 21.4-29.8 39.8-45.8 54.6-46.7 47.9-103.8 50-153.2 50-38.4-2.3-134.7-15.8-113.2-68.9 7.9-15.8 27.2-22.1 43-14.2 61.7 31.5 149.9 27.2 189.5-23.3 9.9-8.9 15.1-16.4 22-26.7-11.4-11.5-31.6-28.7-45.3-37.8l-6 5.4zm56.4 23.8l0 0z"],
    "arrow-up-right-from-square": [512, 512, ["external-link"], "f08e", "M503.4 8.9c-27-19.2-81-1.2-114.3-4.1-33.9 7.4-106.9-14.4-108.6 37.6 7.1 49.6 69.8 23.5 104.1 26.7-30.5 31.5-58.1 61.5-86.1 94.8-31.7 35.7-62 76.9-98.1 107.4-13.5 11.4-15.2 31.6-3.7 45.1 43.1 48.4 118.8-83.6 150-110.3 31.3-37.5 60.6-68 95-104.4 1.8-1.9 5.3-5.7 7.1-7.6 1.2 32.8-.7 68.3 .8 101.4 4.7 41.6 67.9 34.8 63.6-6.8-.1-38.2-.4-83.6-.2-124-1.1-18.8 5.7-41.4-9.7-55.8zM174.9 128.5c43.1-2.4 39.2-66.7-4-63.9-47.7 5-148.1-3.6-171.7 55.9-7.5 25-3.4 42.3-4.6 66.2 1.9 95.5-5.4 201.5 32.2 292.5 10 13.6 24.4 20.4 40.1 22.8 94.9 14.5 195.3 23.8 294.9 8.1 59-4 83.6-49.2 81.5-104.8-3.3-31.7 7.5-86.6-37.4-86.7-56.6 7.5-11.4 90.2-32.7 122.8-94.8 23.6-196 11.3-295.3-2.5-21.8-96.4-20.7-194.9-18.8-295.1 33.5-12.2 73.4-13.9 115.7-15.4z"],
    "rectangle-tall": [384, 512, [], "e791", "M384.4 1.9l0 441.8c0 12.8-2.1 28.6-4 40.6-4.8 30.4-30.6 51.5-59.8 52.6-82.4 3.2-178.4 23-260.6 4.6-13.1-2.9-33.8-11.4-41.9-35.1-8.6-25.1-13.3-59.5-16-95.9-2.7-37.1-3.6-78.9-3.5-120.3 .1-83-1.1-169 4.5-251.8 1.4-19.8 4.3-42.2 18-57.7 6.1-6.9 14.8-10.8 24-10.8 45.2 0 81.4 .7 115 1.3 60.1 1.1 111.7 2.1 190.9-1.3 17.9-.8 33.4 14 33.4 32zM67.8 34c-10.1 81.9-5.1 173.8-5.2 256.4-.1 40.7 .8 80.7 3.4 115.4 2.3 31.5 6 56.6 10.8 73.7 78.5 9.5 162-3.4 240.6-6.5 1.7-11.2 3-22.2 3-29.3l0-408.6c-63.4 1.9-111.1 1.1-163.8 .1-27.3-.5-55.9-1-88.8-1.2z"],
    "compass": [512, 512, [129517], "f14e", "M509.9 241.4C494.2 28.6 227.7-88.3 75 73.5-.2 153.7-22.5 266.7 14.5 368.8 62.5 468 170.4 521.8 276.8 510.3 417.4 502.7 519.9 378.8 509.9 241.4zM239.7 62.8c83.5-20.6 210.3 94.4 206.2 178.7 8.3 107.8-67.3 200-176 205.2-81.6 8.8-162.5-32.8-197.8-105.7-43.2-112.6 39.5-278.4 167.6-278.1zm102.2 80.6c-16.7 .2-37.7 6-54 9.8-33.1 11.6-115.8 6-114.8 56.8-.4 16.2-3.9 34.8-7.3 52-3.1 17.8-9.6 47.7-14.8 65.3-7.5 25.3 21.2 49.2 44.7 37 35.6-17 69.1-31.3 100.6-32 25.4-3.2 27.8-15.4 34.9-30.6 6.9-18.6 13-42 18-60.6 5.8-15.2 15.5-37.6 22.1-53 9.5-20.3-7-45.4-29.3-44.8zM274.4 270c-16.3 2.2-32.1 6.4-47.2 11.6 3.3-17.1 6.9-34.4 8.7-52.5 14.9-4.4 35.1-6.5 53.3-10.4-4.7 14.5-8.8 33.5-14.8 51.4z"],
    "pen-nib": [512, 512, [10001], "f5ad", "M340.6 103.2c5.3-4.2 13.1-9.8 21-15.1 39.6 37.2 62 60.3 74.5 74.2-13.3 12.4-27.2 24.2-41.8 36.2-24.3 20.1-27 51.3-25 71 2.1 127.3-138.2 130.7-232.7 156.2 22.7-26.1 46.8-52.8 68.8-75.9 43.5 9.1 89.1-40 65.7-80.2-31.5-61.1-113.7-35.5-107.2 31.1-23.5 24.3-49 52.6-73 80.2 1.6-12 3.1-25.2 4.4-37.4 7.8-82.2 21.3-163 101.1-191.2-.1 0-.1 0 .2 0 18.6-3.5 47.8-4.6 65.8-5.6 32.5-.6 53.9-25.6 78.3-43.5zM64 508.6c7.3-.8 15.7-3.2 23.5-5.6 22.6-6 45.7-11 69.3-16.1 25.9-5.5 52.8-11.6 79.1-18.6 130-28.7 198.8-81.5 199.1-220.4 113.9-87.3 81.2-98.8-31.1-207.7-19.2-18-49.9-23.6-74.8-7.3-26.6 15.2-43.6 37.4-69.8 49.9-216.9-13.4-231.9 215.7-238.8 375.1-5.8 32.1 17.3 55.1 43.5 50.8z"],
    "square": [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M440 43c6.3 6 9.9 14.4 9.9 23.1 0 27.8-.5 67.5-.9 107.1-1.5 79.1-.7 133.6 .9 206.8-1 52.4-25.7 93.4-77.2 94.7-76.3 8.8-162.5 4.5-233.4 5.4-43.4-2.8-102.4 14.9-121.3-42.8-22.8-72.5-18.2-153.6-15.6-229.5 6.8-43.4-14.2-179.5 50.3-173.7 122.6 .2 243.4 5.2 365.8 0 8.1 .1 15.8 3.3 21.7 8.9l0 0zM72 98.2c-5.1 101.2-19.2 221.5 6.1 317.5 96.5-1.3 201 6.7 300-6.9 13.6-24.9 5.8-50.1 6.8-77.1-2.3-71 .5-156.7 .8-232.4-104.9 3-209.3-.5-313.7-1.1z"],
    "angle-up": [448, 512, [8963], "f106", "M391.9 350.5c11.4 13.5 31.6 15.3 45.1 3.9 13.5-11.4 15.3-31.5 3.9-45.1-39.3-46.8-81.9-92.3-126-134.6-19.1-18.3-47.1-45.3-67.9-65.5-29.6-26.4-51.8 6.8-68.8 29-5.7 6.3-11.5 12.7-17.5 19.2-31.1 33.1-57.4 68.1-92.4 99.1-12.1 11.3-26.9 25.3-37.4 37.7-5.8 6.7-11.5 12.9-16.7 17.7-30.7 28.4 12.3 75.3 43.3 47.2 19.3-18.7 32.8-36.6 52.4-53.7 34.7-30.5 64.9-68.9 96.7-103.3 6.8-7.4 13.8-14.9 20.8-22.8 58.8 55.9 113.2 109.4 164.5 171.3l0 0z"],
    "face-smile": [512, 512, [128578, "smile"], "f118", "M396.7 48.8C286.5-38.2 104-11.7 36.1 120.5 5.3 185.9-17.8 246.2-2.8 324.7 36.7 508.8 279.3 563.2 414.6 450.3 543 341.5 529.8 153.5 396.8 48.8l0 0zM203.5 68.3c185.4-48.8 324.9 206.2 168.8 333.9-95 81.8-287.3 41.5-312.3-89.4-15.3-84 30.6-224.5 143.5-244.4zM178.6 248.3c-42.4-.4-61.3-69-14.2-78.9 61.3-9.9 79.4 69.1 14.2 78.9zM379.7 355.5c31-28.1-11.5-75.5-42.8-47.6-38.2 40.5-90.5 33.7-138.4 14.9-7.3-3-13.5-7.3-23.6-14.7-14.3-10.4-34.3-7.3-44.7 6.9-21.2 32.9 15.5 54 44 66.9 66.3 28.8 153.2 29.4 205.5-26.6zM347.5 173.2c-18.3-10.6-42.4-1-54.4 18.2-14.6 23 7.4 52.4 27.9 55.1 53.2 14.1 69-48.7 26.6-73.3l0 0z"],
    "cloud-showers": [576, 512, [], "f73f", "M233 45c-26.1 12.9-42.8 31.6-48.3 49.9 27.5 4.8 72.5 29.5 49.8 63.2-10.2 14.4-30.2 17.9-44.6 7.7-36.3-27.5-99.8 9-118.6 43.3-19.1 29.2-6.6 87.7 23.4 113.5l25.3 15.5c35.6 22 2.3 76.3-33.5 54.5-29.2-14.6-58.9-41.8-70.5-70.8-46.7-89.5 1.2-194.7 103.2-223.9 13.9-102 145-161.3 232.3-111.5 30.9 19.8 65.7 47 80.8 84.8L443.5 94c145.3 10.9 181.1 245.4 38.5 300.4-39.4 14.3-61.4-45.3-22.2-60 58.8-17.9 61.6-120.4 17.6-160.1-12.8-12.1-28.8-18.5-49.1-15.7-13.6 1.8-26.8-5.2-32.9-17.5L374.2 98.3c-.5-1.1-1-2.1-1.4-3.2-27.3-47.6-78-82.4-139.8-50l0 0zm-23.3 270c5.7 48.1 11.4 97.1 13.6 146.8 .8 17.6-12.9 32.6-30.5 33.4-17.7 .8-32.6-12.8-33.4-30.5-2.2-47.2-7.5-94-13.2-142.2-4.8-41.6 58.4-49.1 63.6-7.6zm68.4 1.8c17.7 0 32 14.3 32 32 0 55.7 .3 111.3 1.6 166.8 .4 17.7-13.6 32.3-31.2 32.7-17.7 .4-32.3-13.5-32.8-31.2-1.3-56.2-1.6-112.4-1.6-168.3 0-17.7 14.3-32 32-32zm129.7-13.2l1.6 32.3c2.2 45.1 4.4 90.4 6.3 135.6 .7 17.7-13 32.6-30.7 33.3-17.7 .7-32.5-13-33.3-30.6-2.3-55.4-5.2-111.9-7.8-167.5-1.8-41.9 61.7-44.9 63.9-3.1z"],
    "umbrella": [512, 512, [], "f0e9", "M370.3 101.6c50.3 31.6 78 70.6 75.8 113.3l0 9.5c-6.9 0-13.8-.2-21-.3-121.1-4-238 7.4-359.5 2.3 34.2-140.9 175.5-209.7 304.6-124.7zM288.6 288.2c45.5 0 90.1-1 135.6-.2 15.8 .4 32.6 .3 48.7 .3l4 0c19.5 .8 34.8-16.1 33.2-35.4l0-39.2c.4-140.8-173.4-227.6-294.5-212-82.3 13-149.2 68.8-187.3 143.4-16.6 34.7-61.1 136.1 1.8 143 64.9 5.7 130 4.4 194.2 .9 2.2 44.1 18.6 109.4-7.8 145.3-15.2 14.7-59.8 8.8-58.4-18.2-.2-41.9-63.8-41.8-64 0 1.8 85.7 103.6 115.3 163.3 67.5 53.6-50.2 35.7-131.7 31.1-195.5z"],
    "briefcase": [512, 512, [128188], "f0b1", "M291.4 .3c54.1-1.1 94.7 43.9 97.3 97 151.4-14.8 118.1 120.1 123.1 222.3-5.2 96.5 21.7 207.3-125.4 191.2-67-.6-139.1-1.2-192.9 .7-70.4-1.3-194.1 21.5-193.3-82.9-.1-67.8-.9-193 2-265.8 4.6-67.9 81.8-62.1 126.8-64.9 2.6-50.9 42.5-96.8 98-97.1l64.4-.4 0 0zm-98 95.7c42.5-.2 85.7 .3 130.4 .7-1-17.2-12.8-32.7-32-32.4l-64.4 .4c-15.9 .1-30.9 12.8-34 31.3zM64.2 287.3c-.2 52.6-.1 107.9 0 144.8 0 8.3 6 13.7 12.4 14 39.9 2.2 84.9 2.3 119.6 1.2 66.1-2.1 158.5-.7 233.3-.2 7.9 .1 13.1-5.4 13.5-11.5 4.4-56.8 5.1-101.2 4.8-145.6-18.4-.1-35.5-.6-52.2-1.1-94.9-.8-230.7-1.5-331.5-1.8zM446.9 226l0 0c-4.7-13.5 5.6-63.5-20.3-64.4-123 .7-237.2-7.1-360.5 5.2-.8 15.1-1 34.1-1.3 56.5 37.9-.6 93.7 .2 138.7 .7 103.6 1.5 152.5-.9 243.6 2.1z"],
    "microchip": [576, 512, [], "f2db", "M400.9 33.4L380 33.6c2.3-26.6 3.4-65.9-32.5-65.6-36.6 1.5-30.5 40.8-31.6 66-21.6 0-42.5-.2-61.2-.7 1.4-26 3.4-65.2-32.3-65.3-35.5 1.1-32.2 38.1-31.7 64-100.4-5.2-133 27.6-125.5 128.1-25.7-1.6-64.1-2.8-64 32.3 1.1 35.5 38.1 32.2 64 31.7 0 21.8 .1 44.1 .2 65.8-25.4-2.4-62.9-4.5-64.2 30-.5 35.8 38.8 33.9 64.7 34-5.7 114.8 26.2 121 127.4 124.7-1.2 26.3-2.3 66.1 33.7 65.2 35.2-2 31.1-38.5 30.3-64.1 20.9-.4 42.6-1.7 64.4-3.2-.5 26.3-4 67.4 32.8 67.4 38.8-1.4 31.2-45.4 31.1-72.4 87.8 .5 125-26.2 126-117.3 26 .8 65.7 3.3 65.7-32.7-.7-34.8-38.6-32.7-64-31.3-.2-21.4-.3-42-.2-63 25.9 1.7 64.7 2.4 64.2-33-1.8-36.3-39.8-31-65.8-31.1 2.3-83.3-16-138.9-110.6-129.8zM352.6 410c-77.2 7.1-143.3 9-221.5-.7-2.5-64-1.9-221.5-1.7-298 0-8.3 5.8-13.2 11.4-13.5 98.7-4 187.4 2.8 290-.7 8-.1 13.6 5.6 14 12.3 4.1 64.9 4.4 115.6 4.4 167.6 .6 40.4-.2 71.2-5.4 113-.8 7.2-7.4 14.2-17.1 14.7-25.6 1.3-50 3.4-74 5.3zM266.8 128c-137.7-9-100.3 81.6-105.6 179.8 6 99.7 104.4 72 176.9 75.4 40.7 .4 76.1-30.4 77.9-72.9 1.1-25.7 1.1-40.9 1.1-62 10.4-110.6-60.4-120.9-150.3-120.4zm68.4 68.2c26.7 4.2 15.6 30.1 17.9 48.4-.1 21.2 .2 36.3-1.1 63-.3 6.2-5.3 11.7-13.3 11.6-37.6-.9-68.5 .6-103.6 .7-6.4-.4-9.7-5.6-9.9-12.3-.1-35 0-83.9 .5-114 33-2.8 60.5-1.8 94.3 1.3 4.9 .4 10 .8 15.1 1.2z"],
    "pause": [256, 512, [9208], "f04c", "M71 95.6c.2-41.8-63.5-42.5-64-.5-1 107.4 7.8 212.4 .2 318.7-1.3 17.6 12 33 29.6 34.2 17.6 1.3 32.9-12 34.2-29.6 7.6-105.2-.8-217.5-.1-322.7zM262 100.7c1.1-41.8-62.5-43.8-64-2-3.2 107-7 214.8-1.8 323.3 2.2 41.7 65.8 38.8 63.9-3.1-5.1-105.3-1.4-211.4 1.8-318.3z"],
    "arrow-down": [448, 512, [8595], "f063", "M54 236.5c-30.7-28.3-74.1 18.3-43.5 46.9 56.6 52 145.9 136.1 191.8 185 15.8 16.2 41.6 16 57.3 0 10.3-10.5 28.4-28.8 34.8-34.2 54.1-45.6 91.7-106.1 142.6-149.9 13.4-11.5 15-31.7 3.6-45.1-40.8-41.6-92 50.1-118.4 73.2-22.6 26.5-43.9 51.3-68.1 72-.3-12.4 0-24.8 .2-37.7 .2-80.9 2.2-162.6 1.5-244.4 1.2-25.6 5.1-65.8-31.6-66.3-34 .5-33.2 36.2-32.4 62 .5 81.5-1.2 162.8-1.5 245.2-.2 6.9-.3 14.1-.4 21.7-48.5-48.6-88.5-83.5-136-128.4z"],
    "location-dot": [384, 512, ["map-marker-alt"], "f3c5", "M329.6 53c-218.4-167.3-431.6 86.1-269.7 291.6 28.9 41.7 79.1 116.1 97.2 142.9 15.6 23.1 50.4 24.1 66.5-.3 23.5-35.7 108.7-167.1 142-246.6 17.8-41 23.2-92.9-3-137.9-9.3-18.4-16.1-34.1-33-49.7l0 0zM177.3 63.5c51.2 .9 105.2 15.1 126.3 64.1 15.6 25.9 18 53.4 3 88.2-24.7 58.8-82.5 152.3-116.8 205.8-36.8-60.2-93.1-121.8-114.9-184.7-27.5-80.2 15-164.3 102.4-173.4zm13.2 78.1c-51.1 5.6-57.5 89.2 .4 90.6 57.4-.3 56.4-91.2-.4-90.6z"],
    "bars": [576, 512, ["navicon"], "f0c9", "M36.1 85.7c0-17.7 14.3-32 32-32 36.3 0 72.4 1.2 107.8 2.5 111.5 5.4 221.2-.4 332.9-.8 17.7 0 32 14.3 32 32s-14.3 32-32 32c-37.5 0-75.1 .8-113.1 1.6-108.7 4.4-219.3-1.8-327.6-3.3-17.7 0-32-14.3-32-32zM520 284c-72.3-6.8-146.1 5.8-219 5.2-78.6 .1-158.8-10.8-236.1-5.7-17.6 1.2-32.9-12.2-34-29.8s12.2-32.9 29.8-34c81.1-5.5 160.4 5.4 240.3 5.5 75 .2 149.4-12.4 225-5 17.6 1.7 30.5 17.3 28.8 34.9S537.6 285.6 520 284zM433.5 442.2c-51.5 .4-303 .2-359.1 .3-41.7-.2-42-63.8 0-64 104.6 .2 332.5-.1 434-.5 17.7 0 32 14.3 32 32-5.1 51.1-72.2 26.5-107 32.2z"],
    "battery-empty": [640, 512, ["battery-0"], "f244", "M328.4 64c-46.7 0-95.9 2.7-144 5.4-206.3-4.8-187.5 102.9-180.6 270 5.9 68.8 68.3 111.8 134.4 105.9 70.4-.6 145.1-1 201.5 .6 241.5 20.2 203.3-111 203.1-289.7-7.1-112-136.1-88-214.4-92.3l0 0zM121.8 136.4c23-1 45.8-2.3 68.4-3.5 73.5-4.4 142.1-6.8 214.3-3.6 19.4 3 76.3-7.6 74.5 31.6 1.1 45.1 1.2 110.2 1.1 162.7-.1 32.8-24.7 58.1-55.3 58.8-102.8 .7-191.9-2.8-301.4-.7-78-1.2-53.9-98.9-58.2-145.1-2.2-43.5-3.2-96.9 56.6-100.2zM576.1 319c.2 41.7 63.7 41.6 63.9 0l0-127.5c-.2-41.7-63.7-41.6-63.9 0l0 127.5z"],
    "keyboard": [576, 512, [9000], "f11c", "M229.9 32c86.1 0 176 9.4 261.8 12 96.7 4.5 84.5 126.5 85.7 195.5 .4 52.2-.8 105.5-6.1 169.6-3.5 41.2-38.3 70.3-77.7 70-147.9-4-276 4.1-418.7-1.5-42.1-2.4-72.9-37.6-73-78-.4-75.5-.7-232.5 2.1-297.4 1.3-32.3 24.6-58 57.1-62 66-6.9 108.8-7.6 168.9-8.2zm148.7 70.2l0 0c-108.5-7.2-201-9.9-310.6 1.6-3 63.6-2.4 218.6-2.2 295.4 0 8.4 6.1 14 12.7 14.4 126.3 5.8 229.5-2.4 361.4 1l0 0c18.7 .2 36.9 .3 54 .4 7.9 0 13-5.4 13.5-11.4 5.6-65.3 5.9-116.9 5.9-169.2 .9-40.8-.3-71-7.5-113.2-1.1-6.9-7.4-13.1-16.2-13.3-36.7-1.1-74.2-3.4-111.1-5.7zM253.3 386.7c-34.2-5.2-108.6 21.3-115-29.2 2.3-53.8 74.9-28.1 110.8-34.8l0 0c47.5-.9 96.1-1.8 143.7 0 17.7 .7 31.4 15.6 30.8 33.2-.7 17.7-15.5 31.5-33.2 30.8-46.2-1.8-91.1-.9-137.2 0zm152.4-155c-24.4 34.9 32.5 74.5 56.8 39.5 24.4-34.9-32.5-74.6-56.8-39.5zm-83.8-8c-39.7 22-6 80 32.4 55.5 39.7-22 5.9-80-32.4-55.5zm-108.2 8c-24.4 34.9 32.5 74.5 56.8 39.5 24.4-34.9-32.5-74.6-56.8-39.5zm-83.8-8c-39.7 22-6 80 32.4 55.5 39.7-22 5.9-80-32.4-55.5zm275.8-40.5c-24.4-35 32.5-74.6 56.8-39.5 24.4 35-32.4 74.6-56.8 39.5zm-83.8 8c-39.7-22-6-80.1 32.4-55.5 39.7 22.1 6 80-32.4 55.5zm-108.2-8c-24.4-35 32.5-74.6 56.8-39.5 24.4 35-32.4 74.6-56.8 39.5zm-83.8 8c-39.7-22-6-80.1 32.4-55.5 39.7 22.1 6 80-32.4 55.5z"],
    "stopwatch": [512, 512, [9201], "f2f2", "M176.2-32.4c-41.8 .2-41.9 63.8 0 64l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0zm190 128.8c-201.7-119.7-418.6 102.7-300.3 301 59.8 125.6 233 151.8 334.8 55.5 68.2-58.5 111.6-167.3 49.3-260.1l0-.1-2.2-3.7c3.4-1.9 6.6-3.6 10-5.4 21.6-9.3 50-27.9 34-56-8.9-15.3-28.5-20.5-43.7-11.6-13.6 7.9-23.2 12.4-36.1 19.7-12.2-14.3-27-27.9-45.9-39.3zM204.8 131.6c86.6-18.4 159.5 22 195.9 103.6 54.2 87.9-43.8 208.8-140.4 212.3-84.8 8.3-151.5-69.3-163.4-149.4-8.1-71.6 39.3-143.2 107.9-166.5zm83.4 63.7c-.2-41.8-63.8-41.9-64 0l0 92.3c.2 41.8 63.8 41.9 64 0l0-92.3z"],
    "train": [448, 512, [128646], "f238", "M228.9 61.9c36.1 1.4 97.6-11.9 123.6 15.2 33.7 35.3 29.5 89.2 29.6 150.8-108.4-6.3-216.2-1.2-323.3-1.2 .8-37 1.7-67.2 3.2-97.7-.8-32.9 25.5-62 56.5-62.4 37.2-.7 74.2-4.8 110.4-4.8zM58.4 290.8c108.4-.1 213.7-5.2 323.3 1.2-.8 25.4-2.6 62.4-10.8 81.3-65.2 56-167.1 40.2-258.8 34.7-67.2-7.3-49.8-63.8-53.6-117.2zM117.3 2.7c-68.6 1.2-118.9 60.7-119.4 124-1.4 29.5-2.2 53.7-3 90.4 5.3 78.7-23.4 184.2 47.4 231.6-11.8 13.4-26.2 30-36.5 41.8-27.2 31.8 20.8 73.4 48.4 41.9 15-17.4 37.3-42.7 53-60.6 63.9 5.8 145.3 13 218.9-5.8l64.8 67.6c29.1 30.1 75-14 46.2-44.3l-46.7-48.7C461.2 399 442.3 294.6 446 226.3 455.3-43.9 327.6-6 117.3 2.7zm22.9 320.6c-34.9-27.3-74.5 27.5-37.4 52 36.6 29 77-27.1 37.4-52zm147.9 12.2c13.3-39.7 66.9-22.9 64.2 13.2-4.4 51.8-75.8 34.9-64.2-13.2z"],
    "train-subway": [448, 512, ["subway"], "f239", "M239.3 409c53.3-4.9 137.5 13.7 139.4-65.4 .8-16.6 1.4-33.7 2-52.8-108.4-.9-212.9-4.8-322 1.6-.8 143.8 71 120.4 180.6 116.6zm15.4-184.1c39.6 1.1 86.9 2 127.4 1.9-4.4-131.1 27.9-167.9-124.4-165.8-.3 14.7-.8 29.2-1.4 43.4-1.9 38.9-1.7 81.9-1.6 120.5zm-64-.5c-.1-38.7-.2-83.9 1.6-122 .5-14 1-27.7 1.3-41.3-45.3 3.6-92.9 6.1-123.9 38.3-13 34.5-10.7 90.2-11.3 129 39.3-1.7 89.4-3.4 132.3-3.9zM442.7 346.1c-.3 39.3-19.8 77.1-50.9 100.4l44.3 41.6c30.3 28.8-13.2 75.2-43.8 46.7L323.3 470c-70.1 .3-140.2 9.5-210.8 4.4-8.1 8.2-16.3 16.1-24.1 23.4-12 11.4-24.2 23-34.1 34.5-27.6 31.5-75.6-10.1-48.4-41.9 14.2-16.4 28.5-29.5 43.2-43.5-60.6-58.6-54.4-129-54.6-200.6 1.9-56.7-6.7-130.3 22.4-183.1 76.9-88.7 215-64.9 317.5-62.3 51.7 5.2 106.8 40.6 108.6 100.9 6 70.8 2.8 171.8-.4 244.3zm-303-23.3c-34.9-26.3-73.3 28.5-36.7 52.5 37.2 29.3 77.3-28.2 36.7-52.5zM328 313.6c16.9 4.1 25.5 23.2 24.5 35.1 .3 37.2-54.5 43.6-63 7.8-10.6-23.6 13.6-51 38.5-42.9zm-39.5 34.3l0 0z"],
    "cloud-drizzle": [576, 512, [], "f738", "M192 84.4s-.1 0-.1 .1c42.5-76 147.5-67.5 180.1 16.1 10.7 22.6 10.7 55.8 41.2 57.4 117.2 8.3 132.8 124.7 35.3 181.8-34.1 24.2 2.5 76.3 36.9 52.3 137.6-82.1 116.7-268.5-46.4-295.6-45.9-165.7-277.6-174.8-318.5 .7-155 18.6-150.2 224.8-43.1 298 13.8 11.1 33.9 9 45-4.8 11.1-13.7 9-33.9-4.8-45-48.2-38.9-67.1-90.9-45.8-146.3 22.8-51.6 87.8-40.6 131.3-22.9 16.4 6.4 35-1.7 41.4-18.1 13.3-37.4-31.6-47.9-59.2-54.3 2-6.4 4.4-13.9 6.4-19 .2-.4 .2-.6 .2-.6zM180.6 285c-17.7 .7-31.4 15.5-30.8 33.2l1.3 33.9c.7 17.7 15.6 31.4 33.2 30.8s31.4-15.5 30.8-33.2l-1.3-33.9c-.7-17.7-15.5-31.4-33.2-30.8zM215 451.3c3.1-41.8-60.4-46.7-63.8-5l-2.1 27c-3.1 41.7 60.4 46.7 63.8 5l2.1-27zm67.1-130c-17.7-.2-32.1 14-32.3 31.7-2.6 23.4 4 47.4 31.5 48.5 17.7 .2 32.1-14 32.3-31.7 2.6-23.4-4.1-47.4-31.6-48.5zm33.2 162.9c-.1-41.8-63.7-42-64-.2l-.2 56.4c-.1 17.7 14.2 32 31.9 32.1 17.7 0 32-14.2 32.1-31.9l.2-56.4zm63.6-205.5l0 0c-17.7 .1-31.9 14.5-31.8 32.2l.3 59.7c.1 17.7 14.5 31.9 32.2 31.8 17.7-.1 31.9-14.5 31.8-32.2l-.3-59.7c-.1-17.7-14.5-31.9-32.2-31.8zM412.6 451c2-41.8-61.6-45-63.9-3.2L346.1 499c-2 41.8 61.7 45 63.9 3.2l2.6-51.2z"],
    "ship": [640, 512, [128674], "f21a", "M388.8 64.1c-67.8-.1-133.9 3.5-199.7 16.5-.1 3.5-1.3 23.5-1.1 26.7l0 56.4c27.8-10.8 55.1-19.3 82.5-28.3 52.4-24.4 115.4 11.6 164.1 28.3 1.6 .6 3.2 1.2 4.8 1.9-1.4-27.5-4-55.8-3.9-84-.1-5.8-.1-11.4-.2-16.9-14.5-1.2-29.7-.9-46.5-.5zM124.6 193.4l0-78.1c-.5-10.7 1.9-51.4 2.4-62.7 .7-14.5 11.1-26.6 25.2-29.6 70.7-14.9 137.1-22.2 209.7-22.2 35.8-.2 73.4-3.4 111.5 5.5 33.3 8.4 23.5 50.3 25.6 75.7-.2 33.5 4.1 66.2 4.2 100.5 .3 4.2 .7 11.7 1.1 17 30.8 23 35.5 76.4 22.1 108.5-12.5 33.4-22.8 81.8-63.9 64.9-35.4-21.1-4.9-53.1 3.3-83.6 16.6-46.5-11.9-47.8-54.2-66.2-23.4-9.2-45.8-18-68.1-24.9-1.4 44.4 6.1 91.7 6 137 0 17.6-14.2 31.9-31.7 31.9-45.7-3.2-28.2-58.6-34.6-90.7-1.9-25.4-3.8-50.5-3.1-77-42 15.1-85.9 24.8-120.3 48.6-2.5 21.4 10.4 52.2 18 73.8 6.2 16.5-2 34.9-18.4 41.1-16.4 6.2-34.7-2-40.9-18.5l-8.2-21.8c-13.6-40.9-28.9-98.9 14.5-129.3zM61.3 391.6c7.4 18.3 11.7 29 17.8 37.2 28.6 32.6 82.9 16.7 103.5-20.5 14.9-36 54.5-48.4 71.6-5.5 9.3 17.6 20.8 44.3 39.3 45.8 34.9 2.4 74.3-18.7 87.7-54.7 11.3-26.5 52.7-22.9 59.3 5.1 9.8 24.5 51.5 43.2 72.3 44.1 16.1 1 33-4.1 49.6-23.6 17.1-20.3 29.6-55.4 61.7-38.3 34.5 20.7 4.5 59.3-13.6 79.9-55.1 67.6-143.4 52.3-199.6 2.9-46.3 52.3-153.3 73.6-193.1 3.2-71.2 73.3-188.6 49.7-215.2-51.5-15.5-38.7 42.9-62.5 58.7-24z"],
    "arrows-rotate": [512, 512, [128472, "refresh", "sync"], "f021", "M507.1 14.5c-4.5-41.7-67.8-34.9-63.6 6.7l5.7 54.3c0 3.4 0 6.9 .1 10.4-51.6-46.5-101-90.1-191.2-90.1-125.8 9.7-236.9 103.4-253 233.8-2.4 17.5 9.8 33.7 27.3 36.1 17.5 2.4 33.7-9.8 36.1-27.3 11.7-97 93.2-168.8 191.2-178.5 63 .4 92 25.6 140.1 68.2l-44.6 0c-41.8 .2-41.9 63.8 0 64l128 0c40.5-1.3 31.6-47.6 31-75.9 .1-29.5-3.3-72.6-7-101.6zM263.3 518c124.6-11.3 233.9-104.2 249.9-233.6 2.4-17.5-9.8-33.7-27.3-36.1-17.5-2.4-33.7 9.8-36.1 27.3-11.7 97.1-93.2 168.8-191.2 178.5-63-.4-92-25.6-140.1-68.2l44.6 0c41.9-.2 41.8-63.8 0-64l-128 0c-40.5 1.3-31.6 47.7-31 75.9-.1 29.7 3.3 72.4 7 101.6 4.5 41.7 67.8 34.9 63.6-6.7l-5.7-54.3c0-3.4 0-6.9-.1-10.4 51.7 46.9 103.7 91.8 194.3 89.9z"],
    "quotes": [512, 512, [], "e234", "M426.3 32c-123.2 2-138.4 121.7-139.3 217.6-9.2 90.2-4 220.5 121.8 201.1 4.7-.4 8.4-.8 13.2-1 72.4 1.5 103.3-60.1 94.9-126.2 7-103.3-90.6-108.2-164.6-95.5 0-40.4 6.5-88.6 29.9-117.9 1.3-1.2 4-3 12.4-6 12.4-4.4 22.7-8.5 31.7-8 41.8-.2 41.9-63.8 0-64zM348.9 326.8c-.6-11.3-.5-23.1-.2-34.8 32 .7 75.4-15.4 100.6 4.1 6.1 13.7 3.3 44.3 3.7 59.9-1.6 25.3-12.5 28.9-32.8 29.5-57.3 6.8-66.7 3.5-71.4-58.7zM148.2 35.8c-130.3-14-145.7 89.7-149 194.8 3.6 58-10.4 121.9 14 175.5 22.7 52.2 98.9 48.1 144.4 36.4 56.4-12.4 65.8-70.9 64.4-114.1 5.6-115.2-59.4-120.9-158.2-113.2 1.9-35.3 6.8-68.2 17.6-97.7 6.4-16.8 42.4-20.4 59.8-18 41.6 4.3 48.5-58.9 6.9-63.6zM63.5 308.2c-.2-9.6-.4-19.2-.5-28.8 27.5-1.2 60.3-3.5 86.5 .3 10.3 7.4 8.1 31.2 8.6 46.6-1.2 18.7 3.1 47.2-14.2 53.9-19.1 4.4-51.1 9-68.4 3.2-19.5-20.6-8.5-50.6-12-75.1z"],
    "book-open": [576, 512, [128214, 128366], "f518", "M29.1 16c4.5 0 8.8 .9 12.7 2.6 21.1 .5 40.3 5.2 59.6 6.4 67 2.5 120 30.6 182.1 65.1 79.5-52.6 161.5-62.3 252.4-62.3 7.5 0 14.4 2.6 19.8 6.9 12.1 5.2 20.2 17.6 19.3 31.5 1.8 114.7 3.7 229.6 .1 350.2-.1 18.7-16.2 33.1-34.7 31.8-79.7-.7-163.3 6-229 52.7-6 7.1-15.3 11.6-25.3 11.3-39.6-10.2-91-52.8-134.9-62-36.4-11.5-74.8-16.9-124.2-16.9-18 .4-33.6-16.3-31.9-34.2 5.6-80.9 4.4-161.3 3.1-243.2-.6-35.5-1.1-71.3-1.1-107.6 0-17.7 14.3-32 32-32zM319.3 423c59.8-31.3 125.6-37.9 192.1-38.4-.5-82.2 6.5-147.3 1.1-223.5-1.2-22.4-2.4-45.7-2.3-69.2-74.5 2-134.8 13.5-192.8 52.3L319 254.9c1.1 29.4 .7 109.6 .3 168.1zM253.4 146.6c-63.2-37.9-116.5-58.5-185.9-61-1.5-.2-4.7-.7-6.2-.9 .8 94.8 4.2 189.8-.4 285.2 72.7 3.6 131.3 21.6 194.3 55.8 .4-58.9 .9-140.1-.3-168.6 0-1.2-1.6-109.1-1.6-110.5z"],
    "box-archive": [512, 512, ["archive"], "f187", "M434.1 64.8c-130.6-3.6-241 4.7-364.9 .3-4.6-.1-9.6 4-9.9 9.7-1 18.6-1.9 36.5-1.2 51.8 134.8 3.2 235.6 2.5 377.1 2.2 8.5 .5 7.8-10.8 7.8-14.4 0-9.6-.6-26.4-1.4-42.5-.2-3.8-3.3-7.1-7.5-7.1zM234.8 1.4c57-2.2 133.3-1.7 200.3-.6 37.7 .6 68.7 30.3 70.4 68.2 1.9 41.1 8 85.4-28.4 110.2 8.5 101.1 6.1 203 .3 303.4-6.1 44.1-61.4 25.4-91.8 29.7-27 .5-59 1.1-86-1.4-80.3-3.3-158 4.7-238.3 1-16.5-.5-29.9-13.6-30.9-30.1-2-55.6-1-112.6 1.9-167.2l.1-.5c3.2-38.8 1.2-82.8 1.6-128.4-46.3-14.6-41.8-74.4-38.5-114.5 2.1-39.2 35.1-71.2 75.5-70.1 55.3 1.4 110.1 2.4 163.9 .4l0 0zM314.3 193c-72 0-144.1-.2-216.4-1.7 2 91.7-5.4 169.4-4.6 257.2 96.5-1.2 193.1-2.5 289.1-.2 11.1-.2 22.4-.4 33.6-.4l.6-7.1c0-24.9 .4-49.4 .9-73.5 1.1-59.4 2.1-116.8-3.3-174.5-38.4 .1-84.6 .2-99.8 .2zm20.5 128l-58.2 2.5c-36.6-5.2-123.3 24.2-124.5-33.9 6.1-43.8 57.1-24.2 88.3-29.2 11-.4 22.8-.9 34.2-.9l57.6-2.4c41.8-1.6 44.5 62 2.7 63.9z"],
    "list-ul": [576, 512, ["list-dots"], "f0ca", "M70.3 147.8c8.4 2.2 16.6 1.9 23.9-1.8 6.4-2 12.1-6 16.2-11.6 41.8-28.8 6.1-99.6-44.1-90.1-58.7 11.6-49 97.5 3.9 103.5zM82.4 311.6s.4-.1 1.8-.3l.3-.1c52.7-6.3 62.1-91.9 3.6-103.5-50.2-9.4-85.9 61.2-44.1 90.1 4.1 5.6 9.9 9.6 16.3 11.6 6.7 3.2 14.5 4.2 22.2 2.1zm2.4 47.9c-53.3-9.6-86.8 71.9-32.4 98.8 46.1 22.1 98.8-36.9 66-75.6-2.5-6.5-7-11.8-12.7-15.5-5.6-4.8-12.9-7.7-20.9-7.7zm236 84.9c70.3-4.8 138.4-9.4 208.7-6.6 17.7 .7 32.6-13 33.3-30.7s-13.1-32.5-30.7-33.2c-73.7-2.9-147.7 2-219.9 6.9-33.4 2.2-66.4 4.5-98.8 5.9-17.7 .7-31.4 15.7-30.6 33.3 .7 17.7 15.7 31.4 33.3 30.6 35.7-1.6 70.5-3.9 104.7-6.2zm-8.8-163.6l.3 0c68.6-1.4 135.6-1.9 204 1.4 17.7 .8 32.6-12.9 33.4-30.6 .8-17.6-12.9-32.6-30.6-33.4-68.9-3.4-138.9-2.9-208-1.5-32.8 .6-65.2 1.2-97.3 1.2-17.7 0-32 14.3-32 32s14.3 32 32 32c32.7 0 65.6-.6 98.1-1.2zM412.8 123.4c36-.9 74.2-5.7 107 .2 17.4 3.1 34-8.5 37.1-25.9 3.1-17.4-8.5-34-25.9-37.1-78.6-9.4-154.7 1.9-232 5.3-29.2 2-57.3 3.1-85 1.5-17.6-1.1-32.8 12.4-33.8 30 1.6 55.8 88 29.4 123.3 32.3 36.7-2.5 73.2-5.3 109.3-6.3z"],
    "money-bill": [576, 512, [], "f0d6", "M348 480c-82.7 0-201.2 0-272.8-7.9-35-3.9-60.1-31.3-65.2-63.5-16.7-106.9-9.9-192.2-3.3-305.6 8.3-72.2 75.2-73.2 132.7-69.6 134.3 3.4 235.3-4.9 363.7 1.1 42.1 2.4 72.9 37.6 73 78 .4 75.5 .7 232.5-2.1 297.4-1.3 32.3-24.6 58-57.1 62-66 6.9-108.8 7.6-168.9 8.2zM82.3 408.5c125.4 9.5 290.8 12.4 427.6-.4 3-63.6 2.4-218.6 2.2-295.4 0-8.4-6.1-14-12.7-14.4-126.3-5.8-229.5 2.4-361.4-1-19.4 3.6-68-12.1-67.9 14.6-5.8 109.9-12.6 186.2 3.3 287.8 1.3 5.6 5.3 8.3 8.9 8.7zM375.1 294.2c-24 60.1-102.4 77-152.2 36.9-39.9-38.2-42-107.5 1.2-146.2 78.7-67.2 195.7 9.8 151 109.3zM266.7 232.5c-13.7 12.3-14.3 38.3 .4 52.3 4.3 3.5 22.4 3.8 29.3 2.2 18.9-.3 27.7-38.3 22.7-46.8-7.1-19.8-38.5-20.4-52.3-7.7z"],
    "arrow-pointer": [512, 512, ["mouse-pointer"], "f245", "M20.7 110.5c-16.3-50.7 32.7-89.6 77-76.3 134.2 40.4 240.4 67.2 361.6 124.7 19.3 9.4 31.5 27.7 33.1 47.7 4.6 73.4-134.2 92-181.8 108.6L261.9 431.7c-20.6 47.3-90.8 54.7-116 4.2-29.6-67-56.8-137.9-82.6-206-14.3-40.4-28.9-79.3-42.6-119.4zM83.5 96.7c9.3 26.4 119.3 309.8 119.3 309.8s43-101.7 47.6-113.7c7.4-19.5 23.9-34.5 44.5-39.7 41.9-10.5 88.3-23.3 124.8-42.1-112.2-51.3-210.3-76.3-336.2-114.2z"],
    "cake-candles": [512, 512, [127874, "birthday-cake", "cake"], "f1fd", "M448.9-.5c-.2-41.9-63.8-41.9-64 0l0 166.2c-46.2 .6-57 .6-92.6 .5L287.9 14.2c-.5-17.7-15.2-31.6-32.9-31.1S223.5-1.7 224 16l4.3 150.3c-28.4 .1-51.4 .1-81.9-1.1-5.9-.2-12-.4-18.3-.5l0-157.2c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 156.7c-47.9-2.2-67.8 33.7-63.5 76.2-.5 72-1.1 144.8-.1 217 .4 31.6 26.9 56.4 58.2 55 51.6-2.4 94.1-1 144.6-1.4 69.6 0 186.9 .1 252.9 .3 70.4-2.5 54.8-79.5 54.7-128-1.2-53.8-2.3-106.4 0-159.5 1.7-34-27.6-62-62.1-58.8l0-165.4zM64.7 228.2c135.7 1.6 238.8 3.6 382 .8-.9 24.8-1.1 49.8-1 74.7-15.6 20.3-27 22.2-35.1 21.7-12.5-.7-27.6-7.8-49.6-21.1-34.5-20.7-72.2-47.9-116.4-41.2-16.9 2.6-32.5 10.2-46.7 22.6-37.4 33.4-92.4 54.2-133.7 21.5 .2-26.2 .4-52.8 .5-79.1zm-.3 220c-.3-22.8-.4-45.6-.4-68.5 61.9 24.1 130.3-5.8 176-45.7 26.3-20.1 48.2 3.6 76.3 18.1l0 0c34.6 22.4 85.6 50.6 130.6 30.7l.1 4.2c.4 20.3 .9 40.4 1.1 60.3-125.4 .5-259.6-2-383.7 .9z"],
    "bug-slash": [576, 512, [], "e490", "M55.7-22.8c-12.6-12.4-32.9-12.3-45.2 .3-12.4 12.6-12.3 32.9 .3 45.2 34.3 34.1 69.7 63.2 103.4 98.3 90.6 87.8 178.4 172.7 262.1 268.9 41.4 54.1 97.1 98.9 145.5 144 12.1 12.9 32.4 13.5 45.2 1.5 12.9-12.1 13.5-32.4 1.5-45.2-50.1-48.3-98.2-83.1-142.7-140.8-115.6-132-242.7-251.5-370.1-372.1zm369.9 3.7l-.1 0c-14.8-9.7-34.6-5.5-44.3 9.3l0-.1 0 .1c-3.3 4.3-8.4 9.6-12.6 14.4-9.2 10.2-19.2 21-27.4 32.2-30.3-10.5-113.7-20.6-106.9 34.3 3.9 17.2 21 28.1 38.2 24.2 27.1-6.1 48.8-.6 67 11.8 24.9 16.4 55.1 60.3 56.9 95.5 1.5 29-2.4 56.8 26.7 78.7 22.4 15.5 86.2 37.4 93.9-8 2.4-17.5-9.8-33.7-27.3-36.1-18-2.5-25.4-5.6-27.9-7-1.4-10.2-.4-23.8-1.8-35.9l41.7 .4c41.9 .3 42.5-63.4 .7-64L440 130c-11.5-22.1-26.1-42.7-44.1-59.5 5.3-6.7 13.3-15.6 19.5-22.3 19.6-18.2 38.6-47.3 10.2-67.4zm-324 277.8c-55-3.4-49.4 74.1 4.4 63.8 7.9-.4 15.3-.8 22.6-1 4.1 22 6.2 41.8 10.1 63.5-27.4 5.5-75-5.9-76.1 35.2 4 49.2 64.5 27.9 97.3 27 34 56.4 114.7 70.7 180 61.1 17.6-1.3 30.9-16.6 29.6-34.2s-16.6-30.9-34.2-29.6l-45.3 3.3c-27.8-3.7-45.4-9.7-56.7-16.3-29.8-17.5-29.5-48.9-35.6-82.8-9.2-73.7-15.5-99.6-96.3-90.1z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M398.3 48.8C288.1-38.2 105.5-11.7 37.6 120.5 6.8 185.9-16.3 246.2-1.3 324.7 38.2 508.8 280.8 563.2 416.1 450.3 544.4 341.5 531.3 153.5 398.3 48.8zM205 68.3C390.4 19.5 530 274.6 373.8 402.1 278.9 484 86.6 443.6 61.5 312.7 46.3 228.7 92.1 88.2 205 68.3zM258.2 122c-53.1 2-38.6 79.2 9.8 62.5 34-10.4 26.2-62.9-9.8-62.5zM235.5 280.1l.1 1.9c.8 13.3 1.4 24.7 .8 36.1l-13 .1c-41.9 .6-41.2 64.3 .6 64l78.7-.8c43.1-1.3 40.8-65.5-2.2-64 .5-14.8-.4-29.6-1.1-42.6 2.4-41.1-25.2-65.2-68-58.7-59.1-4.7-53.4 74.5 4.2 63.9z"],
    "feather": [512, 512, [129718], "f52d", "M222.8 93.5c7.3 36.8 17.9 99.9 20 128.8 10.6-11 22.1-21.4 33.1-32.1 21.5-18.7 45.8-62 77.6-33.8 29.4 30.2-13.4 58.8-32.9 79.5-8.9 8.6-18.1 17.2-26.9 25.9 22.6 0 45.4-.5 68.4-1 21.6-.5 43.4-.9 65.5-1 74.3-140.3-83.8-244.2-206-171 .4 1.6 .8 3.3 1.2 4.7zm12.4 230.9c-11.1 11.2-23.2 21.9-34.7 32.7-11.2 10.3-22.2 20.5-33.1 30.8 52.8 3.7 108 3.9 157.1-5.7 21-16.2 42-35.9 60.5-57.8-5.8 .1-11.6 .3-17.5 .4-43.3 .9-88.6 1.9-132.3-.4zm-53-70.3c-.3-2.2-.5-4.4-.8-6.7-1.4-11.1-2.9-23.3-3.6-34.1-3.2-24.6-8-53.4-12.5-79.3-14.9 15.9-37.6 42.2-49 55.5-4.6 47.7 .5 98.5 2 156.8 22.1-21.1 44.8-41.3 66.8-62.2-.3-8.5-1.4-18.6-2.8-29.9zM56.8 404.9c-1.9-69.4-10.2-158.9-4.1-222.9 6.1-38.6 47.3-67.5 72.5-98.8 66.8-72.9 187.4-110.1 283.6-57.3 185.6 94.2 81.2 319.4-46 407.4-65.5 31.9-148.6 19.5-217.2 17-15.1-1.5-26-2-41.7-1.9l-2.2 2c-29.2 18.9-54.1 79.3-93.2 50.4-35.4-36.9 26.8-71.4 48.2-95.9z"],
    "phone-arrow-down-left": [512, 512, ["phone-arrow-down", "phone-incoming"], "e223", "M234.5 84c16.8 28.5 3.2 74.2-17.6 95.8-48 55.8 27.4 140.9 91.6 121.3 17.3-4.1 34.1-10.3 50-20.4 11.7-7.4 20-14.8 40.2-15.6 38.6 2.4 52.5 28.9 69 51.4 21.2 28.1 42.9 67 19.8 105.2-87.5 129.1-280.5 100.6-376.8 6.8-78.9-69.8-111.4-159.7-110.5-259.4 4-59.8 38.9-142.8 102-166.6 57.9-12.3 109.3 33 132.3 81.4zM119.7 64.3c-144.8 126.5 14.1 382.6 182.3 380.4 57.4-.4 112.1-18.7 131.5-58.4-3-16.2-23-40.6-34.9-55.3-67 48.6-167.9 50.6-222.7-15.3-28.9-33.6-48.5-83.5-33.4-129.9 7.1-26.9 27.2-45.4 35.9-65.7-1.8-22.9-34.9-56-58.7-55.9zm198.5-32c17.6-1.1 32.8 12.3 34 29.9l3.1 49.7c35.2-36.7 68.2-73.8 110.6-105.5 14.3-10.4 34.3-7.2 44.7 7.1 10.4 14.3 7.2 34.3-7 44.7-24.4 17.8-45 38.9-67.7 62.3-14.6 15.1-29.1 29.1-43.2 46.1 16.6 1.2 36.6 2.1 52.2 1.7 41.8-1.1 43.7 62.6 1.9 64-29.9 1.3-55.3-3.4-85.2-1.5-24.7 2.9-62.4 5.3-64.5-28.5L288.2 66.2c-1.1-17.6 12.3-32.8 29.9-34z"],
    "wind": [576, 512, [], "f72e", "M208.5 20.1c6.7-16.4 25.3-24.2 41.7-17.6L278.4 14c56.3 19.4 91.1 85.1 48.1 138.1-34.7 40.9-106.2 33.7-154.2 38-38.1 .8-77.6-.3-113.9 3.2-17.6 1.7-33.2-11.3-34.8-28.8 .5-55 79.6-32.2 115.9-38 45.5-.2 95.8-.9 135.5-12.4 25.3-28.7-27.9-43.3-48.9-52.3-16.4-6.7-24.2-25.3-17.6-41.7zm65.7 94.7l.1-.1s-.1 .1-.1 .1zM402 135.6c4.5-47.1 60.7-32.6 95.4-20.4 62.6 23.5 59.7 108.2 5.6 141.2-21.1 14.6-46.7 22.6-67.9 25.7-125.8 18.5-250.3 5.3-375.7 9.1-17.7 .5-32.4-13.3-33-31s13.3-32.4 31-33c44.3-1.3 89.2-.6 133.2 .2 78.7 1.4 158.9 2.7 235.1-8.6 20.1-2.8 59.9-16.7 53.8-39.9-22.6-20.4-76 2.8-77.6-43.3zM62.1 384.2c-40.9-.1-42.3-61.8-1.8-64 23.5-.1 46.8-.5 70.9-1.1 65.1-1.5 132.9-3 200.4 6.6 29.3 4.2 57.3 19.6 74.3 44.1 29.9 38.8 14.5 109.5-34.7 130.9-26.8 12.4-88.5 21.8-88.3-23.8 .9-17.7 15.9-31.3 33.5-30.4 20.5-.3 28.5 .1 37.1-12.9 33.2-72.4-176.2-46.8-216.1-50.6-24.5 .5-49.6 1.1-75.4 1.1z"],
    "layer-group": [576, 512, [], "f5fd", "M260.5-23.7c17.2-7.5 36.5-6.7 52.9 1.7 55.6 28.4 145.8 82.1 188.6 107.8 33 19.9 29.4 66.3-1.4 83.9-43.2 26.1-90.1 51.8-135.6 72.2-1.2 .5-6.9 3.3-8 3.7-27.8 10.5-67.1 34.6-96.8 17.9-62.7-29.2-108.5-45.2-167.1-73.6-13.3-6.2-28.2-13.1-42.1-20.9-33.8-18.9-29.2-63.8-.3-80.8 42.4-24.9 142.6-82.8 209.7-112zm24.6 59.1c-51.7 22.6-126 64-174.4 92.1 60.4 29.4 112.7 48.3 176.3 77.8l45.1-18.5 5.4-2.6c37.1-17.3 72.7-34.8 106.6-55.5l2.5-1.5C400.1 99.5 330.3 58.6 285.1 35.4zM24.3 245.9c9.5-14.9 29.3-19.3 44.2-9.8 29.2 18.7 60.7 34.7 93.4 50.4 35.9 17.2 98 48.5 125.2 62.3 70.7-30.4 141.6-65.3 200.3-95 63.4-42.2 98.7 36 26.6 58.2l0 0c-56.8 29.1-135.6 67.1-201 95.3-17.6 7.8-37.7 7.3-54.8-1.4-27.3-13.8-88.9-44.8-124.1-61.7-33.3-16-67.6-33.3-100.2-54.1-14.9-9.5-19.3-29.3-9.8-44.2zm515 178.7c-17.9 7.1-35 15.5-53.4 24.4-44 20.5-120.6 64-155 83.7-16.2 9.3-35.9 11.3-54 4.3-36.4-14-137.8-55-235.7-114.2-35.8-21.8-2.7-76.3 33.1-54.8 92.7 56.1 189.5 95.4 225 109.1 33.4-19.2 112.4-64 158.2-85.4 28.9-10.8 78.9-52.1 99.6-8.6 6.6 16.4-1.4 35-17.8 41.6z"],
    "shield": [448, 512, [128737, "shield-blank"], "f132", "M225.9 62.8c-60.1 23.3-103.1 43.8-159.7 58.9 5.8 167.5-24.3 246.4 146.9 320.6 65.9-21.4 110-61 151-116.1 32.7-60.3 14.2-141.8 16.6-208.7-51.4-18.4-102.6-40.9-154.9-54.7zM202.6 3.2c23.7-11.8 57.3 3.6 80.6 9.6 47.3 16.1 91.3 36.3 138.5 50.2 13.6 4 23 16.5 23 30.7 0 44.7 2.5 90.1 2.5 135.4-.3 42.4-3.5 96.2-31.2 134.8-46 62.8-101.2 111.1-176 137.1-16.1 5.3-23.8 11.7-39.2 5.6-185.5-70.9-205.3-184.3-197.4-358.7l0 .2c.7-22.5-7.1-47.4 5.3-68.5 5.1-10.9 29.3-16.3 41.9-20 56.1-15 95.4-34.7 152.2-56.4z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M396.8 457.2C286.5 544.2 104 517.8 36.1 385.5 5.3 320.2-17.8 259.8-2.8 181.3 36.8-2.8 279.2-57.2 414.5 55.7 542.9 164.6 529.8 352.5 396.8 457.2zM203.5 437.7c185.4 48.8 325-206.3 168.8-333.9-94.9-81.8-287.3-41.5-312.3 89.4-11 57.5 4.3 102 34 164.9 19.8 42 58.5 66.2 109.5 79.5zM167.7 153.1c-43.9 7.5-46.7 81.6 1.6 82.3 62.6-4.5 62.9-81.9-1.6-82.3zM151.6 263c66.3 0 132.6 1.8 198.6 1.8 17.7 0 32 14.3 32 31.9 .2 58-35.6 97-80.6 112.1-75.2 24.4-180.8-15.4-182-113.1-.7-17.4 14.6-33.1 32-32.7zm50.9 71.4c33.8 24.2 81.7 25.4 106.4-5.8-39.4-.3-77.6-1-114.4-1.4 2.4 2.8 5.1 5.1 8 7.2zM353.9 170.9c38 30.4-2.6 82.5-43.5 65.8-60.1-26.5-6.7-112 43.5-65.8z"],
    "cart-shopping": [640, 512, [128722, "shopping-cart"], "f07a", "M0 32C0 14.3 14.3 0 32 0L74.7 0c31.6-2 62.9 23.5 67.8 62 107.9 .3 197.2-.8 308.7 1 35.6 .5 71.2 1 92.8 1 17.7-.4 33.1 15.7 32 33.3-5.3 67.6-29.4 203.6-85.8 265.2-23.4 25.8-60.8 24.9-96.1 26.9-60.3 2.9-138.2-2-194.2-5-84.1-11.2-89.6-160.8-105-228.6-4.7-29-11.4-71.3-18.2-91.7-27.6-1.6-75.2 9.5-76.6-32.1l0 0zm154.9 94c1.2 6.9 2.3 13.9 3.4 21 10 55 17.7 130.6 47.3 173.7 72.6 3.3 164.5 11 234.9 .2 42.4-43.1 57.6-136.9 68.1-193.1-122.6-2.2-234.5-1.8-353.7-1.7zM256 464c-1.1-63.1-94.9-63.1-96 0 1.1 63.1 94.9 63.1 96 0zm176 48c-63.1-1.1-63.1-94.9 0-96 63.1 1.1 63.1 94.9 0 96z"],
    "arrow-up-arrow-down": [512, 512, ["sort-up-down"], "e099", "M350.6 64.2c-1.4 30.3 .8 230.1 1.4 311.4-17.3-18.2-31.5-33.1-48.8-47.6-31.6-27.4-73.5 20.6-42.1 48.2 32.5 27.2 67.5 71.3 100.6 98.3 13.1 10.7 32.3 9.3 43.8-3.1 31.2-33.9 60-65.1 93.2-93.3 31.7-27.2-9.4-75.8-41.4-48.8-14.5 12.3-28.1 25.1-41.2 38.1-.1-13.8-.3-33.2-.5-55.6-.8-88.2-2-223.2-1-244.4 2-41.8-61.6-45.1-63.9-3.3zm-190 131.4c-.2-23.8-.4-43.6-.5-55.6 17.3 18.2 31.5 33.1 48.8 47.6 31.6 27.4 73.5-20.6 42.1-48.2-32.5-27.2-67.5-71.3-100.6-98.4-12.7-10.4-31.2-9.4-42.8 2.2l-96 96c-29.5 29.7 15.6 74.7 45.2 45.2l39.4-39.3c.1 13.8 .3 34.5 .5 58.6 .8 88.2 2 223.2 1 244.4-.9 17.6 12.7 32.7 30.3 33.6 17.7 .9 32.7-12.7 33.6-30.3 1.2-23.3-.1-167.9-.9-255.9z"]
  };

  bunker(function () {
    defineIcons('fawsb', icons);
  });

}());
