# AdoxEdu SCSS Styles

This directory contains the consolidated SCSS styles for the entire AdoxEdu application.

## Quick Start

```bash
# Install dependencies
npm install

# Watch for changes during development
npm run scss:watch

# Build for production
npm run scss:build
```

## File Structure

```
assets/
├── scss/
│   ├── main.scss      # Source SCSS file
│   └── README.md      # This file
└── css/
    ├── main.css       # Compiled CSS (minified)
    └── main.css.map   # Source maps for debugging
```

## Available Scripts

| Command | Description |
|---------|-------------|
| `npm run scss:build` | Compile SCSS to minified CSS with source maps |
| `npm run scss:watch` | Watch for changes and auto-compile (minified) |
| `npm run scss:dev` | Watch with uncompressed output for debugging |

## SCSS Organization

The `main.scss` file is organized into sections:

1. **Variables** - Colors, spacing, border-radius, fonts, z-index
2. **CSS Custom Properties** - Runtime theming variables
3. **Base Styles** - Body and foundational styles
4. **UIKit Overrides** - Customizations to UIKit components
5. **Component Styles** - Toast, skeleton loaders, empty states, etc.
6. **Layout Styles** - Page structure and containers
7. **Auth Pages** - Login, register, forgot-password
8. **Portal Styles** - Admin, Student, Counselor, Chancellor
9. **Utility Classes** - Flexbox, dimensions, colors
10. **Responsive Styles** - Tablet and mobile breakpoints
11. **Dark Mode** - Complete dark theme support

## Color Palette

### Primary Colors
- Primary: `#1a1a1a`
- Success: `#22c55e`
- Warning: `#f59e0b`
- Danger: `#ef4444`
- Info: `#3b82f6`

### Dark Mode Colors
- Background Primary: `#0f172a`
- Background Secondary: `#1e293b`
- Text Primary: `#f8fafc`
- Text Secondary: `#94a3b8`

## Usage in PHP Files

All layout files include the compiled CSS:

```html
<link rel="stylesheet" href="/assets/css/main.css">
```

## Adding New Styles

1. Open `assets/scss/main.scss`
2. Find the appropriate section for your styles
3. Add your SCSS code
4. Save - the watch process will auto-compile

### Example: Adding a new component

```scss
// -----------------------------------------------------------------------------
// 5.x New Component Name
// -----------------------------------------------------------------------------
.my-component {
  padding: $spacing-lg;
  border-radius: $radius-md;
  background: $bg-light;

  &-title {
    font-size: $font-size-lg;
    color: $text-primary;
  }
}
```

## Variables Reference

### Spacing
- `$spacing-xs`: 2px
- `$spacing-sm`: 4px
- `$spacing-md`: 8px
- `$spacing-lg`: 12px
- `$spacing-xl`: 16px

### Border Radius
- `$radius-sm`: 4px
- `$radius-md`: 8px
- `$radius-lg`: 12px
- `$radius-xl`: 16px

### Font Sizes
- `$font-size-xs`: 9px
- `$font-size-sm`: 10px
- `$font-size-base`: 11px
- `$font-size-md`: 13px
- `$font-size-lg`: 14px

## Dark Mode

Dark mode is automatically supported via `[data-theme="dark"]` selectors. When adding new styles, include dark mode variants:

```scss
.my-element {
  background: $bg-light;
  color: $text-primary;
}

[data-theme="dark"] .my-element {
  background: var(--bg-secondary);
  color: var(--text-primary);
}
```

## Troubleshooting

### CSS not updating
- Ensure `npm run scss:watch` is running
- Check for SCSS syntax errors in terminal
- Hard refresh browser (Ctrl+Shift+R)

### Source maps not working
- Ensure `.map` file exists in `assets/css/`
- Enable source maps in browser DevTools

### Styles not applying
- Check CSS specificity
- Verify the selector matches your HTML
- Use browser DevTools to inspect applied styles
