<?php
/**
 * Forgot Password API Endpoint
 * Handles password reset requests and returns HTML for HTMX
 */

require_once __DIR__ . '/../includes/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo '<div class="uk-alert uk-alert-danger uk-margin-small">Method not allowed</div>';
    exit;
}

$email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);

// Validate input
if (empty($email)) {
    echo '<div class="uk-alert uk-alert-danger uk-margin-small">
        <span uk-icon="icon: warning"></span> Email address is required.
    </div>';
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo '<div class="uk-alert uk-alert-danger uk-margin-small">
        <span uk-icon="icon: warning"></span> Please enter a valid email address.
    </div>';
    exit;
}

// Generate reset token (in production, save to database)
$resetToken = bin2hex(random_bytes(32));
$resetExpiry = date('Y-m-d H:i:s', strtotime('+1 hour'));

// In production, you would:
// 1. Check if email exists in database
// 2. Generate and store reset token
// 3. Send email with reset link

// For demo purposes, we'll simulate success
// In production: send actual email with link like: /auth/reset-password.php?token=$resetToken

// Log the reset request (for demo)
$logMessage = sprintf(
    "[%s] Password reset requested for: %s (Token: %s, Expires: %s)\n",
    date('Y-m-d H:i:s'),
    $email,
    $resetToken,
    $resetExpiry
);

// Could write to log file in production
// file_put_contents(__DIR__ . '/../../logs/password-resets.log', $logMessage, FILE_APPEND);

// Return success message
echo '<div class="uk-alert uk-alert-success uk-margin-small">
    <span uk-icon="icon: check"></span>
    <strong>Reset link sent!</strong><br>
    If an account exists with <strong>' . htmlspecialchars($email) . '</strong>, you will receive a password reset link shortly. Please check your inbox and spam folder.
</div>
<div class="uk-text-small uk-text-muted uk-margin-small-top">
    <span uk-icon="icon: info; ratio: 0.8"></span>
    The link will expire in 1 hour for security reasons.
</div>';
