<?php
/**
 * Login API Endpoint
 * Handles user authentication
 */

require_once __DIR__ . '/../includes/bootstrap.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
$password = $_POST['password'] ?? '';
$remember = isset($_POST['remember']);

// Validate input
if (empty($email) || empty($password)) {
    http_response_code(400);
    echo json_encode(['error' => 'Email and password are required']);
    exit;
}

// TODO: Implement actual authentication logic
// For now, return a mock response

// Mock successful login
$response = [
    'success' => true,
    'message' => 'Login successful',
    'redirect' => '/admin/', // Redirect based on role
    'user' => [
        'id' => 1,
        'name' => 'Admin User',
        'email' => $email,
        'role' => 'admin'
    ]
];

echo json_encode($response);
