<?php
require_once __DIR__ . '/includes/bootstrap.php';
$page_title = 'Reset Password';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($page_title) ?> - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">
</head>
<body>
    <!-- Theme Toggle -->
    <button class="theme-toggle uk-icon-button" onclick="toggleDarkMode()" aria-label="Toggle dark mode">
        <span uk-icon="icon: paint-bucket"></span>
    </button>

    <div class="uk-container">
        <div class="uk-flex uk-flex-center">
            <div class="uk-width-medium">
                <div class="uk-text-center uk-margin-bottom">
                    <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle uk-margin-auto" style="width: 48px; height: 48px; background: #1a1a1a; color: white; font-size: 16px; font-weight: 600;">GP</span>
                    <h2 class="uk-margin-small-top"><?= APP_NAME ?></h2>
                </div>

                <div class="uk-card uk-card-default uk-card-body">
                    <h3 class="uk-card-title uk-text-center">Reset Password</h3>
                    <p class="uk-text-muted uk-text-center uk-text-small">Enter your email address and we'll send you a link to reset your password.</p>

                    <form class="uk-form-stacked" hx-post="api/forgot-password.php" hx-target="#result">
                        <div class="uk-margin">
                            <label class="uk-form-label">Email Address</label>
                            <input class="uk-input" type="email" name="email" placeholder="Enter your email" required>
                        </div>
                        <div id="result"></div>
                        <button class="uk-button uk-button-primary uk-width-1-1" type="submit">Send Reset Link</button>
                    </form>

                    <div class="uk-text-center uk-margin-top">
                        <a href="login.php" class="uk-text-small">Back to Sign In</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    <script>
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
        }
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
</body>
</html>
