<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign In - GlobalEd Pathways</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">
</head>
<body>
    <!-- Theme Toggle -->
    <button class="theme-toggle uk-icon-button" onclick="toggleDarkMode()" aria-label="Toggle dark mode">
        <span uk-icon="icon: paint-bucket"></span>
    </button>

    <div class="uk-card uk-card-default uk-card-body login-card">
        <div class="uk-flex uk-flex-middle uk-margin-bottom">
            <a href="../" class="uk-margin-small-right" uk-icon="icon: arrow-left"></a>
            <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle" style="width: 32px; height: 32px; background: #1a1a1a; color: white; font-size: 12px; font-weight: 600;">GP</span>
            <span class="uk-margin-small-left uk-text-bold">Student Portal</span>
        </div>

        <h3 class="uk-text-center uk-margin-bottom">Welcome Back</h3>

        <form hx-post="api/login.php" hx-target="#login-result" method="POST">
            <div class="uk-margin">
                <label class="uk-form-label">Email Address *</label>
                <input class="uk-input" type="email" name="email" placeholder="john.doe@example.com" required>
            </div>

            <div class="uk-margin">
                <label class="uk-form-label">Password *</label>
                <div class="uk-inline uk-width-1-1">
                    <input class="uk-input" type="password" name="password" placeholder="Enter your password" required>
                    <a class="uk-form-icon uk-form-icon-flip" href="#" uk-icon="icon: eye"
                       _="on click toggle [@type='password'] on previous <input/> then toggle .uk-hidden on me then toggle .uk-hidden on next <a/>"></a>
                    <a class="uk-form-icon uk-form-icon-flip uk-hidden" href="#" uk-icon="icon: eye-slash"
                       _="on click toggle [@type='password'] on previous previous <input/> then toggle .uk-hidden on me then toggle .uk-hidden on previous <a/>"></a>
                </div>
            </div>

            <div id="login-result"></div>
            <button class="uk-button uk-button-primary uk-width-1-1 uk-margin-top" type="submit">Sign In</button>
        </form>

        <div class="uk-text-center uk-margin-top">
            <a href="forgot-password.php" class="uk-link-muted">Forgot your password?</a>
        </div>

        <hr class="uk-margin-medium-top uk-margin-medium-bottom">

        <div class="uk-text-center">
            <p class="uk-text-muted uk-margin-small-bottom">Don't have an account?</p>
            <a href="register.php" class="uk-button uk-button-default uk-width-1-1">Create Account</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>
    <script>
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
        }
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
</body>
</html>
