<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Account - GlobalEd Pathways</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">
</head>
<body>
    <!-- Theme Toggle -->
    <button class="theme-toggle uk-icon-button" onclick="toggleDarkMode()" aria-label="Toggle dark mode">
        <span uk-icon="icon: paint-bucket"></span>
    </button>

    <div class="uk-card uk-card-default uk-card-body register-card">
        <div class="uk-flex uk-flex-middle uk-margin-bottom">
            <a href="login.php" class="uk-margin-small-right" uk-icon="icon: arrow-left"></a>
            <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle" style="width: 32px; height: 32px; background: #1a1a1a; color: white; font-size: 12px; font-weight: 600;">GP</span>
            <span class="uk-margin-small-left uk-text-bold">GlobalEd Pathways</span>
        </div>

        <h3 class="uk-text-center uk-margin-bottom">Create Your Account</h3>

        <form action="#" method="POST">
            <div class="uk-grid-small" uk-grid>
                <div class="uk-width-1-2@s">
                    <label class="uk-form-label">First Name *</label>
                    <input class="uk-input" type="text" placeholder="John" required>
                </div>
                <div class="uk-width-1-2@s">
                    <label class="uk-form-label">Last Name *</label>
                    <input class="uk-input" type="text" placeholder="Doe" required>
                </div>
            </div>

            <div class="uk-margin">
                <label class="uk-form-label">Email Address *</label>
                <input class="uk-input" type="email" placeholder="john.doe@example.com" required>
            </div>

            <div class="uk-margin">
                <label class="uk-form-label">Password *</label>
                <input class="uk-input" type="password" placeholder="Create a strong password" required>
            </div>

            <div class="uk-margin">
                <label class="uk-form-label">Confirm Password *</label>
                <input class="uk-input" type="password" placeholder="Confirm your password" required>
            </div>

            <div class="uk-margin">
                <label class="uk-form-label">I am a... *</label>
                <select class="uk-select" required
                        _="on change if my value == 'student' show #student-fields hide #counselor-fields else if my value == 'counselor' show #counselor-fields hide #student-fields else hide #student-fields hide #counselor-fields">
                    <option value="">Select your role</option>
                    <option value="student">Student</option>
                    <option value="counselor">Counselor</option>
                </select>
            </div>

            <!-- Student-specific fields -->
            <div id="student-fields" class="uk-hidden">
                <div class="uk-margin">
                    <label class="uk-form-label">Target Study Destination</label>
                    <select class="uk-select">
                        <option value="">Select country</option>
                        <option>United States</option>
                        <option>United Kingdom</option>
                        <option>Canada</option>
                        <option>Australia</option>
                        <option>Germany</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Intended Start Date</label>
                    <select class="uk-select">
                        <option value="">Select term</option>
                        <option>Fall 2024</option>
                        <option>Spring 2025</option>
                        <option>Fall 2025</option>
                    </select>
                </div>
            </div>

            <!-- Counselor-specific fields -->
            <div id="counselor-fields" class="uk-hidden">
                <div class="uk-margin">
                    <label class="uk-form-label">Organization</label>
                    <input class="uk-input" type="text" placeholder="Your company or school">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Years of Experience</label>
                    <select class="uk-select">
                        <option value="">Select experience</option>
                        <option>0-2 years</option>
                        <option>3-5 years</option>
                        <option>6-10 years</option>
                        <option>10+ years</option>
                    </select>
                </div>
            </div>

            <div class="uk-margin">
                <label>
                    <input id="terms-checkbox" class="uk-checkbox" type="checkbox" required disabled>
                    I agree to the <a href="#" uk-toggle="target: #tos-modal">Terms of Service</a> and <a href="#" uk-toggle="target: #privacy-modal">Privacy Policy</a>
                </label>
                <div class="uk-text-small uk-text-muted uk-margin-small-top">Please read both documents to enable this checkbox</div>
            </div>

            <button class="uk-button uk-button-primary uk-width-1-1 uk-margin-top" type="submit">Create Account</button>
        </form>

        <!-- Terms of Service Modal -->
        <div id="tos-modal" uk-modal>
            <div class="uk-modal-dialog">
                <button class="uk-modal-close-default" type="button" uk-close></button>
                <div class="uk-modal-header">
                    <h2 class="uk-modal-title">Terms of Service</h2>
                </div>
                <div id="tos-content" class="uk-modal-body" style="max-height: 400px; overflow-y: auto;"
                     _="on scroll if my scrollTop + my clientHeight >= my scrollHeight - 10 then set #tos-read to 'true' then call checkBothRead()">
                    <h4>1. Acceptance of Terms</h4>
                    <p>By accessing and using GlobalEd Pathways services, you acknowledge that you have read, understood, and agree to be bound by these Terms of Service. If you do not agree with any part of these terms, you may not use our services.</p>

                    <h4>2. Description of Services</h4>
                    <p>GlobalEd Pathways provides educational consulting services, including but not limited to university application assistance, document preparation, counseling services, and related educational guidance.</p>

                    <h4>3. User Responsibilities</h4>
                    <p>Users are responsible for providing accurate and truthful information. Any falsification of documents or misrepresentation may result in immediate termination of services and potential legal action.</p>

                    <h4>4. Payment Terms</h4>
                    <p>All payments are due according to the agreed payment schedule. Refunds are subject to our refund policy and may be prorated based on services already rendered.</p>

                    <h4>5. Privacy and Data Protection</h4>
                    <p>We are committed to protecting your personal information in accordance with applicable data protection laws. Please refer to our Privacy Policy for detailed information.</p>

                    <h4>6. Limitation of Liability</h4>
                    <p>GlobalEd Pathways shall not be liable for any indirect, incidental, special, consequential, or punitive damages resulting from your use of our services.</p>

                    <h4>7. Modifications to Terms</h4>
                    <p>We reserve the right to modify these terms at any time. Continued use of our services after such modifications constitutes acceptance of the updated terms.</p>

                    <h4>8. Governing Law</h4>
                    <p>These terms shall be governed by and construed in accordance with the laws of the jurisdiction in which GlobalEd Pathways operates.</p>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button class="uk-button uk-button-primary uk-modal-close" type="button">I Have Read This</button>
                </div>
            </div>
        </div>

        <!-- Privacy Policy Modal -->
        <div id="privacy-modal" uk-modal>
            <div class="uk-modal-dialog">
                <button class="uk-modal-close-default" type="button" uk-close></button>
                <div class="uk-modal-header">
                    <h2 class="uk-modal-title">Privacy Policy</h2>
                </div>
                <div id="privacy-content" class="uk-modal-body" style="max-height: 400px; overflow-y: auto;"
                     _="on scroll if my scrollTop + my clientHeight >= my scrollHeight - 10 then set #privacy-read to 'true' then call checkBothRead()">
                    <h4>1. Information We Collect</h4>
                    <p>We collect personal information that you voluntarily provide, including name, email address, phone number, educational history, financial information for payments, and documents required for university applications.</p>

                    <h4>2. How We Use Your Information</h4>
                    <p>Your information is used to provide our consulting services, process applications, communicate with you about your applications, and improve our services.</p>

                    <h4>3. Information Sharing</h4>
                    <p>We may share your information with universities, educational institutions, and third-party service providers necessary to fulfill our services. We do not sell your personal information.</p>

                    <h4>4. Data Security</h4>
                    <p>We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p>

                    <h4>5. Data Retention</h4>
                    <p>We retain your personal information for as long as necessary to provide our services and comply with legal obligations. You may request deletion of your data subject to legal requirements.</p>

                    <h4>6. Your Rights</h4>
                    <p>You have the right to access, correct, delete, and port your personal data. You may also object to certain processing activities and withdraw consent where applicable.</p>

                    <h4>7. Cookies and Tracking</h4>
                    <p>We use cookies and similar technologies to improve user experience and analyze usage patterns. You can control cookie preferences through your browser settings.</p>

                    <h4>8. Contact Us</h4>
                    <p>For questions about this Privacy Policy or to exercise your rights, please contact our Data Protection Officer at privacy@globaledpathways.com.</p>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button class="uk-button uk-button-primary uk-modal-close" type="button">I Have Read This</button>
                </div>
            </div>
        </div>

        <input type="hidden" id="tos-read" value="false">
        <input type="hidden" id="privacy-read" value="false">
        <script>
            function checkBothRead() {
                var tosRead = document.getElementById('tos-read').value === 'true';
                var privacyRead = document.getElementById('privacy-read').value === 'true';
                if (tosRead && privacyRead) {
                    document.getElementById('terms-checkbox').disabled = false;
                }
            }
        </script>

        <hr class="uk-margin-medium-top uk-margin-medium-bottom">

        <div class="uk-text-center">
            <p class="uk-text-muted uk-margin-small-bottom">Already have an account?</p>
            <a href="login.php" class="uk-button uk-button-default uk-width-1-1">Sign In</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>
    <script>
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
        }
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
</body>
</html>
