<?php
if (!defined('APP_NAME')) {
    require_once __DIR__ . '/bootstrap.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($page_title ?? 'High Chancellor Portal') ?> - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">

    <!-- Chart & Map Libraries -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css">
</head>
<body>
    <!-- Skip Link for Accessibility -->
    <a href="#main-content" class="skip-link">Skip to main content</a>

    <!-- Page Loading Indicator -->
    <div id="page-loader" class="page-loading" style="display: none;"></div>

    <!-- Toast Container -->
    <div id="toast-container" class="toast-container" aria-live="polite"></div>

    <header class="uk-background-default" uk-sticky>
        <div class="uk-container uk-container-expand">
            <nav class="uk-navbar" uk-navbar>
                <div class="uk-navbar-left">
                    <a href="<?= BASE_URL ?>" class="uk-navbar-item uk-logo">
                        <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle" style="width: 32px; height: 32px; background: #7c3aed; color: white; font-size: 12px;">
                            <span uk-icon="icon: star; ratio: 0.7"></span>
                        </span>
                        <span class="uk-margin-small-left uk-text-bold"><?= APP_NAME ?></span>
                        <span class="uk-label uk-label-warning uk-margin-small-left">System Administrator</span>
                    </a>
                </div>
                <div class="uk-navbar-center">
                    <span class="uk-text-success"><span uk-icon="icon: check; ratio: 0.7"></span> System Online</span>
                </div>
                <div class="uk-navbar-right">
                    <!-- Notifications Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link">
                            <span uk-icon="icon: bell"></span>
                            <span class="uk-badge uk-position-top-right" style="font-size: 10px; padding: 2px 5px;">5</span>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <div class="uk-dropdown-nav">
                                <div class="uk-nav-header uk-flex uk-flex-between uk-flex-middle">
                                    <span>System Alerts</span>
                                    <a href="#" class="uk-text-small">Mark all read</a>
                                </div>
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li><a href="#"><div class="uk-text-small uk-text-bold uk-text-warning">CDN failover triggered</div><div class="uk-text-meta">AWS S3 → Cloudflare R2</div><div class="uk-text-meta">5 minutes ago</div></a></li>
                                    <li><a href="#"><div class="uk-text-small uk-text-bold">New client onboarded</div><div class="uk-text-meta">UniPath Canada - Trial</div><div class="uk-text-meta">1 hour ago</div></a></li>
                                    <li><a href="#"><div class="uk-text-small uk-text-bold uk-text-danger">Security alert</div><div class="uk-text-meta">Multiple failed logins detected</div><div class="uk-text-meta">2 hours ago</div></a></li>
                                    <li><a href="#"><div class="uk-text-small uk-text-bold">Database backup completed</div><div class="uk-text-meta">All clients - 45GB</div><div class="uk-text-meta">4 hours ago</div></a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li class="uk-text-center"><a href="<?= BASE_URL ?>/audit.php" hx-get="<?= BASE_URL ?>/pages/audit.php" hx-target="#main-content" hx-swap="innerHTML" class="uk-text-small">View all alerts</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Settings Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link"><span uk-icon="icon: cog"></span></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">System Settings</li>
                                <li><a href="<?= BASE_URL ?>/system.php" hx-get="<?= BASE_URL ?>/pages/system.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: server; ratio: 0.8" class="uk-margin-small-right"></span> Infrastructure</a></li>
                                <li><a href="<?= BASE_URL ?>/data.php" hx-get="<?= BASE_URL ?>/pages/data.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: database; ratio: 0.8" class="uk-margin-small-right"></span> Database</a></li>
                                <li><a href="<?= BASE_URL ?>/cdn.php" hx-get="<?= BASE_URL ?>/pages/cdn.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: cloud-upload; ratio: 0.8" class="uk-margin-small-right"></span> CDN Config</a></li>
                                <li><a href="<?= BASE_URL ?>/security.php" hx-get="<?= BASE_URL ?>/pages/security.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: lock; ratio: 0.8" class="uk-margin-small-right"></span> Security</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/system.php" hx-get="<?= BASE_URL ?>/pages/system.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: code; ratio: 0.8" class="uk-margin-small-right"></span> API Keys</a></li>
                                <li><a href="<?= BASE_URL ?>/system.php" hx-get="<?= BASE_URL ?>/pages/system.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: git-branch; ratio: 0.8" class="uk-margin-small-right"></span> Webhooks</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" onclick="toggleDarkMode(); return false;"><span uk-icon="icon: paint-bucket; ratio: 0.8" class="uk-margin-small-right"></span> <span id="theme-toggle-text">Dark Mode</span></a></li>
                                <li class="uk-parent">
                                    <a href="#"><span uk-icon="icon: palette; ratio: 0.8" class="uk-margin-small-right"></span> Theme Skin <span uk-nav-parent-icon></span></a>
                                    <ul class="uk-nav-sub">
                                        <li><a href="#" onclick="switchThemeSkin(''); return false;"><span id="skin-default-check" class="uk-margin-small-right">✓</span> Default</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('oceanic'); return false;"><span id="skin-oceanic-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Oceanic</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('amethyst'); return false;"><span id="skin-amethyst-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Amethyst</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('violet'); return false;"><span id="skin-violet-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Violet</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('matrix'); return false;"><span id="skin-matrix-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Matrix</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('noir'); return false;"><span id="skin-noir-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Noir</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!-- Profile Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-flex uk-flex-middle">
                            <?= get_avatar($GLOBALS['current_user']['name'], 36) ?>
                            <div class="uk-margin-small-left uk-visible@m">
                                <div class="uk-text-bold uk-text-small"><?= e($GLOBALS['current_user']['name']) ?></div>
                                <div class="uk-text-meta uk-text-small"><?= e($GLOBALS['current_user']['role']) ?></div>
                            </div>
                            <span uk-icon="icon: triangle-down; ratio: 0.7" class="uk-margin-small-left"></span>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Account</li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: user; ratio: 0.8" class="uk-margin-small-right"></span> My Profile</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: lock; ratio: 0.8" class="uk-margin-small-right"></span> Change Password</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: phone; ratio: 0.8" class="uk-margin-small-right"></span> Two-Factor Auth</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/audit.php" hx-get="<?= BASE_URL ?>/pages/audit.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: list; ratio: 0.8" class="uk-margin-small-right"></span> Audit Log</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: laptop; ratio: 0.8" class="uk-margin-small-right"></span> Active Sessions</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="/auth/login.php" class="uk-text-danger"><span uk-icon="icon: sign-out; ratio: 0.8" class="uk-margin-small-right"></span> Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <hr class="uk-margin-remove">
    </header>

    <div class="uk-container uk-container-large uk-margin-medium-top uk-margin-large-bottom">
        <div class="uk-margin-medium-bottom">
            <h1 class="uk-heading-small uk-margin-remove-bottom"><?= e($page_title ?? 'System Command Center') ?></h1>
            <p class="uk-text-muted uk-margin-remove-top"><?= e($page_description ?? 'Complete oversight and control of the GlobalEd Pathways ecosystem.') ?></p>
        </div>

        <ul class="uk-tab uk-margin-medium-bottom" uk-tab>
            <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
                <li class="<?= ($active_tab ?? 'overview') === $key ? 'uk-active' : '' ?>">
                    <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                       hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                        <?= e($item['label']) ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>

        <div id="main-content"><?php if (isset($content)) echo $content; ?></div>
    </div>

    <div id="modal-container"></div>

    <!-- Back to Top Button -->
    <button class="back-to-top" id="back-to-top" aria-label="Back to top" onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
        <span uk-icon="icon: chevron-up"></span>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>

    <!-- Chart & Map Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.0/dist/apexcharts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"></script>

    <script>
        // Toast Notification System
        function showToast(message, type = 'info', duration = 4000) {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.innerHTML = `<span>${message}</span>`;
            container.appendChild(toast);
            setTimeout(() => {
                toast.classList.add('hiding');
                setTimeout(() => toast.remove(), 300);
            }, duration);
        }

        // Dark Mode Toggle
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
            document.getElementById('theme-toggle-text').textContent = isDark ? 'Dark Mode' : 'Light Mode';
        }

        // Theme Skin Switcher (for testing - no persistence)
        function switchThemeSkin(skinName) {
            const html = document.documentElement;
            if (skinName) {
                html.setAttribute('data-skin', skinName);
            } else {
                html.removeAttribute('data-skin');
            }
            // Update checkmarks
            const defaultCheck = document.getElementById('skin-default-check');
            const oceanicCheck = document.getElementById('skin-oceanic-check');
            const amethystCheck = document.getElementById('skin-amethyst-check');
            const violetCheck = document.getElementById('skin-violet-check');
            const matrixCheck = document.getElementById('skin-matrix-check');
            const noirCheck = document.getElementById('skin-noir-check');
            if (defaultCheck) defaultCheck.style.visibility = skinName === '' ? 'visible' : 'hidden';
            if (oceanicCheck) oceanicCheck.style.visibility = skinName === 'oceanic' ? 'visible' : 'hidden';
            if (amethystCheck) amethystCheck.style.visibility = skinName === 'amethyst' ? 'visible' : 'hidden';
            if (violetCheck) violetCheck.style.visibility = skinName === 'violet' ? 'visible' : 'hidden';
            if (matrixCheck) matrixCheck.style.visibility = skinName === 'matrix' ? 'visible' : 'hidden';
            if (noirCheck) noirCheck.style.visibility = skinName === 'noir' ? 'visible' : 'hidden';
        }

        // Initialize theme from localStorage
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
            const toggleText = document.getElementById('theme-toggle-text');
            if (toggleText) toggleText.textContent = savedTheme === 'dark' ? 'Light Mode' : 'Dark Mode';
        })();

        // Back to Top Button
        window.addEventListener('scroll', function() {
            const btn = document.getElementById('back-to-top');
            if (window.scrollY > 300) btn.classList.add('visible');
            else btn.classList.remove('visible');
        });

        // HTMX Loading Indicator
        document.body.addEventListener('htmx:beforeRequest', function() {
            document.getElementById('page-loader').style.display = 'block';
        });
        document.body.addEventListener('htmx:afterRequest', function() {
            document.getElementById('page-loader').style.display = 'none';
        });

        // Keyboard Shortcuts
        document.addEventListener('keydown', function(e) {
            if ((e.metaKey || e.ctrlKey) && e.key === 'k') {
                e.preventDefault();
                const searchInput = document.querySelector('input[type="search"], input[placeholder*="Search"]');
                if (searchInput) searchInput.focus();
            }
            if (e.key === 'Escape') {
                const modal = document.querySelector('.uk-modal.uk-open');
                if (modal) UIkit.modal(modal).hide();
            }
            if (e.key === '?' && !e.target.matches('input, textarea, select')) {
                showToast('Shortcuts: Ctrl+K = Search, Esc = Close modal', 'info', 5000);
            }
        });

        // Autosave for textareas
        document.querySelectorAll('textarea[data-autosave]').forEach(textarea => {
            const key = 'autosave_' + (textarea.id || textarea.name);
            const saved = localStorage.getItem(key);
            if (saved) textarea.value = saved;
            textarea.addEventListener('input', () => {
                localStorage.setItem(key, textarea.value);
            });
        });

        // Form submission feedback
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                const btn = form.querySelector('button[type="submit"]');
                if (btn) {
                    btn.disabled = true;
                    btn.innerHTML = '<span uk-spinner="ratio: 0.5"></span> Processing...';
                }
            });
        });

        // Add ARIA labels to icon-only buttons
        document.querySelectorAll('a[uk-icon], button[uk-icon]').forEach(el => {
            if (!el.getAttribute('aria-label') && !el.textContent.trim()) {
                const icon = el.getAttribute('uk-icon');
                if (icon) {
                    const match = icon.match(/icon:\s*([^;]+)/);
                    if (match) el.setAttribute('aria-label', match[1].trim());
                }
            }
        });
    </script>
</body>
</html>
