<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$stats = [
    ['icon' => 'trending-up', 'value' => '23.5%', 'label' => 'Growth Rate', 'trend' => 5, 'color' => 'success'],
    ['icon' => 'users', 'value' => '89.2%', 'label' => 'User Retention', 'trend' => 3, 'color' => 'primary'],
    ['icon' => 'check', 'value' => '94.7%', 'label' => 'Success Rate', 'trend' => 2, 'color' => 'warning'],
    ['icon' => 'clock', 'value' => '4.2 days', 'label' => 'Avg Process Time', 'trend' => -8, 'color' => 'cyan']
];

$monthly = [
    ['month' => 'Jul', 'users' => 8234, 'revenue' => '$1.8M'],
    ['month' => 'Aug', 'users' => 8987, 'revenue' => '$2.0M'],
    ['month' => 'Sep', 'users' => 9654, 'revenue' => '$2.2M'],
    ['month' => 'Oct', 'users' => 10432, 'revenue' => '$2.4M'],
    ['month' => 'Nov', 'users' => 11234, 'revenue' => '$2.6M'],
    ['month' => 'Dec', 'users' => 12847, 'revenue' => '$2.9M']
];

render_stat_cards($stats);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Growth Trends</h4>
            <div id="growth-chart" style="height: 300px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Key Metrics</h4>
            <div class="uk-grid-small uk-child-width-1-2" uk-grid>
                <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center">
                    <div class="uk-text-large uk-text-bold">$234</div>
                    <div class="uk-text-muted uk-text-small">Avg Revenue/User</div>
                </div>
                <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center">
                    <div class="uk-text-large uk-text-bold">3.2</div>
                    <div class="uk-text-muted uk-text-small">Apps/Student</div>
                </div>
                <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center">
                    <div class="uk-text-large uk-text-bold">87%</div>
                    <div class="uk-text-muted uk-text-small">Completion Rate</div>
                </div>
                <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center">
                    <div class="uk-text-large uk-text-bold">4.8/5</div>
                    <div class="uk-text-muted uk-text-small">Satisfaction</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
(function() {
    // ApexCharts - Growth Trends Area Chart
    var el = document.getElementById('growth-chart');
    if (el && typeof ApexCharts !== 'undefined') {
        var growthOptions = {
            series: [{
                name: 'Users',
                data: [8234, 8987, 9654, 10432, 11234, 12847]
            }, {
                name: 'Revenue ($K)',
                data: [1800, 2000, 2200, 2400, 2600, 2900]
            }],
            chart: {
                type: 'area',
                height: 300,
                toolbar: { show: false },
                background: 'transparent'
            },
            colors: ['#3b82f6', '#10b981'],
            dataLabels: { enabled: false },
            stroke: { curve: 'smooth', width: 2 },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.4,
                    opacityTo: 0.1
                }
            },
            xaxis: {
                categories: ['Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                labels: { style: { colors: '#64748b' } }
            },
            yaxis: {
                labels: { style: { colors: '#64748b' } }
            },
            legend: { position: 'top' },
            tooltip: { theme: 'dark' }
        };
        new ApexCharts(el, growthOptions).render();
    }
})();
</script>
