<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$audit_entries = [
    ['user' => 'System', 'action' => 'CDN failover triggered', 'resource' => 'AWS S3 → Cloudflare R2', 'ip' => 'System', 'time' => '2024-01-30 16:45:32', 'level' => 'warning'],
    ['user' => 'admin@globaledpathways.com', 'action' => 'User created', 'resource' => 'john.doe@email.com', 'ip' => '192.168.1.100', 'time' => '2024-01-30 15:30:00', 'level' => 'info'],
    ['user' => 'System', 'action' => 'Backup completed', 'resource' => 'All databases - 45GB', 'ip' => 'System', 'time' => '2024-01-30 02:00:00', 'level' => 'success'],
    ['user' => 'unknown', 'action' => 'Failed login attempt', 'resource' => 'admin@company.com', 'ip' => '45.67.89.123', 'time' => '2024-01-29 23:45:00', 'level' => 'danger'],
    ['user' => 'admin@globaledpathways.com', 'action' => 'Settings modified', 'resource' => 'Email configuration', 'ip' => '192.168.1.100', 'time' => '2024-01-29 14:20:00', 'level' => 'info'],
    ['user' => 'System', 'action' => 'New client onboarded', 'resource' => 'UniPath Canada', 'ip' => 'System', 'time' => '2024-01-29 10:00:00', 'level' => 'success'],
];

$level_colors = ['info' => 'primary', 'success' => 'success', 'warning' => 'warning', 'danger' => 'danger'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">Audit Log</h3>
    <div class="uk-flex uk-flex-wrap uk-flex-middle">
        <select class="uk-select uk-form-small uk-margin-small-right uk-margin-small-bottom" style="width: 130px;">
            <option>All Events</option>
            <option>User Actions</option>
            <option>System Events</option>
            <option>Security Events</option>
        </select>
        <input type="date" class="uk-input uk-form-small uk-margin-small-right uk-margin-small-bottom" style="width: 130px;">
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-bottom">
            <span uk-icon="icon: download; ratio: 0.8"></span> Export
        </button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <div class="table-responsive">
    <table class="uk-table uk-table-divider uk-table-hover uk-table-small">
        <thead>
            <tr>
                <th>Time</th>
                <th>User</th>
                <th>Action</th>
                <th>Resource</th>
                <th>IP Address</th>
                <th>Level</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($audit_entries as $entry): ?>
            <tr>
                <td class="uk-text-small uk-text-muted"><?= e($entry['time']) ?></td>
                <td class="uk-text-small"><?= e($entry['user']) ?></td>
                <td class="uk-text-bold uk-text-small"><?= e($entry['action']) ?></td>
                <td class="uk-text-small"><?= e($entry['resource']) ?></td>
                <td><code class="uk-text-small"><?= e($entry['ip']) ?></code></td>
                <td><span class="uk-label uk-label-<?= $level_colors[$entry['level']] ?>"><?= e($entry['level']) ?></span></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>

    <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-top mobile-stack">
        <div class="uk-text-small uk-text-muted">Showing 1-6 of 1,234 entries</div>
        <ul class="uk-pagination uk-margin-remove">
            <li><a href="#"><span uk-pagination-previous></span></a></li>
            <li class="uk-active"><a href="#">1</a></li>
            <li><a href="#">2</a></li>
            <li><a href="#">3</a></li>
            <li class="uk-disabled"><span>...</span></li>
            <li><a href="#">206</a></li>
            <li><a href="#"><span uk-pagination-next></span></a></li>
        </ul>
    </div>
</div>
