<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$logs = [
    ['time' => '2024-01-30 16:45:32', 'user' => 'admin@gep.com', 'action' => 'User Login', 'details' => 'Successful login from 192.168.1.100', 'level' => 'info'],
    ['time' => '2024-01-30 16:30:15', 'user' => 'system', 'action' => 'Backup Created', 'details' => 'Automatic daily backup completed', 'level' => 'success'],
    ['time' => '2024-01-30 15:23:45', 'user' => 'sarah.j@gep.com', 'action' => 'User Updated', 'details' => 'Modified user profile for John Doe', 'level' => 'info'],
    ['time' => '2024-01-30 14:15:00', 'user' => 'system', 'action' => 'Alert Triggered', 'details' => 'High CPU usage detected', 'level' => 'warning'],
    ['time' => '2024-01-30 12:00:00', 'user' => 'a.supreme@gep.com', 'action' => 'Settings Changed', 'details' => 'Updated email notification settings', 'level' => 'info'],
    ['time' => '2024-01-30 10:30:22', 'user' => 'system', 'action' => 'Failed Login', 'details' => 'Multiple failed attempts from 45.67.89.123', 'level' => 'danger']
];

$level_colors = ['info' => 'primary', 'success' => 'success', 'warning' => 'warning', 'danger' => 'danger'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">Audit Logs</h3>
    <div>
        <select class="uk-select uk-form-small uk-margin-small-right" style="width: 120px;">
            <option>All Levels</option>
            <option>Info</option>
            <option>Success</option>
            <option>Warning</option>
            <option>Error</option>
        </select>
        <input class="uk-input uk-form-small uk-margin-small-right" type="date" style="width: 150px;">
        <button class="uk-button uk-button-default uk-button-small">Export Logs</button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-small">
        <thead>
            <tr><th>Timestamp</th><th>User</th><th>Action</th><th>Details</th><th>Level</th></tr>
        </thead>
        <tbody>
            <?php foreach ($logs as $log): ?>
            <tr>
                <td class="uk-text-small"><code><?= e($log['time']) ?></code></td>
                <td class="uk-text-small"><?= e($log['user']) ?></td>
                <td class="uk-text-bold uk-text-small"><?= e($log['action']) ?></td>
                <td class="uk-text-small uk-text-muted"><?= e($log['details']) ?></td>
                <td><span class="uk-label uk-label-<?= $level_colors[$log['level']] ?>"><?= e($log['level']) ?></span></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
