<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$cdn_providers = [
    ['id' => 1, 'name' => 'AWS S3', 'region' => 'us-east-1', 'status' => 'active', 'encryption' => 'AES-256', 'compliance' => ['GDPR', 'HIPAA', 'SOC2'], 'storage_used' => '2.4 TB', 'bandwidth' => '890 GB/mo'],
    ['id' => 2, 'name' => 'Cloudflare R2', 'region' => 'eu-west-1', 'status' => 'active', 'encryption' => 'AES-256', 'compliance' => ['GDPR', 'SOC2'], 'storage_used' => '1.8 TB', 'bandwidth' => '560 GB/mo'],
    ['id' => 3, 'name' => 'Google Cloud Storage', 'region' => 'asia-east1', 'status' => 'standby', 'encryption' => 'AES-256', 'compliance' => ['GDPR', 'ISO27001'], 'storage_used' => '450 GB', 'bandwidth' => '120 GB/mo'],
    ['id' => 4, 'name' => 'Azure Blob Storage', 'region' => 'eu-north-1', 'status' => 'inactive', 'encryption' => 'AES-256', 'compliance' => ['GDPR', 'HIPAA'], 'storage_used' => '0 GB', 'bandwidth' => '0 GB/mo']
];

$privacy_laws = [
    ['region' => 'European Union', 'law' => 'GDPR', 'status' => 'compliant', 'last_audit' => '2024-01-15'],
    ['region' => 'California, USA', 'law' => 'CCPA', 'status' => 'compliant', 'last_audit' => '2024-01-10'],
    ['region' => 'Brazil', 'law' => 'LGPD', 'status' => 'compliant', 'last_audit' => '2024-01-20'],
    ['region' => 'Canada', 'law' => 'PIPEDA', 'status' => 'review', 'last_audit' => '2023-12-01'],
    ['region' => 'Australia', 'law' => 'Privacy Act', 'status' => 'compliant', 'last_audit' => '2024-01-05']
];

$sensitive_docs = [
    ['type' => 'Passport', 'count' => 4567, 'encryption' => 'AES-256-GCM', 'cdn' => 'AWS S3', 'retention' => '7 years'],
    ['type' => 'ID Documents', 'count' => 3892, 'encryption' => 'AES-256-GCM', 'cdn' => 'AWS S3', 'retention' => '7 years'],
    ['type' => 'Financial Records', 'count' => 12456, 'encryption' => 'AES-256-GCM', 'cdn' => 'Cloudflare R2', 'retention' => '10 years'],
    ['type' => 'Academic Transcripts', 'count' => 8934, 'encryption' => 'AES-256', 'cdn' => 'AWS S3', 'retention' => '15 years'],
    ['type' => 'Medical Records', 'count' => 234, 'encryption' => 'AES-256-GCM', 'cdn' => 'AWS S3 (HIPAA)', 'retention' => '10 years']
];

$status_colors = ['active' => 'success', 'standby' => 'warning', 'inactive' => 'danger', 'compliant' => 'success', 'review' => 'warning'];

$stats = [
    ['icon' => 'cloud-upload', 'value' => '4.7 TB', 'label' => 'Total Storage', 'color' => 'primary'],
    ['icon' => 'bolt', 'value' => '1.57 TB', 'label' => 'Monthly Bandwidth', 'color' => 'warning'],
    ['icon' => 'lock', 'value' => '30,083', 'label' => 'Encrypted Files', 'color' => 'success'],
    ['icon' => 'check', 'value' => '4/5', 'label' => 'Compliant Regions', 'color' => 'secondary']
];

render_stat_cards($stats, 4);
?>

<ul class="uk-subnav uk-subnav-pill uk-margin-top" uk-switcher="animation: uk-animation-fade">
    <li class="uk-active"><a href="#">CDN Providers</a></li>
    <li><a href="#">Privacy Compliance</a></li>
    <li><a href="#">Sensitive Documents</a></li>
    <li><a href="#">Encryption Settings</a></li>
</ul>

<ul class="uk-switcher uk-margin">
    <!-- CDN Providers Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">CDN Providers</h4>
            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-cdn-modal">
                <span uk-icon="icon: plus; ratio: 0.8"></span> Add Provider
            </button>
        </div>

        <div class="uk-grid-small uk-child-width-1-2@m" uk-grid>
            <?php foreach ($cdn_providers as $cdn): ?>
            <div>
                <div class="uk-card uk-card-default uk-card-body">
                    <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
                        <h5 class="uk-margin-remove"><?= e($cdn['name']) ?></h5>
                        <span class="uk-label uk-label-<?= $status_colors[$cdn['status']] ?>"><?= e($cdn['status']) ?></span>
                    </div>
                    <dl class="uk-description-list uk-text-small">
                        <dt>Region</dt>
                        <dd><?= e($cdn['region']) ?></dd>
                        <dt>Encryption</dt>
                        <dd><?= e($cdn['encryption']) ?></dd>
                        <dt>Compliance</dt>
                        <dd><?= implode(', ', $cdn['compliance']) ?></dd>
                        <dt>Storage Used</dt>
                        <dd><?= e($cdn['storage_used']) ?></dd>
                        <dt>Bandwidth</dt>
                        <dd><?= e($cdn['bandwidth']) ?></dd>
                    </dl>
                    <div class="uk-margin-top">
                        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">Configure</button>
                        <button class="uk-button uk-button-default uk-button-small">Test Connection</button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </li>

    <!-- Privacy Compliance Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">Privacy Law Compliance</h4>
            <button class="uk-button uk-button-primary uk-button-small">
                <span uk-icon="icon: download; ratio: 0.8"></span> Export Report
            </button>
        </div>

        <div class="uk-card uk-card-default uk-card-body">
            <table class="uk-table uk-table-divider uk-table-hover">
                <thead>
                    <tr><th>Region</th><th>Law/Regulation</th><th>Status</th><th>Last Audit</th><th>Actions</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($privacy_laws as $law): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($law['region']) ?></td>
                        <td><?= e($law['law']) ?></td>
                        <td><span class="uk-label uk-label-<?= $status_colors[$law['status']] ?>"><?= e($law['status']) ?></span></td>
                        <td><?= e($law['last_audit']) ?></td>
                        <td>
                            <a href="#" uk-icon="icon: file-text; ratio: 0.8" uk-tooltip="View Report"></a>
                            <a href="#" uk-icon="icon: refresh; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Run Audit"></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5>Data Processing Agreements</h5>
            <ul class="uk-list uk-list-divider">
                <li class="uk-flex uk-flex-between">
                    <span>AWS DPA</span>
                    <span class="uk-text-success">Signed - Valid until 2025</span>
                </li>
                <li class="uk-flex uk-flex-between">
                    <span>Cloudflare DPA</span>
                    <span class="uk-text-success">Signed - Valid until 2025</span>
                </li>
                <li class="uk-flex uk-flex-between">
                    <span>Google Cloud DPA</span>
                    <span class="uk-text-warning">Renewal Required</span>
                </li>
            </ul>
        </div>
    </li>

    <!-- Sensitive Documents Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
            <h4 class="uk-margin-remove">Sensitive Document Management</h4>
            <button class="uk-button uk-button-default uk-button-small">
                <span uk-icon="icon: cog; ratio: 0.8"></span> Encryption Settings
            </button>
        </div>

        <div class="uk-card uk-card-default uk-card-body">
            <table class="uk-table uk-table-divider uk-table-hover">
                <thead>
                    <tr><th>Document Type</th><th>Count</th><th>Encryption</th><th>CDN Location</th><th>Retention</th><th></th></tr>
                </thead>
                <tbody>
                    <?php foreach ($sensitive_docs as $doc): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($doc['type']) ?></td>
                        <td><?= number_format($doc['count']) ?></td>
                        <td><code><?= e($doc['encryption']) ?></code></td>
                        <td><?= e($doc['cdn']) ?></td>
                        <td><?= e($doc['retention']) ?></td>
                        <td>
                            <a href="#" uk-icon="icon: cog; ratio: 0.8" uk-tooltip="Configure"></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="uk-alert-warning uk-margin-top" uk-alert>
            <p><strong>Encryption Notice:</strong> All passport and ID documents are encrypted with AES-256-GCM and stored with additional access logging for compliance.</p>
        </div>
    </li>

    <!-- Encryption Settings Tab -->
    <li>
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Encryption at Rest</h4>
                    <form class="uk-form-stacked">
                        <div class="uk-margin">
                            <label class="uk-form-label">Default Algorithm</label>
                            <select class="uk-select">
                                <option selected>AES-256-GCM (Recommended)</option>
                                <option>AES-256-CBC</option>
                                <option>ChaCha20-Poly1305</option>
                            </select>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Key Management</label>
                            <select class="uk-select">
                                <option selected>AWS KMS</option>
                                <option>HashiCorp Vault</option>
                                <option>Azure Key Vault</option>
                            </select>
                        </div>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Enable automatic key rotation</label>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Rotation Period</label>
                            <select class="uk-select">
                                <option>30 days</option>
                                <option selected>90 days</option>
                                <option>180 days</option>
                                <option>365 days</option>
                            </select>
                        </div>
                    </form>
                </div>
            </div>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Encryption in Transit</h4>
                    <form class="uk-form-stacked">
                        <div class="uk-margin">
                            <label class="uk-form-label">TLS Version</label>
                            <select class="uk-select">
                                <option selected>TLS 1.3 (Recommended)</option>
                                <option>TLS 1.2</option>
                            </select>
                        </div>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Enforce HTTPS</label>
                        </div>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Enable HSTS</label>
                        </div>
                        <div class="uk-margin">
                            <label><input class="uk-checkbox" type="checkbox" checked> Certificate pinning</label>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </li>
</ul>

<!-- Add CDN Modal -->
<div id="add-cdn-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add CDN Provider</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Provider</label>
                    <select class="uk-select" required>
                        <option value="">Select provider...</option>
                        <option>AWS S3</option>
                        <option>Cloudflare R2</option>
                        <option>Google Cloud Storage</option>
                        <option>Azure Blob Storage</option>
                        <option>DigitalOcean Spaces</option>
                        <option>Backblaze B2</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Region</label>
                    <select class="uk-select" required>
                        <option value="">Select region...</option>
                        <option>US East</option>
                        <option>US West</option>
                        <option>EU West</option>
                        <option>EU North</option>
                        <option>Asia Pacific</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Access Key</label>
                    <input class="uk-input" type="text" placeholder="Access key ID">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Secret Key</label>
                    <input class="uk-input" type="password" placeholder="Secret access key">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Bucket Name</label>
                    <input class="uk-input" type="text" placeholder="my-bucket-name">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add Provider</button>
        </div>
    </div>
</div>
