<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$clients = [
    [
        'id' => 1, 'name' => 'GlobalEd Pathways', 'type' => 'Enterprise', 'status' => 'active',
        'users' => 2456, 'applications' => 890, 'storage' => '2.4 TB', 'cdn' => 'multi',
        'cdns' => ['AWS S3', 'Cloudflare R2'], 'mrr' => '$45,000', 'since' => '2022-01-15'
    ],
    [
        'id' => 2, 'name' => 'EduConnect Asia', 'type' => 'Business', 'status' => 'active',
        'users' => 892, 'applications' => 234, 'storage' => '890 GB', 'cdn' => 'single',
        'cdns' => ['AWS S3'], 'mrr' => '$12,500', 'since' => '2023-03-20'
    ],
    [
        'id' => 3, 'name' => 'StudyAbroad UK', 'type' => 'Business', 'status' => 'active',
        'users' => 567, 'applications' => 156, 'storage' => '450 GB', 'cdn' => 'single',
        'cdns' => ['Cloudflare R2'], 'mrr' => '$8,900', 'since' => '2023-06-10'
    ],
    [
        'id' => 4, 'name' => 'UniPath Canada', 'type' => 'Starter', 'status' => 'trial',
        'users' => 45, 'applications' => 12, 'storage' => '15 GB', 'cdn' => 'single',
        'cdns' => ['AWS S3'], 'mrr' => '$0', 'since' => '2024-01-25'
    ]
];

$stats = [
    ['icon' => 'users', 'value' => '4', 'label' => 'Total Clients', 'color' => 'primary'],
    ['icon' => 'user', 'value' => '3,960', 'label' => 'Total Users', 'color' => 'secondary'],
    ['icon' => 'credit-card', 'value' => '$66,400', 'label' => 'Monthly Revenue', 'color' => 'success'],
    ['icon' => 'cloud-upload', 'value' => '3.8 TB', 'label' => 'Total Storage', 'color' => 'warning']
];

$type_colors = ['Enterprise' => 'success', 'Business' => 'primary', 'Starter' => 'secondary'];
$status_colors = ['active' => 'success', 'trial' => 'warning', 'suspended' => 'danger'];

render_stat_cards($stats, 4);
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">Client Management</h3>
    <div class="uk-flex uk-flex-middle mobile-stack">
        <input class="uk-input uk-form-small uk-margin-small-right mobile-full mobile-mb" type="search" placeholder="Search clients..." style="width: 200px;"
               _="on keyup
                  set query to my value.toLowerCase()
                  for row in #clients-table tbody tr
                    if row.textContent.toLowerCase().indexOf(query) >= 0
                      remove .uk-hidden from row
                    else
                      add .uk-hidden to row
                    end
                  end">
        <button class="uk-button uk-button-primary uk-button-small mobile-full" uk-toggle="target: #add-client-modal">
            <span uk-icon="icon: plus; ratio: 0.8"></span> Add Client
        </button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <div class="table-responsive">
    <table id="clients-table" class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr><th>Client</th><th>Type</th><th>Users</th><th>Storage</th><th>CDN</th><th>MRR</th><th>Status</th><th></th></tr>
        </thead>
        <tbody>
            <?php foreach ($clients as $client): ?>
            <tr>
                <td>
                    <div class="uk-text-bold"><?= e($client['name']) ?></div>
                    <div class="uk-text-small uk-text-muted">Since <?= e($client['since']) ?></div>
                </td>
                <td><span class="uk-label uk-label-<?= $type_colors[$client['type']] ?>"><?= e($client['type']) ?></span></td>
                <td><?= number_format($client['users']) ?></td>
                <td><?= e($client['storage']) ?></td>
                <td>
                    <span class="uk-label uk-label-<?= $client['cdn'] === 'multi' ? 'success' : 'secondary' ?>">
                        <?= $client['cdn'] === 'multi' ? 'Multi-CDN' : 'Single' ?>
                    </span>
                </td>
                <td class="uk-text-bold"><?= e($client['mrr']) ?></td>
                <td><span class="uk-label uk-label-<?= $status_colors[$client['status']] ?>"><?= e($client['status']) ?></span></td>
                <td>
                    <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li class="uk-nav-header">Actions</li>
                            <li><a href="#" _="on click set #client-detail-name.innerHTML to '<?= e($client['name']) ?>' then call UIkit.modal('#client-detail-modal').show()"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> View Details</a></li>
                            <li><a href="#" uk-toggle="target: #client-settings-modal"><span uk-icon="icon: cog; ratio: 0.8" class="uk-margin-small-right"></span> Settings</a></li>
                            <li><a href="#" uk-toggle="target: #manage-cdn-modal"><span uk-icon="icon: cloud-upload; ratio: 0.8" class="uk-margin-small-right"></span> Manage CDN</a></li>
                            <li><a href="#" uk-toggle="target: #view-invoices-modal"><span uk-icon="icon: credit-card; ratio: 0.8" class="uk-margin-small-right"></span> View Invoices</a></li>
                            <li><a href="#" uk-toggle="target: #update-plan-modal"><span uk-icon="icon: tag; ratio: 0.8" class="uk-margin-small-right"></span> Update Plan</a></li>
                            <li><a href="#" uk-toggle="target: #contact-client-modal"><span uk-icon="icon: mail; ratio: 0.8" class="uk-margin-small-right"></span> Contact Client</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" class="uk-text-warning" uk-toggle="target: #suspend-client-modal"><span uk-icon="icon: ban; ratio: 0.8" class="uk-margin-small-right"></span> <?= $client['status'] === 'active' ? 'Suspend' : 'Activate' ?> Client</a></li>
                            <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-client-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete Client</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>

<!-- Client Detail Modal -->
<div id="client-detail-modal" class="uk-modal-full" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-full uk-close-large" type="button" uk-close></button>
        <div class="uk-padding-large">
            <h2 id="client-detail-name">GlobalEd Pathways</h2>

            <ul class="uk-subnav uk-subnav-pill" uk-switcher>
                <li class="uk-active"><a href="#">Overview</a></li>
                <li><a href="#">CDN Settings</a></li>
                <li><a href="#">Statistics</a></li>
                <li><a href="#">Billing</a></li>
            </ul>

            <ul class="uk-switcher uk-margin">
                <!-- Overview -->
                <li>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2@m">
                            <div class="uk-card uk-card-default uk-card-body">
                                <h4>Client Information</h4>
                                <dl class="uk-description-list">
                                    <dt>Client ID</dt><dd>CLT-001</dd>
                                    <dt>Type</dt><dd>Enterprise</dd>
                                    <dt>Status</dt><dd><span class="uk-label uk-label-success">Active</span></dd>
                                    <dt>Primary Contact</dt><dd>admin@globaledpathways.com</dd>
                                    <dt>Member Since</dt><dd>January 15, 2022</dd>
                                </dl>
                            </div>
                        </div>
                        <div class="uk-width-1-2@m">
                            <div class="uk-card uk-card-default uk-card-body">
                                <h4>Quick Stats</h4>
                                <div class="uk-grid-small uk-child-width-1-2" uk-grid>
                                    <div><div class="uk-text-meta">Users</div><div class="uk-text-large uk-text-bold">2,456</div></div>
                                    <div><div class="uk-text-meta">Applications</div><div class="uk-text-large uk-text-bold">890</div></div>
                                    <div><div class="uk-text-meta">Storage</div><div class="uk-text-large uk-text-bold">2.4 TB</div></div>
                                    <div><div class="uk-text-meta">Bandwidth</div><div class="uk-text-large uk-text-bold">1.2 TB/mo</div></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>

                <!-- CDN Settings -->
                <li>
                    <div class="uk-card uk-card-default uk-card-body">
                        <h4>CDN Configuration</h4>
                        <div class="uk-margin">
                            <label class="uk-form-label">CDN Mode</label>
                            <div class="uk-margin-small">
                                <label><input class="uk-radio" type="radio" name="cdn-mode"> Single CDN</label>
                            </div>
                            <div class="uk-margin-small">
                                <label><input class="uk-radio" type="radio" name="cdn-mode" checked> Multi-CDN (Load Balanced)</label>
                            </div>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Active CDN Providers</label>
                            <div class="uk-margin-small">
                                <label><input class="uk-checkbox" type="checkbox" checked> AWS S3 (Primary)</label>
                            </div>
                            <div class="uk-margin-small">
                                <label><input class="uk-checkbox" type="checkbox" checked> Cloudflare R2 (Secondary)</label>
                            </div>
                            <div class="uk-margin-small">
                                <label><input class="uk-checkbox" type="checkbox"> Google Cloud Storage</label>
                            </div>
                        </div>
                        <div class="uk-margin">
                            <label class="uk-form-label">Failover Strategy</label>
                            <select class="uk-select">
                                <option>Automatic (Latency-based)</option>
                                <option>Geographic</option>
                                <option>Round-robin</option>
                            </select>
                        </div>
                        <button class="uk-button uk-button-primary uk-margin-top">Save CDN Settings</button>
                    </div>
                </li>

                <!-- Statistics -->
                <li>
                    <div class="uk-grid-small" uk-grid>
                        <div class="uk-width-1-2@m">
                            <div class="uk-card uk-card-default uk-card-body">
                                <h4>Usage Trends (Last 30 Days)</h4>
                                <div class="uk-margin">
                                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                        <span>New Users</span><span class="uk-text-success">+124</span>
                                    </div>
                                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                        <span>Applications Submitted</span><span class="uk-text-success">+89</span>
                                    </div>
                                    <div class="uk-flex uk-flex-between uk-margin-small-bottom">
                                        <span>Documents Uploaded</span><span class="uk-text-success">+456</span>
                                    </div>
                                    <div class="uk-flex uk-flex-between">
                                        <span>Storage Growth</span><span class="uk-text-warning">+120 GB</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-1-2@m">
                            <div class="uk-card uk-card-default uk-card-body">
                                <h4>Top Activities</h4>
                                <ol class="uk-list">
                                    <li>Document uploads - 456</li>
                                    <li>Application views - 1,234</li>
                                    <li>Payment processing - 89</li>
                                    <li>User logins - 4,567</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </li>

                <!-- Billing -->
                <li>
                    <div class="uk-card uk-card-default uk-card-body">
                        <h4>Billing Information</h4>
                        <dl class="uk-description-list uk-description-list-divider">
                            <dt>Plan</dt><dd>Enterprise</dd>
                            <dt>Monthly Recurring Revenue</dt><dd class="uk-text-bold">$45,000</dd>
                            <dt>Billing Cycle</dt><dd>Monthly (1st of each month)</dd>
                            <dt>Payment Method</dt><dd>Bank Transfer (ACH)</dd>
                            <dt>Next Invoice</dt><dd>February 1, 2024</dd>
                        </dl>
                        <div class="uk-margin-top">
                            <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">View Invoices</button>
                            <button class="uk-button uk-button-default uk-button-small">Update Payment</button>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Add Client Modal -->
<div id="add-client-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add New Client</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Client Name *</label>
                    <input class="uk-input" type="text" placeholder="Company Name" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Contact Email *</label>
                    <input class="uk-input" type="email" placeholder="admin@company.com" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Plan Type *</label>
                    <select class="uk-select" required>
                        <option value="">Select plan...</option>
                        <option>Starter</option>
                        <option>Business</option>
                        <option>Enterprise</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">CDN Configuration</label>
                    <select class="uk-select">
                        <option>Single CDN (Default)</option>
                        <option>Multi-CDN</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Primary CDN Provider</label>
                    <select class="uk-select">
                        <option>AWS S3</option>
                        <option>Cloudflare R2</option>
                        <option>Google Cloud Storage</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Client</button>
        </div>
    </div>
</div>

<!-- Client Settings Modal -->
<div id="client-settings-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Client Settings</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Client Name</label>
                    <input class="uk-input" type="text" value="GlobalEd Pathways">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Primary Contact Email</label>
                    <input class="uk-input" type="email" value="admin@globaledpathways.com">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Storage Limit</label>
                    <select class="uk-select">
                        <option>1 TB</option>
                        <option>2 TB</option>
                        <option selected>5 TB</option>
                        <option>10 TB</option>
                        <option>Unlimited</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">User Limit</label>
                    <input class="uk-input" type="number" value="5000">
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Enable API access</label>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Enable custom branding</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Settings</button>
        </div>
    </div>
</div>

<!-- Manage CDN Modal -->
<div id="manage-cdn-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Manage CDN</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">CDN Mode</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-radio" type="radio" name="cdn-config"> Single CDN</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-radio" type="radio" name="cdn-config" checked> Multi-CDN</label>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Active Providers</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> AWS S3</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Cloudflare R2</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Google Cloud Storage</label>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Failover Strategy</label>
                    <select class="uk-select">
                        <option selected>Automatic (Latency-based)</option>
                        <option>Geographic</option>
                        <option>Round-robin</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save CDN Settings</button>
        </div>
    </div>
</div>

<!-- View Invoices Modal -->
<div id="view-invoices-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">Client Invoices</h2>
        <table class="uk-table uk-table-small uk-table-divider">
            <thead>
                <tr><th>Invoice #</th><th>Date</th><th>Amount</th><th>Status</th><th></th></tr>
            </thead>
            <tbody>
                <tr>
                    <td>INV-2024-001</td>
                    <td>Jan 1, 2024</td>
                    <td class="uk-text-bold">$45,000</td>
                    <td><span class="uk-label uk-label-success">Paid</span></td>
                    <td><a href="#" uk-icon="icon: download; ratio: 0.8"></a></td>
                </tr>
                <tr>
                    <td>INV-2023-012</td>
                    <td>Dec 1, 2023</td>
                    <td class="uk-text-bold">$45,000</td>
                    <td><span class="uk-label uk-label-success">Paid</span></td>
                    <td><a href="#" uk-icon="icon: download; ratio: 0.8"></a></td>
                </tr>
                <tr>
                    <td>INV-2023-011</td>
                    <td>Nov 1, 2023</td>
                    <td class="uk-text-bold">$45,000</td>
                    <td><span class="uk-label uk-label-success">Paid</span></td>
                    <td><a href="#" uk-icon="icon: download; ratio: 0.8"></a></td>
                </tr>
            </tbody>
        </table>
        <div class="uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">Generate Invoice</button>
        </div>
    </div>
</div>

<!-- Update Plan Modal -->
<div id="update-plan-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Update Plan</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Current Plan</label>
                    <div class="uk-text-bold">Enterprise - $45,000/month</div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">New Plan *</label>
                    <select class="uk-select" required>
                        <option value="">Select plan...</option>
                        <option>Starter - $500/month</option>
                        <option>Business - $5,000/month</option>
                        <option selected>Enterprise - $45,000/month</option>
                        <option>Custom</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Effective Date</label>
                    <select class="uk-select">
                        <option>Immediately</option>
                        <option selected>Next billing cycle</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Reason for plan change..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Update Plan</button>
        </div>
    </div>
</div>

<!-- Contact Client Modal -->
<div id="contact-client-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Contact Client</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">To</label>
                    <input class="uk-input" type="email" value="admin@globaledpathways.com" readonly>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" placeholder="Message subject" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="5" placeholder="Your message..." required></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> Send copy to support team</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send Message</button>
        </div>
    </div>
</div>

<!-- Suspend Client Modal -->
<div id="suspend-client-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Suspend Client</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-warning">
                <p>Suspending this client will immediately disable their access to the platform. All data will be preserved.</p>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Reason for Suspension *</label>
                    <select class="uk-select" required>
                        <option value="">Select reason...</option>
                        <option>Non-payment</option>
                        <option>Terms violation</option>
                        <option>Client request</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Additional details..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox" checked> Notify client via email</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-warning" type="button">Suspend Client</button>
        </div>
    </div>
</div>

<!-- Delete Client Modal -->
<div id="delete-client-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete Client</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p><strong>Warning:</strong> This action is irreversible. All client data, users, applications, and documents will be permanently deleted.</p>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Type "DELETE" to confirm *</label>
                    <input class="uk-input" type="text" placeholder="DELETE" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Reason *</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Reason for deletion..." required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete Client</button>
        </div>
    </div>
</div>
