<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Sample system data
$countries_count = 195;
$cities_count = 12847;
$currencies_count = 156;
$universities_count = 2834;

$recent_updates = [
    ['type' => 'Universities', 'count' => 45, 'date' => '2024-01-30', 'status' => 'synced'],
    ['type' => 'Exchange Rates', 'count' => 156, 'date' => '2024-01-30', 'status' => 'synced'],
    ['type' => 'Cities Database', 'count' => 234, 'date' => '2024-01-28', 'status' => 'synced'],
    ['type' => 'Country Data', 'count' => 12, 'date' => '2024-01-25', 'status' => 'synced']
];

$universities_sample = [
    ['name' => 'Stanford University', 'country' => 'United States', 'ranking' => 3, 'programs' => 142, 'acceptance' => '4.3%'],
    ['name' => 'University of Cambridge', 'country' => 'United Kingdom', 'ranking' => 5, 'programs' => 156, 'acceptance' => '21%'],
    ['name' => 'MIT', 'country' => 'United States', 'ranking' => 1, 'programs' => 98, 'acceptance' => '6.7%'],
    ['name' => 'University of Toronto', 'country' => 'Canada', 'ranking' => 18, 'programs' => 234, 'acceptance' => '43%'],
    ['name' => 'ETH Zurich', 'country' => 'Switzerland', 'ranking' => 7, 'programs' => 89, 'acceptance' => '27%']
];

$exchange_rates = [
    ['currency' => 'EUR', 'name' => 'Euro', 'rate' => 0.92, 'change' => '+0.3%'],
    ['currency' => 'GBP', 'name' => 'British Pound', 'rate' => 0.79, 'change' => '-0.1%'],
    ['currency' => 'CAD', 'name' => 'Canadian Dollar', 'rate' => 1.35, 'change' => '+0.2%'],
    ['currency' => 'AUD', 'name' => 'Australian Dollar', 'rate' => 1.53, 'change' => '+0.5%'],
    ['currency' => 'CHF', 'name' => 'Swiss Franc', 'rate' => 0.86, 'change' => '-0.2%']
];

$stats = [
    ['icon' => 'world', 'value' => number_format($countries_count), 'label' => 'Countries', 'color' => 'primary'],
    ['icon' => 'location', 'value' => number_format($cities_count), 'label' => 'Cities', 'color' => 'secondary'],
    ['icon' => 'credit-card', 'value' => number_format($currencies_count), 'label' => 'Currencies', 'color' => 'warning'],
    ['icon' => 'university', 'value' => number_format($universities_count), 'label' => 'Universities', 'color' => 'success']
];

render_stat_cards($stats, 4);
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top">
    <h3 class="uk-margin-remove">System Reference Data</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">
            <span uk-icon="icon: refresh; ratio: 0.8"></span> Sync All
        </button>
        <button class="uk-button uk-button-primary uk-button-small">
            <span uk-icon="icon: cloud-upload; ratio: 0.8"></span> Import Data
        </button>
    </div>
</div>

<!-- Data Categories -->
<ul class="uk-subnav uk-subnav-pill" uk-switcher="animation: uk-animation-fade">
    <li class="uk-active"><a href="#">Overview</a></li>
    <li><a href="#">Universities</a></li>
    <li><a href="#">Countries & Cities</a></li>
    <li><a href="#">Currencies</a></li>
    <li><a href="#">API Sources</a></li>
</ul>

<ul class="uk-switcher uk-margin">
    <!-- Overview Tab -->
    <li>
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-2-3@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Recent Data Updates</h4>
                    <table class="uk-table uk-table-divider uk-table-small">
                        <thead>
                            <tr><th>Data Type</th><th>Records Updated</th><th>Last Sync</th><th>Status</th></tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_updates as $update): ?>
                            <tr>
                                <td class="uk-text-bold"><?= e($update['type']) ?></td>
                                <td><?= e($update['count']) ?></td>
                                <td><?= e($update['date']) ?></td>
                                <td><span class="uk-label uk-label-success"><?= e($update['status']) ?></span></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="uk-width-1-3@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">API Status</h4>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between">
                            <span>REST Countries API</span>
                            <span class="uk-text-success" uk-icon="icon: check"></span>
                        </div>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between">
                            <span>Exchange Rates API</span>
                            <span class="uk-text-success" uk-icon="icon: check"></span>
                        </div>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between">
                            <span>Universities API</span>
                            <span class="uk-text-success" uk-icon="icon: check"></span>
                        </div>
                    </div>
                    <div class="uk-margin">
                        <div class="uk-flex uk-flex-between">
                            <span>GeoNames API</span>
                            <span class="uk-text-warning" uk-icon="icon: warning"></span>
                        </div>
                        <div class="uk-text-small uk-text-muted">Rate limited</div>
                    </div>
                </div>
            </div>
        </div>
    </li>

    <!-- Universities Tab -->
    <li>
        <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-bottom">
            <form class="uk-grid-small" uk-grid>
                <div class="uk-width-1-4@m">
                    <input class="uk-input uk-form-small" type="search" placeholder="Search universities..."
                           _="on keyup
                              set query to my value.toLowerCase()
                              for row in #universities-table tbody tr
                                if row.textContent.toLowerCase().indexOf(query) >= 0
                                  remove .uk-hidden from row
                                else
                                  add .uk-hidden to row
                                end
                              end">
                </div>
                <div class="uk-width-1-6@m">
                    <select class="uk-select uk-form-small">
                        <option value="">All Countries</option>
                        <option>United States</option>
                        <option>United Kingdom</option>
                        <option>Canada</option>
                        <option>Australia</option>
                    </select>
                </div>
                <div class="uk-width-1-6@m">
                    <select class="uk-select uk-form-small">
                        <option value="">All Rankings</option>
                        <option>Top 10</option>
                        <option>Top 50</option>
                        <option>Top 100</option>
                    </select>
                </div>
                <div class="uk-width-expand@m uk-text-right">
                    <button class="uk-button uk-button-default uk-button-small" type="button">
                        <span uk-icon="icon: download; ratio: 0.8"></span> Export
                    </button>
                </div>
            </form>
        </div>

        <div class="uk-card uk-card-default uk-card-body">
            <table id="universities-table" class="uk-table uk-table-divider uk-table-hover uk-table-small">
                <thead>
                    <tr><th>University</th><th>Country</th><th>Ranking</th><th>Programs</th><th>Acceptance</th><th></th></tr>
                </thead>
                <tbody>
                    <?php foreach ($universities_sample as $uni): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($uni['name']) ?></td>
                        <td><?= e($uni['country']) ?></td>
                        <td>#<?= e($uni['ranking']) ?></td>
                        <td><?= e($uni['programs']) ?></td>
                        <td><?= e($uni['acceptance']) ?></td>
                        <td>
                            <a href="#" uk-icon="icon: eye; ratio: 0.8" uk-tooltip="View Details"></a>
                            <a href="#" uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-left" uk-tooltip="Edit"></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <div class="uk-text-center uk-margin-top">
                <button class="uk-button uk-button-default uk-button-small">Load More Universities</button>
            </div>
        </div>
    </li>

    <!-- Countries & Cities Tab -->
    <li>
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Countries (<?= $countries_count ?>)</h4>
                    <div class="uk-margin-bottom">
                        <input class="uk-input uk-form-small" type="search" placeholder="Search countries...">
                    </div>
                    <div style="max-height: 300px; overflow-y: auto;">
                        <ul class="uk-list uk-list-divider">
                            <li class="uk-flex uk-flex-between"><span>United States</span><span class="uk-text-muted">50 states</span></li>
                            <li class="uk-flex uk-flex-between"><span>United Kingdom</span><span class="uk-text-muted">4 countries</span></li>
                            <li class="uk-flex uk-flex-between"><span>Canada</span><span class="uk-text-muted">13 provinces</span></li>
                            <li class="uk-flex uk-flex-between"><span>Australia</span><span class="uk-text-muted">8 states</span></li>
                            <li class="uk-flex uk-flex-between"><span>Germany</span><span class="uk-text-muted">16 states</span></li>
                            <li class="uk-flex uk-flex-between"><span>France</span><span class="uk-text-muted">18 regions</span></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="uk-width-1-2@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title">Cities (<?= number_format($cities_count) ?>)</h4>
                    <div class="uk-margin-bottom">
                        <input class="uk-input uk-form-small" type="search" placeholder="Search cities...">
                    </div>
                    <div style="max-height: 300px; overflow-y: auto;">
                        <ul class="uk-list uk-list-divider">
                            <li class="uk-flex uk-flex-between"><span>New York</span><span class="uk-text-muted">US</span></li>
                            <li class="uk-flex uk-flex-between"><span>London</span><span class="uk-text-muted">UK</span></li>
                            <li class="uk-flex uk-flex-between"><span>Toronto</span><span class="uk-text-muted">CA</span></li>
                            <li class="uk-flex uk-flex-between"><span>Sydney</span><span class="uk-text-muted">AU</span></li>
                            <li class="uk-flex uk-flex-between"><span>Berlin</span><span class="uk-text-muted">DE</span></li>
                            <li class="uk-flex uk-flex-between"><span>Paris</span><span class="uk-text-muted">FR</span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </li>

    <!-- Currencies Tab -->
    <li>
        <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
                <h4 class="uk-margin-remove">Exchange Rates (Base: USD)</h4>
                <div class="uk-text-small uk-text-muted">Last updated: 2024-01-30 12:00 UTC</div>
            </div>
            <table class="uk-table uk-table-divider uk-table-hover uk-table-small">
                <thead>
                    <tr><th>Code</th><th>Currency</th><th>Rate</th><th>24h Change</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($exchange_rates as $rate): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($rate['currency']) ?></td>
                        <td><?= e($rate['name']) ?></td>
                        <td><?= e($rate['rate']) ?></td>
                        <td class="<?= strpos($rate['change'], '+') === 0 ? 'uk-text-success' : 'uk-text-danger' ?>">
                            <?= e($rate['change']) ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </li>

    <!-- API Sources Tab -->
    <li>
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Connected API Sources</h4>
            <table class="uk-table uk-table-divider">
                <thead>
                    <tr><th>API</th><th>Endpoint</th><th>Auth Type</th><th>Status</th><th>Last Call</th><th></th></tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="uk-text-bold">REST Countries</td>
                        <td><code>restcountries.com/v3.1</code></td>
                        <td>None</td>
                        <td><span class="uk-label uk-label-success">Active</span></td>
                        <td>2 min ago</td>
                        <td><a href="#" uk-icon="icon: cog; ratio: 0.8"></a></td>
                    </tr>
                    <tr>
                        <td class="uk-text-bold">Exchange Rates</td>
                        <td><code>api.exchangerate.host</code></td>
                        <td>API Key</td>
                        <td><span class="uk-label uk-label-success">Active</span></td>
                        <td>5 min ago</td>
                        <td><a href="#" uk-icon="icon: cog; ratio: 0.8"></a></td>
                    </tr>
                    <tr>
                        <td class="uk-text-bold">World Universities</td>
                        <td><code>universities.hipolabs.com</code></td>
                        <td>None</td>
                        <td><span class="uk-label uk-label-success">Active</span></td>
                        <td>1 hour ago</td>
                        <td><a href="#" uk-icon="icon: cog; ratio: 0.8"></a></td>
                    </tr>
                    <tr>
                        <td class="uk-text-bold">GeoNames</td>
                        <td><code>api.geonames.org</code></td>
                        <td>Username</td>
                        <td><span class="uk-label uk-label-warning">Limited</span></td>
                        <td>3 hours ago</td>
                        <td><a href="#" uk-icon="icon: cog; ratio: 0.8"></a></td>
                    </tr>
                </tbody>
            </table>
            <div class="uk-margin-top">
                <button class="uk-button uk-button-primary uk-button-small">
                    <span uk-icon="icon: plus; ratio: 0.8"></span> Add API Source
                </button>
            </div>
        </div>
    </li>
</ul>
