<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$stats = [
    ['icon' => 'credit-card', 'value' => '$2.9M', 'label' => 'Total Revenue', 'trend' => 18, 'color' => 'success'],
    ['icon' => 'trending-up', 'value' => '$456K', 'label' => 'This Month', 'trend' => 12, 'color' => 'primary'],
    ['icon' => 'clock', 'value' => '$89K', 'label' => 'Pending', 'color' => 'warning'],
    ['icon' => 'refresh', 'value' => '$23K', 'label' => 'Refunds', 'color' => 'danger']
];

$transactions = [
    ['id' => 'TXN-10234', 'user' => 'John Doe', 'amount' => '$25,000', 'type' => 'Payment', 'date' => '2024-01-30', 'status' => 'completed'],
    ['id' => 'TXN-10233', 'user' => 'Sarah Chen', 'amount' => '$15,000', 'type' => 'Payment', 'date' => '2024-01-30', 'status' => 'completed'],
    ['id' => 'TXN-10232', 'user' => 'Mike Rodriguez', 'amount' => '$500', 'type' => 'Refund', 'date' => '2024-01-29', 'status' => 'completed'],
    ['id' => 'TXN-10231', 'user' => 'Emma Wilson', 'amount' => '$30,000', 'type' => 'Payment', 'date' => '2024-01-29', 'status' => 'pending']
];

render_stat_cards($stats);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Revenue Breakdown</h4>
            <div id="revenue-pie-chart" style="height: 280px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Monthly Revenue Trend</h4>
            <div id="revenue-trend-chart" style="height: 280px;"></div>
        </div>
    </div>
</div>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top">
    <h3 class="uk-margin-remove">Financial Overview</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right">Export Report</button>
        <button class="uk-button uk-button-primary uk-button-small">Generate Invoice</button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Recent Transactions</h4>
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr><th>ID</th><th>User</th><th>Amount</th><th>Type</th><th>Date</th><th>Status</th></tr>
        </thead>
        <tbody>
            <?php foreach ($transactions as $txn): ?>
            <tr>
                <td class="uk-text-bold"><?= e($txn['id']) ?></td>
                <td><?= e($txn['user']) ?></td>
                <td class="uk-text-bold"><?= e($txn['amount']) ?></td>
                <td><span class="uk-label uk-label-<?= $txn['type'] === 'Payment' ? 'success' : 'warning' ?>"><?= e($txn['type']) ?></span></td>
                <td><?= e($txn['date']) ?></td>
                <td><span class="uk-label uk-label-<?= $txn['status'] === 'completed' ? 'success' : 'warning' ?>"><?= e($txn['status']) ?></span></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
(function() {
    // ECharts - Revenue Pie Chart
    var pieEl = document.getElementById('revenue-pie-chart');
    if (pieEl && typeof echarts !== 'undefined') {
        var pieChart = echarts.init(pieEl);
        var pieOption = {
            tooltip: { trigger: 'item', formatter: '{b}: ${c}K ({d}%)' },
            legend: { orient: 'vertical', right: 10, top: 'center' },
            series: [{
                type: 'pie',
                radius: ['40%', '70%'],
                avoidLabelOverlap: false,
                itemStyle: { borderRadius: 10, borderColor: '#fff', borderWidth: 2 },
                label: { show: false },
                emphasis: { label: { show: true, fontSize: 14, fontWeight: 'bold' } },
                labelLine: { show: false },
                data: [
                    { value: 1140, name: 'North America', itemStyle: { color: '#3b82f6' } },
                    { value: 785, name: 'Europe', itemStyle: { color: '#10b981' } },
                    { value: 567, name: 'Asia Pacific', itemStyle: { color: '#f59e0b' } },
                    { value: 234, name: 'Latin America', itemStyle: { color: '#8b5cf6' } },
                    { value: 124, name: 'ME & Africa', itemStyle: { color: '#06b6d4' } }
                ]
            }]
        };
        pieChart.setOption(pieOption);
        window.addEventListener('resize', function() { pieChart.resize(); });
    }

    // ApexCharts - Revenue Trend Line Chart
    var trendEl = document.getElementById('revenue-trend-chart');
    if (trendEl && typeof ApexCharts !== 'undefined') {
        var trendOptions = {
            series: [{ name: 'Revenue', data: [380, 420, 456, 478, 512, 456] }],
            chart: { type: 'line', height: 280, toolbar: { show: false } },
            colors: ['#10b981'],
            stroke: { curve: 'smooth', width: 3 },
            markers: { size: 5, colors: ['#10b981'], strokeColors: '#fff', strokeWidth: 2 },
            xaxis: {
                categories: ['Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                labels: { style: { colors: '#64748b' } }
            },
            yaxis: {
                labels: { formatter: function(val) { return '$' + val + 'K'; }, style: { colors: '#64748b' } }
            },
            tooltip: { y: { formatter: function(val) { return '$' + val + 'K'; } } }
        };
        new ApexCharts(trendEl, trendOptions).render();
    }
})();
</script>
