<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$alerts = [
    ['level' => 'high', 'message' => 'Multiple failed login attempts detected from IP 45.67.89.123', 'time' => '2024-01-30 16:45:32', 'status' => 'active'],
    ['level' => 'medium', 'message' => 'Database query response time increased by 15% in last hour', 'time' => '2024-01-30 15:23:18', 'status' => 'investigating'],
    ['level' => 'low', 'message' => 'Scheduled maintenance reminder: Database backup tonight at 2 AM EST', 'time' => '2024-01-30 12:00:00', 'status' => 'scheduled']
];

$stats = [
    ['icon' => 'users', 'value' => '12,847', 'label' => 'Total Users', 'trend' => 12, 'color' => 'primary'],
    ['icon' => 'credit-card', 'value' => '$2.9M', 'label' => 'Total Revenue', 'trend' => 18, 'color' => 'success'],
    ['icon' => 'server', 'value' => '99.94%', 'label' => 'Server Uptime', 'color' => 'warning'],
    ['icon' => 'clock', 'value' => '247ms', 'label' => 'Avg Response', 'trend' => -5, 'suffix' => 'improvement', 'color' => 'cyan']
];

$regions = [
    ['name' => 'North America', 'users' => '4,521', 'applications' => '18,934', 'revenue' => '$1140K', 'growth' => '+15.3%'],
    ['name' => 'Europe', 'users' => '3,847', 'applications' => '15,678', 'revenue' => '$785K', 'growth' => '+12.8%'],
    ['name' => 'Asia Pacific', 'users' => '2,934', 'applications' => '8,234', 'revenue' => '$567K', 'growth' => '+23.7%'],
    ['name' => 'Latin America', 'users' => '1,234', 'applications' => '2,456', 'revenue' => '$234K', 'growth' => '+18.9%'],
    ['name' => 'Middle East & Africa', 'users' => '311', 'applications' => '370', 'revenue' => '$124K', 'growth' => '+28.4%']
];
?>

<!-- Critical System Alerts -->
<div class="uk-card uk-card-default uk-card-body uk-margin-bottom" style="border-left: 4px solid #ef4444;">
    <h4 class="uk-card-title uk-text-danger"><span uk-icon="icon: warning"></span> Critical System Alerts</h4>
    <?php foreach ($alerts as $alert): ?>
    <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom uk-padding-small uk-background-muted" style="border-radius: 8px;">
        <div class="uk-flex uk-flex-middle">
            <span class="uk-label uk-label-<?= $GLOBALS['alert_levels'][$alert['level']]['color'] ?> uk-margin-right"><?= $alert['level'] ?></span>
            <div>
                <div class="uk-text-small"><?= e($alert['message']) ?></div>
                <div class="uk-text-meta uk-text-small"><?= e($alert['time']) ?></div>
            </div>
        </div>
        <div class="uk-flex uk-flex-middle">
            <span class="uk-label uk-label-<?= $GLOBALS['alert_statuses'][$alert['status']]['color'] ?>"><?= $alert['status'] ?></span>
            <a href="#" uk-icon="icon: eye" class="uk-margin-small-left"></a>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php render_stat_cards($stats); ?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">System Performance</h4>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between"><span>CPU Usage</span><span>34.2%</span></div>
                <progress class="uk-progress" value="34.2" max="100"></progress>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between"><span>Memory Usage</span><span>45.7GB / 128GB</span></div>
                <progress class="uk-progress" value="35.7" max="100"></progress>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between"><span>Storage Usage</span><span>2847.5GB / 5000GB</span></div>
                <progress class="uk-progress" value="56.9" max="100"></progress>
            </div>
            <div class="uk-grid-small uk-child-width-1-2 uk-margin-top" uk-grid>
                <div>
                    <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center" style="background: #dbeafe;">
                        <div class="uk-text-primary uk-text-small">Network In</div>
                        <div class="uk-text-bold uk-text-primary">234.7 Mbps</div>
                    </div>
                </div>
                <div>
                    <div class="uk-card uk-card-default uk-card-body uk-card-small uk-text-center" style="background: #fee2e2;">
                        <div class="uk-text-danger uk-text-small">Network Out</div>
                        <div class="uk-text-bold uk-text-danger">189.3 Mbps</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Regional Performance</h4>
            <div id="regional-chart" style="height: 320px;"></div>
        </div>
    </div>
</div>

<!-- Regional Map -->
<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">Global Distribution</h4>
    <div id="world-map" style="height: 350px;"></div>
</div>

<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">System Controls</h4>
    <div class="uk-grid-small uk-child-width-1-4@m" uk-grid>
        <div><button class="uk-button uk-button-default uk-width-1-1"><span uk-icon="icon: ban; ratio: 0.8"></span> Maintenance Mode</button></div>
        <div><button class="uk-button uk-button-default uk-width-1-1"><span uk-icon="icon: database; ratio: 0.8"></span> Create Backup</button></div>
        <div><button class="uk-button uk-button-default uk-width-1-1"><span uk-icon="icon: refresh; ratio: 0.8"></span> Schedule Restart</button></div>
        <div><button class="uk-button uk-button-default uk-width-1-1"><span uk-icon="icon: desktop; ratio: 0.8"></span> System Monitor</button></div>
    </div>
</div>

<script>
(function() {
    // ECharts - Regional Performance Bar Chart
    var regionalEl = document.getElementById('regional-chart');
    if (regionalEl && typeof echarts !== 'undefined') {
        var regionalChart = echarts.init(regionalEl);
        var regionalOption = {
            tooltip: { trigger: 'axis', axisPointer: { type: 'shadow' } },
            legend: { data: ['Users', 'Revenue ($K)'], top: 0 },
            grid: { left: '3%', right: '4%', bottom: '3%', containLabel: true },
            xAxis: {
                type: 'value',
                axisLabel: { color: '#64748b' }
            },
            yAxis: {
                type: 'category',
                data: ['ME & Africa', 'Latin America', 'Asia Pacific', 'Europe', 'North America'],
                axisLabel: { color: '#64748b' }
            },
            series: [
                {
                    name: 'Users',
                    type: 'bar',
                    data: [311, 1234, 2934, 3847, 4521],
                    itemStyle: { color: '#3b82f6' }
                },
                {
                    name: 'Revenue ($K)',
                    type: 'bar',
                    data: [124, 234, 567, 785, 1140],
                    itemStyle: { color: '#10b981' }
                }
            ]
        };
        regionalChart.setOption(regionalOption);
        window.addEventListener('resize', function() { regionalChart.resize(); });
    }

    // jsVectorMap - World Map
    var mapEl = document.getElementById('world-map');
    if (mapEl && typeof jsVectorMap !== 'undefined') {
        new jsVectorMap({
            selector: '#world-map',
            map: 'world',
            backgroundColor: 'transparent',
            regionStyle: {
                initial: { fill: '#e2e8f0', stroke: '#cbd5e1', strokeWidth: 0.5 },
                hover: { fillOpacity: 0.8 }
            },
            markers: [
                { name: 'North America', coords: [40.7128, -74.0060] },
                { name: 'Europe', coords: [51.5074, -0.1278] },
                { name: 'Asia Pacific', coords: [35.6762, 139.6503] },
                { name: 'Latin America', coords: [-23.5505, -46.6333] },
                { name: 'Middle East', coords: [25.2048, 55.2708] }
            ],
            markerStyle: {
                initial: { fill: '#3b82f6', stroke: '#fff', r: 8 },
                hover: { fill: '#1d4ed8', r: 10 }
            },
            markerLabelStyle: {
                initial: { fontFamily: 'inherit', fontSize: 12, fill: '#374151' }
            },
            labels: { markers: { render: function(marker) { return marker.name; } } }
        });
    }
})();
</script>
