<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user = $GLOBALS['current_user'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">My Profile</h3>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #edit-profile-modal">
        <span uk-icon="icon: pencil; ratio: 0.8"></span> Edit Profile
    </button>
</div>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body uk-text-center">
            <?= get_avatar($user['name'], 120) ?>
            <h4 class="uk-margin-small-top uk-margin-remove-bottom"><?= e($user['name']) ?></h4>
            <p class="uk-text-muted uk-margin-remove"><?= e($user['role']) ?></p>
            <span class="uk-label uk-label-warning">System Administrator</span>
            <div class="uk-margin-top">
                <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #change-avatar-modal">
                    <span uk-icon="icon: image; ratio: 0.8"></span> Change Avatar
                </button>
            </div>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Access Level</h5>
            <dl class="uk-description-list">
                <dt>Role</dt>
                <dd>High Chancellor</dd>
                <dt>Permissions</dt>
                <dd>Full System Access</dd>
                <dt>API Access</dt>
                <dd><span class="uk-label uk-label-success">Enabled</span></dd>
            </dl>
        </div>
    </div>

    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Personal Information</h4>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Full Name</dt>
                <dd><?= e($user['name']) ?></dd>
                <dt>Email Address</dt>
                <dd><?= e($user['email']) ?></dd>
                <dt>Phone Number</dt>
                <dd>+1 (555) 000-0001</dd>
                <dt>Department</dt>
                <dd>System Administration</dd>
                <dt>Timezone</dt>
                <dd>UTC</dd>
            </dl>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Security Settings</h4>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Two-Factor Authentication</div>
                        <div class="uk-text-small uk-text-muted">Required for system administrators</div>
                    </div>
                    <span class="uk-label uk-label-success">Enabled</span>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">Hardware Security Key</div>
                        <div class="uk-text-small uk-text-muted">YubiKey 5 NFC registered</div>
                    </div>
                    <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #manage-security-key-modal">Manage</button>
                </div>
            </div>
            <div class="uk-margin">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">IP Whitelist</div>
                        <div class="uk-text-small uk-text-muted">3 IP addresses whitelisted</div>
                    </div>
                    <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #configure-ip-whitelist-modal">Configure</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change Avatar Modal -->
<div id="change-avatar-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change Avatar</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-margin-bottom">
                <?= get_avatar($user['name'], 100) ?>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Upload New Avatar</label>
                    <div uk-form-custom="target: true">
                        <input type="file" accept="image/*">
                        <input class="uk-input uk-form-width-large" type="text" placeholder="Select image..." disabled>
                    </div>
                    <p class="uk-text-small uk-text-muted uk-margin-small-top">Max file size: 2MB. Supported: JPG, PNG, GIF</p>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Upload</button>
        </div>
    </div>
</div>

<!-- Manage Security Key Modal -->
<div id="manage-security-key-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Hardware Security Keys</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold">YubiKey 5 NFC</div>
                        <div class="uk-text-small uk-text-muted">Added on January 15, 2024</div>
                    </div>
                    <button class="uk-button uk-button-danger uk-button-small">Remove</button>
                </div>
            </div>
            <hr>
            <button class="uk-button uk-button-default uk-width-1-1">
                <span uk-icon="icon: plus; ratio: 0.8"></span> Add New Security Key
            </button>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Configure IP Whitelist Modal -->
<div id="configure-ip-whitelist-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">IP Whitelist</h2>
        </div>
        <div class="uk-modal-body">
            <table class="uk-table uk-table-small uk-table-divider">
                <thead>
                    <tr><th>IP Address</th><th>Label</th><th></th></tr>
                </thead>
                <tbody>
                    <tr>
                        <td><code>192.168.1.100</code></td>
                        <td>Office</td>
                        <td><a href="#" uk-icon="icon: trash; ratio: 0.8" class="uk-text-danger"></a></td>
                    </tr>
                    <tr>
                        <td><code>10.0.0.50</code></td>
                        <td>VPN</td>
                        <td><a href="#" uk-icon="icon: trash; ratio: 0.8" class="uk-text-danger"></a></td>
                    </tr>
                    <tr>
                        <td><code>203.0.113.25</code></td>
                        <td>Home</td>
                        <td><a href="#" uk-icon="icon: trash; ratio: 0.8" class="uk-text-danger"></a></td>
                    </tr>
                </tbody>
            </table>
            <hr>
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <input class="uk-input" type="text" placeholder="IP Address">
                    </div>
                    <div class="uk-width-1-4">
                        <input class="uk-input" type="text" placeholder="Label">
                    </div>
                    <div class="uk-width-1-4">
                        <button class="uk-button uk-button-primary uk-width-1-1" type="button">Add</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Edit Profile Modal -->
<div id="edit-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit Profile</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Full Name</label>
                    <input class="uk-input" type="text" value="<?= e($user['name']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Address</label>
                    <input class="uk-input" type="email" value="<?= e($user['email']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Phone Number</label>
                    <input class="uk-input" type="tel" value="+1 (555) 000-0001">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>
