<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$threats = [
    ['type' => 'Failed Login', 'ip' => '45.67.89.123', 'attempts' => 23, 'time' => '2024-01-30 16:45', 'status' => 'blocked'],
    ['type' => 'Suspicious Activity', 'ip' => '123.45.67.89', 'attempts' => 5, 'time' => '2024-01-30 14:23', 'status' => 'monitoring'],
    ['type' => 'Rate Limit', 'ip' => '98.76.54.32', 'attempts' => 100, 'time' => '2024-01-30 12:15', 'status' => 'blocked']
];

$stats = [
    ['icon' => 'lock', 'value' => '99.8%', 'label' => 'Security Score', 'color' => 'success'],
    ['icon' => 'ban', 'value' => '156', 'label' => 'Blocked IPs', 'color' => 'danger'],
    ['icon' => 'warning', 'value' => '3', 'label' => 'Active Threats', 'color' => 'warning'],
    ['icon' => 'check', 'value' => '2FA', 'label' => 'Auth Method', 'color' => 'primary']
];

render_stat_cards($stats);
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top">
    <h3 class="uk-margin-remove">Security Threats</h3>
    <button class="uk-button uk-button-primary uk-button-small">Security Scan</button>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider">
        <thead>
            <tr><th>Type</th><th>IP Address</th><th>Attempts</th><th>Time</th><th>Status</th><th></th></tr>
        </thead>
        <tbody>
            <?php foreach ($threats as $threat): ?>
            <tr>
                <td class="uk-text-bold"><?= e($threat['type']) ?></td>
                <td><code><?= e($threat['ip']) ?></code></td>
                <td><?= $threat['attempts'] ?></td>
                <td><?= e($threat['time']) ?></td>
                <td><span class="uk-label uk-label-<?= $threat['status'] === 'blocked' ? 'danger' : 'warning' ?>"><?= e($threat['status']) ?></span></td>
                <td>
                    <a href="#" uk-icon="icon: ban" uk-tooltip="Block"></a>
                    <a href="#" uk-icon="icon: info" class="uk-margin-small-left" uk-tooltip="Details"></a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
