<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$services = [
    ['name' => 'Web Server', 'status' => 'running', 'uptime' => '45 days', 'cpu' => 23, 'memory' => 34],
    ['name' => 'Database', 'status' => 'running', 'uptime' => '45 days', 'cpu' => 45, 'memory' => 67],
    ['name' => 'Cache Server', 'status' => 'running', 'uptime' => '12 days', 'cpu' => 12, 'memory' => 45],
    ['name' => 'Email Service', 'status' => 'running', 'uptime' => '30 days', 'cpu' => 8, 'memory' => 23],
    ['name' => 'File Storage', 'status' => 'running', 'uptime' => '45 days', 'cpu' => 15, 'memory' => 78]
];

$status_colors = ['running' => 'success', 'stopped' => 'danger', 'warning' => 'warning'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">System Services</h3>
    <div class="uk-flex uk-flex-wrap">
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right uk-margin-small-bottom" uk-toggle="target: #restart-all-modal">Restart All</button>
        <button class="uk-button uk-button-primary uk-button-small uk-margin-small-bottom" uk-toggle="target: #health-check-modal">Health Check</button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <div class="table-responsive">
    <table class="uk-table uk-table-divider">
        <thead>
            <tr><th>Service</th><th>Status</th><th>Uptime</th><th>CPU</th><th>Memory</th><th></th></tr>
        </thead>
        <tbody>
            <?php foreach ($services as $service): ?>
            <tr>
                <td class="uk-text-bold"><?= e($service['name']) ?></td>
                <td><span class="uk-label uk-label-<?= $status_colors[$service['status']] ?>"><?= e($service['status']) ?></span></td>
                <td><?= e($service['uptime']) ?></td>
                <td>
                    <div style="width: 100px;">
                        <progress class="uk-progress uk-margin-remove" value="<?= $service['cpu'] ?>" max="100"></progress>
                        <div class="uk-text-small"><?= $service['cpu'] ?>%</div>
                    </div>
                </td>
                <td>
                    <div style="width: 100px;">
                        <progress class="uk-progress uk-margin-remove" value="<?= $service['memory'] ?>" max="100"></progress>
                        <div class="uk-text-small"><?= $service['memory'] ?>%</div>
                    </div>
                </td>
                <td>
                    <a href="#" uk-icon="icon: play" class="uk-margin-small-right" uk-toggle="target: #start-service-modal" uk-tooltip="Start"></a>
                    <a href="#" uk-icon="icon: refresh" class="uk-margin-small-right" uk-toggle="target: #restart-service-modal" uk-tooltip="Restart"></a>
                    <a href="#" uk-icon="icon: close" class="uk-text-danger" uk-toggle="target: #stop-service-modal" uk-tooltip="Stop"></a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>

<!-- Restart All Services Modal -->
<div id="restart-all-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Restart All Services</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-warning">
                <p>This will restart all system services. Users may experience brief downtime.</p>
            </div>
            <p>Are you sure you want to restart all services?</p>
            <div class="uk-margin">
                <label><input class="uk-checkbox" type="checkbox"> Send notification to administrators</label>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-warning" type="button">Restart All</button>
        </div>
    </div>
</div>

<!-- Health Check Modal -->
<div id="health-check-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">System Health Check</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-padding">
                <span uk-spinner="ratio: 2"></span>
                <p class="uk-margin-top">Running health checks...</p>
            </div>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Database Connection</dt>
                <dd><span class="uk-label uk-label-success">Healthy</span></dd>
                <dt>Cache Server</dt>
                <dd><span class="uk-label uk-label-success">Healthy</span></dd>
                <dt>File Storage</dt>
                <dd><span class="uk-label uk-label-success">Healthy</span></dd>
                <dt>Email Service</dt>
                <dd><span class="uk-label uk-label-success">Healthy</span></dd>
                <dt>SSL Certificates</dt>
                <dd><span class="uk-label uk-label-success">Valid (expires in 89 days)</span></dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">Run Again</button>
        </div>
    </div>
</div>

<!-- Start Service Modal -->
<div id="start-service-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Start Service</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to start this service?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-success" type="button">Start Service</button>
        </div>
    </div>
</div>

<!-- Restart Service Modal -->
<div id="restart-service-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Restart Service</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to restart this service?</p>
            <p class="uk-text-muted uk-text-small">The service will be briefly unavailable during restart.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-warning" type="button">Restart</button>
        </div>
    </div>
</div>

<!-- Stop Service Modal -->
<div id="stop-service-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Stop Service</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p>Stopping this service may affect system functionality.</p>
            </div>
            <p>Are you sure you want to stop this service?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Stop Service</button>
        </div>
    </div>
</div>
