<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$universities = [
    ['id' => 1, 'name' => 'Stanford University', 'country' => 'USA', 'applications' => 1234, 'acceptance' => '12%', 'active' => true],
    ['id' => 2, 'name' => 'MIT', 'country' => 'USA', 'applications' => 987, 'acceptance' => '8%', 'active' => true],
    ['id' => 3, 'name' => 'University of Cambridge', 'country' => 'UK', 'applications' => 876, 'acceptance' => '21%', 'active' => true],
    ['id' => 4, 'name' => 'University of Oxford', 'country' => 'UK', 'applications' => 823, 'acceptance' => '17%', 'active' => true],
    ['id' => 5, 'name' => 'ETH Zurich', 'country' => 'Switzerland', 'applications' => 567, 'acceptance' => '27%', 'active' => true],
    ['id' => 6, 'name' => 'University of Toronto', 'country' => 'Canada', 'applications' => 543, 'acceptance' => '43%', 'active' => true]
];

$stats = [
    ['icon' => 'location', 'value' => '2,847', 'label' => 'Partner Universities', 'color' => 'primary'],
    ['icon' => 'world', 'value' => '45', 'label' => 'Countries', 'color' => 'success'],
    ['icon' => 'file-text', 'value' => '89,234', 'label' => 'Total Applications', 'color' => 'warning']
];

render_stat_cards($stats, 3);
?>

<!-- University Distribution Map -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Partner University Distribution</h4>
            <div id="university-map" style="height: 300px;"></div>
        </div>
    </div>
    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Applications by Country</h4>
            <div id="university-bar-chart" style="height: 300px;"></div>
        </div>
    </div>
</div>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top">
    <h3 class="uk-margin-remove">University Partners</h3>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-university-modal">Add University</button>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr><th>University</th><th>Country</th><th>Applications</th><th>Avg Acceptance</th><th>Status</th><th></th></tr>
        </thead>
        <tbody>
            <?php foreach ($universities as $uni): ?>
            <tr>
                <td class="uk-text-bold"><?= e($uni['name']) ?></td>
                <td><?= e($uni['country']) ?></td>
                <td><?= number_format($uni['applications']) ?></td>
                <td><?= e($uni['acceptance']) ?></td>
                <td><span class="uk-label uk-label-<?= $uni['active'] ? 'success' : 'secondary' ?>"><?= $uni['active'] ? 'Active' : 'Inactive' ?></span></td>
                <td>
                    <a href="#" uk-icon="icon: more-vertical"></a>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li class="uk-nav-header">Actions</li>
                            <li><a href="<?= BASE_URL ?>/pages/university-detail.php?id=<?= $uni['id'] ?>"
                                   hx-get="<?= BASE_URL ?>/pages/university-detail.php?id=<?= $uni['id'] ?>"
                                   hx-target="#main-content"
                                   hx-swap="innerHTML"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> View Details</a></li>
                            <li><a href="#" uk-toggle="target: #edit-university-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                            <li><a href="<?= BASE_URL ?>/pages/university-detail.php?id=<?= $uni['id'] ?>"
                                   hx-get="<?= BASE_URL ?>/pages/university-detail.php?id=<?= $uni['id'] ?>"
                                   hx-target="#main-content"
                                   hx-swap="innerHTML"><span uk-icon="icon: file-text; ratio: 0.8" class="uk-margin-small-right"></span> View Applications</a></li>
                            <li><a href="#" uk-toggle="target: #statistics-modal"><span uk-icon="icon: chart; ratio: 0.8" class="uk-margin-small-right"></span> Statistics</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" uk-toggle="target: #toggle-status-modal"><span uk-icon="icon: <?= $uni['active'] ? 'close' : 'check' ?>; ratio: 0.8" class="uk-margin-small-right"></span> <?= $uni['active'] ? 'Deactivate' : 'Activate' ?></a></li>
                            <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-university-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Edit University Modal -->
<div id="edit-university-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit University</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">University Name *</label>
                    <input class="uk-input" type="text" placeholder="University name" required>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Country *</label>
                        <input class="uk-input" type="text" placeholder="Country" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">City *</label>
                        <input class="uk-input" type="text" placeholder="City" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Website</label>
                    <input class="uk-input" type="url" placeholder="https://...">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Contact Email</label>
                    <input class="uk-input" type="email" placeholder="admissions@...">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- Add University Modal -->
<div id="add-university-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add University</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">University Name *</label>
                    <input class="uk-input" type="text" placeholder="University name" required>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Country *</label>
                        <input class="uk-input" type="text" placeholder="Country" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">City *</label>
                        <input class="uk-input" type="text" placeholder="City" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Website</label>
                    <input class="uk-input" type="url" placeholder="https://...">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Contact Email</label>
                    <input class="uk-input" type="email" placeholder="admissions@...">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add University</button>
        </div>
    </div>
</div>

<!-- Statistics Modal -->
<div id="statistics-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">University Statistics</h2>
        </div>
        <div class="uk-modal-body">
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Total Applications</dt>
                <dd>1,234</dd>
                <dt>Acceptance Rate</dt>
                <dd>12%</dd>
                <dt>Average Processing Time</dt>
                <dd>45 days</dd>
                <dt>Most Popular Programs</dt>
                <dd>Computer Science, Engineering, Business</dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">Export Report</button>
        </div>
    </div>
</div>

<!-- Toggle Status Modal -->
<div id="toggle-status-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change University Status</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to change the status of this university?</p>
            <p class="uk-text-muted uk-text-small">Deactivated universities will not appear in application options.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-warning" type="button">Change Status</button>
        </div>
    </div>
</div>

<!-- Delete University Modal -->
<div id="delete-university-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete University</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p>This action cannot be undone. All associated application data will be archived.</p>
            </div>
            <p>Are you sure you want to delete this university?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>

<script>
(function() {
    // jsVectorMap - University Distribution
    var mapEl = document.getElementById('university-map');
    if (mapEl && typeof jsVectorMap !== 'undefined') {
        new jsVectorMap({
            selector: '#university-map',
            map: 'world',
            backgroundColor: 'transparent',
            regionStyle: {
                initial: { fill: '#e2e8f0', stroke: '#cbd5e1', strokeWidth: 0.5 },
                hover: { fillOpacity: 0.8 }
            },
            series: {
                regions: [{
                    values: { US: 2221, GB: 1699, CA: 543, CH: 567 },
                    scale: ['#bfdbfe', '#1d4ed8'],
                    normalizeFunction: 'polynomial'
                }]
            },
            markers: [
                { name: 'Stanford', coords: [37.4275, -122.1697], style: { fill: '#ef4444' } },
                { name: 'MIT', coords: [42.3601, -71.0942], style: { fill: '#ef4444' } },
                { name: 'Cambridge', coords: [52.2053, 0.1218], style: { fill: '#f59e0b' } },
                { name: 'Oxford', coords: [51.7520, -1.2577], style: { fill: '#f59e0b' } },
                { name: 'ETH Zurich', coords: [47.3769, 8.5417], style: { fill: '#10b981' } },
                { name: 'Toronto', coords: [43.6629, -79.3957], style: { fill: '#8b5cf6' } }
            ],
            markerStyle: {
                initial: { r: 6, stroke: '#fff', strokeWidth: 2 },
                hover: { r: 8 }
            },
            labels: { markers: { render: function(marker) { return marker.name; } } }
        });
    }

    // ApexCharts - Applications by Country
    var barEl = document.getElementById('university-bar-chart');
    if (barEl && typeof ApexCharts !== 'undefined') {
        var barOptions = {
            series: [{ name: 'Applications', data: [2221, 1699, 567, 543] }],
            chart: { type: 'bar', height: 300, toolbar: { show: false } },
            colors: ['#3b82f6'],
            plotOptions: { bar: { borderRadius: 4, horizontal: true } },
            dataLabels: { enabled: false },
            xaxis: { categories: ['USA', 'UK', 'Switzerland', 'Canada'], labels: { style: { colors: '#64748b' } } },
            yaxis: { labels: { style: { colors: '#64748b' } } }
        };
        new ApexCharts(barEl, barOptions).render();
    }
})();
</script>
