<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$uni_id = $_GET['id'] ?? 1;

$university = [
    'id' => $uni_id,
    'name' => 'Stanford University',
    'country' => 'USA',
    'city' => 'Stanford, California',
    'website' => 'https://www.stanford.edu',
    'contact_email' => 'admissions@stanford.edu',
    'applications' => 1234,
    'acceptance_rate' => '12%',
    'active' => true,
    'added' => '2022-01-15'
];

$programs = [
    ['name' => 'Computer Science (MS)', 'applications' => 456, 'acceptance' => '8%', 'deadline' => '2024-12-15'],
    ['name' => 'Engineering (MS)', 'applications' => 342, 'acceptance' => '10%', 'deadline' => '2024-12-01'],
    ['name' => 'Business Administration (MBA)', 'applications' => 298, 'acceptance' => '15%', 'deadline' => '2024-01-15'],
    ['name' => 'Medicine (MD)', 'applications' => 138, 'acceptance' => '5%', 'deadline' => '2024-10-15']
];

$recent_applications = [
    ['student' => 'John Doe', 'program' => 'Computer Science (MS)', 'status' => 'under_review', 'submitted' => '2024-01-30'],
    ['student' => 'Sarah Chen', 'program' => 'Engineering (MS)', 'status' => 'accepted', 'submitted' => '2024-01-28'],
    ['student' => 'Michael Rodriguez', 'program' => 'Business Administration (MBA)', 'status' => 'interview_scheduled', 'submitted' => '2024-01-25']
];

$status_colors = ['submitted' => 'secondary', 'under_review' => 'warning', 'interview_scheduled' => 'primary', 'accepted' => 'success', 'rejected' => 'danger'];
?>

<div class="uk-margin-bottom">
    <a href="<?= BASE_URL ?>/index.php"
       hx-get="<?= BASE_URL ?>/pages/universities.php"
       hx-target="#main-content"
       hx-swap="innerHTML"
       class="uk-link-muted">
        <span uk-icon="arrow-left"></span> Back to Universities
    </a>
</div>

<!-- University Header -->
<div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
    <div class="uk-flex uk-flex-between uk-flex-middle">
        <div>
            <h2 class="uk-margin-remove"><?= e($university['name']) ?></h2>
            <div class="uk-text-muted"><?= e($university['city']) ?>, <?= e($university['country']) ?></div>
        </div>
        <div class="uk-flex uk-flex-middle">
            <span class="uk-label uk-label-<?= $university['active'] ? 'success' : 'secondary' ?> uk-margin-small-right">
                <?= $university['active'] ? 'Active' : 'Inactive' ?>
            </span>
            <a href="#" uk-icon="icon: more-vertical"></a>
            <div uk-dropdown="mode: click; pos: bottom-right">
                <ul class="uk-nav uk-dropdown-nav">
                    <li class="uk-nav-header">Actions</li>
                    <li><a href="#" uk-toggle="target: #edit-university-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                    <li><a href="#" uk-toggle="target: #add-program-modal"><span uk-icon="icon: plus; ratio: 0.8" class="uk-margin-small-right"></span> Add Program</a></li>
                    <li><a href="<?= e($university['website']) ?>" target="_blank"><span uk-icon="icon: link; ratio: 0.8" class="uk-margin-small-right"></span> Visit Website</a></li>
                    <li class="uk-nav-divider"></li>
                    <li><a href="#" uk-toggle="target: #toggle-status-modal"><span uk-icon="icon: <?= $university['active'] ? 'close' : 'check' ?>; ratio: 0.8" class="uk-margin-small-right"></span> <?= $university['active'] ? 'Deactivate' : 'Activate' ?></a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="uk-grid-small" uk-grid>
    <!-- Left Column -->
    <div class="uk-width-2-3@m">
        <!-- Programs -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
                <h4 class="uk-card-title uk-margin-remove">Programs (<?= count($programs) ?>)</h4>
                <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #add-program-modal">
                    <span uk-icon="icon: plus; ratio: 0.8"></span> Add Program
                </button>
            </div>
            <table class="uk-table uk-table-small uk-table-divider uk-table-hover">
                <thead>
                    <tr><th>Program</th><th>Applications</th><th>Acceptance</th><th>Deadline</th><th></th></tr>
                </thead>
                <tbody>
                    <?php foreach ($programs as $program): ?>
                    <tr>
                        <td class="uk-text-bold"><?= e($program['name']) ?></td>
                        <td><?= number_format($program['applications']) ?></td>
                        <td><?= e($program['acceptance']) ?></td>
                        <td><?= e($program['deadline']) ?></td>
                        <td>
                            <a href="#" uk-icon="icon: more-vertical; ratio: 0.8"></a>
                            <div uk-dropdown="mode: click; pos: bottom-right">
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li><a href="#" uk-toggle="target: #edit-program-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit</a></li>
                                    <li><a href="#" uk-toggle="target: #view-program-applications-modal"><span uk-icon="icon: file-text; ratio: 0.8" class="uk-margin-small-right"></span> View Applications</a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-program-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Recent Applications -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Recent Applications</h4>
            <?php foreach ($recent_applications as $app): ?>
            <div class="uk-card uk-card-secondary uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold"><?= e($app['student']) ?></div>
                        <div class="uk-text-small"><?= e($app['program']) ?></div>
                        <div class="uk-text-small uk-text-muted">Submitted: <?= e($app['submitted']) ?></div>
                    </div>
                    <span class="uk-label uk-label-<?= $status_colors[$app['status']] ?>">
                        <?= str_replace('_', ' ', $app['status']) ?>
                    </span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Right Column -->
    <div class="uk-width-1-3@m">
        <!-- University Info -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title">University Info</h4>
            <dl class="uk-description-list">
                <dt>Total Applications</dt>
                <dd class="uk-text-bold"><?= number_format($university['applications']) ?></dd>
                <dt>Avg Acceptance Rate</dt>
                <dd class="uk-text-bold"><?= e($university['acceptance_rate']) ?></dd>
                <dt>Contact Email</dt>
                <dd><a href="mailto:<?= e($university['contact_email']) ?>"><?= e($university['contact_email']) ?></a></dd>
                <dt>Added</dt>
                <dd><?= e($university['added']) ?></dd>
            </dl>
        </div>

        <!-- Quick Stats -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Statistics</h4>
            <div class="uk-margin">
                <div class="uk-text-meta">This Month</div>
                <div class="uk-text-large uk-text-bold">89 applications</div>
            </div>
            <div class="uk-margin">
                <div class="uk-text-meta">Pending Review</div>
                <div class="uk-text-large uk-text-bold">34</div>
            </div>
            <div class="uk-margin">
                <div class="uk-text-meta">Interviews Scheduled</div>
                <div class="uk-text-large uk-text-bold">12</div>
            </div>
        </div>
    </div>
</div>

<!-- Edit University Modal -->
<div id="edit-university-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit University</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">University Name *</label>
                    <input class="uk-input" type="text" value="<?= e($university['name']) ?>" required>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Country *</label>
                        <input class="uk-input" type="text" value="<?= e($university['country']) ?>" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">City *</label>
                        <input class="uk-input" type="text" value="<?= e($university['city']) ?>" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Website</label>
                    <input class="uk-input" type="url" value="<?= e($university['website']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Contact Email</label>
                    <input class="uk-input" type="email" value="<?= e($university['contact_email']) ?>">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- Toggle Status Modal -->
<div id="toggle-status-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change University Status</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to <?= $university['active'] ? 'deactivate' : 'activate' ?> this university?</p>
            <?php if ($university['active']): ?>
            <p class="uk-text-muted uk-text-small">Deactivated universities will not appear in application options for students.</p>
            <?php else: ?>
            <p class="uk-text-muted uk-text-small">Activating this university will make it available for student applications.</p>
            <?php endif; ?>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-<?= $university['active'] ? 'warning' : 'success' ?>" type="button"><?= $university['active'] ? 'Deactivate' : 'Activate' ?></button>
        </div>
    </div>
</div>

<!-- Edit Program Modal -->
<div id="edit-program-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit Program</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Program Name *</label>
                    <input class="uk-input" type="text" value="Computer Science (MS)" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Degree Type *</label>
                    <select class="uk-select" required>
                        <option>Bachelor's</option>
                        <option selected>Master's</option>
                        <option>PhD</option>
                        <option>MBA</option>
                        <option>MD</option>
                    </select>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Application Deadline</label>
                        <input class="uk-input" type="date" value="2024-12-15">
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Tuition (USD)</label>
                        <input class="uk-input" type="number" value="50000">
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- View Program Applications Modal -->
<div id="view-program-applications-modal" uk-modal>
    <div class="uk-modal-dialog uk-width-large">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Program Applications</h2>
        </div>
        <div class="uk-modal-body">
            <table class="uk-table uk-table-small uk-table-divider">
                <thead>
                    <tr><th>Student</th><th>Status</th><th>Submitted</th></tr>
                </thead>
                <tbody>
                    <tr><td>John Doe</td><td><span class="uk-label uk-label-warning">Under Review</span></td><td>2024-01-30</td></tr>
                    <tr><td>Sarah Chen</td><td><span class="uk-label uk-label-success">Accepted</span></td><td>2024-01-28</td></tr>
                    <tr><td>Michael Rodriguez</td><td><span class="uk-label uk-label-primary">Interview</span></td><td>2024-01-25</td></tr>
                </tbody>
            </table>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Delete Program Modal -->
<div id="delete-program-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete Program</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p>This action cannot be undone. All application data for this program will be archived.</p>
            </div>
            <p>Are you sure you want to delete this program?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>

<!-- Add Program Modal -->
<div id="add-program-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add Program</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Program Name *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Computer Science (MS)" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Degree Type *</label>
                    <select class="uk-select" required>
                        <option value="">Select type...</option>
                        <option>Bachelor's</option>
                        <option>Master's</option>
                        <option>PhD</option>
                        <option>MBA</option>
                        <option>MD</option>
                    </select>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Application Deadline</label>
                        <input class="uk-input" type="date">
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Tuition (USD)</label>
                        <input class="uk-input" type="number" placeholder="0">
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="3" placeholder="Program description..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add Program</button>
        </div>
    </div>
</div>
