<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user_stats = [
    ['icon' => 'users', 'value' => '12,847', 'label' => 'Total Users', 'trend' => 12, 'color' => 'primary'],
    ['icon' => 'user', 'value' => '11,234', 'label' => 'Students', 'color' => 'success'],
    ['icon' => 'briefcase', 'value' => '1,456', 'label' => 'Counselors', 'color' => 'warning'],
    ['icon' => 'cog', 'value' => '157', 'label' => 'Staff', 'color' => 'purple']
];

$recent_users = [
    ['name' => 'Emily Zhang', 'email' => 'emily.z@email.com', 'role' => 'Student', 'joined' => '2024-01-30', 'status' => 'active'],
    ['name' => 'Carlos Martinez', 'email' => 'c.martinez@email.com', 'role' => 'Student', 'joined' => '2024-01-29', 'status' => 'active'],
    ['name' => 'Priya Sharma', 'email' => 'priya.s@gep.com', 'role' => 'Counselor', 'joined' => '2024-01-28', 'status' => 'pending'],
    ['name' => 'James Wilson', 'email' => 'james.w@email.com', 'role' => 'Student', 'joined' => '2024-01-27', 'status' => 'active']
];

render_stat_cards($user_stats);
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">User Management</h3>
    <div class="uk-flex uk-flex-wrap uk-flex-middle">
        <input class="uk-input uk-form-small uk-margin-small-right uk-margin-small-bottom" type="search" placeholder="Search users..." style="width: 160px;">
        <select class="uk-select uk-form-small uk-margin-small-right uk-margin-small-bottom" style="width: 100px;">
            <option>All Roles</option>
            <option>Students</option>
            <option>Counselors</option>
            <option>Admins</option>
        </select>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right uk-margin-small-bottom" uk-toggle="target: #export-users-modal">Export</button>
        <button class="uk-button uk-button-primary uk-button-small uk-margin-small-bottom" uk-toggle="target: #add-user-modal">Add User</button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <h4 class="uk-card-title">Recently Registered</h4>
    <div class="table-responsive">
    <table class="uk-table uk-table-divider uk-table-hover">
        <thead>
            <tr><th>Name</th><th>Email</th><th>Role</th><th>Joined</th><th>Status</th><th></th></tr>
        </thead>
        <tbody>
            <?php foreach ($recent_users as $user): ?>
            <tr>
                <td class="uk-text-bold"><?= e($user['name']) ?></td>
                <td><?= e($user['email']) ?></td>
                <td><span class="uk-label uk-label-secondary"><?= e($user['role']) ?></span></td>
                <td><?= e($user['joined']) ?></td>
                <td><span class="uk-label uk-label-<?= $user['status'] === 'active' ? 'success' : 'warning' ?>"><?= e($user['status']) ?></span></td>
                <td>
                    <a href="#" uk-icon="icon: more-vertical"></a>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li class="uk-nav-header">Actions</li>
                            <li><a href="#" uk-toggle="target: #view-profile-modal"><span uk-icon="icon: user; ratio: 0.8" class="uk-margin-small-right"></span> View Profile</a></li>
                            <li><a href="#" uk-toggle="target: #edit-user-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Edit User</a></li>
                            <li><a href="#" uk-toggle="target: #send-email-modal"><span uk-icon="icon: mail; ratio: 0.8" class="uk-margin-small-right"></span> Send Email</a></li>
                            <li><a href="#" uk-toggle="target: #reset-password-modal"><span uk-icon="icon: unlock; ratio: 0.8" class="uk-margin-small-right"></span> Reset Password</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#" uk-toggle="target: #toggle-user-modal"><span uk-icon="icon: ban; ratio: 0.8" class="uk-margin-small-right"></span> <?= $user['status'] === 'active' ? 'Disable' : 'Enable' ?> User</a></li>
                            <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-user-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete User</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    </div>
</div>

<!-- Export Users Modal -->
<div id="export-users-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Export Users</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>CSV</option>
                        <option>Excel</option>
                        <option>PDF</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Basic Info</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Contact Details</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Activity History</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Export</button>
        </div>
    </div>
</div>

<!-- Add User Modal -->
<div id="add-user-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add User</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">First Name *</label>
                        <input class="uk-input" type="text" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Last Name *</label>
                        <input class="uk-input" type="text" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email *</label>
                    <input class="uk-input" type="email" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Role *</label>
                    <select class="uk-select" required>
                        <option value="">Select role...</option>
                        <option>Student</option>
                        <option>Counselor</option>
                        <option>Admin</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add User</button>
        </div>
    </div>
</div>

<!-- View Profile Modal -->
<div id="view-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">User Profile</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-flex uk-flex-middle uk-margin-bottom">
                <div class="uk-border-circle uk-background-muted uk-flex uk-flex-center uk-flex-middle" style="width: 60px; height: 60px;">
                    <span uk-icon="icon: user; ratio: 1.5"></span>
                </div>
                <div class="uk-margin-left">
                    <div class="uk-text-bold">Emily Zhang</div>
                    <div class="uk-text-muted uk-text-small">emily.z@email.com</div>
                </div>
            </div>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Role</dt>
                <dd>Student</dd>
                <dt>Joined</dt>
                <dd>January 30, 2024</dd>
                <dt>Status</dt>
                <dd><span class="uk-label uk-label-success">Active</span></dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
        </div>
    </div>
</div>

<!-- Edit User Modal -->
<div id="edit-user-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit User</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">First Name *</label>
                        <input class="uk-input" type="text" value="Emily" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Last Name *</label>
                        <input class="uk-input" type="text" value="Zhang" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email *</label>
                    <input class="uk-input" type="email" value="emily.z@email.com" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Role *</label>
                    <select class="uk-select" required>
                        <option selected>Student</option>
                        <option>Counselor</option>
                        <option>Admin</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>

<!-- Send Email Modal -->
<div id="send-email-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Send Email</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="4" required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send</button>
        </div>
    </div>
</div>

<!-- Reset Password Modal -->
<div id="reset-password-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Reset Password</h2>
        </div>
        <div class="uk-modal-body">
            <p>Send a password reset link to this user?</p>
            <p class="uk-text-muted uk-text-small">The user will receive an email with instructions to reset their password.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send Reset Link</button>
        </div>
    </div>
</div>

<!-- Toggle User Modal -->
<div id="toggle-user-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change User Status</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to change this user's status?</p>
            <p class="uk-text-muted uk-text-small">Disabled users cannot log in to the system.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-warning" type="button">Change Status</button>
        </div>
    </div>
</div>

<!-- Delete User Modal -->
<div id="delete-user-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete User</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-danger">
                <p>This action cannot be undone. All user data will be permanently deleted.</p>
            </div>
            <p>Are you sure you want to delete this user?</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>
