<?php
if (!defined('APP_NAME')) {
    require_once __DIR__ . '/bootstrap.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($page_title ?? 'Counselor Portal') ?> - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">

    <!-- Chart & Map Libraries -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css">

    <style>
    /* Mobile Navigation */
    .mobile-nav-trigger {
        display: none;
        position: fixed;
        bottom: 20px;
        right: 20px;
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 50%;
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 24px;
        z-index: 999;
        border: none;
        cursor: pointer;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .mobile-nav-trigger:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 16px rgba(102, 126, 234, 0.5);
    }

    .mobile-nav-trigger.active {
        background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
    }

    @media (max-width: 959px) {
        .mobile-nav-trigger {
            display: flex;
        }

        .uk-navbar-center {
            display: none;
        }
    }

    /* Modern Tab Navigation */
    .uk-tab > * > a {
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .uk-tab > .uk-active > a {
        border-bottom: 3px solid #667eea;
    }

    /* Mobile Stack */
    @media (max-width: 640px) {
        .mobile-stack {
            flex-wrap: wrap;
            gap: 12px;
        }

        .mobile-stack > * {
            width: 100%;
        }

        .mobile-mb {
            margin-bottom: 12px;
        }
    }
    </style>
</head>
<body>
    <!-- Skip Link for Accessibility -->
    <a href="#main-content" class="skip-link">Skip to main content</a>

    <!-- Page Loading Indicator -->
    <div id="page-loader" class="page-loading" style="display: none;"></div>

    <!-- Toast Container -->
    <div id="toast-container" class="toast-container" aria-live="polite"></div>

    <!-- Modern Header -->
    <header class="uk-background-default" uk-sticky>
        <div class="uk-container uk-container-expand">
            <nav class="uk-navbar" uk-navbar>
                <div class="uk-navbar-left">
                    <a href="<?= BASE_URL ?>" class="uk-navbar-item uk-logo">
                        <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle" style="width: 32px; height: 32px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; font-size: 12px; font-weight: 600;">CP</span>
                        <span class="uk-margin-small-left uk-text-bold uk-visible@s"><?= APP_NAME ?></span>
                    </a>
                </div>

                <!-- Center Navigation (Desktop) -->
                <div class="uk-navbar-center uk-visible@m">
                    <ul class="uk-navbar-nav">
                        <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
                        <li class="<?= ($active_tab ?? 'overview') === $key ? 'uk-active' : '' ?>">
                            <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                               hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                               hx-target="#main-content"
                               hx-swap="innerHTML"
                               hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                                <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> fa-sm"></i>
                                <span class="uk-visible@l"><?= e($item['label']) ?></span>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <div class="uk-navbar-right">
                    <!-- Notifications Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link uk-position-relative">
                            <i class="fa-slab fa-solid fa-bell"></i>
                            <span class="uk-badge uk-position-top-right" style="font-size: 10px; padding: 2px 5px; background: #f0506e;">4</span>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <div class="uk-dropdown-nav">
                                <div class="uk-padding-small uk-flex uk-flex-between uk-flex-middle" style="border-bottom: 1px solid #e5e5e5;">
                                    <span class="uk-text-bold">Notifications</span>
                                    <a href="#" class="uk-text-small uk-text-primary">Mark all read</a>
                                </div>
                                <ul class="uk-nav uk-dropdown-nav" style="max-height: 300px; overflow-y: auto;">
                                    <li><a href="#">
                                        <div class="uk-text-small uk-text-bold"><i class="fa-slab fa-solid fa-user-plus fa-xs uk-text-primary"></i> New student assigned</div>
                                        <div class="uk-text-meta">David Kim - Fall 2024</div>
                                        <div class="uk-text-meta">30 minutes ago</div>
                                    </a></li>
                                    <li><a href="#">
                                        <div class="uk-text-small uk-text-bold"><i class="fa-slab fa-solid fa-calendar fa-xs uk-text-warning"></i> Meeting reminder</div>
                                        <div class="uk-text-meta">John Doe - Stanford Prep</div>
                                        <div class="uk-text-meta">1 hour ago</div>
                                    </a></li>
                                    <li><a href="#">
                                        <div class="uk-text-small uk-text-bold"><i class="fa-slab fa-solid fa-file-alt fa-xs uk-text-success"></i> Document needs review</div>
                                        <div class="uk-text-meta">Emma Wilson - Essay</div>
                                        <div class="uk-text-meta">2 hours ago</div>
                                    </a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li class="uk-text-center"><a href="<?= BASE_URL ?>/profile.php" class="uk-text-small">View all notifications</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Settings Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link"><i class="fa-slab fa-solid fa-cog"></i></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Settings</li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-sliders fa-fw"></i> General</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-lock fa-fw"></i> Security</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-bell fa-fw"></i> Notifications</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-calendar fa-fw"></i> Calendar Sync</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-question-circle fa-fw"></i> Help & Support</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#" onclick="toggleDarkMode(); return false;"><i class="fa-slab fa-solid fa-moon fa-fw"></i> <span id="theme-toggle-text">Dark Mode</span></a></li>
                            </ul>
                        </div>
                    </div>

                    <!-- Profile Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-flex uk-flex-middle">
                            <?= get_avatar($GLOBALS['current_user']['name'], 36) ?>
                            <div class="uk-margin-small-left uk-visible@m">
                                <div class="uk-text-bold uk-text-small"><?= e($GLOBALS['current_user']['name']) ?></div>
                                <div class="uk-text-meta uk-text-small"><?= e($GLOBALS['current_user']['role']) ?></div>
                            </div>
                            <i class="fa-slab fa-solid fa-chevron-down fa-xs uk-margin-small-left"></i>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Account</li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-user fa-fw"></i> My Profile</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-image fa-fw"></i> Change Avatar</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><i class="fa-slab fa-solid fa-key fa-fw"></i> Change Password</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/reports.php" hx-get="<?= BASE_URL ?>/pages/reports.php" hx-target="#main-content" hx-swap="innerHTML" hx-push-url="<?= BASE_URL ?>/reports.php"><i class="fa-slab fa-solid fa-chart-bar fa-fw"></i> My Reports</a></li>
                                <li><a href="<?= BASE_URL ?>/performance.php" hx-get="<?= BASE_URL ?>/pages/performance.php" hx-target="#main-content" hx-swap="innerHTML" hx-push-url="<?= BASE_URL ?>/performance.php"><i class="fa-slab fa-solid fa-star fa-fw"></i> Performance</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="/auth/login.php" class="uk-text-danger"><i class="fa-slab fa-solid fa-sign-out-alt fa-fw"></i> Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <hr class="uk-margin-remove">
    </header>

    <!-- Mobile Navigation Trigger -->
    <button class="mobile-nav-trigger" id="mobile-nav-trigger" uk-toggle="target: #mobile-nav">
        <i class="fa-slab fa-solid fa-bars"></i>
    </button>

    <!-- Mobile Navigation Offcanvas -->
    <div id="mobile-nav" uk-offcanvas="overlay: true">
        <div class="uk-offcanvas-bar uk-flex uk-flex-column">
            <button class="uk-offcanvas-close" type="button" uk-close></button>

            <div class="uk-margin-top">
                <div class="uk-flex uk-flex-middle uk-margin-bottom">
                    <?= get_avatar($GLOBALS['current_user']['name'], 48) ?>
                    <div class="uk-margin-small-left">
                        <div class="uk-text-bold"><?= e($GLOBALS['current_user']['name']) ?></div>
                        <div class="uk-text-meta uk-text-small"><?= e($GLOBALS['current_user']['role']) ?></div>
                    </div>
                </div>
            </div>

            <ul class="uk-nav uk-nav-primary uk-nav-center uk-margin-auto-vertical">
                <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
                <li class="<?= ($active_tab ?? 'overview') === $key ? 'uk-active' : '' ?>">
                    <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                       hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                       onclick="UIkit.offcanvas('#mobile-nav').hide();">
                        <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> fa-fw"></i> <?= e($item['label']) ?>
                    </a>
                </li>
                <?php endforeach; ?>
                <li class="uk-nav-divider"></li>
                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML" onclick="UIkit.offcanvas('#mobile-nav').hide();"><i class="fa-slab fa-solid fa-user fa-fw"></i> Profile</a></li>
                <li><a href="#" onclick="toggleDarkMode(); return false;"><i class="fa-slab fa-solid fa-moon fa-fw"></i> <span id="mobile-theme-toggle-text">Dark Mode</span></a></li>
                <li class="uk-nav-divider"></li>
                <li><a href="/auth/login.php" class="uk-text-danger"><i class="fa-slab fa-solid fa-sign-out-alt fa-fw"></i> Sign Out</a></li>
            </ul>
        </div>
    </div>

    <div class="uk-container uk-container-large uk-margin-medium-top uk-margin-large-bottom">
        <div class="uk-margin-medium-bottom">
            <h1 class="uk-heading-small uk-margin-remove-bottom"><?= e($page_title ?? 'Welcome back, Sarah!') ?></h1>
            <p class="uk-text-muted uk-margin-remove-top"><?= e($page_description ?? 'Manage your students and track their progress.') ?></p>
        </div>

        <!-- Tab Navigation (Desktop) -->
        <ul class="uk-tab uk-margin-medium-bottom uk-visible@m" uk-tab>
            <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
                <li class="<?= ($active_tab ?? 'overview') === $key ? 'uk-active' : '' ?>">
                    <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                       hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                        <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> fa-sm"></i> <?= e($item['label']) ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>

        <div id="main-content"><?php if (isset($content)) echo $content; ?></div>
    </div>

    <div id="modal-container"></div>

    <!-- Back to Top Button -->
    <button class="back-to-top" id="back-to-top" aria-label="Back to top" onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
        <i class="fa-slab fa-solid fa-chevron-up"></i>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>

    <!-- Chart & Map Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.0/dist/apexcharts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"></script>

    <script>
        // Toast Notification System
        function showToast(message, type = 'info', duration = 4000) {
            const container = document.getElementById('toast-container');
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.innerHTML = `<span>${message}</span>`;
            container.appendChild(toast);
            setTimeout(() => {
                toast.classList.add('hiding');
                setTimeout(() => toast.remove(), 300);
            }, duration);
        }

        // Dark Mode Toggle
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.getAttribute('data-theme') === 'dark';
            html.setAttribute('data-theme', isDark ? 'light' : 'dark');
            localStorage.setItem('theme', isDark ? 'light' : 'dark');
            const toggleText = document.getElementById('theme-toggle-text');
            const mobileToggleText = document.getElementById('mobile-theme-toggle-text');
            if (toggleText) toggleText.textContent = isDark ? 'Dark Mode' : 'Light Mode';
            if (mobileToggleText) mobileToggleText.textContent = isDark ? 'Dark Mode' : 'Light Mode';
        }

        // Initialize theme from localStorage
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
            const toggleText = document.getElementById('theme-toggle-text');
            const mobileToggleText = document.getElementById('mobile-theme-toggle-text');
            if (toggleText) toggleText.textContent = savedTheme === 'dark' ? 'Light Mode' : 'Dark Mode';
            if (mobileToggleText) mobileToggleText.textContent = savedTheme === 'dark' ? 'Light Mode' : 'Dark Mode';
        })();

        // Back to Top Button
        window.addEventListener('scroll', function() {
            const btn = document.getElementById('back-to-top');
            if (window.scrollY > 300) btn.classList.add('visible');
            else btn.classList.remove('visible');
        });

        // HTMX Loading Indicator
        document.body.addEventListener('htmx:beforeRequest', function() {
            document.getElementById('page-loader').style.display = 'block';
        });
        document.body.addEventListener('htmx:afterRequest', function() {
            document.getElementById('page-loader').style.display = 'none';
        });

        // Keyboard Shortcuts
        document.addEventListener('keydown', function(e) {
            if ((e.metaKey || e.ctrlKey) && e.key === 'k') {
                e.preventDefault();
                const searchInput = document.querySelector('input[type="search"], input[placeholder*="Search"]');
                if (searchInput) searchInput.focus();
            }
            if (e.key === 'Escape') {
                const modal = document.querySelector('.uk-modal.uk-open');
                if (modal) UIkit.modal(modal).hide();
            }
            if (e.key === '?' && !e.target.matches('input, textarea, select')) {
                showToast('Shortcuts: Ctrl+K = Search, Esc = Close modal', 'info', 5000);
            }
        });

        // Autosave for textareas
        document.querySelectorAll('textarea[data-autosave]').forEach(textarea => {
            const key = 'autosave_' + (textarea.id || textarea.name);
            const saved = localStorage.getItem(key);
            if (saved) textarea.value = saved;
            textarea.addEventListener('input', () => {
                localStorage.setItem(key, textarea.value);
            });
        });

        // Form submission feedback
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                const btn = form.querySelector('button[type="submit"]');
                if (btn) {
                    btn.disabled = true;
                    btn.innerHTML = '<span uk-spinner="ratio: 0.5"></span> Processing...';
                }
            });
        });

        // Add ARIA labels to icon-only buttons
        document.querySelectorAll('a[uk-icon], button[uk-icon]').forEach(el => {
            if (!el.getAttribute('aria-label') && !el.textContent.trim()) {
                const icon = el.getAttribute('uk-icon');
                if (icon) {
                    const match = icon.match(/icon:\s*([^;]+)/);
                    if (match) el.setAttribute('aria-label', match[1].trim());
                }
            }
        });
    </script>
</body>
</html>
