<?php
require_once __DIR__ . '/includes/bootstrap.php';
$page_title = 'Welcome back, Sarah!';
$page_description = 'Manage your students and track their progress.';
$active_tab = 'overview';
ob_start();

$stats = [
    ['icon' => 'users', 'value' => '45', 'label' => 'My Students', 'color' => 'primary'],
    ['icon' => 'file-text', 'value' => '89', 'label' => 'Active Applications', 'color' => 'success'],
    ['icon' => 'trending-up', 'value' => '92.5%', 'label' => 'Success Rate', 'color' => 'warning'],
    ['icon' => 'calendar', 'value' => '12', 'label' => 'Meetings This Week', 'color' => 'purple']
];

$messages = [
    ['name' => 'John Doe', 'subject' => 'Stanford Interview Preparation', 'preview' => 'Hi Sarah, I wanted to ask about the upcoming interview...', 'time' => '2 hours ago', 'unread' => true],
    ['name' => 'Sarah Chen', 'subject' => 'Document Submission', 'preview' => 'I have uploaded the requested financial documents...', 'time' => '5 hours ago', 'unread' => true],
    ['name' => 'Michael Rodriguez', 'subject' => 'Application Status Update', 'preview' => 'Could you please update me on my Toronto application...', 'time' => '1 day ago', 'unread' => false]
];

$meetings = [
    ['name' => 'John Doe', 'topic' => 'Interview Preparation', 'date' => '2024-02-05 at 14:00', 'duration' => '60 min', 'platform' => 'Zoom'],
    ['name' => 'Sarah Chen', 'topic' => 'Document Review', 'date' => '2024-02-03 at 10:00', 'duration' => '45 min', 'platform' => 'Google Meet'],
    ['name' => 'Emma Wilson', 'topic' => 'Initial Consultation', 'date' => '2024-02-06 at 16:00', 'duration' => '90 min', 'platform' => 'Zoom']
];

$tasks = [
    ['title' => 'Review John Doe\'s Stanford application', 'student' => 'John Doe', 'due' => '2024-02-05', 'priority' => 'high', 'status' => 'pending'],
    ['title' => 'Prepare visa documentation for Sarah Chen', 'student' => 'Sarah Chen', 'due' => '2024-02-10', 'priority' => 'medium', 'status' => 'in_progress'],
    ['title' => 'Follow up with Michael Rodriguez on revised documents', 'student' => 'Michael Rodriguez', 'due' => '2024-02-02', 'priority' => 'high', 'status' => 'overdue']
];

render_stat_cards($stats);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><span uk-icon="icon: comment"></span> Recent Messages</h4>
            <?php foreach ($messages as $msg): ?>
            <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between">
                    <div>
                        <div class="uk-text-bold"><?= e($msg['name']) ?> <?php if ($msg['unread']): ?><span class="uk-badge">new</span><?php endif; ?></div>
                        <div class="uk-text-small uk-text-bold"><?= e($msg['subject']) ?></div>
                        <div class="uk-text-muted uk-text-small"><?= e($msg['preview']) ?></div>
                    </div>
                    <div class="uk-text-muted uk-text-small"><?= e($msg['time']) ?></div>
                </div>
            </div>
            <?php endforeach; ?>
            <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top">
                <span uk-icon="icon: comment; ratio: 0.8"></span> View All Messages
            </button>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><span uk-icon="icon: calendar"></span> Upcoming Meetings</h4>
            <?php foreach ($meetings as $meeting): ?>
            <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div>
                        <div class="uk-text-bold"><?= e($meeting['name']) ?></div>
                        <div class="uk-text-muted uk-text-small"><?= e($meeting['topic']) ?></div>
                        <div class="uk-text-meta uk-text-small"><?= e($meeting['date']) ?> &middot; <?= e($meeting['duration']) ?></div>
                    </div>
                    <span class="uk-label uk-label-secondary"><?= e($meeting['platform']) ?></span>
                </div>
            </div>
            <?php endforeach; ?>
            <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top">
                <span uk-icon="icon: calendar; ratio: 0.8"></span> View Full Schedule
            </button>
        </div>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body uk-margin-top">
    <h4 class="uk-card-title">My Tasks</h4>
    <?php foreach ($tasks as $task): ?>
    <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div class="uk-flex uk-flex-middle">
                <span class="uk-margin-right" style="color: #1a1a1a;">&#8226;</span>
                <div>
                    <div class="uk-text-bold"><?= e($task['title']) ?></div>
                    <div class="uk-text-muted uk-text-small">Student: <?= e($task['student']) ?> &middot; Due: <?= e($task['due']) ?> <span class="uk-text-<?= $GLOBALS['priority_levels'][$task['priority']]['color'] ?>"><?= $GLOBALS['priority_levels'][$task['priority']]['label'] ?></span></div>
                </div>
            </div>
            <span class="uk-label uk-label-<?= $GLOBALS['task_statuses'][$task['status']]['color'] ?>"><?= $GLOBALS['task_statuses'][$task['status']]['label'] ?></span>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
