<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$app_id = $_GET['id'] ?? 'APP-001';

// Sample application data (would come from database in production)
$application = [
    'id' => $app_id,
    'student' => ['id' => 1, 'name' => 'John Doe', 'email' => 'john.doe@email.com', 'phone' => '+1 (555) 123-4567', 'initials' => 'JD'],
    'university' => 'Stanford University',
    'program' => 'Computer Science (MS)',
    'deadline' => '2024-02-15',
    'submitted' => '2024-01-30',
    'status' => 'under_review',
    'progress' => 65,
    'priority' => 'high'
];

$app_stats = [
    ['icon' => 'fa-percent', 'value' => '65%', 'label' => 'Progress', 'color' => '#667eea', 'color_dark' => '#5568d3'],
    ['icon' => 'fa-file-alt', 'value' => '3/4', 'label' => 'Documents', 'color' => '#32d296', 'color_dark' => '#28b67f'],
    ['icon' => 'fa-calendar-check', 'value' => '16', 'label' => 'Days Left', 'color' => '#faa05a', 'color_dark' => '#f48939'],
    ['icon' => 'fa-flag', 'value' => 'High', 'label' => 'Priority', 'color' => '#f0506e', 'color_dark' => '#e03e5c']
];

$documents = [
    ['name' => 'Transcript', 'status' => 'verified', 'uploaded' => '2024-01-25', 'icon' => 'fa-file-alt'],
    ['name' => 'Statement of Purpose', 'status' => 'verified', 'uploaded' => '2024-01-26', 'icon' => 'fa-file-text'],
    ['name' => 'Letter of Recommendation', 'status' => 'pending', 'uploaded' => '2024-01-28', 'icon' => 'fa-file-signature'],
    ['name' => 'English Proficiency Test', 'status' => 'missing', 'uploaded' => '-', 'icon' => 'fa-language']
];

$timeline = [
    ['date' => '2024-01-30', 'event' => 'Application submitted to Stanford', 'user' => 'John Doe', 'icon' => 'fa-paper-plane'],
    ['date' => '2024-01-28', 'event' => 'Documents uploaded successfully', 'user' => 'John Doe', 'icon' => 'fa-cloud-upload-alt'],
    ['date' => '2024-01-26', 'event' => 'Counselor assigned - Sarah Johnson', 'user' => 'System', 'icon' => 'fa-user-check'],
    ['date' => '2024-01-25', 'event' => 'Application created', 'user' => 'John Doe', 'icon' => 'fa-plus-circle']
];

$notes = [
    ['text' => 'Strong candidate - research background aligns well with program requirements. GPA 3.9, solid recommendation letters.', 'author' => 'You', 'date' => 'Jan 30', 'time' => '2:45 PM'],
    ['text' => 'Needs English proficiency scores before deadline. Reminded student via email.', 'author' => 'You', 'date' => 'Jan 28', 'time' => '10:30 AM']
];

$status_colors = ['submitted' => 'secondary', 'under_review' => 'warning', 'interview_scheduled' => 'primary', 'accepted' => 'success', 'rejected' => 'danger'];
$doc_status_colors = ['verified' => 'success', 'pending' => 'warning', 'missing' => 'danger'];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.app-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.app-icon-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 36px;
    color: white;
    border: 3px solid rgba(255, 255, 255, 0.3);
}

.app-id {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.9);
    font-weight: 500;
    margin-bottom: 4px;
}

.app-title {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.app-subtitle {
    font-size: 15px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 4px;
}

.app-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.2);
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #667eea;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.app-stat-card {
    border-radius: 12px;
    padding: 20px;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.app-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.stat-icon-small {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
    margin-bottom: 12px;
}

.stat-value-small {
    font-size: 24px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.stat-label-small {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    margin-top: 24px;
}

@media (min-width: 1200px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.document-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.document-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.document-item:last-child {
    margin-bottom: 0;
}

.doc-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.timeline-item {
    display: flex;
    gap: 16px;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.timeline-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.timeline-item:last-child {
    margin-bottom: 0;
}

.timeline-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
}

.note-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border-left: 3px solid #667eea;
}

.note-item:last-child {
    margin-bottom: 0;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status-success {
    background: #d1fae5;
    color: #065f46;
}

.status-warning {
    background: #fef3c7;
    color: #92400e;
}

.status-danger {
    background: #fee2e2;
    color: #991b1b;
}

.status-secondary {
    background: #e2e8f0;
    color: #475569;
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transition: width 0.3s ease;
}

.info-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.info-list dt {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
    margin-bottom: 4px;
}

.info-list dd {
    font-size: 15px;
    color: #1a1a1a;
    font-weight: 500;
    margin-bottom: 16px;
    margin-left: 0;
}

.info-list dd:last-child {
    margin-bottom: 0;
}

.student-chip {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
    border-radius: 8px;
    background: #f0f4ff;
    cursor: pointer;
    transition: all 0.2s ease;
}

.student-chip:hover {
    background: #e0e7ff;
    transform: translateX(2px);
}

.student-avatar-small {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 12px;
}

@media (max-width: 959px) {
    .app-header-card {
        padding: 24px;
    }

    .app-title {
        font-size: 22px;
    }

    .modern-btn {
        font-size: 13px;
        padding: 8px 16px;
    }

    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/applications.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/applications.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to Applications
</a>

<!-- Application Header -->
<div class="app-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="app-icon-large">
                <i class="fa-slab fa-solid fa-graduation-cap"></i>
            </div>
            <div>
                <div class="app-id"><?= e($application['id']) ?></div>
                <h2 class="app-title"><?= e($application['university']) ?></h2>
                <div class="app-subtitle"><?= e($application['program']) ?></div>
                <div>
                    <span class="app-badge"><?= ucfirst($application['status']) ?></span>
                    <span class="app-badge"><?= ucfirst($application['priority']) ?> Priority</span>
                </div>
            </div>
        </div>
        <div style="display: flex; gap: 12px;">
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-envelope"></i> Message Student
            </button>
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-edit"></i> Update Status
            </button>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <?php foreach ($app_stats as $stat): ?>
    <div class="app-stat-card">
        <div class="stat-icon-small" style="background: linear-gradient(135deg, <?= $stat['color'] ?> 0%, <?= $stat['color_dark'] ?> 100%);">
            <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
        </div>
        <div class="stat-value-small"><?= e($stat['value']) ?></div>
        <div class="stat-label-small"><?= e($stat['label']) ?></div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Left Column -->
    <div>
        <!-- Progress Bar -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-tasks"></i> Application Progress
            </h4>
            <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
                <span style="font-weight: 600; color: #1a1a1a;">Overall Progress</span>
                <span style="font-weight: 700; color: #667eea;"><?= $application['progress'] ?>%</span>
            </div>
            <div class="progress-bar">
                <div class="progress-fill" style="width: <?= $application['progress'] ?>%;"></div>
            </div>
        </div>

        <!-- Documents -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-folder-open"></i> Documents
            </h4>
            <?php foreach ($documents as $doc): ?>
            <div class="document-item">
                <div style="display: flex; align-items: center; justify-content: space-between; gap: 12px;">
                    <div style="display: flex; align-items: center; gap: 12px; flex: 1;">
                        <div class="doc-icon">
                            <i class="fa-slab fa-solid <?= $doc['icon'] ?>"></i>
                        </div>
                        <div>
                            <div style="font-weight: 600; color: #1a1a1a; font-size: 14px; margin-bottom: 2px;">
                                <?= e($doc['name']) ?>
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                <?php if ($doc['uploaded'] !== '-'): ?>
                                    Uploaded: <?= date('M d, Y', strtotime($doc['uploaded'])) ?>
                                <?php else: ?>
                                    Not uploaded yet
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <span class="status-badge status-<?= $doc_status_colors[$doc['status']] ?>">
                        <?= e($doc['status']) ?>
                    </span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Timeline -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-history"></i> Activity Timeline
            </h4>
            <?php foreach ($timeline as $item): ?>
            <div class="timeline-item">
                <div class="timeline-icon">
                    <i class="fa-slab fa-solid <?= $item['icon'] ?>"></i>
                </div>
                <div style="flex: 1;">
                    <div style="font-size: 14px; color: #1a1a1a; font-weight: 500;"><?= e($item['event']) ?></div>
                    <div style="font-size: 12px; color: #94a3b8; margin-top: 2px;">
                        <?= date('M d, Y', strtotime($item['date'])) ?> • <?= e($item['user']) ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Counselor Notes -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-sticky-note"></i> Counselor Notes
            </h4>
            <?php foreach ($notes as $note): ?>
            <div class="note-item">
                <div style="font-size: 14px; color: #1a1a1a; margin-bottom: 6px;"><?= e($note['text']) ?></div>
                <div style="font-size: 12px; color: #94a3b8;">
                    <?= e($note['author']) ?> • <?= e($note['date']) ?> at <?= e($note['time']) ?>
                </div>
            </div>
            <?php endforeach; ?>
            <div style="margin-top: 16px;">
                <textarea class="uk-textarea" rows="3" placeholder="Add a new note..."></textarea>
                <button class="uk-button uk-button-primary uk-button-small" style="margin-top: 8px;">
                    <i class="fa-slab fa-solid fa-plus"></i> Add Note
                </button>
            </div>
        </div>
    </div>

    <!-- Right Column -->
    <div>
        <!-- Student Information -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-user"></i> Student Information
            </h4>
            <div class="student-chip"
                 hx-get="<?= BASE_URL ?>/pages/student-detail.php?id=<?= $application['student']['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/student-detail.php?id=<?= $application['student']['id'] ?>">
                <div class="student-avatar-small"><?= $application['student']['initials'] ?></div>
                <div>
                    <div style="font-weight: 600; color: #1a1a1a; font-size: 14px;"><?= e($application['student']['name']) ?></div>
                    <div style="font-size: 12px; color: #64748b;"><?= e($application['student']['email']) ?></div>
                </div>
            </div>

            <dl class="info-list" style="margin-top: 20px;">
                <dt>Email</dt>
                <dd><i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($application['student']['email']) ?></dd>

                <dt>Phone</dt>
                <dd><i class="fa-slab fa-solid fa-phone fa-sm"></i> <?= e($application['student']['phone']) ?></dd>

                <dt>View Profile</dt>
                <dd>
                    <a href="#"
                       hx-get="<?= BASE_URL ?>/pages/student-detail.php?id=<?= $application['student']['id'] ?>"
                       hx-target="#main-content"
                       hx-swap="innerHTML"
                       hx-push-url="<?= BASE_URL ?>/student-detail.php?id=<?= $application['student']['id'] ?>"
                       style="color: #667eea; text-decoration: none;">
                        <i class="fa-slab fa-solid fa-arrow-right"></i> View full profile
                    </a>
                </dd>
            </dl>
        </div>

        <!-- Application Details -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-info-circle"></i> Application Details
            </h4>
            <dl class="info-list">
                <dt>Application ID</dt>
                <dd><code style="background: #f8fafc; padding: 4px 8px; border-radius: 4px;"><?= e($application['id']) ?></code></dd>

                <dt>Deadline</dt>
                <dd><i class="fa-slab fa-solid fa-calendar fa-sm"></i> <?= date('M d, Y', strtotime($application['deadline'])) ?></dd>

                <dt>Submitted</dt>
                <dd><i class="fa-slab fa-solid fa-calendar-check fa-sm"></i> <?= date('M d, Y', strtotime($application['submitted'])) ?></dd>

                <dt>Status</dt>
                <dd>
                    <span class="status-badge status-<?= $status_colors[$application['status']] ?>">
                        <?= str_replace('_', ' ', $application['status']) ?>
                    </span>
                </dd>

                <dt>Priority Level</dt>
                <dd>
                    <span class="status-badge <?= $application['priority'] === 'high' ? 'status-danger' : ($application['priority'] === 'medium' ? 'status-warning' : 'status-success') ?>">
                        <?= ucfirst($application['priority']) ?>
                    </span>
                </dd>
            </dl>
        </div>

        <!-- Quick Actions -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-bolt"></i> Quick Actions
            </h4>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-envelope fa-fw"></i> Message Student
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-calendar fa-fw"></i> Schedule Meeting
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-edit fa-fw"></i> Update Status
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-download fa-fw"></i> Export PDF
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components for dynamically loaded content
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
