<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$applications = [
    ['id' => 'APP-001', 'student' => 'John Doe', 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'deadline' => '2024-02-15', 'status' => 'under_review', 'priority' => 'high'],
    ['id' => 'APP-002', 'student' => 'Sarah Chen', 'university' => 'MIT', 'program' => 'Engineering (MS)', 'deadline' => '2024-02-20', 'status' => 'interview_scheduled', 'priority' => 'high'],
    ['id' => 'APP-003', 'student' => 'Michael Rodriguez', 'university' => 'Harvard University', 'program' => 'Business Administration (MBA)', 'deadline' => '2024-02-10', 'status' => 'accepted', 'priority' => 'medium'],
    ['id' => 'APP-004', 'student' => 'Emma Wilson', 'university' => 'University of Cambridge', 'program' => 'Economics (PhD)', 'deadline' => '2024-03-01', 'status' => 'submitted', 'priority' => 'low'],
    ['id' => 'APP-005', 'student' => 'David Kim', 'university' => 'UC Berkeley', 'program' => 'Data Science (MS)', 'deadline' => '2024-02-08', 'status' => 'under_review', 'priority' => 'high']
];

$status_config = [
    'submitted' => ['label' => 'Submitted', 'color' => '#94a3b8', 'icon' => 'fa-paper-plane'],
    'under_review' => ['label' => 'Under Review', 'color' => '#faa05a', 'icon' => 'fa-search'],
    'interview_scheduled' => ['label' => 'Interview Scheduled', 'color' => '#667eea', 'icon' => 'fa-calendar-check'],
    'accepted' => ['label' => 'Accepted', 'color' => '#32d296', 'icon' => 'fa-check-circle'],
    'rejected' => ['label' => 'Rejected', 'color' => '#f0506e', 'icon' => 'fa-times-circle']
];

$priority_config = [
    'high' => ['label' => 'High', 'color' => '#f0506e'],
    'medium' => ['label' => 'Medium', 'color' => '#faa05a'],
    'low' => ['label' => 'Low', 'color' => '#32d296']
];
?>

<style>
.application-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.2s ease;
    border-left: 4px solid transparent;
}

.application-card:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
}

.application-card.priority-high {
    border-left-color: #f0506e;
}

.application-card.priority-medium {
    border-left-color: #faa05a;
}

.application-card.priority-low {
    border-left-color: #32d296;
}

.app-header {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: 12px;
}

.app-id {
    font-size: 12px;
    font-weight: 600;
    color: #667eea;
    background: #f0f4ff;
    padding: 4px 10px;
    border-radius: 6px;
}

.app-student {
    font-size: 16px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.app-university {
    font-size: 14px;
    font-weight: 500;
    color: #334155;
    margin-bottom: 4px;
}

.app-program {
    font-size: 13px;
    color: #64748b;
    margin-bottom: 12px;
}

.app-meta {
    display: flex;
    align-items: center;
    gap: 16px;
    flex-wrap: wrap;
    margin-bottom: 12px;
}

.app-meta-item {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    color: #64748b;
}

.status-badge-app {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 600;
    color: white;
}

.priority-badge-app {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.app-actions {
    display: flex;
    gap: 8px;
    margin-top: 12px;
    padding-top: 12px;
    border-top: 1px solid #e2e8f0;
}

.app-action-btn {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.app-action-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.app-action-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.app-action-secondary {
    background: #f1f5f9;
    color: #475569;
}

.app-action-secondary:hover {
    background: #e2e8f0;
}

.filter-bar {
    background: white;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.filter-select {
    padding: 8px 12px;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 13px;
    background: white;
    transition: all 0.2s ease;
}

.filter-select:focus {
    outline: none;
    border-color: #667eea;
}

.action-button {
    padding: 8px 16px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.action-button-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.action-button-secondary {
    background: #f1f5f9;
    color: #475569;
}

.action-button-secondary:hover {
    background: #e2e8f0;
}

@media (max-width: 959px) {
    .application-card {
        padding: 16px;
    }

    .app-actions {
        flex-wrap: wrap;
    }

    .filter-bar {
        padding: 12px;
    }
}
</style>

<!-- Header with Filters and Actions -->
<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-file-alt"></i> Student Applications (<?= count($applications) ?>)
    </h3>
    <button class="action-button action-button-secondary mobile-full" uk-toggle="target: #export-applications-modal">
        <i class="fa-slab fa-solid fa-download"></i> Export
    </button>
</div>

<!-- Filter Bar -->
<div class="filter-bar">
    <div class="uk-flex uk-flex-between uk-flex-middle mobile-stack" style="gap: 12px;">
        <div class="uk-flex uk-flex-middle mobile-stack" style="gap: 12px; flex: 1;">
            <select class="filter-select mobile-full">
                <option>All Status</option>
                <option>Submitted</option>
                <option>Under Review</option>
                <option>Interview Scheduled</option>
                <option>Accepted</option>
                <option>Rejected</option>
            </select>
            <select class="filter-select mobile-full">
                <option>All Priorities</option>
                <option>High Priority</option>
                <option>Medium Priority</option>
                <option>Low Priority</option>
            </select>
            <select class="filter-select mobile-full">
                <option>All Students</option>
                <option>John Doe</option>
                <option>Sarah Chen</option>
                <option>Michael Rodriguez</option>
                <option>Emma Wilson</option>
                <option>David Kim</option>
            </select>
        </div>
        <button class="action-button-secondary mobile-full" onclick="resetFilters()">
            <i class="fa-slab fa-solid fa-redo"></i> Reset
        </button>
    </div>
</div>

<!-- Application Cards -->
<?php foreach ($applications as $app):
    $status = $status_config[$app['status']];
    $priority = $priority_config[$app['priority']];
?>
<div class="application-card priority-<?= $app['priority'] ?>">
    <div class="app-header">
        <span class="app-id"><i class="fa-slab fa-solid fa-hashtag"></i> <?= e($app['id']) ?></span>
        <span class="priority-badge-app" style="background: <?= $priority['color'] ?>20; color: <?= $priority['color'] ?>;">
            <?= $priority['label'] ?> Priority
        </span>
    </div>

    <div class="app-student"><?= e($app['student']) ?></div>
    <div class="app-university"><i class="fa-slab fa-solid fa-university"></i> <?= e($app['university']) ?></div>
    <div class="app-program"><?= e($app['program']) ?></div>

    <div class="app-meta">
        <div class="app-meta-item">
            <i class="fa-slab fa-solid fa-calendar-alt"></i>
            <span>Deadline: <strong><?= e($app['deadline']) ?></strong></span>
        </div>
        <span class="status-badge-app" style="background: <?= $status['color'] ?>;">
            <i class="fa-slab fa-solid <?= $status['icon'] ?>"></i>
            <?= $status['label'] ?>
        </span>
    </div>

    <div class="app-actions">
        <button class="app-action-btn app-action-primary"
                onclick="window.location.href='<?= BASE_URL ?>/pages/application-detail.php?id=<?= e($app['id']) ?>'"
                hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= e($app['id']) ?>"
                hx-target="#main-content"
                hx-swap="innerHTML">
            <i class="fa-slab fa-solid fa-eye"></i> Review
        </button>
        <button class="app-action-btn app-action-secondary" uk-toggle="target: #message-student-modal">
            <i class="fa-slab fa-solid fa-envelope"></i> Message
        </button>
        <button class="app-action-btn app-action-secondary" uk-toggle="target: #update-status-modal">
            <i class="fa-slab fa-solid fa-tag"></i> Status
        </button>
        <button class="app-action-btn app-action-secondary" uk-toggle="target: #add-notes-modal">
            <i class="fa-slab fa-solid fa-sticky-note"></i> Notes
        </button>
        <button class="app-action-btn app-action-secondary" uk-toggle="target: #request-documents-modal">
            <i class="fa-slab fa-solid fa-file-upload"></i> Documents
        </button>
    </div>
</div>
<?php endforeach; ?>

<!-- Export Applications Modal -->
<div id="export-applications-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-download"></i> Export Applications</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Format</label>
                    <select class="uk-select">
                        <option>Excel</option>
                        <option>CSV</option>
                        <option>PDF</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Include</label>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Basic Info</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox" checked> Status History</label>
                    </div>
                    <div class="uk-margin-small">
                        <label><input class="uk-checkbox" type="checkbox"> Notes</label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-download"></i> Export
            </button>
        </div>
    </div>
</div>

<!-- Message Student Modal -->
<div id="message-student-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-envelope"></i> Message Student</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Subject *</label>
                    <input class="uk-input" type="text" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="4" required></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-paper-plane"></i> Send
            </button>
        </div>
    </div>
</div>

<!-- Update Status Modal -->
<div id="update-status-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-tag"></i> Update Status</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New Status *</label>
                    <select class="uk-select" required>
                        <option value="">Select status...</option>
                        <option>Submitted</option>
                        <option>Under Review</option>
                        <option>Interview Scheduled</option>
                        <option>Accepted</option>
                        <option>Rejected</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Optional notes about this status change"></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Update
            </button>
        </div>
    </div>
</div>

<!-- Add Notes Modal -->
<div id="add-notes-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-sticky-note"></i> Add Notes</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Note *</label>
                    <textarea class="uk-textarea" rows="4" required></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> <i class="fa-slab fa-solid fa-star"></i> Mark as important</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-save"></i> Save Note
            </button>
        </div>
    </div>
</div>

<!-- Request Documents Modal -->
<div id="request-documents-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-file-upload"></i> Request Documents</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Document Type *</label>
                    <select class="uk-select" required>
                        <option value="">Select type...</option>
                        <option>Transcript</option>
                        <option>Test Scores</option>
                        <option>Letter of Recommendation</option>
                        <option>Financial Documents</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Additional details about the required document"></textarea>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Deadline</label>
                    <input class="uk-input" type="date">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-paper-plane"></i> Send Request
            </button>
        </div>
    </div>
</div>

<script>
function resetFilters() {
    document.querySelectorAll('.filter-select').forEach(select => {
        select.selectedIndex = 0;
    });
}
</script>
