<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$conversations = [
    ['id' => 1, 'name' => 'John Doe', 'last_message' => 'Thank you for the feedback on my essay!', 'time' => '30 min ago', 'unread' => 2],
    ['id' => 2, 'name' => 'Sarah Chen', 'last_message' => 'When can we discuss the MIT application?', 'time' => '2 hours ago', 'unread' => 1],
    ['id' => 3, 'name' => 'Emma Wilson', 'last_message' => 'I\'ve uploaded the updated documents.', 'time' => '5 hours ago', 'unread' => 0],
    ['id' => 4, 'name' => 'Admin Support', 'last_message' => 'New application assignment notification', 'time' => '1 day ago', 'unread' => 0],
    ['id' => 5, 'name' => 'David Kim', 'last_message' => 'Looking forward to our meeting tomorrow.', 'time' => '2 days ago', 'unread' => 0]
];

$active_chat = [
    'name' => 'John Doe',
    'messages' => [
        ['from' => 'student', 'text' => 'Hi! I wanted to follow up on my Stanford application.', 'time' => '10:30 AM'],
        ['from' => 'me', 'text' => 'Hello John! Your application is progressing well. The academic review is in progress.', 'time' => '10:45 AM'],
        ['from' => 'student', 'text' => 'That\'s great news! Is there anything else I need to submit?', 'time' => '11:00 AM'],
        ['from' => 'me', 'text' => 'Just waiting on your English proficiency scores. Please upload those when available.', 'time' => '11:15 AM'],
        ['from' => 'student', 'text' => 'Thank you for the feedback on my essay!', 'time' => '11:30 AM']
    ]
];
?>

<style>
.messages-container {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.conversation-list {
    border-right: 1px solid #e2e8f0;
    height: 600px;
    overflow-y: auto;
}

.conversation-item {
    padding: 16px;
    cursor: pointer;
    transition: all 0.2s ease;
    border-left: 3px solid transparent;
}

.conversation-item:hover {
    background: #f8fafc;
    border-left-color: #667eea;
}

.conversation-item.active {
    background: #f0f4ff;
    border-left-color: #667eea;
}

.conversation-item.unread {
    background: #eff6ff;
}

.conversation-avatar {
    width: 44px;
    height: 44px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 16px;
    flex-shrink: 0;
}

.conversation-name {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.conversation-preview {
    font-size: 13px;
    color: #64748b;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.conversation-time {
    font-size: 11px;
    color: #94a3b8;
}

.unread-badge {
    background: #667eea;
    color: white;
    border-radius: 10px;
    padding: 2px 8px;
    font-size: 11px;
    font-weight: 600;
}

.chat-header {
    padding: 16px 20px;
    border-bottom: 1px solid #e2e8f0;
    background: white;
}

.chat-messages {
    height: 450px;
    overflow-y: auto;
    padding: 20px;
    background: #f8fafc;
}

.message-bubble {
    max-width: 70%;
    padding: 12px 16px;
    border-radius: 16px;
    margin-bottom: 12px;
    word-wrap: break-word;
}

.message-student {
    background: white;
    border: 1px solid #e2e8f0;
    color: #1a1a1a;
    border-bottom-left-radius: 4px;
}

.message-me {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    margin-left: auto;
    border-bottom-right-radius: 4px;
}

.message-time {
    font-size: 11px;
    opacity: 0.7;
    margin-top: 4px;
}

.chat-input-container {
    padding: 16px 20px;
    border-top: 1px solid #e2e8f0;
    background: white;
}

.chat-input {
    padding: 10px 16px;
    border: 2px solid #e2e8f0;
    border-radius: 24px;
    font-size: 14px;
    flex: 1;
    transition: all 0.2s ease;
}

.chat-input:focus {
    outline: none;
    border-color: #667eea;
}

.send-button {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
}

.send-button:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.action-icon {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s ease;
    color: #64748b;
}

.action-icon:hover {
    background: #f1f5f9;
    color: #667eea;
}

.search-conversations {
    padding: 10px 16px 10px 40px;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 13px;
    width: 100%;
    transition: all 0.2s ease;
}

.search-conversations:focus {
    outline: none;
    border-color: #667eea;
}

.search-icon-container {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #94a3b8;
}

@media (max-width: 959px) {
    .conversation-list {
        height: auto;
        border-right: none;
        border-bottom: 1px solid #e2e8f0;
    }

    .chat-messages {
        height: 350px;
    }

    .message-bubble {
        max-width: 85%;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-envelope"></i> Messages
    </h3>
    <button class="uk-button uk-button-primary uk-button-small mobile-full" uk-toggle="target: #new-message-modal">
        <i class="fa-slab fa-solid fa-plus"></i> New Message
    </button>
</div>

<div class="messages-container">
    <div class="uk-grid-collapse" uk-grid>
        <!-- Conversations List -->
        <div class="uk-width-1-3@m">
            <div class="conversation-list">
                <div style="padding: 16px; position: relative;">
                    <i class="fa-slab fa-solid fa-search search-icon-container"></i>
                    <input class="search-conversations" type="search" placeholder="Search conversations...">
                </div>
                <?php foreach ($conversations as $i => $conv):
                    $initials = strtoupper(substr($conv['name'], 0, 1) . (strpos($conv['name'], ' ') !== false ? substr(strstr($conv['name'], ' '), 1, 1) : ''));
                ?>
                <div class="conversation-item <?= $conv['unread'] > 0 ? 'unread' : '' ?> <?= $i === 0 ? 'active' : '' ?>">
                    <div class="uk-flex uk-flex-between uk-flex-top" style="gap: 12px;">
                        <div class="uk-flex uk-flex-top" style="flex: 1; gap: 12px; min-width: 0;">
                            <div class="conversation-avatar"><?= $initials ?></div>
                            <div style="flex: 1; min-width: 0;">
                                <div class="conversation-name"><?= e($conv['name']) ?></div>
                                <div class="conversation-preview"><?= e($conv['last_message']) ?></div>
                            </div>
                        </div>
                        <div class="uk-flex uk-flex-column uk-flex-middle" style="gap: 4px;">
                            <div class="conversation-time"><?= e($conv['time']) ?></div>
                            <?php if ($conv['unread'] > 0): ?>
                                <span class="unread-badge"><?= $conv['unread'] ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Active Chat -->
        <div class="uk-width-2-3@m">
            <!-- Chat Header -->
            <div class="chat-header">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-flex uk-flex-middle" style="gap: 12px;">
                        <div class="conversation-avatar">
                            <?= strtoupper(substr($active_chat['name'], 0, 1) . substr(strstr($active_chat['name'], ' '), 1, 1)) ?>
                        </div>
                        <div>
                            <div class="uk-text-bold" style="color: #1a1a1a;"><?= e($active_chat['name']) ?></div>
                            <div class="uk-text-small" style="color: #32d296;">
                                <i class="fa-slab fa-solid fa-circle" style="font-size: 6px;"></i> Online
                            </div>
                        </div>
                    </div>
                    <div class="uk-flex uk-flex-middle" style="gap: 8px;">
                        <div class="action-icon" uk-tooltip="Call">
                            <i class="fa-slab fa-solid fa-phone"></i>
                        </div>
                        <div class="action-icon" uk-tooltip="Video Call">
                            <i class="fa-slab fa-solid fa-video"></i>
                        </div>
                        <div class="action-icon" uk-tooltip="More Options">
                            <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Messages -->
            <div class="chat-messages">
                <?php foreach ($active_chat['messages'] as $msg): ?>
                <div class="uk-flex <?= $msg['from'] === 'me' ? 'uk-flex-right' : '' ?>">
                    <div class="message-bubble message-<?= $msg['from'] ?>">
                        <div><?= e($msg['text']) ?></div>
                        <div class="message-time"><?= e($msg['time']) ?></div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <!-- Input -->
            <div class="chat-input-container">
                <form class="uk-flex uk-flex-middle" style="gap: 12px;">
                    <div class="action-icon">
                        <i class="fa-slab fa-solid fa-paperclip"></i>
                    </div>
                    <input class="chat-input" type="text" placeholder="Type a message...">
                    <button class="send-button" type="button">
                        <i class="fa-slab fa-solid fa-paper-plane"></i>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- New Message Modal -->
<div id="new-message-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-envelope"></i> New Message</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">To</label>
                    <select class="uk-select">
                        <option value="">Select recipient...</option>
                        <option>John Doe (Student)</option>
                        <option>Sarah Chen (Student)</option>
                        <option>Emma Wilson (Student)</option>
                        <option>David Kim (Student)</option>
                        <option>Admin Support</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message</label>
                    <textarea class="uk-textarea" rows="4" placeholder="Type your message..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-paper-plane"></i> Send
            </button>
        </div>
    </div>
</div>
