<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$students = [
    ['id' => 1, 'name' => 'John Doe', 'email' => 'john.doe@email.com', 'applications' => 3, 'status' => 'active', 'last_contact' => '2024-01-30', 'progress' => 65],
    ['id' => 2, 'name' => 'Sarah Chen', 'email' => 'sarah.chen@email.com', 'applications' => 2, 'status' => 'active', 'last_contact' => '2024-01-28', 'progress' => 80],
    ['id' => 3, 'name' => 'Michael Rodriguez', 'email' => 'michael.r@email.com', 'applications' => 4, 'status' => 'active', 'last_contact' => '2024-01-25', 'progress' => 100],
    ['id' => 4, 'name' => 'Emma Wilson', 'email' => 'emma.w@email.com', 'applications' => 1, 'status' => 'inactive', 'last_contact' => '2024-01-10', 'progress' => 30]
];

$stats = [
    ['icon' => 'users', 'value' => count($students), 'label' => 'Total Students', 'color' => 'primary'],
    ['icon' => 'check', 'value' => '12', 'label' => 'Applications Completed', 'color' => 'success'],
    ['icon' => 'clock', 'value' => '5', 'label' => 'Pending Reviews', 'color' => 'warning']
];

render_stat_cards($stats, 3);
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom uk-margin-top">
    <h3 class="uk-margin-remove">My Students</h3>
    <div>
        <button class="uk-button uk-button-primary uk-button-small uk-margin-small-right" uk-toggle="target: #add-student-modal">
            <span uk-icon="icon: plus; ratio: 0.8"></span> Add Student
        </button>
        <input class="uk-input uk-form-small" type="search" placeholder="Search students..." style="width: 200px;"
               _="on keyup
                  set query to my value.toLowerCase()
                  for row in #students-table tbody tr
                    if row.textContent.toLowerCase().indexOf(query) >= 0
                      remove .uk-hidden from row
                    else
                      add .uk-hidden to row
                    end
                  end">
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <table id="students-table" class="uk-table uk-table-divider uk-table-hover uk-table-middle">
        <thead>
            <tr>
                <th>Student</th>
                <th>Applications</th>
                <th>Progress</th>
                <th>Last Contact</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($students as $student): ?>
            <tr>
                <td>
                    <div class="uk-flex uk-flex-middle">
                        <?= get_avatar($student['name'], 36) ?>
                        <div class="uk-margin-small-left">
                            <div class="uk-text-bold"><?= e($student['name']) ?></div>
                            <div class="uk-text-small uk-text-muted"><?= e($student['email']) ?></div>
                        </div>
                    </div>
                </td>
                <td><?= e($student['applications']) ?></td>
                <td>
                    <div class="uk-flex uk-flex-middle">
                        <progress class="uk-progress uk-margin-remove" value="<?= $student['progress'] ?>" max="100" style="width: 80px;"></progress>
                        <span class="uk-text-small uk-margin-small-left"><?= $student['progress'] ?>%</span>
                    </div>
                </td>
                <td><?= e($student['last_contact']) ?></td>
                <td>
                    <span class="uk-label uk-label-<?= $student['status'] === 'active' ? 'success' : 'danger' ?>">
                        <?= e($student['status']) ?>
                    </span>
                </td>
                <td>
                    <a href="#" uk-icon="icon: more-vertical"></a>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li class="uk-nav-header">Actions</li>
                            <li><a href="<?= BASE_URL ?>/pages/student-detail.php?id=<?= $student['id'] ?>"
                                   hx-get="<?= BASE_URL ?>/pages/student-detail.php?id=<?= $student['id'] ?>"
                                   hx-target="#main-content"
                                   hx-swap="innerHTML"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> View Profile</a></li>
                            <li><a href="#"><span uk-icon="icon: mail; ratio: 0.8" class="uk-margin-small-right"></span> Send Message</a></li>
                            <li><a href="#"><span uk-icon="icon: calendar; ratio: 0.8" class="uk-margin-small-right"></span> Schedule Meeting</a></li>
                            <li><a href="#"><span uk-icon="icon: comment; ratio: 0.8" class="uk-margin-small-right"></span> Add Note</a></li>
                            <li><a href="#"><span uk-icon="icon: file-text; ratio: 0.8" class="uk-margin-small-right"></span> View Applications</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#"><span uk-icon="icon: move; ratio: 0.8" class="uk-margin-small-right"></span> Transfer Student</a></li>
                            <li><a href="#" class="uk-text-danger"><span uk-icon="icon: close; ratio: 0.8" class="uk-margin-small-right"></span> Remove from List</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Add Student Modal -->
<div id="add-student-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Add New Student</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">First Name *</label>
                        <input class="uk-input" type="text" placeholder="John" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Last Name *</label>
                        <input class="uk-input" type="text" placeholder="Doe" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Address *</label>
                    <input class="uk-input" type="email" placeholder="student@example.com" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Phone Number</label>
                    <input class="uk-input" type="tel" placeholder="+1 (555) 123-4567">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Target Study Destination</label>
                    <select class="uk-select">
                        <option value="">Select country</option>
                        <option>United States</option>
                        <option>United Kingdom</option>
                        <option>Canada</option>
                        <option>Australia</option>
                        <option>Germany</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Intended Program</label>
                    <select class="uk-select">
                        <option value="">Select program type</option>
                        <option>Bachelor's Degree</option>
                        <option>Master's Degree</option>
                        <option>PhD</option>
                        <option>MBA</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Initial consultation notes..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> Send welcome email to student</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Add Student</button>
        </div>
    </div>
</div>
