<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Modern gradient stat cards configuration
$stats = [
    ['icon' => 'fa-users', 'value' => '45', 'label' => 'My Students', 'color' => '#667eea', 'trend' => 'Active this semester'],
    ['icon' => 'fa-file-text', 'value' => '89', 'label' => 'Active Applications', 'color' => '#32d296', 'trend' => 'Across all students'],
    ['icon' => 'fa-chart-line', 'value' => '92.5%', 'label' => 'Success Rate', 'color' => '#faa05a', 'trend' => 'Above average'],
    ['icon' => 'fa-calendar-alt', 'value' => '12', 'label' => 'Meetings This Week', 'color' => '#1e87f0', 'trend' => '8 remaining']
];

$messages = [
    ['name' => 'John Doe', 'subject' => 'Stanford Interview Preparation', 'preview' => 'Hi Sarah, I wanted to ask about the upcoming interview...', 'time' => '2 hours ago', 'unread' => true],
    ['name' => 'Sarah Chen', 'subject' => 'Document Submission', 'preview' => 'I have uploaded the requested financial documents...', 'time' => '5 hours ago', 'unread' => true],
    ['name' => 'Michael Rodriguez', 'subject' => 'Application Status Update', 'preview' => 'Could you please update me on my Toronto application...', 'time' => '1 day ago', 'unread' => false]
];

$meetings = [
    ['name' => 'John Doe', 'topic' => 'Interview Preparation', 'date' => '2024-02-05 at 14:00', 'duration' => '60 min', 'platform' => 'Zoom'],
    ['name' => 'Sarah Chen', 'topic' => 'Document Review', 'date' => '2024-02-03 at 10:00', 'duration' => '45 min', 'platform' => 'Google Meet'],
    ['name' => 'Emma Wilson', 'topic' => 'Initial Consultation', 'date' => '2024-02-06 at 16:00', 'duration' => '90 min', 'platform' => 'Zoom']
];

$tasks = [
    ['title' => 'Review John Doe\'s Stanford application', 'student' => 'John Doe', 'due' => '2024-02-05', 'priority' => 'high', 'status' => 'pending'],
    ['title' => 'Prepare visa documentation for Sarah Chen', 'student' => 'Sarah Chen', 'due' => '2024-02-10', 'priority' => 'medium', 'status' => 'in_progress'],
    ['title' => 'Follow up with Michael Rodriguez on revised documents', 'student' => 'Michael Rodriguez', 'due' => '2024-02-02', 'priority' => 'high', 'status' => 'overdue']
];
?>

<style>
.stat-card-modern {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    cursor: pointer;
}

.stat-card-modern:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}

.stat-card-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20px;
    width: 150px;
    height: 150px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

.stat-card-modern::after {
    content: '';
    position: absolute;
    bottom: -30px;
    right: -30px;
    width: 100px;
    height: 100px;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 50%;
}

.stat-icon-modern {
    font-size: 32px;
    margin-bottom: 12px;
    opacity: 0.95;
    position: relative;
    z-index: 1;
}

.stat-value-modern {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
    position: relative;
    z-index: 1;
}

.stat-label-modern {
    font-size: 14px;
    opacity: 0.95;
    margin-bottom: 8px;
    position: relative;
    z-index: 1;
}

.stat-trend-modern {
    font-size: 12px;
    opacity: 0.85;
    position: relative;
    z-index: 1;
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: box-shadow 0.2s ease;
}

.modern-card:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.modern-card-title {
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 20px;
    color: #1a1a1a;
    display: flex;
    align-items: center;
    gap: 10px;
}

.message-item, .meeting-item, .task-item {
    background: #f8fafc;
    border-radius: 8px;
    padding: 16px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border-left: 3px solid transparent;
}

.message-item:hover, .meeting-item:hover, .task-item:hover {
    background: #f1f5f9;
    border-left-color: #667eea;
    transform: translateX(4px);
}

.message-item.unread {
    background: #eff6ff;
    border-left-color: #3b82f6;
}

.task-item.overdue {
    background: #fef2f2;
    border-left-color: #ef4444;
}

.task-item.in_progress {
    background: #fffbeb;
    border-left-color: #f59e0b;
}

.priority-badge {
    display: inline-block;
    padding: 2px 8px;
    border-radius: 4px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
}

.priority-high {
    background: #fee2e2;
    color: #dc2626;
}

.priority-medium {
    background: #fef3c7;
    color: #d97706;
}

.priority-low {
    background: #dbeafe;
    color: #2563eb;
}

.status-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
}

.status-pending {
    background: #e0e7ff;
    color: #4f46e5;
}

.status-in_progress {
    background: #fef3c7;
    color: #d97706;
}

.status-overdue {
    background: #fee2e2;
    color: #dc2626;
}

.platform-badge {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

@media (max-width: 640px) {
    .stat-card-modern {
        padding: 20px;
    }

    .stat-value-modern {
        font-size: 28px;
    }

    .modern-card {
        padding: 16px;
    }
}
</style>

<!-- Modern Gradient Stat Cards -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($stats as $stat):
        $color_dark = match($stat['color']) {
            '#667eea' => '#5568d3',
            '#32d296' => '#28b67f',
            '#faa05a' => '#f48939',
            '#1e87f0' => '#1b78d6',
            default => '#333'
        };
    ?>
    <div>
        <div class="stat-card-modern" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $color_dark ?>;">
            <div class="stat-icon-modern">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-value-modern"><?= e($stat['value']) ?></div>
            <div class="stat-label-modern"><?= e($stat['label']) ?></div>
            <div class="stat-trend-modern"><?= e($stat['trend']) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Performance Charts -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="modern-card">
            <h4 class="modern-card-title">
                <i class="fa-slab fa-solid fa-chart-pie"></i>
                Application Status Distribution
            </h4>
            <div id="counselor-status-chart" style="height: 220px;"></div>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="modern-card">
            <h4 class="modern-card-title">
                <i class="fa-slab fa-solid fa-chart-area"></i>
                Monthly Performance
            </h4>
            <div id="counselor-performance-chart" style="height: 220px;"></div>
        </div>
    </div>
</div>

<!-- Recent Messages & Upcoming Meetings -->
<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="modern-card">
            <h4 class="modern-card-title">
                <i class="fa-slab fa-solid fa-envelope"></i>
                Recent Messages
            </h4>
            <?php foreach ($messages as $msg): ?>
            <div class="message-item <?= $msg['unread'] ? 'unread' : '' ?>">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-width-expand">
                        <div class="uk-flex uk-flex-middle uk-margin-small-bottom">
                            <span class="uk-text-bold" style="color: #1a1a1a;"><?= e($msg['name']) ?></span>
                            <?php if ($msg['unread']): ?>
                                <span class="uk-badge uk-margin-small-left" style="background: #3b82f6;">new</span>
                            <?php endif; ?>
                        </div>
                        <div class="uk-text-small uk-text-bold" style="color: #334155;"><?= e($msg['subject']) ?></div>
                        <div class="uk-text-muted uk-text-small uk-margin-small-top"><?= e($msg['preview']) ?></div>
                    </div>
                    <div class="uk-text-muted uk-text-small uk-margin-left"><?= e($msg['time']) ?></div>
                </div>
            </div>
            <?php endforeach; ?>
            <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top" onclick="window.location.href='messages.php'">
                <i class="fa-slab fa-solid fa-envelope"></i> View All Messages
            </button>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="modern-card">
            <h4 class="modern-card-title">
                <i class="fa-slab fa-solid fa-calendar-check"></i>
                Upcoming Meetings
            </h4>
            <?php foreach ($meetings as $meeting): ?>
            <div class="meeting-item">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-width-expand">
                        <div class="uk-text-bold" style="color: #1a1a1a;"><?= e($meeting['name']) ?></div>
                        <div class="uk-text-muted uk-text-small uk-margin-small-top"><?= e($meeting['topic']) ?></div>
                        <div class="uk-text-meta uk-text-small uk-margin-small-top">
                            <i class="fa-slab fa-solid fa-clock"></i> <?= e($meeting['date']) ?> &middot; <?= e($meeting['duration']) ?>
                        </div>
                    </div>
                    <span class="platform-badge"><?= e($meeting['platform']) ?></span>
                </div>
            </div>
            <?php endforeach; ?>
            <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top" onclick="window.location.href='schedule.php'">
                <i class="fa-slab fa-solid fa-calendar-alt"></i> View Full Schedule
            </button>
        </div>
    </div>
</div>

<!-- My Tasks -->
<div class="modern-card uk-margin-top">
    <h4 class="modern-card-title">
        <i class="fa-slab fa-solid fa-tasks"></i>
        My Tasks
    </h4>
    <?php foreach ($tasks as $task): ?>
    <div class="task-item <?= $task['status'] ?>">
        <div class="uk-flex uk-flex-between uk-flex-middle">
            <div class="uk-flex uk-flex-middle uk-width-expand">
                <i class="fa-slab fa-solid fa-circle uk-margin-right" style="font-size: 8px; color: #64748b;"></i>
                <div class="uk-width-expand">
                    <div class="uk-text-bold" style="color: #1a1a1a;"><?= e($task['title']) ?></div>
                    <div class="uk-text-muted uk-text-small uk-margin-small-top">
                        <i class="fa-slab fa-solid fa-user"></i> <?= e($task['student']) ?> &middot;
                        <i class="fa-slab fa-solid fa-calendar"></i> Due: <?= e($task['due']) ?> &middot;
                        <span class="priority-badge priority-<?= $task['priority'] ?>"><?= ucfirst($task['priority']) ?></span>
                    </div>
                </div>
            </div>
            <span class="status-badge status-<?= $task['status'] ?>"><?= ucfirst(str_replace('_', ' ', $task['status'])) ?></span>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<script>
(function() {
    // ECharts - Application Status Distribution
    var statusEl = document.getElementById('counselor-status-chart');
    if (statusEl && typeof echarts !== 'undefined') {
        var statusChart = echarts.init(statusEl);
        var statusOption = {
            tooltip: {
                trigger: 'item',
                formatter: '{b}: {c} ({d}%)',
                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                borderColor: 'transparent',
                textStyle: { color: '#fff' }
            },
            legend: {
                orient: 'horizontal',
                bottom: 0,
                textStyle: { fontSize: 11 }
            },
            series: [{
                type: 'pie',
                radius: ['40%', '65%'],
                center: ['50%', '45%'],
                avoidLabelOverlap: false,
                itemStyle: {
                    borderRadius: 8,
                    borderColor: '#fff',
                    borderWidth: 2
                },
                label: { show: false },
                emphasis: {
                    itemStyle: {
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowColor: 'rgba(0, 0, 0, 0.3)'
                    }
                },
                data: [
                    { value: 45, name: 'Accepted', itemStyle: { color: '#32d296' } },
                    { value: 28, name: 'In Review', itemStyle: { color: '#faa05a' } },
                    { value: 12, name: 'Pending', itemStyle: { color: '#667eea' } },
                    { value: 4, name: 'Rejected', itemStyle: { color: '#f0506e' } }
                ]
            }]
        };
        statusChart.setOption(statusOption);
        window.addEventListener('resize', function() { statusChart.resize(); });
    }

    // ApexCharts - Monthly Performance
    var perfEl = document.getElementById('counselor-performance-chart');
    if (perfEl && typeof ApexCharts !== 'undefined') {
        var perfOptions = {
            series: [{
                name: 'Students Helped',
                data: [8, 10, 7, 12, 9, 11]
            }],
            chart: {
                type: 'area',
                height: 220,
                toolbar: { show: false },
                sparkline: { enabled: false },
                fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif'
            },
            colors: ['#32d296'],
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.5,
                    opacityTo: 0.1,
                    stops: [0, 100]
                }
            },
            stroke: {
                curve: 'smooth',
                width: 3
            },
            xaxis: {
                categories: ['Sep', 'Oct', 'Nov', 'Dec', 'Jan', 'Feb'],
                labels: {
                    style: {
                        colors: '#64748b',
                        fontSize: '11px',
                        fontWeight: 500
                    }
                },
                axisBorder: { show: false },
                axisTicks: { show: false }
            },
            yaxis: {
                labels: {
                    style: {
                        colors: '#64748b',
                        fontSize: '11px'
                    }
                }
            },
            dataLabels: { enabled: false },
            grid: {
                borderColor: '#e2e8f0',
                strokeDashArray: 4,
                xaxis: { lines: { show: false } }
            },
            tooltip: {
                theme: 'dark',
                y: {
                    formatter: function(val) {
                        return val + ' students';
                    }
                }
            }
        };
        new ApexCharts(perfEl, perfOptions).render();
    }
})();
</script>
