<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Sample performance data
$performance = [
    'overview' => [
        'total_students' => 23,
        'active_applications' => 47,
        'success_rate' => 78,
        'avg_satisfaction' => 4.7,
        'response_time' => 2.3
    ],
    'monthly_trends' => [
        ['month' => 'Sep', 'students' => 18, 'applications' => 35, 'success' => 75],
        ['month' => 'Oct', 'students' => 20, 'applications' => 40, 'success' => 76],
        ['month' => 'Nov', 'students' => 21, 'applications' => 42, 'success' => 77],
        ['month' => 'Dec', 'students' => 22, 'applications' => 45, 'success' => 77],
        ['month' => 'Jan', 'students' => 23, 'applications' => 47, 'success' => 78],
        ['month' => 'Feb', 'students' => 23, 'applications' => 47, 'success' => 78]
    ],
    'university_breakdown' => [
        ['name' => 'Stanford University', 'applications' => 8, 'accepted' => 6, 'rate' => 75],
        ['name' => 'MIT', 'applications' => 7, 'accepted' => 5, 'rate' => 71],
        ['name' => 'Harvard University', 'applications' => 6, 'accepted' => 5, 'rate' => 83],
        ['name' => 'UC Berkeley', 'applications' => 9, 'accepted' => 8, 'rate' => 89],
        ['name' => 'Yale University', 'applications' => 5, 'accepted' => 4, 'rate' => 80],
        ['name' => 'Other Universities', 'applications' => 12, 'accepted' => 9, 'rate' => 75]
    ],
    'achievements' => [
        ['icon' => 'trophy', 'color' => '#ffd700', 'title' => 'Top Performer', 'description' => 'Highest acceptance rate this quarter'],
        ['icon' => 'star', 'color' => '#667eea', 'title' => 'Student Favorite', 'description' => '4.7/5.0 average satisfaction rating'],
        ['icon' => 'clock', 'color' => '#32d296', 'title' => 'Quick Responder', 'description' => 'Average 2.3 hour response time'],
        ['icon' => 'graduation-cap', 'color' => '#faa05a', 'title' => 'Application Expert', 'description' => '47 active applications managed']
    ],
    'skills' => [
        ['name' => 'Application Strategy', 'level' => 95],
        ['name' => 'Essay Coaching', 'level' => 92],
        ['name' => 'Interview Prep', 'level' => 88],
        ['name' => 'University Research', 'level' => 90],
        ['name' => 'Student Communication', 'level' => 96],
        ['name' => 'Time Management', 'level' => 85]
    ]
];
?>

<style>
.performance-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.performance-icon-large {
    width: 64px;
    height: 64px;
    border-radius: 16px;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    backdrop-filter: blur(10px);
}

.performance-title {
    font-size: 28px;
    font-weight: 700;
    margin: 0 0 8px 0;
}

.performance-subtitle {
    font-size: 16px;
    opacity: 0.9;
    margin: 0;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.stat-card-modern {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.2s ease;
}

.stat-card-modern:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
}

.stat-label {
    font-size: 13px;
    color: #64748b;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 8px;
}

.stat-value-large {
    font-size: 32px;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, var(--gradient-from) 0%, var(--gradient-to) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stat-unit {
    font-size: 16px;
    margin-left: 4px;
}

.section-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 24px;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 12px;
    border-bottom: 2px solid #f1f5f9;
}

.section-title {
    font-size: 18px;
    font-weight: 700;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.achievement-card {
    background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 16px;
    border-left: 4px solid var(--achievement-color);
    transition: all 0.2s ease;
}

.achievement-card:hover {
    background: #f1f5f9;
    transform: translateX(4px);
}

.achievement-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    margin-right: 16px;
    flex-shrink: 0;
}

.achievement-title {
    font-size: 16px;
    font-weight: 700;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.achievement-description {
    font-size: 13px;
    color: #64748b;
}

.skill-item {
    margin-bottom: 20px;
}

.skill-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.skill-name {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
}

.skill-level {
    font-size: 12px;
    font-weight: 700;
    color: #667eea;
}

.skill-bar {
    height: 8px;
    background: #e2e8f0;
    border-radius: 4px;
    overflow: hidden;
}

.skill-bar-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transition: width 0.6s ease;
    border-radius: 4px;
}

.university-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.university-item:hover {
    background: #f1f5f9;
}

.university-info {
    flex: 1;
}

.university-name {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.university-stats {
    font-size: 12px;
    color: #64748b;
}

.university-rate {
    font-size: 20px;
    font-weight: 700;
    color: #667eea;
    margin-left: 16px;
}

.chart-container {
    height: 300px;
    margin-top: 16px;
}

@media (max-width: 959px) {
    .performance-header-card {
        padding: 24px;
    }

    .performance-icon-large {
        width: 48px;
        height: 48px;
        font-size: 24px;
    }

    .performance-title {
        font-size: 22px;
    }

    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    }
}
</style>

<!-- Performance Header -->
<div class="performance-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="performance-icon-large">
                <i class="fa-slab fa-solid fa-star"></i>
            </div>
            <div>
                <h2 class="performance-title">My Performance</h2>
                <p class="performance-subtitle">Track your counseling metrics and achievements</p>
            </div>
        </div>
    </div>
</div>

<!-- Overview Stats -->
<div class="stats-grid">
    <div class="stat-card-modern" style="--gradient-from: #667eea; --gradient-to: #764ba2;">
        <div class="stat-label">Total Students</div>
        <div class="stat-value-large"><?= $performance['overview']['total_students'] ?></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #32d296; --gradient-to: #28b67f;">
        <div class="stat-label">Active Applications</div>
        <div class="stat-value-large"><?= $performance['overview']['active_applications'] ?></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #faa05a; --gradient-to: #f48939;">
        <div class="stat-label">Success Rate</div>
        <div class="stat-value-large"><?= $performance['overview']['success_rate'] ?><span class="stat-unit">%</span></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #8b5cf6; --gradient-to: #7c3aed;">
        <div class="stat-label">Avg Satisfaction</div>
        <div class="stat-value-large"><?= number_format($performance['overview']['avg_satisfaction'], 1) ?><span class="stat-unit">/5</span></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #1e87f0; --gradient-to: #1b78d6;">
        <div class="stat-label">Response Time</div>
        <div class="stat-value-large"><?= number_format($performance['overview']['response_time'], 1) ?><span class="stat-unit">h</span></div>
    </div>
</div>

<!-- Performance Trends Chart -->
<div class="section-card">
    <div class="section-header">
        <h3 class="section-title">
            <i class="fa-slab fa-solid fa-chart-line"></i> Performance Trends
        </h3>
    </div>
    <div id="trends-chart" class="chart-container"></div>
</div>

<!-- Two Column Layout -->
<div style="display: grid; grid-template-columns: 1fr; gap: 24px;">
    <div class="content-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 24px;">

        <!-- Achievements -->
        <div class="section-card">
            <div class="section-header">
                <h3 class="section-title">
                    <i class="fa-slab fa-solid fa-award"></i> Achievements
                </h3>
            </div>

            <?php foreach ($performance['achievements'] as $achievement): ?>
            <div class="achievement-card" style="--achievement-color: <?= $achievement['color'] ?>;">
                <div style="display: flex; align-items: center;">
                    <div class="achievement-icon" style="background: <?= $achievement['color'] ?>20; color: <?= $achievement['color'] ?>;">
                        <i class="fa-slab fa-solid fa-<?= $achievement['icon'] ?>"></i>
                    </div>
                    <div>
                        <div class="achievement-title"><?= e($achievement['title']) ?></div>
                        <div class="achievement-description"><?= e($achievement['description']) ?></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Skills Assessment -->
        <div class="section-card">
            <div class="section-header">
                <h3 class="section-title">
                    <i class="fa-slab fa-solid fa-tasks"></i> Skills Assessment
                </h3>
            </div>

            <?php foreach ($performance['skills'] as $skill): ?>
            <div class="skill-item">
                <div class="skill-header">
                    <span class="skill-name"><?= e($skill['name']) ?></span>
                    <span class="skill-level"><?= $skill['level'] ?>%</span>
                </div>
                <div class="skill-bar">
                    <div class="skill-bar-fill" style="width: <?= $skill['level'] ?>%;"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- University Success Rates -->
<div class="section-card">
    <div class="section-header">
        <h3 class="section-title">
            <i class="fa-slab fa-solid fa-university"></i> University Success Rates
        </h3>
    </div>

    <?php foreach ($performance['university_breakdown'] as $university): ?>
    <div class="university-item">
        <div class="university-info">
            <div class="university-name"><?= e($university['name']) ?></div>
            <div class="university-stats">
                <?= $university['accepted'] ?>/<?= $university['applications'] ?> applications accepted
            </div>
        </div>
        <div class="university-rate"><?= $university['rate'] ?>%</div>
    </div>
    <?php endforeach; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.0/dist/apexcharts.min.js"></script>
<script>
// Performance Trends Chart
const trendsData = <?= json_encode($performance['monthly_trends']) ?>;

const trendsOptions = {
    series: [
        {
            name: 'Students',
            data: trendsData.map(d => d.students)
        },
        {
            name: 'Applications',
            data: trendsData.map(d => d.applications)
        },
        {
            name: 'Success Rate (%)',
            data: trendsData.map(d => d.success)
        }
    ],
    chart: {
        height: 300,
        type: 'line',
        toolbar: {
            show: true,
            tools: {
                download: true,
                zoom: false,
                zoomin: false,
                zoomout: false,
                pan: false,
                reset: false
            }
        },
        fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif'
    },
    colors: ['#667eea', '#32d296', '#faa05a'],
    dataLabels: {
        enabled: false
    },
    stroke: {
        curve: 'smooth',
        width: 3
    },
    markers: {
        size: 5,
        hover: {
            size: 7
        }
    },
    xaxis: {
        categories: trendsData.map(d => d.month),
        labels: {
            style: {
                colors: '#64748b',
                fontSize: '12px'
            }
        }
    },
    yaxis: {
        labels: {
            style: {
                colors: '#64748b',
                fontSize: '12px'
            }
        }
    },
    grid: {
        borderColor: '#f1f5f9',
        strokeDashArray: 4
    },
    legend: {
        position: 'top',
        horizontalAlign: 'right',
        fontSize: '13px',
        fontWeight: 600,
        labels: {
            colors: '#64748b'
        },
        markers: {
            width: 10,
            height: 10,
            radius: 10
        }
    },
    tooltip: {
        theme: 'light',
        y: {
            formatter: function(value, { seriesIndex }) {
                if (seriesIndex === 2) return value + '%';
                return value;
            }
        }
    }
};

const trendsChart = new ApexCharts(document.querySelector("#trends-chart"), trendsOptions);
trendsChart.render();

// Re-initialize UIKit components for dynamically loaded content
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
