<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user = $GLOBALS['current_user'];
?>

<style>
.profile-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    text-align: center;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.3);
}

.profile-avatar-large {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    background: white;
    color: #667eea;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 48px;
    border: 4px solid rgba(255, 255, 255, 0.3);
}

.profile-name {
    font-size: 28px;
    font-weight: 700;
    margin-top: 16px;
    margin-bottom: 4px;
}

.profile-role {
    font-size: 14px;
    opacity: 0.9;
}

.info-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.info-row {
    padding: 16px 0;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    align-items: start;
    gap: 16px;
}

.info-row:last-child {
    border-bottom: none;
}

.info-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: #f0f4ff;
    color: #667eea;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.info-label {
    font-size: 12px;
    font-weight: 600;
    color: #94a3b8;
    text-transform: uppercase;
    margin-bottom: 4px;
}

.info-value {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
}

.performance-stat {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 20px;
    color: white;
    text-align: center;
    margin-bottom: 16px;
}

.performance-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
}

.performance-label {
    font-size: 13px;
    opacity: 0.9;
}

.integration-item {
    background: #f8fafc;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    transition: all 0.2s ease;
}

.integration-item:hover {
    background: #f1f5f9;
}

.integration-icon {
    width: 48px;
    height: 48px;
    border-radius: 10px;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
    flex-shrink: 0;
}

.integration-name {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.integration-desc {
    font-size: 12px;
    color: #64748b;
}

.status-badge-connected {
    background: #d1fae5;
    color: #065f46;
    padding: 4px 12px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

@media (max-width: 959px) {
    .profile-header-card {
        padding: 24px;
    }

    .profile-avatar-large {
        width: 100px;
        height: 100px;
        font-size: 40px;
    }

    .profile-name {
        font-size: 24px;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-user"></i> My Profile
    </h3>
    <button class="uk-button uk-button-primary uk-button-small mobile-full" uk-toggle="target: #edit-profile-modal">
        <i class="fa-slab fa-solid fa-edit"></i> Edit Profile
    </button>
</div>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-3@m">
        <!-- Profile Header Card -->
        <div class="profile-header-card">
            <div class="profile-avatar-large">
                <?= strtoupper(substr($user['name'], 0, 1) . (strpos($user['name'], ' ') !== false ? substr(strstr($user['name'], ' '), 1, 1) : '')) ?>
            </div>
            <div class="profile-name"><?= e($user['name']) ?></div>
            <div class="profile-role">Senior Counselor</div>
            <button class="uk-button uk-button-default uk-button-small uk-margin-top" style="background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3);" uk-toggle="target: #change-avatar-modal">
                <i class="fa-slab fa-solid fa-camera"></i> Change Avatar
            </button>
        </div>

        <!-- Performance Stats -->
        <div class="uk-margin-top">
            <div class="performance-stat" style="--stat-color: #32d296; --stat-color-dark: #28b67f;">
                <div class="performance-value"><i class="fa-slab fa-solid fa-chart-line"></i> 92.5%</div>
                <div class="performance-label">Success Rate</div>
            </div>
            <div class="performance-stat" style="--stat-color: #667eea; --stat-color-dark: #5568d3;">
                <div class="performance-value"><i class="fa-slab fa-solid fa-users"></i> 45</div>
                <div class="performance-label">Students Assigned</div>
            </div>
            <div class="performance-stat" style="--stat-color: #faa05a; --stat-color-dark: #f48939;">
                <div class="performance-value"><i class="fa-slab fa-solid fa-file-alt"></i> 89</div>
                <div class="performance-label">Applications</div>
            </div>
            <div class="performance-stat" style="--stat-color: #1e87f0; --stat-color-dark: #1b78d6;">
                <div class="performance-value"><i class="fa-slab fa-solid fa-clock"></i> 2.3h</div>
                <div class="performance-label">Avg. Response</div>
            </div>
        </div>
    </div>

    <div class="uk-width-2-3@m">
        <!-- Personal Information -->
        <div class="info-card">
            <h4 style="font-size: 18px; font-weight: 600; margin-bottom: 20px;">
                <i class="fa-slab fa-solid fa-info-circle"></i> Personal Information
            </h4>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-user"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Full Name</div>
                    <div class="info-value"><?= e($user['name']) ?></div>
                </div>
            </div>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-envelope"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Email Address</div>
                    <div class="info-value"><?= e($user['email']) ?></div>
                </div>
            </div>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-phone"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Phone Number</div>
                    <div class="info-value">+1 (555) 234-5678</div>
                </div>
            </div>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-graduation-cap"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Specialization</div>
                    <div class="info-value">US & UK Universities</div>
                </div>
            </div>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-language"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Languages</div>
                    <div class="info-value">English, Spanish</div>
                </div>
            </div>
            <div class="info-row">
                <div class="info-icon"><i class="fa-slab fa-solid fa-globe"></i></div>
                <div style="flex: 1;">
                    <div class="info-label">Timezone</div>
                    <div class="info-value">Eastern Time (ET)</div>
                </div>
            </div>
        </div>

        <!-- Calendar Integration -->
        <div class="info-card">
            <h4 style="font-size: 18px; font-weight: 600; margin-bottom: 20px;">
                <i class="fa-slab fa-solid fa-plug"></i> Integrations
            </h4>
            <div class="integration-item">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-flex uk-flex-middle" style="gap: 16px; flex: 1;">
                        <div class="integration-icon" style="color: #4285F4;">
                            <i class="fa-slab fa-solid fa-calendar"></i>
                        </div>
                        <div>
                            <div class="integration-name">Google Calendar</div>
                            <div class="integration-desc">Sync your appointments with Google Calendar</div>
                        </div>
                    </div>
                    <span class="status-badge-connected">
                        <i class="fa-slab fa-solid fa-check"></i> Connected
                    </span>
                </div>
            </div>
            <div class="integration-item">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-flex uk-flex-middle" style="gap: 16px; flex: 1;">
                        <div class="integration-icon" style="color: #2D8CFF;">
                            <i class="fa-slab fa-solid fa-video"></i>
                        </div>
                        <div>
                            <div class="integration-name">Zoom</div>
                            <div class="integration-desc">Auto-create meeting links for appointments</div>
                        </div>
                    </div>
                    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #connect-zoom-modal">
                        <i class="fa-slab fa-solid fa-plug"></i> Connect
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change Avatar Modal -->
<div id="change-avatar-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-camera"></i> Change Avatar</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-margin-bottom">
                <div class="profile-avatar-large" style="width: 100px; height: 100px; font-size: 40px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                    <?= strtoupper(substr($user['name'], 0, 1) . (strpos($user['name'], ' ') !== false ? substr(strstr($user['name'], ' '), 1, 1) : '')) ?>
                </div>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Upload New Avatar</label>
                    <div uk-form-custom="target: true">
                        <input type="file" accept="image/*">
                        <input class="uk-input" type="text" placeholder="Select image..." disabled>
                    </div>
                    <p class="uk-text-small uk-text-muted uk-margin-small-top">
                        <i class="fa-slab fa-solid fa-info-circle"></i> Max file size: 2MB. Supported: JPG, PNG, GIF
                    </p>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-upload"></i> Upload
            </button>
        </div>
    </div>
</div>

<!-- Connect Zoom Modal -->
<div id="connect-zoom-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-video"></i> Connect Zoom</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-padding">
                <div style="width: 80px; height: 80px; border-radius: 50%; background: linear-gradient(135deg, #2D8CFF 0%, #1a75e8 100%); color: white; display: inline-flex; align-items: center; justify-content: center; margin-bottom: 16px;">
                    <i class="fa-slab fa-solid fa-video" style="font-size: 32px;"></i>
                </div>
                <p class="uk-margin-top">Connect your Zoom account to automatically create meeting links for your appointments.</p>
            </div>
            <div class="uk-alert uk-alert-primary">
                <p><i class="fa-slab fa-solid fa-info-circle"></i> You will be redirected to Zoom to authorize the connection.</p>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-plug"></i> Connect to Zoom
            </button>
        </div>
    </div>
</div>

<!-- Edit Profile Modal -->
<div id="edit-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-edit"></i> Edit Profile</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Full Name</label>
                    <input class="uk-input" type="text" value="<?= e($user['name']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Address</label>
                    <input class="uk-input" type="email" value="<?= e($user['email']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Phone Number</label>
                    <input class="uk-input" type="tel" value="+1 (555) 234-5678">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Specialization</label>
                    <input class="uk-input" type="text" value="US & UK Universities">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Languages</label>
                    <input class="uk-input" type="text" value="English, Spanish">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-save"></i> Save Changes
            </button>
        </div>
    </div>
</div>
