<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Sample reports data
$reports = [
    'weekly' => [
        'students_contacted' => 18,
        'meetings_completed' => 12,
        'applications_submitted' => 7,
        'documents_reviewed' => 24,
        'hours_logged' => 32.5
    ],
    'monthly' => [
        'new_students' => 5,
        'active_students' => 23,
        'completed_applications' => 15,
        'acceptance_rate' => 78,
        'student_satisfaction' => 4.7
    ],
    'recent_activities' => [
        ['date' => '2024-02-28', 'type' => 'meeting', 'student' => 'John Doe', 'description' => 'Stanford application review', 'duration' => '60 min'],
        ['date' => '2024-02-27', 'type' => 'review', 'student' => 'Sarah Chen', 'description' => 'Essay revision - MIT', 'duration' => '45 min'],
        ['date' => '2024-02-27', 'type' => 'meeting', 'student' => 'Michael Rodriguez', 'description' => 'UC system strategy session', 'duration' => '90 min'],
        ['date' => '2024-02-26', 'type' => 'submission', 'student' => 'Emma Wilson', 'description' => 'Submitted Harvard application', 'duration' => null],
        ['date' => '2024-02-26', 'type' => 'review', 'student' => 'David Kim', 'description' => 'Personal statement feedback', 'duration' => '30 min']
    ],
    'top_students' => [
        ['name' => 'Michael Rodriguez', 'applications' => 4, 'submitted' => 4, 'accepted' => 2, 'progress' => 100],
        ['name' => 'David Kim', 'applications' => 3, 'submitted' => 3, 'accepted' => 1, 'progress' => 100],
        ['name' => 'John Doe', 'applications' => 3, 'submitted' => 2, 'accepted' => 1, 'progress' => 85],
        ['name' => 'Sarah Chen', 'applications' => 2, 'submitted' => 1, 'accepted' => 0, 'progress' => 75],
        ['name' => 'Emma Wilson', 'applications' => 2, 'submitted' => 1, 'accepted' => 0, 'progress' => 60]
    ]
];

$activity_types = [
    'meeting' => ['icon' => 'calendar-check', 'color' => '#667eea', 'label' => 'Meeting'],
    'review' => ['icon' => 'file-alt', 'color' => '#faa05a', 'label' => 'Review'],
    'submission' => ['icon' => 'paper-plane', 'color' => '#32d296', 'label' => 'Submission']
];
?>

<style>
.reports-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.reports-icon-large {
    width: 64px;
    height: 64px;
    border-radius: 16px;
    background: rgba(255, 255, 255, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    backdrop-filter: blur(10px);
}

.reports-title {
    font-size: 28px;
    font-weight: 700;
    margin: 0 0 8px 0;
}

.reports-subtitle {
    font-size: 16px;
    opacity: 0.9;
    margin: 0;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.stat-card-modern {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.2s ease;
}

.stat-card-modern:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
}

.stat-label {
    font-size: 13px;
    color: #64748b;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 8px;
}

.stat-value-large {
    font-size: 32px;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, var(--gradient-from) 0%, var(--gradient-to) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stat-change {
    font-size: 12px;
    font-weight: 600;
    margin-top: 8px;
    display: flex;
    align-items: center;
    gap: 4px;
}

.stat-change.positive {
    color: #32d296;
}

.stat-change.negative {
    color: #f0506e;
}

.section-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 24px;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
    padding-bottom: 12px;
    border-bottom: 2px solid #f1f5f9;
}

.section-title {
    font-size: 18px;
    font-weight: 700;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 8px;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    padding: 16px;
    border-radius: 8px;
    margin-bottom: 12px;
    background: #f8fafc;
    transition: all 0.2s ease;
}

.activity-item:hover {
    background: #f1f5f9;
    transform: translateX(4px);
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
    flex-shrink: 0;
    margin-right: 16px;
}

.activity-content {
    flex: 1;
    min-width: 0;
}

.activity-type {
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 4px;
    opacity: 0.7;
}

.activity-description {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.activity-student {
    font-size: 13px;
    color: #64748b;
}

.activity-meta {
    display: flex;
    flex-direction: column;
    align-items: flex-end;
    gap: 4px;
    flex-shrink: 0;
}

.activity-date {
    font-size: 12px;
    color: #94a3b8;
}

.activity-duration {
    font-size: 12px;
    font-weight: 600;
    color: #667eea;
    padding: 4px 8px;
    background: rgba(102, 126, 234, 0.1);
    border-radius: 4px;
}

.student-rank-item {
    display: flex;
    align-items: center;
    padding: 12px;
    border-radius: 8px;
    margin-bottom: 8px;
    background: #f8fafc;
    transition: all 0.2s ease;
}

.student-rank-item:hover {
    background: #f1f5f9;
}

.rank-number {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 14px;
    margin-right: 12px;
    flex-shrink: 0;
}

.rank-1 { background: linear-gradient(135deg, #ffd700 0%, #ffed4e 100%); color: #000; }
.rank-2 { background: linear-gradient(135deg, #c0c0c0 0%, #e8e8e8 100%); color: #000; }
.rank-3 { background: linear-gradient(135deg, #cd7f32 0%, #e89f71 100%); color: #fff; }
.rank-other { background: #e2e8f0; color: #64748b; }

.student-rank-info {
    flex: 1;
    min-width: 0;
}

.student-rank-name {
    font-size: 14px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 2px;
}

.student-rank-stats {
    font-size: 12px;
    color: #64748b;
}

.progress-bar-mini {
    width: 100px;
    height: 6px;
    background: #e2e8f0;
    border-radius: 3px;
    overflow: hidden;
}

.progress-bar-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transition: width 0.3s ease;
}

.export-dropdown {
    position: relative;
}

.export-button {
    padding: 8px 16px;
    border-radius: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.export-button:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

@media (max-width: 959px) {
    .reports-header-card {
        padding: 24px;
    }

    .reports-icon-large {
        width: 48px;
        height: 48px;
        font-size: 24px;
    }

    .reports-title {
        font-size: 22px;
    }

    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    }

    .activity-item {
        flex-direction: column;
        gap: 12px;
    }

    .activity-meta {
        align-items: flex-start;
        width: 100%;
    }
}
</style>

<!-- Reports Header -->
<div class="reports-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="reports-icon-large">
                <i class="fa-slab fa-solid fa-chart-bar"></i>
            </div>
            <div>
                <h2 class="reports-title">My Reports</h2>
                <p class="reports-subtitle">Track your counseling activity and student progress</p>
            </div>
        </div>
        <div class="export-dropdown">
            <button class="export-button">
                <i class="fa-slab fa-solid fa-download"></i> Export Report
            </button>
        </div>
    </div>
</div>

<!-- Weekly Stats -->
<h3 class="uk-margin-medium-bottom">
    <i class="fa-slab fa-solid fa-calendar-week"></i> This Week
</h3>
<div class="stats-grid">
    <div class="stat-card-modern" style="--gradient-from: #667eea; --gradient-to: #764ba2;">
        <div class="stat-label">Students Contacted</div>
        <div class="stat-value-large"><?= $reports['weekly']['students_contacted'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 12% vs last week
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #32d296; --gradient-to: #28b67f;">
        <div class="stat-label">Meetings Completed</div>
        <div class="stat-value-large"><?= $reports['weekly']['meetings_completed'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 8% vs last week
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #faa05a; --gradient-to: #f48939;">
        <div class="stat-label">Applications Submitted</div>
        <div class="stat-value-large"><?= $reports['weekly']['applications_submitted'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 15% vs last week
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #8b5cf6; --gradient-to: #7c3aed;">
        <div class="stat-label">Documents Reviewed</div>
        <div class="stat-value-large"><?= $reports['weekly']['documents_reviewed'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 20% vs last week
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #1e87f0; --gradient-to: #1b78d6;">
        <div class="stat-label">Hours Logged</div>
        <div class="stat-value-large"><?= number_format($reports['weekly']['hours_logged'], 1) ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 5% vs last week
        </div>
    </div>
</div>

<!-- Monthly Stats -->
<h3 class="uk-margin-medium-bottom uk-margin-medium-top">
    <i class="fa-slab fa-solid fa-calendar-alt"></i> This Month
</h3>
<div class="stats-grid">
    <div class="stat-card-modern" style="--gradient-from: #667eea; --gradient-to: #764ba2;">
        <div class="stat-label">New Students</div>
        <div class="stat-value-large"><?= $reports['monthly']['new_students'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 25% vs last month
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #32d296; --gradient-to: #28b67f;">
        <div class="stat-label">Active Students</div>
        <div class="stat-value-large"><?= $reports['monthly']['active_students'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 10% vs last month
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #faa05a; --gradient-to: #f48939;">
        <div class="stat-label">Completed Applications</div>
        <div class="stat-value-large"><?= $reports['monthly']['completed_applications'] ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 18% vs last month
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #8b5cf6; --gradient-to: #7c3aed;">
        <div class="stat-label">Acceptance Rate</div>
        <div class="stat-value-large"><?= $reports['monthly']['acceptance_rate'] ?>%</div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 5% vs last month
        </div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #1e87f0; --gradient-to: #1b78d6;">
        <div class="stat-label">Student Satisfaction</div>
        <div class="stat-value-large"><?= number_format($reports['monthly']['student_satisfaction'], 1) ?></div>
        <div class="stat-change positive">
            <i class="fa-slab fa-solid fa-arrow-up"></i> 0.3 vs last month
        </div>
    </div>
</div>

<!-- Two Column Layout -->
<div style="display: grid; grid-template-columns: 1fr; gap: 24px; margin-top: 32px;">
    <div class="content-grid" style="display: grid; grid-template-columns: 2fr 1fr; gap: 24px;">
        <!-- Recent Activities -->
        <div class="section-card">
            <div class="section-header">
                <h3 class="section-title">
                    <i class="fa-slab fa-solid fa-clock"></i> Recent Activities
                </h3>
                <a href="#" class="uk-text-small" style="color: #667eea; font-weight: 600;">View All</a>
            </div>

            <?php foreach ($reports['recent_activities'] as $activity):
                $type = $activity_types[$activity['type']];
            ?>
            <div class="activity-item">
                <div class="activity-icon" style="background: <?= $type['color'] ?>;">
                    <i class="fa-slab fa-solid fa-<?= $type['icon'] ?>"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-type" style="color: <?= $type['color'] ?>;"><?= $type['label'] ?></div>
                    <div class="activity-description"><?= e($activity['description']) ?></div>
                    <div class="activity-student"><?= e($activity['student']) ?></div>
                </div>
                <div class="activity-meta">
                    <div class="activity-date"><?= date('M d', strtotime($activity['date'])) ?></div>
                    <?php if ($activity['duration']): ?>
                    <div class="activity-duration"><?= e($activity['duration']) ?></div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Top Performing Students -->
        <div class="section-card">
            <div class="section-header">
                <h3 class="section-title">
                    <i class="fa-slab fa-solid fa-star"></i> Top Students
                </h3>
            </div>

            <?php foreach ($reports['top_students'] as $index => $student):
                $rank = $index + 1;
                $rankClass = $rank <= 3 ? "rank-{$rank}" : "rank-other";
            ?>
            <div class="student-rank-item">
                <div class="rank-number <?= $rankClass ?>"><?= $rank ?></div>
                <div class="student-rank-info">
                    <div class="student-rank-name"><?= e($student['name']) ?></div>
                    <div class="student-rank-stats">
                        <?= $student['submitted'] ?>/<?= $student['applications'] ?> submitted ·
                        <?= $student['accepted'] ?> accepted
                    </div>
                </div>
                <div class="progress-bar-mini">
                    <div class="progress-bar-fill" style="width: <?= $student['progress'] ?>%;"></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components for dynamically loaded content
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
