<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Current month data
$current_month = 'February 2024';
$days_in_month = 29;
$first_day_offset = 4; // Thursday

$meetings = [
    5 => [
        ['time' => '09:00', 'student' => 'John Doe', 'topic' => 'Stanford Interview Prep', 'platform' => 'Zoom'],
        ['time' => '14:00', 'student' => 'Emma Wilson', 'topic' => 'Initial Consultation', 'platform' => 'Zoom']
    ],
    8 => [['time' => '11:00', 'student' => 'Sarah Chen', 'topic' => 'Document Review', 'platform' => 'Meet']],
    12 => [['time' => '10:00', 'student' => 'David Kim', 'topic' => 'Essay Review', 'platform' => 'Phone']],
    15 => [
        ['time' => '09:30', 'student' => 'Michael R.', 'topic' => 'MBA Prep', 'platform' => 'Zoom'],
        ['time' => '15:00', 'student' => 'Emma Wilson', 'topic' => 'Follow-up', 'platform' => 'Meet']
    ],
    20 => [['time' => '14:00', 'student' => 'John Doe', 'topic' => 'Status Update', 'platform' => 'Zoom']],
    22 => [['time' => '10:00', 'student' => 'Sarah Chen', 'topic' => 'Interview Prep', 'platform' => 'Zoom']],
    28 => [['time' => '11:00', 'student' => 'David Kim', 'topic' => 'Final Review', 'platform' => 'Meet']]
];

$today_meetings = [
    ['time' => '09:00', 'student' => 'John Doe', 'topic' => 'Stanford Interview Prep', 'duration' => '60 min', 'platform' => 'Zoom', 'status' => 'confirmed'],
    ['time' => '11:00', 'student' => 'Sarah Chen', 'topic' => 'Document Review', 'duration' => '45 min', 'platform' => 'Google Meet', 'status' => 'confirmed'],
    ['time' => '14:00', 'student' => 'Emma Wilson', 'topic' => 'Initial Consultation', 'duration' => '90 min', 'platform' => 'Zoom', 'status' => 'pending'],
    ['time' => '16:00', 'student' => 'David Kim', 'topic' => 'Essay Review', 'duration' => '30 min', 'platform' => 'Phone', 'status' => 'confirmed']
];

$status_config = [
    'confirmed' => ['label' => 'Confirmed', 'color' => '#32d296'],
    'pending' => ['label' => 'Pending', 'color' => '#faa05a'],
    'cancelled' => ['label' => 'Cancelled', 'color' => '#f0506e']
];
?>

<style>
.calendar-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.calendar-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 4px;
}

.calendar-table th {
    text-align: center;
    padding: 12px 8px;
    font-size: 12px;
    font-weight: 600;
    color: #64748b;
    text-transform: uppercase;
}

.calendar-day {
    background: #f8fafc;
    border-radius: 8px;
    padding: 8px;
    height: 90px;
    vertical-align: top;
    cursor: pointer;
    transition: all 0.2s ease;
    position: relative;
}

.calendar-day:hover {
    background: #f0f4ff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.calendar-day.today {
    border: 2px solid #667eea;
}

.calendar-day.has-meetings {
    background: #eff6ff;
}

.day-number {
    font-weight: 600;
    font-size: 14px;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.meeting-dot {
    width: 6px;
    height: 6px;
    border-radius: 50%;
    background: #667eea;
    display: inline-block;
    margin-right: 2px;
}

.meeting-preview {
    font-size: 10px;
    color: #64748b;
    margin-top: 4px;
    padding: 2px 6px;
    background: white;
    border-radius: 4px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.meeting-item {
    background: white;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.2s ease;
    border-left: 4px solid #667eea;
}

.meeting-item:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateX(4px);
}

.meeting-time {
    font-size: 16px;
    font-weight: 700;
    color: #667eea;
    min-width: 60px;
}

.meeting-student {
    font-size: 15px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 4px;
}

.meeting-topic {
    font-size: 13px;
    color: #64748b;
}

.platform-badge {
    background: #f1f5f9;
    color: #475569;
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.status-badge-schedule {
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    color: white;
}

.stats-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 20px;
    color: white;
    margin-bottom: 16px;
}

.stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 13px;
    opacity: 0.9;
}

@media (max-width: 959px) {
    .calendar-day {
        height: 60px;
        padding: 4px;
    }

    .meeting-preview {
        display: none;
    }
}
</style>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb">
        <i class="fa-slab fa-solid fa-calendar-alt"></i> My Schedule
    </h3>
    <div class="uk-flex uk-flex-middle mobile-stack" style="gap: 12px;">
        <div class="uk-flex uk-flex-middle">
            <button class="uk-button uk-button-default uk-button-small">
                <i class="fa-slab fa-solid fa-chevron-left"></i>
            </button>
            <span class="uk-text-bold uk-margin-left uk-margin-right"><?= $current_month ?></span>
            <button class="uk-button uk-button-default uk-button-small">
                <i class="fa-slab fa-solid fa-chevron-right"></i>
            </button>
        </div>
        <button class="uk-button uk-button-primary uk-button-small mobile-full" uk-toggle="target: #new-meeting-modal">
            <i class="fa-slab fa-solid fa-plus"></i> New Meeting
        </button>
    </div>
</div>

<!-- Calendar View -->
<div class="calendar-card uk-margin-bottom">
    <table class="calendar-table">
        <thead>
            <tr>
                <th>Sun</th>
                <th>Mon</th>
                <th>Tue</th>
                <th>Wed</th>
                <th>Thu</th>
                <th>Fri</th>
                <th>Sat</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $day = 1;
            $cell = 0;
            while ($day <= $days_in_month):
            ?>
            <tr>
                <?php for ($i = 0; $i < 7; $i++): ?>
                    <?php if (($cell < $first_day_offset && $day === 1) || $day > $days_in_month): ?>
                        <td></td>
                    <?php else: ?>
                        <td class="calendar-day <?= $day === 5 ? 'today' : '' ?> <?= isset($meetings[$day]) ? 'has-meetings' : '' ?>">
                            <div class="day-number"><?= $day ?></div>
                            <?php if (isset($meetings[$day])): ?>
                                <div class="uk-visible@m">
                                    <?php foreach (array_slice($meetings[$day], 0, 1) as $meeting): ?>
                                        <div class="meeting-preview">
                                            <i class="fa-slab fa-solid fa-clock" style="font-size: 8px;"></i> <?= e($meeting['time']) ?> - <?= e($meeting['student']) ?>
                                        </div>
                                    <?php endforeach; ?>
                                    <?php if (count($meetings[$day]) > 1): ?>
                                        <div style="font-size: 9px; color: #667eea; margin-top: 2px;">+<?= count($meetings[$day]) - 1 ?> more</div>
                                    <?php endif; ?>
                                </div>
                                <div class="uk-hidden@m" style="margin-top: 4px;">
                                    <?php for ($d = 0; $d < min(count($meetings[$day]), 3); $d++): ?>
                                        <span class="meeting-dot"></span>
                                    <?php endfor; ?>
                                </div>
                            <?php endif; ?>
                        </td>
                        <?php $day++; ?>
                    <?php endif; ?>
                    <?php $cell++; ?>
                <?php endfor; ?>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- Today's Meetings & Stats -->
<div class="uk-grid-small" uk-grid>
    <div class="uk-width-2-3@m">
        <div class="calendar-card">
            <h4 style="font-size: 18px; font-weight: 600; margin-bottom: 20px;">
                <i class="fa-slab fa-solid fa-calendar-day"></i> Today's Meetings
            </h4>
            <?php foreach ($today_meetings as $meeting):
                $status = $status_config[$meeting['status']];
            ?>
            <div class="meeting-item">
                <div class="uk-flex uk-flex-between uk-flex-middle">
                    <div class="uk-flex uk-flex-middle" style="flex: 1; gap: 16px;">
                        <div class="meeting-time"><?= e($meeting['time']) ?></div>
                        <div style="flex: 1;">
                            <div class="meeting-student"><?= e($meeting['student']) ?></div>
                            <div class="meeting-topic">
                                <i class="fa-slab fa-solid fa-comment-dots"></i> <?= e($meeting['topic']) ?> · <?= e($meeting['duration']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="uk-flex uk-flex-middle" style="gap: 8px;">
                        <span class="platform-badge">
                            <i class="fa-slab fa-solid fa-video"></i> <?= e($meeting['platform']) ?>
                        </span>
                        <span class="status-badge-schedule" style="background: <?= $status['color'] ?>;">
                            <?= $status['label'] ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="uk-width-1-3@m">
        <div class="stats-card">
            <div class="stat-value"><i class="fa-slab fa-solid fa-calendar-check"></i> 4</div>
            <div class="stat-label">Meetings Today</div>
        </div>
        <div class="stats-card" style="background: linear-gradient(135deg, #32d296 0%, #28b67f 100%);">
            <div class="stat-value"><i class="fa-slab fa-solid fa-calendar-week"></i> 12</div>
            <div class="stat-label">This Week</div>
        </div>
        <div class="stats-card" style="background: linear-gradient(135deg, #faa05a 0%, #f48939 100%);">
            <div class="stat-value"><i class="fa-slab fa-solid fa-clock"></i> 56</div>
            <div class="stat-label">Avg. Minutes</div>
        </div>
    </div>
</div>

<!-- New Meeting Modal -->
<div id="new-meeting-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-calendar-plus"></i> Schedule New Meeting</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Student</label>
                    <select class="uk-select">
                        <option value="">Select student...</option>
                        <option>John Doe</option>
                        <option>Sarah Chen</option>
                        <option>Emma Wilson</option>
                        <option>David Kim</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Topic</label>
                    <input class="uk-input" type="text" placeholder="e.g., Application Review">
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Date</label>
                        <input class="uk-input" type="date">
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Time</label>
                        <input class="uk-input" type="time">
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Duration</label>
                    <select class="uk-select">
                        <option>30 minutes</option>
                        <option>45 minutes</option>
                        <option selected>60 minutes</option>
                        <option>90 minutes</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Platform</label>
                    <select class="uk-select">
                        <option>Zoom</option>
                        <option>Google Meet</option>
                        <option>Microsoft Teams</option>
                        <option>Phone</option>
                        <option>In-Person</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Notes (Optional)</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Meeting notes..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">
                <i class="fa-slab fa-solid fa-check"></i> Schedule Meeting
            </button>
        </div>
    </div>
</div>
