<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$student_id = $_GET['id'] ?? 1;

// Sample student data
$student = [
    'id' => $student_id,
    'name' => 'John Doe',
    'email' => 'john.doe@email.com',
    'phone' => '+1 (555) 123-4567',
    'status' => 'active',
    'joined' => '2024-01-15',
    'last_contact' => '2024-01-30',
    'initials' => 'JD',
    'gpa' => '3.9',
    'location' => 'San Francisco, CA'
];

$applications = [
    ['id' => 1, 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'status' => 'under_review', 'deadline' => '2024-02-15', 'progress' => 65],
    ['id' => 2, 'university' => 'MIT', 'program' => 'AI Research (MS)', 'status' => 'submitted', 'deadline' => '2024-02-20', 'progress' => 80],
    ['id' => 3, 'university' => 'UC Berkeley', 'program' => 'Data Science (MS)', 'status' => 'accepted', 'deadline' => '2024-01-30', 'progress' => 100]
];

$meetings = [
    ['title' => 'Application Review', 'date' => '2024-02-05', 'time' => '10:00 AM', 'type' => 'video'],
    ['title' => 'Interview Prep', 'date' => '2024-02-10', 'time' => '2:00 PM', 'type' => 'phone']
];

$notes = [
    ['text' => 'Strong candidate for Stanford - research background aligns well with program requirements. GPA 3.9, solid recommendation letters.', 'author' => 'You', 'date' => 'Jan 30', 'time' => '2:45 PM'],
    ['text' => 'Needs English proficiency scores before deadline. Reminded student via email.', 'author' => 'You', 'date' => 'Jan 28', 'time' => '10:30 AM'],
    ['text' => 'Initial consultation completed. Discussed timeline and application strategy.', 'author' => 'You', 'date' => 'Jan 15', 'time' => '11:00 AM']
];

$documents = [
    ['name' => 'Transcript', 'date' => '2024-01-25', 'type' => 'academic'],
    ['name' => 'Test Scores', 'date' => '2024-01-26', 'type' => 'test'],
    ['name' => 'Letters of Recommendation', 'date' => '2024-01-28', 'type' => 'letter']
];

$status_colors = [
    'submitted' => ['bg' => '#e2e8f0', 'text' => '#475569'],
    'under_review' => ['bg' => '#fef3c7', 'text' => '#92400e'],
    'interview_scheduled' => ['bg' => '#dbeafe', 'text' => '#1e40af'],
    'accepted' => ['bg' => '#d1fae5', 'text' => '#065f46'],
    'rejected' => ['bg' => '#fee2e2', 'text' => '#991b1b']
];
?>

<style>
.back-link {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: #64748b;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 24px;
    transition: all 0.2s ease;
}

.back-link:hover {
    color: #667eea;
    text-decoration: none;
}

.student-header-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 32px;
    color: white;
    margin-bottom: 24px;
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.2);
}

.student-avatar-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 28px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    backdrop-filter: blur(10px);
}

.student-name {
    font-size: 28px;
    font-weight: 700;
    margin: 0;
    color: white;
}

.student-email {
    font-size: 15px;
    color: rgba(255, 255, 255, 0.9);
    margin-top: 4px;
}

.student-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    margin-right: 8px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.2);
}

.modern-btn {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    border: none;
}

.modern-btn-white {
    background: white;
    color: #667eea;
}

.modern-btn-white:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(255, 255, 255, 0.3);
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
    margin-bottom: 24px;
}

.stat-card-modern {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.2s ease;
}

.stat-card-modern:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
}

.stat-label {
    font-size: 13px;
    color: #64748b;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 8px;
}

.stat-value-large {
    font-size: 32px;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, var(--gradient-from) 0%, var(--gradient-to) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
    margin-top: 24px;
}

@media (min-width: 1200px) {
    .content-grid {
        grid-template-columns: 2fr 1fr;
    }
}

.modern-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    margin-bottom: 20px;
}

.card-title {
    font-size: 18px;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.application-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border-left: 4px solid transparent;
    cursor: pointer;
}

.application-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    border-left-color: #667eea;
}

.meeting-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.meeting-item:hover {
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.meeting-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    flex-shrink: 0;
}

.note-item {
    padding: 16px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 12px;
    border-left: 3px solid #667eea;
}

.document-item {
    padding: 12px;
    border-radius: 8px;
    background: #f8fafc;
    margin-bottom: 8px;
    transition: all 0.2s ease;
}

.document-item:hover {
    background: #f1f5f9;
}

.status-badge {
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 600;
    text-transform: capitalize;
}

.progress-bar-small {
    width: 100%;
    height: 6px;
    background: #e2e8f0;
    border-radius: 3px;
    overflow: hidden;
    margin-top: 8px;
}

.progress-bar-fill {
    height: 100%;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    transition: width 0.3s ease;
}

@media (max-width: 959px) {
    .student-header-card {
        padding: 24px;
    }

    .student-name {
        font-size: 22px;
    }

    .student-avatar-large {
        width: 64px;
        height: 64px;
        font-size: 24px;
    }

    .modern-btn {
        font-size: 13px;
        padding: 8px 16px;
    }
}
</style>

<a href="<?= BASE_URL ?>/index.php"
   hx-get="<?= BASE_URL ?>/pages/students.php"
   hx-target="#main-content"
   hx-swap="innerHTML"
   hx-push-url="<?= BASE_URL ?>/students.php"
   class="back-link">
    <i class="fa-slab fa-solid fa-arrow-left"></i> Back to My Students
</a>

<!-- Student Header -->
<div class="student-header-card">
    <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
        <div style="display: flex; align-items: center; gap: 24px;">
            <div class="student-avatar-large"><?= $student['initials'] ?></div>
            <div>
                <h2 class="student-name"><?= e($student['name']) ?></h2>
                <div class="student-email"><?= e($student['email']) ?></div>
                <div>
                    <span class="student-badge"><i class="fa-slab fa-solid fa-check-circle"></i> <?= ucfirst($student['status']) ?></span>
                    <span class="student-badge"><i class="fa-slab fa-solid fa-map-marker-alt"></i> <?= e($student['location']) ?></span>
                </div>
            </div>
        </div>
        <div style="display: flex; gap: 12px; flex-wrap: wrap;">
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-envelope"></i> Message
            </button>
            <button class="modern-btn modern-btn-white">
                <i class="fa-slab fa-solid fa-calendar"></i> Schedule Meeting
            </button>
        </div>
    </div>
</div>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card-modern" style="--gradient-from: #667eea; --gradient-to: #764ba2;">
        <div class="stat-label">Total Applications</div>
        <div class="stat-value-large"><?= count($applications) ?></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #32d296; --gradient-to: #28b67f;">
        <div class="stat-label">Accepted</div>
        <div class="stat-value-large"><?= count(array_filter($applications, fn($a) => $a['status'] === 'accepted')) ?></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #faa05a; --gradient-to: #f48939;">
        <div class="stat-label">Upcoming Meetings</div>
        <div class="stat-value-large"><?= count($meetings) ?></div>
    </div>

    <div class="stat-card-modern" style="--gradient-from: #8b5cf6; --gradient-to: #7c3aed;">
        <div class="stat-label">GPA</div>
        <div class="stat-value-large"><?= $student['gpa'] ?></div>
    </div>
</div>

<!-- Main Content Grid -->
<div class="content-grid">
    <!-- Left Column -->
    <div>
        <!-- Applications -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-file-alt"></i> Applications (<?= count($applications) ?>)
            </h4>
            <?php foreach ($applications as $app):
                $status = $status_colors[$app['status']];
            ?>
            <div class="application-item"
                 hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= $app['id'] ?>"
                 hx-target="#main-content"
                 hx-swap="innerHTML"
                 hx-push-url="<?= BASE_URL ?>/application-detail.php?id=<?= $app['id'] ?>">
                <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 8px;">
                    <div style="flex: 1;">
                        <div style="font-weight: 600; color: #1a1a1a; font-size: 15px; margin-bottom: 4px;">
                            <?= e($app['university']) ?>
                        </div>
                        <div style="font-size: 13px; color: #64748b; margin-bottom: 4px;">
                            <?= e($app['program']) ?>
                        </div>
                        <div style="font-size: 12px; color: #94a3b8;">
                            <i class="fa-slab fa-solid fa-calendar"></i> Deadline: <?= date('M d, Y', strtotime($app['deadline'])) ?>
                        </div>
                    </div>
                    <span class="status-badge" style="background: <?= $status['bg'] ?>; color: <?= $status['text'] ?>;">
                        <?= str_replace('_', ' ', $app['status']) ?>
                    </span>
                </div>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span style="font-size: 12px; color: #667eea; font-weight: 600;">Progress: <?= $app['progress'] ?>%</span>
                </div>
                <div class="progress-bar-small">
                    <div class="progress-bar-fill" style="width: <?= $app['progress'] ?>%;"></div>
                </div>
            </div>
            <?php endforeach; ?>

            <button class="uk-button uk-button-primary uk-button-small uk-width-1-1" style="margin-top: 8px;">
                <i class="fa-slab fa-solid fa-plus"></i> Add Application
            </button>
        </div>

        <!-- Upcoming Meetings -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-calendar-check"></i> Upcoming Meetings
            </h4>
            <?php if (empty($meetings)): ?>
                <p style="color: #94a3b8; font-size: 14px;">No upcoming meetings</p>
            <?php else: ?>
                <?php foreach ($meetings as $meeting): ?>
                <div class="meeting-item">
                    <div style="display: flex; align-items: center; gap: 12px;">
                        <div class="meeting-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                            <i class="fa-slab fa-solid fa-<?= $meeting['type'] === 'video' ? 'video' : 'phone' ?>"></i>
                        </div>
                        <div style="flex: 1;">
                            <div style="font-weight: 600; color: #1a1a1a; font-size: 14px; margin-bottom: 2px;">
                                <?= e($meeting['title']) ?>
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                <i class="fa-slab fa-solid fa-calendar"></i> <?= date('M d, Y', strtotime($meeting['date'])) ?> at <?= e($meeting['time']) ?>
                            </div>
                        </div>
                        <button class="uk-button uk-button-default uk-button-small">
                            <i class="fa-slab fa-solid fa-ellipsis-v"></i>
                        </button>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>

            <button class="uk-button uk-button-primary uk-button-small uk-width-1-1" style="margin-top: 8px;">
                <i class="fa-slab fa-solid fa-plus"></i> Schedule Meeting
            </button>
        </div>

        <!-- Counselor Notes -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-sticky-note"></i> Counselor Notes
            </h4>
            <?php foreach ($notes as $note): ?>
            <div class="note-item">
                <div style="font-size: 14px; color: #1a1a1a; margin-bottom: 6px;"><?= e($note['text']) ?></div>
                <div style="font-size: 12px; color: #94a3b8;">
                    <?= e($note['author']) ?> • <?= e($note['date']) ?> at <?= e($note['time']) ?>
                </div>
            </div>
            <?php endforeach; ?>

            <div style="margin-top: 16px;">
                <textarea class="uk-textarea" rows="3" placeholder="Add a new note..."></textarea>
                <button class="uk-button uk-button-primary uk-button-small" style="margin-top: 8px;">
                    <i class="fa-slab fa-solid fa-plus"></i> Add Note
                </button>
            </div>
        </div>
    </div>

    <!-- Right Column -->
    <div>
        <!-- Student Information -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-user"></i> Student Information
            </h4>
            <dl style="margin: 0;">
                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">Email</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 16px; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-envelope fa-sm"></i> <?= e($student['email']) ?>
                </dd>

                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">Phone</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 16px; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-phone fa-sm"></i> <?= e($student['phone']) ?>
                </dd>

                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">GPA</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 16px; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-graduation-cap fa-sm"></i> <?= e($student['gpa']) ?>
                </dd>

                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">Location</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 16px; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-map-marker-alt fa-sm"></i> <?= e($student['location']) ?>
                </dd>

                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">Joined</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 16px; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-calendar-plus fa-sm"></i> <?= date('M d, Y', strtotime($student['joined'])) ?>
                </dd>

                <dt style="font-size: 13px; color: #64748b; font-weight: 500; margin-bottom: 4px;">Last Contact</dt>
                <dd style="font-size: 14px; color: #1a1a1a; margin-bottom: 0; margin-left: 0;">
                    <i class="fa-slab fa-solid fa-clock fa-sm"></i> <?= date('M d, Y', strtotime($student['last_contact'])) ?>
                </dd>
            </dl>
        </div>

        <!-- Documents -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-folder-open"></i> Documents
            </h4>
            <?php foreach ($documents as $doc): ?>
            <div class="document-item">
                <div style="display: flex; align-items: center; justify-content: space-between;">
                    <div style="display: flex; align-items: center; gap: 8px;">
                        <i class="fa-slab fa-solid fa-file-alt" style="color: #667eea;"></i>
                        <span style="font-size: 13px; color: #1a1a1a; font-weight: 500;"><?= e($doc['name']) ?></span>
                    </div>
                    <span style="font-size: 11px; color: #94a3b8;"><?= date('M d', strtotime($doc['date'])) ?></span>
                </div>
            </div>
            <?php endforeach; ?>

            <button class="uk-button uk-button-default uk-button-small uk-width-1-1" style="margin-top: 8px;">
                <i class="fa-slab fa-solid fa-upload"></i> Upload Document
            </button>
        </div>

        <!-- Quick Actions -->
        <div class="modern-card">
            <h4 class="card-title">
                <i class="fa-slab fa-solid fa-bolt"></i> Quick Actions
            </h4>
            <div style="display: flex; flex-direction: column; gap: 8px;">
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-envelope fa-fw"></i> Message Student
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-calendar fa-fw"></i> Schedule Meeting
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-edit fa-fw"></i> Edit Profile
                </button>
                <button class="uk-button uk-button-default uk-width-1-1" style="justify-content: flex-start;">
                    <i class="fa-slab fa-solid fa-download fa-fw"></i> Export Profile
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Re-initialize UIKit components for dynamically loaded content
if (typeof UIkit !== 'undefined') {
    UIkit.update();
}
</script>
