<?php
/**
 * Student Portal Configuration
 */

define('APP_NAME', 'Student Portal');
define('APP_VERSION', '1.0.0');
define('BASE_URL', '.');
define('PORTAL_TYPE', 'student');

// Navigation
$GLOBALS['portal_nav'] = [
    'overview' => ['label' => 'Overview', 'icon' => 'home'],
    'applications' => ['label' => 'Applications', 'icon' => 'file-alt'],
    'documents' => ['label' => 'Documents', 'icon' => 'folder'],
    'payments' => ['label' => 'Payments', 'icon' => 'credit-card'],
    'messages' => ['label' => 'Messages', 'icon' => 'envelope']
];

// Current user
$GLOBALS['current_user'] = [
    'id' => 1,
    'name' => 'John Doe',
    'email' => 'john.doe@email.com',
    'role' => 'student',
    'student_id' => 'GP2024001',
    'initials' => 'JD'
];

// Application statuses
$GLOBALS['application_statuses'] = [
    'submitted' => ['label' => 'Submitted', 'color' => 'secondary'],
    'under_review' => ['label' => 'Under Review', 'color' => 'warning'],
    'interview_scheduled' => ['label' => 'Interview Scheduled', 'color' => 'primary'],
    'accepted' => ['label' => 'Accepted', 'color' => 'success'],
    'rejected' => ['label' => 'Rejected', 'color' => 'danger']
];

// Priority levels
$GLOBALS['priority_levels'] = [
    'high' => ['label' => 'high', 'color' => 'danger'],
    'medium' => ['label' => 'medium', 'color' => 'warning'],
    'low' => ['label' => 'low', 'color' => 'secondary']
];
