<?php
if (!defined('APP_NAME')) {
    require_once __DIR__ . '/bootstrap.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title><?= e($page_title ?? 'Student Portal') ?> - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/css/uikit.min.css">
    <link rel="stylesheet" href="/assets/css/main.css">

    <!-- Font Awesome -->
    <script defer src="/assets/fonts/fontawesome/js/all.min.js"></script>
    <script defer src="/assets/fonts/fontawesome/js/slab-regular.min.js"></script>
    <script defer src="/your-path-to-fontawesome/js/brands.js"></script>

    <!-- Chart & Map Libraries -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/css/jsvectormap.min.css">
</head>
<body>
    <!-- Skip Link for Accessibility -->
    <a href="#main-content" class="skip-link">Skip to main content</a>

    <!-- Loading Indicator -->
    <div id="page-loader" class="page-loading" style="display: none;"></div>

    <!-- Toast Container -->
    <div id="toast-container" class="toast-container" aria-live="polite"></div>

    <header class="uk-background-default" uk-sticky>
        <nav class="uk-navbar-container">
            <div class="uk-container uk-container-expand">
                <div class="uk-navbar-primary" uk-navbar>
                    <div class="uk-navbar-left">
                        <a href="<?= BASE_URL ?>" class="uk-navbar-item uk-logo">
                            <span class="uk-border-circle uk-flex uk-flex-center uk-flex-middle" style="width: 32px; height: 32px; background: #1a1a1a; color: white; font-size: 12px; font-weight: 600;">GP</span>
                        </a>

                        <ul class="uk-navbar-nav uk-navbar-nav-primary uk-visible@m">
                            <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
                                <li class="<?= ($active_tab ?? 'overview') === $key ? 'uk-active' : '' ?>">
                                    <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                                       hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                                       hx-target="#main-content"
                                       hx-swap="innerHTML"
                                       hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php">
                                        <?= strtoupper(e($item['label'])) ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="uk-navbar-right">
                    <!-- Notifications Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link">
                            <span uk-icon="icon: bell"></span>
                            <span class="uk-badge uk-position-top-right" style="font-size: 10px; padding: 2px 5px;">2</span>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <div class="uk-dropdown-nav">
                                <div class="uk-nav-header uk-flex uk-flex-between uk-flex-middle">
                                    <span>Notifications</span>
                                    <a href="#" class="uk-text-small">Mark all read</a>
                                </div>
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li><a href="#"><div class="uk-text-small uk-text-bold">Application status updated</div><div class="uk-text-meta">MIT - Under Review</div><div class="uk-text-meta">1 hour ago</div></a></li>
                                    <li><a href="#"><div class="uk-text-small uk-text-bold">Document approved</div><div class="uk-text-meta">Transcript verified</div><div class="uk-text-meta">3 hours ago</div></a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li class="uk-text-center"><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML" class="uk-text-small">View all notifications</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Settings Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-icon-link"><span uk-icon="icon: cog"></span></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">Settings</li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: settings; ratio: 0.8" class="uk-margin-small-right"></span> General</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: lock; ratio: 0.8" class="uk-margin-small-right"></span> Security</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: bell; ratio: 0.8" class="uk-margin-small-right"></span> Notifications</a></li>
                                <li><a href="#" onclick="toggleDarkMode(); return false;"><span uk-icon="icon: paint-bucket; ratio: 0.8" class="uk-margin-small-right"></span> <span id="theme-toggle-text">Dark Mode</span></a></li>
                                <li class="uk-parent">
                                    <a href="#"><span uk-icon="icon: palette; ratio: 0.8" class="uk-margin-small-right"></span> Theme Skin <span uk-nav-parent-icon></span></a>
                                    <ul class="uk-nav-sub">
                                        <li><a href="#" onclick="switchThemeSkin(''); return false;"><span id="skin-default-check" class="uk-margin-small-right">✓</span> Default</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('oceanic'); return false;"><span id="skin-oceanic-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Oceanic</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('amethyst'); return false;"><span id="skin-amethyst-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Amethyst</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('violet'); return false;"><span id="skin-violet-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Violet</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('matrix'); return false;"><span id="skin-matrix-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Matrix</a></li>
                                        <li><a href="#" onclick="switchThemeSkin('noir'); return false;"><span id="skin-noir-check" class="uk-margin-small-right" style="visibility: hidden;">✓</span> Noir</a></li>
                                    </ul>
                                </li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: question; ratio: 0.8" class="uk-margin-small-right"></span> Help & Support</a></li>
                            </ul>
                        </div>
                    </div>

                    <!-- Profile Dropdown -->
                    <div class="uk-navbar-item">
                        <a href="#" class="uk-flex uk-flex-middle">
                            <?= get_avatar($GLOBALS['current_user']['name'], 36) ?>
                            <span uk-icon="icon: triangle-down; ratio: 0.7" class="uk-margin-small-left"></span>
                        </a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li class="uk-nav-header">
                                    <div class="uk-text-bold"><?= e($GLOBALS['current_user']['name']) ?></div>
                                    <div class="uk-text-meta">ID: <?= e($GLOBALS['current_user']['student_id']) ?></div>
                                </li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: user; ratio: 0.8" class="uk-margin-small-right"></span> My Profile</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: image; ratio: 0.8" class="uk-margin-small-right"></span> Change Avatar</a></li>
                                <li><a href="<?= BASE_URL ?>/profile.php" hx-get="<?= BASE_URL ?>/pages/profile.php" hx-target="#main-content" hx-swap="innerHTML"><span uk-icon="icon: lock; ratio: 0.8" class="uk-margin-small-right"></span> Change Password</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="/auth/login.php" class="uk-text-danger"><span uk-icon="icon: sign-out; ratio: 0.8" class="uk-margin-small-right"></span> Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
        <hr class="uk-margin-remove">
    </header>

    <div class="uk-container uk-container-large uk-margin-medium-top uk-margin-large-bottom">
        <div id="main-content"><?php if (isset($content)) echo $content; ?></div>
    </div>

    <div id="modal-container"></div>

    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-bottom-nav uk-hidden@m">
        <ul class="mobile-nav-items">
            <?php foreach ($GLOBALS['portal_nav'] as $key => $item): ?>
            <li class="mobile-nav-item">
                <a href="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                   class="mobile-nav-link <?= ($active_tab ?? 'overview') === $key ? 'active' : '' ?>"
                   hx-get="<?= BASE_URL ?>/pages/<?= $key ?>.php"
                   hx-target="#main-content"
                   hx-swap="innerHTML"
                   hx-push-url="<?= BASE_URL ?>/<?= $key === 'overview' ? 'index' : $key ?>.php"
                   data-nav-key="<?= $key ?>">
                    <i class="fa-slab fa-solid fa-<?= $item['icon'] ?> mobile-nav-icon"></i>
                    <span class="mobile-nav-label"><?= e($item['label']) ?></span>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
    </nav>

    <!-- Back to Top Button -->
    <button class="back-to-top" id="back-to-top" aria-label="Back to top" onclick="window.scrollTo({top: 0, behavior: 'smooth'})">
        <span uk-icon="icon: chevron-up"></span>
    </button>

    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.0/dist/js/uikit-icons.min.js"></script>
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    <script src="https://unpkg.com/hyperscript.org@0.9.12"></script>

    <!-- Chart & Map Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts@3.45.0/dist/apexcharts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/js/jsvectormap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsvectormap@1.5.3/dist/maps/world.js"></script>

    <script>
    // Toast Notification System
    function showToast(message, type = 'info', duration = 4000) {
        const container = document.getElementById('toast-container');
        const toast = document.createElement('div');
        toast.className = `toast toast-${type}`;
        toast.innerHTML = `
            <span uk-icon="icon: ${type === 'success' ? 'check' : type === 'error' ? 'warning' : type === 'warning' ? 'info' : 'info'}; ratio: 0.8"></span>
            <span>${message}</span>
            <span class="toast-close" onclick="this.parentElement.remove()" uk-icon="icon: close; ratio: 0.7"></span>
        `;
        container.appendChild(toast);
        UIkit.icon(toast);
        setTimeout(() => {
            toast.style.animation = 'slideOut 0.3s ease forwards';
            setTimeout(() => toast.remove(), 300);
        }, duration);
    }

    // Dark Mode Toggle
    function toggleDarkMode() {
        const html = document.documentElement;
        const isDark = html.getAttribute('data-theme') === 'dark';
        html.setAttribute('data-theme', isDark ? 'light' : 'dark');
        localStorage.setItem('theme', isDark ? 'light' : 'dark');
        document.getElementById('theme-toggle-text').textContent = isDark ? 'Dark Mode' : 'Light Mode';
        showToast(`${isDark ? 'Light' : 'Dark'} mode enabled`, 'info', 2000);
    }

    // Theme Skin Switcher (for testing - no persistence)
    function switchThemeSkin(skinName) {
        const html = document.documentElement;
        if (skinName) {
            html.setAttribute('data-skin', skinName);
        } else {
            html.removeAttribute('data-skin');
        }
        // Update checkmarks
        const defaultCheck = document.getElementById('skin-default-check');
        const oceanicCheck = document.getElementById('skin-oceanic-check');
        const amethystCheck = document.getElementById('skin-amethyst-check');
        const violetCheck = document.getElementById('skin-violet-check');
            const matrixCheck = document.getElementById('skin-matrix-check');
        const noirCheck = document.getElementById('skin-noir-check');
        if (defaultCheck) defaultCheck.style.visibility = skinName === '' ? 'visible' : 'hidden';
        if (oceanicCheck) oceanicCheck.style.visibility = skinName === 'oceanic' ? 'visible' : 'hidden';
        if (amethystCheck) amethystCheck.style.visibility = skinName === 'amethyst' ? 'visible' : 'hidden';
        if (violetCheck) violetCheck.style.visibility = skinName === 'violet' ? 'visible' : 'hidden';
            if (matrixCheck) matrixCheck.style.visibility = skinName === 'matrix' ? 'visible' : 'hidden';
        if (noirCheck) noirCheck.style.visibility = skinName === 'noir' ? 'visible' : 'hidden';
    }

    // Initialize theme from localStorage
    (function() {
        const savedTheme = localStorage.getItem('theme') || 'light';
        document.documentElement.setAttribute('data-theme', savedTheme);
        const toggleText = document.getElementById('theme-toggle-text');
        if (toggleText) toggleText.textContent = savedTheme === 'dark' ? 'Light Mode' : 'Dark Mode';
    })();

    // Back to Top Button
    window.addEventListener('scroll', function() {
        const btn = document.getElementById('back-to-top');
        if (window.scrollY > 300) {
            btn.classList.add('visible');
        } else {
            btn.classList.remove('visible');
        }
    });

    // HTMX Loading Indicator
    document.body.addEventListener('htmx:beforeRequest', function() {
        document.getElementById('page-loader').style.display = 'block';
    });
    document.body.addEventListener('htmx:afterRequest', function() {
        document.getElementById('page-loader').style.display = 'none';
    });

    // Keyboard Shortcuts
    document.addEventListener('keydown', function(e) {
        // Cmd/Ctrl + K for search focus
        if ((e.metaKey || e.ctrlKey) && e.key === 'k') {
            e.preventDefault();
            const searchInput = document.querySelector('input[type="search"]');
            if (searchInput) searchInput.focus();
        }
        // Escape to close modals
        if (e.key === 'Escape') {
            const modal = document.querySelector('.uk-modal.uk-open');
            if (modal) UIkit.modal(modal).hide();
        }
        // ? for keyboard shortcuts help
        if (e.key === '?' && !e.target.matches('input, textarea, select')) {
            showToast('Shortcuts: Ctrl+K (Search), Esc (Close), G+H (Home)', 'info', 5000);
        }
    });

    // Autosave for textareas
    document.querySelectorAll('textarea[data-autosave]').forEach(textarea => {
        const key = textarea.getAttribute('data-autosave');
        const saved = localStorage.getItem(key);
        if (saved) textarea.value = saved;

        let timeout;
        textarea.addEventListener('input', function() {
            clearTimeout(timeout);
            timeout = setTimeout(() => {
                localStorage.setItem(key, this.value);
                showToast('Draft saved', 'success', 1500);
            }, 1000);
        });
    });

    // Form submission feedback
    document.querySelectorAll('form').forEach(form => {
        form.addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"], .uk-button-primary');
            if (btn && !btn.disabled) {
                btn.disabled = true;
                btn.innerHTML = '<span uk-spinner="ratio: 0.5"></span> Saving...';
            }
        });
    });

    // Add ARIA labels to icon-only buttons
    document.querySelectorAll('a[uk-icon], button[uk-icon]').forEach(el => {
        if (!el.getAttribute('aria-label') && !el.textContent.trim()) {
            const icon = el.getAttribute('uk-icon');
            const match = icon.match(/icon:\s*([^;]+)/);
            if (match) el.setAttribute('aria-label', match[1].trim());
        }
    });

    // Mobile bottom nav active state management
    document.body.addEventListener('htmx:afterSwap', function(event) {
        if (event.detail.target.id === 'main-content') {
            // Update all nav links (desktop and mobile) active states
            document.querySelectorAll('.mobile-nav-link').forEach(function(link) {
                link.classList.remove('active');
            });
            // Set active on the triggering element if it exists
            if (event.detail.requestConfig && event.detail.requestConfig.elt) {
                event.detail.requestConfig.elt.classList.add('active');
            }
        }
    });
    </script>
    <style>
    /* Mobile Bottom Navigation */
    .mobile-bottom-nav {
        display: none;
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: white;
        box-shadow: 0 -2px 12px rgba(0, 0, 0, 0.1);
        z-index: 1000;
        padding: 8px 0 calc(8px + env(safe-area-inset-bottom));
    }

    @media (max-width: 959px) {
        .mobile-bottom-nav {
            display: block;
        }
    }

    .mobile-nav-items {
        display: flex;
        justify-content: space-around;
        align-items: center;
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .mobile-nav-item {
        flex: 1;
        display: flex;
        justify-content: center;
    }

    .mobile-nav-link {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 4px;
        padding: 8px 12px;
        text-decoration: none;
        color: #64748b;
        font-size: 11px;
        font-weight: 500;
        transition: all 0.2s ease;
        width: 100%;
        text-align: center;
    }

    .mobile-nav-link:hover {
        color: #475569;
        text-decoration: none;
    }

    .mobile-nav-icon {
        font-size: 20px;
        transition: all 0.2s ease;
    }

    .mobile-nav-link.active {
        color: #667eea;
    }

    .mobile-nav-link.active .mobile-nav-icon {
        color: #667eea;
        transform: scale(1.1);
    }

    .mobile-nav-label {
        display: block;
        line-height: 1.2;
    }

    @media (max-width: 640px) {
        .mobile-nav-label {
            display: none;
        }

        .mobile-nav-icon {
            font-size: 22px;
        }
    }

    /* Dark mode support */
    [data-theme="dark"] .mobile-bottom-nav {
        background: #1a1a1a;
        border-top: 1px solid #333;
    }

    [data-theme="dark"] .mobile-nav-link {
        color: #94a3b8;
    }

    [data-theme="dark"] .mobile-nav-link:hover {
        color: #cbd5e1;
    }

    [data-theme="dark"] .mobile-nav-link.active {
        color: #667eea;
    }

    /* Adjust main content padding on mobile */
    @media (max-width: 959px) {
        .uk-container.uk-container-large {
            padding-bottom: calc(80px + env(safe-area-inset-bottom)) !important;
        }

        /* Ensure back to top button doesn't conflict with bottom nav */
        .back-to-top {
            bottom: calc(80px + env(safe-area-inset-bottom)) !important;
        }
    }
    </style>
</body>
</html>
