<?php
require_once __DIR__ . '/includes/bootstrap.php';
$page_title = 'Welcome back, John!';
$page_description = 'Track your applications and stay updated on your progress.';
$active_tab = 'overview';
ob_start();

$stats = [
    ['icon' => 'file-text', 'value' => '3', 'label' => 'Total Applications', 'color' => 'primary'],
    ['icon' => 'check', 'value' => '1', 'label' => 'Accepted', 'color' => 'success'],
    ['icon' => 'clock', 'value' => '2', 'label' => 'In Progress', 'color' => 'warning'],
    ['icon' => 'warning', 'value' => '2', 'label' => 'Action Required', 'color' => 'danger']
];

$activities = [
    ['icon' => 'file-text', 'title' => 'Stanford University application status updated to "In Review"', 'time' => '2 hours ago', 'color' => 'primary'],
    ['icon' => 'comment', 'title' => 'New message from counselor about visa documentation', 'time' => '1 day ago', 'color' => 'success'],
    ['icon' => 'calendar', 'title' => 'Cambridge interview scheduled for February 5th', 'time' => '2 days ago', 'color' => 'warning'],
    ['icon' => 'check', 'title' => 'Transcript uploaded successfully for Toronto application', 'time' => '3 days ago', 'color' => 'cyan']
];

$tasks = [
    ['title' => 'Submit recommendation letters for Cambridge', 'university' => 'University of Cambridge', 'due' => '2024-02-10', 'priority' => 'high'],
    ['title' => 'Confirm enrollment at University of Toronto', 'university' => 'University of Toronto', 'due' => '2024-02-20', 'priority' => 'medium'],
    ['title' => 'Prepare for Stanford interview', 'university' => 'Stanford University', 'due' => '2024-02-05', 'priority' => 'high']
];

render_stat_cards($stats);
?>

<div class="uk-grid-small uk-margin-top" uk-grid>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><span uk-icon="icon: trending-up"></span> Recent Activity</h4>
            <?php foreach ($activities as $activity): ?>
                <div class="uk-flex uk-margin-small-bottom">
                    <div class="uk-border-circle uk-flex uk-flex-center uk-flex-middle uk-margin-right" style="width: 36px; height: 36px; min-width: 36px; <?= get_stat_icon_style($activity['color']) ?>">
                        <span uk-icon="icon: <?= $activity['icon'] ?>; ratio: 0.8"></span>
                    </div>
                    <div>
                        <div class="uk-text-small"><?= e($activity['title']) ?></div>
                        <div class="uk-text-muted uk-text-small"><?= e($activity['time']) ?></div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="uk-width-1-2@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><span uk-icon="icon: calendar"></span> Upcoming Tasks</h4>
            <?php foreach ($tasks as $task): ?>
                <div class="uk-card uk-card-default uk-card-body uk-card-small uk-margin-small-bottom">
                    <div class="uk-flex uk-flex-between uk-flex-middle">
                        <div>
                            <div class="uk-text-bold uk-text-small"><?= e($task['title']) ?></div>
                            <div class="uk-text-muted uk-text-small"><?= e($task['university']) ?></div>
                            <div class="uk-text-meta uk-text-small">Due: <?= e($task['due']) ?></div>
                        </div>
                        <span class="uk-label uk-label-<?= $GLOBALS['priority_levels'][$task['priority']]['color'] ?>"><?= $task['priority'] ?></span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/includes/layout.php';
?>
