<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Get application ID from URL
$app_id = $_GET['id'] ?? 'APP-2024-001';

// Sample application data
$application = [
    'id' => 'APP-2024-001',
    'university' => 'Stanford University',
    'program' => 'Master of Science in Computer Science',
    'status' => 'under_review',
    'progress' => 65,
    'submitted' => '2024-01-15',
    'deadline' => '2024-03-01',
    'days_until_deadline' => 35,
    'start_term' => 'Fall 2024',
    'degree_type' => 'Master\'s',
    'application_fee' => '$125',
    'fee_paid' => true
];

$timeline = [
    ['step' => 'Application Submitted', 'date' => 'Jan 15, 2024', 'time' => '2:30 PM', 'status' => 'completed', 'icon' => 'check', 'description' => 'Application successfully submitted and received'],
    ['step' => 'Initial Review', 'date' => 'Jan 18, 2024', 'time' => '10:00 AM', 'status' => 'completed', 'icon' => 'check', 'description' => 'Application passed initial screening'],
    ['step' => 'Document Verification', 'date' => 'Jan 22, 2024', 'time' => '3:45 PM', 'status' => 'completed', 'icon' => 'check', 'description' => 'All documents verified and accepted'],
    ['step' => 'Academic Review', 'date' => 'In Progress', 'time' => '', 'status' => 'current', 'icon' => 'clock', 'description' => 'Academic committee reviewing your application'],
    ['step' => 'Interview Schedule', 'date' => 'Pending', 'time' => '', 'status' => 'pending', 'icon' => 'calendar', 'description' => 'Interview invitation will be sent if selected'],
    ['step' => 'Final Decision', 'date' => 'Expected Mar 1', 'time' => '', 'status' => 'pending', 'icon' => 'flag-checkered', 'description' => 'Final admission decision']
];

$documents = [
    ['name' => 'Transcripts', 'status' => 'verified', 'date' => 'Jan 15, 2024', 'size' => '2.3 MB', 'type' => 'PDF'],
    ['name' => 'Statement of Purpose', 'status' => 'verified', 'date' => 'Jan 15, 2024', 'size' => '856 KB', 'type' => 'PDF'],
    ['name' => 'Letters of Recommendation (3)', 'status' => 'verified', 'date' => 'Jan 16, 2024', 'size' => '1.8 MB', 'type' => 'PDF'],
    ['name' => 'Resume/CV', 'status' => 'verified', 'date' => 'Jan 15, 2024', 'size' => '425 KB', 'type' => 'PDF'],
    ['name' => 'English Proficiency (TOEFL)', 'status' => 'pending', 'date' => 'Jan 20, 2024', 'size' => '1.2 MB', 'type' => 'PDF'],
    ['name' => 'Portfolio', 'status' => 'verified', 'date' => 'Jan 17, 2024', 'size' => '5.6 MB', 'type' => 'PDF']
];

$events = [
    ['title' => 'Interview with Admissions Committee', 'date' => 'Feb 15, 2024', 'time' => '10:00 AM PST', 'type' => 'video', 'location' => 'Zoom Meeting'],
    ['title' => 'Additional Documents Deadline', 'date' => 'Feb 20, 2024', 'time' => '11:59 PM PST', 'type' => 'deadline', 'location' => 'Online Portal']
];

$counselor = [
    'name' => 'Dr. Sarah Johnson',
    'title' => 'Senior Admissions Counselor',
    'email' => 'sarah.j@gep.com',
    'phone' => '+1 (555) 123-4567',
    'avatar' => 'SJ',
    'online' => true
];

$notes = [
    ['date' => 'Jan 25, 2024', 'author' => 'Dr. Sarah Johnson', 'text' => 'Strong academic background. GPA and test scores meet requirements. Statement of purpose is well-written and shows clear motivation.'],
    ['date' => 'Jan 20, 2024', 'author' => 'Dr. Sarah Johnson', 'text' => 'All required documents received. Recommendation letters are excellent and highlight research potential.']
];

// Status badge helper
function get_detail_status_badge($status) {
    $badges = [
        'draft' => '<span class="uk-label uk-label-muted"><i class="fa-solid fa-pencil fa-xs"></i> Draft</span>',
        'incomplete' => '<span class="uk-label" style="background: #f0506e;"><i class="fa-solid fa-exclamation-triangle fa-xs"></i> Incomplete</span>',
        'under_review' => '<span class="uk-label" style="background: #faa05a;"><i class="fa-solid fa-clock fa-xs"></i> Under Review</span>',
        'interview_scheduled' => '<span class="uk-label uk-label-warning"><i class="fa-solid fa-calendar-check fa-xs"></i> Interview Scheduled</span>',
        'accepted' => '<span class="uk-label uk-label-success"><i class="fa-solid fa-check-circle fa-xs"></i> Accepted</span>',
        'rejected' => '<span class="uk-label uk-label-danger"><i class="fa-solid fa-times-circle fa-xs"></i> Rejected</span>',
        'waitlisted' => '<span class="uk-label" style="background: #32d296;"><i class="fa-solid fa-hourglass-half fa-xs"></i> Waitlisted</span>'
    ];
    return $badges[$status] ?? '<span class="uk-label">' . e(ucwords(str_replace('_', ' ', $status))) . '</span>';
}
?>

<style>
.detail-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 8px;
    padding: 24px;
    margin-bottom: 24px;
}

.detail-header h2 {
    color: white;
    margin: 0 0 8px 0;
}

.detail-progress-circle {
    position: relative;
    width: 80px;
    height: 80px;
}

.detail-progress-circle svg {
    transform: rotate(-90deg);
}

.detail-progress-text {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 20px;
    font-weight: bold;
    color: white;
}

.timeline-container {
    position: relative;
    padding-left: 40px;
}

.timeline-item {
    position: relative;
    padding-bottom: 32px;
}

.timeline-item:last-child {
    padding-bottom: 0;
}

.timeline-item::before {
    content: '';
    position: absolute;
    left: -25px;
    top: 0;
    bottom: -32px;
    width: 2px;
    background: #e5e5e5;
}

.timeline-item:last-child::before {
    display: none;
}

.timeline-icon {
    position: absolute;
    left: -36px;
    top: 0;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    z-index: 1;
}

.timeline-icon.completed {
    background: #32d296;
    color: white;
}

.timeline-icon.current {
    background: #faa05a;
    color: white;
    animation: pulse 2s infinite;
}

.timeline-icon.pending {
    background: #e5e5e5;
    color: #999;
}

@keyframes pulse {
    0%, 100% { box-shadow: 0 0 0 0 rgba(250, 160, 90, 0.7); }
    50% { box-shadow: 0 0 0 10px rgba(250, 160, 90, 0); }
}

.document-grid-item {
    position: relative;
    z-index: 1;
    transition: all 0.2s ease;
}

.document-grid-item:hover {
    z-index: 10;
    box-shadow: 0 3px 12px rgba(0,0,0,0.08);
}

.document-grid-item:has(.uk-open) {
    z-index: 10;
}

.document-grid-item .uk-dropdown {
    z-index: 1020 !important;
}

.stat-card {
    text-align: center;
    padding: 16px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    backdrop-filter: blur(10px);
}

.stat-card-icon {
    font-size: 24px;
    margin-bottom: 8px;
    opacity: 0.9;
}

.stat-card-value {
    font-size: 18px;
    font-weight: bold;
    margin-bottom: 4px;
}

.stat-card-label {
    font-size: 12px;
    opacity: 0.8;
}

.event-card {
    border-left: 4px solid;
    padding-left: 16px;
}

.event-card.event-video {
    border-color: #1e87f0;
}

.event-card.event-deadline {
    border-color: #faa05a;
}

.counselor-avatar {
    position: relative;
    width: 64px;
    height: 64px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 24px;
}

.counselor-online-indicator {
    position: absolute;
    bottom: 2px;
    right: 2px;
    width: 16px;
    height: 16px;
    background: #32d296;
    border: 3px solid white;
    border-radius: 50%;
}

.note-item {
    border-left: 3px solid #e5e5e5;
    padding-left: 16px;
}

@media (max-width: 959px) {
    .timeline-container {
        padding-left: 32px;
    }

    .detail-header {
        padding: 16px;
    }

    .stat-card {
        padding: 12px;
    }
}
</style>

<!-- Back Button -->
<div class="uk-margin-bottom">
    <a href="<?= BASE_URL ?>/applications.php"
       hx-get="<?= BASE_URL ?>/pages/applications.php"
       hx-target="#main-content"
       hx-swap="innerHTML"
       class="uk-button uk-button-default uk-button-small">
        <i class="fa-solid fa-arrow-left"></i> Back to Applications
    </a>
</div>

<!-- Application Header -->
<div class="detail-header">
    <div class="uk-grid uk-grid-small" uk-grid>
        <div class="uk-width-expand">
            <h2><?= e($application['university']) ?></h2>
            <p class="uk-margin-remove" style="opacity: 0.9;"><?= e($application['program']) ?></p>
            <div class="uk-margin-small-top" style="opacity: 0.8;">
                <code style="background: rgba(255,255,255,0.2); padding: 4px 8px; border-radius: 4px;"><?= e($application['id']) ?></code>
            </div>

            <!-- Stats Grid -->
            <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-child-width-1-4@s uk-margin-top" uk-grid>
                <div>
                    <div class="stat-card">
                        <div class="stat-card-icon"><i class="fa-solid fa-calendar"></i></div>
                        <div class="stat-card-value"><?= date('M d', strtotime($application['deadline'])) ?></div>
                        <div class="stat-card-label">Deadline</div>
                    </div>
                </div>
                <div>
                    <div class="stat-card">
                        <div class="stat-card-icon"><i class="fa-solid fa-check-circle"></i></div>
                        <div class="stat-card-value"><?= date('M d', strtotime($application['submitted'])) ?></div>
                        <div class="stat-card-label">Submitted</div>
                    </div>
                </div>
                <div>
                    <div class="stat-card">
                        <div class="stat-card-icon"><i class="fa-solid fa-calendar-days"></i></div>
                        <div class="stat-card-value"><?= $application['start_term'] ?></div>
                        <div class="stat-card-label">Start Term</div>
                    </div>
                </div>
                <div>
                    <div class="stat-card">
                        <div class="stat-card-icon"><i class="fa-solid fa-credit-card"></i></div>
                        <div class="stat-card-value"><?= $application['fee_paid'] ? '<i class="fa-solid fa-check"></i>' : $application['application_fee'] ?></div>
                        <div class="stat-card-label">App Fee</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status and Progress -->
        <div class="uk-width-auto uk-text-center">
            <div class="detail-progress-circle uk-margin-bottom">
                <svg width="80" height="80">
                    <circle cx="40" cy="40" r="32" fill="none" stroke="rgba(255,255,255,0.3)" stroke-width="6"/>
                    <circle cx="40" cy="40" r="32" fill="none" stroke="white" stroke-width="6"
                            stroke-dasharray="<?= $application['progress'] * 2.01 ?>, 201"
                            stroke-linecap="round"/>
                </svg>
                <div class="detail-progress-text"><?= $application['progress'] ?>%</div>
            </div>
            <?= get_detail_status_badge($application['status']) ?>
        </div>
    </div>
</div>

<!-- Main Content Grid -->
<div class="uk-grid uk-grid-medium" uk-grid>
    <!-- Left Column -->
    <div class="uk-width-1-1 uk-width-2-3@m">
        <!-- Application Timeline -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-list-check"></i> Application Timeline</h4>
            <div class="timeline-container">
                <?php foreach ($timeline as $item): ?>
                <div class="timeline-item">
                    <div class="timeline-icon <?= $item['status'] ?>">
                        <i class="fa-solid fa-<?= $item['icon'] ?>"></i>
                    </div>
                    <div class="<?= $item['status'] === 'pending' ? 'uk-text-muted' : '' ?>">
                        <div class="uk-text-bold"><?= e($item['step']) ?></div>
                        <div class="uk-text-small uk-text-muted">
                            <?= e($item['date']) ?><?= $item['time'] ? ' • ' . e($item['time']) : '' ?>
                        </div>
                        <?php if ($item['description']): ?>
                        <div class="uk-text-small uk-margin-small-top" style="opacity: 0.8;">
                            <?= e($item['description']) ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Submitted Documents -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
                <h4 class="uk-margin-remove"><i class="fa-solid fa-folder-open"></i> Submitted Documents</h4>
                <button class="uk-button uk-button-primary uk-button-small">
                    <i class="fa-solid fa-plus"></i> Upload
                </button>
            </div>

            <div class="uk-grid uk-grid-small uk-child-width-1-1" uk-grid>
                <?php foreach ($documents as $doc): ?>
                <div>
                    <div class="document-grid-item uk-card uk-card-small" style="background: #fafafa; border-radius: 4px; padding: 12px;">
                        <div class="uk-grid uk-grid-small uk-flex-middle" uk-grid>
                            <!-- Icon -->
                            <div class="uk-width-auto">
                                <?php if ($doc['status'] === 'verified'): ?>
                                    <div style="width: 40px; height: 40px; background: #32d296; border-radius: 4px; display: flex; align-items: center; justify-content: center; color: white;">
                                        <i class="fa-solid fa-file-pdf"></i>
                                    </div>
                                <?php else: ?>
                                    <div style="width: 40px; height: 40px; background: #faa05a; border-radius: 4px; display: flex; align-items: center; justify-content: center; color: white;">
                                        <i class="fa-solid fa-file-pdf"></i>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Desktop Layout -->
                            <div class="uk-width-expand uk-visible@s">
                                <div class="uk-grid uk-grid-small uk-flex-middle" uk-grid>
                                    <div class="uk-width-expand">
                                        <div class="uk-text-bold uk-text-small"><?= e($doc['name']) ?></div>
                                        <div class="uk-text-meta uk-text-small">
                                            <?= e($doc['type']) ?> • <?= e($doc['size']) ?> • <?= e($doc['date']) ?>
                                        </div>
                                    </div>
                                    <div class="uk-width-auto">
                                        <?php if ($doc['status'] === 'verified'): ?>
                                            <span class="uk-text-success"><i class="fa-solid fa-check-circle"></i> Verified</span>
                                        <?php else: ?>
                                            <span class="uk-text-warning"><i class="fa-solid fa-clock"></i> Pending</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="uk-width-auto">
                                        <button class="uk-button uk-button-default uk-button-small" type="button">
                                            <i class="fa-solid fa-ellipsis-vertical"></i>
                                        </button>
                                        <div uk-dropdown="mode: click; pos: bottom-right">
                                            <ul class="uk-nav uk-dropdown-nav">
                                                <li><a href="#"><i class="fa-solid fa-download fa-fw"></i> Download</a></li>
                                                <li><a href="#"><i class="fa-solid fa-eye fa-fw"></i> Preview</a></li>
                                                <li class="uk-nav-divider"></li>
                                                <li><a href="#" class="uk-text-danger"><i class="fa-solid fa-trash fa-fw"></i> Delete</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Mobile Layout -->
                            <div class="uk-width-expand uk-hidden@s">
                                <div class="uk-text-bold uk-text-small"><?= e($doc['name']) ?></div>
                                <div class="uk-text-meta uk-text-small"><?= e($doc['size']) ?> • <?= e($doc['date']) ?></div>
                                <div class="uk-margin-small-top">
                                    <?php if ($doc['status'] === 'verified'): ?>
                                        <span class="uk-text-success uk-text-small"><i class="fa-solid fa-check-circle"></i> Verified</span>
                                    <?php else: ?>
                                        <span class="uk-text-warning uk-text-small"><i class="fa-solid fa-clock"></i> Pending</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Counselor Notes -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><i class="fa-solid fa-note-sticky"></i> Counselor Notes</h4>
            <?php if (empty($notes)): ?>
                <p class="uk-text-muted uk-text-small">No notes yet</p>
            <?php else: ?>
                <div class="uk-grid uk-grid-small uk-child-width-1-1" uk-grid>
                    <?php foreach ($notes as $note): ?>
                    <div>
                        <div class="note-item">
                            <div class="uk-text-small uk-text-muted uk-margin-small-bottom">
                                <i class="fa-solid fa-user"></i> <?= e($note['author']) ?> • <?= e($note['date']) ?>
                            </div>
                            <div class="uk-text-small"><?= e($note['text']) ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Right Column -->
    <div class="uk-width-1-1 uk-width-1-3@m">
        <!-- Quick Actions -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-bolt"></i> Quick Actions</h4>
            <div class="uk-grid uk-grid-small uk-child-width-1-1" uk-grid>
                <div>
                    <button class="uk-button uk-button-primary uk-width-1-1 uk-button-small">
                        <i class="fa-solid fa-upload"></i> Upload Documents
                    </button>
                </div>
                <div>
                    <button class="uk-button uk-button-default uk-width-1-1 uk-button-small">
                        <i class="fa-solid fa-envelope"></i> Message Counselor
                    </button>
                </div>
                <div>
                    <button class="uk-button uk-button-default uk-width-1-1 uk-button-small">
                        <i class="fa-solid fa-calendar"></i> Schedule Call
                    </button>
                </div>
                <div>
                    <button class="uk-button uk-button-default uk-width-1-1 uk-button-small">
                        <i class="fa-solid fa-download"></i> Download Summary
                    </button>
                </div>
                <div>
                    <button class="uk-button uk-button-danger uk-width-1-1 uk-button-small">
                        <i class="fa-solid fa-times"></i> Withdraw Application
                    </button>
                </div>
            </div>
        </div>

        <!-- Upcoming Events -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-calendar-days"></i> Upcoming Events</h4>
            <?php if (empty($events)): ?>
                <p class="uk-text-muted uk-text-small">No upcoming events</p>
            <?php else: ?>
                <div class="uk-grid uk-grid-small uk-child-width-1-1" uk-grid>
                    <?php foreach ($events as $event): ?>
                    <div>
                        <div class="event-card event-<?= $event['type'] ?> uk-card uk-card-small" style="background: #fafafa; border-radius: 4px; padding: 12px;">
                            <div class="uk-text-bold uk-text-small"><?= e($event['title']) ?></div>
                            <div class="uk-text-small uk-margin-small-top">
                                <div><i class="fa-solid fa-calendar fa-fw"></i> <?= e($event['date']) ?></div>
                                <div><i class="fa-solid fa-clock fa-fw"></i> <?= e($event['time']) ?></div>
                                <div><i class="fa-solid fa-location-dot fa-fw"></i> <?= e($event['location']) ?></div>
                            </div>
                            <div class="uk-margin-small-top">
                                <a href="#" class="uk-button uk-button-primary uk-button-small uk-width-1-1">
                                    <i class="fa-solid fa-bell"></i> Add Reminder
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Counselor Contact -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><i class="fa-solid fa-user-tie"></i> Your Counselor</h4>
            <div class="uk-flex uk-flex-middle uk-margin-bottom">
                <div class="counselor-avatar">
                    <?= e($counselor['avatar']) ?>
                    <?php if ($counselor['online']): ?>
                        <div class="counselor-online-indicator"></div>
                    <?php endif; ?>
                </div>
                <div class="uk-margin-left">
                    <div class="uk-text-bold"><?= e($counselor['name']) ?></div>
                    <div class="uk-text-small uk-text-muted"><?= e($counselor['title']) ?></div>
                    <?php if ($counselor['online']): ?>
                        <div class="uk-text-small uk-text-success"><i class="fa-solid fa-circle fa-xs"></i> Online now</div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="uk-text-small">
                <div class="uk-margin-small-bottom">
                    <i class="fa-solid fa-envelope fa-fw uk-text-muted"></i>
                    <a href="mailto:<?= e($counselor['email']) ?>"><?= e($counselor['email']) ?></a>
                </div>
                <div class="uk-margin-small-bottom">
                    <i class="fa-solid fa-phone fa-fw uk-text-muted"></i>
                    <a href="tel:<?= e($counselor['phone']) ?>"><?= e($counselor['phone']) ?></a>
                </div>
            </div>
            <div class="uk-margin-top">
                <button class="uk-button uk-button-primary uk-button-small uk-width-1-1">
                    <i class="fa-solid fa-comment"></i> Send Message
                </button>
            </div>
        </div>
    </div>
</div>
