<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$documents = [
    ['name' => 'Transcript - Bachelor\'s Degree', 'description' => 'Official transcript from undergraduate institution', 'category' => 'Academic', 'type' => 'Academic Transcript', 'uploaded' => '2024-01-05', 'status' => 'verified', 'size' => '2.4 MB', 'required' => true],
    ['name' => 'Letter of Recommendation - Prof. Smith', 'description' => 'Recommendation from Computer Science Department Head', 'category' => 'Recommendations', 'type' => 'Letter of Recommendation', 'uploaded' => '2024-01-08', 'status' => 'verified', 'size' => '156 KB', 'required' => true],
    ['name' => 'Statement of Purpose', 'description' => 'Personal statement for Stanford MS program', 'category' => 'Essays', 'type' => 'Statement of Purpose', 'uploaded' => '2024-01-10', 'status' => 'verified', 'size' => '89 KB', 'required' => true],
    ['name' => 'Resume/CV', 'description' => '', 'category' => 'Personal', 'type' => 'Resume/CV', 'uploaded' => '2024-01-12', 'status' => 'verified', 'size' => '245 KB', 'required' => true],
    ['name' => 'Passport Copy', 'description' => 'Valid until 2029', 'category' => 'Identity', 'type' => 'Passport', 'uploaded' => '2024-01-15', 'status' => 'pending', 'size' => '1.8 MB', 'required' => true],
    ['name' => 'Financial Statement', 'description' => 'Bank statement showing proof of funds', 'category' => 'Financial', 'type' => 'Bank Statement', 'uploaded' => '2024-01-18', 'status' => 'review', 'size' => '3.2 MB', 'required' => true],
    ['name' => 'TOEFL Score Report', 'description' => '', 'category' => 'Academic', 'type' => 'Test Score', 'uploaded' => '2024-01-20', 'status' => 'verified', 'size' => '125 KB', 'required' => false],
    ['name' => 'Letter of Recommendation - Dr. Johnson', 'description' => 'Academic reference from thesis advisor', 'category' => 'Recommendations', 'type' => 'Letter of Recommendation', 'uploaded' => '2024-01-22', 'status' => 'verified', 'size' => '178 KB', 'required' => false],
];

// Handle HTMX search request
if (isset($_POST['search'])) {
    $search = strtolower(trim($_POST['search']));
    $filtered_documents = [];

    if (!empty($search)) {
        foreach ($documents as $doc) {
            $searchable = strtolower($doc['name'] . ' ' . $doc['description'] . ' ' . $doc['category'] . ' ' . $doc['type'] . ' ' . $doc['status']);
            if (strpos($searchable, $search) !== false) {
                $filtered_documents[] = $doc;
            }
        }
    } else {
        $filtered_documents = $documents;
    }

    // Return only the document items for HTMX
    $status_colors = ['verified' => 'success', 'pending' => 'warning', 'review' => 'primary'];
    foreach ($filtered_documents as $doc):
?>
            <div class="document-item uk-card uk-card-default uk-card-small uk-margin-small-top" data-category="<?= e($doc['category']) ?>">
                <div class="uk-card-body uk-padding-small">
                    <!-- Desktop Layout -->
                    <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                        <div class="uk-width-expand">
                            <div class="uk-flex uk-flex-middle">
                                <?php if ($doc['required']): ?>
                                <span class="uk-text-danger uk-margin-small-right" uk-tooltip="Required Document" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-exclamation-triangle"></i></span>
                                <?php else: ?>
                                <span class="uk-margin-small-right" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-file"></i></span>
                                <?php endif; ?>
                                <div>
                                    <div class="uk-text-bold"><?= e($doc['name']) ?></div>
                                    <?php if (!empty($doc['description'])): ?>
                                    <div class="uk-text-meta uk-text-small"><?= e($doc['description']) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-small">
                            <span class="uk-label uk-label-secondary"><?= e($doc['category']) ?></span>
                        </div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['type']) ?></div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['uploaded']) ?></div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['size']) ?></div>
                        <div class="uk-width-small">
                            <span class="uk-label uk-label-<?= $status_colors[$doc['status']] ?>"><?= e($doc['status']) ?></span>
                        </div>
                        <div class="uk-width-auto uk-text-right" style="width: 60px;">
                            <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                            <div uk-dropdown="mode: click; pos: bottom-right">
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li class="uk-nav-header">Actions</li>
                                    <li><a href="#" uk-toggle="target: #preview-document-modal"><i class="fa-slab fa-solid fa-eye fa-fw"></i> Preview</a></li>
                                    <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download</a></li>
                                    <li><a href="#" uk-toggle="target: #rename-document-modal"><i class="fa-slab fa-solid fa-pencil fa-fw"></i> Rename</a></li>
                                    <li><a href="#" uk-toggle="target: #move-document-modal"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Move to Folder</a></li>
                                    <li><a href="#" uk-toggle="target: #share-document-modal"><i class="fa-slab fa-solid fa-link fa-fw"></i> Share</a></li>
                                    <li><a href="#" uk-toggle="target: #replace-document-modal"><i class="fa-slab fa-solid fa-upload fa-fw"></i> Replace</a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-document-modal"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Mobile Layout -->
                    <div class="uk-hidden@m">
                        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                            <div class="uk-flex uk-flex-middle uk-width-expand">
                                <?php if ($doc['required']): ?>
                                <span class="uk-text-danger uk-margin-small-right" uk-tooltip="Required Document" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-exclamation-triangle"></i></span>
                                <?php else: ?>
                                <span class="uk-margin-small-right" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-file"></i></span>
                                <?php endif; ?>
                                <div class="uk-width-expand" style="min-width: 0;">
                                    <div class="uk-text-bold uk-text-small"><?= e($doc['name']) ?></div>
                                    <?php if (!empty($doc['description'])): ?>
                                    <div class="uk-text-meta" style="font-size: 0.7rem;"><?= e($doc['description']) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="uk-flex-none">
                                <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                                <div uk-dropdown="mode: click; pos: bottom-right">
                                    <ul class="uk-nav uk-dropdown-nav">
                                        <li class="uk-nav-header">Actions</li>
                                        <li><a href="#" uk-toggle="target: #preview-document-modal"><i class="fa-slab fa-solid fa-eye fa-fw"></i> Preview</a></li>
                                        <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download</a></li>
                                        <li><a href="#" uk-toggle="target: #rename-document-modal"><i class="fa-slab fa-solid fa-pencil fa-fw"></i> Rename</a></li>
                                        <li><a href="#" uk-toggle="target: #move-document-modal"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Move to Folder</a></li>
                                        <li><a href="#" uk-toggle="target: #share-document-modal"><i class="fa-slab fa-solid fa-link fa-fw"></i> Share</a></li>
                                        <li><a href="#" uk-toggle="target: #replace-document-modal"><i class="fa-slab fa-solid fa-upload fa-fw"></i> Replace</a></li>
                                        <li class="uk-nav-divider"></li>
                                        <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-document-modal"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-text-small" uk-grid>
                            <div>
                                <div class="uk-text-meta">Category</div>
                                <span class="uk-label uk-label-secondary" style="font-size: 0.65rem;"><?= e($doc['category']) ?></span>
                            </div>
                            <div>
                                <div class="uk-text-meta">Type</div>
                                <div><?= e($doc['type']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Uploaded</div>
                                <div><?= e($doc['uploaded']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Size</div>
                                <div><?= e($doc['size']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Status</div>
                                <span class="uk-label uk-label-<?= $status_colors[$doc['status']] ?>" style="font-size: 0.65rem;"><?= e($doc['status']) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
<?php
    endforeach;
    exit; // Stop execution for HTMX requests
}

$categories = ['All', 'Academic', 'Financial', 'Identity', 'Essays', 'Recommendations', 'Personal'];

// Category to icon mapping (Font Awesome)
$category_icons = [
    'Academic' => 'fa-landmark',
    'Financial' => 'fa-money-bill-wave',
    'Identity' => 'fa-address-card',
    'Essays' => 'fa-pencil',
    'Recommendations' => 'fa-star',
    'Personal' => 'fa-user'
];

// Document types organized by category
$document_types = [
    'Academic' => ['Academic Transcript', 'Test Score', 'Diploma/Certificate', 'Course Syllabus'],
    'Recommendations' => ['Letter of Recommendation', 'Reference Letter'],
    'Essays' => ['Statement of Purpose', 'Personal Statement', 'Research Proposal', 'Writing Sample'],
    'Personal' => ['Resume/CV', 'Portfolio', 'Work Experience Letter'],
    'Identity' => ['Passport', 'National ID', 'Birth Certificate', 'Photo ID'],
    'Financial' => ['Bank Statement', 'Scholarship Letter', 'Sponsorship Letter', 'Tax Documents'],
];

$status_colors = ['verified' => 'success', 'pending' => 'warning', 'review' => 'primary'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
    <h3 class="uk-margin-remove mobile-mb"><i class="fa-slab fa-solid fa-folder-open"></i> My Documents</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right" uk-toggle="target: #new-folder-modal">
            <i class="fa-slab fa-solid fa-folder-plus"></i> New Folder
        </button>
        <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #upload-document-modal">
            <i class="fa-slab fa-solid fa-cloud-upload"></i> Upload Document
        </button>
    </div>
</div>

<div class="uk-card uk-card-default uk-card-body">
    <!-- Filter Controls -->
    <div class="uk-grid-small uk-child-width-auto uk-margin-bottom" uk-grid>
        <div>
            <div class="uk-margin-small-bottom uk-text-bold uk-text-small">Filter by Category:</div>
            <ul id="category-filter" class="uk-subnav uk-subnav-pill" uk-filter="target: #documents-tbody">
                <?php foreach ($categories as $i => $cat): ?>
                <li <?= $i === 0 ? 'class="uk-active"' : '' ?> uk-filter-control="<?= $cat === 'All' ? '' : '[data-category=\'' . $cat . '\']' ?>" data-filter-name="<?= e($cat) ?>">
                    <a href="#">
                        <?php if ($cat === 'All'): ?>
                            <?= e($cat) ?>
                        <?php else: ?>
                            <span class="uk-visible@m"><?= e($cat) ?></span>
                            <i class="fa-slab fa-solid <?= $category_icons[$cat] ?> uk-hidden@m" uk-tooltip="title: <?= e($cat) ?>; pos: bottom"></i>
                        <?php endif; ?>
                    </a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>

    <!-- Search Box -->
    <div class="uk-margin-bottom uk-inline uk-width-medium">
        <span class="uk-form-icon"><i class="fa-slab fa-solid fa-search"></i></span>
        <input class="uk-input uk-form-width-medium"
               type="search"
               name="search"
               id="document-search"
               placeholder="Search documents..."
               hx-post="<?= BASE_URL ?>/pages/documents.php"
               hx-trigger="keyup changed delay:300ms, search"
               hx-target="#documents-tbody"
               hx-indicator="#search-spinner"
               hx-swap="innerHTML"
               _="on keyup
                    if my value.trim() is not ''
                        call resetFilterToAll()
                    end"
               style="padding-right: 35px;">
        <span id="search-spinner" class="htmx-indicator" uk-spinner="ratio: 0.6" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%);"></span>
    </div>

    <!-- Documents Grid -->
    <div class="documents-grid">
        <!-- Grid Header (Desktop Only) -->
        <div class="documents-grid-header uk-visible@m">
            <div class="uk-grid uk-grid-small uk-grid-divider uk-text-small uk-text-bold uk-text-muted" uk-grid>
                <div class="uk-width-expand">Document Name</div>
                <div class="uk-width-small">Category</div>
                <div class="uk-width-small">Type</div>
                <div class="uk-width-small">Uploaded</div>
                <div class="uk-width-small">Size</div>
                <div class="uk-width-small">Status</div>
                <div class="uk-width-auto" style="width: 60px;"></div>
            </div>
        </div>

        <!-- Grid Body -->
        <div id="documents-tbody">
            <?php foreach ($documents as $doc): ?>
            <div class="document-item uk-card uk-card-default uk-card-small uk-margin-small-top" data-category="<?= e($doc['category']) ?>">
                <div class="uk-card-body uk-padding-small">
                    <!-- Desktop Layout -->
                    <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                        <div class="uk-width-expand">
                            <div class="uk-flex uk-flex-middle">
                                <?php if ($doc['required']): ?>
                                <span class="uk-text-danger uk-margin-small-right" uk-tooltip="Required Document" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-exclamation-triangle"></i></span>
                                <?php else: ?>
                                <span class="uk-margin-small-right" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-file"></i></span>
                                <?php endif; ?>
                                <div>
                                    <div class="uk-text-bold"><?= e($doc['name']) ?></div>
                                    <?php if (!empty($doc['description'])): ?>
                                    <div class="uk-text-meta uk-text-small"><?= e($doc['description']) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-small">
                            <span class="uk-label uk-label-secondary"><?= e($doc['category']) ?></span>
                        </div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['type']) ?></div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['uploaded']) ?></div>
                        <div class="uk-width-small uk-text-small"><?= e($doc['size']) ?></div>
                        <div class="uk-width-small">
                            <span class="uk-label uk-label-<?= $status_colors[$doc['status']] ?>"><?= e($doc['status']) ?></span>
                        </div>
                        <div class="uk-width-auto uk-text-right" style="width: 60px;">
                            <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                            <div uk-dropdown="mode: click; pos: bottom-right">
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li class="uk-nav-header">Actions</li>
                                    <li><a href="#" uk-toggle="target: #preview-document-modal"><i class="fa-slab fa-solid fa-eye fa-fw"></i> Preview</a></li>
                                    <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download</a></li>
                                    <li><a href="#" uk-toggle="target: #rename-document-modal"><i class="fa-slab fa-solid fa-pencil fa-fw"></i> Rename</a></li>
                                    <li><a href="#" uk-toggle="target: #move-document-modal"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Move to Folder</a></li>
                                    <li><a href="#" uk-toggle="target: #share-document-modal"><i class="fa-slab fa-solid fa-link fa-fw"></i> Share</a></li>
                                    <li><a href="#" uk-toggle="target: #replace-document-modal"><i class="fa-slab fa-solid fa-upload fa-fw"></i> Replace</a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-document-modal"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Mobile Layout -->
                    <div class="uk-hidden@m">
                        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                            <div class="uk-flex uk-flex-middle uk-width-expand">
                                <?php if ($doc['required']): ?>
                                <span class="uk-text-danger uk-margin-small-right" uk-tooltip="Required Document" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-exclamation-triangle"></i></span>
                                <?php else: ?>
                                <span class="uk-margin-small-right" style="flex-shrink: 0;"><i class="fa-slab fa-solid fa-file"></i></span>
                                <?php endif; ?>
                                <div class="uk-width-expand" style="min-width: 0;">
                                    <div class="uk-text-bold uk-text-small"><?= e($doc['name']) ?></div>
                                    <?php if (!empty($doc['description'])): ?>
                                    <div class="uk-text-meta" style="font-size: 0.7rem;"><?= e($doc['description']) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="uk-flex-none">
                                <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                                <div uk-dropdown="mode: click; pos: bottom-right">
                                    <ul class="uk-nav uk-dropdown-nav">
                                        <li class="uk-nav-header">Actions</li>
                                        <li><a href="#" uk-toggle="target: #preview-document-modal"><i class="fa-slab fa-solid fa-eye fa-fw"></i> Preview</a></li>
                                        <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download</a></li>
                                        <li><a href="#" uk-toggle="target: #rename-document-modal"><i class="fa-slab fa-solid fa-pencil fa-fw"></i> Rename</a></li>
                                        <li><a href="#" uk-toggle="target: #move-document-modal"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Move to Folder</a></li>
                                        <li><a href="#" uk-toggle="target: #share-document-modal"><i class="fa-slab fa-solid fa-link fa-fw"></i> Share</a></li>
                                        <li><a href="#" uk-toggle="target: #replace-document-modal"><i class="fa-slab fa-solid fa-upload fa-fw"></i> Replace</a></li>
                                        <li class="uk-nav-divider"></li>
                                        <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-document-modal"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-text-small" uk-grid>
                            <div>
                                <div class="uk-text-meta">Category</div>
                                <span class="uk-label uk-label-secondary" style="font-size: 0.65rem;"><?= e($doc['category']) ?></span>
                            </div>
                            <div>
                                <div class="uk-text-meta">Type</div>
                                <div><?= e($doc['type']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Uploaded</div>
                                <div><?= e($doc['uploaded']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Size</div>
                                <div><?= e($doc['size']) ?></div>
                            </div>
                            <div>
                                <div class="uk-text-meta">Status</div>
                                <span class="uk-label uk-label-<?= $status_colors[$doc['status']] ?>" style="font-size: 0.65rem;"><?= e($doc['status']) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Upload Document Modal -->
<div id="upload-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Upload Document</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-margin">
                <div class="uk-placeholder uk-text-center" style="border: 2px dashed #e5e5e5; padding: 30px;">
                    <i class="fa-slab fa-solid fa-cloud-upload fa-3x uk-text-primary"></i>
                    <p class="uk-text-muted uk-margin-small-top">Drag and drop files here or click to browse</p>
                    <div uk-form-custom>
                        <input type="file" multiple>
                        <button class="uk-button uk-button-default" type="button">Select Files</button>
                    </div>
                </div>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Document Title *</label>
                    <input class="uk-input" type="text" placeholder="e.g., Transcript - Bachelor's Degree" required>
                    <div class="uk-text-small uk-text-muted uk-margin-small-top">Give this document a descriptive title</div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category *</label>
                    <select class="uk-select" id="doc-category" required
                            onchange="updateDocumentTypes(this.value)">
                        <option value="">Select category...</option>
                        <option value="Academic">Academic</option>
                        <option value="Recommendations">Recommendations</option>
                        <option value="Essays">Essays</option>
                        <option value="Personal">Personal</option>
                        <option value="Identity">Identity</option>
                        <option value="Financial">Financial</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Document Type *</label>
                    <select class="uk-select" id="doc-type" required disabled>
                        <option value="">Select category first...</option>
                    </select>
                    <div class="uk-text-small uk-text-muted uk-margin-small-top">Choose the specific type of document</div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description (Optional)</label>
                    <textarea class="uk-textarea" rows="2" placeholder="Brief description of the document..."></textarea>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> Mark as required document</label>
                </div>
            </form>
            <div class="uk-text-small uk-text-muted">Max file size: 10MB. Accepted formats: PDF, DOC, DOCX, JPG, PNG</div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Upload</button>
        </div>
    </div>
</div>

<style>
.documents-grid-header {
    padding: 0.75rem 0.5rem;
    border-bottom: 2px solid #e5e5e5;
    margin-bottom: 0.5rem;
}

.document-item {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    border: 1px solid #e5e5e5;
    position: relative;
    z-index: 1;
}

.document-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    z-index: 10;
}

/* Elevate card when dropdown is open */
.document-item:has(.uk-open) {
    z-index: 10;
}

.document-item .uk-card-body {
    padding: 0.75rem 1rem;
}

/* Ensure dropdown appears above other cards */
.document-item .uk-dropdown {
    z-index: 1020 !important;
}

@media (max-width: 959px) {
    .document-item {
        margin-bottom: 0.75rem;
    }

    .document-item .uk-card-body {
        padding: 0.875rem;
    }

    /* Mobile filter icon styling */
    #category-filter li a i {
        font-size: 1.1rem;
        display: inline-block;
        min-width: 24px;
        text-align: center;
    }
}
</style>

<script>
// Document types data
const documentTypes = <?= json_encode($document_types) ?>;

function updateDocumentTypes(category) {
    const typeSelect = document.getElementById('doc-type');

    if (!category) {
        typeSelect.disabled = true;
        typeSelect.innerHTML = '<option value="">Select category first...</option>';
        return;
    }

    typeSelect.disabled = false;
    typeSelect.innerHTML = '<option value="">Select type...</option>';

    if (documentTypes[category]) {
        documentTypes[category].forEach(type => {
            const option = document.createElement('option');
            option.value = type;
            option.textContent = type;
            typeSelect.appendChild(option);
        });
    }
}

// Reset filter to "All" when searching
function resetFilterToAll() {
    const filterElement = document.getElementById('category-filter');
    if (filterElement) {
        // Find the "All" filter button (first li element)
        const allFilterButton = filterElement.querySelector('li[data-filter-name="All"] a');
        if (allFilterButton) {
            // Trigger click on "All" filter
            allFilterButton.click();
        }
    }
}

// Re-initialize UIKit components after HTMX swaps content
document.body.addEventListener('htmx:afterSwap', function(event) {
    // Re-initialize UIkit components in the swapped content
    UIkit.icon('[uk-icon]', event.detail.target);
    UIkit.tooltip('[uk-tooltip]', event.detail.target);
    UIkit.grid('[uk-grid]', event.detail.target);

    // Re-initialize the filter component to reconnect with new content
    if (event.detail.target.id === 'documents-tbody') {
        const filterNav = document.getElementById('category-filter');
        if (filterNav) {
            // Re-initialize the UIKit filter
            UIkit.filter(filterNav);
        }
    }
});
</script>

<!-- New Folder Modal -->
<div id="new-folder-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create New Folder</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Folder Name *</label>
                    <input class="uk-input" type="text" placeholder="Enter folder name" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category</label>
                    <select class="uk-select">
                        <option value="">Select category...</option>
                        <option>Academic</option>
                        <option>Financial</option>
                        <option>Identity</option>
                        <option>Essays</option>
                        <option>Recommendations</option>
                        <option>Personal</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Folder</button>
        </div>
    </div>
</div>

<!-- Preview Document Modal -->
<div id="preview-document-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">Document Preview</h2>
        <div class="uk-text-center uk-padding">
            <i class="fa-slab fa-solid fa-file-pdf fa-4x uk-text-muted"></i>
            <p class="uk-text-muted uk-margin-top">Document preview would appear here</p>
        </div>
        <div class="uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">Download</button>
        </div>
    </div>
</div>

<!-- Rename Document Modal -->
<div id="rename-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Rename Document</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New Name *</label>
                    <input class="uk-input" type="text" placeholder="Document name" required>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Rename</button>
        </div>
    </div>
</div>

<!-- Move Document Modal -->
<div id="move-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Move to Folder</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Select Destination *</label>
                    <select class="uk-select" required>
                        <option value="">Select folder...</option>
                        <option>Academic</option>
                        <option>Financial</option>
                        <option>Identity</option>
                        <option>Essays</option>
                        <option>Recommendations</option>
                        <option>Personal</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Move</button>
        </div>
    </div>
</div>

<!-- Share Document Modal -->
<div id="share-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Share Document</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Share Link</label>
                    <div class="uk-flex">
                        <input class="uk-input uk-flex-1" type="text" value="https://adoxedu.com/files/abc123" readonly>
                        <button class="uk-button uk-button-default uk-margin-small-left" type="button">Copy</button>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Share with Email</label>
                    <input class="uk-input" type="email" placeholder="Enter email address">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Expiration</label>
                    <select class="uk-select">
                        <option>Never</option>
                        <option>1 day</option>
                        <option>7 days</option>
                        <option>30 days</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Share</button>
        </div>
    </div>
</div>

<!-- Replace Document Modal -->
<div id="replace-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Replace Document</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-alert uk-alert-warning">
                <p>This will permanently replace the existing document. This action cannot be undone.</p>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New File *</label>
                    <div uk-form-custom="target: true">
                        <input type="file" required>
                        <input class="uk-input uk-form-width-large" type="text" placeholder="Select file..." disabled>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Replace</button>
        </div>
    </div>
</div>

<!-- Delete Document Modal -->
<div id="delete-document-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete Document</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to delete this document? This action cannot be undone.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>
