<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$categories = ['All Files', 'Academic', 'Financial', 'Identity', 'Essays', 'Recommendations'];

$files = [
    ['name' => 'transcript_2023.pdf', 'category' => 'Academic', 'size' => '2.4 MB', 'modified' => '2024-01-05'],
    ['name' => 'bank_statement_jan.pdf', 'category' => 'Financial', 'size' => '1.2 MB', 'modified' => '2024-01-18'],
    ['name' => 'passport_scan.jpg', 'category' => 'Identity', 'size' => '1.8 MB', 'modified' => '2024-01-15'],
    ['name' => 'sop_stanford.docx', 'category' => 'Essays', 'size' => '89 KB', 'modified' => '2024-01-10'],
    ['name' => 'rec_letter_smith.pdf', 'category' => 'Recommendations', 'size' => '156 KB', 'modified' => '2024-01-08']
];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">File Manager</h3>
    <div>
        <button class="uk-button uk-button-default uk-button-small uk-margin-small-right" uk-toggle="target: #new-folder-modal">
            <span uk-icon="icon: folder; ratio: 0.8"></span> New Folder
        </button>
        <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #upload-modal">
            <span uk-icon="icon: cloud-upload; ratio: 0.8"></span> Upload Files
        </button>
    </div>
</div>

<!-- Upload Modal -->
<div id="upload-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Upload Documents</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-margin">
                <div class="uk-placeholder uk-text-center" style="border: 2px dashed #e5e5e5; padding: 30px;">
                    <span uk-icon="icon: cloud-upload; ratio: 2"></span>
                    <p class="uk-text-muted uk-margin-small-top">Drag and drop files here or click to browse</p>
                    <div uk-form-custom>
                        <input type="file" multiple>
                        <button class="uk-button uk-button-default" type="button">Select Files</button>
                    </div>
                </div>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label">Category</label>
                <select class="uk-select">
                    <option value="">Select category...</option>
                    <option>Academic</option>
                    <option>Financial</option>
                    <option>Identity</option>
                    <option>Essays</option>
                    <option>Recommendations</option>
                </select>
            </div>
            <div class="uk-margin">
                <label class="uk-form-label">Description (Optional)</label>
                <textarea class="uk-textarea" rows="2" placeholder="Brief description of the document..."></textarea>
            </div>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Upload</button>
        </div>
    </div>
</div>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-4@m">
        <div class="uk-card uk-card-default uk-card-body uk-card-small">
            <h5 class="uk-card-title">Categories</h5>
            <ul class="uk-nav uk-nav-default">
                <?php foreach ($categories as $i => $cat): ?>
                <li class="<?= $i === 0 ? 'uk-active' : '' ?>"><a href="#"><?= e($cat) ?></a></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
    <div class="uk-width-3-4@m">
        <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-margin-bottom">
                <input class="uk-input" type="search" placeholder="Search files..."
                       _="on keyup
                          set query to my value.toLowerCase()
                          for row in #files-table tbody tr
                            if row.textContent.toLowerCase().indexOf(query) >= 0
                              remove .uk-hidden from row
                            else
                              add .uk-hidden to row
                            end
                          end">
            </div>
            <table id="files-table" class="uk-table uk-table-divider uk-table-hover uk-table-small">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Size</th>
                        <th>Modified</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($files as $file): ?>
                    <tr>
                        <td>
                            <span uk-icon="icon: file" class="uk-margin-small-right"></span>
                            <?= e($file['name']) ?>
                        </td>
                        <td><span class="uk-label uk-label-secondary"><?= e($file['category']) ?></span></td>
                        <td><?= e($file['size']) ?></td>
                        <td><?= e($file['modified']) ?></td>
                        <td class="uk-text-right">
                            <a href="#" uk-icon="icon: more-vertical"></a>
                            <div uk-dropdown="mode: click; pos: bottom-right">
                                <ul class="uk-nav uk-dropdown-nav">
                                    <li class="uk-nav-header">Actions</li>
                                    <li><a href="#" uk-toggle="target: #preview-file-modal"><span uk-icon="icon: eye; ratio: 0.8" class="uk-margin-small-right"></span> Preview</a></li>
                                    <li><a href="#"><span uk-icon="icon: download; ratio: 0.8" class="uk-margin-small-right"></span> Download</a></li>
                                    <li><a href="#" uk-toggle="target: #rename-file-modal"><span uk-icon="icon: pencil; ratio: 0.8" class="uk-margin-small-right"></span> Rename</a></li>
                                    <li><a href="#" uk-toggle="target: #move-file-modal"><span uk-icon="icon: folder; ratio: 0.8" class="uk-margin-small-right"></span> Move to Folder</a></li>
                                    <li><a href="#" uk-toggle="target: #share-file-modal"><span uk-icon="icon: link; ratio: 0.8" class="uk-margin-small-right"></span> Share</a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="#" class="uk-text-danger" uk-toggle="target: #delete-file-modal"><span uk-icon="icon: trash; ratio: 0.8" class="uk-margin-small-right"></span> Delete</a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- New Folder Modal -->
<div id="new-folder-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Create New Folder</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Folder Name *</label>
                    <input class="uk-input" type="text" placeholder="Enter folder name" required>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Category</label>
                    <select class="uk-select">
                        <option value="">Select category...</option>
                        <option>Academic</option>
                        <option>Financial</option>
                        <option>Identity</option>
                        <option>Essays</option>
                        <option>Recommendations</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Create Folder</button>
        </div>
    </div>
</div>

<!-- Preview File Modal -->
<div id="preview-file-modal" uk-modal="container: false">
    <div class="uk-modal-dialog uk-modal-body uk-width-xlarge">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <h2 class="uk-modal-title">File Preview</h2>
        <div class="uk-text-center uk-padding">
            <span uk-icon="icon: file-pdf; ratio: 3" class="uk-text-muted"></span>
            <p class="uk-text-muted uk-margin-top">File preview would appear here</p>
        </div>
        <div class="uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button">Download</button>
        </div>
    </div>
</div>

<!-- Rename File Modal -->
<div id="rename-file-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Rename File</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">New Name *</label>
                    <input class="uk-input" type="text" placeholder="Enter new file name" required>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Rename</button>
        </div>
    </div>
</div>

<!-- Move File Modal -->
<div id="move-file-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Move to Folder</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Select Destination *</label>
                    <select class="uk-select" required>
                        <option value="">Select folder...</option>
                        <option>Academic</option>
                        <option>Financial</option>
                        <option>Identity</option>
                        <option>Essays</option>
                        <option>Recommendations</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Move</button>
        </div>
    </div>
</div>

<!-- Share File Modal -->
<div id="share-file-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Share File</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Share Link</label>
                    <div class="uk-flex">
                        <input class="uk-input uk-flex-1" type="text" value="https://adoxedu.com/files/abc123" readonly>
                        <button class="uk-button uk-button-default uk-margin-small-left" type="button">Copy</button>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Share with Email</label>
                    <input class="uk-input" type="email" placeholder="Enter email address">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Expiration</label>
                    <select class="uk-select">
                        <option>Never</option>
                        <option>1 day</option>
                        <option>7 days</option>
                        <option>30 days</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Share</button>
        </div>
    </div>
</div>

<!-- Delete File Modal -->
<div id="delete-file-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Delete File</h2>
        </div>
        <div class="uk-modal-body">
            <p>Are you sure you want to delete this file? This action cannot be undone.</p>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-danger" type="button">Delete</button>
        </div>
    </div>
</div>
