<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$conversations = [
    [
        'id' => 1,
        'name' => 'Sarah Johnson',
        'role' => 'Senior Counselor',
        'last_message' => 'Great progress on your Stanford application!',
        'time' => '2 hours ago',
        'unread' => 2,
        'online' => true,
        'starred' => true
    ],
    [
        'id' => 2,
        'name' => 'Dr. Michael Chen',
        'role' => 'Academic Advisor',
        'last_message' => 'Your transcript has been verified.',
        'time' => '1 day ago',
        'unread' => 0,
        'online' => false,
        'starred' => false
    ],
    [
        'id' => 3,
        'name' => 'Emily Rodriguez',
        'role' => 'Visa Specialist',
        'last_message' => 'Please upload your updated financial documents.',
        'time' => '3 days ago',
        'unread' => 1,
        'online' => true,
        'starred' => false
    ],
    [
        'id' => 4,
        'name' => 'James Wilson',
        'role' => 'Financial Aid Officer',
        'last_message' => 'Your scholarship application has been reviewed.',
        'time' => '5 days ago',
        'unread' => 0,
        'online' => false,
        'starred' => false
    ]
];

// Sample messages for chat view
$sample_messages = [
    ['sender' => 'Sarah Johnson', 'message' => 'Hi! How are you doing with your applications?', 'time' => '10:30 AM', 'is_me' => false],
    ['sender' => 'You', 'message' => 'Hi Sarah! I\'m making good progress. Just finished my Stanford essay.', 'time' => '10:32 AM', 'is_me' => true],
    ['sender' => 'Sarah Johnson', 'message' => 'That\'s wonderful! Would you like me to review it before you submit?', 'time' => '10:33 AM', 'is_me' => false],
    ['sender' => 'You', 'message' => 'Yes please! I\'ll upload it to the documents section.', 'time' => '10:35 AM', 'is_me' => true],
    ['sender' => 'Sarah Johnson', 'message' => 'Great progress on your Stanford application!', 'time' => '10:40 AM', 'is_me' => false],
];
?>

<!-- Messages List View -->
<div id="messages-list-view">
    <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
        <div>
            <h3 class="uk-margin-remove">Messages</h3>
            <p class="uk-text-muted uk-text-small uk-margin-remove-top"><?= count(array_filter($conversations, fn($c) => $c['unread'] > 0)) ?> unread conversations</p>
        </div>
        <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #new-message-modal">
            <i class="fa-slab fa-solid fa-plus"></i> <span class="uk-visible@s">New Message</span>
        </button>
    </div>

    <!-- Search and Filter -->
    <div class="uk-margin-bottom">
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-expand">
                <div class="uk-inline uk-width-1-1">
                    <span class="uk-form-icon"><i class="fa-slab fa-solid fa-search"></i></span>
                    <input class="uk-input uk-form-small" type="search" placeholder="Search messages...">
                </div>
            </div>
            <div class="uk-width-auto">
                <button class="uk-button uk-button-default uk-button-small">
                    <i class="fa-slab fa-solid fa-star"></i> <span class="uk-visible@s">Starred</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Conversations List -->
    <div class="uk-card uk-card-default">
        <div class="conversations-list">
            <?php foreach ($conversations as $i => $conv): ?>
            <div class="conversation-item <?= $conv['unread'] > 0 ? 'unread' : '' ?>"
                 onclick="openChat(<?= $conv['id'] ?>, '<?= e($conv['name']) ?>', '<?= e($conv['role']) ?>', <?= $conv['online'] ? 'true' : 'false' ?>)"
                 data-conv-id="<?= $conv['id'] ?>">
                <div class="uk-flex uk-flex-between uk-flex-top">
                    <div class="uk-flex uk-flex-middle uk-width-expand" style="min-width: 0;">
                        <div class="avatar-container">
                            <?= get_avatar($conv['name'], 48) ?>
                            <?php if ($conv['online']): ?>
                            <span class="online-indicator"></span>
                            <?php endif; ?>
                        </div>
                        <div class="conversation-content">
                            <div class="uk-flex uk-flex-between uk-flex-middle">
                                <div class="uk-flex uk-flex-middle">
                                    <span class="conversation-name"><?= e($conv['name']) ?></span>
                                    <?php if ($conv['starred']): ?>
                                    <i class="fa-slab fa-solid fa-star fa-xs uk-text-warning uk-margin-small-left"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="conversation-time"><?= e($conv['time']) ?></div>
                            </div>
                            <div class="conversation-role"><?= e($conv['role']) ?></div>
                            <div class="uk-flex uk-flex-between uk-flex-middle">
                                <div class="conversation-preview"><?= e($conv['last_message']) ?></div>
                                <?php if ($conv['unread'] > 0): ?>
                                <span class="unread-badge"><?= $conv['unread'] ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="conversation-actions" onclick="event.stopPropagation();">
                        <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical fa-xs"></i></a>
                        <div uk-dropdown="mode: click; pos: bottom-right">
                            <ul class="uk-nav uk-dropdown-nav">
                                <li><a href="#"><i class="fa-slab fa-solid fa-check fa-fw"></i> Mark as Read</a></li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-star fa-fw"></i> Star</a></li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-bell fa-fw"></i> Mute</a></li>
                                <li class="uk-nav-divider"></li>
                                <li><a href="#"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Archive</a></li>
                                <li><a href="#" class="uk-text-danger"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<!-- Chat View -->
<div id="chat-view" style="display: none;">
    <div class="uk-card uk-card-default chat-container">
        <!-- Chat Header -->
        <div class="chat-header">
            <div class="uk-flex uk-flex-between uk-flex-middle">
                <div class="uk-flex uk-flex-middle">
                    <button class="uk-button uk-button-text uk-padding-remove" onclick="closeChat()">
                        <i class="fa-slab fa-solid fa-arrow-left"></i>
                    </button>
                    <div class="avatar-container uk-margin-left">
                        <div id="chat-avatar"></div>
                        <span class="online-indicator" id="chat-online-indicator" style="display: none;"></span>
                    </div>
                    <div class="uk-margin-small-left">
                        <div class="uk-text-bold" id="chat-name"></div>
                        <div class="uk-text-small uk-text-muted" id="chat-role"></div>
                    </div>
                </div>
                <div class="uk-flex uk-flex-middle">
                    <button class="uk-button uk-button-text uk-margin-small-right">
                        <i class="fa-slab fa-solid fa-search"></i>
                    </button>
                    <button class="uk-button uk-button-text">
                        <i class="fa-slab fa-solid fa-ellipsis-vertical"></i>
                    </button>
                    <div uk-dropdown="mode: click; pos: bottom-right">
                        <ul class="uk-nav uk-dropdown-nav">
                            <li><a href="#"><i class="fa-slab fa-solid fa-star fa-fw"></i> Star Conversation</a></li>
                            <li><a href="#"><i class="fa-slab fa-solid fa-bell fa-fw"></i> Mute Notifications</a></li>
                            <li class="uk-nav-divider"></li>
                            <li><a href="#"><i class="fa-slab fa-solid fa-folder fa-fw"></i> Archive</a></li>
                            <li><a href="#" class="uk-text-danger"><i class="fa-slab fa-solid fa-trash fa-fw"></i> Delete Conversation</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chat Messages -->
        <div class="chat-messages" id="chat-messages">
            <div class="uk-text-center uk-text-muted uk-padding">
                <div class="uk-text-small">Today</div>
            </div>
            <?php foreach ($sample_messages as $msg): ?>
            <div class="message <?= $msg['is_me'] ? 'message-sent' : 'message-received' ?>">
                <div class="message-bubble">
                    <?php if (!$msg['is_me']): ?>
                    <div class="message-sender"><?= e($msg['sender']) ?></div>
                    <?php endif; ?>
                    <div class="message-text"><?= e($msg['message']) ?></div>
                    <div class="message-time"><?= e($msg['time']) ?></div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

        <!-- Chat Input -->
        <div class="chat-input">
            <form class="uk-flex uk-flex-middle" onsubmit="sendMessage(event)">
                <button type="button" class="uk-button uk-button-text uk-margin-small-right">
                    <i class="fa-slab fa-solid fa-circle-plus"></i>
                </button>
                <input class="uk-input uk-flex-1" type="text" id="message-input" placeholder="Type a message..." autocomplete="off">
                <button type="submit" class="uk-button uk-button-primary uk-margin-small-left">
                    <i class="fa-slab fa-solid fa-arrow-right"></i>
                </button>
            </form>
        </div>
    </div>
</div>

<!-- New Message Modal -->
<div id="new-message-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">New Message</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">To *</label>
                    <select class="uk-select" required>
                        <option value="">Select recipient...</option>
                        <option>Sarah Johnson - Senior Counselor</option>
                        <option>Dr. Michael Chen - Academic Advisor</option>
                        <option>Emily Rodriguez - Visa Specialist</option>
                        <option>James Wilson - Financial Aid Officer</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Subject</label>
                    <input class="uk-input" type="text" placeholder="Message subject...">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Message *</label>
                    <textarea class="uk-textarea" rows="4" placeholder="Type your message..." required></textarea>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Attachments</label>
                    <div uk-form-custom>
                        <input type="file" multiple>
                        <button class="uk-button uk-button-default uk-button-small" type="button" tabindex="-1">
                            <i class="fa-slab fa-solid fa-cloud-upload"></i> Attach Files
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Send Message</button>
        </div>
    </div>
</div>

<style>
/* Conversations List */
.conversations-list {
    max-height: calc(100vh - 350px);
    overflow-y: auto;
}

.conversation-item {
    padding: 16px;
    border-bottom: 1px solid #e5e5e5;
    cursor: pointer;
    transition: background 0.2s ease;
    background: #fff;
}

.conversation-item:hover {
    background: #f8f8f8;
}

.conversation-item.unread {
    background: #f0f7ff;
}

.conversation-item.unread:hover {
    background: #e6f2ff;
}

.avatar-container {
    position: relative;
    flex-shrink: 0;
}

.online-indicator {
    position: absolute;
    bottom: 2px;
    right: 2px;
    width: 12px;
    height: 12px;
    background: #32d296;
    border: 2px solid #fff;
    border-radius: 50%;
}

.conversation-content {
    flex: 1;
    min-width: 0;
    margin-left: 12px;
}

.conversation-name {
    font-weight: 600;
    font-size: 15px;
    color: #333;
}

.conversation-item.unread .conversation-name {
    font-weight: 700;
}

.conversation-role {
    font-size: 13px;
    color: #666;
    margin-top: 2px;
}

.conversation-preview {
    font-size: 14px;
    color: #666;
    margin-top: 4px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    flex: 1;
    min-width: 0;
}

.conversation-item.unread .conversation-preview {
    color: #333;
    font-weight: 500;
}

.conversation-time {
    font-size: 12px;
    color: #999;
    flex-shrink: 0;
    margin-left: 8px;
}

.conversation-item.unread .conversation-time {
    color: #1e87f0;
    font-weight: 600;
}

.unread-badge {
    background: #1e87f0;
    color: #fff;
    border-radius: 10px;
    padding: 2px 7px;
    font-size: 11px;
    font-weight: 600;
    flex-shrink: 0;
    margin-left: 8px;
}

.conversation-actions {
    margin-left: 12px;
    flex-shrink: 0;
}

/* Chat Container */
.chat-container {
    display: flex;
    flex-direction: column;
    height: calc(100vh - 250px);
    min-height: 500px;
}

.chat-header {
    padding: 16px;
    border-bottom: 1px solid #e5e5e5;
    flex-shrink: 0;
}

.chat-messages {
    flex: 1;
    overflow-y: auto;
    padding: 20px;
    background: #f8f8f8;
}

.message {
    margin-bottom: 16px;
    display: flex;
}

.message-received {
    justify-content: flex-start;
}

.message-sent {
    justify-content: flex-end;
}

.message-bubble {
    max-width: 70%;
    padding: 10px 14px;
    border-radius: 12px;
    position: relative;
}

.message-received .message-bubble {
    background: #fff;
    border-bottom-left-radius: 4px;
}

.message-sent .message-bubble {
    background: #1e87f0;
    color: #fff;
    border-bottom-right-radius: 4px;
}

.message-sender {
    font-size: 12px;
    font-weight: 600;
    margin-bottom: 4px;
    color: #666;
}

.message-text {
    font-size: 14px;
    line-height: 1.5;
    word-wrap: break-word;
}

.message-time {
    font-size: 11px;
    margin-top: 4px;
    opacity: 0.7;
}

.message-received .message-time {
    color: #999;
}

.message-sent .message-time {
    text-align: right;
}

.chat-input {
    padding: 16px;
    border-top: 1px solid #e5e5e5;
    background: #fff;
    flex-shrink: 0;
}

.chat-input input {
    border-radius: 20px;
}

/* Dark mode support */
[data-theme="dark"] .conversation-item {
    background: #1a1a1a;
    border-bottom-color: #333;
}

[data-theme="dark"] .conversation-item:hover {
    background: #252525;
}

[data-theme="dark"] .conversation-item.unread {
    background: #1a2a3a;
}

[data-theme="dark"] .conversation-name {
    color: #e5e5e5;
}

[data-theme="dark"] .conversation-preview,
[data-theme="dark"] .conversation-role {
    color: #999;
}

[data-theme="dark"] .chat-messages {
    background: #1a1a1a;
}

[data-theme="dark"] .message-received .message-bubble {
    background: #2a2a2a;
    color: #e5e5e5;
}

[data-theme="dark"] .chat-header,
[data-theme="dark"] .chat-input {
    background: #1a1a1a;
    border-color: #333;
}

/* Mobile Responsive */
@media (max-width: 959px) {
    .conversations-list {
        max-height: calc(100vh - 400px);
    }

    .chat-container {
        height: calc(100vh - 280px);
    }

    .message-bubble {
        max-width: 85%;
    }
}
</style>

<script>
function openChat(id, name, role, isOnline) {
    // Hide list view, show chat view
    document.getElementById('messages-list-view').style.display = 'none';
    document.getElementById('chat-view').style.display = 'block';

    // Update chat header
    document.getElementById('chat-name').textContent = name;
    document.getElementById('chat-role').textContent = role;

    // Update avatar
    const avatarHtml = `<div class="uk-border-circle uk-background-primary uk-flex uk-flex-center uk-flex-middle" style="width: 40px; height: 40px; color: white; font-weight: 600; font-size: 14px;">
        ${name.split(' ').map(n => n[0]).join('').toUpperCase()}
    </div>`;
    document.getElementById('chat-avatar').innerHTML = avatarHtml;

    // Show/hide online indicator
    if (isOnline) {
        document.getElementById('chat-online-indicator').style.display = 'block';
    } else {
        document.getElementById('chat-online-indicator').style.display = 'none';
    }

    // Scroll to bottom of messages
    const messagesContainer = document.getElementById('chat-messages');
    messagesContainer.scrollTop = messagesContainer.scrollHeight;

    // Focus input
    setTimeout(() => {
        document.getElementById('message-input').focus();
    }, 100);
}

function closeChat() {
    // Show list view, hide chat view
    document.getElementById('messages-list-view').style.display = 'block';
    document.getElementById('chat-view').style.display = 'none';
}

function sendMessage(event) {
    event.preventDefault();

    const input = document.getElementById('message-input');
    const messageText = input.value.trim();

    if (!messageText) return;

    // Get current time
    const now = new Date();
    const time = now.toLocaleTimeString('en-US', { hour: 'numeric', minute: '2-digit' });

    // Create message element
    const messageDiv = document.createElement('div');
    messageDiv.className = 'message message-sent';
    messageDiv.innerHTML = `
        <div class="message-bubble">
            <div class="message-text">${escapeHtml(messageText)}</div>
            <div class="message-time">${time}</div>
        </div>
    `;

    // Add to messages container
    const messagesContainer = document.getElementById('chat-messages');
    messagesContainer.appendChild(messageDiv);

    // Clear input
    input.value = '';

    // Scroll to bottom
    messagesContainer.scrollTop = messagesContainer.scrollHeight;

    // Simulate response (for demo purposes)
    setTimeout(() => {
        const responseDiv = document.createElement('div');
        responseDiv.className = 'message message-received';
        const name = document.getElementById('chat-name').textContent;
        responseDiv.innerHTML = `
            <div class="message-bubble">
                <div class="message-sender">${escapeHtml(name)}</div>
                <div class="message-text">Thanks for your message! I'll get back to you shortly.</div>
                <div class="message-time">${time}</div>
            </div>
        `;
        messagesContainer.appendChild(responseDiv);
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }, 1000);
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Handle back button on mobile
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        const chatView = document.getElementById('chat-view');
        if (chatView.style.display !== 'none') {
            closeChat();
        }
    }
});
</script>
