<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$stats = [
    ['icon' => 'fa-file-text', 'value' => '5', 'label' => 'Total Applications', 'color' => '#667eea', 'trend' => '+2 this month'],
    ['icon' => 'fa-check-circle', 'value' => '1', 'label' => 'Accepted', 'color' => '#32d296', 'trend' => 'Stanford'],
    ['icon' => 'fa-clock', 'value' => '2', 'label' => 'In Review', 'color' => '#faa05a', 'trend' => 'Pending decision'],
    ['icon' => 'fa-exclamation-triangle', 'value' => '2', 'label' => 'Need Action', 'color' => '#f0506e', 'trend' => 'Urgent']
];

$active_applications = [
    ['id' => 'APP-2024-001', 'university' => 'Stanford University', 'program' => 'Computer Science (MS)', 'progress' => 85, 'status' => 'interview_scheduled', 'deadline' => '2024-03-01', 'days_left' => 8],
    ['id' => 'APP-2024-002', 'university' => 'MIT', 'program' => 'AI & Machine Learning (MS)', 'progress' => 45, 'status' => 'incomplete', 'deadline' => '2024-02-15', 'days_left' => -7],
    ['id' => 'APP-2024-003', 'university' => 'University of Cambridge', 'program' => 'Computer Science (PhD)', 'progress' => 92, 'status' => 'under_review', 'deadline' => '2024-02-28', 'days_left' => 6]
];

$upcoming_deadlines = [
    ['title' => 'Interview with Stanford Admissions', 'date' => '2024-02-05', 'time' => '10:00 AM PST', 'days_left' => 3, 'type' => 'interview', 'application' => 'Stanford University'],
    ['title' => 'Submit missing documents - MIT', 'date' => '2024-02-08', 'time' => '11:59 PM', 'days_left' => 6, 'type' => 'document', 'application' => 'MIT'],
    ['title' => 'Application deadline - Harvard', 'date' => '2024-02-15', 'time' => '11:59 PM EST', 'days_left' => 13, 'type' => 'deadline', 'application' => 'Harvard University'],
    ['title' => 'Financial documents - Cambridge', 'date' => '2024-02-20', 'time' => '5:00 PM GMT', 'days_left' => 18, 'type' => 'document', 'application' => 'University of Cambridge']
];

$recent_activities = [
    ['icon' => 'fa-check-circle', 'title' => 'Application submitted successfully', 'subtitle' => 'Stanford University - Computer Science (MS)', 'time' => '2 hours ago', 'color' => '#32d296'],
    ['icon' => 'fa-envelope', 'title' => 'New message from counselor', 'subtitle' => 'Dr. Sarah Johnson replied to your query', 'time' => '5 hours ago', 'color' => '#1e87f0'],
    ['icon' => 'fa-calendar-check', 'title' => 'Interview scheduled', 'subtitle' => 'Cambridge - Feb 15, 2024 at 2:00 PM', 'time' => '1 day ago', 'color' => '#faa05a'],
    ['icon' => 'fa-cloud-upload', 'title' => 'Documents uploaded', 'subtitle' => 'Transcripts and recommendation letters verified', 'time' => '2 days ago', 'color' => '#32d296'],
    ['icon' => 'fa-credit-card', 'title' => 'Payment processed', 'subtitle' => '$125 application fee for MIT', 'time' => '3 days ago', 'color' => '#666']
];

$financial_summary = [
    'total_paid' => '$875',
    'pending' => '$250',
    'total' => '$1,125',
    'recent_payment' => ['amount' => '$125', 'to' => 'MIT', 'date' => '3 days ago']
];

$recommended_actions = [
    ['icon' => 'fa-upload', 'title' => 'Upload missing transcript', 'description' => 'MIT application requires updated transcript', 'priority' => 'high', 'link' => 'documents.php'],
    ['icon' => 'fa-calendar', 'title' => 'Prepare for Stanford interview', 'description' => 'Interview scheduled in 3 days', 'priority' => 'high', 'link' => 'applications.php'],
    ['icon' => 'fa-file-text', 'title' => 'Complete Harvard application', 'description' => '45% complete - deadline in 13 days', 'priority' => 'medium', 'link' => 'applications.php']
];

function get_status_color($status) {
    $colors = [
        'accepted' => '#32d296',
        'under_review' => '#faa05a',
        'interview_scheduled' => '#1e87f0',
        'incomplete' => '#f0506e',
        'draft' => '#999'
    ];
    return $colors[$status] ?? '#666';
}

function get_deadline_urgency($days_left) {
    if ($days_left < 0) return 'overdue';
    if ($days_left <= 3) return 'critical';
    if ($days_left <= 7) return 'urgent';
    return 'normal';
}
?>

<style>
.stat-card-modern {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
}

.stat-card-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

.stat-card-icon {
    font-size: 36px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-card-value {
    font-size: 32px;
    font-weight: bold;
    margin-bottom: 4px;
}

.stat-card-label {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 8px;
}

.stat-card-trend {
    font-size: 12px;
    opacity: 0.8;
}

.quick-action-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 20px;
    border-radius: 8px;
    background: white;
    border: 2px solid #e5e5e5;
    transition: all 0.2s ease;
    text-decoration: none;
    color: inherit;
}

.quick-action-btn:hover {
    border-color: #667eea;
    background: #f8f9ff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.15);
}

.quick-action-icon {
    font-size: 28px;
    color: #667eea;
    margin-bottom: 8px;
}

.quick-action-label {
    font-size: 13px;
    font-weight: 500;
    text-align: center;
}

.application-card-mini {
    position: relative;
    overflow: hidden;
}

.application-progress-mini {
    position: absolute;
    top: 0;
    left: 0;
    height: 4px;
    background: var(--progress-color);
    transition: width 0.3s ease;
}

.deadline-item {
    border-left: 4px solid;
    padding-left: 12px;
    margin-bottom: 12px;
}

.deadline-item.critical {
    border-color: #f0506e;
    background: rgba(240, 80, 110, 0.05);
}

.deadline-item.urgent {
    border-color: #faa05a;
    background: rgba(250, 160, 90, 0.05);
}

.deadline-item.normal {
    border-color: #1e87f0;
    background: rgba(30, 135, 240, 0.05);
}

.deadline-item.overdue {
    border-color: #999;
    background: rgba(153, 153, 153, 0.05);
}

.activity-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 16px;
    padding-bottom: 16px;
    border-bottom: 1px solid #f0f0f0;
}

.activity-item:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 12px;
    flex-shrink: 0;
}

.recommended-action-card {
    border-left: 4px solid;
    padding: 12px;
    border-radius: 4px;
    margin-bottom: 12px;
    background: #fafafa;
    transition: all 0.2s ease;
}

.recommended-action-card:hover {
    background: #f0f0f0;
    transform: translateX(4px);
}

.recommended-action-card.priority-high {
    border-color: #f0506e;
}

.recommended-action-card.priority-medium {
    border-color: #faa05a;
}

.recommended-action-card.priority-low {
    border-color: #1e87f0;
}

.financial-stat {
    text-align: center;
    padding: 16px;
    background: #f8f9fa;
    border-radius: 8px;
}

.financial-stat-value {
    font-size: 24px;
    font-weight: bold;
    color: #667eea;
    margin-bottom: 4px;
}

.financial-stat-label {
    font-size: 12px;
    color: #666;
}

@media (max-width: 959px) {
    .stat-card-modern {
        padding: 16px;
    }

    .stat-card-value {
        font-size: 24px;
    }

    .stat-card-icon {
        font-size: 28px;
    }

    .quick-action-btn {
        padding: 16px 12px;
    }

    .quick-action-icon {
        font-size: 24px;
    }

    .quick-action-label {
        font-size: 11px;
    }
}
</style>

<!-- Welcome Message -->
<div class="uk-margin-bottom">
    <h3 class="uk-margin-remove">Welcome back, <?= e($GLOBALS['current_user']['name']) ?>!</h3>
    <p class="uk-text-muted uk-margin-remove-top">Here's your application overview</p>
</div>

<!-- Stats Cards -->
<div class="uk-grid uk-grid-small uk-child-width-1-2 uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($stats as $stat): ?>
    <div>
        <div class="stat-card-modern" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= $stat['color'] ?>dd;">
            <div class="stat-card-icon">
                <i class="fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-card-value"><?= e($stat['value']) ?></div>
            <div class="stat-card-label"><?= e($stat['label']) ?></div>
            <div class="stat-card-trend"><?= e($stat['trend']) ?></div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Quick Actions -->
<div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
    <h4 class="uk-card-title uk-margin-remove-bottom"><i class="fa-solid fa-bolt"></i> Quick Actions</h4>
    <div class="uk-grid uk-grid-small uk-child-width-1-3 uk-child-width-1-6@m uk-margin-top" uk-grid>
        <div>
            <a href="<?= BASE_URL ?>/applications.php" class="quick-action-btn"
               hx-get="<?= BASE_URL ?>/pages/applications.php"
               hx-target="#main-content"
               hx-swap="innerHTML">
                <div class="quick-action-icon"><i class="fa-solid fa-plus-circle"></i></div>
                <div class="quick-action-label">New Application</div>
            </a>
        </div>
        <div>
            <a href="<?= BASE_URL ?>/documents.php" class="quick-action-btn"
               hx-get="<?= BASE_URL ?>/pages/documents.php"
               hx-target="#main-content"
               hx-swap="innerHTML">
                <div class="quick-action-icon"><i class="fa-solid fa-cloud-upload"></i></div>
                <div class="quick-action-label">Upload Documents</div>
            </a>
        </div>
        <div>
            <a href="<?= BASE_URL ?>/payments.php" class="quick-action-btn"
               hx-get="<?= BASE_URL ?>/pages/payments.php"
               hx-target="#main-content"
               hx-swap="innerHTML">
                <div class="quick-action-icon"><i class="fa-solid fa-credit-card"></i></div>
                <div class="quick-action-label">Make Payment</div>
            </a>
        </div>
        <div>
            <a href="<?= BASE_URL ?>/messages.php" class="quick-action-btn"
               hx-get="<?= BASE_URL ?>/pages/messages.php"
               hx-target="#main-content"
               hx-swap="innerHTML">
                <div class="quick-action-icon"><i class="fa-solid fa-envelope"></i></div>
                <div class="quick-action-label">Send Message</div>
            </a>
        </div>
        <div>
            <a href="#" class="quick-action-btn">
                <div class="quick-action-icon"><i class="fa-solid fa-calendar"></i></div>
                <div class="quick-action-label">Schedule Call</div>
            </a>
        </div>
        <div>
            <a href="#" class="quick-action-btn">
                <div class="quick-action-icon"><i class="fa-solid fa-download"></i></div>
                <div class="quick-action-label">Download Report</div>
            </a>
        </div>
    </div>
</div>

<!-- Main Content Grid -->
<div class="uk-grid uk-grid-medium" uk-grid>
    <!-- Left Column -->
    <div class="uk-width-1-1 uk-width-2-3@m">
        <!-- Active Applications -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
                <h4 class="uk-margin-remove"><i class="fa-solid fa-file-text"></i> Active Applications</h4>
                <a href="<?= BASE_URL ?>/applications.php"
                   hx-get="<?= BASE_URL ?>/pages/applications.php"
                   hx-target="#main-content"
                   hx-swap="innerHTML"
                   class="uk-button uk-button-text uk-button-small">View All <i class="fa-solid fa-arrow-right"></i></a>
            </div>

            <?php if (empty($active_applications)): ?>
                <p class="uk-text-muted uk-text-center">No active applications</p>
            <?php else: ?>
                <div class="uk-grid uk-grid-small uk-child-width-1-1" uk-grid>
                    <?php foreach ($active_applications as $app): ?>
                    <div>
                        <div class="application-card-mini uk-card uk-card-small" style="background: #fafafa; border-radius: 8px; padding: 16px; position: relative;">
                            <div class="application-progress-mini" style="--progress-color: <?= get_status_color($app['status']) ?>; width: <?= $app['progress'] ?>%;"></div>

                            <div class="uk-grid uk-grid-small uk-flex-middle" uk-grid>
                                <!-- Desktop Layout -->
                                <div class="uk-width-expand uk-visible@s">
                                    <div class="uk-text-bold uk-text-small"><?= e($app['university']) ?></div>
                                    <div class="uk-text-muted" style="font-size: 12px;"><?= e($app['program']) ?></div>
                                </div>

                                <!-- Mobile Layout -->
                                <div class="uk-width-expand uk-hidden@s">
                                    <div class="uk-text-bold" style="font-size: 13px;"><?= e($app['university']) ?></div>
                                    <div class="uk-text-muted" style="font-size: 11px;"><?= e($app['program']) ?></div>
                                </div>

                                <div class="uk-width-auto">
                                    <div class="uk-text-right">
                                        <div style="font-size: 18px; font-weight: bold; color: <?= get_status_color($app['status']) ?>;">
                                            <?= $app['progress'] ?>%
                                        </div>
                                        <div class="uk-text-muted" style="font-size: 11px;">
                                            <?php if ($app['days_left'] > 0): ?>
                                                <?= $app['days_left'] ?> days left
                                            <?php elseif ($app['days_left'] === 0): ?>
                                                Due today
                                            <?php else: ?>
                                                Overdue
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="uk-width-auto">
                                    <a href="<?= BASE_URL ?>/pages/application-detail.php?id=<?= e($app['id']) ?>"
                                       hx-get="<?= BASE_URL ?>/pages/application-detail.php?id=<?= e($app['id']) ?>"
                                       hx-target="#main-content"
                                       hx-swap="innerHTML"
                                       class="uk-button uk-button-primary uk-button-small">
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Recommended Actions -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-lightbulb"></i> Recommended Actions</h4>
            <?php if (empty($recommended_actions)): ?>
                <p class="uk-text-muted">No pending actions. Great job!</p>
            <?php else: ?>
                <?php foreach ($recommended_actions as $action): ?>
                <a href="<?= BASE_URL ?>/<?= e($action['link']) ?>" class="recommended-action-card priority-<?= $action['priority'] ?>">
                    <div class="uk-flex uk-flex-middle">
                        <div style="width: 40px; height: 40px; background: rgba(102, 126, 234, 0.1); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 12px;">
                            <i class="fa-solid <?= $action['icon'] ?>" style="color: #667eea;"></i>
                        </div>
                        <div style="flex: 1;">
                            <div class="uk-text-bold uk-text-small"><?= e($action['title']) ?></div>
                            <div class="uk-text-muted" style="font-size: 12px;"><?= e($action['description']) ?></div>
                        </div>
                        <div>
                            <i class="fa-solid fa-chevron-right uk-text-muted"></i>
                        </div>
                    </div>
                </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- Recent Activity -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><i class="fa-solid fa-clock-rotate-left"></i> Recent Activity</h4>
            <?php if (empty($recent_activities)): ?>
                <p class="uk-text-muted">No recent activity</p>
            <?php else: ?>
                <?php foreach ($recent_activities as $activity): ?>
                <div class="activity-item">
                    <div class="activity-icon" style="background: <?= $activity['color'] ?>20;">
                        <i class="fa-solid <?= $activity['icon'] ?>" style="color: <?= $activity['color'] ?>; font-size: 16px;"></i>
                    </div>
                    <div style="flex: 1;">
                        <div class="uk-text-bold uk-text-small"><?= e($activity['title']) ?></div>
                        <div class="uk-text-muted" style="font-size: 12px;"><?= e($activity['subtitle']) ?></div>
                        <div class="uk-text-meta" style="font-size: 11px;"><?= e($activity['time']) ?></div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Right Column -->
    <div class="uk-width-1-1 uk-width-1-3@m">
        <!-- Upcoming Deadlines -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-calendar-days"></i> Upcoming Deadlines</h4>
            <?php if (empty($upcoming_deadlines)): ?>
                <p class="uk-text-muted uk-text-small">No upcoming deadlines</p>
            <?php else: ?>
                <?php foreach ($upcoming_deadlines as $deadline): ?>
                <div class="deadline-item <?= get_deadline_urgency($deadline['days_left']) ?>">
                    <div class="uk-text-bold uk-text-small"><?= e($deadline['title']) ?></div>
                    <div class="uk-text-muted" style="font-size: 11px; margin-top: 4px;">
                        <div><i class="fa-solid fa-calendar fa-fw"></i> <?= date('M d, Y', strtotime($deadline['date'])) ?></div>
                        <div><i class="fa-solid fa-clock fa-fw"></i> <?= e($deadline['time']) ?></div>
                        <div><i class="fa-solid fa-building fa-fw"></i> <?= e($deadline['application']) ?></div>
                    </div>
                    <div class="uk-margin-small-top">
                        <?php if ($deadline['days_left'] < 0): ?>
                            <span class="uk-label uk-label-danger" style="font-size: 10px;">Overdue</span>
                        <?php elseif ($deadline['days_left'] === 0): ?>
                            <span class="uk-label uk-label-danger" style="font-size: 10px;">Due Today</span>
                        <?php elseif ($deadline['days_left'] <= 3): ?>
                            <span class="uk-label uk-label-danger" style="font-size: 10px;"><?= $deadline['days_left'] ?> days left</span>
                        <?php elseif ($deadline['days_left'] <= 7): ?>
                            <span class="uk-label uk-label-warning" style="font-size: 10px;"><?= $deadline['days_left'] ?> days left</span>
                        <?php else: ?>
                            <span class="uk-label" style="font-size: 10px; background: #1e87f0;"><?= $deadline['days_left'] ?> days left</span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- Financial Summary -->
        <div class="uk-card uk-card-default uk-card-body uk-margin-bottom">
            <h4 class="uk-card-title"><i class="fa-solid fa-wallet"></i> Financial Summary</h4>
            <div class="uk-grid uk-grid-small uk-child-width-1-3@s" uk-grid>
                <div>
                    <div class="financial-stat">
                        <div class="financial-stat-value"><?= e($financial_summary['total_paid']) ?></div>
                        <div class="financial-stat-label">Total Paid</div>
                    </div>
                </div>
                <div>
                    <div class="financial-stat">
                        <div class="financial-stat-value" style="color: #faa05a;"><?= e($financial_summary['pending']) ?></div>
                        <div class="financial-stat-label">Pending</div>
                    </div>
                </div>
                <div>
                    <div class="financial-stat">
                        <div class="financial-stat-value" style="color: #666;"><?= e($financial_summary['total']) ?></div>
                        <div class="financial-stat-label">Total</div>
                    </div>
                </div>
            </div>
            <div class="uk-margin-top" style="padding: 12px; background: #f8f9fa; border-radius: 4px;">
                <div class="uk-text-small uk-text-bold">Recent Payment</div>
                <div class="uk-text-muted" style="font-size: 12px; margin-top: 4px;">
                    <?= e($financial_summary['recent_payment']['amount']) ?> to <?= e($financial_summary['recent_payment']['to']) ?>
                </div>
                <div class="uk-text-meta" style="font-size: 11px;"><?= e($financial_summary['recent_payment']['date']) ?></div>
            </div>
            <div class="uk-margin-top">
                <a href="<?= BASE_URL ?>/payments.php"
                   hx-get="<?= BASE_URL ?>/pages/payments.php"
                   hx-target="#main-content"
                   hx-swap="innerHTML"
                   class="uk-button uk-button-primary uk-button-small uk-width-1-1">
                    <i class="fa-solid fa-eye"></i> View All Payments
                </a>
            </div>
        </div>

        <!-- Counselor Contact -->
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title"><i class="fa-solid fa-user-tie"></i> Your Counselor</h4>
            <div class="uk-flex uk-flex-middle uk-margin-bottom">
                <div style="width: 48px; height: 48px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 18px; position: relative;">
                    SJ
                    <div style="position: absolute; bottom: 0; right: 0; width: 14px; height: 14px; background: #32d296; border: 3px solid white; border-radius: 50%;"></div>
                </div>
                <div class="uk-margin-left">
                    <div class="uk-text-bold uk-text-small">Dr. Sarah Johnson</div>
                    <div class="uk-text-muted" style="font-size: 11px;">Senior Counselor</div>
                    <div class="uk-text-success" style="font-size: 11px;"><i class="fa-solid fa-circle fa-xs"></i> Online now</div>
                </div>
            </div>
            <div class="uk-margin-top">
                <a href="<?= BASE_URL ?>/messages.php"
                   hx-get="<?= BASE_URL ?>/pages/messages.php"
                   hx-target="#main-content"
                   hx-swap="innerHTML"
                   class="uk-button uk-button-primary uk-button-small uk-width-1-1">
                    <i class="fa-solid fa-comment"></i> Send Message
                </a>
            </div>
        </div>
    </div>
</div>
