<?php
require_once __DIR__ . '/../includes/bootstrap.php';

// Payment statistics with modern gradient colors
$stats = [
    ['icon' => 'fa-check-circle', 'value' => '$45,000', 'label' => 'Total Paid', 'color' => '#32d296', 'trend' => 'All caught up'],
    ['icon' => 'fa-clock', 'value' => '$15,000', 'label' => 'Pending Payments', 'color' => '#faa05a', 'trend' => '2 installments'],
    ['icon' => 'fa-calendar-alt', 'value' => '$5,000', 'label' => 'Next Due', 'color' => '#667eea', 'trend' => 'Feb 15, 2024'],
    ['icon' => 'fa-receipt', 'value' => '12', 'label' => 'Transactions', 'color' => '#1e87f0', 'trend' => 'This year']
];

$installments = [
    ['name' => 'Tuition - Semester 1', 'total' => '$20,000', 'paid' => '$20,000', 'remaining' => '$0', 'due' => 'Completed', 'status' => 'completed'],
    ['name' => 'Tuition - Semester 2', 'total' => '$20,000', 'paid' => '$15,000', 'remaining' => '$5,000', 'due' => 'Feb 15, 2024', 'status' => 'partial', 'progress' => 75],
    ['name' => 'Housing Deposit', 'total' => '$5,000', 'paid' => '$5,000', 'remaining' => '$0', 'due' => 'Completed', 'status' => 'completed'],
    ['name' => 'Meal Plan', 'total' => '$3,000', 'paid' => '$0', 'remaining' => '$3,000', 'due' => 'Mar 1, 2024', 'status' => 'pending', 'progress' => 0]
];

$transactions = [
    ['id' => 'TXN-10234', 'description' => 'Tuition Payment - Semester 2', 'amount' => '$10,000', 'date' => '2024-01-30', 'method' => 'Bank Transfer', 'status' => 'completed'],
    ['id' => 'TXN-10233', 'description' => 'Tuition Payment - Semester 2', 'amount' => '$5,000', 'date' => '2024-01-15', 'method' => 'Credit Card', 'status' => 'completed'],
    ['id' => 'TXN-10232', 'description' => 'Housing Deposit', 'amount' => '$5,000', 'date' => '2024-01-10', 'method' => 'Credit Card', 'status' => 'completed'],
    ['id' => 'TXN-10231', 'description' => 'Application Fee - Stanford', 'amount' => '$150', 'date' => '2024-01-05', 'method' => 'Credit Card', 'status' => 'completed'],
    ['id' => 'TXN-10230', 'description' => 'Tuition Payment - Semester 1', 'amount' => '$20,000', 'date' => '2023-12-20', 'method' => 'Bank Transfer', 'status' => 'completed']
];

$refunds = [
    ['id' => 'REF-001', 'original' => 'TXN-10228', 'amount' => '$500', 'reason' => 'Overpayment', 'date' => '2024-01-25', 'status' => 'completed'],
    ['id' => 'REF-002', 'original' => 'TXN-10215', 'amount' => '$175', 'reason' => 'Application Withdrawal', 'date' => '2023-12-15', 'status' => 'completed']
];

$status_colors = ['completed' => 'success', 'pending' => 'warning', 'partial' => 'primary', 'failed' => 'danger'];

function get_color_darker($hex) {
    $hex = str_replace('#', '', $hex);
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    $r = max(0, $r - 30);
    $g = max(0, $g - 30);
    $b = max(0, $b - 30);
    return sprintf("#%02x%02x%02x", $r, $g, $b);
}
?>

<style>
/* Modern Gradient Stat Cards */
.stat-card-modern {
    background: linear-gradient(135deg, var(--stat-color) 0%, var(--stat-color-dark) 100%);
    border-radius: 12px;
    padding: 24px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.stat-card-modern:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

.stat-card-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 200px;
    height: 200px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

.stat-card-icon {
    font-size: 36px;
    opacity: 0.9;
    margin-bottom: 12px;
}

.stat-card-value {
    font-size: 32px;
    font-weight: bold;
    margin-bottom: 4px;
}

.stat-card-label {
    font-size: 14px;
    opacity: 0.9;
    margin-bottom: 8px;
}

.stat-card-trend {
    font-size: 12px;
    opacity: 0.8;
    display: flex;
    align-items: center;
    gap: 4px;
}

/* Payment Grid Styling */
.payment-grid-header {
    padding: 0.75rem 0.5rem;
    border-bottom: 2px solid #e5e5e5;
    margin-bottom: 0.5rem;
}

.payment-item {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    border: 1px solid #e5e5e5;
    position: relative;
    z-index: 1;
}

.payment-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    z-index: 10;
}

.payment-item:has(.uk-open) {
    z-index: 10;
}

.payment-item .uk-card-body {
    padding: 0.75rem 1rem;
}

.payment-item .uk-dropdown {
    z-index: 1020 !important;
}

/* Progress Bar for Installments */
.payment-progress {
    height: 6px;
    background: #e5e5e5;
    border-radius: 3px;
    overflow: hidden;
    margin-top: 8px;
}

.payment-progress-bar {
    height: 100%;
    background: linear-gradient(90deg, #32d296 0%, #1fb881 100%);
    transition: width 0.3s ease;
}

.payment-progress-bar.partial {
    background: linear-gradient(90deg, #667eea 0%, #5568d3 100%);
}

/* Payment Method Cards */
.payment-method-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    padding: 20px;
    color: white;
    margin-bottom: 12px;
    position: relative;
    overflow: hidden;
}

.payment-method-card::before {
    content: '';
    position: absolute;
    top: -30px;
    right: -30px;
    width: 100px;
    height: 100px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

/* Mobile Responsive */
@media (max-width: 959px) {
    .stat-card-modern {
        padding: 20px;
    }

    .stat-card-value {
        font-size: 28px;
    }

    .stat-card-icon {
        font-size: 32px;
    }

    .payment-item {
        margin-bottom: 0.75rem;
    }

    .payment-item .uk-card-body {
        padding: 0.875rem;
    }
}

.mobile-stack {
    flex-wrap: wrap;
    gap: 12px;
}

.mobile-mb {
    margin-bottom: 12px;
}

@media (max-width: 640px) {
    .mobile-stack > * {
        width: 100%;
    }
}
</style>

<!-- Modern Gradient Stat Cards -->
<div class="uk-grid-small uk-child-width-1-2@s uk-child-width-1-4@m uk-margin-bottom" uk-grid>
    <?php foreach ($stats as $stat): ?>
    <div>
        <div class="stat-card-modern" style="--stat-color: <?= $stat['color'] ?>; --stat-color-dark: <?= get_color_darker($stat['color']) ?>">
            <div class="stat-card-icon">
                <i class="fa-slab fa-solid <?= $stat['icon'] ?>"></i>
            </div>
            <div class="stat-card-value"><?= e($stat['value']) ?></div>
            <div class="stat-card-label"><?= e($stat['label']) ?></div>
            <div class="stat-card-trend">
                <span><?= e($stat['trend']) ?></span>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- Sub-navigation tabs -->
<ul class="uk-subnav uk-subnav-pill" uk-switcher="animation: uk-animation-fade">
    <li class="uk-active"><a href="#"><i class="fa-slab fa-solid fa-home fa-sm"></i> Overview</a></li>
    <li><a href="#"><i class="fa-slab fa-solid fa-calendar-check fa-sm"></i> Installments</a></li>
    <li><a href="#"><i class="fa-slab fa-solid fa-list fa-sm"></i> Transactions</a></li>
    <li><a href="#"><i class="fa-slab fa-solid fa-undo fa-sm"></i> Refunds</a></li>
</ul>

<ul class="uk-switcher uk-margin">
    <!-- Overview Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
            <h3 class="uk-margin-remove mobile-mb"><i class="fa-slab fa-solid fa-chart-line"></i> Payment Overview</h3>
            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #make-payment-modal">
                <i class="fa-slab fa-solid fa-credit-card"></i> Make Payment
            </button>
        </div>

        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-2-3@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title"><i class="fa-slab fa-solid fa-bell"></i> Upcoming Payments</h4>

                    <?php
                    $upcoming = array_filter($installments, fn($i) => $i['status'] !== 'completed');
                    if (empty($upcoming)):
                    ?>
                        <div class="uk-text-center uk-padding">
                            <i class="fa-slab fa-solid fa-check-circle fa-3x uk-text-success"></i>
                            <p class="uk-text-muted uk-margin-top">All payments are up to date!</p>
                        </div>
                    <?php else: ?>
                        <!-- Grid Header (Desktop Only) -->
                        <div class="payment-grid-header uk-visible@m">
                            <div class="uk-grid uk-grid-small uk-text-small uk-text-bold uk-text-muted" uk-grid>
                                <div class="uk-width-expand">Description</div>
                                <div class="uk-width-small">Amount</div>
                                <div class="uk-width-small">Due Date</div>
                                <div class="uk-width-auto" style="width: 100px;">Action</div>
                            </div>
                        </div>

                        <!-- Grid Body -->
                        <div class="payment-grid">
                            <?php foreach ($upcoming as $inst): ?>
                            <div class="payment-item uk-card uk-card-default uk-card-small uk-margin-small-top">
                                <div class="uk-card-body uk-padding-small">
                                    <!-- Desktop Layout -->
                                    <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                                        <div class="uk-width-expand uk-text-bold"><?= e($inst['name']) ?></div>
                                        <div class="uk-width-small uk-text-bold uk-text-primary"><?= e($inst['remaining']) ?></div>
                                        <div class="uk-width-small uk-text-small"><?= e($inst['due']) ?></div>
                                        <div class="uk-width-auto" style="width: 100px;">
                                            <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #make-payment-modal">Pay Now</button>
                                        </div>
                                    </div>

                                    <!-- Mobile Layout -->
                                    <div class="uk-hidden@m">
                                        <div class="uk-text-bold uk-margin-small-bottom"><?= e($inst['name']) ?></div>
                                        <div class="uk-grid uk-grid-small uk-child-width-1-2" uk-grid>
                                            <div>
                                                <div class="uk-text-meta uk-text-small">Amount</div>
                                                <div class="uk-text-bold uk-text-primary"><?= e($inst['remaining']) ?></div>
                                            </div>
                                            <div>
                                                <div class="uk-text-meta uk-text-small">Due Date</div>
                                                <div><?= e($inst['due']) ?></div>
                                            </div>
                                        </div>
                                        <button class="uk-button uk-button-primary uk-button-small uk-margin-small-top uk-width-1-1" uk-toggle="target: #make-payment-modal">Pay Now</button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="uk-width-1-3@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <h4 class="uk-card-title"><i class="fa-slab fa-solid fa-wallet"></i> Payment Methods</h4>

                    <div class="payment-method-card">
                        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                            <div>
                                <i class="fa-slab fa-solid fa-credit-card fa-2x"></i>
                            </div>
                            <span class="uk-label" style="background: rgba(255,255,255,0.3);">Default</span>
                        </div>
                        <div class="uk-text-bold uk-margin-small-top" style="font-size: 18px; letter-spacing: 2px;">•••• •••• •••• 4242</div>
                        <div class="uk-text-small" style="opacity: 0.9; margin-top: 8px;">Visa - Expires 12/25</div>
                    </div>

                    <button class="uk-button uk-button-default uk-button-small uk-width-1-1" uk-toggle="target: #add-payment-method-modal">
                        <i class="fa-slab fa-solid fa-plus"></i> Add Payment Method
                    </button>

                    <hr>

                    <div class="uk-text-small uk-text-muted">
                        <div class="uk-flex uk-flex-between uk-margin-small">
                            <span><i class="fa-slab fa-solid fa-shield-alt"></i> Secure payments</span>
                            <span class="uk-text-success"><i class="fa-slab fa-solid fa-check-circle"></i></span>
                        </div>
                        <div class="uk-flex uk-flex-between">
                            <span><i class="fa-slab fa-solid fa-lock"></i> 256-bit encryption</span>
                            <span class="uk-text-success"><i class="fa-slab fa-solid fa-check-circle"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </li>

    <!-- Installments Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
            <h3 class="uk-margin-remove mobile-mb"><i class="fa-slab fa-solid fa-calendar-check"></i> Payment Installments</h3>
            <button class="uk-button uk-button-default uk-button-small">
                <i class="fa-slab fa-solid fa-download"></i> <span class="uk-visible@s">Export Schedule</span>
            </button>
        </div>

        <div class="uk-card uk-card-default uk-card-body">
            <!-- Grid Header (Desktop Only) -->
            <div class="payment-grid-header uk-visible@m">
                <div class="uk-grid uk-grid-small uk-text-small uk-text-bold uk-text-muted" uk-grid>
                    <div class="uk-width-expand">Description</div>
                    <div class="uk-width-small">Total</div>
                    <div class="uk-width-small">Paid</div>
                    <div class="uk-width-small">Remaining</div>
                    <div class="uk-width-small">Due Date</div>
                    <div class="uk-width-auto" style="width: 100px;">Status</div>
                </div>
            </div>

            <!-- Grid Body -->
            <div class="payment-grid">
                <?php foreach ($installments as $inst): ?>
                <div class="payment-item uk-card uk-card-default uk-card-small uk-margin-small-top">
                    <div class="uk-card-body uk-padding-small">
                        <!-- Desktop Layout -->
                        <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                            <div class="uk-width-expand">
                                <div class="uk-text-bold"><?= e($inst['name']) ?></div>
                                <?php if (isset($inst['progress'])): ?>
                                <div class="payment-progress">
                                    <div class="payment-progress-bar <?= $inst['status'] === 'partial' ? 'partial' : '' ?>" style="width: <?= $inst['progress'] ?>%"></div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="uk-width-small"><?= e($inst['total']) ?></div>
                            <div class="uk-width-small uk-text-success"><i class="fa-slab fa-solid fa-check-circle fa-xs"></i> <?= e($inst['paid']) ?></div>
                            <div class="uk-width-small <?= $inst['remaining'] !== '$0' ? 'uk-text-warning' : 'uk-text-muted' ?>"><?= e($inst['remaining']) ?></div>
                            <div class="uk-width-small uk-text-small"><?= e($inst['due']) ?></div>
                            <div class="uk-width-auto" style="width: 100px;">
                                <span class="uk-label uk-label-<?= $status_colors[$inst['status']] ?>">
                                    <?php if ($inst['status'] === 'completed'): ?>
                                        <i class="fa-slab fa-solid fa-check fa-xs"></i>
                                    <?php elseif ($inst['status'] === 'partial'): ?>
                                        <i class="fa-slab fa-solid fa-clock fa-xs"></i>
                                    <?php else: ?>
                                        <i class="fa-slab fa-solid fa-exclamation fa-xs"></i>
                                    <?php endif; ?>
                                    <?= e($inst['status']) ?>
                                </span>
                            </div>
                        </div>

                        <!-- Mobile Layout -->
                        <div class="uk-hidden@m">
                            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                                <div class="uk-text-bold uk-text-small"><?= e($inst['name']) ?></div>
                                <span class="uk-label uk-label-<?= $status_colors[$inst['status']] ?>" style="font-size: 0.65rem;">
                                    <?php if ($inst['status'] === 'completed'): ?>
                                        <i class="fa-slab fa-solid fa-check fa-xs"></i>
                                    <?php elseif ($inst['status'] === 'partial'): ?>
                                        <i class="fa-slab fa-solid fa-clock fa-xs"></i>
                                    <?php else: ?>
                                        <i class="fa-slab fa-solid fa-exclamation fa-xs"></i>
                                    <?php endif; ?>
                                    <?= e($inst['status']) ?>
                                </span>
                            </div>
                            <?php if (isset($inst['progress'])): ?>
                            <div class="payment-progress uk-margin-small-bottom">
                                <div class="payment-progress-bar <?= $inst['status'] === 'partial' ? 'partial' : '' ?>" style="width: <?= $inst['progress'] ?>%"></div>
                            </div>
                            <?php endif; ?>
                            <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-text-small" uk-grid>
                                <div>
                                    <div class="uk-text-meta">Total</div>
                                    <div><?= e($inst['total']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Paid</div>
                                    <div class="uk-text-success"><i class="fa-slab fa-solid fa-check-circle fa-xs"></i> <?= e($inst['paid']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Remaining</div>
                                    <div class="<?= $inst['remaining'] !== '$0' ? 'uk-text-warning' : 'uk-text-muted' ?>"><?= e($inst['remaining']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Due Date</div>
                                    <div><?= e($inst['due']) ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </li>

    <!-- Transactions Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
            <h3 class="uk-margin-remove mobile-mb"><i class="fa-slab fa-solid fa-list"></i> Transaction History</h3>
            <div class="uk-flex uk-flex-middle">
                <input class="uk-input uk-form-small uk-margin-small-right uk-visible@s" type="search" placeholder="Search..." style="width: 200px;" id="transaction-search">
                <button class="uk-button uk-button-default uk-button-small">
                    <i class="fa-slab fa-solid fa-download"></i> <span class="uk-visible@s">Export</span>
                </button>
            </div>
        </div>

        <!-- Mobile Search -->
        <div class="uk-margin-bottom uk-hidden@s">
            <input class="uk-input uk-form-small" type="search" placeholder="Search transactions..." id="transaction-search-mobile">
        </div>

        <div class="uk-card uk-card-default uk-card-body">
            <!-- Grid Header (Desktop Only) -->
            <div class="payment-grid-header uk-visible@m">
                <div class="uk-grid uk-grid-small uk-text-small uk-text-bold uk-text-muted" uk-grid>
                    <div class="uk-width-small">ID</div>
                    <div class="uk-width-expand">Description</div>
                    <div class="uk-width-small">Amount</div>
                    <div class="uk-width-small">Date</div>
                    <div class="uk-width-small">Method</div>
                    <div class="uk-width-auto" style="width: 80px;">Status</div>
                    <div class="uk-width-auto" style="width: 40px;"></div>
                </div>
            </div>

            <!-- Grid Body -->
            <div class="payment-grid" id="transactions-list">
                <?php foreach ($transactions as $txn): ?>
                <div class="payment-item uk-card uk-card-default uk-card-small uk-margin-small-top transaction-row">
                    <div class="uk-card-body uk-padding-small">
                        <!-- Desktop Layout -->
                        <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                            <div class="uk-width-small"><code class="uk-text-small"><?= e($txn['id']) ?></code></div>
                            <div class="uk-width-expand">
                                <i class="fa-slab fa-solid fa-<?= $txn['method'] === 'Bank Transfer' ? 'university' : 'credit-card' ?> fa-sm uk-text-muted uk-margin-small-right"></i>
                                <?= e($txn['description']) ?>
                            </div>
                            <div class="uk-width-small uk-text-bold"><?= e($txn['amount']) ?></div>
                            <div class="uk-width-small uk-text-small"><?= e($txn['date']) ?></div>
                            <div class="uk-width-small uk-text-small"><?= e($txn['method']) ?></div>
                            <div class="uk-width-auto" style="width: 80px;">
                                <span class="uk-label uk-label-<?= $status_colors[$txn['status']] ?>">
                                    <i class="fa-slab fa-solid fa-check fa-xs"></i> <?= e($txn['status']) ?>
                                </span>
                            </div>
                            <div class="uk-width-auto uk-text-right" style="width: 40px;">
                                <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                                <div uk-dropdown="mode: click; pos: bottom-right">
                                    <ul class="uk-nav uk-dropdown-nav">
                                        <li class="uk-nav-header">Actions</li>
                                        <li><a href="#" uk-toggle="target: #view-transaction-modal"><i class="fa-slab fa-solid fa-circle-info fa-fw"></i> View Details</a></li>
                                        <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download Receipt</a></li>
                                        <li><a href="#"><i class="fa-slab fa-solid fa-envelope fa-fw"></i> Email Receipt</a></li>
                                        <li class="uk-nav-divider"></li>
                                        <li><a href="#" uk-toggle="target: #report-issue-modal"><i class="fa-slab fa-solid fa-exclamation-triangle fa-fw"></i> Report Issue</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Mobile Layout -->
                        <div class="uk-hidden@m">
                            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                                <div class="uk-width-expand" style="min-width: 0;">
                                    <div class="uk-text-bold uk-text-small">
                                        <i class="fa-slab fa-solid fa-<?= $txn['method'] === 'Bank Transfer' ? 'university' : 'credit-card' ?> fa-sm uk-text-muted uk-margin-small-right"></i>
                                        <?= e($txn['description']) ?>
                                    </div>
                                    <div class="uk-text-meta" style="font-size: 0.7rem;"><code><?= e($txn['id']) ?></code></div>
                                </div>
                                <div class="uk-flex-none">
                                    <a href="#"><i class="fa-slab fa-solid fa-ellipsis-vertical"></i></a>
                                    <div uk-dropdown="mode: click; pos: bottom-right">
                                        <ul class="uk-nav uk-dropdown-nav">
                                            <li class="uk-nav-header">Actions</li>
                                            <li><a href="#" uk-toggle="target: #view-transaction-modal"><i class="fa-slab fa-solid fa-circle-info fa-fw"></i> View Details</a></li>
                                            <li><a href="#"><i class="fa-slab fa-solid fa-download fa-fw"></i> Download Receipt</a></li>
                                            <li><a href="#"><i class="fa-slab fa-solid fa-envelope fa-fw"></i> Email Receipt</a></li>
                                            <li class="uk-nav-divider"></li>
                                            <li><a href="#" uk-toggle="target: #report-issue-modal"><i class="fa-slab fa-solid fa-exclamation-triangle fa-fw"></i> Report Issue</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-text-small" uk-grid>
                                <div>
                                    <div class="uk-text-meta">Amount</div>
                                    <div class="uk-text-bold"><?= e($txn['amount']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Date</div>
                                    <div><?= e($txn['date']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Method</div>
                                    <div><?= e($txn['method']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Status</div>
                                    <span class="uk-label uk-label-<?= $status_colors[$txn['status']] ?>" style="font-size: 0.65rem;">
                                        <i class="fa-slab fa-solid fa-check fa-xs"></i> <?= e($txn['status']) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </li>

    <!-- Refunds Tab -->
    <li>
        <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom mobile-stack">
            <h3 class="uk-margin-remove mobile-mb"><i class="fa-slab fa-solid fa-undo"></i> Refund History</h3>
            <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #request-refund-modal">
                <i class="fa-slab fa-solid fa-plus"></i> <span class="uk-visible@s">Request Refund</span>
            </button>
        </div>

        <?php if (empty($refunds)): ?>
        <div class="uk-card uk-card-default uk-card-body uk-text-center uk-padding">
            <i class="fa-slab fa-solid fa-check-circle fa-3x uk-text-success"></i>
            <p class="uk-text-muted uk-margin-top">No refunds to display</p>
        </div>
        <?php else: ?>
        <div class="uk-card uk-card-default uk-card-body">
            <!-- Grid Header (Desktop Only) -->
            <div class="payment-grid-header uk-visible@m">
                <div class="uk-grid uk-grid-small uk-text-small uk-text-bold uk-text-muted" uk-grid>
                    <div class="uk-width-small">Refund ID</div>
                    <div class="uk-width-small">Original Txn</div>
                    <div class="uk-width-small">Amount</div>
                    <div class="uk-width-expand">Reason</div>
                    <div class="uk-width-small">Date</div>
                    <div class="uk-width-auto" style="width: 80px;">Status</div>
                </div>
            </div>

            <!-- Grid Body -->
            <div class="payment-grid">
                <?php foreach ($refunds as $refund): ?>
                <div class="payment-item uk-card uk-card-default uk-card-small uk-margin-small-top">
                    <div class="uk-card-body uk-padding-small">
                        <!-- Desktop Layout -->
                        <div class="uk-grid uk-grid-small uk-flex-middle uk-visible@m" uk-grid>
                            <div class="uk-width-small"><code class="uk-text-small"><?= e($refund['id']) ?></code></div>
                            <div class="uk-width-small"><code class="uk-text-small"><?= e($refund['original']) ?></code></div>
                            <div class="uk-width-small uk-text-bold" style="color: #f0506e;"><?= e($refund['amount']) ?></div>
                            <div class="uk-width-expand">
                                <i class="fa-slab fa-solid fa-undo fa-sm uk-text-muted uk-margin-small-right"></i>
                                <?= e($refund['reason']) ?>
                            </div>
                            <div class="uk-width-small uk-text-small"><?= e($refund['date']) ?></div>
                            <div class="uk-width-auto" style="width: 80px;">
                                <span class="uk-label uk-label-<?= $status_colors[$refund['status']] ?>">
                                    <i class="fa-slab fa-solid fa-check fa-xs"></i> <?= e($refund['status']) ?>
                                </span>
                            </div>
                        </div>

                        <!-- Mobile Layout -->
                        <div class="uk-hidden@m">
                            <div class="uk-flex uk-flex-between uk-flex-middle uk-margin-small-bottom">
                                <div>
                                    <div class="uk-text-meta" style="font-size: 0.7rem;"><code><?= e($refund['id']) ?></code></div>
                                    <div class="uk-text-small">
                                        <i class="fa-slab fa-solid fa-undo fa-sm uk-text-muted uk-margin-small-right"></i>
                                        <?= e($refund['reason']) ?>
                                    </div>
                                </div>
                                <span class="uk-label uk-label-<?= $status_colors[$refund['status']] ?>" style="font-size: 0.65rem;">
                                    <i class="fa-slab fa-solid fa-check fa-xs"></i> <?= e($refund['status']) ?>
                                </span>
                            </div>
                            <div class="uk-grid uk-grid-small uk-child-width-1-2 uk-text-small" uk-grid>
                                <div>
                                    <div class="uk-text-meta">Amount</div>
                                    <div class="uk-text-bold" style="color: #f0506e;"><?= e($refund['amount']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Date</div>
                                    <div><?= e($refund['date']) ?></div>
                                </div>
                                <div>
                                    <div class="uk-text-meta">Original Txn</div>
                                    <div><code style="font-size: 0.7rem;"><?= e($refund['original']) ?></code></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </li>
</ul>

<script>
// Search functionality for transactions
function setupSearch(inputId, targetSelector) {
    const input = document.getElementById(inputId);
    if (!input) return;

    input.addEventListener('keyup', function() {
        const query = this.value.toLowerCase();
        const items = document.querySelectorAll(targetSelector);

        items.forEach(item => {
            const text = item.textContent.toLowerCase();
            if (text.indexOf(query) >= 0) {
                item.classList.remove('uk-hidden');
            } else {
                item.classList.add('uk-hidden');
            }
        });
    });
}

// Initialize search for both desktop and mobile
setupSearch('transaction-search', '.transaction-row');
setupSearch('transaction-search-mobile', '.transaction-row');
</script>

<!-- Make Payment Modal -->
<div id="make-payment-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-credit-card"></i> Make Payment</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Payment For</label>
                    <select class="uk-select">
                        <option>Tuition - Semester 2 ($5,000 remaining)</option>
                        <option>Meal Plan ($3,000 remaining)</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Amount</label>
                    <div class="uk-inline uk-width-1-1">
                        <span class="uk-form-icon">$</span>
                        <input class="uk-input" type="number" placeholder="0.00" value="5000">
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Payment Method</label>
                    <div class="uk-margin-small">
                        <label>
                            <input class="uk-radio" type="radio" name="payment-method" checked>
                            <span class="uk-margin-small-left"><i class="fa-slab fa-solid fa-credit-card uk-text-muted"></i> Credit Card •••• 4242</span>
                        </label>
                    </div>
                    <div class="uk-margin-small">
                        <label>
                            <input class="uk-radio" type="radio" name="payment-method">
                            <span class="uk-margin-small-left"><i class="fa-slab fa-solid fa-university uk-text-muted"></i> Bank Transfer</span>
                        </label>
                    </div>
                    <div class="uk-margin-small">
                        <label>
                            <input class="uk-radio" type="radio" name="payment-method">
                            <span class="uk-margin-small-left"><i class="fa-slab fa-solid fa-plus uk-text-muted"></i> New Payment Method</span>
                        </label>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button"><i class="fa-slab fa-solid fa-check"></i> Pay $5,000</button>
        </div>
    </div>
</div>

<!-- Add Payment Method Modal -->
<div id="add-payment-method-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-plus-circle"></i> Add Payment Method</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Payment Type *</label>
                    <select class="uk-select" required>
                        <option value="">Select type...</option>
                        <option>Credit Card</option>
                        <option>Debit Card</option>
                        <option>Bank Account</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Card Number *</label>
                    <input class="uk-input" type="text" placeholder="1234 5678 9012 3456" required>
                </div>
                <div class="uk-grid-small" uk-grid>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">Expiry Date *</label>
                        <input class="uk-input" type="text" placeholder="MM/YY" required>
                    </div>
                    <div class="uk-width-1-2">
                        <label class="uk-form-label">CVV *</label>
                        <input class="uk-input" type="text" placeholder="123" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Cardholder Name *</label>
                    <input class="uk-input" type="text" placeholder="Name on card" required>
                </div>
                <div class="uk-margin">
                    <label><input class="uk-checkbox" type="checkbox"> Set as default payment method</label>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button"><i class="fa-slab fa-solid fa-check"></i> Add Payment Method</button>
        </div>
    </div>
</div>

<!-- Request Refund Modal -->
<div id="request-refund-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-undo"></i> Request Refund</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Transaction *</label>
                    <select class="uk-select" required>
                        <option value="">Select transaction...</option>
                        <option>TXN-10234 - Tuition Payment ($10,000)</option>
                        <option>TXN-10233 - Tuition Payment ($5,000)</option>
                        <option>TXN-10232 - Housing Deposit ($5,000)</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Refund Amount *</label>
                    <div class="uk-inline uk-width-1-1">
                        <span class="uk-form-icon">$</span>
                        <input class="uk-input" type="number" placeholder="0.00" required>
                    </div>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Reason *</label>
                    <select class="uk-select" required>
                        <option value="">Select reason...</option>
                        <option>Overpayment</option>
                        <option>Course Withdrawal</option>
                        <option>Application Withdrawal</option>
                        <option>Duplicate Payment</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Additional Details</label>
                    <textarea class="uk-textarea" rows="3" placeholder="Provide any additional information..."></textarea>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button"><i class="fa-slab fa-solid fa-paper-plane"></i> Submit Request</button>
        </div>
    </div>
</div>

<!-- View Transaction Modal -->
<div id="view-transaction-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-receipt"></i> Transaction Details</h2>
        </div>
        <div class="uk-modal-body">
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Transaction ID</dt>
                <dd><code>TXN-10234</code></dd>
                <dt>Description</dt>
                <dd>Tuition Payment - Semester 2</dd>
                <dt>Amount</dt>
                <dd class="uk-text-bold">$10,000</dd>
                <dt>Date</dt>
                <dd>January 30, 2024</dd>
                <dt>Payment Method</dt>
                <dd><i class="fa-slab fa-solid fa-university uk-text-muted"></i> Bank Transfer</dd>
                <dt>Status</dt>
                <dd><span class="uk-label uk-label-success"><i class="fa-slab fa-solid fa-check"></i> Completed</span></dd>
                <dt>Reference Number</dt>
                <dd><code>REF-20240130-001</code></dd>
            </dl>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
            <button class="uk-button uk-button-primary" type="button"><i class="fa-slab fa-solid fa-download"></i> Download Receipt</button>
        </div>
    </div>
</div>

<!-- Report Issue Modal -->
<div id="report-issue-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title"><i class="fa-slab fa-solid fa-exclamation-triangle"></i> Report Payment Issue</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Issue Type *</label>
                    <select class="uk-select" required>
                        <option value="">Select issue type...</option>
                        <option>Incorrect Amount</option>
                        <option>Payment Not Reflected</option>
                        <option>Duplicate Charge</option>
                        <option>Unauthorized Transaction</option>
                        <option>Other</option>
                    </select>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Description *</label>
                    <textarea class="uk-textarea" rows="4" placeholder="Describe the issue in detail..." required></textarea>
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Supporting Documents (Optional)</label>
                    <div uk-form-custom="target: true">
                        <input type="file" multiple>
                        <input class="uk-input uk-form-width-large" type="text" placeholder="Select files..." disabled>
                    </div>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button"><i class="fa-slab fa-solid fa-paper-plane"></i> Submit Report</button>
        </div>
    </div>
</div>
