<?php
require_once __DIR__ . '/../includes/bootstrap.php';

$user = $GLOBALS['current_user'];
?>

<div class="uk-flex uk-flex-between uk-flex-middle uk-margin-bottom">
    <h3 class="uk-margin-remove">My Profile</h3>
    <button class="uk-button uk-button-primary uk-button-small" uk-toggle="target: #edit-profile-modal">
        <span uk-icon="icon: pencil; ratio: 0.8"></span> Edit Profile
    </button>
</div>

<div class="uk-grid-small" uk-grid>
    <div class="uk-width-1-3@m">
        <div class="uk-card uk-card-default uk-card-body uk-text-center">
            <?= get_avatar($user['name'], 120) ?>
            <h4 class="uk-margin-small-top uk-margin-remove-bottom"><?= e($user['name']) ?></h4>
            <p class="uk-text-muted uk-margin-remove">Student</p>
            <div class="uk-margin-top">
                <button class="uk-button uk-button-default uk-button-small" uk-toggle="target: #change-avatar-modal">
                    <span uk-icon="icon: image; ratio: 0.8"></span> Change Avatar
                </button>
            </div>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h5 class="uk-card-title">Application Summary</h5>
            <dl class="uk-description-list">
                <dt>Total Applications</dt>
                <dd>3</dd>
                <dt>Accepted</dt>
                <dd><span class="uk-text-success">1</span></dd>
                <dt>In Progress</dt>
                <dd><span class="uk-text-warning">2</span></dd>
                <dt>Assigned Counselor</dt>
                <dd>Sarah Johnson</dd>
            </dl>
        </div>
    </div>

    <div class="uk-width-2-3@m">
        <div class="uk-card uk-card-default uk-card-body">
            <h4 class="uk-card-title">Personal Information</h4>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Full Name</dt>
                <dd><?= e($user['name']) ?></dd>
                <dt>Email Address</dt>
                <dd><?= e($user['email']) ?></dd>
                <dt>Phone Number</dt>
                <dd>+1 (555) 345-6789</dd>
                <dt>Date of Birth</dt>
                <dd>March 15, 2000</dd>
                <dt>Nationality</dt>
                <dd>United States</dd>
                <dt>Current Education</dt>
                <dd>Bachelor's in Computer Science</dd>
            </dl>
        </div>

        <div class="uk-card uk-card-default uk-card-body uk-margin-top">
            <h4 class="uk-card-title">Emergency Contact</h4>
            <dl class="uk-description-list uk-description-list-divider">
                <dt>Name</dt>
                <dd>Robert Doe</dd>
                <dt>Relationship</dt>
                <dd>Father</dd>
                <dt>Phone</dt>
                <dd>+1 (555) 456-7890</dd>
                <dt>Email</dt>
                <dd>robert.doe@email.com</dd>
            </dl>
        </div>
    </div>
</div>

<!-- Change Avatar Modal -->
<div id="change-avatar-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Change Avatar</h2>
        </div>
        <div class="uk-modal-body">
            <div class="uk-text-center uk-margin-bottom">
                <?= get_avatar($user['name'], 100) ?>
            </div>
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Upload New Avatar</label>
                    <div uk-form-custom="target: true">
                        <input type="file" accept="image/*">
                        <input class="uk-input uk-form-width-large" type="text" placeholder="Select image..." disabled>
                    </div>
                    <p class="uk-text-small uk-text-muted uk-margin-small-top">Max file size: 2MB. Supported: JPG, PNG, GIF</p>
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Upload</button>
        </div>
    </div>
</div>

<!-- Edit Profile Modal -->
<div id="edit-profile-modal" uk-modal>
    <div class="uk-modal-dialog">
        <button class="uk-modal-close-default" type="button" uk-close></button>
        <div class="uk-modal-header">
            <h2 class="uk-modal-title">Edit Profile</h2>
        </div>
        <div class="uk-modal-body">
            <form class="uk-form-stacked">
                <div class="uk-margin">
                    <label class="uk-form-label">Full Name</label>
                    <input class="uk-input" type="text" value="<?= e($user['name']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Email Address</label>
                    <input class="uk-input" type="email" value="<?= e($user['email']) ?>">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Phone Number</label>
                    <input class="uk-input" type="tel" value="+1 (555) 345-6789">
                </div>
                <div class="uk-margin">
                    <label class="uk-form-label">Current Education</label>
                    <input class="uk-input" type="text" value="Bachelor's in Computer Science">
                </div>
            </form>
        </div>
        <div class="uk-modal-footer uk-text-right">
            <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
            <button class="uk-button uk-button-primary" type="button">Save Changes</button>
        </div>
    </div>
</div>
